/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="SampledData")
public class SampledData
extends DataType
implements ICompositeType {
    @Child(name="origin", type={Quantity.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Zero value and units", formalDefinition="The base quantity that a measured value of zero represents. In addition, this provides the units of the entire measurement series.")
    protected Quantity origin;
    @Child(name="interval", type={DecimalType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of intervalUnits between samples", formalDefinition="Amount of intervalUnits between samples, e.g. milliseconds for time-based sampling.")
    protected DecimalType interval;
    @Child(name="intervalUnit", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The measurement unit of the interval between samples", formalDefinition="The measurement unit in which the sample interval is expressed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/ucum-units")
    protected CodeType intervalUnit;
    @Child(name="factor", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Multiply data by this before adding to origin", formalDefinition="A correction factor that is applied to the sampled data points before they are added to the origin.")
    protected DecimalType factor;
    @Child(name="lowerLimit", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Lower limit of detection", formalDefinition="The lower limit of detection of the measured points. This is needed if any of the data points have the value \"L\" (lower than detection limit).")
    protected DecimalType lowerLimit;
    @Child(name="upperLimit", type={DecimalType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Upper limit of detection", formalDefinition="The upper limit of detection of the measured points. This is needed if any of the data points have the value \"U\" (higher than detection limit).")
    protected DecimalType upperLimit;
    @Child(name="dimensions", type={PositiveIntType.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of sample points at each time point", formalDefinition="The number of sample points at each time point. If this value is greater than one, then the dimensions will be interlaced - all the sample points for a point in time will be recorded at once.")
    protected PositiveIntType dimensions;
    @Child(name="codeMap", type={CanonicalType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Defines the codes used in the data", formalDefinition="Reference to ConceptMap that defines the codes used in the data.")
    protected CanonicalType codeMap;
    @Child(name="offsets", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Offsets, typically in time, at which data values were taken", formalDefinition="A series of data points which are decimal values separated by a single space (character u20).  The units in which the offsets are expressed are found in intervalUnit.  The absolute point at which the measurements begin SHALL be conveyed outside the scope of this datatype, e.g. Observation.effectiveDateTime for a timing offset.")
    protected StringType offsets;
    @Child(name="data", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Decimal values with spaces, or \"E\" | \"U\" | \"L\", or another code", formalDefinition="A series of data points which are decimal values or codes separated by a single space (character u20). The special codes \"E\" (error), \"L\" (below detection limit) and \"U\" (above detection limit) are also defined for used in place of decimal values.")
    protected StringType data;
    private static final long serialVersionUID = 1859118926L;

    public SampledData() {
    }

    public SampledData(Quantity origin, String intervalUnit, int dimensions) {
        this.setOrigin(origin);
        this.setIntervalUnit(intervalUnit);
        this.setDimensions(dimensions);
    }

    public Quantity getOrigin() {
        if (this.origin == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.origin");
            }
            if (Configuration.doAutoCreate()) {
                this.origin = new Quantity();
            }
        }
        return this.origin;
    }

    public boolean hasOrigin() {
        return this.origin != null && !this.origin.isEmpty();
    }

    public SampledData setOrigin(Quantity value) {
        this.origin = value;
        return this;
    }

    public DecimalType getIntervalElement() {
        if (this.interval == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.interval");
            }
            if (Configuration.doAutoCreate()) {
                this.interval = new DecimalType();
            }
        }
        return this.interval;
    }

    public boolean hasIntervalElement() {
        return this.interval != null && !this.interval.isEmpty();
    }

    public boolean hasInterval() {
        return this.interval != null && !this.interval.isEmpty();
    }

    public SampledData setIntervalElement(DecimalType value) {
        this.interval = value;
        return this;
    }

    public BigDecimal getInterval() {
        return this.interval == null ? null : (BigDecimal)this.interval.getValue();
    }

    public SampledData setInterval(BigDecimal value) {
        if (value == null) {
            this.interval = null;
        } else {
            if (this.interval == null) {
                this.interval = new DecimalType();
            }
            this.interval.setValue(value);
        }
        return this;
    }

    public SampledData setInterval(long value) {
        this.interval = new DecimalType();
        this.interval.setValue(value);
        return this;
    }

    public SampledData setInterval(double value) {
        this.interval = new DecimalType();
        this.interval.setValue(value);
        return this;
    }

    public CodeType getIntervalUnitElement() {
        if (this.intervalUnit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.intervalUnit");
            }
            if (Configuration.doAutoCreate()) {
                this.intervalUnit = new CodeType();
            }
        }
        return this.intervalUnit;
    }

    public boolean hasIntervalUnitElement() {
        return this.intervalUnit != null && !this.intervalUnit.isEmpty();
    }

    public boolean hasIntervalUnit() {
        return this.intervalUnit != null && !this.intervalUnit.isEmpty();
    }

    public SampledData setIntervalUnitElement(CodeType value) {
        this.intervalUnit = value;
        return this;
    }

    public String getIntervalUnit() {
        return this.intervalUnit == null ? null : (String)this.intervalUnit.getValue();
    }

    public SampledData setIntervalUnit(String value) {
        if (this.intervalUnit == null) {
            this.intervalUnit = new CodeType();
        }
        this.intervalUnit.setValue(value);
        return this;
    }

    public DecimalType getFactorElement() {
        if (this.factor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.factor");
            }
            if (Configuration.doAutoCreate()) {
                this.factor = new DecimalType();
            }
        }
        return this.factor;
    }

    public boolean hasFactorElement() {
        return this.factor != null && !this.factor.isEmpty();
    }

    public boolean hasFactor() {
        return this.factor != null && !this.factor.isEmpty();
    }

    public SampledData setFactorElement(DecimalType value) {
        this.factor = value;
        return this;
    }

    public BigDecimal getFactor() {
        return this.factor == null ? null : (BigDecimal)this.factor.getValue();
    }

    public SampledData setFactor(BigDecimal value) {
        if (value == null) {
            this.factor = null;
        } else {
            if (this.factor == null) {
                this.factor = new DecimalType();
            }
            this.factor.setValue(value);
        }
        return this;
    }

    public SampledData setFactor(long value) {
        this.factor = new DecimalType();
        this.factor.setValue(value);
        return this;
    }

    public SampledData setFactor(double value) {
        this.factor = new DecimalType();
        this.factor.setValue(value);
        return this;
    }

    public DecimalType getLowerLimitElement() {
        if (this.lowerLimit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.lowerLimit");
            }
            if (Configuration.doAutoCreate()) {
                this.lowerLimit = new DecimalType();
            }
        }
        return this.lowerLimit;
    }

    public boolean hasLowerLimitElement() {
        return this.lowerLimit != null && !this.lowerLimit.isEmpty();
    }

    public boolean hasLowerLimit() {
        return this.lowerLimit != null && !this.lowerLimit.isEmpty();
    }

    public SampledData setLowerLimitElement(DecimalType value) {
        this.lowerLimit = value;
        return this;
    }

    public BigDecimal getLowerLimit() {
        return this.lowerLimit == null ? null : (BigDecimal)this.lowerLimit.getValue();
    }

    public SampledData setLowerLimit(BigDecimal value) {
        if (value == null) {
            this.lowerLimit = null;
        } else {
            if (this.lowerLimit == null) {
                this.lowerLimit = new DecimalType();
            }
            this.lowerLimit.setValue(value);
        }
        return this;
    }

    public SampledData setLowerLimit(long value) {
        this.lowerLimit = new DecimalType();
        this.lowerLimit.setValue(value);
        return this;
    }

    public SampledData setLowerLimit(double value) {
        this.lowerLimit = new DecimalType();
        this.lowerLimit.setValue(value);
        return this;
    }

    public DecimalType getUpperLimitElement() {
        if (this.upperLimit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.upperLimit");
            }
            if (Configuration.doAutoCreate()) {
                this.upperLimit = new DecimalType();
            }
        }
        return this.upperLimit;
    }

    public boolean hasUpperLimitElement() {
        return this.upperLimit != null && !this.upperLimit.isEmpty();
    }

    public boolean hasUpperLimit() {
        return this.upperLimit != null && !this.upperLimit.isEmpty();
    }

    public SampledData setUpperLimitElement(DecimalType value) {
        this.upperLimit = value;
        return this;
    }

    public BigDecimal getUpperLimit() {
        return this.upperLimit == null ? null : (BigDecimal)this.upperLimit.getValue();
    }

    public SampledData setUpperLimit(BigDecimal value) {
        if (value == null) {
            this.upperLimit = null;
        } else {
            if (this.upperLimit == null) {
                this.upperLimit = new DecimalType();
            }
            this.upperLimit.setValue(value);
        }
        return this;
    }

    public SampledData setUpperLimit(long value) {
        this.upperLimit = new DecimalType();
        this.upperLimit.setValue(value);
        return this;
    }

    public SampledData setUpperLimit(double value) {
        this.upperLimit = new DecimalType();
        this.upperLimit.setValue(value);
        return this;
    }

    public PositiveIntType getDimensionsElement() {
        if (this.dimensions == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.dimensions");
            }
            if (Configuration.doAutoCreate()) {
                this.dimensions = new PositiveIntType();
            }
        }
        return this.dimensions;
    }

    public boolean hasDimensionsElement() {
        return this.dimensions != null && !this.dimensions.isEmpty();
    }

    public boolean hasDimensions() {
        return this.dimensions != null && !this.dimensions.isEmpty();
    }

    public SampledData setDimensionsElement(PositiveIntType value) {
        this.dimensions = value;
        return this;
    }

    public int getDimensions() {
        return this.dimensions == null || this.dimensions.isEmpty() ? 0 : (Integer)this.dimensions.getValue();
    }

    public SampledData setDimensions(int value) {
        if (this.dimensions == null) {
            this.dimensions = new PositiveIntType();
        }
        this.dimensions.setValue((Object)value);
        return this;
    }

    public CanonicalType getCodeMapElement() {
        if (this.codeMap == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.codeMap");
            }
            if (Configuration.doAutoCreate()) {
                this.codeMap = new CanonicalType();
            }
        }
        return this.codeMap;
    }

    public boolean hasCodeMapElement() {
        return this.codeMap != null && !this.codeMap.isEmpty();
    }

    public boolean hasCodeMap() {
        return this.codeMap != null && !this.codeMap.isEmpty();
    }

    public SampledData setCodeMapElement(CanonicalType value) {
        this.codeMap = value;
        return this;
    }

    public String getCodeMap() {
        return this.codeMap == null ? null : (String)this.codeMap.getValue();
    }

    public SampledData setCodeMap(String value) {
        if (Utilities.noString((String)value)) {
            this.codeMap = null;
        } else {
            if (this.codeMap == null) {
                this.codeMap = new CanonicalType();
            }
            this.codeMap.setValue(value);
        }
        return this;
    }

    public StringType getOffsetsElement() {
        if (this.offsets == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.offsets");
            }
            if (Configuration.doAutoCreate()) {
                this.offsets = new StringType();
            }
        }
        return this.offsets;
    }

    public boolean hasOffsetsElement() {
        return this.offsets != null && !this.offsets.isEmpty();
    }

    public boolean hasOffsets() {
        return this.offsets != null && !this.offsets.isEmpty();
    }

    public SampledData setOffsetsElement(StringType value) {
        this.offsets = value;
        return this;
    }

    public String getOffsets() {
        return this.offsets == null ? null : (String)this.offsets.getValue();
    }

    public SampledData setOffsets(String value) {
        if (Utilities.noString((String)value)) {
            this.offsets = null;
        } else {
            if (this.offsets == null) {
                this.offsets = new StringType();
            }
            this.offsets.setValue(value);
        }
        return this;
    }

    public StringType getDataElement() {
        if (this.data == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SampledData.data");
            }
            if (Configuration.doAutoCreate()) {
                this.data = new StringType();
            }
        }
        return this.data;
    }

    public boolean hasDataElement() {
        return this.data != null && !this.data.isEmpty();
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public SampledData setDataElement(StringType value) {
        this.data = value;
        return this;
    }

    public String getData() {
        return this.data == null ? null : (String)this.data.getValue();
    }

    public SampledData setData(String value) {
        if (Utilities.noString((String)value)) {
            this.data = null;
        } else {
            if (this.data == null) {
                this.data = new StringType();
            }
            this.data.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("origin", "Quantity", "The base quantity that a measured value of zero represents. In addition, this provides the units of the entire measurement series.", 0, 1, this.origin));
        children.add(new Property("interval", "decimal", "Amount of intervalUnits between samples, e.g. milliseconds for time-based sampling.", 0, 1, this.interval));
        children.add(new Property("intervalUnit", "code", "The measurement unit in which the sample interval is expressed.", 0, 1, this.intervalUnit));
        children.add(new Property("factor", "decimal", "A correction factor that is applied to the sampled data points before they are added to the origin.", 0, 1, this.factor));
        children.add(new Property("lowerLimit", "decimal", "The lower limit of detection of the measured points. This is needed if any of the data points have the value \"L\" (lower than detection limit).", 0, 1, this.lowerLimit));
        children.add(new Property("upperLimit", "decimal", "The upper limit of detection of the measured points. This is needed if any of the data points have the value \"U\" (higher than detection limit).", 0, 1, this.upperLimit));
        children.add(new Property("dimensions", "positiveInt", "The number of sample points at each time point. If this value is greater than one, then the dimensions will be interlaced - all the sample points for a point in time will be recorded at once.", 0, 1, this.dimensions));
        children.add(new Property("codeMap", "canonical(ConceptMap)", "Reference to ConceptMap that defines the codes used in the data.", 0, 1, this.codeMap));
        children.add(new Property("offsets", "string", "A series of data points which are decimal values separated by a single space (character u20).  The units in which the offsets are expressed are found in intervalUnit.  The absolute point at which the measurements begin SHALL be conveyed outside the scope of this datatype, e.g. Observation.effectiveDateTime for a timing offset.", 0, 1, this.offsets));
        children.add(new Property("data", "string", "A series of data points which are decimal values or codes separated by a single space (character u20). The special codes \"E\" (error), \"L\" (below detection limit) and \"U\" (above detection limit) are also defined for used in place of decimal values.", 0, 1, this.data));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1008619738: {
                return new Property("origin", "Quantity", "The base quantity that a measured value of zero represents. In addition, this provides the units of the entire measurement series.", 0, 1, this.origin);
            }
            case 570418373: {
                return new Property("interval", "decimal", "Amount of intervalUnits between samples, e.g. milliseconds for time-based sampling.", 0, 1, this.interval);
            }
            case -1569830935: {
                return new Property("intervalUnit", "code", "The measurement unit in which the sample interval is expressed.", 0, 1, this.intervalUnit);
            }
            case -1282148017: {
                return new Property("factor", "decimal", "A correction factor that is applied to the sampled data points before they are added to the origin.", 0, 1, this.factor);
            }
            case 1209133370: {
                return new Property("lowerLimit", "decimal", "The lower limit of detection of the measured points. This is needed if any of the data points have the value \"L\" (lower than detection limit).", 0, 1, this.lowerLimit);
            }
            case -1681713095: {
                return new Property("upperLimit", "decimal", "The upper limit of detection of the measured points. This is needed if any of the data points have the value \"U\" (higher than detection limit).", 0, 1, this.upperLimit);
            }
            case 414334925: {
                return new Property("dimensions", "positiveInt", "The number of sample points at each time point. If this value is greater than one, then the dimensions will be interlaced - all the sample points for a point in time will be recorded at once.", 0, 1, this.dimensions);
            }
            case 941825071: {
                return new Property("codeMap", "canonical(ConceptMap)", "Reference to ConceptMap that defines the codes used in the data.", 0, 1, this.codeMap);
            }
            case -1548407232: {
                return new Property("offsets", "string", "A series of data points which are decimal values separated by a single space (character u20).  The units in which the offsets are expressed are found in intervalUnit.  The absolute point at which the measurements begin SHALL be conveyed outside the scope of this datatype, e.g. Observation.effectiveDateTime for a timing offset.", 0, 1, this.offsets);
            }
            case 3076010: {
                return new Property("data", "string", "A series of data points which are decimal values or codes separated by a single space (character u20). The special codes \"E\" (error), \"L\" (below detection limit) and \"U\" (above detection limit) are also defined for used in place of decimal values.", 0, 1, this.data);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1008619738: {
                Base[] baseArray;
                if (this.origin == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.origin;
                }
                return baseArray;
            }
            case 570418373: {
                Base[] baseArray;
                if (this.interval == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.interval;
                }
                return baseArray;
            }
            case -1569830935: {
                Base[] baseArray;
                if (this.intervalUnit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.intervalUnit;
                }
                return baseArray;
            }
            case -1282148017: {
                Base[] baseArray;
                if (this.factor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.factor;
                }
                return baseArray;
            }
            case 1209133370: {
                Base[] baseArray;
                if (this.lowerLimit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.lowerLimit;
                }
                return baseArray;
            }
            case -1681713095: {
                Base[] baseArray;
                if (this.upperLimit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.upperLimit;
                }
                return baseArray;
            }
            case 414334925: {
                Base[] baseArray;
                if (this.dimensions == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.dimensions;
                }
                return baseArray;
            }
            case 941825071: {
                Base[] baseArray;
                if (this.codeMap == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.codeMap;
                }
                return baseArray;
            }
            case -1548407232: {
                Base[] baseArray;
                if (this.offsets == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.offsets;
                }
                return baseArray;
            }
            case 3076010: {
                Base[] baseArray;
                if (this.data == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.data;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1008619738: {
                this.origin = TypeConvertor.castToQuantity(value);
                return value;
            }
            case 570418373: {
                this.interval = TypeConvertor.castToDecimal(value);
                return value;
            }
            case -1569830935: {
                this.intervalUnit = TypeConvertor.castToCode(value);
                return value;
            }
            case -1282148017: {
                this.factor = TypeConvertor.castToDecimal(value);
                return value;
            }
            case 1209133370: {
                this.lowerLimit = TypeConvertor.castToDecimal(value);
                return value;
            }
            case -1681713095: {
                this.upperLimit = TypeConvertor.castToDecimal(value);
                return value;
            }
            case 414334925: {
                this.dimensions = TypeConvertor.castToPositiveInt(value);
                return value;
            }
            case 941825071: {
                this.codeMap = TypeConvertor.castToCanonical(value);
                return value;
            }
            case -1548407232: {
                this.offsets = TypeConvertor.castToString(value);
                return value;
            }
            case 3076010: {
                this.data = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("origin")) {
            this.origin = TypeConvertor.castToQuantity(value);
        } else if (name.equals("interval")) {
            this.interval = TypeConvertor.castToDecimal(value);
        } else if (name.equals("intervalUnit")) {
            this.intervalUnit = TypeConvertor.castToCode(value);
        } else if (name.equals("factor")) {
            this.factor = TypeConvertor.castToDecimal(value);
        } else if (name.equals("lowerLimit")) {
            this.lowerLimit = TypeConvertor.castToDecimal(value);
        } else if (name.equals("upperLimit")) {
            this.upperLimit = TypeConvertor.castToDecimal(value);
        } else if (name.equals("dimensions")) {
            this.dimensions = TypeConvertor.castToPositiveInt(value);
        } else if (name.equals("codeMap")) {
            this.codeMap = TypeConvertor.castToCanonical(value);
        } else if (name.equals("offsets")) {
            this.offsets = TypeConvertor.castToString(value);
        } else if (name.equals("data")) {
            this.data = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("origin")) {
            this.origin = null;
        } else if (name.equals("interval")) {
            this.interval = null;
        } else if (name.equals("intervalUnit")) {
            this.intervalUnit = null;
        } else if (name.equals("factor")) {
            this.factor = null;
        } else if (name.equals("lowerLimit")) {
            this.lowerLimit = null;
        } else if (name.equals("upperLimit")) {
            this.upperLimit = null;
        } else if (name.equals("dimensions")) {
            this.dimensions = null;
        } else if (name.equals("codeMap")) {
            this.codeMap = null;
        } else if (name.equals("offsets")) {
            this.offsets = null;
        } else if (name.equals("data")) {
            this.data = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1008619738: {
                return this.getOrigin();
            }
            case 570418373: {
                return this.getIntervalElement();
            }
            case -1569830935: {
                return this.getIntervalUnitElement();
            }
            case -1282148017: {
                return this.getFactorElement();
            }
            case 1209133370: {
                return this.getLowerLimitElement();
            }
            case -1681713095: {
                return this.getUpperLimitElement();
            }
            case 414334925: {
                return this.getDimensionsElement();
            }
            case 941825071: {
                return this.getCodeMapElement();
            }
            case -1548407232: {
                return this.getOffsetsElement();
            }
            case 3076010: {
                return this.getDataElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1008619738: {
                return new String[]{"Quantity"};
            }
            case 570418373: {
                return new String[]{"decimal"};
            }
            case -1569830935: {
                return new String[]{"code"};
            }
            case -1282148017: {
                return new String[]{"decimal"};
            }
            case 1209133370: {
                return new String[]{"decimal"};
            }
            case -1681713095: {
                return new String[]{"decimal"};
            }
            case 414334925: {
                return new String[]{"positiveInt"};
            }
            case 941825071: {
                return new String[]{"canonical"};
            }
            case -1548407232: {
                return new String[]{"string"};
            }
            case 3076010: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("origin")) {
            this.origin = new Quantity();
            return this.origin;
        }
        if (name.equals("interval")) {
            throw new FHIRException("Cannot call addChild on a singleton property SampledData.interval");
        }
        if (name.equals("intervalUnit")) {
            throw new FHIRException("Cannot call addChild on a singleton property SampledData.intervalUnit");
        }
        if (name.equals("factor")) {
            throw new FHIRException("Cannot call addChild on a singleton property SampledData.factor");
        }
        if (name.equals("lowerLimit")) {
            throw new FHIRException("Cannot call addChild on a singleton property SampledData.lowerLimit");
        }
        if (name.equals("upperLimit")) {
            throw new FHIRException("Cannot call addChild on a singleton property SampledData.upperLimit");
        }
        if (name.equals("dimensions")) {
            throw new FHIRException("Cannot call addChild on a singleton property SampledData.dimensions");
        }
        if (name.equals("codeMap")) {
            throw new FHIRException("Cannot call addChild on a singleton property SampledData.codeMap");
        }
        if (name.equals("offsets")) {
            throw new FHIRException("Cannot call addChild on a singleton property SampledData.offsets");
        }
        if (name.equals("data")) {
            throw new FHIRException("Cannot call addChild on a singleton property SampledData.data");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SampledData";
    }

    @Override
    public SampledData copy() {
        SampledData dst = new SampledData();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SampledData dst) {
        super.copyValues(dst);
        dst.origin = this.origin == null ? null : this.origin.copy();
        dst.interval = this.interval == null ? null : this.interval.copy();
        dst.intervalUnit = this.intervalUnit == null ? null : this.intervalUnit.copy();
        dst.factor = this.factor == null ? null : this.factor.copy();
        dst.lowerLimit = this.lowerLimit == null ? null : this.lowerLimit.copy();
        dst.upperLimit = this.upperLimit == null ? null : this.upperLimit.copy();
        dst.dimensions = this.dimensions == null ? null : this.dimensions.copy();
        dst.codeMap = this.codeMap == null ? null : this.codeMap.copy();
        dst.offsets = this.offsets == null ? null : this.offsets.copy();
        dst.data = this.data == null ? null : this.data.copy();
    }

    protected SampledData typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SampledData)) {
            return false;
        }
        SampledData o = (SampledData)other_;
        return SampledData.compareDeep(this.origin, o.origin, true) && SampledData.compareDeep(this.interval, o.interval, true) && SampledData.compareDeep(this.intervalUnit, o.intervalUnit, true) && SampledData.compareDeep(this.factor, o.factor, true) && SampledData.compareDeep(this.lowerLimit, o.lowerLimit, true) && SampledData.compareDeep(this.upperLimit, o.upperLimit, true) && SampledData.compareDeep(this.dimensions, o.dimensions, true) && SampledData.compareDeep(this.codeMap, o.codeMap, true) && SampledData.compareDeep(this.offsets, o.offsets, true) && SampledData.compareDeep(this.data, o.data, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SampledData)) {
            return false;
        }
        SampledData o = (SampledData)other_;
        return SampledData.compareValues(this.interval, o.interval, true) && SampledData.compareValues(this.intervalUnit, o.intervalUnit, true) && SampledData.compareValues(this.factor, o.factor, true) && SampledData.compareValues(this.lowerLimit, o.lowerLimit, true) && SampledData.compareValues(this.upperLimit, o.upperLimit, true) && SampledData.compareValues(this.dimensions, o.dimensions, true) && SampledData.compareValues(this.codeMap, o.codeMap, true) && SampledData.compareValues(this.offsets, o.offsets, true) && SampledData.compareValues(this.data, o.data, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.origin, this.interval, this.intervalUnit, this.factor, this.lowerLimit, this.upperLimit, this.dimensions, this.codeMap, this.offsets, this.data});
    }
}

