/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.testfactory.dataprovider;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.testfactory.dataprovider.TableDataProvider;
import org.hl7.fhir.utilities.CSVReader;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class CSVDataProvider
extends TableDataProvider {
    private CSVReader csv;
    private List<String> cols = new ArrayList<String>();
    private int counter;
    private String filename;

    protected CSVDataProvider(String filename) throws FHIRException, FileNotFoundException, IOException {
        this.filename = filename;
        this.reset();
    }

    @Override
    public List<String> columns() {
        return this.cols;
    }

    @Override
    public boolean nextRow() throws FHIRException {
        try {
            ++this.counter;
            return this.csv.line();
        }
        catch (IOException e) {
            throw new FHIRException("Error moving to next row: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<String> cells() {
        ArrayList<String> cells = new ArrayList<String>();
        cells.add("" + this.counter);
        for (String s : this.csv.getCells()) {
            cells.add(s.trim());
        }
        return cells;
    }

    @Override
    public String cell(String name) {
        if ("counter".equals(name)) {
            return "" + this.counter;
        }
        return this.csv.cell(name).trim();
    }

    @Override
    public void reset() throws FHIRException {
        try {
            this.csv = new CSVReader((InputStream)new FileInputStream(this.filename));
            this.cols.add("counter");
            for (String s : this.csv.readHeaders()) {
                this.cols.add(s.trim());
            }
        }
        catch (Exception e) {
            throw new FHIRException("Error moving to next row: " + e.getMessage(), (Throwable)e);
        }
    }
}

