/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.tools;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.tools.CDSHookContext;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="CDSHookOrderSignContext")
public class CDSHookOrderSignContext
extends CDSHookContext
implements ICompositeType {
    @Child(name="userId", type={UrlType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The id of the current user. Must be in the format [ResourceType]/[id].", formalDefinition="For this hook, the user is expected to be of type Practitioner, PractitionerRole, Patient, or RelatedPerson. Patient or RelatedPerson are appropriate when a patient or their proxy are viewing the record. For example, Practitioner/abc or Patient/123.")
    protected UrlType userId;
    @Child(name="patientId", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The FHIR Patient.id of the current patient in context", formalDefinition="The FHIR Patient.id of the current patient in context")
    protected IdType patientId;
    @Child(name="encounterId", type={IdType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The FHIR Encounter.id of the current encounter in context", formalDefinition="The FHIR Encounter.id of the current encounter in context")
    protected IdType encounterId;
    @Child(name="draftOrders", type={Bundle.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="FHIR Bundle of MedicationRequest, NutritionOrder, ServiceRequest, VisionPrescription with draft status", formalDefinition="FHIR Bundle of MedicationRequest, NutritionOrder, ServiceRequest, VisionPrescription with draft status")
    protected Bundle draftOrders;
    private static final long serialVersionUID = -590647101L;

    public CDSHookOrderSignContext() {
    }

    public CDSHookOrderSignContext(String userId, String patientId, Bundle draftOrders) {
        this.setUserId(userId);
        this.setPatientId(patientId);
        this.setDraftOrders(draftOrders);
    }

    public UrlType getUserIdElement() {
        if (this.userId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CDSHookOrderSignContext.userId");
            }
            if (Configuration.doAutoCreate()) {
                this.userId = new UrlType();
            }
        }
        return this.userId;
    }

    public boolean hasUserIdElement() {
        return this.userId != null && !this.userId.isEmpty();
    }

    public boolean hasUserId() {
        return this.userId != null && !this.userId.isEmpty();
    }

    public CDSHookOrderSignContext setUserIdElement(UrlType value) {
        this.userId = value;
        return this;
    }

    public String getUserId() {
        return this.userId == null ? null : (String)this.userId.getValue();
    }

    public CDSHookOrderSignContext setUserId(String value) {
        if (this.userId == null) {
            this.userId = new UrlType();
        }
        this.userId.setValue(value);
        return this;
    }

    public IdType getPatientIdElement() {
        if (this.patientId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CDSHookOrderSignContext.patientId");
            }
            if (Configuration.doAutoCreate()) {
                this.patientId = new IdType();
            }
        }
        return this.patientId;
    }

    public boolean hasPatientIdElement() {
        return this.patientId != null && !this.patientId.isEmpty();
    }

    public boolean hasPatientId() {
        return this.patientId != null && !this.patientId.isEmpty();
    }

    public CDSHookOrderSignContext setPatientIdElement(IdType value) {
        this.patientId = value;
        return this;
    }

    public String getPatientId() {
        return this.patientId == null ? null : this.patientId.getValue();
    }

    public CDSHookOrderSignContext setPatientId(String value) {
        if (this.patientId == null) {
            this.patientId = new IdType();
        }
        this.patientId.setValue(value);
        return this;
    }

    public IdType getEncounterIdElement() {
        if (this.encounterId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CDSHookOrderSignContext.encounterId");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterId = new IdType();
            }
        }
        return this.encounterId;
    }

    public boolean hasEncounterIdElement() {
        return this.encounterId != null && !this.encounterId.isEmpty();
    }

    public boolean hasEncounterId() {
        return this.encounterId != null && !this.encounterId.isEmpty();
    }

    public CDSHookOrderSignContext setEncounterIdElement(IdType value) {
        this.encounterId = value;
        return this;
    }

    public String getEncounterId() {
        return this.encounterId == null ? null : this.encounterId.getValue();
    }

    public CDSHookOrderSignContext setEncounterId(String value) {
        if (Utilities.noString((String)value)) {
            this.encounterId = null;
        } else {
            if (this.encounterId == null) {
                this.encounterId = new IdType();
            }
            this.encounterId.setValue(value);
        }
        return this;
    }

    public Bundle getDraftOrders() {
        if (this.draftOrders == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CDSHookOrderSignContext.draftOrders");
            }
            if (Configuration.doAutoCreate()) {
                this.draftOrders = new Bundle();
            }
        }
        return this.draftOrders;
    }

    public boolean hasDraftOrders() {
        return this.draftOrders != null && !this.draftOrders.isEmpty();
    }

    public CDSHookOrderSignContext setDraftOrders(Bundle value) {
        this.draftOrders = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("userId", "url", "For this hook, the user is expected to be of type Practitioner, PractitionerRole, Patient, or RelatedPerson. Patient or RelatedPerson are appropriate when a patient or their proxy are viewing the record. For example, Practitioner/abc or Patient/123.", 0, 1, this.userId));
        children.add(new Property("patientId", "id", "The FHIR Patient.id of the current patient in context", 0, 1, this.patientId));
        children.add(new Property("encounterId", "id", "The FHIR Encounter.id of the current encounter in context", 0, 1, this.encounterId));
        children.add(new Property("draftOrders", "Bundle", "FHIR Bundle of MedicationRequest, NutritionOrder, ServiceRequest, VisionPrescription with draft status", 0, 1, this.draftOrders));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -836030906: {
                return new Property("userId", "url", "For this hook, the user is expected to be of type Practitioner, PractitionerRole, Patient, or RelatedPerson. Patient or RelatedPerson are appropriate when a patient or their proxy are viewing the record. For example, Practitioner/abc or Patient/123.", 0, 1, this.userId);
            }
            case -343587072: {
                return new Property("patientId", "id", "The FHIR Patient.id of the current patient in context", 0, 1, this.patientId);
            }
            case 107147694: {
                return new Property("encounterId", "id", "The FHIR Encounter.id of the current encounter in context", 0, 1, this.encounterId);
            }
            case 155667430: {
                return new Property("draftOrders", "Bundle", "FHIR Bundle of MedicationRequest, NutritionOrder, ServiceRequest, VisionPrescription with draft status", 0, 1, this.draftOrders);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -836030906: {
                Base[] baseArray;
                if (this.userId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.userId;
                }
                return baseArray;
            }
            case -343587072: {
                Base[] baseArray;
                if (this.patientId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patientId;
                }
                return baseArray;
            }
            case 107147694: {
                Base[] baseArray;
                if (this.encounterId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.encounterId;
                }
                return baseArray;
            }
            case 155667430: {
                Base[] baseArray;
                if (this.draftOrders == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.draftOrders;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -836030906: {
                this.userId = TypeConvertor.castToUrl(value);
                return value;
            }
            case -343587072: {
                this.patientId = TypeConvertor.castToId(value);
                return value;
            }
            case 107147694: {
                this.encounterId = TypeConvertor.castToId(value);
                return value;
            }
            case 155667430: {
                this.draftOrders = (Bundle)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("userId")) {
            this.userId = TypeConvertor.castToUrl(value);
        } else if (name.equals("patientId")) {
            this.patientId = TypeConvertor.castToId(value);
        } else if (name.equals("encounterId")) {
            this.encounterId = TypeConvertor.castToId(value);
        } else if (name.equals("draftOrders")) {
            this.draftOrders = (Bundle)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -836030906: {
                return this.getUserIdElement();
            }
            case -343587072: {
                return this.getPatientIdElement();
            }
            case 107147694: {
                return this.getEncounterIdElement();
            }
            case 155667430: {
                return this.getDraftOrders();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -836030906: {
                return new String[]{"url"};
            }
            case -343587072: {
                return new String[]{"id"};
            }
            case 107147694: {
                return new String[]{"id"};
            }
            case 155667430: {
                return new String[]{"Bundle"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("userId")) {
            throw new FHIRException("Cannot call addChild on a singleton property CDSHookOrderSignContext.userId");
        }
        if (name.equals("patientId")) {
            throw new FHIRException("Cannot call addChild on a singleton property CDSHookOrderSignContext.patientId");
        }
        if (name.equals("encounterId")) {
            throw new FHIRException("Cannot call addChild on a singleton property CDSHookOrderSignContext.encounterId");
        }
        if (name.equals("draftOrders")) {
            this.draftOrders = new Bundle();
            return this.draftOrders;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CDSHookOrderSignContext";
    }

    @Override
    public CDSHookOrderSignContext copy() {
        CDSHookOrderSignContext dst = new CDSHookOrderSignContext();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CDSHookOrderSignContext dst) {
        super.copyValues(dst);
        dst.userId = this.userId == null ? null : this.userId.copy();
        dst.patientId = this.patientId == null ? null : this.patientId.copy();
        dst.encounterId = this.encounterId == null ? null : this.encounterId.copy();
        dst.draftOrders = this.draftOrders == null ? null : this.draftOrders.copy();
    }

    protected CDSHookOrderSignContext typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CDSHookOrderSignContext)) {
            return false;
        }
        CDSHookOrderSignContext o = (CDSHookOrderSignContext)other_;
        return CDSHookOrderSignContext.compareDeep(this.userId, o.userId, true) && CDSHookOrderSignContext.compareDeep(this.patientId, o.patientId, true) && CDSHookOrderSignContext.compareDeep(this.encounterId, o.encounterId, true) && CDSHookOrderSignContext.compareDeep(this.draftOrders, o.draftOrders, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CDSHookOrderSignContext)) {
            return false;
        }
        CDSHookOrderSignContext o = (CDSHookOrderSignContext)other_;
        return CDSHookOrderSignContext.compareValues(this.userId, o.userId, true) && CDSHookOrderSignContext.compareValues(this.patientId, o.patientId, true) && CDSHookOrderSignContext.compareValues(this.encounterId, o.encounterId, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.userId, this.patientId, this.encounterId, this.draftOrders});
    }
}

