/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.tools;

import java.util.List;
import org.hl7.fhir.r5.extensions.ExtensionsUtils;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;

public class Extensions {
    public static Extension makeBindingDefinition(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/binding-definition").setValue(new MarkdownType(value));
    }

    public static Extension makeTerminologyBindingStyleEXT(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style").setValue(new CodeType(value));
    }

    public static StructureDefinition addTerminologyBindingStyleEXT(StructureDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style", new CodeType(value));
        return context;
    }

    public static List<String> getTerminologyBindingStyleEXTList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style");
    }

    public static Extension makeDateFormat(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format").setValue(new StringType(value));
    }

    public static ElementDefinition addDateFormat(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format", new StringType(value));
        return context;
    }

    public static List<String> getDateFormatList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format");
    }

    public static Extension makeDateRulesControl(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules").setValue(new StringType(value));
    }

    public static ElementDefinition addDateRulesControl(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules", new StringType(value));
        return context;
    }

    public static List<String> getDateRulesControlList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules");
    }

    public static Extension makeExtensionStylesEXT(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/extension-style").setValue(new CodeType(value));
    }

    public static StructureDefinition addExtensionStylesEXT(StructureDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/extension-style", new CodeType(value));
        return context;
    }

    public static List<String> getExtensionStylesEXTList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/extension-style");
    }

    public static Extension makeIdExpectationExt(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/id-expectation").setValue(new CodeType(value));
    }

    public static ElementDefinition addIdExpectationExt(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/id-expectation", new CodeType(value));
        return context;
    }

    public static List<String> getIdExpectationExtList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/id-expectation");
    }

    public static Extension makeActorExampleURL(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/ig-actor-example-url").setValue(new UrlType(value));
    }

    public static ActorDefinition addActorExampleURL(ActorDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/ig-actor-example-url", new UrlType(value));
        return context;
    }

    public static List<String> getActorExampleURLList(ActorDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/ig-actor-example-url");
    }

    public static Extension makeActorForExample(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/ig-example-actor").setValue(new CanonicalType(value));
    }

    public static Extension makeIGInternalDependency(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency").setValue(new CodeType(value));
    }

    public static Extension makeIGLinkDependency(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/ig-link-dependency").setValue(new CodeType(value));
    }

    public static Extension makeIGPublisherLoadAsResource(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/ig-load-as-resource").setValue(new BooleanType(value));
    }

    public static StructureDefinition addIGPublisherLoadAsResource(StructureDefinition context, boolean value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/ig-load-as-resource", new BooleanType(value));
        return context;
    }

    public static List<Boolean> getIGPublisherLoadAsResourceList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionBooleanList(context, "http://hl7.org/fhir/tools/StructureDefinition/ig-load-as-resource");
    }

    public static Extension makeIGPageName(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/ig-page-name").setValue(new UrlType(value));
    }

    public static Extension makeIGPublisherUseAsResourceId(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/ig-use-as-resource-id").setValue(new BooleanType(value));
    }

    public static ElementDefinition addIGPublisherUseAsResourceId(ElementDefinition context, boolean value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/ig-use-as-resource-id", new BooleanType(value));
        return context;
    }

    public static List<Boolean> getIGPublisherUseAsResourceIdList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionBooleanList(context, "http://hl7.org/fhir/tools/StructureDefinition/ig-use-as-resource-id");
    }

    public static Extension makeIGPublisherBundle(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/igpublisher-bundle").setValue(new UrlType(value));
    }

    public static Extension makeIGDependencyComment(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment").setValue(new MarkdownType(value));
    }

    public static Extension makeBinaryResourceFormat(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format").setValue(new CodeType(value));
    }

    public static Extension makeBinaryResourceLogical(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical").setValue(new CanonicalType(value));
    }

    public static Extension makeImpliedStringPrefix(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix").setValue(new StringType(value));
    }

    public static ElementDefinition addImpliedStringPrefix(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix", new StringType(value));
        return context;
    }

    public static List<String> getImpliedStringPrefixList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix");
    }

    public static Extension makeInheritObligations(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/inherit-obligations").setValue(new CanonicalType(value));
    }

    public static StructureDefinition addInheritObligations(StructureDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/inherit-obligations", new CanonicalType(value));
        return context;
    }

    public static List<String> getInheritObligationsList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/inherit-obligations");
    }

    public static Extension makeJsonEmptyBehavior(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior").setValue(new CodeType(value));
    }

    public static ElementDefinition addJsonEmptyBehavior(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior", new CodeType(value));
        return context;
    }

    public static List<String> getJsonEmptyBehaviorList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior");
    }

    public static Extension makeJsonPropertyName(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/json-name").setValue(new StringType(value));
    }

    public static ElementDefinition addJsonPropertyName(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-name", new StringType(value));
        return context;
    }

    public static List<String> getJsonPropertyNameList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/json-name");
    }

    public static Extension makeJsonNullableExt(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/json-nullable").setValue(new BooleanType(value));
    }

    public static ElementDefinition setJsonNullableExt(ElementDefinition context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-nullable", new BooleanType(value));
        return context;
    }

    public static Boolean getJsonNullableExt(ElementDefinition context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/tools/StructureDefinition/json-nullable");
    }

    public static Extension makeJsonPrimitiveChoiceExt(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice").setValue(new BooleanType(value));
    }

    public static ElementDefinition setJsonPrimitiveChoiceExt(ElementDefinition context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice", new BooleanType(value));
        return context;
    }

    public static Boolean getJsonPrimitiveChoiceExt(ElementDefinition context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice");
    }

    public static Extension makeJsonPropertyKey(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/json-property-key").setValue(new CodeType(value));
    }

    public static ElementDefinition addJsonPropertyKey(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-property-key", new CodeType(value));
        return context;
    }

    public static List<String> getJsonPropertyKeyList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/json-property-key");
    }

    public static Extension makeJsonSuppressResourceType(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/json-suppress-resourcetype").setValue(new BooleanType(value));
    }

    public static StructureDefinition addJsonSuppressResourceType(StructureDefinition context, boolean value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-suppress-resourcetype", new BooleanType(value));
        return context;
    }

    public static List<Boolean> getJsonSuppressResourceTypeList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionBooleanList(context, "http://hl7.org/fhir/tools/StructureDefinition/json-suppress-resourcetype");
    }

    public static Extension makeLogicalContainer(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/logical-container").setValue(new UriType(value));
    }

    public static StructureDefinition setLogicalContainer(StructureDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/logical-container", new UriType(value));
        return context;
    }

    public static String getLogicalContainer(StructureDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/tools/StructureDefinition/logical-container");
    }

    public static Extension makeLogicalTarget(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/logical-target").setValue(new BooleanType(value));
    }

    public static StructureDefinition setLogicalTarget(StructureDefinition context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/logical-target", new BooleanType(value));
        return context;
    }

    public static Boolean getLogicalTarget(StructureDefinition context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/tools/StructureDefinition/logical-target");
    }

    public static Extension makeMatchetypeFlag(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/matchetype").setValue(new CodeType(value));
    }

    public static Resource addMatchetypeFlag(Resource context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/matchetype", new CodeType(value));
        return context;
    }

    public static List<String> getMatchetypeFlagList(Resource context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/matchetype");
    }

    public static Extension makeMatchetypeCountFlag(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/matchetype-count").setValue(new StringType(value));
    }

    public static Element addMatchetypeCountFlag(Element context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/matchetype-count", new StringType(value));
        return context;
    }

    public static List<String> getMatchetypeCountFlagList(Element context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/matchetype-count");
    }

    public static Extension makeMatchetypeOptionalFlag(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/matchetype-optional").setValue(new StringType(value));
    }

    public static Extension makeMatchetypeOptionalFlag(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/matchetype-optional").setValue(new BooleanType(value));
    }

    public static Element addMatchetypeOptionalFlag(Element context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/matchetype-optional", new StringType(value));
        return context;
    }

    public static List<String> getMatchetypeOptionalFlagStringList(Element context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/matchetype-optional");
    }

    public static Element addMatchetypeOptionalFlag(Element context, boolean value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/matchetype-optional", new BooleanType(value));
        return context;
    }

    public static List<Boolean> getMatchetypeOptionalFlagBooleanList(Element context) {
        return ExtensionsUtils.getExtensionBooleanList(context, "http://hl7.org/fhir/tools/StructureDefinition/matchetype-optional");
    }

    public static Extension makeNoBinding(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/no-binding").setValue(new BooleanType(value));
    }

    public static ElementDefinition setNoBinding(ElementDefinition context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/no-binding", new BooleanType(value));
        return context;
    }

    public static Boolean getNoBinding(ElementDefinition context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/tools/StructureDefinition/no-binding");
    }

    public static Extension makeObligationProfile(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/obligation-profile").setValue(new BooleanType(value));
    }

    public static StructureDefinition addObligationProfile(StructureDefinition context, boolean value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/obligation-profile", new BooleanType(value));
        return context;
    }

    public static List<Boolean> getObligationProfileList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionBooleanList(context, "http://hl7.org/fhir/tools/StructureDefinition/obligation-profile");
    }

    public static Extension makePackageScope(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/package-scope").setValue(new CodeType(value));
    }

    public static ImplementationGuide addPackageScope(ImplementationGuide context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/package-scope", new CodeType(value));
        return context;
    }

    public static List<String> getPackageScopeList(ImplementationGuide context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/package-scope");
    }

    public static Extension makeProfileMapping(DataType value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/profile-mapping").setValue(value);
    }

    public static Extension makeResourceSortExt(int value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/resource-sort").setValue(new IntegerType(value));
    }

    public static Extension makeSearchParameterBaseType(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/searchparameter-base-type").setValue(new CodeType(value));
    }

    public static Extension makeSnapshotBaseVersion(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/snapshot-base-version").setValue(new StringType(value));
    }

    public static Extension makeExtensionSnapshotBehavior(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/snapshot-behavior").setValue(new CodeType(value));
    }

    public static StructureDefinition addExtensionSnapshotBehavior(StructureDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/snapshot-behavior", new CodeType(value));
        return context;
    }

    public static List<String> getExtensionSnapshotBehaviorList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/snapshot-behavior");
    }

    public static Extension makeRenderingEngineViewHintsExt(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/view-hint").setValue(new CodeType(value));
    }

    public static ElementDefinition setRenderingEngineViewHintsExt(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/view-hint", new CodeType(value));
        return context;
    }

    public static String getRenderingEngineViewHintsExt(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/tools/StructureDefinition/view-hint");
    }

    public static StructureDefinition setRenderingEngineViewHintsExt(StructureDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/view-hint", new CodeType(value));
        return context;
    }

    public static String getRenderingEngineViewHintsExt(StructureDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/tools/StructureDefinition/view-hint");
    }

    public static Extension makeWebSource(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/web-source").setValue(new UrlType(value));
    }

    public static CanonicalResource setWebSource(CanonicalResource context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/web-source", new UrlType(value));
        return context;
    }

    public static String getWebSource(CanonicalResource context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/tools/StructureDefinition/web-source");
    }

    public static Extension makeXMLChoiceGroup(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/xml-choice-group").setValue(new BooleanType(value));
    }

    public static ElementDefinition addXMLChoiceGroup(ElementDefinition context, boolean value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/xml-choice-group", new BooleanType(value));
        return context;
    }

    public static List<Boolean> getXMLChoiceGroupList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionBooleanList(context, "http://hl7.org/fhir/tools/StructureDefinition/xml-choice-group");
    }

    public static Extension makeXmlElementName(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/xml-name").setValue(new StringType(value));
    }

    public static ElementDefinition addXmlElementName(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/xml-name", new StringType(value));
        return context;
    }

    public static List<String> getXmlElementNameList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/xml-name");
    }

    public static StructureDefinition addXmlElementName(StructureDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/xml-name", new StringType(value));
        return context;
    }

    public static List<String> getXmlElementNameList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/xml-name");
    }

    public static Extension makeNamespace(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/xml-namespace").setValue(new UriType(value));
    }

    public static ElementDefinition setNamespace(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace", new UriType(value));
        return context;
    }

    public static String getNamespace(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace");
    }

    public static StructureDefinition setNamespace(StructureDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace", new UriType(value));
        return context;
    }

    public static String getNamespace(StructureDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace");
    }

    public static Extension makeXmlNoOrder(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/xml-no-order").setValue(new BooleanType(value));
    }

    public static StructureDefinition setXmlNoOrder(StructureDefinition context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/xml-no-order", new BooleanType(value));
        return context;
    }

    public static Boolean getXmlNoOrder(StructureDefinition context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/tools/StructureDefinition/xml-no-order");
    }
}

