/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.formats.JsonCreator;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.tools.CDSHookContext;
import org.hl7.fhir.r5.tools.CDSHookOrderSelectContext;
import org.hl7.fhir.r5.tools.CDSHookOrderSignContext;
import org.hl7.fhir.r5.tools.CDSHookPatientViewContext;
import org.hl7.fhir.r5.tools.CDSHooksElement;
import org.hl7.fhir.r5.tools.CDSHooksExtensions;
import org.hl7.fhir.r5.tools.CDSHooksRequest;
import org.hl7.fhir.r5.tools.CDSHooksResponse;
import org.hl7.fhir.r5.tools.CDSHooksServices;
import org.hl7.fhir.r5.tools.TestCases;
import org.hl7.fhir.utilities.Utilities;

public class ToolsJsonParser
extends JsonParser {
    public ToolsJsonParser(JsonCreator json) {
        this.json = json;
    }

    public ToolsJsonParser(boolean allowUnknownContent, boolean allowComments) {
        this.setAllowUnknownContent(allowUnknownContent);
        this.setAllowComments(allowComments);
    }

    @Override
    public Resource parseResource(JsonObject json) throws IOException, FHIRFormatError {
        if (!json.has("resourceType")) {
            throw new FHIRFormatError("Unable to find resource type - maybe not a FHIR resource?");
        }
        String t = json.get("resourceType").getAsString();
        if (Utilities.noString((String)t)) {
            throw new FHIRFormatError("Unable to find resource type - maybe not a FHIR resource?");
        }
        if (t.equals("TestCases")) {
            return this.parseTestCases(json);
        }
        throw new FHIRFormatError("Unknown/Unrecognised resource type '" + t + "' (in property 'resourceType')");
    }

    protected void parseCDSHookContextProperties(JsonObject json, CDSHookContext res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
    }

    protected void parseCDSHooksElementProperties(JsonObject json, CDSHooksElement res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("extension")) {
            res.setExtension(this.parseCDSHooksExtensions(this.getJObject(json, "extension")));
        }
    }

    protected CDSHookOrderSelectContext parseCDSHookOrderSelectContext(JsonObject json) throws IOException, FHIRFormatError {
        CDSHookOrderSelectContext res = new CDSHookOrderSelectContext();
        this.parseCDSHookOrderSelectContextProperties(json, res);
        return res;
    }

    protected void parseCDSHookOrderSelectContextProperties(JsonObject json, CDSHookOrderSelectContext res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseCDSHookContextProperties(json, res);
        if (json.has("userId")) {
            res.setUserIdElement(this.parseUrl(json.get("userId").getAsString()));
        }
        if (json.has("_userId")) {
            this.parseElementProperties(this.getJObject(json, "_userId"), res.getUserIdElement());
        }
        if (json.has("patientId")) {
            res.setPatientIdElement(this.parseId(json.get("patientId").getAsString()));
        }
        if (json.has("_patientId")) {
            this.parseElementProperties(this.getJObject(json, "_patientId"), res.getPatientIdElement());
        }
        if (json.has("encounterId")) {
            res.setEncounterIdElement(this.parseId(json.get("encounterId").getAsString()));
        }
        if (json.has("_encounterId")) {
            this.parseElementProperties(this.getJObject(json, "_encounterId"), res.getEncounterIdElement());
        }
        if (json.has("selections")) {
            array = this.getJArray(json, "selections");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSelections().add(new UriType());
                    continue;
                }
                res.getSelections().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_selections")) {
            array = this.getJArray(json, "_selections");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSelections().size()) {
                    res.getSelections().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSelections().get(i));
            }
        }
        if (json.has("draftOrders")) {
            res.setDraftOrders(this.parseBundle(this.getJObject(json, "draftOrders")));
        }
    }

    protected CDSHookOrderSignContext parseCDSHookOrderSignContext(JsonObject json) throws IOException, FHIRFormatError {
        CDSHookOrderSignContext res = new CDSHookOrderSignContext();
        this.parseCDSHookOrderSignContextProperties(json, res);
        return res;
    }

    protected void parseCDSHookOrderSignContextProperties(JsonObject json, CDSHookOrderSignContext res) throws IOException, FHIRFormatError {
        this.parseCDSHookContextProperties(json, res);
        if (json.has("userId")) {
            res.setUserIdElement(this.parseUrl(json.get("userId").getAsString()));
        }
        if (json.has("_userId")) {
            this.parseElementProperties(this.getJObject(json, "_userId"), res.getUserIdElement());
        }
        if (json.has("patientId")) {
            res.setPatientIdElement(this.parseId(json.get("patientId").getAsString()));
        }
        if (json.has("_patientId")) {
            this.parseElementProperties(this.getJObject(json, "_patientId"), res.getPatientIdElement());
        }
        if (json.has("encounterId")) {
            res.setEncounterIdElement(this.parseId(json.get("encounterId").getAsString()));
        }
        if (json.has("_encounterId")) {
            this.parseElementProperties(this.getJObject(json, "_encounterId"), res.getEncounterIdElement());
        }
        if (json.has("draftOrders")) {
            res.setDraftOrders(this.parseBundle(this.getJObject(json, "draftOrders")));
        }
    }

    protected CDSHookPatientViewContext parseCDSHookPatientViewContext(JsonObject json) throws IOException, FHIRFormatError {
        CDSHookPatientViewContext res = new CDSHookPatientViewContext();
        this.parseCDSHookPatientViewContextProperties(json, res);
        return res;
    }

    protected void parseCDSHookPatientViewContextProperties(JsonObject json, CDSHookPatientViewContext res) throws IOException, FHIRFormatError {
        this.parseCDSHookContextProperties(json, res);
        if (json.has("userId")) {
            res.setUserIdElement(this.parseUrl(json.get("userId").getAsString()));
        }
        if (json.has("_userId")) {
            this.parseElementProperties(this.getJObject(json, "_userId"), res.getUserIdElement());
        }
        if (json.has("patientId")) {
            res.setPatientIdElement(this.parseId(json.get("patientId").getAsString()));
        }
        if (json.has("_patientId")) {
            this.parseElementProperties(this.getJObject(json, "_patientId"), res.getPatientIdElement());
        }
        if (json.has("encounterId")) {
            res.setEncounterIdElement(this.parseId(json.get("encounterId").getAsString()));
        }
        if (json.has("_encounterId")) {
            this.parseElementProperties(this.getJObject(json, "_encounterId"), res.getEncounterIdElement());
        }
    }

    protected CDSHooksExtensions parseCDSHooksExtensions(JsonObject json) throws IOException, FHIRFormatError {
        CDSHooksExtensions res = new CDSHooksExtensions();
        this.parseCDSHooksExtensionsProperties(json, res);
        return res;
    }

    protected void parseCDSHooksExtensionsProperties(JsonObject json, CDSHooksExtensions res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
    }

    protected CDSHooksRequest parseCDSHooksRequest(JsonObject json) throws IOException, FHIRFormatError {
        CDSHooksRequest res = new CDSHooksRequest();
        this.parseCDSHooksRequestProperties(json, res);
        return res;
    }

    protected void parseCDSHooksRequestProperties(JsonObject json, CDSHooksRequest res) throws IOException, FHIRFormatError {
        this.parseCDSHooksElementProperties(json, res);
        if (json.has("hook")) {
            res.setHookElement(this.parseCode(json.get("hook").getAsString()));
        }
        if (json.has("_hook")) {
            this.parseElementProperties(this.getJObject(json, "_hook"), res.getHookElement());
        }
        if (json.has("hookInstance")) {
            res.setHookInstanceElement(this.parseUuid(json.get("hookInstance").getAsString()));
        }
        if (json.has("_hookInstance")) {
            this.parseElementProperties(this.getJObject(json, "_hookInstance"), res.getHookInstanceElement());
        }
        if (json.has("fhirServer")) {
            res.setFhirServerElement(this.parseUrl(json.get("fhirServer").getAsString()));
        }
        if (json.has("_fhirServer")) {
            this.parseElementProperties(this.getJObject(json, "_fhirServer"), res.getFhirServerElement());
        }
        if (json.has("fhirAuthorization")) {
            res.setFhirAuthorization(this.parseCDSHooksRequestFhirAuthorizationComponent(this.getJObject(json, "fhirAuthorization")));
        }
        if (json.has("context")) {
            res.setContext(this.parseCDSHookContext(json, this.getJObject(json, "context")));
        }
        if (json.has("prefetch")) {
            JsonArray array = this.getJArray(json, "prefetch");
            for (int i = 0; i < array.size(); ++i) {
                res.getPrefetch().add(this.parseCDSHooksRequestPrefetchComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CDSHookContext parseCDSHookContext(JsonObject resource, JsonObject json) throws IOException, FHIRFormatError {
        if (resource.get("hook").getAsString().equals("patient-view")) {
            return this.parseCDSHookPatientViewContext(json);
        }
        if (resource.get("hook").getAsString().equals("order-sign")) {
            return this.parseCDSHookOrderSignContext(json);
        }
        if (resource.get("hook").getAsString().equals("order-select")) {
            return this.parseCDSHookOrderSelectContext(json);
        }
        throw new FHIRFormatError("Unable to parse CDSHookContext: The content does not meet any of the type specifiers");
    }

    protected CDSHooksRequest.CDSHooksRequestFhirAuthorizationComponent parseCDSHooksRequestFhirAuthorizationComponent(JsonObject json) throws IOException, FHIRFormatError {
        CDSHooksRequest.CDSHooksRequestFhirAuthorizationComponent res = new CDSHooksRequest.CDSHooksRequestFhirAuthorizationComponent();
        this.parseCDSHooksRequestFhirAuthorizationComponentProperties(json, res);
        return res;
    }

    protected void parseCDSHooksRequestFhirAuthorizationComponentProperties(JsonObject json, CDSHooksRequest.CDSHooksRequestFhirAuthorizationComponent res) throws IOException, FHIRFormatError {
        if (json.has("accessToken")) {
            res.setAccessTokenElement(this.parseString(json.get("accessToken").getAsString()));
        }
        if (json.has("_accessToken")) {
            this.parseElementProperties(this.getJObject(json, "_accessToken"), res.getAccessTokenElement());
        }
        if (json.has("tokenType")) {
            res.setTokenTypeElement(this.parseCode(json.get("tokenType").getAsString()));
        }
        if (json.has("_tokenType")) {
            this.parseElementProperties(this.getJObject(json, "_tokenType"), res.getTokenTypeElement());
        }
        if (json.has("expiresIn")) {
            res.setExpiresInElement(this.parseInteger(json.get("expiresIn").getAsLong()));
        }
        if (json.has("_expiresIn")) {
            this.parseElementProperties(this.getJObject(json, "_expiresIn"), res.getExpiresInElement());
        }
        if (json.has("scope")) {
            res.setScopeElement(this.parseString(json.get("scope").getAsString()));
        }
        if (json.has("_scope")) {
            this.parseElementProperties(this.getJObject(json, "_scope"), res.getScopeElement());
        }
        if (json.has("subject")) {
            res.setSubjectElement(this.parseString(json.get("subject").getAsString()));
        }
        if (json.has("_subject")) {
            this.parseElementProperties(this.getJObject(json, "_subject"), res.getSubjectElement());
        }
        if (json.has("patient")) {
            res.setPatientElement(this.parseId(json.get("patient").getAsString()));
        }
        if (json.has("_patient")) {
            this.parseElementProperties(this.getJObject(json, "_patient"), res.getPatientElement());
        }
    }

    protected CDSHooksRequest.CDSHooksRequestPrefetchComponent parseCDSHooksRequestPrefetchComponent(JsonObject json) throws IOException, FHIRFormatError {
        CDSHooksRequest.CDSHooksRequestPrefetchComponent res = new CDSHooksRequest.CDSHooksRequestPrefetchComponent();
        this.parseCDSHooksRequestPrefetchComponentProperties(json, res);
        return res;
    }

    protected void parseCDSHooksRequestPrefetchComponentProperties(JsonObject json, CDSHooksRequest.CDSHooksRequestPrefetchComponent res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("key")) {
            res.setKeyElement(this.parseCode(json.get("key").getAsString()));
        }
        if (json.has("_key")) {
            this.parseElementProperties(this.getJObject(json, "_key"), res.getKeyElement());
        }
        if (json.has("value")) {
            res.setValue(this.parseResource(this.getJObject(json, "value")));
        }
    }

    protected CDSHooksResponse parseCDSHooksResponse(JsonObject json) throws IOException, FHIRFormatError {
        CDSHooksResponse res = new CDSHooksResponse();
        this.parseCDSHooksResponseProperties(json, res);
        return res;
    }

    protected void parseCDSHooksResponseProperties(JsonObject json, CDSHooksResponse res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseCDSHooksElementProperties(json, res);
        if (json.has("cards")) {
            array = this.getJArray(json, "cards");
            for (i = 0; i < array.size(); ++i) {
                res.getCards().add(this.parseCDSHooksResponseCardsComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("systemActions")) {
            array = this.getJArray(json, "systemActions");
            for (i = 0; i < array.size(); ++i) {
                res.getSystemActions().add(this.parseCDSHooksResponseCardsSuggestionsActionsComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CDSHooksResponse.CDSHooksResponseCardsComponent parseCDSHooksResponseCardsComponent(JsonObject json) throws IOException, FHIRFormatError {
        CDSHooksResponse.CDSHooksResponseCardsComponent res = new CDSHooksResponse.CDSHooksResponseCardsComponent();
        this.parseCDSHooksResponseCardsComponentProperties(json, res);
        return res;
    }

    protected void parseCDSHooksResponseCardsComponentProperties(JsonObject json, CDSHooksResponse.CDSHooksResponseCardsComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        if (json.has("uuid")) {
            res.setUuidElement(this.parseUuid(json.get("uuid").getAsString()));
        }
        if (json.has("_uuid")) {
            this.parseElementProperties(this.getJObject(json, "_uuid"), res.getUuidElement());
        }
        if (json.has("summary")) {
            res.setSummaryElement(this.parseString(json.get("summary").getAsString()));
        }
        if (json.has("_summary")) {
            this.parseElementProperties(this.getJObject(json, "_summary"), res.getSummaryElement());
        }
        if (json.has("detail")) {
            res.setDetailElement(this.parseMarkdown(json.get("detail").getAsString()));
        }
        if (json.has("_detail")) {
            this.parseElementProperties(this.getJObject(json, "_detail"), res.getDetailElement());
        }
        if (json.has("indicator")) {
            res.setIndicatorElement(this.parseEnumeration(json.get("indicator").getAsString(), CDSHooksResponse.CDSIndicatorCodesVS.NULL, new CDSHooksResponse.CDSIndicatorCodesVSEnumFactory()));
        }
        if (json.has("_indicator")) {
            this.parseElementProperties(this.getJObject(json, "_indicator"), res.getIndicatorElement());
        }
        if (json.has("source")) {
            res.setSource(this.parseCDSHooksResponseCardsSourceComponent(this.getJObject(json, "source")));
        }
        if (json.has("suggestions")) {
            array = this.getJArray(json, "suggestions");
            for (i = 0; i < array.size(); ++i) {
                res.getSuggestions().add(this.parseCDSHooksResponseCardsSuggestionsComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("selectionBehavior")) {
            res.setSelectionBehaviorElement(this.parseEnumeration(json.get("selectionBehavior").getAsString(), CDSHooksResponse.CDSSelectionBehaviorCodesVS.NULL, new CDSHooksResponse.CDSSelectionBehaviorCodesVSEnumFactory()));
        }
        if (json.has("_selectionBehavior")) {
            this.parseElementProperties(this.getJObject(json, "_selectionBehavior"), res.getSelectionBehaviorElement());
        }
        if (json.has("overrideReasons")) {
            array = this.getJArray(json, "overrideReasons");
            for (i = 0; i < array.size(); ++i) {
                res.getOverrideReasons().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("links")) {
            array = this.getJArray(json, "links");
            for (i = 0; i < array.size(); ++i) {
                res.getLinks().add(this.parseCDSHooksResponseCardsLinksComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CDSHooksResponse.CDSHooksResponseCardsSourceComponent parseCDSHooksResponseCardsSourceComponent(JsonObject json) throws IOException, FHIRFormatError {
        CDSHooksResponse.CDSHooksResponseCardsSourceComponent res = new CDSHooksResponse.CDSHooksResponseCardsSourceComponent();
        this.parseCDSHooksResponseCardsSourceComponentProperties(json, res);
        return res;
    }

    protected void parseCDSHooksResponseCardsSourceComponentProperties(JsonObject json, CDSHooksResponse.CDSHooksResponseCardsSourceComponent res) throws IOException, FHIRFormatError {
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(this.getJObject(json, "_label"), res.getLabelElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUrl(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("icon")) {
            res.setIconElement(this.parseUrl(json.get("icon").getAsString()));
        }
        if (json.has("_icon")) {
            this.parseElementProperties(this.getJObject(json, "_icon"), res.getIconElement());
        }
        if (json.has("topic")) {
            res.setTopic(this.parseCoding(this.getJObject(json, "topic")));
        }
    }

    protected CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent parseCDSHooksResponseCardsSuggestionsComponent(JsonObject json) throws IOException, FHIRFormatError {
        CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent res = new CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent();
        this.parseCDSHooksResponseCardsSuggestionsComponentProperties(json, res);
        return res;
    }

    protected void parseCDSHooksResponseCardsSuggestionsComponentProperties(JsonObject json, CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent res) throws IOException, FHIRFormatError {
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(this.getJObject(json, "_label"), res.getLabelElement());
        }
        if (json.has("uuid")) {
            res.setUuidElement(this.parseUuid(json.get("uuid").getAsString()));
        }
        if (json.has("_uuid")) {
            this.parseElementProperties(this.getJObject(json, "_uuid"), res.getUuidElement());
        }
        if (json.has("isRecommended")) {
            res.setIsRecommendedElement(this.parseBoolean(json.get("isRecommended").getAsBoolean()));
        }
        if (json.has("_isRecommended")) {
            this.parseElementProperties(this.getJObject(json, "_isRecommended"), res.getIsRecommendedElement());
        }
        if (json.has("actions")) {
            JsonArray array = this.getJArray(json, "actions");
            for (int i = 0; i < array.size(); ++i) {
                res.getActions().add(this.parseCDSHooksResponseCardsSuggestionsActionsComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent parseCDSHooksResponseCardsSuggestionsActionsComponent(JsonObject json) throws IOException, FHIRFormatError {
        CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent res = new CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent();
        this.parseCDSHooksResponseCardsSuggestionsActionsComponentProperties(json, res);
        return res;
    }

    protected void parseCDSHooksResponseCardsSuggestionsActionsComponentProperties(JsonObject json, CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent res) throws IOException, FHIRFormatError {
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), CDSHooksResponse.CDSActionTypeCodesVS.NULL, new CDSHooksResponse.CDSActionTypeCodesVSEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("resource")) {
            res.setResource(this.parseResource(this.getJObject(json, "resource")));
        }
        if (json.has("resourceId")) {
            res.setResourceIdElement(this.parseUrl(json.get("resourceId").getAsString()));
        }
        if (json.has("_resourceId")) {
            this.parseElementProperties(this.getJObject(json, "_resourceId"), res.getResourceIdElement());
        }
    }

    protected CDSHooksResponse.CDSHooksResponseCardsLinksComponent parseCDSHooksResponseCardsLinksComponent(JsonObject json) throws IOException, FHIRFormatError {
        CDSHooksResponse.CDSHooksResponseCardsLinksComponent res = new CDSHooksResponse.CDSHooksResponseCardsLinksComponent();
        this.parseCDSHooksResponseCardsLinksComponentProperties(json, res);
        return res;
    }

    protected void parseCDSHooksResponseCardsLinksComponentProperties(JsonObject json, CDSHooksResponse.CDSHooksResponseCardsLinksComponent res) throws IOException, FHIRFormatError {
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(this.getJObject(json, "_label"), res.getLabelElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUrl(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), CDSHooksResponse.CDSLinkTypeCodesVS.NULL, new CDSHooksResponse.CDSLinkTypeCodesVSEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("appContext")) {
            res.setAppContextElement(this.parseString(json.get("appContext").getAsString()));
        }
        if (json.has("_appContext")) {
            this.parseElementProperties(this.getJObject(json, "_appContext"), res.getAppContextElement());
        }
    }

    protected CDSHooksServices parseCDSHooksServices(JsonObject json) throws IOException, FHIRFormatError {
        CDSHooksServices res = new CDSHooksServices();
        this.parseCDSHooksServicesProperties(json, res);
        return res;
    }

    protected void parseCDSHooksServicesProperties(JsonObject json, CDSHooksServices res) throws IOException, FHIRFormatError {
        this.parseCDSHooksElementProperties(json, res);
        if (json.has("services")) {
            JsonArray array = this.getJArray(json, "services");
            for (int i = 0; i < array.size(); ++i) {
                res.getServices().add(this.parseCDSHooksServicesServicesComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CDSHooksServices.CDSHooksServicesServicesComponent parseCDSHooksServicesServicesComponent(JsonObject json) throws IOException, FHIRFormatError {
        CDSHooksServices.CDSHooksServicesServicesComponent res = new CDSHooksServices.CDSHooksServicesServicesComponent();
        this.parseCDSHooksServicesServicesComponentProperties(json, res);
        return res;
    }

    protected void parseCDSHooksServicesServicesComponentProperties(JsonObject json, CDSHooksServices.CDSHooksServicesServicesComponent res) throws IOException, FHIRFormatError {
        if (json.has("hook")) {
            res.setHookElement(this.parseString(json.get("hook").getAsString()));
        }
        if (json.has("_hook")) {
            this.parseElementProperties(this.getJObject(json, "_hook"), res.getHookElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("id")) {
            res.setIdElement(this.parseCode(json.get("id").getAsString()));
        }
        if (json.has("_id")) {
            this.parseElementProperties(this.getJObject(json, "_id"), res.getIdElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("usageRequirements")) {
            res.setUsageRequirementsElement(this.parseString(json.get("usageRequirements").getAsString()));
        }
        if (json.has("_usageRequirements")) {
            this.parseElementProperties(this.getJObject(json, "_usageRequirements"), res.getUsageRequirementsElement());
        }
        if (json.has("prefetch")) {
            JsonArray array = this.getJArray(json, "prefetch");
            for (int i = 0; i < array.size(); ++i) {
                res.getPrefetch().add(this.parseCDSHooksServicesServicesPrefetchComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CDSHooksServices.CDSHooksServicesServicesPrefetchComponent parseCDSHooksServicesServicesPrefetchComponent(JsonObject json) throws IOException, FHIRFormatError {
        CDSHooksServices.CDSHooksServicesServicesPrefetchComponent res = new CDSHooksServices.CDSHooksServicesServicesPrefetchComponent();
        this.parseCDSHooksServicesServicesPrefetchComponentProperties(json, res);
        return res;
    }

    protected void parseCDSHooksServicesServicesPrefetchComponentProperties(JsonObject json, CDSHooksServices.CDSHooksServicesServicesPrefetchComponent res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("key")) {
            res.setKeyElement(this.parseCode(json.get("key").getAsString()));
        }
        if (json.has("_key")) {
            this.parseElementProperties(this.getJObject(json, "_key"), res.getKeyElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected TestCases parseTestCases(JsonObject json) throws IOException, FHIRFormatError {
        TestCases res = new TestCases();
        this.parseTestCasesProperties(json, res);
        return res;
    }

    protected void parseTestCasesProperties(JsonObject json, TestCases res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("runner")) {
            res.setRunnerElement(this.parseUrl(json.get("runner").getAsString()));
        }
        if (json.has("_runner")) {
            this.parseElementProperties(this.getJObject(json, "_runner"), res.getRunnerElement());
        }
        if (json.has("mode")) {
            array = this.getJArray(json, "mode");
            for (i = 0; i < array.size(); ++i) {
                res.getMode().add(this.parseTestCasesModeComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("suite")) {
            array = this.getJArray(json, "suite");
            for (i = 0; i < array.size(); ++i) {
                res.getSuite().add(this.parseTestCasesSuiteComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected TestCases.TestCasesModeComponent parseTestCasesModeComponent(JsonObject json) throws IOException, FHIRFormatError {
        TestCases.TestCasesModeComponent res = new TestCases.TestCasesModeComponent();
        this.parseTestCasesModeComponentProperties(json, res);
        return res;
    }

    protected void parseTestCasesModeComponentProperties(JsonObject json, TestCases.TestCasesModeComponent res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseString(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
    }

    protected TestCases.TestCasesSuiteComponent parseTestCasesSuiteComponent(JsonObject json) throws IOException, FHIRFormatError {
        TestCases.TestCasesSuiteComponent res = new TestCases.TestCasesSuiteComponent();
        this.parseTestCasesSuiteComponentProperties(json, res);
        return res;
    }

    protected void parseTestCasesSuiteComponentProperties(JsonObject json, TestCases.TestCasesSuiteComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBaseProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseCode(json.get("mode").getAsString()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("resource")) {
            array = this.getJArray(json, "resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseTestCasesSuiteResourceComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("parameter")) {
            array = this.getJArray(json, "parameter");
            for (i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseTestCasesSuiteParameterComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("test")) {
            array = this.getJArray(json, "test");
            for (i = 0; i < array.size(); ++i) {
                res.getTest().add(this.parseTestCasesSuiteTestComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected TestCases.TestCasesSuiteResourceComponent parseTestCasesSuiteResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
        TestCases.TestCasesSuiteResourceComponent res = new TestCases.TestCasesSuiteResourceComponent();
        this.parseTestCasesSuiteResourceComponentProperties(json, res);
        return res;
    }

    protected void parseTestCasesSuiteResourceComponentProperties(JsonObject json, TestCases.TestCasesSuiteResourceComponent res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("file")) {
            res.setFileElement(this.parseString(json.get("file").getAsString()));
        }
        if (json.has("_file")) {
            this.parseElementProperties(this.getJObject(json, "_file"), res.getFileElement());
        }
        if (json.has("resource")) {
            res.setResource(this.parseResource(this.getJObject(json, "resource")));
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseCode(json.get("mode").getAsString()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
    }

    protected TestCases.TestCasesSuiteParameterComponent parseTestCasesSuiteParameterComponent(JsonObject json) throws IOException, FHIRFormatError {
        TestCases.TestCasesSuiteParameterComponent res = new TestCases.TestCasesSuiteParameterComponent();
        this.parseTestCasesSuiteParameterComponentProperties(json, res);
        return res;
    }

    protected void parseTestCasesSuiteParameterComponentProperties(JsonObject json, TestCases.TestCasesSuiteParameterComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBaseProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseCode(json.get("mode").getAsString()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
    }

    protected TestCases.TestCasesSuiteTestComponent parseTestCasesSuiteTestComponent(JsonObject json) throws IOException, FHIRFormatError {
        TestCases.TestCasesSuiteTestComponent res = new TestCases.TestCasesSuiteTestComponent();
        this.parseTestCasesSuiteTestComponentProperties(json, res);
        return res;
    }

    protected void parseTestCasesSuiteTestComponentProperties(JsonObject json, TestCases.TestCasesSuiteTestComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBaseProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("operation")) {
            res.setOperationElement(this.parseCode(json.get("operation").getAsString()));
        }
        if (json.has("_operation")) {
            this.parseElementProperties(this.getJObject(json, "_operation"), res.getOperationElement());
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseString(json.get("mode").getAsString()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("parameter")) {
            array = this.getJArray(json, "parameter");
            for (i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseTestCasesSuiteParameterComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("input")) {
            array = this.getJArray(json, "input");
            for (i = 0; i < array.size(); ++i) {
                res.getInput().add(this.parseTestCasesSuiteResourceComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("output")) {
            array = this.getJArray(json, "output");
            for (i = 0; i < array.size(); ++i) {
                res.getOutput().add(this.parseTestCasesSuiteResourceComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected void composeCDSHookContextProperties(CDSHookContext element) throws IOException {
        this.composeBaseProperties(element);
    }

    protected void composeCDSHooksElementProperties(CDSHooksElement element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasExtension()) {
            this.composeCDSHooksExtensions("extension", element.getExtension());
        }
    }

    protected void composeCDSHookOrderSelectContext(String name, CDSHookOrderSelectContext element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHookOrderSelectContextProperties(element);
            this.close();
        }
    }

    protected void composeCDSHookOrderSelectContextProperties(CDSHookOrderSelectContext element) throws IOException {
        this.composeCDSHookContextProperties(element);
        if (element.hasUserIdElement()) {
            this.composeUrlCore("userId", element.getUserIdElement(), false);
            this.composeUrlExtras("userId", element.getUserIdElement(), false);
        }
        if (element.hasPatientIdElement()) {
            this.composeIdCore("patientId", element.getPatientIdElement(), false);
            this.composeIdExtras("patientId", element.getPatientIdElement(), false);
        }
        if (element.hasEncounterIdElement()) {
            this.composeIdCore("encounterId", element.getEncounterIdElement(), false);
            this.composeIdExtras("encounterId", element.getEncounterIdElement(), false);
        }
        if (element.hasSelections()) {
            if (this.anyHasValue(element.getSelections())) {
                this.openArray("selections");
                for (UriType e : element.getSelections()) {
                    this.composeUriCore(null, e, e != element.getSelections().get(element.getSelections().size() - 1));
                }
                this.closeArray();
            }
            if (this.anyHasExtras(element.getSelections())) {
                this.openArray("_selections");
                for (UriType e : element.getSelections()) {
                    this.composeUriExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasDraftOrders()) {
            this.composeBundle("draftOrders", element.getDraftOrders());
        }
    }

    protected void composeCDSHookOrderSignContext(String name, CDSHookOrderSignContext element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHookOrderSignContextProperties(element);
            this.close();
        }
    }

    protected void composeCDSHookOrderSignContextProperties(CDSHookOrderSignContext element) throws IOException {
        this.composeCDSHookContextProperties(element);
        if (element.hasUserIdElement()) {
            this.composeUrlCore("userId", element.getUserIdElement(), false);
            this.composeUrlExtras("userId", element.getUserIdElement(), false);
        }
        if (element.hasPatientIdElement()) {
            this.composeIdCore("patientId", element.getPatientIdElement(), false);
            this.composeIdExtras("patientId", element.getPatientIdElement(), false);
        }
        if (element.hasEncounterIdElement()) {
            this.composeIdCore("encounterId", element.getEncounterIdElement(), false);
            this.composeIdExtras("encounterId", element.getEncounterIdElement(), false);
        }
        if (element.hasDraftOrders()) {
            this.composeBundle("draftOrders", element.getDraftOrders());
        }
    }

    protected void composeCDSHookPatientViewContext(String name, CDSHookPatientViewContext element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHookPatientViewContextProperties(element);
            this.close();
        }
    }

    protected void composeCDSHookPatientViewContextProperties(CDSHookPatientViewContext element) throws IOException {
        this.composeCDSHookContextProperties(element);
        if (element.hasUserIdElement()) {
            this.composeUrlCore("userId", element.getUserIdElement(), false);
            this.composeUrlExtras("userId", element.getUserIdElement(), false);
        }
        if (element.hasPatientIdElement()) {
            this.composeIdCore("patientId", element.getPatientIdElement(), false);
            this.composeIdExtras("patientId", element.getPatientIdElement(), false);
        }
        if (element.hasEncounterIdElement()) {
            this.composeIdCore("encounterId", element.getEncounterIdElement(), false);
            this.composeIdExtras("encounterId", element.getEncounterIdElement(), false);
        }
    }

    protected void composeCDSHooksExtensions(String name, CDSHooksExtensions element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHooksExtensionsProperties(element);
            this.close();
        }
    }

    protected void composeCDSHooksExtensionsProperties(CDSHooksExtensions element) throws IOException {
        this.composeElementProperties(element);
    }

    protected void composeCDSHooksRequest(String name, CDSHooksRequest element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHooksRequestProperties(element);
            this.close();
        }
    }

    protected void composeCDSHooksRequestProperties(CDSHooksRequest element) throws IOException {
        this.composeCDSHooksElementProperties(element);
        if (element.hasHookElement()) {
            this.composeCodeCore("hook", element.getHookElement(), false);
            this.composeCodeExtras("hook", element.getHookElement(), false);
        }
        if (element.hasHookInstanceElement()) {
            this.composeUuidCore("hookInstance", element.getHookInstanceElement(), false);
            this.composeUuidExtras("hookInstance", element.getHookInstanceElement(), false);
        }
        if (element.hasFhirServerElement()) {
            this.composeUrlCore("fhirServer", element.getFhirServerElement(), false);
            this.composeUrlExtras("fhirServer", element.getFhirServerElement(), false);
        }
        if (element.hasFhirAuthorization()) {
            this.composeCDSHooksRequestFhirAuthorizationComponent("fhirAuthorization", element.getFhirAuthorization());
        }
        if (element.hasContext()) {
            this.composeCDSHookContext("context", element.getContext());
        }
        if (element.hasPrefetch()) {
            this.openArray("prefetch");
            for (CDSHooksRequest.CDSHooksRequestPrefetchComponent e : element.getPrefetch()) {
                this.composeCDSHooksRequestPrefetchComponent(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeCDSHookContext(String name, CDSHookContext element) throws IOException {
        if (element instanceof CDSHookPatientViewContext) {
            this.composeCDSHookPatientViewContext(name, (CDSHookPatientViewContext)element);
        } else if (element instanceof CDSHookOrderSignContext) {
            this.composeCDSHookOrderSignContext(name, (CDSHookOrderSignContext)element);
        } else if (element instanceof CDSHookOrderSelectContext) {
            this.composeCDSHookOrderSelectContext(name, (CDSHookOrderSelectContext)element);
        } else {
            throw new FHIRFormatError("Unable to compose CDSHookContext: Unexpected type " + element.getClass().getName());
        }
    }

    protected void composeCDSHooksRequestFhirAuthorizationComponent(String name, CDSHooksRequest.CDSHooksRequestFhirAuthorizationComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHooksRequestFhirAuthorizationComponentProperties(element);
            this.close();
        }
    }

    protected void composeCDSHooksRequestFhirAuthorizationComponentProperties(CDSHooksRequest.CDSHooksRequestFhirAuthorizationComponent element) throws IOException {
        if (element.hasAccessTokenElement()) {
            this.composeStringCore("accessToken", element.getAccessTokenElement(), false);
            this.composeStringExtras("accessToken", element.getAccessTokenElement(), false);
        }
        if (element.hasTokenTypeElement()) {
            this.composeCodeCore("tokenType", element.getTokenTypeElement(), false);
            this.composeCodeExtras("tokenType", element.getTokenTypeElement(), false);
        }
        if (element.hasExpiresInElement()) {
            this.composeIntegerCore("expiresIn", element.getExpiresInElement(), false);
            this.composeIntegerExtras("expiresIn", element.getExpiresInElement(), false);
        }
        if (element.hasScopeElement()) {
            this.composeStringCore("scope", element.getScopeElement(), false);
            this.composeStringExtras("scope", element.getScopeElement(), false);
        }
        if (element.hasSubjectElement()) {
            this.composeStringCore("subject", element.getSubjectElement(), false);
            this.composeStringExtras("subject", element.getSubjectElement(), false);
        }
        if (element.hasPatientElement()) {
            this.composeIdCore("patient", element.getPatientElement(), false);
            this.composeIdExtras("patient", element.getPatientElement(), false);
        }
    }

    protected void composeCDSHooksRequestPrefetchComponent(String name, CDSHooksRequest.CDSHooksRequestPrefetchComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHooksRequestPrefetchComponentProperties(element);
            this.close();
        }
    }

    protected void composeCDSHooksRequestPrefetchComponentProperties(CDSHooksRequest.CDSHooksRequestPrefetchComponent element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasKeyElement()) {
            this.composeCodeCore("key", element.getKeyElement(), false);
            this.composeCodeExtras("key", element.getKeyElement(), false);
        }
        if (element.hasValue()) {
            this.open("value");
            this.composeResource(element.getValue());
            this.close();
        }
    }

    protected void composeCDSHooksResponse(String name, CDSHooksResponse element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHooksResponseProperties(element);
            this.close();
        }
    }

    protected void composeCDSHooksResponseProperties(CDSHooksResponse element) throws IOException {
        this.composeCDSHooksElementProperties(element);
        if (element.hasCards()) {
            this.openArray("cards");
            for (CDSHooksResponse.CDSHooksResponseCardsComponent cDSHooksResponseCardsComponent : element.getCards()) {
                this.composeCDSHooksResponseCardsComponent(null, cDSHooksResponseCardsComponent);
            }
            this.closeArray();
        }
        if (element.hasSystemActions()) {
            this.openArray("systemActions");
            for (CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent cDSHooksResponseCardsSuggestionsActionsComponent : element.getSystemActions()) {
                this.composeCDSHooksResponseCardsSuggestionsActionsComponent(null, cDSHooksResponseCardsSuggestionsActionsComponent);
            }
            this.closeArray();
        }
    }

    protected void composeCDSHooksResponseCardsComponent(String name, CDSHooksResponse.CDSHooksResponseCardsComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHooksResponseCardsComponentProperties(element);
            this.close();
        }
    }

    protected void composeCDSHooksResponseCardsComponentProperties(CDSHooksResponse.CDSHooksResponseCardsComponent element) throws IOException {
        if (element.hasUuidElement()) {
            this.composeUuidCore("uuid", element.getUuidElement(), false);
            this.composeUuidExtras("uuid", element.getUuidElement(), false);
        }
        if (element.hasSummaryElement()) {
            this.composeStringCore("summary", element.getSummaryElement(), false);
            this.composeStringExtras("summary", element.getSummaryElement(), false);
        }
        if (element.hasDetailElement()) {
            this.composeMarkdownCore("detail", element.getDetailElement(), false);
            this.composeMarkdownExtras("detail", element.getDetailElement(), false);
        }
        if (element.hasIndicatorElement()) {
            this.composeEnumerationCore("indicator", element.getIndicatorElement(), new CDSHooksResponse.CDSIndicatorCodesVSEnumFactory(), false);
            this.composeEnumerationExtras("indicator", element.getIndicatorElement(), new CDSHooksResponse.CDSIndicatorCodesVSEnumFactory(), false);
        }
        if (element.hasSource()) {
            this.composeCDSHooksResponseCardsSourceComponent("source", element.getSource());
        }
        if (element.hasSuggestions()) {
            this.openArray("suggestions");
            for (CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent cDSHooksResponseCardsSuggestionsComponent : element.getSuggestions()) {
                this.composeCDSHooksResponseCardsSuggestionsComponent(null, cDSHooksResponseCardsSuggestionsComponent);
            }
            this.closeArray();
        }
        if (element.hasSelectionBehaviorElement()) {
            this.composeEnumerationCore("selectionBehavior", element.getSelectionBehaviorElement(), new CDSHooksResponse.CDSSelectionBehaviorCodesVSEnumFactory(), false);
            this.composeEnumerationExtras("selectionBehavior", element.getSelectionBehaviorElement(), new CDSHooksResponse.CDSSelectionBehaviorCodesVSEnumFactory(), false);
        }
        if (element.hasOverrideReasons()) {
            this.openArray("overrideReasons");
            for (Coding coding : element.getOverrideReasons()) {
                this.composeCoding(null, coding);
            }
            this.closeArray();
        }
        if (element.hasLinks()) {
            this.openArray("links");
            for (CDSHooksResponse.CDSHooksResponseCardsLinksComponent cDSHooksResponseCardsLinksComponent : element.getLinks()) {
                this.composeCDSHooksResponseCardsLinksComponent(null, cDSHooksResponseCardsLinksComponent);
            }
            this.closeArray();
        }
    }

    protected void composeCDSHooksResponseCardsSourceComponent(String name, CDSHooksResponse.CDSHooksResponseCardsSourceComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHooksResponseCardsSourceComponentProperties(element);
            this.close();
        }
    }

    protected void composeCDSHooksResponseCardsSourceComponentProperties(CDSHooksResponse.CDSHooksResponseCardsSourceComponent element) throws IOException {
        if (element.hasLabelElement()) {
            this.composeStringCore("label", element.getLabelElement(), false);
            this.composeStringExtras("label", element.getLabelElement(), false);
        }
        if (element.hasUrlElement()) {
            this.composeUrlCore("url", element.getUrlElement(), false);
            this.composeUrlExtras("url", element.getUrlElement(), false);
        }
        if (element.hasIconElement()) {
            this.composeUrlCore("icon", element.getIconElement(), false);
            this.composeUrlExtras("icon", element.getIconElement(), false);
        }
        if (element.hasTopic()) {
            this.composeCoding("topic", element.getTopic());
        }
    }

    protected void composeCDSHooksResponseCardsSuggestionsComponent(String name, CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHooksResponseCardsSuggestionsComponentProperties(element);
            this.close();
        }
    }

    protected void composeCDSHooksResponseCardsSuggestionsComponentProperties(CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent element) throws IOException {
        if (element.hasLabelElement()) {
            this.composeStringCore("label", element.getLabelElement(), false);
            this.composeStringExtras("label", element.getLabelElement(), false);
        }
        if (element.hasUuidElement()) {
            this.composeUuidCore("uuid", element.getUuidElement(), false);
            this.composeUuidExtras("uuid", element.getUuidElement(), false);
        }
        if (element.hasIsRecommendedElement()) {
            this.composeBooleanCore("isRecommended", element.getIsRecommendedElement(), false);
            this.composeBooleanExtras("isRecommended", element.getIsRecommendedElement(), false);
        }
        if (element.hasActions()) {
            this.openArray("actions");
            for (CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent e : element.getActions()) {
                this.composeCDSHooksResponseCardsSuggestionsActionsComponent(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeCDSHooksResponseCardsSuggestionsActionsComponent(String name, CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHooksResponseCardsSuggestionsActionsComponentProperties(element);
            this.close();
        }
    }

    protected void composeCDSHooksResponseCardsSuggestionsActionsComponentProperties(CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent element) throws IOException {
        if (element.hasTypeElement()) {
            this.composeEnumerationCore("type", element.getTypeElement(), new CDSHooksResponse.CDSActionTypeCodesVSEnumFactory(), false);
            this.composeEnumerationExtras("type", element.getTypeElement(), new CDSHooksResponse.CDSActionTypeCodesVSEnumFactory(), false);
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasResource()) {
            this.open("resource");
            this.composeResource(element.getResource());
            this.close();
        }
        if (element.hasResourceIdElement()) {
            this.composeUrlCore("resourceId", element.getResourceIdElement(), false);
            this.composeUrlExtras("resourceId", element.getResourceIdElement(), false);
        }
    }

    protected void composeCDSHooksResponseCardsLinksComponent(String name, CDSHooksResponse.CDSHooksResponseCardsLinksComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHooksResponseCardsLinksComponentProperties(element);
            this.close();
        }
    }

    protected void composeCDSHooksResponseCardsLinksComponentProperties(CDSHooksResponse.CDSHooksResponseCardsLinksComponent element) throws IOException {
        if (element.hasLabelElement()) {
            this.composeStringCore("label", element.getLabelElement(), false);
            this.composeStringExtras("label", element.getLabelElement(), false);
        }
        if (element.hasUrlElement()) {
            this.composeUrlCore("url", element.getUrlElement(), false);
            this.composeUrlExtras("url", element.getUrlElement(), false);
        }
        if (element.hasTypeElement()) {
            this.composeEnumerationCore("type", element.getTypeElement(), new CDSHooksResponse.CDSLinkTypeCodesVSEnumFactory(), false);
            this.composeEnumerationExtras("type", element.getTypeElement(), new CDSHooksResponse.CDSLinkTypeCodesVSEnumFactory(), false);
        }
        if (element.hasAppContextElement()) {
            this.composeStringCore("appContext", element.getAppContextElement(), false);
            this.composeStringExtras("appContext", element.getAppContextElement(), false);
        }
    }

    protected void composeCDSHooksServices(String name, CDSHooksServices element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHooksServicesProperties(element);
            this.close();
        }
    }

    protected void composeCDSHooksServicesProperties(CDSHooksServices element) throws IOException {
        this.composeCDSHooksElementProperties(element);
        if (element.hasServices()) {
            this.openArray("services");
            for (CDSHooksServices.CDSHooksServicesServicesComponent e : element.getServices()) {
                this.composeCDSHooksServicesServicesComponent(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeCDSHooksServicesServicesComponent(String name, CDSHooksServices.CDSHooksServicesServicesComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHooksServicesServicesComponentProperties(element);
            this.close();
        }
    }

    protected void composeCDSHooksServicesServicesComponentProperties(CDSHooksServices.CDSHooksServicesServicesComponent element) throws IOException {
        if (element.hasHookElement()) {
            this.composeStringCore("hook", element.getHookElement(), false);
            this.composeStringExtras("hook", element.getHookElement(), false);
        }
        if (element.hasTitleElement()) {
            this.composeStringCore("title", element.getTitleElement(), false);
            this.composeStringExtras("title", element.getTitleElement(), false);
        }
        if (element.hasIdElement()) {
            this.composeCodeCore("id", element.getIdElement(), false);
            this.composeCodeExtras("id", element.getIdElement(), false);
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasUsageRequirementsElement()) {
            this.composeStringCore("usageRequirements", element.getUsageRequirementsElement(), false);
            this.composeStringExtras("usageRequirements", element.getUsageRequirementsElement(), false);
        }
        if (element.hasPrefetch()) {
            this.openArray("prefetch");
            for (CDSHooksServices.CDSHooksServicesServicesPrefetchComponent e : element.getPrefetch()) {
                this.composeCDSHooksServicesServicesPrefetchComponent(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeCDSHooksServicesServicesPrefetchComponent(String name, CDSHooksServices.CDSHooksServicesServicesPrefetchComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCDSHooksServicesServicesPrefetchComponentProperties(element);
            this.close();
        }
    }

    protected void composeCDSHooksServicesServicesPrefetchComponentProperties(CDSHooksServices.CDSHooksServicesServicesPrefetchComponent element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasKeyElement()) {
            this.composeCodeCore("key", element.getKeyElement(), false);
            this.composeCodeExtras("key", element.getKeyElement(), false);
        }
        if (element.hasValueElement()) {
            this.composeStringCore("value", element.getValueElement(), false);
            this.composeStringExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeTestCases(String name, TestCases element) throws IOException {
        if (element != null) {
            this.prop("resourceType", "TestCases");
            this.composeTestCasesProperties(element);
        }
    }

    protected void composeTestCasesProperties(TestCases element) throws IOException {
        this.composeResourceProperties(element);
        if (element.hasUrlElement()) {
            this.composeUriCore("url", element.getUrlElement(), false);
            this.composeUriExtras("url", element.getUrlElement(), false);
        }
        if (element.hasVersionElement()) {
            this.composeStringCore("version", element.getVersionElement(), false);
            this.composeStringExtras("version", element.getVersionElement(), false);
        }
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdownCore("description", element.getDescriptionElement(), false);
            this.composeMarkdownExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasRunnerElement()) {
            this.composeUrlCore("runner", element.getRunnerElement(), false);
            this.composeUrlExtras("runner", element.getRunnerElement(), false);
        }
        if (element.hasMode()) {
            this.openArray("mode");
            for (TestCases.TestCasesModeComponent testCasesModeComponent : element.getMode()) {
                this.composeTestCasesModeComponent(null, testCasesModeComponent);
            }
            this.closeArray();
        }
        if (element.hasSuite()) {
            this.openArray("suite");
            for (TestCases.TestCasesSuiteComponent testCasesSuiteComponent : element.getSuite()) {
                this.composeTestCasesSuiteComponent(null, testCasesSuiteComponent);
            }
            this.closeArray();
        }
    }

    protected void composeTestCasesModeComponent(String name, TestCases.TestCasesModeComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeTestCasesModeComponentProperties(element);
            this.close();
        }
    }

    protected void composeTestCasesModeComponentProperties(TestCases.TestCasesModeComponent element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasCodeElement()) {
            this.composeStringCore("code", element.getCodeElement(), false);
            this.composeStringExtras("code", element.getCodeElement(), false);
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
    }

    protected void composeTestCasesSuiteComponent(String name, TestCases.TestCasesSuiteComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeTestCasesSuiteComponentProperties(element);
            this.close();
        }
    }

    protected void composeTestCasesSuiteComponentProperties(TestCases.TestCasesSuiteComponent element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasModeElement()) {
            this.composeCodeCore("mode", element.getModeElement(), false);
            this.composeCodeExtras("mode", element.getModeElement(), false);
        }
        if (element.hasResource()) {
            this.openArray("resource");
            for (TestCases.TestCasesSuiteResourceComponent testCasesSuiteResourceComponent : element.getResource()) {
                this.composeTestCasesSuiteResourceComponent(null, testCasesSuiteResourceComponent);
            }
            this.closeArray();
        }
        if (element.hasParameter()) {
            this.openArray("parameter");
            for (TestCases.TestCasesSuiteParameterComponent testCasesSuiteParameterComponent : element.getParameter()) {
                this.composeTestCasesSuiteParameterComponent(null, testCasesSuiteParameterComponent);
            }
            this.closeArray();
        }
        if (element.hasTest()) {
            this.openArray("test");
            for (TestCases.TestCasesSuiteTestComponent testCasesSuiteTestComponent : element.getTest()) {
                this.composeTestCasesSuiteTestComponent(null, testCasesSuiteTestComponent);
            }
            this.closeArray();
        }
    }

    protected void composeTestCasesSuiteResourceComponent(String name, TestCases.TestCasesSuiteResourceComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeTestCasesSuiteResourceComponentProperties(element);
            this.close();
        }
    }

    protected void composeTestCasesSuiteResourceComponentProperties(TestCases.TestCasesSuiteResourceComponent element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasFileElement()) {
            this.composeStringCore("file", element.getFileElement(), false);
            this.composeStringExtras("file", element.getFileElement(), false);
        }
        if (element.hasResource()) {
            this.open("resource");
            this.composeResource(element.getResource());
            this.close();
        }
        if (element.hasModeElement()) {
            this.composeCodeCore("mode", element.getModeElement(), false);
            this.composeCodeExtras("mode", element.getModeElement(), false);
        }
    }

    protected void composeTestCasesSuiteParameterComponent(String name, TestCases.TestCasesSuiteParameterComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeTestCasesSuiteParameterComponentProperties(element);
            this.close();
        }
    }

    protected void composeTestCasesSuiteParameterComponentProperties(TestCases.TestCasesSuiteParameterComponent element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasValue()) {
            this.composeType("value", element.getValue());
        }
        if (element.hasModeElement()) {
            this.composeCodeCore("mode", element.getModeElement(), false);
            this.composeCodeExtras("mode", element.getModeElement(), false);
        }
    }

    protected void composeTestCasesSuiteTestComponent(String name, TestCases.TestCasesSuiteTestComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeTestCasesSuiteTestComponentProperties(element);
            this.close();
        }
    }

    protected void composeTestCasesSuiteTestComponentProperties(TestCases.TestCasesSuiteTestComponent element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasOperationElement()) {
            this.composeCodeCore("operation", element.getOperationElement(), false);
            this.composeCodeExtras("operation", element.getOperationElement(), false);
        }
        if (element.hasModeElement()) {
            this.composeStringCore("mode", element.getModeElement(), false);
            this.composeStringExtras("mode", element.getModeElement(), false);
        }
        if (element.hasParameter()) {
            this.openArray("parameter");
            for (TestCases.TestCasesSuiteParameterComponent testCasesSuiteParameterComponent : element.getParameter()) {
                this.composeTestCasesSuiteParameterComponent(null, testCasesSuiteParameterComponent);
            }
            this.closeArray();
        }
        if (element.hasInput()) {
            this.openArray("input");
            for (TestCases.TestCasesSuiteResourceComponent testCasesSuiteResourceComponent : element.getInput()) {
                this.composeTestCasesSuiteResourceComponent(null, testCasesSuiteResourceComponent);
            }
            this.closeArray();
        }
        if (element.hasOutput()) {
            this.openArray("output");
            for (TestCases.TestCasesSuiteResourceComponent testCasesSuiteResourceComponent : element.getOutput()) {
                this.composeTestCasesSuiteResourceComponent(null, testCasesSuiteResourceComponent);
            }
            this.closeArray();
        }
    }

    @Override
    protected void composeResource(Resource resource) throws IOException {
        if (resource == null) {
            throw new Error("Unhandled resource type " + resource.getClass().getName());
        }
        if (!(resource instanceof TestCases)) {
            throw new Error("Unhandled resource type " + resource.getClass().getName());
        }
        this.composeTestCases("TestCases", (TestCases)resource);
    }
}

