/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.utilities.Utilities;

public class CapabilityStatementUtilities {
    private IWorkerContext context;

    public CapabilityStatementUtilities(IWorkerContext context) {
        this.context = context;
    }

    public CapabilityStatement resolveImports(CapabilityStatement targetCS) throws FHIRException {
        CapabilityStatement resolvedCS = targetCS.copy();
        return this.resolveImports(resolvedCS, new HashMap<String, String>(), "SHALL");
    }

    public CapabilityStatement resolveImports(CapabilityStatement targetCS, Map<String, String> importedUrls, String conformance) throws FHIRException {
        if (!targetCS.hasImports()) {
            return targetCS;
        }
        CapabilityStatement resolvedCS = targetCS.copy();
        for (CanonicalType canonical : resolvedCS.getImports()) {
            CapabilityStatement importedCS = this.context.fetchResource(CapabilityStatement.class, (String)canonical.getValue());
            if (importedCS == null) {
                throw new FHIRException("Unable to resolve CapabilityStatement " + (String)canonical.getValue() + " imported by " + targetCS.getUrl());
            }
            String importConformance = this.effectiveConformance(canonical.getExtensionString("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation"), conformance);
            if (importedUrls.containsKey(canonical.getValue()) && !importedUrls.get(canonical.getValue()).equals(importConformance)) {
                throw new FHIRException("The CapabilityStatement " + (String)canonical.getValue() + " is imported with different strengths - " + importedUrls.get(canonical.getValue()).equals(importConformance) + ", " + importConformance + (String)(importConformance.equals(canonical.getExtensionString("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation")) ? "" : "(effective from " + canonical.getExtensionString("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation") + ")"));
            }
            importedUrls.put(targetCS.getUrl(), importConformance);
            CapabilityStatement mergedImportedCS = this.resolveImports(importedCS, importedUrls, importConformance);
            this.mergeCS(resolvedCS, mergedImportedCS, importConformance);
        }
        return resolvedCS;
    }

    protected void mergeCS(CapabilityStatement targetCS, CapabilityStatement importedCS, String maxConformance) {
        this.merge(targetCS.getFormat(), importedCS.getFormat(), maxConformance, "format");
        this.merge(targetCS.getPatchFormat(), importedCS.getPatchFormat(), maxConformance, "patchFormat");
        this.merge(targetCS.getAcceptLanguage(), importedCS.getAcceptLanguage(), maxConformance, "acceptLanguage");
        this.merge(targetCS.getImplementationGuide(), importedCS.getImplementationGuide(), maxConformance, "implementationGuide");
        this.merge(targetCS.getRest(), importedCS.getRest(), maxConformance, "rest");
        if (targetCS.getMessaging().size() > 1) {
            throw new FHIRException("Unable to handle messaging repetitions greater than one for importing Capability Statement - use one repetition with multiple messaging.supportedMessage elements.");
        }
        if (importedCS.getMessaging().size() > 1) {
            throw new FHIRException("Unable to handle messaging repetitions greater than one for imported Capability Statement - use one repetition with multiple messaging.supportedMessage elements.");
        }
        if (importedCS.hasMessaging()) {
            if (!targetCS.hasMessaging()) {
                targetCS.setMessaging(importedCS.getMessaging());
            } else {
                CapabilityStatement.CapabilityStatementMessagingComponent targetMessaging = targetCS.getMessaging().get(0);
                CapabilityStatement.CapabilityStatementMessagingComponent importedMessaging = importedCS.getMessaging().get(0);
                this.merge(targetMessaging.getReliableCacheElement(), importedMessaging.getReliableCacheElement(), maxConformance, "messaging.reliableCache");
                if (importedMessaging.hasEndpoint()) {
                    throw new FHIRException("Importing capability statements that assert endpoints is not supported");
                }
                this.merge(targetMessaging.getSupportedMessage(), importedMessaging.getSupportedMessage(), maxConformance, "messaging.supportedMessage");
            }
        }
        this.merge(targetCS.getMessaging(), importedCS.getMessaging(), maxConformance, "messaging");
        this.merge(targetCS.getDocument(), importedCS.getDocument(), maxConformance, "messaging");
    }

    void mergeProperties(CapabilityStatement.CapabilityStatementRestComponent targetType, CapabilityStatement.CapabilityStatementRestComponent importedType, String maxConformance, String context) {
        String localContext = context + "." + String.valueOf((Object)targetType.getMode());
        this.merge(targetType.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-declared-profile"), importedType.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-declared-profile"), maxConformance, ".extension(DeclaredProfile)");
        this.merge(targetType.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"), importedType.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"), maxConformance, ".extension(SearchMode)");
        if (!targetType.hasSecurity()) {
            targetType.setSecurity(importedType.getSecurity());
        } else {
            if (!importedType.hasSecurity()) {
                return;
            }
            this.mergeProperties(targetType.getSecurity(), importedType.getSecurity(), maxConformance, localContext);
            this.mergeExpectations(targetType.getSecurity(), importedType.getSecurity(), maxConformance);
        }
        this.merge(targetType.getResource(), importedType.getResource(), maxConformance, localContext + ".resource");
        this.merge(targetType.getInteraction(), importedType.getInteraction(), maxConformance, localContext + ".interaction");
        this.merge(targetType.getOperation(), importedType.getOperation(), maxConformance, localContext + ".operation");
        this.merge(targetType.getSearchParam(), importedType.getSearchParam(), maxConformance, localContext + ".searchParam");
    }

    void mergeProperties(CapabilityStatement.CapabilityStatementRestSecurityComponent targetType, CapabilityStatement.CapabilityStatementRestSecurityComponent importedType, String maxConformance, String context) {
        this.merge(targetType.getCorsElement(), importedType.getCorsElement(), maxConformance, context + ".cors");
        this.merge(targetType.getService(), importedType.getService(), maxConformance, context + ".service");
    }

    void mergeProperties(CapabilityStatement.CapabilityStatementRestResourceComponent targetType, CapabilityStatement.CapabilityStatementRestResourceComponent importedType, String maxConformance, String context) throws FHIRException {
        String localContext = context + "." + targetType.getType();
        if (targetType.hasProfile() && importedType.hasProfile() && !targetType.getProfile().equals(importedType.getProfile())) {
            throw new FHIRException("Conflicting resource profiles for " + localContext + ".  If both the importing and imported CapabilityStatement declare profiles for the same resource, those profiles must be the same.Importing: " + targetType.getProfile() + "; Imported: " + importedType.getProfile());
        }
        this.merge(targetType.getSupportedProfile(), importedType.getSupportedProfile(), maxConformance, localContext + ".supportedProfile");
        targetType.setVersioningElement(this.merge(targetType.getVersioningElement(), importedType.getVersioningElement(), maxConformance, localContext + ".versioning"));
        this.merge(targetType.getInteraction(), importedType.getInteraction(), maxConformance, localContext + ".interaction");
        targetType.setReadHistoryElement(this.merge(targetType.getReadHistoryElement(), importedType.getReadHistoryElement(), maxConformance, localContext + ".readHistory"));
        targetType.setUpdateCreateElement(this.merge(targetType.getUpdateCreateElement(), importedType.getUpdateCreateElement(), maxConformance, localContext + ".updateCreate"));
        targetType.setConditionalCreateElement(this.merge(targetType.getConditionalCreateElement(), importedType.getConditionalCreateElement(), maxConformance, localContext + ".conditionalCreate"));
        targetType.setConditionalReadElement(this.merge(targetType.getConditionalReadElement(), importedType.getConditionalReadElement(), maxConformance, localContext + ".conditionalRead"));
        targetType.setConditionalPatchElement(this.merge(targetType.getConditionalPatchElement(), importedType.getConditionalPatchElement(), maxConformance, localContext + ".conditionalPatch"));
        targetType.setConditionalDeleteElement(this.merge(targetType.getConditionalDeleteElement(), importedType.getConditionalDeleteElement(), maxConformance, localContext + ".conditionalDelete"));
        this.merge(targetType.getReferencePolicy(), importedType.getReferencePolicy(), maxConformance, localContext + ".referencePolicy");
        this.merge(targetType.getSearchInclude(), importedType.getSearchInclude(), maxConformance, localContext + ".searchInclude");
        this.merge(targetType.getSearchRevInclude(), importedType.getSearchRevInclude(), maxConformance, localContext + ".searchRevInclude");
        this.merge(targetType.getSearchParam(), importedType.getSearchParam(), maxConformance, localContext + ".searchParam");
        this.merge(targetType.getOperation(), importedType.getOperation(), maxConformance, localContext + ".operation");
    }

    void mergeProperties(CapabilityStatement.CapabilityStatementRestResourceOperationComponent targetType, CapabilityStatement.CapabilityStatementRestResourceOperationComponent importedType, String context) throws FHIRException {
        String localContext = context + "(name=" + targetType.getName() + ")";
        if (importedType.hasDefinition()) {
            if (!targetType.hasDefinition()) {
                targetType.setDefinitionElement(importedType.getDefinitionElement());
            } else if (!targetType.getDefinition().equals(importedType.getDefinition())) {
                throw new FHIRException("Differing definitions for same operation " + localContext + " in imported IG.  Importing:" + targetType.getDefinition() + "; imported:" + importedType.getDefinition());
            }
        }
    }

    void mergeProperties(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent targetType, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent importedType, String maxConformance, String context) throws FHIRException {
        String localContext = context + "(name=" + targetType.getName() + ")";
        if (importedType.hasDefinition()) {
            if (!targetType.hasDefinition()) {
                targetType.setDefinitionElement((CanonicalType)this.fixMax(importedType.getDefinitionElement(), maxConformance));
            } else if (!targetType.getDefinition().equals(importedType.getDefinition())) {
                throw new FHIRException("Differing definitions for same Search parameter " + localContext + " in imported IG.  Importing:" + targetType.getDefinition() + "; imported:" + importedType.getDefinition());
            }
        }
        if (importedType.hasType()) {
            if (!targetType.hasType()) {
                targetType.setTypeElement((Enumeration)this.fixMax(importedType.getTypeElement(), maxConformance));
            } else if (!targetType.getType().equals((Object)importedType.getType())) {
                throw new FHIRException("Differing search types for same Search parameter " + localContext + " in imported IG.  Importing:" + String.valueOf((Object)targetType.getType()) + "; imported:" + String.valueOf((Object)importedType.getType()));
            }
        }
    }

    void mergeProperties(CapabilityStatement.CapabilityStatementMessagingComponent targetType, CapabilityStatement.CapabilityStatementMessagingComponent importedType, String maxConformance, String context) throws FHIRException {
        if (importedType.hasEndpoint()) {
            throw new FHIRException("Cannot handle importing messaging with declared endpoints");
        }
        targetType.setReliableCacheElement(this.merge(targetType.getReliableCacheElement(), importedType.getReliableCacheElement(), maxConformance, context + ".reliableCache"));
        this.merge(targetType.getSupportedMessage(), importedType.getSupportedMessage(), maxConformance, context + ".reliableCache");
    }

    void merge(List targetList, List importedList, String context) throws FHIRException {
        this.merge(targetList, importedList, "SHALL", context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void merge(List targetList, List importedList, String maxConformance, String context) throws FHIRException {
        for (Object importedType : importedList) {
            Object foundType = null;
            for (Object targetType : targetList) {
                boolean match;
                if (targetType instanceof PrimitiveType) {
                    match = importedType.toString().equals(targetType.toString());
                } else if (importedType instanceof CodeableConcept) {
                    match = this.match((CodeableConcept)targetType, (CodeableConcept)importedType);
                } else if (importedType instanceof CapabilityStatement.CapabilityStatementRestComponent) {
                    match = ((CapabilityStatement.CapabilityStatementRestComponent)targetType).getMode().equals((Object)((CapabilityStatement.CapabilityStatementRestComponent)importedType).getMode());
                } else if (importedType instanceof CapabilityStatement.CapabilityStatementRestResourceComponent) {
                    match = ((CapabilityStatement.CapabilityStatementRestResourceComponent)targetType).getType().equals(((CapabilityStatement.CapabilityStatementRestResourceComponent)importedType).getType());
                } else if (importedType instanceof CapabilityStatement.CapabilityStatementRestResourceOperationComponent) {
                    match = ((CapabilityStatement.CapabilityStatementRestResourceOperationComponent)targetType).getName().equals(((CapabilityStatement.CapabilityStatementRestResourceOperationComponent)importedType).getName());
                } else if (importedType instanceof CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent) {
                    match = ((CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent)targetType).getName().equals(((CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent)importedType).getName());
                } else if (importedType instanceof CapabilityStatement.CapabilityStatementMessagingComponent) {
                    match = true;
                } else if (importedType instanceof CapabilityStatement.ResourceInteractionComponent) {
                    match = ((CapabilityStatement.ResourceInteractionComponent)targetType).getCode().equals((Object)((CapabilityStatement.ResourceInteractionComponent)importedType).getCode());
                } else if (importedType instanceof CapabilityStatement.SystemInteractionComponent) {
                    match = ((CapabilityStatement.SystemInteractionComponent)targetType).getCode().equals((Object)((CapabilityStatement.SystemInteractionComponent)importedType).getCode());
                } else if (importedType instanceof CapabilityStatement.CapabilityStatementDocumentComponent) {
                    match = ((CapabilityStatement.CapabilityStatementDocumentComponent)targetType).getMode().equals((Object)((CapabilityStatement.CapabilityStatementDocumentComponent)importedType).getMode()) && ((CapabilityStatement.CapabilityStatementDocumentComponent)targetType).getProfile().equals(((CapabilityStatement.CapabilityStatementDocumentComponent)importedType).getProfile());
                } else if (importedType instanceof CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent) {
                    match = ((CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent)targetType).getMode().equals((Object)((CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent)importedType).getMode()) && ((CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent)targetType).getDefinition().equals(((CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent)importedType).getDefinition());
                } else {
                    if (!(importedType instanceof Extension)) throw new Error("Unhandled complex type in List match");
                    if (((Extension)importedType).getUrl().equals("http://hl7.org/fhir/StructureDefinition/capabilitystatement-declared-profile")) {
                        match = ((String)((Extension)targetType).getValueCanonicalType().getValue()).equals(((Extension)importedType).getValueCanonicalType().getValue());
                    } else {
                        if (!((Extension)importedType).getUrl().equals("http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination")) throw new Error("Unexpected extension " + ((Extension)importedType).getUrl());
                        match = this.requiredSort(targetType).equals(this.requiredSort(importedType));
                    }
                }
                if (!match) continue;
                foundType = targetType;
                break;
            }
            if (foundType == null) {
                targetList.add(importedType);
                continue;
            }
            if (!(importedType instanceof PrimitiveType)) {
                if (importedType instanceof CapabilityStatement.CapabilityStatementRestComponent) {
                    this.mergeProperties(foundType, (CapabilityStatement.CapabilityStatementRestComponent)importedType, maxConformance, context);
                } else if (importedType instanceof CapabilityStatement.CapabilityStatementRestResourceComponent) {
                    this.mergeProperties(foundType, (CapabilityStatement.CapabilityStatementRestResourceComponent)importedType, maxConformance, context);
                } else if (importedType instanceof CapabilityStatement.CapabilityStatementRestResourceOperationComponent) {
                    this.mergeProperties(foundType, (CapabilityStatement.CapabilityStatementRestResourceOperationComponent)importedType, context);
                } else if (importedType instanceof CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent) {
                    this.mergeProperties(foundType, (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent)importedType, maxConformance, context);
                } else if (!(importedType instanceof CapabilityStatement.ResourceInteractionComponent || importedType instanceof CapabilityStatement.SystemInteractionComponent || importedType instanceof CapabilityStatement.CapabilityStatementDocumentComponent)) {
                    if (importedType instanceof CapabilityStatement.CapabilityStatementMessagingComponent) {
                        this.mergeProperties(foundType, (CapabilityStatement.CapabilityStatementMessagingComponent)importedType, maxConformance, context);
                    } else if (!(importedType instanceof CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent) && importedType instanceof Extension && !((Extension)importedType).getUrl().equals("http://hl7.org/fhir/StructureDefinition/capabilitystatement-declared-profile") && ((Extension)importedType).getUrl().equals("http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination")) {
                        this.mergeSearchComboExt(foundType, (Extension)importedType, context + ".extension(SearchCombo - " + this.requiredSort(importedType) + ")");
                    }
                }
            }
            this.mergeExpectations(foundType, (Element)importedType, maxConformance);
        }
    }

    private boolean match(CodeableConcept a, CodeableConcept b) {
        if (!(!a.hasText() && !b.hasText() || a.hasText() == b.hasText() && a.getText().equals(b.getText()))) {
            return false;
        }
        if (a.getCoding().size() != b.getCoding().size()) {
            return false;
        }
        for (Coding codeA : a.getCoding()) {
            boolean codingMatch = false;
            for (Coding codeB : b.getCoding()) {
                if (codeA.hasSystem() != codeB.hasSystem() || codeA.hasSystem() && !codeA.getSystem().equals(codeB.getSystem()) || codeA.hasCode() != codeB.hasCode() || codeA.hasCode() && !codeA.getCode().equals(codeB.getCode()) || codeA.hasVersion() != codeB.hasVersion() || codeA.hasVersion() && !codeA.getVersion().equals(codeB.getVersion())) continue;
                codingMatch = true;
                break;
            }
            if (codingMatch) continue;
            return false;
        }
        return true;
    }

    private List<String> extensionValueList(Extension sortExtension, String url) {
        ArrayList<String> aList = new ArrayList<String>();
        for (Extension e : sortExtension.getExtensionsByUrl(url)) {
            aList.add(e.getValueStringType().toString());
        }
        aList.sort((Comparator<String>)new Utilities.CaseInsensitiveSorter());
        return aList;
    }

    private String requiredSort(Object sortExtension) {
        return String.join((CharSequence)";", this.extensionValueList((Extension)sortExtension, "required"));
    }

    private void mergeSearchComboExt(Extension targetExt, Extension importedExt, String context) {
        List<String> importedList;
        List<String> targetList = this.extensionValueList(targetExt, "otional");
        if (!targetList.containsAll(importedList = this.extensionValueList(importedExt, "otional"))) {
            throw new FHIRException("Search Options extension for " + context + " does not contain all of the optional search names from the imported CapabilityStatement, which is not supported.");
        }
    }

    private UnsignedIntType merge(UnsignedIntType targetInt, UnsignedIntType importedInt, String context) throws FHIRException {
        return this.merge(targetInt, importedInt, "SHALL", context);
    }

    private UnsignedIntType merge(UnsignedIntType targetInt, UnsignedIntType importedInt, String maxConformance, String context) throws FHIRException {
        if (targetInt == null) {
            return importedInt;
        }
        if (importedInt == null) {
            return (UnsignedIntType)this.fixMax(targetInt, context);
        }
        if (((Integer)targetInt.getValue()).equals(importedInt.getValue())) {
            this.mergeExpectations(targetInt, importedInt, maxConformance);
            return targetInt;
        }
        if (targetInt.hasExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation") && importedInt.hasExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation")) {
            String importedExpectation;
            String targetExpectation = targetInt.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation").getValueCodeType().getCode();
            if (targetExpectation.equals(importedExpectation = importedInt.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation").getValueCodeType().getCode())) {
                if (targetExpectation.equals("SHALL")) {
                    throw new FHIRException("Non matching enumeration values with SHALL conformance expectations for " + context + " - base CapabilityStatement:" + String.valueOf(targetInt.getValue()) + "; imported CapabilityStatement:" + String.valueOf(importedInt.getValue()));
                }
                if ((Integer)targetInt.getValue() > (Integer)importedInt.getValue()) {
                    return targetInt;
                }
                return (UnsignedIntType)this.fixMax(importedInt, maxConformance);
            }
            if (targetExpectation.equals("SHALL")) {
                return targetInt;
            }
            if (importedExpectation.equals("SHALL")) {
                return (UnsignedIntType)this.fixMax(importedInt, maxConformance);
            }
            if ((Integer)targetInt.getValue() > (Integer)importedInt.getValue()) {
                return targetInt;
            }
            return importedInt;
        }
        throw new FHIRException("Non matching integer values for " + context + " - base CapabilityStatement:" + String.valueOf(targetInt.getValue()) + "; imported CapabilityStatement:" + String.valueOf(importedInt.getValue()));
    }

    private Enumeration merge(Enumeration targetCode, Enumeration importedCode, String context) throws FHIRException {
        return this.merge(targetCode, importedCode, "SHALL", context);
    }

    private Enumeration merge(Enumeration targetCode, Enumeration importedCode, String maxConformance, String context) throws FHIRException {
        if (targetCode == null || targetCode.getCode() == null) {
            return (Enumeration)this.fixMax(importedCode, maxConformance);
        }
        if (importedCode == null || importedCode.getCode() == null) {
            return targetCode;
        }
        if (targetCode.getValue().equals(importedCode.getValue())) {
            this.mergeExpectations(targetCode, importedCode, maxConformance);
            return targetCode;
        }
        if (targetCode.hasExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation") && importedCode.hasExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation")) {
            String targetExpectation = targetCode.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation").getValueCodeType().getCode();
            String importedExpectation = importedCode.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation").getValueCodeType().getCode();
            int targetWeight = this.weightForEnum(targetCode, context);
            int importedWeight = this.weightForEnum(importedCode, context);
            if (targetExpectation.equals(importedExpectation)) {
                if (targetExpectation.equals("SHALL")) {
                    throw new FHIRException("Non matching enumeration values with SHALL conformance expectations for " + context + " - base CapabilityStatement:" + String.valueOf(targetCode.getValue()) + "; imported CapabilityStatement:" + String.valueOf(importedCode.getValue()));
                }
                if (targetWeight == importedWeight) {
                    throw new FHIRException("Non matching enumeration values with equivalent weight and identical conformance expectations for " + context + " - base CapabilityStatement:" + String.valueOf(targetCode.getValue()) + "; imported CapabilityStatement:" + String.valueOf(importedCode.getValue()));
                }
                if (targetWeight > importedWeight) {
                    return targetCode;
                }
                return (Enumeration)this.fixMax(importedCode, maxConformance);
            }
            if (targetExpectation.equals("SHALL")) {
                return targetCode;
            }
            if (importedExpectation.equals("SHALL")) {
                return (Enumeration)this.fixMax(importedCode, maxConformance);
            }
            if (targetWeight == importedWeight) {
                throw new FHIRException("Non matching enumeration values with equivalent weight and optional conformance expectations for " + context + " - base CapabilityStatement:" + String.valueOf(targetCode.getValue()) + "; imported CapabilityStatement:" + String.valueOf(importedCode.getValue()));
            }
            if (targetWeight > importedWeight) {
                return targetCode;
            }
            return (Enumeration)this.fixMax(importedCode, maxConformance);
        }
        throw new FHIRException("Non matching code values for " + context + " - base CapabilityStatement:" + targetCode.getCode() + "; imported CapabilityStatement:" + importedCode.getCode());
    }

    private int weightForEnum(Enumeration code, String context) {
        switch (code.getSystem()) {
            case "http://hl7.org/fhir/conditional-delete-status": {
                CapabilityStatement.ConditionalDeleteStatus deleteStatus = CapabilityStatement.ConditionalDeleteStatus.fromCode(code.getCode());
                switch (deleteStatus) {
                    case NOTSUPPORTED: {
                        return 0;
                    }
                    case SINGLE: {
                        return 1;
                    }
                    case MULTIPLE: {
                        return 2;
                    }
                }
                throw new FHIRException("Unrecognized Delete Status in " + context + ": " + code.getCode());
            }
            case "http://hl7.org/fhir/conditional-read-status": {
                CapabilityStatement.ConditionalReadStatus readStatus = CapabilityStatement.ConditionalReadStatus.fromCode(code.getCode());
                switch (readStatus) {
                    case NOTSUPPORTED: {
                        return 0;
                    }
                    case MODIFIEDSINCE: {
                        return 1;
                    }
                    case NOTMATCH: {
                        return 1;
                    }
                    case FULLSUPPORT: {
                        return 2;
                    }
                }
                throw new FHIRException("Unrecognized Read Status in " + context + ": " + code.getCode());
            }
            case "http://hl7.org/fhir/versioning-policy": {
                CapabilityStatement.ResourceVersionPolicy versionPolicy = CapabilityStatement.ResourceVersionPolicy.fromCode(code.getCode());
                switch (versionPolicy) {
                    case NOVERSION: {
                        return 0;
                    }
                    case VERSIONED: {
                        return 1;
                    }
                    case VERSIONEDUPDATE: {
                        return 2;
                    }
                }
                throw new FHIRException("Unrecognized Versioning Policy in " + context + ": " + code.getCode());
            }
        }
        throw new Error("Unsupported code system in " + context + ": " + code.getSystem());
    }

    protected BooleanType merge(BooleanType targetBool, BooleanType importedBool, String context) throws FHIRException {
        return this.merge(targetBool, importedBool, "SHALL", context);
    }

    protected BooleanType merge(BooleanType targetBool, BooleanType importedBool, String maxConformance, String context) throws FHIRException {
        if (targetBool == null || targetBool.getValue() == null) {
            return (BooleanType)this.fixMax(importedBool, maxConformance);
        }
        if (importedBool == null || importedBool.getValue() == null) {
            return targetBool;
        }
        if (((Boolean)targetBool.getValue()).equals(importedBool.getValue())) {
            this.mergeExpectations(targetBool, importedBool, maxConformance);
            return targetBool;
        }
        if (targetBool.hasExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation") && importedBool.hasExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation")) {
            String importedExpectation;
            String targetExpectation = targetBool.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation").getValueCodeType().getCode();
            if (targetExpectation.equals(importedExpectation = importedBool.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation").getValueCodeType().getCode())) {
                throw new FHIRException("Non matching boolean values with equivalent conformance expectations for " + context + " - base CapabilityStatement:" + String.valueOf(targetBool.getValue()) + "; imported CapabilityStatement:" + String.valueOf(importedBool.getValue()));
            }
            if (targetExpectation.equals("SHALL")) {
                return targetBool;
            }
            if (importedExpectation.equals("SHALL")) {
                return (BooleanType)this.fixMax(importedBool, maxConformance);
            }
            if (targetExpectation.equals("SHOULD")) {
                return targetBool;
            }
            if (importedExpectation.equals("SHOULD")) {
                return (BooleanType)this.fixMax(importedBool, maxConformance);
            }
        }
        throw new FHIRException("Non matching boolean values with no conformance expectations for " + context + " - base CapabilityStatement:" + String.valueOf(targetBool.getValue()) + "; imported CapabilityStatement:" + String.valueOf(importedBool.getValue()));
    }

    public void mergeExpectations(Element target, Element source, String maxConformance) {
        if (target.hasExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation")) {
            String sourceExpectation;
            Extension targetExpectation = target.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation");
            if (!targetExpectation.getValueCodeType().getCode().equals("SHALL") && source.hasExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation") && ((sourceExpectation = this.effectiveConformance(source.getExtensionString("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation"), maxConformance)).equals("SHALL") || targetExpectation.getValueCodeType().getCode().equals("MAY"))) {
                targetExpectation.setValue(new CodeType(sourceExpectation));
            }
        } else if (source.hasExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation")) {
            target.addExtension(source.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation"));
        }
    }

    private String effectiveConformance(String conf, String maxConf) {
        conf = conf == null ? "SHALL" : conf;
        String string = maxConf = maxConf == null ? "SHALL" : maxConf;
        if (conf.equals(maxConf)) {
            return conf;
        }
        if (conf.equals("SHALL")) {
            return maxConf;
        }
        if (maxConf.equals("SHALL") || maxConf.equals("SHOULD")) {
            return conf;
        }
        return maxConf;
    }

    public DataType fixMax(DataType d, String maxConformance) {
        String conformance = d.getExtensionString("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation");
        d.removeExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation");
        d.addExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation", new CodeType(this.effectiveConformance(conformance, maxConformance)));
        return d;
    }
}

