/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.formats;

public class JsonNumberCanonicalizer {
    public static String toCanonicalJson(String numberString) {
        try {
            double value = Double.parseDouble(numberString);
            if (Double.isNaN(value)) {
                throw new IllegalArgumentException("NaN is not valid in JSON");
            }
            if (Double.isInfinite(value)) {
                throw new IllegalArgumentException("Infinity is not valid in JSON");
            }
            return JsonNumberCanonicalizer.doubleToCanonicalString(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number format: " + numberString);
        }
    }

    private static String doubleToCanonicalString(double value) {
        if (value == 0.0) {
            return "0";
        }
        if (value < 0.0) {
            return "-" + JsonNumberCanonicalizer.doubleToCanonicalString(-value);
        }
        return JsonNumberCanonicalizer.formatWithEcmaScriptRules(value);
    }

    private static String formatWithEcmaScriptRules(double value) {
        String result = JsonNumberCanonicalizer.findShortestString(value);
        return JsonNumberCanonicalizer.applyNotationRules(value, result);
    }

    private static String findShortestString(double value) {
        String javaDefault;
        String shortest = javaDefault = Double.toString(value);
        for (int precision = 0; precision <= 17; ++precision) {
            String candidate = String.format("%." + precision + "f", value);
            if (!JsonNumberCanonicalizer.isExactRepresentation(candidate = JsonNumberCanonicalizer.removeTrailingZeros(candidate), value) || candidate.length() >= shortest.length()) continue;
            shortest = candidate;
        }
        String scientific = String.format("%.15e", value);
        if (JsonNumberCanonicalizer.isExactRepresentation(scientific = JsonNumberCanonicalizer.cleanupScientificNotation(scientific), value) && scientific.length() < shortest.length()) {
            shortest = scientific;
        }
        return shortest;
    }

    private static boolean isExactRepresentation(String str, double original) {
        try {
            double parsed = Double.parseDouble(str);
            return Double.doubleToLongBits(parsed) == Double.doubleToLongBits(original);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static String applyNotationRules(double value, String representation) {
        int k = JsonNumberCanonicalizer.calculateExponent(value);
        if (k <= -7 || k >= 21) {
            return JsonNumberCanonicalizer.formatExponential(value);
        }
        return JsonNumberCanonicalizer.formatDecimal(value, k);
    }

    private static int calculateExponent(double value) {
        if (value == 0.0) {
            return 0;
        }
        double abs = Math.abs(value);
        if (abs >= 1.0) {
            return (int)Math.floor(Math.log10(abs));
        }
        return (int)Math.floor(Math.log10(abs));
    }

    private static String formatDecimal(double value, int k) {
        if (k >= 0) {
            return JsonNumberCanonicalizer.removeTrailingZeros(String.format("%.15f", value));
        }
        int decimalPlaces = Math.max(0, -k + 15);
        String result = String.format("%." + decimalPlaces + "f", value);
        return JsonNumberCanonicalizer.removeTrailingZeros(result);
    }

    private static String formatExponential(double value) {
        String formatted = String.format("%.15e", value);
        return JsonNumberCanonicalizer.cleanupScientificNotation(formatted);
    }

    private static int getEffectiveExponent(double value) {
        if (value == 0.0) {
            return 0;
        }
        double abs = Math.abs(value);
        if (abs >= 1.0) {
            return (int)Math.floor(Math.log10(abs));
        }
        return (int)Math.floor(Math.log10(abs));
    }

    private static String toEcmaScientific(double value) {
        String formatted = String.format("%.16e", value);
        String[] parts = formatted.toLowerCase().split("e");
        String mantissa = JsonNumberCanonicalizer.removeTrailingZeros(parts[0]);
        int exp = Integer.parseInt(parts[1]);
        Object expStr = exp >= 0 ? "+" + exp : String.valueOf(exp);
        return mantissa + "e" + (String)expStr;
    }

    private static String toEcmaScriptScientific(double value) {
        boolean negative;
        if (value == 0.0) {
            return "0";
        }
        boolean bl = negative = value < 0.0;
        if (negative) {
            value = -value;
        }
        int exponent = (int)Math.floor(Math.log10(value));
        double mantissa = value / Math.pow(10.0, exponent);
        String mantissaStr = JsonNumberCanonicalizer.findShortestMantissa(mantissa);
        Object expStr = exponent >= 0 ? "+" + exponent : String.valueOf(exponent);
        String result = mantissaStr + "e" + (String)expStr;
        return negative ? "-" + result : result;
    }

    private static String findShortestMantissa(double mantissa) {
        for (int precision = 1; precision <= 16; ++precision) {
            String candidate = String.format("%." + precision + "f", mantissa);
            double test = Double.parseDouble(candidate = JsonNumberCanonicalizer.removeTrailingZeros(candidate));
            if (!(Math.abs(test - mantissa) < 1.0E-15)) continue;
            return candidate;
        }
        return JsonNumberCanonicalizer.removeTrailingZeros(String.format("%.15f", mantissa));
    }

    private static String removeTrailingZeros(String str) {
        if (!str.contains(".")) {
            return str;
        }
        if ((str = str.replaceAll("0+$", "")).endsWith(".")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String toCanonicalJsonPrecise(String numberString) {
        double value = Double.parseDouble(numberString);
        if (value == 0.0) {
            return "0";
        }
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("NaN not allowed");
        }
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException("Infinity not allowed");
        }
        if (value < 0.0) {
            return "-" + JsonNumberCanonicalizer.toCanonicalJsonPrecise(String.valueOf(-value));
        }
        return JsonNumberCanonicalizer.formatWithEcmaScriptRules(value);
    }

    private static String cleanupScientificNotation(String str) {
        if (!str.contains("e")) {
            return str;
        }
        str = str.toLowerCase();
        String[] parts = str.split("e");
        String mantissa = JsonNumberCanonicalizer.removeTrailingZeros(parts[0]);
        Object exponent = parts[1];
        if (((String)exponent).startsWith("+")) {
            exponent = ((String)exponent).substring(1);
        }
        if (!((String)(exponent = String.valueOf(Integer.parseInt((String)exponent)))).startsWith("-")) {
            exponent = "+" + (String)exponent;
        }
        return mantissa + "e" + (String)exponent;
    }
}

