/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Coverage", profile="http://hl7.org/fhir/StructureDefinition/Coverage")
public class Coverage
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier(s) for this coverage", formalDefinition="The identifier of the coverage as issued by the insurer.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<Enumerations.FinancialResourceStatusCodes> status;
    @Child(name="kind", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="insurance | self-pay | other", formalDefinition="The nature of the coverage be it insurance, or cash payment such as self-pay.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/coverage-kind")
    protected Enumeration<Kind> kind;
    @Child(name="paymentBy", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Self-pay parties and responsibility", formalDefinition="Link to the paying party and optionally what specifically they will be responsible to pay.")
    protected List<CoveragePaymentByComponent> paymentBy;
    @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Coverage category such as medical or accident", formalDefinition="The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health or payment by an individual or organization.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/coverage-type")
    protected CodeableConcept type;
    @Child(name="policyHolder", type={Patient.class, RelatedPerson.class, Organization.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Owner of the policy", formalDefinition="The party who 'owns' the insurance policy.")
    protected Reference policyHolder;
    @Child(name="subscriber", type={Patient.class, RelatedPerson.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Subscriber to the policy", formalDefinition="The party who has signed-up for or 'owns' the contractual relationship to the policy or to whom the benefit of the policy for services rendered to them or their family is due.")
    protected Reference subscriber;
    @Child(name="subscriberId", type={Identifier.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="ID assigned to the subscriber", formalDefinition="The insurer assigned ID for the Subscriber.")
    protected List<Identifier> subscriberId;
    @Child(name="beneficiary", type={Patient.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Plan beneficiary", formalDefinition="The party who benefits from the insurance coverage; the patient when products and/or services are provided.")
    protected Reference beneficiary;
    @Child(name="dependent", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dependent number", formalDefinition="A designator for a dependent under the coverage.")
    protected StringType dependent;
    @Child(name="relationship", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Beneficiary relationship to the subscriber", formalDefinition="The relationship of beneficiary (patient) to the subscriber.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscriber-relationship")
    protected CodeableConcept relationship;
    @Child(name="period", type={Period.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Coverage start and end dates", formalDefinition="Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.")
    protected Period period;
    @Child(name="insurer", type={Organization.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Issuer of the policy", formalDefinition="The program or plan underwriter, payor, insurance company.")
    protected Reference insurer;
    @Child(name="class", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional coverage classifications", formalDefinition="A suite of underwriter specific classifiers.")
    protected List<ClassComponent> class_;
    @Child(name="order", type={PositiveIntType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Relative order of the coverage", formalDefinition="The order of applicability of this coverage relative to other coverages which are currently in force. Note, there may be gaps in the numbering and this does not imply primary, secondary etc. as the specific positioning of coverages depends upon the episode of care. For example; a patient might have (0) auto insurance (1) their own health insurance and (2) spouse's health insurance. When claiming for treatments which were not the result of an auto accident then only coverages (1) and (2) above would be applicatble and would apply in the order specified in parenthesis.")
    protected PositiveIntType order;
    @Child(name="network", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer network", formalDefinition="The insurer-specific identifier for the insurer-defined network of providers to which the beneficiary may seek treatment which will be covered at the 'in-network' rate, otherwise 'out of network' terms and conditions apply.")
    protected StringType network;
    @Child(name="costToBeneficiary", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Patient payments for services/products", formalDefinition="A suite of codes indicating the cost category and associated amount which have been detailed in the policy and may have been  included on the health card.")
    protected List<CostToBeneficiaryComponent> costToBeneficiary;
    @Child(name="subrogation", type={BooleanType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reimbursement to insurer", formalDefinition="When 'subrogation=true' this insurance instance has been included not for adjudication but to provide insurers with the details to recover costs.")
    protected BooleanType subrogation;
    @Child(name="contract", type={Contract.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract details", formalDefinition="The policy(s) which constitute this insurance coverage.")
    protected List<Reference> contract;
    @Child(name="insurancePlan", type={InsurancePlan.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Insurance plan details", formalDefinition="The insurance plan details, benefits and costs, which constitute this insurance coverage.")
    protected Reference insurancePlan;
    private static final long serialVersionUID = -1129388911L;
    @SearchParamDefinition(name="beneficiary", path="Coverage.beneficiary", description="Covered party", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_BENEFICIARY = "beneficiary";
    public static final ReferenceClientParam BENEFICIARY = new ReferenceClientParam("beneficiary");
    public static final Include INCLUDE_BENEFICIARY = new Include("Coverage:beneficiary").toLocked();
    @SearchParamDefinition(name="class-type", path="Coverage.class.type", description="Coverage class (e.g. plan, group)", type="token")
    public static final String SP_CLASS_TYPE = "class-type";
    public static final TokenClientParam CLASS_TYPE = new TokenClientParam("class-type");
    @SearchParamDefinition(name="class-value", path="Coverage.class.value", description="Value of the class (e.g. Plan number, group number)", type="token")
    public static final String SP_CLASS_VALUE = "class-value";
    public static final TokenClientParam CLASS_VALUE = new TokenClientParam("class-value");
    @SearchParamDefinition(name="dependent", path="Coverage.dependent", description="Dependent number", type="string")
    public static final String SP_DEPENDENT = "dependent";
    public static final StringClientParam DEPENDENT = new StringClientParam("dependent");
    @SearchParamDefinition(name="insurer", path="Coverage.insurer", description="The identity of the insurer", type="reference", target={Organization.class})
    public static final String SP_INSURER = "insurer";
    public static final ReferenceClientParam INSURER = new ReferenceClientParam("insurer");
    public static final Include INCLUDE_INSURER = new Include("Coverage:insurer").toLocked();
    @SearchParamDefinition(name="paymentby-party", path="Coverage.paymentBy.party", description="Parties who will pay for services", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Organization.class, Patient.class, RelatedPerson.class})
    public static final String SP_PAYMENTBY_PARTY = "paymentby-party";
    public static final ReferenceClientParam PAYMENTBY_PARTY = new ReferenceClientParam("paymentby-party");
    public static final Include INCLUDE_PAYMENTBY_PARTY = new Include("Coverage:paymentby-party").toLocked();
    @SearchParamDefinition(name="policy-holder", path="Coverage.policyHolder", description="Reference to the policyholder", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Organization.class, Patient.class, RelatedPerson.class})
    public static final String SP_POLICY_HOLDER = "policy-holder";
    public static final ReferenceClientParam POLICY_HOLDER = new ReferenceClientParam("policy-holder");
    public static final Include INCLUDE_POLICY_HOLDER = new Include("Coverage:policy-holder").toLocked();
    @SearchParamDefinition(name="status", path="Coverage.status", description="The status of the Coverage", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subscriber", path="Coverage.subscriber", description="Reference to the subscriber", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Patient.class, RelatedPerson.class})
    public static final String SP_SUBSCRIBER = "subscriber";
    public static final ReferenceClientParam SUBSCRIBER = new ReferenceClientParam("subscriber");
    public static final Include INCLUDE_SUBSCRIBER = new Include("Coverage:subscriber").toLocked();
    @SearchParamDefinition(name="subscriberid", path="Coverage.subscriberId", description="Identifier of the subscriber", type="token")
    public static final String SP_SUBSCRIBERID = "subscriberid";
    public static final TokenClientParam SUBSCRIBERID = new TokenClientParam("subscriberid");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Coverage:patient").toLocked();
    @SearchParamDefinition(name="type", path="Account.type | AllergyIntolerance.type | Composition.type | Coverage.type | DocumentReference.type | Encounter.type | EpisodeOfCare.type | Invoice.type | MedicationDispense.type | MolecularSequence.type | Specimen.type", description="Multiple Resources: \r\n\r\n* [Account](account.html): E.g. patient, expense, depreciation\r\n* [AllergyIntolerance](allergyintolerance.html): allergy | intolerance - Underlying mechanism (if known)\r\n* [Composition](composition.html): Kind of composition (LOINC if possible)\r\n* [Coverage](coverage.html): The kind of coverage (health plan, auto, Workers Compensation)\r\n* [DocumentReference](documentreference.html): Kind of document (LOINC if possible)\r\n* [Encounter](encounter.html): Specific type of encounter\r\n* [EpisodeOfCare](episodeofcare.html): Type/class  - e.g. specialist referral, disease management\r\n* [Invoice](invoice.html): Type of Invoice\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of a specific type\r\n* [MolecularSequence](molecularsequence.html): Amino Acid Sequence/ DNA Sequence / RNA Sequence\r\n* [Specimen](specimen.html): The specimen type\r\n", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public Coverage() {
    }

    public Coverage(Enumerations.FinancialResourceStatusCodes status, Kind kind, Reference beneficiary) {
        this.setStatus(status);
        this.setKind(kind);
        this.setBeneficiary(beneficiary);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Coverage setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Coverage addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<Enumerations.FinancialResourceStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Coverage setStatusElement(Enumeration<Enumerations.FinancialResourceStatusCodes> value) {
        this.status = value;
        return this;
    }

    public Enumerations.FinancialResourceStatusCodes getStatus() {
        return this.status == null ? null : (Enumerations.FinancialResourceStatusCodes)((Object)this.status.getValue());
    }

    public Coverage setStatus(Enumerations.FinancialResourceStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<Kind> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<Kind>(new KindEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public Coverage setKindElement(Enumeration<Kind> value) {
        this.kind = value;
        return this;
    }

    public Kind getKind() {
        return this.kind == null ? null : (Kind)((Object)this.kind.getValue());
    }

    public Coverage setKind(Kind value) {
        if (this.kind == null) {
            this.kind = new Enumeration<Kind>(new KindEnumFactory());
        }
        this.kind.setValue((Object)value);
        return this;
    }

    public List<CoveragePaymentByComponent> getPaymentBy() {
        if (this.paymentBy == null) {
            this.paymentBy = new ArrayList<CoveragePaymentByComponent>();
        }
        return this.paymentBy;
    }

    public Coverage setPaymentBy(List<CoveragePaymentByComponent> thePaymentBy) {
        this.paymentBy = thePaymentBy;
        return this;
    }

    public boolean hasPaymentBy() {
        if (this.paymentBy == null) {
            return false;
        }
        for (CoveragePaymentByComponent item : this.paymentBy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CoveragePaymentByComponent addPaymentBy() {
        CoveragePaymentByComponent t = new CoveragePaymentByComponent();
        if (this.paymentBy == null) {
            this.paymentBy = new ArrayList<CoveragePaymentByComponent>();
        }
        this.paymentBy.add(t);
        return t;
    }

    public Coverage addPaymentBy(CoveragePaymentByComponent t) {
        if (t == null) {
            return this;
        }
        if (this.paymentBy == null) {
            this.paymentBy = new ArrayList<CoveragePaymentByComponent>();
        }
        this.paymentBy.add(t);
        return this;
    }

    public CoveragePaymentByComponent getPaymentByFirstRep() {
        if (this.getPaymentBy().isEmpty()) {
            this.addPaymentBy();
        }
        return this.getPaymentBy().get(0);
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Coverage setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Reference getPolicyHolder() {
        if (this.policyHolder == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.policyHolder");
            }
            if (Configuration.doAutoCreate()) {
                this.policyHolder = new Reference();
            }
        }
        return this.policyHolder;
    }

    public boolean hasPolicyHolder() {
        return this.policyHolder != null && !this.policyHolder.isEmpty();
    }

    public Coverage setPolicyHolder(Reference value) {
        this.policyHolder = value;
        return this;
    }

    public Reference getSubscriber() {
        if (this.subscriber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.subscriber");
            }
            if (Configuration.doAutoCreate()) {
                this.subscriber = new Reference();
            }
        }
        return this.subscriber;
    }

    public boolean hasSubscriber() {
        return this.subscriber != null && !this.subscriber.isEmpty();
    }

    public Coverage setSubscriber(Reference value) {
        this.subscriber = value;
        return this;
    }

    public List<Identifier> getSubscriberId() {
        if (this.subscriberId == null) {
            this.subscriberId = new ArrayList<Identifier>();
        }
        return this.subscriberId;
    }

    public Coverage setSubscriberId(List<Identifier> theSubscriberId) {
        this.subscriberId = theSubscriberId;
        return this;
    }

    public boolean hasSubscriberId() {
        if (this.subscriberId == null) {
            return false;
        }
        for (Identifier item : this.subscriberId) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addSubscriberId() {
        Identifier t = new Identifier();
        if (this.subscriberId == null) {
            this.subscriberId = new ArrayList<Identifier>();
        }
        this.subscriberId.add(t);
        return t;
    }

    public Coverage addSubscriberId(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.subscriberId == null) {
            this.subscriberId = new ArrayList<Identifier>();
        }
        this.subscriberId.add(t);
        return this;
    }

    public Identifier getSubscriberIdFirstRep() {
        if (this.getSubscriberId().isEmpty()) {
            this.addSubscriberId();
        }
        return this.getSubscriberId().get(0);
    }

    public Reference getBeneficiary() {
        if (this.beneficiary == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.beneficiary");
            }
            if (Configuration.doAutoCreate()) {
                this.beneficiary = new Reference();
            }
        }
        return this.beneficiary;
    }

    public boolean hasBeneficiary() {
        return this.beneficiary != null && !this.beneficiary.isEmpty();
    }

    public Coverage setBeneficiary(Reference value) {
        this.beneficiary = value;
        return this;
    }

    public StringType getDependentElement() {
        if (this.dependent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.dependent");
            }
            if (Configuration.doAutoCreate()) {
                this.dependent = new StringType();
            }
        }
        return this.dependent;
    }

    public boolean hasDependentElement() {
        return this.dependent != null && !this.dependent.isEmpty();
    }

    public boolean hasDependent() {
        return this.dependent != null && !this.dependent.isEmpty();
    }

    public Coverage setDependentElement(StringType value) {
        this.dependent = value;
        return this;
    }

    public String getDependent() {
        return this.dependent == null ? null : (String)this.dependent.getValue();
    }

    public Coverage setDependent(String value) {
        if (Utilities.noString((String)value)) {
            this.dependent = null;
        } else {
            if (this.dependent == null) {
                this.dependent = new StringType();
            }
            this.dependent.setValue(value);
        }
        return this;
    }

    public CodeableConcept getRelationship() {
        if (this.relationship == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.relationship");
            }
            if (Configuration.doAutoCreate()) {
                this.relationship = new CodeableConcept();
            }
        }
        return this.relationship;
    }

    public boolean hasRelationship() {
        return this.relationship != null && !this.relationship.isEmpty();
    }

    public Coverage setRelationship(CodeableConcept value) {
        this.relationship = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Coverage setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getInsurer() {
        if (this.insurer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurer = new Reference();
            }
        }
        return this.insurer;
    }

    public boolean hasInsurer() {
        return this.insurer != null && !this.insurer.isEmpty();
    }

    public Coverage setInsurer(Reference value) {
        this.insurer = value;
        return this;
    }

    public List<ClassComponent> getClass_() {
        if (this.class_ == null) {
            this.class_ = new ArrayList<ClassComponent>();
        }
        return this.class_;
    }

    public Coverage setClass_(List<ClassComponent> theClass_) {
        this.class_ = theClass_;
        return this;
    }

    public boolean hasClass_() {
        if (this.class_ == null) {
            return false;
        }
        for (ClassComponent item : this.class_) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ClassComponent addClass_() {
        ClassComponent t = new ClassComponent();
        if (this.class_ == null) {
            this.class_ = new ArrayList<ClassComponent>();
        }
        this.class_.add(t);
        return t;
    }

    public Coverage addClass_(ClassComponent t) {
        if (t == null) {
            return this;
        }
        if (this.class_ == null) {
            this.class_ = new ArrayList<ClassComponent>();
        }
        this.class_.add(t);
        return this;
    }

    public ClassComponent getClass_FirstRep() {
        if (this.getClass_().isEmpty()) {
            this.addClass_();
        }
        return this.getClass_().get(0);
    }

    public PositiveIntType getOrderElement() {
        if (this.order == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.order");
            }
            if (Configuration.doAutoCreate()) {
                this.order = new PositiveIntType();
            }
        }
        return this.order;
    }

    public boolean hasOrderElement() {
        return this.order != null && !this.order.isEmpty();
    }

    public boolean hasOrder() {
        return this.order != null && !this.order.isEmpty();
    }

    public Coverage setOrderElement(PositiveIntType value) {
        this.order = value;
        return this;
    }

    public int getOrder() {
        return this.order == null || this.order.isEmpty() ? 0 : (Integer)this.order.getValue();
    }

    public Coverage setOrder(int value) {
        if (this.order == null) {
            this.order = new PositiveIntType();
        }
        this.order.setValue((Object)value);
        return this;
    }

    public StringType getNetworkElement() {
        if (this.network == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.network");
            }
            if (Configuration.doAutoCreate()) {
                this.network = new StringType();
            }
        }
        return this.network;
    }

    public boolean hasNetworkElement() {
        return this.network != null && !this.network.isEmpty();
    }

    public boolean hasNetwork() {
        return this.network != null && !this.network.isEmpty();
    }

    public Coverage setNetworkElement(StringType value) {
        this.network = value;
        return this;
    }

    public String getNetwork() {
        return this.network == null ? null : (String)this.network.getValue();
    }

    public Coverage setNetwork(String value) {
        if (Utilities.noString((String)value)) {
            this.network = null;
        } else {
            if (this.network == null) {
                this.network = new StringType();
            }
            this.network.setValue(value);
        }
        return this;
    }

    public List<CostToBeneficiaryComponent> getCostToBeneficiary() {
        if (this.costToBeneficiary == null) {
            this.costToBeneficiary = new ArrayList<CostToBeneficiaryComponent>();
        }
        return this.costToBeneficiary;
    }

    public Coverage setCostToBeneficiary(List<CostToBeneficiaryComponent> theCostToBeneficiary) {
        this.costToBeneficiary = theCostToBeneficiary;
        return this;
    }

    public boolean hasCostToBeneficiary() {
        if (this.costToBeneficiary == null) {
            return false;
        }
        for (CostToBeneficiaryComponent item : this.costToBeneficiary) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CostToBeneficiaryComponent addCostToBeneficiary() {
        CostToBeneficiaryComponent t = new CostToBeneficiaryComponent();
        if (this.costToBeneficiary == null) {
            this.costToBeneficiary = new ArrayList<CostToBeneficiaryComponent>();
        }
        this.costToBeneficiary.add(t);
        return t;
    }

    public Coverage addCostToBeneficiary(CostToBeneficiaryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.costToBeneficiary == null) {
            this.costToBeneficiary = new ArrayList<CostToBeneficiaryComponent>();
        }
        this.costToBeneficiary.add(t);
        return this;
    }

    public CostToBeneficiaryComponent getCostToBeneficiaryFirstRep() {
        if (this.getCostToBeneficiary().isEmpty()) {
            this.addCostToBeneficiary();
        }
        return this.getCostToBeneficiary().get(0);
    }

    public BooleanType getSubrogationElement() {
        if (this.subrogation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.subrogation");
            }
            if (Configuration.doAutoCreate()) {
                this.subrogation = new BooleanType();
            }
        }
        return this.subrogation;
    }

    public boolean hasSubrogationElement() {
        return this.subrogation != null && !this.subrogation.isEmpty();
    }

    public boolean hasSubrogation() {
        return this.subrogation != null && !this.subrogation.isEmpty();
    }

    public Coverage setSubrogationElement(BooleanType value) {
        this.subrogation = value;
        return this;
    }

    public boolean getSubrogation() {
        return this.subrogation == null || this.subrogation.isEmpty() ? false : (Boolean)this.subrogation.getValue();
    }

    public Coverage setSubrogation(boolean value) {
        if (this.subrogation == null) {
            this.subrogation = new BooleanType();
        }
        this.subrogation.setValue((Object)value);
        return this;
    }

    public List<Reference> getContract() {
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        return this.contract;
    }

    public Coverage setContract(List<Reference> theContract) {
        this.contract = theContract;
        return this;
    }

    public boolean hasContract() {
        if (this.contract == null) {
            return false;
        }
        for (Reference item : this.contract) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addContract() {
        Reference t = new Reference();
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        this.contract.add(t);
        return t;
    }

    public Coverage addContract(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        this.contract.add(t);
        return this;
    }

    public Reference getContractFirstRep() {
        if (this.getContract().isEmpty()) {
            this.addContract();
        }
        return this.getContract().get(0);
    }

    public Reference getInsurancePlan() {
        if (this.insurancePlan == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.insurancePlan");
            }
            if (Configuration.doAutoCreate()) {
                this.insurancePlan = new Reference();
            }
        }
        return this.insurancePlan;
    }

    public boolean hasInsurancePlan() {
        return this.insurancePlan != null && !this.insurancePlan.isEmpty();
    }

    public Coverage setInsurancePlan(Reference value) {
        this.insurancePlan = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The identifier of the coverage as issued by the insurer.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("kind", "code", "The nature of the coverage be it insurance, or cash payment such as self-pay.", 0, 1, this.kind));
        children.add(new Property("paymentBy", "", "Link to the paying party and optionally what specifically they will be responsible to pay.", 0, Integer.MAX_VALUE, this.paymentBy));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health or payment by an individual or organization.", 0, 1, this.type));
        children.add(new Property("policyHolder", "Reference(Patient|RelatedPerson|Organization)", "The party who 'owns' the insurance policy.", 0, 1, this.policyHolder));
        children.add(new Property(SP_SUBSCRIBER, "Reference(Patient|RelatedPerson)", "The party who has signed-up for or 'owns' the contractual relationship to the policy or to whom the benefit of the policy for services rendered to them or their family is due.", 0, 1, this.subscriber));
        children.add(new Property("subscriberId", "Identifier", "The insurer assigned ID for the Subscriber.", 0, Integer.MAX_VALUE, this.subscriberId));
        children.add(new Property(SP_BENEFICIARY, "Reference(Patient)", "The party who benefits from the insurance coverage; the patient when products and/or services are provided.", 0, 1, this.beneficiary));
        children.add(new Property(SP_DEPENDENT, "string", "A designator for a dependent under the coverage.", 0, 1, this.dependent));
        children.add(new Property("relationship", "CodeableConcept", "The relationship of beneficiary (patient) to the subscriber.", 0, 1, this.relationship));
        children.add(new Property("period", "Period", "Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.", 0, 1, this.period));
        children.add(new Property(SP_INSURER, "Reference(Organization)", "The program or plan underwriter, payor, insurance company.", 0, 1, this.insurer));
        children.add(new Property("class", "", "A suite of underwriter specific classifiers.", 0, Integer.MAX_VALUE, this.class_));
        children.add(new Property("order", "positiveInt", "The order of applicability of this coverage relative to other coverages which are currently in force. Note, there may be gaps in the numbering and this does not imply primary, secondary etc. as the specific positioning of coverages depends upon the episode of care. For example; a patient might have (0) auto insurance (1) their own health insurance and (2) spouse's health insurance. When claiming for treatments which were not the result of an auto accident then only coverages (1) and (2) above would be applicatble and would apply in the order specified in parenthesis.", 0, 1, this.order));
        children.add(new Property("network", "string", "The insurer-specific identifier for the insurer-defined network of providers to which the beneficiary may seek treatment which will be covered at the 'in-network' rate, otherwise 'out of network' terms and conditions apply.", 0, 1, this.network));
        children.add(new Property("costToBeneficiary", "", "A suite of codes indicating the cost category and associated amount which have been detailed in the policy and may have been  included on the health card.", 0, Integer.MAX_VALUE, this.costToBeneficiary));
        children.add(new Property("subrogation", "boolean", "When 'subrogation=true' this insurance instance has been included not for adjudication but to provide insurers with the details to recover costs.", 0, 1, this.subrogation));
        children.add(new Property("contract", "Reference(Contract)", "The policy(s) which constitute this insurance coverage.", 0, Integer.MAX_VALUE, this.contract));
        children.add(new Property("insurancePlan", "Reference(InsurancePlan)", "The insurance plan details, benefits and costs, which constitute this insurance coverage.", 0, 1, this.insurancePlan));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The identifier of the coverage as issued by the insurer.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 3292052: {
                return new Property("kind", "code", "The nature of the coverage be it insurance, or cash payment such as self-pay.", 0, 1, this.kind);
            }
            case -86519555: {
                return new Property("paymentBy", "", "Link to the paying party and optionally what specifically they will be responsible to pay.", 0, Integer.MAX_VALUE, this.paymentBy);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health or payment by an individual or organization.", 0, 1, this.type);
            }
            case 2046898558: {
                return new Property("policyHolder", "Reference(Patient|RelatedPerson|Organization)", "The party who 'owns' the insurance policy.", 0, 1, this.policyHolder);
            }
            case -1219769240: {
                return new Property(SP_SUBSCRIBER, "Reference(Patient|RelatedPerson)", "The party who has signed-up for or 'owns' the contractual relationship to the policy or to whom the benefit of the policy for services rendered to them or their family is due.", 0, 1, this.subscriber);
            }
            case 327834531: {
                return new Property("subscriberId", "Identifier", "The insurer assigned ID for the Subscriber.", 0, Integer.MAX_VALUE, this.subscriberId);
            }
            case -565102875: {
                return new Property(SP_BENEFICIARY, "Reference(Patient)", "The party who benefits from the insurance coverage; the patient when products and/or services are provided.", 0, 1, this.beneficiary);
            }
            case -1109226753: {
                return new Property(SP_DEPENDENT, "string", "A designator for a dependent under the coverage.", 0, 1, this.dependent);
            }
            case -261851592: {
                return new Property("relationship", "CodeableConcept", "The relationship of beneficiary (patient) to the subscriber.", 0, 1, this.relationship);
            }
            case -991726143: {
                return new Property("period", "Period", "Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.", 0, 1, this.period);
            }
            case 1957615864: {
                return new Property(SP_INSURER, "Reference(Organization)", "The program or plan underwriter, payor, insurance company.", 0, 1, this.insurer);
            }
            case 94742904: {
                return new Property("class", "", "A suite of underwriter specific classifiers.", 0, Integer.MAX_VALUE, this.class_);
            }
            case 106006350: {
                return new Property("order", "positiveInt", "The order of applicability of this coverage relative to other coverages which are currently in force. Note, there may be gaps in the numbering and this does not imply primary, secondary etc. as the specific positioning of coverages depends upon the episode of care. For example; a patient might have (0) auto insurance (1) their own health insurance and (2) spouse's health insurance. When claiming for treatments which were not the result of an auto accident then only coverages (1) and (2) above would be applicatble and would apply in the order specified in parenthesis.", 0, 1, this.order);
            }
            case 1843485230: {
                return new Property("network", "string", "The insurer-specific identifier for the insurer-defined network of providers to which the beneficiary may seek treatment which will be covered at the 'in-network' rate, otherwise 'out of network' terms and conditions apply.", 0, 1, this.network);
            }
            case -1866474851: {
                return new Property("costToBeneficiary", "", "A suite of codes indicating the cost category and associated amount which have been detailed in the policy and may have been  included on the health card.", 0, Integer.MAX_VALUE, this.costToBeneficiary);
            }
            case 837389739: {
                return new Property("subrogation", "boolean", "When 'subrogation=true' this insurance instance has been included not for adjudication but to provide insurers with the details to recover costs.", 0, 1, this.subrogation);
            }
            case -566947566: {
                return new Property("contract", "Reference(Contract)", "The policy(s) which constitute this insurance coverage.", 0, Integer.MAX_VALUE, this.contract);
            }
            case 1992141091: {
                return new Property("insurancePlan", "Reference(InsurancePlan)", "The insurance plan details, benefits and costs, which constitute this insurance coverage.", 0, 1, this.insurancePlan);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.kind;
                }
                return baseArray;
            }
            case -86519555: {
                return this.paymentBy == null ? new Base[]{} : this.paymentBy.toArray(new Base[this.paymentBy.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case 2046898558: {
                Base[] baseArray;
                if (this.policyHolder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.policyHolder;
                }
                return baseArray;
            }
            case -1219769240: {
                Base[] baseArray;
                if (this.subscriber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subscriber;
                }
                return baseArray;
            }
            case 327834531: {
                return this.subscriberId == null ? new Base[]{} : this.subscriberId.toArray(new Base[this.subscriberId.size()]);
            }
            case -565102875: {
                Base[] baseArray;
                if (this.beneficiary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.beneficiary;
                }
                return baseArray;
            }
            case -1109226753: {
                Base[] baseArray;
                if (this.dependent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.dependent;
                }
                return baseArray;
            }
            case -261851592: {
                Base[] baseArray;
                if (this.relationship == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.relationship;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.period;
                }
                return baseArray;
            }
            case 1957615864: {
                Base[] baseArray;
                if (this.insurer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.insurer;
                }
                return baseArray;
            }
            case 94742904: {
                return this.class_ == null ? new Base[]{} : this.class_.toArray(new Base[this.class_.size()]);
            }
            case 106006350: {
                Base[] baseArray;
                if (this.order == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.order;
                }
                return baseArray;
            }
            case 1843485230: {
                Base[] baseArray;
                if (this.network == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.network;
                }
                return baseArray;
            }
            case -1866474851: {
                return this.costToBeneficiary == null ? new Base[]{} : this.costToBeneficiary.toArray(new Base[this.costToBeneficiary.size()]);
            }
            case 837389739: {
                Base[] baseArray;
                if (this.subrogation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.subrogation;
                }
                return baseArray;
            }
            case -566947566: {
                return this.contract == null ? new Base[]{} : this.contract.toArray(new Base[this.contract.size()]);
            }
            case 1992141091: {
                Base[] baseArray;
                if (this.insurancePlan == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.insurancePlan;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 3292052: {
                value = new KindEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.kind = value;
                return value;
            }
            case -86519555: {
                this.getPaymentBy().add((CoveragePaymentByComponent)((Object)value));
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 2046898558: {
                this.policyHolder = TypeConvertor.castToReference(value);
                return value;
            }
            case -1219769240: {
                this.subscriber = TypeConvertor.castToReference(value);
                return value;
            }
            case 327834531: {
                this.getSubscriberId().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -565102875: {
                this.beneficiary = TypeConvertor.castToReference(value);
                return value;
            }
            case -1109226753: {
                this.dependent = TypeConvertor.castToString(value);
                return value;
            }
            case -261851592: {
                this.relationship = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 1957615864: {
                this.insurer = TypeConvertor.castToReference(value);
                return value;
            }
            case 94742904: {
                this.getClass_().add((ClassComponent)((Object)value));
                return value;
            }
            case 106006350: {
                this.order = TypeConvertor.castToPositiveInt(value);
                return value;
            }
            case 1843485230: {
                this.network = TypeConvertor.castToString(value);
                return value;
            }
            case -1866474851: {
                this.getCostToBeneficiary().add((CostToBeneficiaryComponent)((Object)value));
                return value;
            }
            case 837389739: {
                this.subrogation = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -566947566: {
                this.getContract().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1992141091: {
                this.insurancePlan = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("kind")) {
            value = new KindEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.kind = value;
        } else if (name.equals("paymentBy")) {
            this.getPaymentBy().add((CoveragePaymentByComponent)((Object)value));
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("policyHolder")) {
            this.policyHolder = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_SUBSCRIBER)) {
            this.subscriber = TypeConvertor.castToReference(value);
        } else if (name.equals("subscriberId")) {
            this.getSubscriberId().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_BENEFICIARY)) {
            this.beneficiary = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DEPENDENT)) {
            this.dependent = TypeConvertor.castToString(value);
        } else if (name.equals("relationship")) {
            this.relationship = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_INSURER)) {
            this.insurer = TypeConvertor.castToReference(value);
        } else if (name.equals("class")) {
            this.getClass_().add((ClassComponent)((Object)value));
        } else if (name.equals("order")) {
            this.order = TypeConvertor.castToPositiveInt(value);
        } else if (name.equals("network")) {
            this.network = TypeConvertor.castToString(value);
        } else if (name.equals("costToBeneficiary")) {
            this.getCostToBeneficiary().add((CostToBeneficiaryComponent)((Object)value));
        } else if (name.equals("subrogation")) {
            this.subrogation = TypeConvertor.castToBoolean(value);
        } else if (name.equals("contract")) {
            this.getContract().add(TypeConvertor.castToReference(value));
        } else if (name.equals("insurancePlan")) {
            this.insurancePlan = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("kind")) {
            value = new KindEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.kind = value;
        } else if (name.equals("paymentBy")) {
            this.getPaymentBy().remove((CoveragePaymentByComponent)((Object)value));
        } else if (name.equals(SP_TYPE)) {
            this.type = null;
        } else if (name.equals("policyHolder")) {
            this.policyHolder = null;
        } else if (name.equals(SP_SUBSCRIBER)) {
            this.subscriber = null;
        } else if (name.equals("subscriberId")) {
            this.getSubscriberId().remove(value);
        } else if (name.equals(SP_BENEFICIARY)) {
            this.beneficiary = null;
        } else if (name.equals(SP_DEPENDENT)) {
            this.dependent = null;
        } else if (name.equals("relationship")) {
            this.relationship = null;
        } else if (name.equals("period")) {
            this.period = null;
        } else if (name.equals(SP_INSURER)) {
            this.insurer = null;
        } else if (name.equals("class")) {
            this.getClass_().remove((ClassComponent)((Object)value));
        } else if (name.equals("order")) {
            this.order = null;
        } else if (name.equals("network")) {
            this.network = null;
        } else if (name.equals("costToBeneficiary")) {
            this.getCostToBeneficiary().remove((CostToBeneficiaryComponent)((Object)value));
        } else if (name.equals("subrogation")) {
            this.subrogation = null;
        } else if (name.equals("contract")) {
            this.getContract().remove(value);
        } else if (name.equals("insurancePlan")) {
            this.insurancePlan = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3292052: {
                return this.getKindElement();
            }
            case -86519555: {
                return this.addPaymentBy();
            }
            case 3575610: {
                return this.getType();
            }
            case 2046898558: {
                return this.getPolicyHolder();
            }
            case -1219769240: {
                return this.getSubscriber();
            }
            case 327834531: {
                return this.addSubscriberId();
            }
            case -565102875: {
                return this.getBeneficiary();
            }
            case -1109226753: {
                return this.getDependentElement();
            }
            case -261851592: {
                return this.getRelationship();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 1957615864: {
                return this.getInsurer();
            }
            case 94742904: {
                return this.addClass_();
            }
            case 106006350: {
                return this.getOrderElement();
            }
            case 1843485230: {
                return this.getNetworkElement();
            }
            case -1866474851: {
                return this.addCostToBeneficiary();
            }
            case 837389739: {
                return this.getSubrogationElement();
            }
            case -566947566: {
                return this.addContract();
            }
            case 1992141091: {
                return this.getInsurancePlan();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3292052: {
                return new String[]{"code"};
            }
            case -86519555: {
                return new String[0];
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 2046898558: {
                return new String[]{"Reference"};
            }
            case -1219769240: {
                return new String[]{"Reference"};
            }
            case 327834531: {
                return new String[]{"Identifier"};
            }
            case -565102875: {
                return new String[]{"Reference"};
            }
            case -1109226753: {
                return new String[]{"string"};
            }
            case -261851592: {
                return new String[]{"CodeableConcept"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 1957615864: {
                return new String[]{"Reference"};
            }
            case 94742904: {
                return new String[0];
            }
            case 106006350: {
                return new String[]{"positiveInt"};
            }
            case 1843485230: {
                return new String[]{"string"};
            }
            case -1866474851: {
                return new String[0];
            }
            case 837389739: {
                return new String[]{"boolean"};
            }
            case -566947566: {
                return new String[]{"Reference"};
            }
            case 1992141091: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.status");
        }
        if (name.equals("kind")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.kind");
        }
        if (name.equals("paymentBy")) {
            return this.addPaymentBy();
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("policyHolder")) {
            this.policyHolder = new Reference();
            return this.policyHolder;
        }
        if (name.equals(SP_SUBSCRIBER)) {
            this.subscriber = new Reference();
            return this.subscriber;
        }
        if (name.equals("subscriberId")) {
            return this.addSubscriberId();
        }
        if (name.equals(SP_BENEFICIARY)) {
            this.beneficiary = new Reference();
            return this.beneficiary;
        }
        if (name.equals(SP_DEPENDENT)) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.dependent");
        }
        if (name.equals("relationship")) {
            this.relationship = new CodeableConcept();
            return this.relationship;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_INSURER)) {
            this.insurer = new Reference();
            return this.insurer;
        }
        if (name.equals("class")) {
            return this.addClass_();
        }
        if (name.equals("order")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.order");
        }
        if (name.equals("network")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.network");
        }
        if (name.equals("costToBeneficiary")) {
            return this.addCostToBeneficiary();
        }
        if (name.equals("subrogation")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coverage.subrogation");
        }
        if (name.equals("contract")) {
            return this.addContract();
        }
        if (name.equals("insurancePlan")) {
            this.insurancePlan = new Reference();
            return this.insurancePlan;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Coverage";
    }

    @Override
    public Coverage copy() {
        Coverage dst = new Coverage();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Coverage dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        Enumeration<Kind> enumeration = dst.kind = this.kind == null ? null : this.kind.copy();
        if (this.paymentBy != null) {
            dst.paymentBy = new ArrayList<CoveragePaymentByComponent>();
            for (CoveragePaymentByComponent coveragePaymentByComponent : this.paymentBy) {
                dst.paymentBy.add(coveragePaymentByComponent.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.policyHolder = this.policyHolder == null ? null : this.policyHolder.copy();
        Reference reference = dst.subscriber = this.subscriber == null ? null : this.subscriber.copy();
        if (this.subscriberId != null) {
            dst.subscriberId = new ArrayList<Identifier>();
            for (Identifier identifier : this.subscriberId) {
                dst.subscriberId.add(identifier.copy());
            }
        }
        dst.beneficiary = this.beneficiary == null ? null : this.beneficiary.copy();
        dst.dependent = this.dependent == null ? null : this.dependent.copy();
        dst.relationship = this.relationship == null ? null : this.relationship.copy();
        dst.period = this.period == null ? null : this.period.copy();
        Reference reference2 = dst.insurer = this.insurer == null ? null : this.insurer.copy();
        if (this.class_ != null) {
            dst.class_ = new ArrayList<ClassComponent>();
            for (ClassComponent classComponent : this.class_) {
                dst.class_.add(classComponent.copy());
            }
        }
        dst.order = this.order == null ? null : this.order.copy();
        StringType stringType = dst.network = this.network == null ? null : this.network.copy();
        if (this.costToBeneficiary != null) {
            dst.costToBeneficiary = new ArrayList<CostToBeneficiaryComponent>();
            for (CostToBeneficiaryComponent costToBeneficiaryComponent : this.costToBeneficiary) {
                dst.costToBeneficiary.add(costToBeneficiaryComponent.copy());
            }
        }
        BooleanType booleanType = dst.subrogation = this.subrogation == null ? null : this.subrogation.copy();
        if (this.contract != null) {
            dst.contract = new ArrayList<Reference>();
            for (Reference reference3 : this.contract) {
                dst.contract.add(reference3.copy());
            }
        }
        dst.insurancePlan = this.insurancePlan == null ? null : this.insurancePlan.copy();
    }

    protected Coverage typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Coverage)) {
            return false;
        }
        Coverage o = (Coverage)other_;
        return Coverage.compareDeep(this.identifier, o.identifier, true) && Coverage.compareDeep(this.status, o.status, true) && Coverage.compareDeep(this.kind, o.kind, true) && Coverage.compareDeep(this.paymentBy, o.paymentBy, true) && Coverage.compareDeep(this.type, o.type, true) && Coverage.compareDeep(this.policyHolder, o.policyHolder, true) && Coverage.compareDeep(this.subscriber, o.subscriber, true) && Coverage.compareDeep(this.subscriberId, o.subscriberId, true) && Coverage.compareDeep(this.beneficiary, o.beneficiary, true) && Coverage.compareDeep(this.dependent, o.dependent, true) && Coverage.compareDeep(this.relationship, o.relationship, true) && Coverage.compareDeep(this.period, o.period, true) && Coverage.compareDeep(this.insurer, o.insurer, true) && Coverage.compareDeep(this.class_, o.class_, true) && Coverage.compareDeep(this.order, o.order, true) && Coverage.compareDeep(this.network, o.network, true) && Coverage.compareDeep(this.costToBeneficiary, o.costToBeneficiary, true) && Coverage.compareDeep(this.subrogation, o.subrogation, true) && Coverage.compareDeep(this.contract, o.contract, true) && Coverage.compareDeep(this.insurancePlan, o.insurancePlan, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Coverage)) {
            return false;
        }
        Coverage o = (Coverage)other_;
        return Coverage.compareValues(this.status, o.status, true) && Coverage.compareValues(this.kind, o.kind, true) && Coverage.compareValues(this.dependent, o.dependent, true) && Coverage.compareValues(this.order, o.order, true) && Coverage.compareValues(this.network, o.network, true) && Coverage.compareValues(this.subrogation, o.subrogation, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.kind, this.paymentBy, this.type, this.policyHolder, this.subscriber, this.subscriberId, this.beneficiary, this.dependent, this.relationship, this.period, this.insurer, this.class_, this.order, this.network, this.costToBeneficiary, this.subrogation, this.contract, this.insurancePlan});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Coverage;
    }

    public static enum Kind {
        INSURANCE,
        SELFPAY,
        OTHER,
        NULL;


        public static Kind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("insurance".equals(codeString)) {
                return INSURANCE;
            }
            if ("self-pay".equals(codeString)) {
                return SELFPAY;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown Kind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INSURANCE: {
                    return "insurance";
                }
                case SELFPAY: {
                    return "self-pay";
                }
                case OTHER: {
                    return "other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INSURANCE: {
                    return "http://hl7.org/fhir/coverage-kind";
                }
                case SELFPAY: {
                    return "http://hl7.org/fhir/coverage-kind";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/coverage-kind";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INSURANCE: {
                    return "The Coverage provides the identifiers and card-level details of an insurance policy.";
                }
                case SELFPAY: {
                    return "One or more persons and/or organizations are paying for the services rendered.";
                }
                case OTHER: {
                    return "Some other organization is paying for the service.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INSURANCE: {
                    return "Insurance";
                }
                case SELFPAY: {
                    return "Self-pay";
                }
                case OTHER: {
                    return "Other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class KindEnumFactory
    implements EnumFactory<Kind> {
        @Override
        public Kind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("insurance".equals(codeString)) {
                return Kind.INSURANCE;
            }
            if ("self-pay".equals(codeString)) {
                return Kind.SELFPAY;
            }
            if ("other".equals(codeString)) {
                return Kind.OTHER;
            }
            throw new IllegalArgumentException("Unknown Kind code '" + codeString + "'");
        }

        public Enumeration<Kind> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<Kind>(this, Kind.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<Kind>(this, Kind.NULL, code);
            }
            if ("insurance".equals(codeString)) {
                return new Enumeration<Kind>(this, Kind.INSURANCE, code);
            }
            if ("self-pay".equals(codeString)) {
                return new Enumeration<Kind>(this, Kind.SELFPAY, code);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<Kind>(this, Kind.OTHER, code);
            }
            throw new FHIRException("Unknown Kind code '" + codeString + "'");
        }

        @Override
        public String toCode(Kind code) {
            if (code == Kind.NULL) {
                return null;
            }
            if (code == Kind.INSURANCE) {
                return "insurance";
            }
            if (code == Kind.SELFPAY) {
                return "self-pay";
            }
            if (code == Kind.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(Kind code) {
            return code.getSystem();
        }
    }

    @Block
    public static class CoveragePaymentByComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="party", type={Patient.class, RelatedPerson.class, Organization.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Parties performing self-payment", formalDefinition="The list of parties providing non-insurance payment for the treatment costs.")
        protected Reference party;
        @Child(name="responsibility", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Party's responsibility", formalDefinition=" Description of the financial responsibility.")
        protected StringType responsibility;
        private static final long serialVersionUID = -1279858336L;

        public CoveragePaymentByComponent() {
        }

        public CoveragePaymentByComponent(Reference party) {
            this.setParty(party);
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoveragePaymentByComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public CoveragePaymentByComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        public StringType getResponsibilityElement() {
            if (this.responsibility == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoveragePaymentByComponent.responsibility");
                }
                if (Configuration.doAutoCreate()) {
                    this.responsibility = new StringType();
                }
            }
            return this.responsibility;
        }

        public boolean hasResponsibilityElement() {
            return this.responsibility != null && !this.responsibility.isEmpty();
        }

        public boolean hasResponsibility() {
            return this.responsibility != null && !this.responsibility.isEmpty();
        }

        public CoveragePaymentByComponent setResponsibilityElement(StringType value) {
            this.responsibility = value;
            return this;
        }

        public String getResponsibility() {
            return this.responsibility == null ? null : (String)this.responsibility.getValue();
        }

        public CoveragePaymentByComponent setResponsibility(String value) {
            if (Utilities.noString((String)value)) {
                this.responsibility = null;
            } else {
                if (this.responsibility == null) {
                    this.responsibility = new StringType();
                }
                this.responsibility.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("party", "Reference(Patient|RelatedPerson|Organization)", "The list of parties providing non-insurance payment for the treatment costs.", 0, 1, this.party));
            children.add(new Property("responsibility", "string", " Description of the financial responsibility.", 0, 1, this.responsibility));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 106437350: {
                    return new Property("party", "Reference(Patient|RelatedPerson|Organization)", "The list of parties providing non-insurance payment for the treatment costs.", 0, 1, this.party);
                }
                case -228897266: {
                    return new Property("responsibility", "string", " Description of the financial responsibility.", 0, 1, this.responsibility);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.party;
                    }
                    return baseArray;
                }
                case -228897266: {
                    Base[] baseArray;
                    if (this.responsibility == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.responsibility;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 106437350: {
                    this.party = TypeConvertor.castToReference(value);
                    return value;
                }
                case -228897266: {
                    this.responsibility = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("party")) {
                this.party = TypeConvertor.castToReference(value);
            } else if (name.equals("responsibility")) {
                this.responsibility = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("party")) {
                this.party = null;
            } else if (name.equals("responsibility")) {
                this.responsibility = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106437350: {
                    return this.getParty();
                }
                case -228897266: {
                    return this.getResponsibilityElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106437350: {
                    return new String[]{"Reference"};
                }
                case -228897266: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            if (name.equals("responsibility")) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.paymentBy.responsibility");
            }
            return super.addChild(name);
        }

        @Override
        public CoveragePaymentByComponent copy() {
            CoveragePaymentByComponent dst = new CoveragePaymentByComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CoveragePaymentByComponent dst) {
            super.copyValues(dst);
            dst.party = this.party == null ? null : this.party.copy();
            dst.responsibility = this.responsibility == null ? null : this.responsibility.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CoveragePaymentByComponent)) {
                return false;
            }
            CoveragePaymentByComponent o = (CoveragePaymentByComponent)other_;
            return CoveragePaymentByComponent.compareDeep(this.party, o.party, true) && CoveragePaymentByComponent.compareDeep(this.responsibility, o.responsibility, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CoveragePaymentByComponent)) {
                return false;
            }
            CoveragePaymentByComponent o = (CoveragePaymentByComponent)other_;
            return CoveragePaymentByComponent.compareValues(this.responsibility, o.responsibility, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.party, this.responsibility});
        }

        @Override
        public String fhirType() {
            return "Coverage.paymentBy";
        }
    }

    @Block
    public static class ClassComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of class such as 'group' or 'plan'", formalDefinition="The type of classification for which an insurer-specific class label or number and optional name is provided.  For example, type may be used to identify a class of coverage or employer group, policy, or plan.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/coverage-class")
        protected CodeableConcept type;
        @Child(name="value", type={Identifier.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Value associated with the type", formalDefinition="The alphanumeric identifier associated with the insurer issued label.")
        protected Identifier value;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human readable description of the type and value", formalDefinition="A short description for the class.")
        protected StringType name;
        private static final long serialVersionUID = 1395172201L;

        public ClassComponent() {
        }

        public ClassComponent(CodeableConcept type, Identifier value) {
            this.setType(type);
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClassComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ClassComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Identifier getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClassComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new Identifier();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ClassComponent setValue(Identifier value) {
            this.value = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClassComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ClassComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ClassComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Coverage.SP_TYPE, "CodeableConcept", "The type of classification for which an insurer-specific class label or number and optional name is provided.  For example, type may be used to identify a class of coverage or employer group, policy, or plan.", 0, 1, this.type));
            children.add(new Property("value", "Identifier", "The alphanumeric identifier associated with the insurer issued label.", 0, 1, this.value));
            children.add(new Property("name", "string", "A short description for the class.", 0, 1, this.name));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Coverage.SP_TYPE, "CodeableConcept", "The type of classification for which an insurer-specific class label or number and optional name is provided.  For example, type may be used to identify a class of coverage or employer group, policy, or plan.", 0, 1, this.type);
                }
                case 111972721: {
                    return new Property("value", "Identifier", "The alphanumeric identifier associated with the insurer issued label.", 0, 1, this.value);
                }
                case 3373707: {
                    return new Property("name", "string", "A short description for the class.", 0, 1, this.name);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToIdentifier(value);
            } else if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = null;
            } else if (name.equals("value")) {
                this.value = null;
            } else if (name.equals("name")) {
                this.name = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 111972721: {
                    return this.getValue();
                }
                case 3373707: {
                    return this.getNameElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Identifier"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("value")) {
                this.value = new Identifier();
                return this.value;
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property Coverage.class.name");
            }
            return super.addChild(name);
        }

        @Override
        public ClassComponent copy() {
            ClassComponent dst = new ClassComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClassComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.name = this.name == null ? null : this.name.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClassComponent)) {
                return false;
            }
            ClassComponent o = (ClassComponent)other_;
            return ClassComponent.compareDeep(this.type, o.type, true) && ClassComponent.compareDeep(this.value, o.value, true) && ClassComponent.compareDeep(this.name, o.name, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClassComponent)) {
                return false;
            }
            ClassComponent o = (ClassComponent)other_;
            return ClassComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value, this.name});
        }

        @Override
        public String fhirType() {
            return "Coverage.class";
        }
    }

    @Block
    public static class CostToBeneficiaryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Cost category", formalDefinition="The category of patient centric costs associated with treatment.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/coverage-copay-type")
        protected CodeableConcept type;
        @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit classification", formalDefinition="Code to identify the general type of benefits under which products and services are provided.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
        protected CodeableConcept category;
        @Child(name="network", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="In or out of network", formalDefinition="Is a flag to indicate whether the benefits refer to in-network providers or out-of-network providers.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-network")
        protected CodeableConcept network;
        @Child(name="unit", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual or family", formalDefinition="Indicates if the benefits apply to an individual or to the family.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-unit")
        protected CodeableConcept unit;
        @Child(name="term", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Annual or lifetime", formalDefinition="The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual visits'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-term")
        protected CodeableConcept term;
        @Child(name="value", type={Quantity.class, Money.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The amount or percentage due from the beneficiary", formalDefinition="The amount due from the patient for the cost category.")
        protected DataType value;
        @Child(name="exception", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Exceptions for patient payments", formalDefinition="A suite of codes indicating exceptions or reductions to patient costs and their effective periods.")
        protected List<ExemptionComponent> exception;
        private static final long serialVersionUID = 472499753L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CostToBeneficiaryComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CostToBeneficiaryComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CostToBeneficiaryComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public CostToBeneficiaryComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getNetwork() {
            if (this.network == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CostToBeneficiaryComponent.network");
                }
                if (Configuration.doAutoCreate()) {
                    this.network = new CodeableConcept();
                }
            }
            return this.network;
        }

        public boolean hasNetwork() {
            return this.network != null && !this.network.isEmpty();
        }

        public CostToBeneficiaryComponent setNetwork(CodeableConcept value) {
            this.network = value;
            return this;
        }

        public CodeableConcept getUnit() {
            if (this.unit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CostToBeneficiaryComponent.unit");
                }
                if (Configuration.doAutoCreate()) {
                    this.unit = new CodeableConcept();
                }
            }
            return this.unit;
        }

        public boolean hasUnit() {
            return this.unit != null && !this.unit.isEmpty();
        }

        public CostToBeneficiaryComponent setUnit(CodeableConcept value) {
            this.unit = value;
            return this;
        }

        public CodeableConcept getTerm() {
            if (this.term == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CostToBeneficiaryComponent.term");
                }
                if (Configuration.doAutoCreate()) {
                    this.term = new CodeableConcept();
                }
            }
            return this.term;
        }

        public boolean hasTerm() {
            return this.term != null && !this.term.isEmpty();
        }

        public CostToBeneficiaryComponent setTerm(CodeableConcept value) {
            this.term = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this.value instanceof Quantity;
        }

        public Money getValueMoney() throws FHIRException {
            if (this.value == null) {
                this.value = new Money();
            }
            if (!(this.value instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Money)this.value;
        }

        public boolean hasValueMoney() {
            return this.value instanceof Money;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CostToBeneficiaryComponent setValue(DataType value) {
            if (value != null && !(value instanceof Quantity) && !(value instanceof Money)) {
                throw new FHIRException("Not the right type for Coverage.costToBeneficiary.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public List<ExemptionComponent> getException() {
            if (this.exception == null) {
                this.exception = new ArrayList<ExemptionComponent>();
            }
            return this.exception;
        }

        public CostToBeneficiaryComponent setException(List<ExemptionComponent> theException) {
            this.exception = theException;
            return this;
        }

        public boolean hasException() {
            if (this.exception == null) {
                return false;
            }
            for (ExemptionComponent item : this.exception) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExemptionComponent addException() {
            ExemptionComponent t = new ExemptionComponent();
            if (this.exception == null) {
                this.exception = new ArrayList<ExemptionComponent>();
            }
            this.exception.add(t);
            return t;
        }

        public CostToBeneficiaryComponent addException(ExemptionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.exception == null) {
                this.exception = new ArrayList<ExemptionComponent>();
            }
            this.exception.add(t);
            return this;
        }

        public ExemptionComponent getExceptionFirstRep() {
            if (this.getException().isEmpty()) {
                this.addException();
            }
            return this.getException().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Coverage.SP_TYPE, "CodeableConcept", "The category of patient centric costs associated with treatment.", 0, 1, this.type));
            children.add(new Property("category", "CodeableConcept", "Code to identify the general type of benefits under which products and services are provided.", 0, 1, this.category));
            children.add(new Property("network", "CodeableConcept", "Is a flag to indicate whether the benefits refer to in-network providers or out-of-network providers.", 0, 1, this.network));
            children.add(new Property("unit", "CodeableConcept", "Indicates if the benefits apply to an individual or to the family.", 0, 1, this.unit));
            children.add(new Property("term", "CodeableConcept", "The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual visits'.", 0, 1, this.term));
            children.add(new Property("value[x]", "Quantity|Money", "The amount due from the patient for the cost category.", 0, 1, this.value));
            children.add(new Property("exception", "", "A suite of codes indicating exceptions or reductions to patient costs and their effective periods.", 0, Integer.MAX_VALUE, this.exception));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Coverage.SP_TYPE, "CodeableConcept", "The category of patient centric costs associated with treatment.", 0, 1, this.type);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Code to identify the general type of benefits under which products and services are provided.", 0, 1, this.category);
                }
                case 1843485230: {
                    return new Property("network", "CodeableConcept", "Is a flag to indicate whether the benefits refer to in-network providers or out-of-network providers.", 0, 1, this.network);
                }
                case 3594628: {
                    return new Property("unit", "CodeableConcept", "Indicates if the benefits apply to an individual or to the family.", 0, 1, this.unit);
                }
                case 3556460: {
                    return new Property("term", "CodeableConcept", "The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual visits'.", 0, 1, this.term);
                }
                case -1410166417: {
                    return new Property("value[x]", "Quantity|Money", "The amount due from the patient for the cost category.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "Quantity|Money", "The amount due from the patient for the cost category.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The amount due from the patient for the cost category.", 0, 1, this.value);
                }
                case 2026560975: {
                    return new Property("value[x]", "Money", "The amount due from the patient for the cost category.", 0, 1, this.value);
                }
                case 1481625679: {
                    return new Property("exception", "", "A suite of codes indicating exceptions or reductions to patient costs and their effective periods.", 0, Integer.MAX_VALUE, this.exception);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.category;
                    }
                    return baseArray;
                }
                case 1843485230: {
                    Base[] baseArray;
                    if (this.network == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.network;
                    }
                    return baseArray;
                }
                case 3594628: {
                    Base[] baseArray;
                    if (this.unit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.unit;
                    }
                    return baseArray;
                }
                case 3556460: {
                    Base[] baseArray;
                    if (this.term == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.term;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.value;
                    }
                    return baseArray;
                }
                case 1481625679: {
                    return this.exception == null ? new Base[]{} : this.exception.toArray(new Base[this.exception.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1843485230: {
                    this.network = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3594628: {
                    this.unit = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3556460: {
                    this.term = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case 1481625679: {
                    this.getException().add((ExemptionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("category")) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("network")) {
                this.network = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("unit")) {
                this.unit = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("term")) {
                this.term = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals("exception")) {
                this.getException().add((ExemptionComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = null;
            } else if (name.equals("category")) {
                this.category = null;
            } else if (name.equals("network")) {
                this.network = null;
            } else if (name.equals("unit")) {
                this.unit = null;
            } else if (name.equals("term")) {
                this.term = null;
            } else if (name.equals("value[x]")) {
                this.value = null;
            } else if (name.equals("exception")) {
                this.getException().remove((ExemptionComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 1843485230: {
                    return this.getNetwork();
                }
                case 3594628: {
                    return this.getUnit();
                }
                case 3556460: {
                    return this.getTerm();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case 1481625679: {
                    return this.addException();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 1843485230: {
                    return new String[]{"CodeableConcept"};
                }
                case 3594628: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556460: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Quantity", "Money"};
                }
                case 1481625679: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("network")) {
                this.network = new CodeableConcept();
                return this.network;
            }
            if (name.equals("unit")) {
                this.unit = new CodeableConcept();
                return this.unit;
            }
            if (name.equals("term")) {
                this.term = new CodeableConcept();
                return this.term;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueMoney")) {
                this.value = new Money();
                return this.value;
            }
            if (name.equals("exception")) {
                return this.addException();
            }
            return super.addChild(name);
        }

        @Override
        public CostToBeneficiaryComponent copy() {
            CostToBeneficiaryComponent dst = new CostToBeneficiaryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CostToBeneficiaryComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.category = this.category == null ? null : this.category.copy();
            dst.network = this.network == null ? null : this.network.copy();
            dst.unit = this.unit == null ? null : this.unit.copy();
            dst.term = this.term == null ? null : this.term.copy();
            DataType dataType = dst.value = this.value == null ? null : this.value.copy();
            if (this.exception != null) {
                dst.exception = new ArrayList<ExemptionComponent>();
                for (ExemptionComponent i : this.exception) {
                    dst.exception.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CostToBeneficiaryComponent)) {
                return false;
            }
            CostToBeneficiaryComponent o = (CostToBeneficiaryComponent)other_;
            return CostToBeneficiaryComponent.compareDeep(this.type, o.type, true) && CostToBeneficiaryComponent.compareDeep(this.category, o.category, true) && CostToBeneficiaryComponent.compareDeep(this.network, o.network, true) && CostToBeneficiaryComponent.compareDeep(this.unit, o.unit, true) && CostToBeneficiaryComponent.compareDeep(this.term, o.term, true) && CostToBeneficiaryComponent.compareDeep(this.value, o.value, true) && CostToBeneficiaryComponent.compareDeep(this.exception, o.exception, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CostToBeneficiaryComponent)) {
                return false;
            }
            CostToBeneficiaryComponent o = (CostToBeneficiaryComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.category, this.network, this.unit, this.term, this.value, this.exception});
        }

        @Override
        public String fhirType() {
            return "Coverage.costToBeneficiary";
        }
    }

    @Block
    public static class ExemptionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Exception category", formalDefinition="The code for the specific exception.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/coverage-financial-exception")
        protected CodeableConcept type;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The effective period of the exception", formalDefinition="The timeframe the exception is in force.")
        protected Period period;
        private static final long serialVersionUID = 523191991L;

        public ExemptionComponent() {
        }

        public ExemptionComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExemptionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ExemptionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExemptionComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public ExemptionComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Coverage.SP_TYPE, "CodeableConcept", "The code for the specific exception.", 0, 1, this.type));
            children.add(new Property("period", "Period", "The timeframe the exception is in force.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Coverage.SP_TYPE, "CodeableConcept", "The code for the specific exception.", 0, 1, this.type);
                }
                case -991726143: {
                    return new Property("period", "Period", "The timeframe the exception is in force.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = null;
            } else if (name.equals("period")) {
                this.period = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Coverage.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public ExemptionComponent copy() {
            ExemptionComponent dst = new ExemptionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExemptionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExemptionComponent)) {
                return false;
            }
            ExemptionComponent o = (ExemptionComponent)other_;
            return ExemptionComponent.compareDeep(this.type, o.type, true) && ExemptionComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExemptionComponent)) {
                return false;
            }
            ExemptionComponent o = (ExemptionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.period});
        }

        @Override
        public String fhirType() {
            return "Coverage.costToBeneficiary.exception";
        }
    }
}

