/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BiologicallyDerivedProductDispense;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceAssociation;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EncounterHistory;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryItem;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestPlan;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DocumentReference", profile="http://hl7.org/fhir/StructureDefinition/DocumentReference")
public class DocumentReference
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifiers for the document", formalDefinition="Other business identifiers associated with the document, including version independent identifiers.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An explicitly assigned identifer of a variation of the content in the DocumentReference", formalDefinition="An explicitly assigned identifer of a variation of the content in the DocumentReference.")
    protected StringType version;
    @Child(name="basedOn", type={Appointment.class, AppointmentResponse.class, CarePlan.class, Claim.class, CommunicationRequest.class, Contract.class, CoverageEligibilityRequest.class, DeviceRequest.class, EnrollmentRequest.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, RequestOrchestration.class, ServiceRequest.class, SupplyRequest.class, VisionPrescription.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Procedure that caused this media to be created", formalDefinition="A procedure that is fulfilled in whole or in part by the creation of this media.")
    protected List<Reference> basedOn;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="current | superseded | entered-in-error", formalDefinition="The status of this document reference.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/document-reference-status")
    protected Enumeration<DocumentReferenceStatus> status;
    @Child(name="docStatus", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="registered | partial | preliminary | final | amended | corrected | appended | cancelled | entered-in-error | deprecated | unknown", formalDefinition="The status of the underlying document.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/composition-status")
    protected Enumeration<Enumerations.CompositionStatus> docStatus;
    @Child(name="modality", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Imaging modality used", formalDefinition="Imaging modality used. This may include both acquisition and non-acquisition modalities.")
    @Binding(valueSet="http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_33.html")
    protected List<CodeableConcept> modality;
    @Child(name="type", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of document (LOINC if possible)", formalDefinition="Specifies the particular kind of document referenced  (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/doc-typecodes")
    protected CodeableConcept type;
    @Child(name="category", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Categorization of document", formalDefinition="A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/referenced-item-category")
    protected List<CodeableConcept> category;
    @Child(name="subject", type={Reference.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/what is the subject of the document", formalDefinition="Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).")
    protected Reference subject;
    @Child(name="context", type={Appointment.class, Encounter.class, EpisodeOfCare.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Context of the document content", formalDefinition="Describes the clinical encounter or type of care that the document content is associated with.")
    protected List<Reference> context;
    @Child(name="event", type={CodeableReference.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Main clinical acts documented", formalDefinition="This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the type Code, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActCode")
    protected List<CodeableReference> event;
    @Child(name="bodySite", type={CodeableReference.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Body part included", formalDefinition="The anatomic structures included in the document.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected List<CodeableReference> bodySite;
    @Child(name="facilityType", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Kind of facility where patient was seen", formalDefinition="The kind of facility where the patient was seen.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-facilitycodes")
    protected CodeableConcept facilityType;
    @Child(name="practiceSetting", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Additional details about where the content was created (e.g. clinical specialty)", formalDefinition="This property may convey specifics about the practice setting where the content was created, often reflecting the clinical specialty.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    protected CodeableConcept practiceSetting;
    @Child(name="period", type={Period.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time of service that is being documented", formalDefinition="The time period over which the service that is described by the document was provided.")
    protected Period period;
    @Child(name="date", type={InstantType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When this document reference was created", formalDefinition="When the document reference was created.")
    protected InstantType date;
    @Child(name="author", type={Practitioner.class, PractitionerRole.class, Organization.class, Device.class, Patient.class, RelatedPerson.class, CareTeam.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what authored the document", formalDefinition="Identifies who is responsible for adding the information to the document.")
    protected List<Reference> author;
    @Child(name="attester", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Attests to accuracy of the document", formalDefinition="A participant who has authenticated the accuracy of the document.")
    protected List<DocumentReferenceAttesterComponent> attester;
    @Child(name="custodian", type={Organization.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization which maintains the document", formalDefinition="Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.")
    protected Reference custodian;
    @Child(name="relatesTo", type={}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Relationships to other documents", formalDefinition="Relationships that this document has with other document references that already exist.")
    protected List<DocumentReferenceRelatesToComponent> relatesTo;
    @Child(name="description", type={MarkdownType.class}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human-readable description", formalDefinition="Human-readable description of the source document.")
    protected MarkdownType description;
    @Child(name="securityLabel", type={CodeableConcept.class}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Document security-tags", formalDefinition="A set of Security-Tag codes specifying the level of privacy/security of the Document found at DocumentReference.content.attachment.url. Note that DocumentReference.meta.security contains the security labels of the data elements in DocumentReference, while DocumentReference.securityLabel contains the security labels for the document the reference refers to. The distinction recognizes that the document may contain sensitive information, while the DocumentReference is metadata about the document and thus might not be as sensitive as the document. For example: a psychotherapy episode may contain highly sensitive information, while the metadata may simply indicate that some episode happened.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-label-examples")
    protected List<CodeableConcept> securityLabel;
    @Child(name="content", type={}, order=22, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Document referenced", formalDefinition="The document and format referenced.  If there are multiple content element repetitions, these must all represent the same document in different format, or attachment metadata.")
    protected List<DocumentReferenceContentComponent> content;
    private static final long serialVersionUID = -981268007L;
    @SearchParamDefinition(name="attester", path="DocumentReference.attester.party", description="Who attested the document", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_ATTESTER = "attester";
    public static final ReferenceClientParam ATTESTER = new ReferenceClientParam("attester");
    public static final Include INCLUDE_ATTESTER = new Include("DocumentReference:attester").toLocked();
    @SearchParamDefinition(name="author", path="DocumentReference.author", description="Who and/or what authored the document", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={CareTeam.class, Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("DocumentReference:author").toLocked();
    @SearchParamDefinition(name="based-on", path="DocumentReference.basedOn", description="Procedure that caused this media to be created", type="reference", target={Appointment.class, AppointmentResponse.class, CarePlan.class, Claim.class, CommunicationRequest.class, Contract.class, CoverageEligibilityRequest.class, DeviceRequest.class, EnrollmentRequest.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, RequestOrchestration.class, ServiceRequest.class, SupplyRequest.class, VisionPrescription.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("DocumentReference:based-on").toLocked();
    @SearchParamDefinition(name="bodysite-reference", path="DocumentReference.bodySite.reference", description="The body site studied", type="reference", target={BodyStructure.class})
    public static final String SP_BODYSITE_REFERENCE = "bodysite-reference";
    public static final ReferenceClientParam BODYSITE_REFERENCE = new ReferenceClientParam("bodysite-reference");
    public static final Include INCLUDE_BODYSITE_REFERENCE = new Include("DocumentReference:bodysite-reference").toLocked();
    @SearchParamDefinition(name="bodysite", path="DocumentReference.bodySite.concept", description="The body site studied", type="token")
    public static final String SP_BODYSITE = "bodysite";
    public static final TokenClientParam BODYSITE = new TokenClientParam("bodysite");
    @SearchParamDefinition(name="category", path="DocumentReference.category", description="Categorization of document", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="contenttype", path="DocumentReference.content.attachment.contentType", description="Mime type of the content, with charset etc.", type="token")
    public static final String SP_CONTENTTYPE = "contenttype";
    public static final TokenClientParam CONTENTTYPE = new TokenClientParam("contenttype");
    @SearchParamDefinition(name="context", path="DocumentReference.context", description="Context of the document content", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Appointment.class, Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("DocumentReference:context").toLocked();
    @SearchParamDefinition(name="creation", path="DocumentReference.content.attachment.creation", description="Date attachment was first created", type="date")
    public static final String SP_CREATION = "creation";
    public static final DateClientParam CREATION = new DateClientParam("creation");
    @SearchParamDefinition(name="custodian", path="DocumentReference.custodian", description="Organization which maintains the document", type="reference", target={Organization.class})
    public static final String SP_CUSTODIAN = "custodian";
    public static final ReferenceClientParam CUSTODIAN = new ReferenceClientParam("custodian");
    public static final Include INCLUDE_CUSTODIAN = new Include("DocumentReference:custodian").toLocked();
    @SearchParamDefinition(name="description", path="DocumentReference.description", description="Human-readable description", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="doc-status", path="DocumentReference.docStatus", description="preliminary | final | amended | entered-in-error", type="token")
    public static final String SP_DOC_STATUS = "doc-status";
    public static final TokenClientParam DOC_STATUS = new TokenClientParam("doc-status");
    @SearchParamDefinition(name="event-code", path="DocumentReference.event.concept", description="Main clinical acts documented", type="token")
    public static final String SP_EVENT_CODE = "event-code";
    public static final TokenClientParam EVENT_CODE = new TokenClientParam("event-code");
    @SearchParamDefinition(name="event-reference", path="DocumentReference.event.reference", description="Main clinical acts documented", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProductDispense.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceAssociation.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentReference.class, Encounter.class, EncounterHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryItem.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Parameters.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestPlan.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_EVENT_REFERENCE = "event-reference";
    public static final ReferenceClientParam EVENT_REFERENCE = new ReferenceClientParam("event-reference");
    public static final Include INCLUDE_EVENT_REFERENCE = new Include("DocumentReference:event-reference").toLocked();
    @SearchParamDefinition(name="facility", path="DocumentReference.facilityType", description="Kind of facility where patient was seen", type="token")
    public static final String SP_FACILITY = "facility";
    public static final TokenClientParam FACILITY = new TokenClientParam("facility");
    @SearchParamDefinition(name="format-canonical", path="(DocumentReference.content.profile.value.ofType(canonical))", description="Profile canonical content rules for the document", type="reference", target={ActivityDefinition.class, ActorDefinition.class, CapabilityStatement.class, ChargeItemDefinition.class, Citation.class, CodeSystem.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, ConditionDefinition.class, Contract.class, Device.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, GraphDefinition.class, ImplementationGuide.class, Library.class, Measure.class, MessageDefinition.class, NamingSystem.class, ObservationDefinition.class, OperationDefinition.class, PlanDefinition.class, Questionnaire.class, Requirements.class, ResearchStudy.class, SearchParameter.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, SubscriptionTopic.class, TerminologyCapabilities.class, TestPlan.class, TestScript.class, ValueSet.class})
    public static final String SP_FORMAT_CANONICAL = "format-canonical";
    public static final ReferenceClientParam FORMAT_CANONICAL = new ReferenceClientParam("format-canonical");
    public static final Include INCLUDE_FORMAT_CANONICAL = new Include("DocumentReference:format-canonical").toLocked();
    @SearchParamDefinition(name="format-code", path="(DocumentReference.content.profile.value.ofType(Coding))", description="Format code content rules for the document", type="token")
    public static final String SP_FORMAT_CODE = "format-code";
    public static final TokenClientParam FORMAT_CODE = new TokenClientParam("format-code");
    @SearchParamDefinition(name="format-uri", path="(DocumentReference.content.profile.value.ofType(uri))", description="Profile URI content rules for the document", type="uri")
    public static final String SP_FORMAT_URI = "format-uri";
    public static final UriClientParam FORMAT_URI = new UriClientParam("format-uri");
    @SearchParamDefinition(name="language", path="DocumentReference.content.attachment.language", description="Human language of the content (BCP-47)", type="token")
    public static final String SP_LANGUAGE = "language";
    public static final TokenClientParam LANGUAGE = new TokenClientParam("language");
    @SearchParamDefinition(name="location", path="DocumentReference.content.attachment.url", description="Uri where the data can be found", type="uri")
    public static final String SP_LOCATION = "location";
    public static final UriClientParam LOCATION = new UriClientParam("location");
    @SearchParamDefinition(name="modality", path="DocumentReference.modality", description="The modality used", type="token")
    public static final String SP_MODALITY = "modality";
    public static final TokenClientParam MODALITY = new TokenClientParam("modality");
    @SearchParamDefinition(name="period", path="DocumentReference.period", description="Time of service that is being documented", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="relatesto", path="DocumentReference.relatesTo.target", description="Target of the relationship", type="reference", target={DocumentReference.class})
    public static final String SP_RELATESTO = "relatesto";
    public static final ReferenceClientParam RELATESTO = new ReferenceClientParam("relatesto");
    public static final Include INCLUDE_RELATESTO = new Include("DocumentReference:relatesto").toLocked();
    @SearchParamDefinition(name="relation", path="DocumentReference.relatesTo.code", description="replaces | transforms | signs | appends", type="token")
    public static final String SP_RELATION = "relation";
    public static final TokenClientParam RELATION = new TokenClientParam("relation");
    @SearchParamDefinition(name="relationship", path="DocumentReference.relatesTo", description="Combination of relation and relatesTo", type="composite", compositeOf={"relatesto", "relation"})
    public static final String SP_RELATIONSHIP = "relationship";
    public static final CompositeClientParam<ReferenceClientParam, TokenClientParam> RELATIONSHIP = new CompositeClientParam("relationship");
    @SearchParamDefinition(name="security-label", path="DocumentReference.securityLabel", description="Document security-tags", type="token")
    public static final String SP_SECURITY_LABEL = "security-label";
    public static final TokenClientParam SECURITY_LABEL = new TokenClientParam("security-label");
    @SearchParamDefinition(name="setting", path="DocumentReference.practiceSetting", description="Additional details about where the content was created (e.g. clinical specialty)", type="token")
    public static final String SP_SETTING = "setting";
    public static final TokenClientParam SETTING = new TokenClientParam("setting");
    @SearchParamDefinition(name="status", path="DocumentReference.status", description="current | superseded | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="DocumentReference.subject", description="Who/what is the subject of the document", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProductDispense.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceAssociation.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentReference.class, Encounter.class, EncounterHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryItem.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Parameters.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestPlan.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DocumentReference:subject").toLocked();
    @SearchParamDefinition(name="version", path="DocumentReference.version", description="The business version identifier", type="string")
    public static final String SP_VERSION = "version";
    public static final StringClientParam VERSION = new StringClientParam("version");
    @SearchParamDefinition(name="date", path="AdverseEvent.occurrence.ofType(dateTime) | AdverseEvent.occurrence.ofType(Period) | AdverseEvent.occurrence.ofType(Timing) | AllergyIntolerance.recordedDate | (start | requestedPeriod.start).first() | AuditEvent.recorded | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.ofType(dateTime) | DiagnosticReport.effective.ofType(Period) | DocumentReference.date | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence.ofType(dateTime)) | ImmunizationEvaluation.date | ImmunizationRecommendation.date | Invoice.date | List.date | MeasureReport.date | NutritionIntake.occurrence.ofType(dateTime) | NutritionIntake.occurrence.ofType(Period) | Observation.effective.ofType(dateTime) | Observation.effective.ofType(Period) | Observation.effective.ofType(Timing) | Observation.effective.ofType(instant) | Procedure.occurrence.ofType(dateTime) | Procedure.occurrence.ofType(Period) | Procedure.occurrence.ofType(Timing) | ResearchSubject.period | (RiskAssessment.occurrence.ofType(dateTime)) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): When the event occurred\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [Appointment](appointment.html): Appointment date/time.\r\n* [AuditEvent](auditevent.html): Time when the event was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [DocumentReference](documentreference.html): When this document reference was created\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [ImmunizationEvaluation](immunizationevaluation.html): Date the evaluation was generated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Date recommendation(s) created\r\n* [Invoice](invoice.html): Invoice date / posting date\r\n* [List](list.html): When the list was prepared\r\n* [MeasureReport](measurereport.html): The date of the measure report\r\n* [NutritionIntake](nutritionintake.html): Date when patient was taking (or not taking) the medication\r\n* [Observation](observation.html): Clinically relevant time/time-period for observation\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [ResearchSubject](researchsubject.html): Start and end of participation\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DocumentReference:patient").toLocked();
    @SearchParamDefinition(name="type", path="Account.type | AllergyIntolerance.type | Composition.type | Coverage.type | DocumentReference.type | Encounter.type | EpisodeOfCare.type | Invoice.type | MedicationDispense.type | MolecularSequence.type | Specimen.type", description="Multiple Resources: \r\n\r\n* [Account](account.html): E.g. patient, expense, depreciation\r\n* [AllergyIntolerance](allergyintolerance.html): allergy | intolerance - Underlying mechanism (if known)\r\n* [Composition](composition.html): Kind of composition (LOINC if possible)\r\n* [Coverage](coverage.html): The kind of coverage (health plan, auto, Workers Compensation)\r\n* [DocumentReference](documentreference.html): Kind of document (LOINC if possible)\r\n* [Encounter](encounter.html): Specific type of encounter\r\n* [EpisodeOfCare](episodeofcare.html): Type/class  - e.g. specialist referral, disease management\r\n* [Invoice](invoice.html): Type of Invoice\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of a specific type\r\n* [MolecularSequence](molecularsequence.html): Amino Acid Sequence/ DNA Sequence / RNA Sequence\r\n* [Specimen](specimen.html): The specimen type\r\n", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public DocumentReference() {
    }

    public DocumentReference(DocumentReferenceStatus status, DocumentReferenceContentComponent content) {
        this.setStatus(status);
        this.addContent(content);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DocumentReference setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DocumentReference addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public DocumentReference setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public DocumentReference setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public DocumentReference setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public DocumentReference addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Enumeration<DocumentReferenceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DocumentReferenceStatus>(new DocumentReferenceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DocumentReference setStatusElement(Enumeration<DocumentReferenceStatus> value) {
        this.status = value;
        return this;
    }

    public DocumentReferenceStatus getStatus() {
        return this.status == null ? null : (DocumentReferenceStatus)((Object)this.status.getValue());
    }

    public DocumentReference setStatus(DocumentReferenceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<DocumentReferenceStatus>(new DocumentReferenceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<Enumerations.CompositionStatus> getDocStatusElement() {
        if (this.docStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.docStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.docStatus = new Enumeration<Enumerations.CompositionStatus>(new Enumerations.CompositionStatusEnumFactory());
            }
        }
        return this.docStatus;
    }

    public boolean hasDocStatusElement() {
        return this.docStatus != null && !this.docStatus.isEmpty();
    }

    public boolean hasDocStatus() {
        return this.docStatus != null && !this.docStatus.isEmpty();
    }

    public DocumentReference setDocStatusElement(Enumeration<Enumerations.CompositionStatus> value) {
        this.docStatus = value;
        return this;
    }

    public Enumerations.CompositionStatus getDocStatus() {
        return this.docStatus == null ? null : (Enumerations.CompositionStatus)((Object)this.docStatus.getValue());
    }

    public DocumentReference setDocStatus(Enumerations.CompositionStatus value) {
        if (value == null) {
            this.docStatus = null;
        } else {
            if (this.docStatus == null) {
                this.docStatus = new Enumeration<Enumerations.CompositionStatus>(new Enumerations.CompositionStatusEnumFactory());
            }
            this.docStatus.setValue((Object)value);
        }
        return this;
    }

    public List<CodeableConcept> getModality() {
        if (this.modality == null) {
            this.modality = new ArrayList<CodeableConcept>();
        }
        return this.modality;
    }

    public DocumentReference setModality(List<CodeableConcept> theModality) {
        this.modality = theModality;
        return this;
    }

    public boolean hasModality() {
        if (this.modality == null) {
            return false;
        }
        for (CodeableConcept item : this.modality) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addModality() {
        CodeableConcept t = new CodeableConcept();
        if (this.modality == null) {
            this.modality = new ArrayList<CodeableConcept>();
        }
        this.modality.add(t);
        return t;
    }

    public DocumentReference addModality(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.modality == null) {
            this.modality = new ArrayList<CodeableConcept>();
        }
        this.modality.add(t);
        return this;
    }

    public CodeableConcept getModalityFirstRep() {
        if (this.getModality().isEmpty()) {
            this.addModality();
        }
        return this.getModality().get(0);
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DocumentReference setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public DocumentReference setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public DocumentReference addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DocumentReference setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public List<Reference> getContext() {
        if (this.context == null) {
            this.context = new ArrayList<Reference>();
        }
        return this.context;
    }

    public DocumentReference setContext(List<Reference> theContext) {
        this.context = theContext;
        return this;
    }

    public boolean hasContext() {
        if (this.context == null) {
            return false;
        }
        for (Reference item : this.context) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addContext() {
        Reference t = new Reference();
        if (this.context == null) {
            this.context = new ArrayList<Reference>();
        }
        this.context.add(t);
        return t;
    }

    public DocumentReference addContext(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.context == null) {
            this.context = new ArrayList<Reference>();
        }
        this.context.add(t);
        return this;
    }

    public Reference getContextFirstRep() {
        if (this.getContext().isEmpty()) {
            this.addContext();
        }
        return this.getContext().get(0);
    }

    public List<CodeableReference> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<CodeableReference>();
        }
        return this.event;
    }

    public DocumentReference setEvent(List<CodeableReference> theEvent) {
        this.event = theEvent;
        return this;
    }

    public boolean hasEvent() {
        if (this.event == null) {
            return false;
        }
        for (CodeableReference item : this.event) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addEvent() {
        CodeableReference t = new CodeableReference();
        if (this.event == null) {
            this.event = new ArrayList<CodeableReference>();
        }
        this.event.add(t);
        return t;
    }

    public DocumentReference addEvent(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.event == null) {
            this.event = new ArrayList<CodeableReference>();
        }
        this.event.add(t);
        return this;
    }

    public CodeableReference getEventFirstRep() {
        if (this.getEvent().isEmpty()) {
            this.addEvent();
        }
        return this.getEvent().get(0);
    }

    public List<CodeableReference> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableReference>();
        }
        return this.bodySite;
    }

    public DocumentReference setBodySite(List<CodeableReference> theBodySite) {
        this.bodySite = theBodySite;
        return this;
    }

    public boolean hasBodySite() {
        if (this.bodySite == null) {
            return false;
        }
        for (CodeableReference item : this.bodySite) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addBodySite() {
        CodeableReference t = new CodeableReference();
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableReference>();
        }
        this.bodySite.add(t);
        return t;
    }

    public DocumentReference addBodySite(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableReference>();
        }
        this.bodySite.add(t);
        return this;
    }

    public CodeableReference getBodySiteFirstRep() {
        if (this.getBodySite().isEmpty()) {
            this.addBodySite();
        }
        return this.getBodySite().get(0);
    }

    public CodeableConcept getFacilityType() {
        if (this.facilityType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.facilityType");
            }
            if (Configuration.doAutoCreate()) {
                this.facilityType = new CodeableConcept();
            }
        }
        return this.facilityType;
    }

    public boolean hasFacilityType() {
        return this.facilityType != null && !this.facilityType.isEmpty();
    }

    public DocumentReference setFacilityType(CodeableConcept value) {
        this.facilityType = value;
        return this;
    }

    public CodeableConcept getPracticeSetting() {
        if (this.practiceSetting == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.practiceSetting");
            }
            if (Configuration.doAutoCreate()) {
                this.practiceSetting = new CodeableConcept();
            }
        }
        return this.practiceSetting;
    }

    public boolean hasPracticeSetting() {
        return this.practiceSetting != null && !this.practiceSetting.isEmpty();
    }

    public DocumentReference setPracticeSetting(CodeableConcept value) {
        this.practiceSetting = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public DocumentReference setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public InstantType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new InstantType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public DocumentReference setDateElement(InstantType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public DocumentReference setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new InstantType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public DocumentReference setAuthor(List<Reference> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (Reference item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAuthor() {
        Reference t = new Reference();
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return t;
    }

    public DocumentReference addAuthor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return this;
    }

    public Reference getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    public List<DocumentReferenceAttesterComponent> getAttester() {
        if (this.attester == null) {
            this.attester = new ArrayList<DocumentReferenceAttesterComponent>();
        }
        return this.attester;
    }

    public DocumentReference setAttester(List<DocumentReferenceAttesterComponent> theAttester) {
        this.attester = theAttester;
        return this;
    }

    public boolean hasAttester() {
        if (this.attester == null) {
            return false;
        }
        for (DocumentReferenceAttesterComponent item : this.attester) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DocumentReferenceAttesterComponent addAttester() {
        DocumentReferenceAttesterComponent t = new DocumentReferenceAttesterComponent();
        if (this.attester == null) {
            this.attester = new ArrayList<DocumentReferenceAttesterComponent>();
        }
        this.attester.add(t);
        return t;
    }

    public DocumentReference addAttester(DocumentReferenceAttesterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.attester == null) {
            this.attester = new ArrayList<DocumentReferenceAttesterComponent>();
        }
        this.attester.add(t);
        return this;
    }

    public DocumentReferenceAttesterComponent getAttesterFirstRep() {
        if (this.getAttester().isEmpty()) {
            this.addAttester();
        }
        return this.getAttester().get(0);
    }

    public Reference getCustodian() {
        if (this.custodian == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.custodian");
            }
            if (Configuration.doAutoCreate()) {
                this.custodian = new Reference();
            }
        }
        return this.custodian;
    }

    public boolean hasCustodian() {
        return this.custodian != null && !this.custodian.isEmpty();
    }

    public DocumentReference setCustodian(Reference value) {
        this.custodian = value;
        return this;
    }

    public List<DocumentReferenceRelatesToComponent> getRelatesTo() {
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
        }
        return this.relatesTo;
    }

    public DocumentReference setRelatesTo(List<DocumentReferenceRelatesToComponent> theRelatesTo) {
        this.relatesTo = theRelatesTo;
        return this;
    }

    public boolean hasRelatesTo() {
        if (this.relatesTo == null) {
            return false;
        }
        for (DocumentReferenceRelatesToComponent item : this.relatesTo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DocumentReferenceRelatesToComponent addRelatesTo() {
        DocumentReferenceRelatesToComponent t = new DocumentReferenceRelatesToComponent();
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
        }
        this.relatesTo.add(t);
        return t;
    }

    public DocumentReference addRelatesTo(DocumentReferenceRelatesToComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
        }
        this.relatesTo.add(t);
        return this;
    }

    public DocumentReferenceRelatesToComponent getRelatesToFirstRep() {
        if (this.getRelatesTo().isEmpty()) {
            this.addRelatesTo();
        }
        return this.getRelatesTo().get(0);
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public DocumentReference setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public DocumentReference setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getSecurityLabel() {
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<CodeableConcept>();
        }
        return this.securityLabel;
    }

    public DocumentReference setSecurityLabel(List<CodeableConcept> theSecurityLabel) {
        this.securityLabel = theSecurityLabel;
        return this;
    }

    public boolean hasSecurityLabel() {
        if (this.securityLabel == null) {
            return false;
        }
        for (CodeableConcept item : this.securityLabel) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSecurityLabel() {
        CodeableConcept t = new CodeableConcept();
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<CodeableConcept>();
        }
        this.securityLabel.add(t);
        return t;
    }

    public DocumentReference addSecurityLabel(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<CodeableConcept>();
        }
        this.securityLabel.add(t);
        return this;
    }

    public CodeableConcept getSecurityLabelFirstRep() {
        if (this.getSecurityLabel().isEmpty()) {
            this.addSecurityLabel();
        }
        return this.getSecurityLabel().get(0);
    }

    public List<DocumentReferenceContentComponent> getContent() {
        if (this.content == null) {
            this.content = new ArrayList<DocumentReferenceContentComponent>();
        }
        return this.content;
    }

    public DocumentReference setContent(List<DocumentReferenceContentComponent> theContent) {
        this.content = theContent;
        return this;
    }

    public boolean hasContent() {
        if (this.content == null) {
            return false;
        }
        for (DocumentReferenceContentComponent item : this.content) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DocumentReferenceContentComponent addContent() {
        DocumentReferenceContentComponent t = new DocumentReferenceContentComponent();
        if (this.content == null) {
            this.content = new ArrayList<DocumentReferenceContentComponent>();
        }
        this.content.add(t);
        return t;
    }

    public DocumentReference addContent(DocumentReferenceContentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.content == null) {
            this.content = new ArrayList<DocumentReferenceContentComponent>();
        }
        this.content.add(t);
        return this;
    }

    public DocumentReferenceContentComponent getContentFirstRep() {
        if (this.getContent().isEmpty()) {
            this.addContent();
        }
        return this.getContent().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Other business identifiers associated with the document, including version independent identifiers.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "An explicitly assigned identifer of a variation of the content in the DocumentReference.", 0, 1, this.version));
        children.add(new Property("basedOn", "Reference(Appointment|AppointmentResponse|CarePlan|Claim|CommunicationRequest|Contract|CoverageEligibilityRequest|DeviceRequest|EnrollmentRequest|ImmunizationRecommendation|MedicationRequest|NutritionOrder|RequestOrchestration|ServiceRequest|SupplyRequest|VisionPrescription)", "A procedure that is fulfilled in whole or in part by the creation of this media.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_STATUS, "code", "The status of this document reference.", 0, 1, this.status));
        children.add(new Property("docStatus", "code", "The status of the underlying document.", 0, 1, this.docStatus));
        children.add(new Property(SP_MODALITY, "CodeableConcept", "Imaging modality used. This may include both acquisition and non-acquisition modalities.", 0, Integer.MAX_VALUE, this.modality));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Specifies the particular kind of document referenced  (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.", 0, 1, this.type));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_SUBJECT, "Reference(Any)", "Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).", 0, 1, this.subject));
        children.add(new Property(SP_CONTEXT, "Reference(Appointment|Encounter|EpisodeOfCare)", "Describes the clinical encounter or type of care that the document content is associated with.", 0, Integer.MAX_VALUE, this.context));
        children.add(new Property("event", "CodeableReference", "This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the type Code, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.", 0, Integer.MAX_VALUE, this.event));
        children.add(new Property("bodySite", "CodeableReference(BodyStructure)", "The anatomic structures included in the document.", 0, Integer.MAX_VALUE, this.bodySite));
        children.add(new Property("facilityType", "CodeableConcept", "The kind of facility where the patient was seen.", 0, 1, this.facilityType));
        children.add(new Property("practiceSetting", "CodeableConcept", "This property may convey specifics about the practice setting where the content was created, often reflecting the clinical specialty.", 0, 1, this.practiceSetting));
        children.add(new Property(SP_PERIOD, "Period", "The time period over which the service that is described by the document was provided.", 0, 1, this.period));
        children.add(new Property(SP_DATE, "instant", "When the document reference was created.", 0, 1, this.date));
        children.add(new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Organization|Device|Patient|RelatedPerson|CareTeam)", "Identifies who is responsible for adding the information to the document.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property(SP_ATTESTER, "", "A participant who has authenticated the accuracy of the document.", 0, Integer.MAX_VALUE, this.attester));
        children.add(new Property(SP_CUSTODIAN, "Reference(Organization)", "Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.", 0, 1, this.custodian));
        children.add(new Property("relatesTo", "", "Relationships that this document has with other document references that already exist.", 0, Integer.MAX_VALUE, this.relatesTo));
        children.add(new Property(SP_DESCRIPTION, "markdown", "Human-readable description of the source document.", 0, 1, this.description));
        children.add(new Property("securityLabel", "CodeableConcept", "A set of Security-Tag codes specifying the level of privacy/security of the Document found at DocumentReference.content.attachment.url. Note that DocumentReference.meta.security contains the security labels of the data elements in DocumentReference, while DocumentReference.securityLabel contains the security labels for the document the reference refers to. The distinction recognizes that the document may contain sensitive information, while the DocumentReference is metadata about the document and thus might not be as sensitive as the document. For example: a psychotherapy episode may contain highly sensitive information, while the metadata may simply indicate that some episode happened.", 0, Integer.MAX_VALUE, this.securityLabel));
        children.add(new Property("content", "", "The document and format referenced.  If there are multiple content element repetitions, these must all represent the same document in different format, or attachment metadata.", 0, Integer.MAX_VALUE, this.content));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Other business identifiers associated with the document, including version independent identifiers.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "An explicitly assigned identifer of a variation of the content in the DocumentReference.", 0, 1, this.version);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(Appointment|AppointmentResponse|CarePlan|Claim|CommunicationRequest|Contract|CoverageEligibilityRequest|DeviceRequest|EnrollmentRequest|ImmunizationRecommendation|MedicationRequest|NutritionOrder|RequestOrchestration|ServiceRequest|SupplyRequest|VisionPrescription)", "A procedure that is fulfilled in whole or in part by the creation of this media.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this document reference.", 0, 1, this.status);
            }
            case -23496886: {
                return new Property("docStatus", "code", "The status of the underlying document.", 0, 1, this.docStatus);
            }
            case -622722335: {
                return new Property(SP_MODALITY, "CodeableConcept", "Imaging modality used. This may include both acquisition and non-acquisition modalities.", 0, Integer.MAX_VALUE, this.modality);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Specifies the particular kind of document referenced  (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.", 0, 1, this.type);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type.", 0, Integer.MAX_VALUE, this.category);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Any)", "Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Appointment|Encounter|EpisodeOfCare)", "Describes the clinical encounter or type of care that the document content is associated with.", 0, Integer.MAX_VALUE, this.context);
            }
            case 96891546: {
                return new Property("event", "CodeableReference", "This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the type Code, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.", 0, Integer.MAX_VALUE, this.event);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableReference(BodyStructure)", "The anatomic structures included in the document.", 0, Integer.MAX_VALUE, this.bodySite);
            }
            case 370698365: {
                return new Property("facilityType", "CodeableConcept", "The kind of facility where the patient was seen.", 0, 1, this.facilityType);
            }
            case 331373717: {
                return new Property("practiceSetting", "CodeableConcept", "This property may convey specifics about the practice setting where the content was created, often reflecting the clinical specialty.", 0, 1, this.practiceSetting);
            }
            case -991726143: {
                return new Property(SP_PERIOD, "Period", "The time period over which the service that is described by the document was provided.", 0, 1, this.period);
            }
            case 3076014: {
                return new Property(SP_DATE, "instant", "When the document reference was created.", 0, 1, this.date);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Organization|Device|Patient|RelatedPerson|CareTeam)", "Identifies who is responsible for adding the information to the document.", 0, Integer.MAX_VALUE, this.author);
            }
            case 542920370: {
                return new Property(SP_ATTESTER, "", "A participant who has authenticated the accuracy of the document.", 0, Integer.MAX_VALUE, this.attester);
            }
            case 1611297262: {
                return new Property(SP_CUSTODIAN, "Reference(Organization)", "Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.", 0, 1, this.custodian);
            }
            case -7765931: {
                return new Property("relatesTo", "", "Relationships that this document has with other document references that already exist.", 0, Integer.MAX_VALUE, this.relatesTo);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "Human-readable description of the source document.", 0, 1, this.description);
            }
            case -722296940: {
                return new Property("securityLabel", "CodeableConcept", "A set of Security-Tag codes specifying the level of privacy/security of the Document found at DocumentReference.content.attachment.url. Note that DocumentReference.meta.security contains the security labels of the data elements in DocumentReference, while DocumentReference.securityLabel contains the security labels for the document the reference refers to. The distinction recognizes that the document may contain sensitive information, while the DocumentReference is metadata about the document and thus might not be as sensitive as the document. For example: a psychotherapy episode may contain highly sensitive information, while the metadata may simply indicate that some episode happened.", 0, Integer.MAX_VALUE, this.securityLabel);
            }
            case 951530617: {
                return new Property("content", "", "The document and format referenced.  If there are multiple content element repetitions, these must all represent the same document in different format, or attachment metadata.", 0, Integer.MAX_VALUE, this.content);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.version;
                }
                return baseArray;
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -23496886: {
                Base[] baseArray;
                if (this.docStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.docStatus;
                }
                return baseArray;
            }
            case -622722335: {
                return this.modality == null ? new Base[]{} : this.modality.toArray(new Base[this.modality.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.type;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                return this.context == null ? new Base[]{} : this.context.toArray(new Base[this.context.size()]);
            }
            case 96891546: {
                return this.event == null ? new Base[]{} : this.event.toArray(new Base[this.event.size()]);
            }
            case 1702620169: {
                return this.bodySite == null ? new Base[]{} : this.bodySite.toArray(new Base[this.bodySite.size()]);
            }
            case 370698365: {
                Base[] baseArray;
                if (this.facilityType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.facilityType;
                }
                return baseArray;
            }
            case 331373717: {
                Base[] baseArray;
                if (this.practiceSetting == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.practiceSetting;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.period;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.date;
                }
                return baseArray;
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case 542920370: {
                return this.attester == null ? new Base[]{} : this.attester.toArray(new Base[this.attester.size()]);
            }
            case 1611297262: {
                Base[] baseArray;
                if (this.custodian == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.custodian;
                }
                return baseArray;
            }
            case -7765931: {
                return this.relatesTo == null ? new Base[]{} : this.relatesTo.toArray(new Base[this.relatesTo.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.description;
                }
                return baseArray;
            }
            case -722296940: {
                return this.securityLabel == null ? new Base[]{} : this.securityLabel.toArray(new Base[this.securityLabel.size()]);
            }
            case 951530617: {
                return this.content == null ? new Base[]{} : this.content.toArray(new Base[this.content.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new DocumentReferenceStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -23496886: {
                value = new Enumerations.CompositionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.docStatus = value;
                return value;
            }
            case -622722335: {
                this.getModality().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 951530927: {
                this.getContext().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 96891546: {
                this.getEvent().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 1702620169: {
                this.getBodySite().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 370698365: {
                this.facilityType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 331373717: {
                this.practiceSetting = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToInstant(value);
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 542920370: {
                this.getAttester().add((DocumentReferenceAttesterComponent)((Object)value));
                return value;
            }
            case 1611297262: {
                this.custodian = TypeConvertor.castToReference(value);
                return value;
            }
            case -7765931: {
                this.getRelatesTo().add((DocumentReferenceRelatesToComponent)((Object)value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -722296940: {
                this.getSecurityLabel().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 951530617: {
                this.getContent().add((DocumentReferenceContentComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new DocumentReferenceStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("docStatus")) {
            value = new Enumerations.CompositionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.docStatus = value;
        } else if (name.equals(SP_MODALITY)) {
            this.getModality().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.getContext().add(TypeConvertor.castToReference(value));
        } else if (name.equals("event")) {
            this.getEvent().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("bodySite")) {
            this.getBodySite().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("facilityType")) {
            this.facilityType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("practiceSetting")) {
            this.practiceSetting = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_PERIOD)) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToInstant(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.getAuthor().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_ATTESTER)) {
            this.getAttester().add((DocumentReferenceAttesterComponent)((Object)value));
        } else if (name.equals(SP_CUSTODIAN)) {
            this.custodian = TypeConvertor.castToReference(value);
        } else if (name.equals("relatesTo")) {
            this.getRelatesTo().add((DocumentReferenceRelatesToComponent)((Object)value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("securityLabel")) {
            this.getSecurityLabel().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("content")) {
            this.getContent().add((DocumentReferenceContentComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = null;
        } else if (name.equals("basedOn")) {
            this.getBasedOn().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new DocumentReferenceStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("docStatus")) {
            value = new Enumerations.CompositionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.docStatus = value;
        } else if (name.equals(SP_MODALITY)) {
            this.getModality().remove(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = null;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().remove(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals(SP_CONTEXT)) {
            this.getContext().remove(value);
        } else if (name.equals("event")) {
            this.getEvent().remove(value);
        } else if (name.equals("bodySite")) {
            this.getBodySite().remove(value);
        } else if (name.equals("facilityType")) {
            this.facilityType = null;
        } else if (name.equals("practiceSetting")) {
            this.practiceSetting = null;
        } else if (name.equals(SP_PERIOD)) {
            this.period = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals(SP_AUTHOR)) {
            this.getAuthor().remove(value);
        } else if (name.equals(SP_ATTESTER)) {
            this.getAttester().remove((DocumentReferenceAttesterComponent)((Object)value));
        } else if (name.equals(SP_CUSTODIAN)) {
            this.custodian = null;
        } else if (name.equals("relatesTo")) {
            this.getRelatesTo().remove((DocumentReferenceRelatesToComponent)((Object)value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = null;
        } else if (name.equals("securityLabel")) {
            this.getSecurityLabel().remove(value);
        } else if (name.equals("content")) {
            this.getContent().remove((DocumentReferenceContentComponent)((Object)value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -23496886: {
                return this.getDocStatusElement();
            }
            case -622722335: {
                return this.addModality();
            }
            case 3575610: {
                return this.getType();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.addContext();
            }
            case 96891546: {
                return this.addEvent();
            }
            case 1702620169: {
                return this.addBodySite();
            }
            case 370698365: {
                return this.getFacilityType();
            }
            case 331373717: {
                return this.getPracticeSetting();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case 542920370: {
                return this.addAttester();
            }
            case 1611297262: {
                return this.getCustodian();
            }
            case -7765931: {
                return this.addRelatesTo();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -722296940: {
                return this.addSecurityLabel();
            }
            case 951530617: {
                return this.addContent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -23496886: {
                return new String[]{"code"};
            }
            case -622722335: {
                return new String[]{"CodeableConcept"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case 96891546: {
                return new String[]{"CodeableReference"};
            }
            case 1702620169: {
                return new String[]{"CodeableReference"};
            }
            case 370698365: {
                return new String[]{"CodeableConcept"};
            }
            case 331373717: {
                return new String[]{"CodeableConcept"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 3076014: {
                return new String[]{"instant"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case 542920370: {
                return new String[0];
            }
            case 1611297262: {
                return new String[]{"Reference"};
            }
            case -7765931: {
                return new String[0];
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -722296940: {
                return new String[]{"CodeableConcept"};
            }
            case 951530617: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property DocumentReference.version");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property DocumentReference.status");
        }
        if (name.equals("docStatus")) {
            throw new FHIRException("Cannot call addChild on a singleton property DocumentReference.docStatus");
        }
        if (name.equals(SP_MODALITY)) {
            return this.addModality();
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            return this.addContext();
        }
        if (name.equals("event")) {
            return this.addEvent();
        }
        if (name.equals("bodySite")) {
            return this.addBodySite();
        }
        if (name.equals("facilityType")) {
            this.facilityType = new CodeableConcept();
            return this.facilityType;
        }
        if (name.equals("practiceSetting")) {
            this.practiceSetting = new CodeableConcept();
            return this.practiceSetting;
        }
        if (name.equals(SP_PERIOD)) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property DocumentReference.date");
        }
        if (name.equals(SP_AUTHOR)) {
            return this.addAuthor();
        }
        if (name.equals(SP_ATTESTER)) {
            return this.addAttester();
        }
        if (name.equals(SP_CUSTODIAN)) {
            this.custodian = new Reference();
            return this.custodian;
        }
        if (name.equals("relatesTo")) {
            return this.addRelatesTo();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property DocumentReference.description");
        }
        if (name.equals("securityLabel")) {
            return this.addSecurityLabel();
        }
        if (name.equals("content")) {
            return this.addContent();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DocumentReference";
    }

    @Override
    public DocumentReference copy() {
        DocumentReference dst = new DocumentReference();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DocumentReference dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        StringType stringType = dst.version = this.version == null ? null : this.version.copy();
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        Enumeration<Enumerations.CompositionStatus> enumeration = dst.docStatus = this.docStatus == null ? null : this.docStatus.copy();
        if (this.modality != null) {
            dst.modality = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.modality) {
                dst.modality.add(codeableConcept.copy());
            }
        }
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.category) {
                dst.category.add(codeableConcept2.copy());
            }
        }
        Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.context != null) {
            dst.context = new ArrayList<Reference>();
            for (Reference reference2 : this.context) {
                dst.context.add(reference2.copy());
            }
        }
        if (this.event != null) {
            dst.event = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.event) {
                dst.event.add(codeableReference.copy());
            }
        }
        if (this.bodySite != null) {
            dst.bodySite = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.bodySite) {
                dst.bodySite.add(codeableReference.copy());
            }
        }
        dst.facilityType = this.facilityType == null ? null : this.facilityType.copy();
        dst.practiceSetting = this.practiceSetting == null ? null : this.practiceSetting.copy();
        dst.period = this.period == null ? null : this.period.copy();
        InstantType instantType = dst.date = this.date == null ? null : this.date.copy();
        if (this.author != null) {
            dst.author = new ArrayList<Reference>();
            for (Reference reference3 : this.author) {
                dst.author.add(reference3.copy());
            }
        }
        if (this.attester != null) {
            dst.attester = new ArrayList<DocumentReferenceAttesterComponent>();
            for (DocumentReferenceAttesterComponent documentReferenceAttesterComponent : this.attester) {
                dst.attester.add(documentReferenceAttesterComponent.copy());
            }
        }
        Reference reference4 = dst.custodian = this.custodian == null ? null : this.custodian.copy();
        if (this.relatesTo != null) {
            dst.relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
            for (DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : this.relatesTo) {
                dst.relatesTo.add(documentReferenceRelatesToComponent.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.securityLabel != null) {
            dst.securityLabel = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.securityLabel) {
                dst.securityLabel.add(codeableConcept3.copy());
            }
        }
        if (this.content != null) {
            dst.content = new ArrayList<DocumentReferenceContentComponent>();
            for (DocumentReferenceContentComponent documentReferenceContentComponent : this.content) {
                dst.content.add(documentReferenceContentComponent.copy());
            }
        }
    }

    protected DocumentReference typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DocumentReference)) {
            return false;
        }
        DocumentReference o = (DocumentReference)other_;
        return DocumentReference.compareDeep(this.identifier, o.identifier, true) && DocumentReference.compareDeep(this.version, o.version, true) && DocumentReference.compareDeep(this.basedOn, o.basedOn, true) && DocumentReference.compareDeep(this.status, o.status, true) && DocumentReference.compareDeep(this.docStatus, o.docStatus, true) && DocumentReference.compareDeep(this.modality, o.modality, true) && DocumentReference.compareDeep(this.type, o.type, true) && DocumentReference.compareDeep(this.category, o.category, true) && DocumentReference.compareDeep(this.subject, o.subject, true) && DocumentReference.compareDeep(this.context, o.context, true) && DocumentReference.compareDeep(this.event, o.event, true) && DocumentReference.compareDeep(this.bodySite, o.bodySite, true) && DocumentReference.compareDeep(this.facilityType, o.facilityType, true) && DocumentReference.compareDeep(this.practiceSetting, o.practiceSetting, true) && DocumentReference.compareDeep(this.period, o.period, true) && DocumentReference.compareDeep(this.date, o.date, true) && DocumentReference.compareDeep(this.author, o.author, true) && DocumentReference.compareDeep(this.attester, o.attester, true) && DocumentReference.compareDeep(this.custodian, o.custodian, true) && DocumentReference.compareDeep(this.relatesTo, o.relatesTo, true) && DocumentReference.compareDeep(this.description, o.description, true) && DocumentReference.compareDeep(this.securityLabel, o.securityLabel, true) && DocumentReference.compareDeep(this.content, o.content, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DocumentReference)) {
            return false;
        }
        DocumentReference o = (DocumentReference)other_;
        return DocumentReference.compareValues(this.version, o.version, true) && DocumentReference.compareValues(this.status, o.status, true) && DocumentReference.compareValues(this.docStatus, o.docStatus, true) && DocumentReference.compareValues(this.date, o.date, true) && DocumentReference.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.version, this.basedOn, this.status, this.docStatus, this.modality, this.type, this.category, this.subject, this.context, this.event, this.bodySite, this.facilityType, this.practiceSetting, this.period, this.date, this.author, this.attester, this.custodian, this.relatesTo, this.description, this.securityLabel, this.content});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DocumentReference;
    }

    public static enum DocumentReferenceStatus {
        CURRENT,
        SUPERSEDED,
        ENTEREDINERROR,
        NULL;


        public static DocumentReferenceStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("current".equals(codeString)) {
                return CURRENT;
            }
            if ("superseded".equals(codeString)) {
                return SUPERSEDED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DocumentReferenceStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CURRENT: {
                    return "current";
                }
                case SUPERSEDED: {
                    return "superseded";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CURRENT: {
                    return "http://hl7.org/fhir/document-reference-status";
                }
                case SUPERSEDED: {
                    return "http://hl7.org/fhir/document-reference-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/document-reference-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CURRENT: {
                    return "This is the current reference for this document.";
                }
                case SUPERSEDED: {
                    return "This reference has been superseded by another reference.";
                }
                case ENTEREDINERROR: {
                    return "This reference was created in error.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CURRENT: {
                    return "Current";
                }
                case SUPERSEDED: {
                    return "Superseded";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class DocumentReferenceContentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="attachment", type={Attachment.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Where to access the document", formalDefinition="The document or URL of the document along with critical metadata to prove content has integrity.")
        protected Attachment attachment;
        @Child(name="profile", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Content profile rules for the document", formalDefinition="An identifier of the document constraints, encoding, structure, and template that the document conforms to beyond the base format indicated in the mimeType.")
        protected List<DocumentReferenceContentProfileComponent> profile;
        private static final long serialVersionUID = 174089424L;

        public DocumentReferenceContentComponent() {
        }

        public DocumentReferenceContentComponent(Attachment attachment) {
            this.setAttachment(attachment);
        }

        public Attachment getAttachment() {
            if (this.attachment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContentComponent.attachment");
                }
                if (Configuration.doAutoCreate()) {
                    this.attachment = new Attachment();
                }
            }
            return this.attachment;
        }

        public boolean hasAttachment() {
            return this.attachment != null && !this.attachment.isEmpty();
        }

        public DocumentReferenceContentComponent setAttachment(Attachment value) {
            this.attachment = value;
            return this;
        }

        public List<DocumentReferenceContentProfileComponent> getProfile() {
            if (this.profile == null) {
                this.profile = new ArrayList<DocumentReferenceContentProfileComponent>();
            }
            return this.profile;
        }

        public DocumentReferenceContentComponent setProfile(List<DocumentReferenceContentProfileComponent> theProfile) {
            this.profile = theProfile;
            return this;
        }

        public boolean hasProfile() {
            if (this.profile == null) {
                return false;
            }
            for (DocumentReferenceContentProfileComponent item : this.profile) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DocumentReferenceContentProfileComponent addProfile() {
            DocumentReferenceContentProfileComponent t = new DocumentReferenceContentProfileComponent();
            if (this.profile == null) {
                this.profile = new ArrayList<DocumentReferenceContentProfileComponent>();
            }
            this.profile.add(t);
            return t;
        }

        public DocumentReferenceContentComponent addProfile(DocumentReferenceContentProfileComponent t) {
            if (t == null) {
                return this;
            }
            if (this.profile == null) {
                this.profile = new ArrayList<DocumentReferenceContentProfileComponent>();
            }
            this.profile.add(t);
            return this;
        }

        public DocumentReferenceContentProfileComponent getProfileFirstRep() {
            if (this.getProfile().isEmpty()) {
                this.addProfile();
            }
            return this.getProfile().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("attachment", "Attachment", "The document or URL of the document along with critical metadata to prove content has integrity.", 0, 1, this.attachment));
            children.add(new Property("profile", "", "An identifier of the document constraints, encoding, structure, and template that the document conforms to beyond the base format indicated in the mimeType.", 0, Integer.MAX_VALUE, this.profile));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1963501277: {
                    return new Property("attachment", "Attachment", "The document or URL of the document along with critical metadata to prove content has integrity.", 0, 1, this.attachment);
                }
                case -309425751: {
                    return new Property("profile", "", "An identifier of the document constraints, encoding, structure, and template that the document conforms to beyond the base format indicated in the mimeType.", 0, Integer.MAX_VALUE, this.profile);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1963501277: {
                    Base[] baseArray;
                    if (this.attachment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.attachment;
                    }
                    return baseArray;
                }
                case -309425751: {
                    return this.profile == null ? new Base[]{} : this.profile.toArray(new Base[this.profile.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1963501277: {
                    this.attachment = TypeConvertor.castToAttachment(value);
                    return value;
                }
                case -309425751: {
                    this.getProfile().add((DocumentReferenceContentProfileComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("attachment")) {
                this.attachment = TypeConvertor.castToAttachment(value);
            } else if (name.equals("profile")) {
                this.getProfile().add((DocumentReferenceContentProfileComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("attachment")) {
                this.attachment = null;
            } else if (name.equals("profile")) {
                this.getProfile().remove((DocumentReferenceContentProfileComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1963501277: {
                    return this.getAttachment();
                }
                case -309425751: {
                    return this.addProfile();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1963501277: {
                    return new String[]{"Attachment"};
                }
                case -309425751: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("attachment")) {
                this.attachment = new Attachment();
                return this.attachment;
            }
            if (name.equals("profile")) {
                return this.addProfile();
            }
            return super.addChild(name);
        }

        @Override
        public DocumentReferenceContentComponent copy() {
            DocumentReferenceContentComponent dst = new DocumentReferenceContentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DocumentReferenceContentComponent dst) {
            super.copyValues(dst);
            Attachment attachment = dst.attachment = this.attachment == null ? null : this.attachment.copy();
            if (this.profile != null) {
                dst.profile = new ArrayList<DocumentReferenceContentProfileComponent>();
                for (DocumentReferenceContentProfileComponent i : this.profile) {
                    dst.profile.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceContentComponent)) {
                return false;
            }
            DocumentReferenceContentComponent o = (DocumentReferenceContentComponent)other_;
            return DocumentReferenceContentComponent.compareDeep(this.attachment, o.attachment, true) && DocumentReferenceContentComponent.compareDeep(this.profile, o.profile, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceContentComponent)) {
                return false;
            }
            DocumentReferenceContentComponent o = (DocumentReferenceContentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.attachment, this.profile});
        }

        @Override
        public String fhirType() {
            return "DocumentReference.content";
        }
    }

    public static class DocumentReferenceStatusEnumFactory
    implements EnumFactory<DocumentReferenceStatus> {
        @Override
        public DocumentReferenceStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("current".equals(codeString)) {
                return DocumentReferenceStatus.CURRENT;
            }
            if ("superseded".equals(codeString)) {
                return DocumentReferenceStatus.SUPERSEDED;
            }
            if ("entered-in-error".equals(codeString)) {
                return DocumentReferenceStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown DocumentReferenceStatus code '" + codeString + "'");
        }

        public Enumeration<DocumentReferenceStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DocumentReferenceStatus>(this, DocumentReferenceStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<DocumentReferenceStatus>(this, DocumentReferenceStatus.NULL, code);
            }
            if ("current".equals(codeString)) {
                return new Enumeration<DocumentReferenceStatus>(this, DocumentReferenceStatus.CURRENT, code);
            }
            if ("superseded".equals(codeString)) {
                return new Enumeration<DocumentReferenceStatus>(this, DocumentReferenceStatus.SUPERSEDED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DocumentReferenceStatus>(this, DocumentReferenceStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown DocumentReferenceStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DocumentReferenceStatus code) {
            if (code == DocumentReferenceStatus.NULL) {
                return null;
            }
            if (code == DocumentReferenceStatus.CURRENT) {
                return "current";
            }
            if (code == DocumentReferenceStatus.SUPERSEDED) {
                return "superseded";
            }
            if (code == DocumentReferenceStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(DocumentReferenceStatus code) {
            return code.getSystem();
        }
    }

    @Block
    public static class DocumentReferenceAttesterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="personal | professional | legal | official", formalDefinition="The type of attestation the authenticator offers.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/composition-attestation-mode")
        protected CodeableConcept mode;
        @Child(name="time", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the document was attested", formalDefinition="When the document was attested by the party.")
        protected DateTimeType time;
        @Child(name="party", type={Patient.class, RelatedPerson.class, Practitioner.class, PractitionerRole.class, Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who attested the document", formalDefinition="Who attested the document in the specified way.")
        protected Reference party;
        private static final long serialVersionUID = 545132751L;

        public DocumentReferenceAttesterComponent() {
        }

        public DocumentReferenceAttesterComponent(CodeableConcept mode) {
            this.setMode(mode);
        }

        public CodeableConcept getMode() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceAttesterComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new CodeableConcept();
                }
            }
            return this.mode;
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public DocumentReferenceAttesterComponent setMode(CodeableConcept value) {
            this.mode = value;
            return this;
        }

        public DateTimeType getTimeElement() {
            if (this.time == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceAttesterComponent.time");
                }
                if (Configuration.doAutoCreate()) {
                    this.time = new DateTimeType();
                }
            }
            return this.time;
        }

        public boolean hasTimeElement() {
            return this.time != null && !this.time.isEmpty();
        }

        public boolean hasTime() {
            return this.time != null && !this.time.isEmpty();
        }

        public DocumentReferenceAttesterComponent setTimeElement(DateTimeType value) {
            this.time = value;
            return this;
        }

        public Date getTime() {
            return this.time == null ? null : (Date)this.time.getValue();
        }

        public DocumentReferenceAttesterComponent setTime(Date value) {
            if (value == null) {
                this.time = null;
            } else {
                if (this.time == null) {
                    this.time = new DateTimeType();
                }
                this.time.setValue(value);
            }
            return this;
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceAttesterComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public DocumentReferenceAttesterComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("mode", "CodeableConcept", "The type of attestation the authenticator offers.", 0, 1, this.mode));
            children.add(new Property("time", "dateTime", "When the document was attested by the party.", 0, 1, this.time));
            children.add(new Property("party", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Who attested the document in the specified way.", 0, 1, this.party));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property("mode", "CodeableConcept", "The type of attestation the authenticator offers.", 0, 1, this.mode);
                }
                case 3560141: {
                    return new Property("time", "dateTime", "When the document was attested by the party.", 0, 1, this.time);
                }
                case 106437350: {
                    return new Property("party", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Who attested the document in the specified way.", 0, 1, this.party);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case 3560141: {
                    Base[] baseArray;
                    if (this.time == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.time;
                    }
                    return baseArray;
                }
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.party;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    this.mode = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3560141: {
                    this.time = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 106437350: {
                    this.party = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                this.mode = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("time")) {
                this.time = TypeConvertor.castToDateTime(value);
            } else if (name.equals("party")) {
                this.party = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                this.mode = null;
            } else if (name.equals("time")) {
                this.time = null;
            } else if (name.equals("party")) {
                this.party = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.getMode();
                }
                case 3560141: {
                    return this.getTimeElement();
                }
                case 106437350: {
                    return this.getParty();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"CodeableConcept"};
                }
                case 3560141: {
                    return new String[]{"dateTime"};
                }
                case 106437350: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("mode")) {
                this.mode = new CodeableConcept();
                return this.mode;
            }
            if (name.equals("time")) {
                throw new FHIRException("Cannot call addChild on a singleton property DocumentReference.attester.time");
            }
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            return super.addChild(name);
        }

        @Override
        public DocumentReferenceAttesterComponent copy() {
            DocumentReferenceAttesterComponent dst = new DocumentReferenceAttesterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DocumentReferenceAttesterComponent dst) {
            super.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.time = this.time == null ? null : this.time.copy();
            dst.party = this.party == null ? null : this.party.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceAttesterComponent)) {
                return false;
            }
            DocumentReferenceAttesterComponent o = (DocumentReferenceAttesterComponent)other_;
            return DocumentReferenceAttesterComponent.compareDeep(this.mode, o.mode, true) && DocumentReferenceAttesterComponent.compareDeep(this.time, o.time, true) && DocumentReferenceAttesterComponent.compareDeep(this.party, o.party, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceAttesterComponent)) {
                return false;
            }
            DocumentReferenceAttesterComponent o = (DocumentReferenceAttesterComponent)other_;
            return DocumentReferenceAttesterComponent.compareValues(this.time, o.time, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mode, this.time, this.party});
        }

        @Override
        public String fhirType() {
            return "DocumentReference.attester";
        }
    }

    @Block
    public static class DocumentReferenceRelatesToComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The relationship type with another document", formalDefinition="The type of relationship that this document has with anther document.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/document-relationship-type")
        protected CodeableConcept code;
        @Child(name="target", type={DocumentReference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Target of the relationship", formalDefinition="The target document of this relationship.")
        protected Reference target;
        private static final long serialVersionUID = -372012026L;

        public DocumentReferenceRelatesToComponent() {
        }

        public DocumentReferenceRelatesToComponent(CodeableConcept code, Reference target) {
            this.setCode(code);
            this.setTarget(target);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceRelatesToComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public DocumentReferenceRelatesToComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Reference getTarget() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceRelatesToComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new Reference();
                }
            }
            return this.target;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public DocumentReferenceRelatesToComponent setTarget(Reference value) {
            this.target = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "The type of relationship that this document has with anther document.", 0, 1, this.code));
            children.add(new Property("target", "Reference(DocumentReference)", "The target document of this relationship.", 0, 1, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The type of relationship that this document has with anther document.", 0, 1, this.code);
                }
                case -880905839: {
                    return new Property("target", "Reference(DocumentReference)", "The target document of this relationship.", 0, 1, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -880905839: {
                    this.target = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("target")) {
                this.target = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("target")) {
                this.target = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -880905839: {
                    return this.getTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -880905839: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("target")) {
                this.target = new Reference();
                return this.target;
            }
            return super.addChild(name);
        }

        @Override
        public DocumentReferenceRelatesToComponent copy() {
            DocumentReferenceRelatesToComponent dst = new DocumentReferenceRelatesToComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DocumentReferenceRelatesToComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.target = this.target == null ? null : this.target.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceRelatesToComponent)) {
                return false;
            }
            DocumentReferenceRelatesToComponent o = (DocumentReferenceRelatesToComponent)other_;
            return DocumentReferenceRelatesToComponent.compareDeep(this.code, o.code, true) && DocumentReferenceRelatesToComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceRelatesToComponent)) {
                return false;
            }
            DocumentReferenceRelatesToComponent o = (DocumentReferenceRelatesToComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.target});
        }

        @Override
        public String fhirType() {
            return "DocumentReference.relatesTo";
        }
    }

    @Block
    public static class DocumentReferenceContentProfileComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={Coding.class, UriType.class, CanonicalType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code|uri|canonical", formalDefinition="Code|uri|canonical.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-HL7FormatCodes")
        protected DataType value;
        private static final long serialVersionUID = -1135414639L;

        public DocumentReferenceContentProfileComponent() {
        }

        public DocumentReferenceContentProfileComponent(DataType value) {
            this.setValue(value);
        }

        public DataType getValue() {
            return this.value;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this.value instanceof Coding;
        }

        public UriType getValueUriType() throws FHIRException {
            if (this.value == null) {
                this.value = new UriType();
            }
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this.value instanceof UriType;
        }

        public CanonicalType getValueCanonicalType() throws FHIRException {
            if (this.value == null) {
                this.value = new CanonicalType();
            }
            if (!(this.value instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.value;
        }

        public boolean hasValueCanonicalType() {
            return this.value instanceof CanonicalType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public DocumentReferenceContentProfileComponent setValue(DataType value) {
            if (!(value == null || value instanceof Coding || value instanceof UriType || value instanceof CanonicalType)) {
                throw new FHIRException("Not the right type for DocumentReference.content.profile.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("value[x]", "Coding|uri|canonical", "Code|uri|canonical.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1410166417: {
                    return new Property("value[x]", "Coding|uri|canonical", "Code|uri|canonical.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "Coding|uri|canonical", "Code|uri|canonical.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "Code|uri|canonical.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "uri", "Code|uri|canonical.", 0, 1, this.value);
                }
                case -786218365: {
                    return new Property("value[x]", "canonical", "Code|uri|canonical.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("value[x]")) {
                return super.setProperty(name, value);
            }
            this.value = TypeConvertor.castToType(value);
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("value[x]")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return new String[]{"Coding", "uri", "canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueCanonical")) {
                this.value = new CanonicalType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public DocumentReferenceContentProfileComponent copy() {
            DocumentReferenceContentProfileComponent dst = new DocumentReferenceContentProfileComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DocumentReferenceContentProfileComponent dst) {
            super.copyValues(dst);
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceContentProfileComponent)) {
                return false;
            }
            DocumentReferenceContentProfileComponent o = (DocumentReferenceContentProfileComponent)other_;
            return DocumentReferenceContentProfileComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceContentProfileComponent)) {
                return false;
            }
            DocumentReferenceContentProfileComponent o = (DocumentReferenceContentProfileComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value});
        }

        @Override
        public String fhirType() {
            return "DocumentReference.content.profile";
        }
    }
}

