/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ExampleScenario", profile="http://hl7.org/fhir/StructureDefinition/ExampleScenario")
public class ExampleScenario
extends CanonicalResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this example scenario, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this example scenario when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this example scenario is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the example scenario is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the example scenario", formalDefinition="A formal identifier that is used to identify this example scenario when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the example scenario", formalDefinition="The identifier that is used to identify this version of the example scenario when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the example scenario author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="versionAlgorithm", type={StringType.class, Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How to compare versions", formalDefinition="Indicates the mechanism used to compare versions to determine which is more current.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/version-algorithm")
    protected DataType versionAlgorithm;
    @Child(name="name", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="To be removed?", formalDefinition="Temporarily retained for tooling purposes.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this example scenario (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the ExampleScenario.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this example scenario. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this example scenario is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the example scenario was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the example scenario changes. (e.g. the 'content logical definition').")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher/steward (organization or individual)", formalDefinition="The name of the organization or individual responsible for the release and ongoing maintenance of the example scenario.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Natural language description of the ExampleScenario", formalDefinition="A free text natural language description of the ExampleScenario from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate example scenario instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for example scenario (if applicable)", formalDefinition="A legal or geographic region in which the example scenario is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The purpose of the example, e.g. to illustrate a scenario", formalDefinition="What the example scenario resource is created for. This should not be used to show the business purpose of the scenario itself, but the purpose of documenting a scenario.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the example scenario and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the example scenario.")
    protected MarkdownType copyright;
    @Child(name="copyrightLabel", type={StringType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Copyright holder and year(s)", formalDefinition="A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').")
    protected StringType copyrightLabel;
    @Child(name="actor", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Individual involved in exchange", formalDefinition="A system or person who shares or receives an instance within the scenario.")
    protected List<ExampleScenarioActorComponent> actor;
    @Child(name="instance", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Data used in the scenario", formalDefinition="A single data collection that is shared as part of the scenario.")
    protected List<ExampleScenarioInstanceComponent> instance;
    @Child(name="process", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Major process within scenario", formalDefinition="A group of operations that represents a significant step within a scenario.")
    protected List<ExampleScenarioProcessComponent> process;
    private static final long serialVersionUID = 292494233L;
    @SearchParamDefinition(name="context-quantity", path="(ActivityDefinition.useContext.value.ofType(Quantity)) | (ActivityDefinition.useContext.value.ofType(Range)) | (ActorDefinition.useContext.value.ofType(Quantity)) | (ActorDefinition.useContext.value.ofType(Range)) | (CapabilityStatement.useContext.value.ofType(Quantity)) | (CapabilityStatement.useContext.value.ofType(Range)) | (ChargeItemDefinition.useContext.value.ofType(Quantity)) | (ChargeItemDefinition.useContext.value.ofType(Range)) | (Citation.useContext.value.ofType(Quantity)) | (Citation.useContext.value.ofType(Range)) | (CodeSystem.useContext.value.ofType(Quantity)) | (CodeSystem.useContext.value.ofType(Range)) | (CompartmentDefinition.useContext.value.ofType(Quantity)) | (CompartmentDefinition.useContext.value.ofType(Range)) | (ConceptMap.useContext.value.ofType(Quantity)) | (ConceptMap.useContext.value.ofType(Range)) | (ConditionDefinition.useContext.value.ofType(Quantity)) | (ConditionDefinition.useContext.value.ofType(Range)) | (EventDefinition.useContext.value.ofType(Quantity)) | (EventDefinition.useContext.value.ofType(Range)) | (Evidence.useContext.value.ofType(Quantity)) | (Evidence.useContext.value.ofType(Range)) | (EvidenceReport.useContext.value.ofType(Quantity)) | (EvidenceReport.useContext.value.ofType(Range)) | (EvidenceVariable.useContext.value.ofType(Quantity)) | (EvidenceVariable.useContext.value.ofType(Range)) | (ExampleScenario.useContext.value.ofType(Quantity)) | (ExampleScenario.useContext.value.ofType(Range)) | (GraphDefinition.useContext.value.ofType(Quantity)) | (GraphDefinition.useContext.value.ofType(Range)) | (ImplementationGuide.useContext.value.ofType(Quantity)) | (ImplementationGuide.useContext.value.ofType(Range)) | (Library.useContext.value.ofType(Quantity)) | (Library.useContext.value.ofType(Range)) | (Measure.useContext.value.ofType(Quantity)) | (Measure.useContext.value.ofType(Range)) | (MessageDefinition.useContext.value.ofType(Quantity)) | (MessageDefinition.useContext.value.ofType(Range)) | (NamingSystem.useContext.value.ofType(Quantity)) | (NamingSystem.useContext.value.ofType(Range)) | (OperationDefinition.useContext.value.ofType(Quantity)) | (OperationDefinition.useContext.value.ofType(Range)) | (PlanDefinition.useContext.value.ofType(Quantity)) | (PlanDefinition.useContext.value.ofType(Range)) | (Questionnaire.useContext.value.ofType(Quantity)) | (Questionnaire.useContext.value.ofType(Range)) | (Requirements.useContext.value.ofType(Quantity)) | (Requirements.useContext.value.ofType(Range)) | (SearchParameter.useContext.value.ofType(Quantity)) | (SearchParameter.useContext.value.ofType(Range)) | (StructureDefinition.useContext.value.ofType(Quantity)) | (StructureDefinition.useContext.value.ofType(Range)) | (StructureMap.useContext.value.ofType(Quantity)) | (StructureMap.useContext.value.ofType(Range)) | (TerminologyCapabilities.useContext.value.ofType(Quantity)) | (TerminologyCapabilities.useContext.value.ofType(Range)) | (TestScript.useContext.value.ofType(Quantity)) | (TestScript.useContext.value.ofType(Range)) | (ValueSet.useContext.value.ofType(Quantity)) | (ValueSet.useContext.value.ofType(Range))", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A quantity- or range-valued use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A quantity- or range-valued use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A quantity- or range-valued use context assigned to the charge item definition\r\n* [Citation](citation.html): A quantity- or range-valued use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A quantity- or range-valued use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A quantity- or range-valued use context assigned to the event definition\r\n* [Evidence](evidence.html): A quantity- or range-valued use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A quantity- or range-valued use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A quantity- or range-valued use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A quantity- or range-valued use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [Library](library.html): A quantity- or range-valued use context assigned to the library\r\n* [Measure](measure.html): A quantity- or range-valued use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A quantity- or range-valued use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A quantity- or range-valued use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A quantity- or range-valued use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A quantity- or range-valued use context assigned to the test script\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and quantity- or range-based value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and quantity- or range-based value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and quantity- or range-based value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and quantity- or range-based value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and quantity- or range-based value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and quantity- or range-based value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and quantity- or range-based value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and quantity- or range-based value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and quantity- or range-based value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and quantity- or range-based value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [Library](library.html): A use context type and quantity- or range-based value assigned to the library\r\n* [Measure](measure.html): A use context type and quantity- or range-based value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and quantity- or range-based value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and quantity- or range-based value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and quantity- or range-based value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and quantity- or range-based value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [Library](library.html): A use context type and value assigned to the library\r\n* [Measure](measure.html): A use context type and value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="ActivityDefinition.useContext.code | ActorDefinition.useContext.code | CapabilityStatement.useContext.code | ChargeItemDefinition.useContext.code | Citation.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | ConditionDefinition.useContext.code | EventDefinition.useContext.code | Evidence.useContext.code | EvidenceReport.useContext.code | EvidenceVariable.useContext.code | ExampleScenario.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | Library.useContext.code | Measure.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | PlanDefinition.useContext.code | Questionnaire.useContext.code | Requirements.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | TestScript.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A type of use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A type of use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A type of use context assigned to the charge item definition\r\n* [Citation](citation.html): A type of use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A type of use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A type of use context assigned to the event definition\r\n* [Evidence](evidence.html): A type of use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A type of use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A type of use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A type of use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [Library](library.html): A type of use context assigned to the library\r\n* [Measure](measure.html): A type of use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A type of use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A type of use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A type of use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A type of use context assigned to the test script\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(ActivityDefinition.useContext.value.ofType(CodeableConcept)) | (ActorDefinition.useContext.value.ofType(CodeableConcept)) | (CapabilityStatement.useContext.value.ofType(CodeableConcept)) | (ChargeItemDefinition.useContext.value.ofType(CodeableConcept)) | (Citation.useContext.value.ofType(CodeableConcept)) | (CodeSystem.useContext.value.ofType(CodeableConcept)) | (CompartmentDefinition.useContext.value.ofType(CodeableConcept)) | (ConceptMap.useContext.value.ofType(CodeableConcept)) | (ConditionDefinition.useContext.value.ofType(CodeableConcept)) | (EventDefinition.useContext.value.ofType(CodeableConcept)) | (Evidence.useContext.value.ofType(CodeableConcept)) | (EvidenceReport.useContext.value.ofType(CodeableConcept)) | (EvidenceVariable.useContext.value.ofType(CodeableConcept)) | (ExampleScenario.useContext.value.ofType(CodeableConcept)) | (GraphDefinition.useContext.value.ofType(CodeableConcept)) | (ImplementationGuide.useContext.value.ofType(CodeableConcept)) | (Library.useContext.value.ofType(CodeableConcept)) | (Measure.useContext.value.ofType(CodeableConcept)) | (MessageDefinition.useContext.value.ofType(CodeableConcept)) | (NamingSystem.useContext.value.ofType(CodeableConcept)) | (OperationDefinition.useContext.value.ofType(CodeableConcept)) | (PlanDefinition.useContext.value.ofType(CodeableConcept)) | (Questionnaire.useContext.value.ofType(CodeableConcept)) | (Requirements.useContext.value.ofType(CodeableConcept)) | (SearchParameter.useContext.value.ofType(CodeableConcept)) | (StructureDefinition.useContext.value.ofType(CodeableConcept)) | (StructureMap.useContext.value.ofType(CodeableConcept)) | (TerminologyCapabilities.useContext.value.ofType(CodeableConcept)) | (TestScript.useContext.value.ofType(CodeableConcept)) | (ValueSet.useContext.value.ofType(CodeableConcept))", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context assigned to the charge item definition\r\n* [Citation](citation.html): A use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context assigned to the event definition\r\n* [Evidence](evidence.html): A use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [Library](library.html): A use context assigned to the library\r\n* [Measure](measure.html): A use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context assigned to the test script\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="ActivityDefinition.date | ActorDefinition.date | CapabilityStatement.date | ChargeItemDefinition.date | Citation.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | ConditionDefinition.date | EventDefinition.date | Evidence.date | EvidenceVariable.date | ExampleScenario.date | GraphDefinition.date | ImplementationGuide.date | Library.date | Measure.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | PlanDefinition.date | Questionnaire.date | Requirements.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | SubscriptionTopic.date | TerminologyCapabilities.date | TestScript.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The activity definition publication date\r\n* [ActorDefinition](actordefinition.html): The Actor Definition publication date\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The charge item definition publication date\r\n* [Citation](citation.html): The citation publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [ConditionDefinition](conditiondefinition.html): The condition definition publication date\r\n* [EventDefinition](eventdefinition.html): The event definition publication date\r\n* [Evidence](evidence.html): The evidence publication date\r\n* [EvidenceVariable](evidencevariable.html): The evidence variable publication date\r\n* [ExampleScenario](examplescenario.html): The example scenario publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [Library](library.html): The library publication date\r\n* [Measure](measure.html): The measure publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [PlanDefinition](plandefinition.html): The plan definition publication date\r\n* [Questionnaire](questionnaire.html): The questionnaire publication date\r\n* [Requirements](requirements.html): The requirements publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [SubscriptionTopic](subscriptiontopic.html): Date status first applied\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [TestScript](testscript.html): The test script publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ActivityDefinition.identifier | ActorDefinition.identifier | CapabilityStatement.identifier | ChargeItemDefinition.identifier | Citation.identifier | CodeSystem.identifier | ConceptMap.identifier | ConditionDefinition.identifier | EventDefinition.identifier | Evidence.identifier | EvidenceReport.identifier | EvidenceVariable.identifier | ExampleScenario.identifier | GraphDefinition.identifier | ImplementationGuide.identifier | Library.identifier | Measure.identifier | MedicationKnowledge.identifier | MessageDefinition.identifier | NamingSystem.identifier | ObservationDefinition.identifier | OperationDefinition.identifier | PlanDefinition.identifier | Questionnaire.identifier | Requirements.identifier | SearchParameter.identifier | SpecimenDefinition.identifier | StructureDefinition.identifier | StructureMap.identifier | SubscriptionTopic.identifier | TerminologyCapabilities.identifier | TestPlan.identifier | TestScript.identifier | ValueSet.identifier", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): External identifier for the activity definition\r\n* [ActorDefinition](actordefinition.html): External identifier for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): External identifier for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): External identifier for the charge item definition\r\n* [Citation](citation.html): External identifier for the citation\r\n* [CodeSystem](codesystem.html): External identifier for the code system\r\n* [ConceptMap](conceptmap.html): External identifier for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): External identifier for the condition definition\r\n* [EventDefinition](eventdefinition.html): External identifier for the event definition\r\n* [Evidence](evidence.html): External identifier for the evidence\r\n* [EvidenceReport](evidencereport.html): External identifier for the evidence report\r\n* [EvidenceVariable](evidencevariable.html): External identifier for the evidence variable\r\n* [ExampleScenario](examplescenario.html): External identifier for the example scenario\r\n* [GraphDefinition](graphdefinition.html): External identifier for the graph definition\r\n* [ImplementationGuide](implementationguide.html): External identifier for the implementation guide\r\n* [Library](library.html): External identifier for the library\r\n* [Measure](measure.html): External identifier for the measure\r\n* [MedicationKnowledge](medicationknowledge.html): Business identifier for this medication\r\n* [MessageDefinition](messagedefinition.html): External identifier for the message definition\r\n* [NamingSystem](namingsystem.html): External identifier for the naming system\r\n* [ObservationDefinition](observationdefinition.html): The unique identifier associated with the specimen definition\r\n* [OperationDefinition](operationdefinition.html): External identifier for the search parameter\r\n* [PlanDefinition](plandefinition.html): External identifier for the plan definition\r\n* [Questionnaire](questionnaire.html): External identifier for the questionnaire\r\n* [Requirements](requirements.html): External identifier for the requirements\r\n* [SearchParameter](searchparameter.html): External identifier for the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The unique identifier associated with the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): External identifier for the structure definition\r\n* [StructureMap](structuremap.html): External identifier for the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business Identifier for SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): External identifier for the terminology capabilities\r\n* [TestPlan](testplan.html): An identifier for the test plan\r\n* [TestScript](testscript.html): External identifier for the test script\r\n* [ValueSet](valueset.html): External identifier for the value set\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="ActivityDefinition.jurisdiction | ActorDefinition.jurisdiction | CapabilityStatement.jurisdiction | ChargeItemDefinition.jurisdiction | Citation.jurisdiction | CodeSystem.jurisdiction | ConceptMap.jurisdiction | ConditionDefinition.jurisdiction | EventDefinition.jurisdiction | ExampleScenario.jurisdiction | GraphDefinition.jurisdiction | ImplementationGuide.jurisdiction | Library.jurisdiction | Measure.jurisdiction | MessageDefinition.jurisdiction | NamingSystem.jurisdiction | OperationDefinition.jurisdiction | PlanDefinition.jurisdiction | Questionnaire.jurisdiction | Requirements.jurisdiction | SearchParameter.jurisdiction | StructureDefinition.jurisdiction | StructureMap.jurisdiction | TerminologyCapabilities.jurisdiction | TestScript.jurisdiction | ValueSet.jurisdiction", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Intended jurisdiction for the activity definition\r\n* [ActorDefinition](actordefinition.html): Intended jurisdiction for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): Intended jurisdiction for the charge item definition\r\n* [Citation](citation.html): Intended jurisdiction for the citation\r\n* [CodeSystem](codesystem.html): Intended jurisdiction for the code system\r\n* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Intended jurisdiction for the condition definition\r\n* [EventDefinition](eventdefinition.html): Intended jurisdiction for the event definition\r\n* [ExampleScenario](examplescenario.html): Intended jurisdiction for the example scenario\r\n* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition\r\n* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide\r\n* [Library](library.html): Intended jurisdiction for the library\r\n* [Measure](measure.html): Intended jurisdiction for the measure\r\n* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition\r\n* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system\r\n* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition\r\n* [PlanDefinition](plandefinition.html): Intended jurisdiction for the plan definition\r\n* [Questionnaire](questionnaire.html): Intended jurisdiction for the questionnaire\r\n* [Requirements](requirements.html): Intended jurisdiction for the requirements\r\n* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter\r\n* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition\r\n* [StructureMap](structuremap.html): Intended jurisdiction for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities\r\n* [TestScript](testscript.html): Intended jurisdiction for the test script\r\n* [ValueSet](valueset.html): Intended jurisdiction for the value set\r\n", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="ActivityDefinition.name | CapabilityStatement.name | Citation.name | CodeSystem.name | CompartmentDefinition.name | ConceptMap.name | ConditionDefinition.name | EventDefinition.name | EvidenceVariable.name | ExampleScenario.name | GraphDefinition.name | ImplementationGuide.name | Library.name | Measure.name | MessageDefinition.name | NamingSystem.name | OperationDefinition.name | PlanDefinition.name | Questionnaire.name | Requirements.name | SearchParameter.name | StructureDefinition.name | StructureMap.name | TerminologyCapabilities.name | TestScript.name | ValueSet.name", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Computationally friendly name of the activity definition\r\n* [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement\r\n* [Citation](citation.html): Computationally friendly name of the citation\r\n* [CodeSystem](codesystem.html): Computationally friendly name of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition\r\n* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Computationally friendly name of the condition definition\r\n* [EventDefinition](eventdefinition.html): Computationally friendly name of the event definition\r\n* [EvidenceVariable](evidencevariable.html): Computationally friendly name of the evidence variable\r\n* [ExampleScenario](examplescenario.html): Computationally friendly name of the example scenario\r\n* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide\r\n* [Library](library.html): Computationally friendly name of the library\r\n* [Measure](measure.html): Computationally friendly name of the measure\r\n* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition\r\n* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system\r\n* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition\r\n* [PlanDefinition](plandefinition.html): Computationally friendly name of the plan definition\r\n* [Questionnaire](questionnaire.html): Computationally friendly name of the questionnaire\r\n* [Requirements](requirements.html): Computationally friendly name of the requirements\r\n* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition\r\n* [StructureMap](structuremap.html): Computationally friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities\r\n* [TestScript](testscript.html): Computationally friendly name of the test script\r\n* [ValueSet](valueset.html): Computationally friendly name of the value set\r\n", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ActivityDefinition.publisher | ActorDefinition.publisher | CapabilityStatement.publisher | ChargeItemDefinition.publisher | Citation.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | ConditionDefinition.publisher | EventDefinition.publisher | Evidence.publisher | EvidenceReport.publisher | EvidenceVariable.publisher | ExampleScenario.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | Library.publisher | Measure.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | PlanDefinition.publisher | Questionnaire.publisher | Requirements.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | TestScript.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Name of the publisher of the activity definition\r\n* [ActorDefinition](actordefinition.html): Name of the publisher of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): Name of the publisher of the charge item definition\r\n* [Citation](citation.html): Name of the publisher of the citation\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Name of the publisher of the condition definition\r\n* [EventDefinition](eventdefinition.html): Name of the publisher of the event definition\r\n* [Evidence](evidence.html): Name of the publisher of the evidence\r\n* [EvidenceReport](evidencereport.html): Name of the publisher of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): Name of the publisher of the evidence variable\r\n* [ExampleScenario](examplescenario.html): Name of the publisher of the example scenario\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [Library](library.html): Name of the publisher of the library\r\n* [Measure](measure.html): Name of the publisher of the measure\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [PlanDefinition](plandefinition.html): Name of the publisher of the plan definition\r\n* [Questionnaire](questionnaire.html): Name of the publisher of the questionnaire\r\n* [Requirements](requirements.html): Name of the publisher of the requirements\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [TestScript](testscript.html): Name of the publisher of the test script\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="ActivityDefinition.status | ActorDefinition.status | CapabilityStatement.status | ChargeItemDefinition.status | Citation.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | ConditionDefinition.status | EventDefinition.status | Evidence.status | EvidenceReport.status | EvidenceVariable.status | ExampleScenario.status | GraphDefinition.status | ImplementationGuide.status | Library.status | Measure.status | MedicationKnowledge.status | MessageDefinition.status | NamingSystem.status | ObservationDefinition.status | OperationDefinition.status | PlanDefinition.status | Questionnaire.status | Requirements.status | SearchParameter.status | SpecimenDefinition.status | StructureDefinition.status | StructureMap.status | SubscriptionTopic.status | TerminologyCapabilities.status | TestPlan.status | TestScript.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The current status of the activity definition\r\n* [ActorDefinition](actordefinition.html): The current status of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The current status of the charge item definition\r\n* [Citation](citation.html): The current status of the citation\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The current status of the condition definition\r\n* [EventDefinition](eventdefinition.html): The current status of the event definition\r\n* [Evidence](evidence.html): The current status of the evidence\r\n* [EvidenceReport](evidencereport.html): The current status of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The current status of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The current status of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [Library](library.html): The current status of the library\r\n* [Measure](measure.html): The current status of the measure\r\n* [MedicationKnowledge](medicationknowledge.html): active | inactive | entered-in-error\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [ObservationDefinition](observationdefinition.html): Publication status of the ObservationDefinition: draft, active, retired, unknown\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [PlanDefinition](plandefinition.html): The current status of the plan definition\r\n* [Questionnaire](questionnaire.html): The current status of the questionnaire\r\n* [Requirements](requirements.html): The current status of the requirements\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): Publication status of the SpecimenDefinition: draft, active, retired, unknown\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): draft | active | retired | unknown\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [TestPlan](testplan.html): The current status of the test plan\r\n* [TestScript](testscript.html): The current status of the test script\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="url", path="ActivityDefinition.url | ActorDefinition.url | CapabilityStatement.url | ChargeItemDefinition.url | Citation.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | ConditionDefinition.url | EventDefinition.url | Evidence.url | EvidenceReport.url | EvidenceVariable.url | ExampleScenario.url | GraphDefinition.url | ImplementationGuide.url | Library.url | Measure.url | MessageDefinition.url | NamingSystem.url | ObservationDefinition.url | OperationDefinition.url | PlanDefinition.url | Questionnaire.url | Requirements.url | SearchParameter.url | SpecimenDefinition.url | StructureDefinition.url | StructureMap.url | SubscriptionTopic.url | TerminologyCapabilities.url | TestPlan.url | TestScript.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The uri that identifies the activity definition\r\n* [ActorDefinition](actordefinition.html): The uri that identifies the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The uri that identifies the charge item definition\r\n* [Citation](citation.html): The uri that identifies the citation\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The URI that identifies the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The uri that identifies the condition definition\r\n* [EventDefinition](eventdefinition.html): The uri that identifies the event definition\r\n* [Evidence](evidence.html): The uri that identifies the evidence\r\n* [EvidenceReport](evidencereport.html): The uri that identifies the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The uri that identifies the evidence variable\r\n* [ExampleScenario](examplescenario.html): The uri that identifies the example scenario\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [Library](library.html): The uri that identifies the library\r\n* [Measure](measure.html): The uri that identifies the measure\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [NamingSystem](namingsystem.html): The uri that identifies the naming system\r\n* [ObservationDefinition](observationdefinition.html): The uri that identifies the observation definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [PlanDefinition](plandefinition.html): The uri that identifies the plan definition\r\n* [Questionnaire](questionnaire.html): The uri that identifies the questionnaire\r\n* [Requirements](requirements.html): The uri that identifies the requirements\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The uri that identifies the specimen definition\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Logical canonical URL to reference this SubscriptionTopic (globally unique)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [TestPlan](testplan.html): The uri that identifies the test plan\r\n* [TestScript](testscript.html): The uri that identifies the test script\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="ActivityDefinition.version | ActorDefinition.version | CapabilityStatement.version | ChargeItemDefinition.version | Citation.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | ConditionDefinition.version | EventDefinition.version | Evidence.version | EvidenceVariable.version | ExampleScenario.version | GraphDefinition.version | ImplementationGuide.version | Library.version | Measure.version | MessageDefinition.version | NamingSystem.version | OperationDefinition.version | PlanDefinition.version | Questionnaire.version | Requirements.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | SubscriptionTopic.version | TerminologyCapabilities.version | TestScript.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The business version of the activity definition\r\n* [ActorDefinition](actordefinition.html): The business version of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The business version of the charge item definition\r\n* [Citation](citation.html): The business version of the citation\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The business version of the condition definition\r\n* [EventDefinition](eventdefinition.html): The business version of the event definition\r\n* [Evidence](evidence.html): The business version of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The business version of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The business version of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [Library](library.html): The business version of the library\r\n* [Measure](measure.html): The business version of the measure\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [NamingSystem](namingsystem.html): The business version of the naming system\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [PlanDefinition](plandefinition.html): The business version of the plan definition\r\n* [Questionnaire](questionnaire.html): The business version of the questionnaire\r\n* [Requirements](requirements.html): The business version of the requirements\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business version of the SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [TestScript](testscript.html): The business version of the test script\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public ExampleScenario() {
    }

    public ExampleScenario(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ExampleScenario setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ExampleScenario setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public ExampleScenario setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public ExampleScenario addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ExampleScenario setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ExampleScenario setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public DataType getVersionAlgorithm() {
        return this.versionAlgorithm;
    }

    @Override
    public StringType getVersionAlgorithmStringType() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new StringType();
        }
        if (!(this.versionAlgorithm instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (StringType)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmStringType() {
        return this.versionAlgorithm instanceof StringType;
    }

    @Override
    public Coding getVersionAlgorithmCoding() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new Coding();
        }
        if (!(this.versionAlgorithm instanceof Coding)) {
            throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (Coding)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmCoding() {
        return this.versionAlgorithm instanceof Coding;
    }

    @Override
    public boolean hasVersionAlgorithm() {
        return this.versionAlgorithm != null && !this.versionAlgorithm.isEmpty();
    }

    @Override
    public ExampleScenario setVersionAlgorithm(DataType value) {
        if (value != null && !(value instanceof StringType) && !(value instanceof Coding)) {
            throw new FHIRException("Not the right type for ExampleScenario.versionAlgorithm[x]: " + value.fhirType());
        }
        this.versionAlgorithm = value;
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ExampleScenario setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ExampleScenario setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ExampleScenario setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ExampleScenario setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ExampleScenario setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ExampleScenario setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ExampleScenario setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ExampleScenario setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ExampleScenario setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ExampleScenario setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ExampleScenario setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ExampleScenario setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public ExampleScenario setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ExampleScenario addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ExampleScenario setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ExampleScenario setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public ExampleScenario setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ExampleScenario addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public ExampleScenario setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ExampleScenario addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public ExampleScenario setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public ExampleScenario setPurpose(String value) {
        if (Utilities.noString((String)value)) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public ExampleScenario setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public ExampleScenario setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getCopyrightLabelElement() {
        if (this.copyrightLabel == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.copyrightLabel");
            }
            if (Configuration.doAutoCreate()) {
                this.copyrightLabel = new StringType();
            }
        }
        return this.copyrightLabel;
    }

    @Override
    public boolean hasCopyrightLabelElement() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public boolean hasCopyrightLabel() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public ExampleScenario setCopyrightLabelElement(StringType value) {
        this.copyrightLabel = value;
        return this;
    }

    @Override
    public String getCopyrightLabel() {
        return this.copyrightLabel == null ? null : (String)this.copyrightLabel.getValue();
    }

    @Override
    public ExampleScenario setCopyrightLabel(String value) {
        if (Utilities.noString((String)value)) {
            this.copyrightLabel = null;
        } else {
            if (this.copyrightLabel == null) {
                this.copyrightLabel = new StringType();
            }
            this.copyrightLabel.setValue(value);
        }
        return this;
    }

    public List<ExampleScenarioActorComponent> getActor() {
        if (this.actor == null) {
            this.actor = new ArrayList<ExampleScenarioActorComponent>();
        }
        return this.actor;
    }

    public ExampleScenario setActor(List<ExampleScenarioActorComponent> theActor) {
        this.actor = theActor;
        return this;
    }

    public boolean hasActor() {
        if (this.actor == null) {
            return false;
        }
        for (ExampleScenarioActorComponent item : this.actor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExampleScenarioActorComponent addActor() {
        ExampleScenarioActorComponent t = new ExampleScenarioActorComponent();
        if (this.actor == null) {
            this.actor = new ArrayList<ExampleScenarioActorComponent>();
        }
        this.actor.add(t);
        return t;
    }

    public ExampleScenario addActor(ExampleScenarioActorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.actor == null) {
            this.actor = new ArrayList<ExampleScenarioActorComponent>();
        }
        this.actor.add(t);
        return this;
    }

    public ExampleScenarioActorComponent getActorFirstRep() {
        if (this.getActor().isEmpty()) {
            this.addActor();
        }
        return this.getActor().get(0);
    }

    public List<ExampleScenarioInstanceComponent> getInstance() {
        if (this.instance == null) {
            this.instance = new ArrayList<ExampleScenarioInstanceComponent>();
        }
        return this.instance;
    }

    public ExampleScenario setInstance(List<ExampleScenarioInstanceComponent> theInstance) {
        this.instance = theInstance;
        return this;
    }

    public boolean hasInstance() {
        if (this.instance == null) {
            return false;
        }
        for (ExampleScenarioInstanceComponent item : this.instance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExampleScenarioInstanceComponent addInstance() {
        ExampleScenarioInstanceComponent t = new ExampleScenarioInstanceComponent();
        if (this.instance == null) {
            this.instance = new ArrayList<ExampleScenarioInstanceComponent>();
        }
        this.instance.add(t);
        return t;
    }

    public ExampleScenario addInstance(ExampleScenarioInstanceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.instance == null) {
            this.instance = new ArrayList<ExampleScenarioInstanceComponent>();
        }
        this.instance.add(t);
        return this;
    }

    public ExampleScenarioInstanceComponent getInstanceFirstRep() {
        if (this.getInstance().isEmpty()) {
            this.addInstance();
        }
        return this.getInstance().get(0);
    }

    public List<ExampleScenarioProcessComponent> getProcess() {
        if (this.process == null) {
            this.process = new ArrayList<ExampleScenarioProcessComponent>();
        }
        return this.process;
    }

    public ExampleScenario setProcess(List<ExampleScenarioProcessComponent> theProcess) {
        this.process = theProcess;
        return this;
    }

    public boolean hasProcess() {
        if (this.process == null) {
            return false;
        }
        for (ExampleScenarioProcessComponent item : this.process) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExampleScenarioProcessComponent addProcess() {
        ExampleScenarioProcessComponent t = new ExampleScenarioProcessComponent();
        if (this.process == null) {
            this.process = new ArrayList<ExampleScenarioProcessComponent>();
        }
        this.process.add(t);
        return t;
    }

    public ExampleScenario addProcess(ExampleScenarioProcessComponent t) {
        if (t == null) {
            return this;
        }
        if (this.process == null) {
            this.process = new ArrayList<ExampleScenarioProcessComponent>();
        }
        this.process.add(t);
        return this;
    }

    public ExampleScenarioProcessComponent getProcessFirstRep() {
        if (this.getProcess().isEmpty()) {
            this.addProcess();
        }
        return this.getProcess().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this example scenario when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this example scenario is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the example scenario is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this example scenario when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the example scenario when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the example scenario author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm));
        children.add(new Property(SP_NAME, "string", "Temporarily retained for tooling purposes.", 0, 1, this.name));
        children.add(new Property("title", "string", "A short, descriptive, user-friendly title for the ExampleScenario.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this example scenario. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this example scenario is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the example scenario was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the example scenario changes. (e.g. the 'content logical definition').", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the example scenario.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("description", "markdown", "A free text natural language description of the ExampleScenario from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate example scenario instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the example scenario is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "What the example scenario resource is created for. This should not be used to show the business purpose of the scenario itself, but the purpose of documenting a scenario.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the example scenario and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the example scenario.", 0, 1, this.copyright));
        children.add(new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel));
        children.add(new Property("actor", "", "A system or person who shares or receives an instance within the scenario.", 0, Integer.MAX_VALUE, this.actor));
        children.add(new Property("instance", "", "A single data collection that is shared as part of the scenario.", 0, Integer.MAX_VALUE, this.instance));
        children.add(new Property("process", "", "A group of operations that represents a significant step within a scenario.", 0, Integer.MAX_VALUE, this.process));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this example scenario when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this example scenario is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the example scenario is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this example scenario when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the example scenario when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the example scenario author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case -115699031: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1508158071: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1836908904: {
                return new Property("versionAlgorithm[x]", "string", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1373807809: {
                return new Property("versionAlgorithm[x]", "Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "Temporarily retained for tooling purposes.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property("title", "string", "A short, descriptive, user-friendly title for the ExampleScenario.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this example scenario. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this example scenario is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the example scenario was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the example scenario changes. (e.g. the 'content logical definition').", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the example scenario.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property("description", "markdown", "A free text natural language description of the ExampleScenario from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate example scenario instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the example scenario is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "What the example scenario resource is created for. This should not be used to show the business purpose of the scenario itself, but the purpose of documenting a scenario.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the example scenario and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the example scenario.", 0, 1, this.copyright);
            }
            case 765157229: {
                return new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel);
            }
            case 92645877: {
                return new Property("actor", "", "A system or person who shares or receives an instance within the scenario.", 0, Integer.MAX_VALUE, this.actor);
            }
            case 555127957: {
                return new Property("instance", "", "A single data collection that is shared as part of the scenario.", 0, Integer.MAX_VALUE, this.instance);
            }
            case -309518737: {
                return new Property("process", "", "A group of operations that represents a significant step within a scenario.", 0, Integer.MAX_VALUE, this.process);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 1508158071: {
                Base[] baseArray;
                if (this.versionAlgorithm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.versionAlgorithm;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.copyright;
                }
                return baseArray;
            }
            case 765157229: {
                Base[] baseArray;
                if (this.copyrightLabel == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.copyrightLabel;
                }
                return baseArray;
            }
            case 92645877: {
                return this.actor == null ? new Base[]{} : this.actor.toArray(new Base[this.actor.size()]);
            }
            case 555127957: {
                return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
            }
            case -309518737: {
                return this.process == null ? new Base[]{} : this.process.toArray(new Base[this.process.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 1508158071: {
                this.versionAlgorithm = TypeConvertor.castToType(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 765157229: {
                this.copyrightLabel = TypeConvertor.castToString(value);
                return value;
            }
            case 92645877: {
                this.getActor().add((ExampleScenarioActorComponent)((Object)value));
                return value;
            }
            case 555127957: {
                this.getInstance().add((ExampleScenarioInstanceComponent)((Object)value));
                return value;
            }
            case -309518737: {
                this.getProcess().add((ExampleScenarioProcessComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = TypeConvertor.castToType(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("title")) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyrightLabel")) {
            this.copyrightLabel = TypeConvertor.castToString(value);
        } else if (name.equals("actor")) {
            this.getActor().add((ExampleScenarioActorComponent)((Object)value));
        } else if (name.equals("instance")) {
            this.getInstance().add((ExampleScenarioInstanceComponent)((Object)value));
        } else if (name.equals("process")) {
            this.getProcess().add((ExampleScenarioProcessComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = null;
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = null;
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals("title")) {
            this.title = null;
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(value);
        } else if (name.equals("description")) {
            this.description = null;
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(value);
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().remove(value);
        } else if (name.equals("purpose")) {
            this.purpose = null;
        } else if (name.equals("copyright")) {
            this.copyright = null;
        } else if (name.equals("copyrightLabel")) {
            this.copyrightLabel = null;
        } else if (name.equals("actor")) {
            this.getActor().remove((ExampleScenarioActorComponent)((Object)value));
        } else if (name.equals("instance")) {
            this.getInstance().remove((ExampleScenarioInstanceComponent)((Object)value));
        } else if (name.equals("process")) {
            this.getProcess().remove((ExampleScenarioProcessComponent)((Object)value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -115699031: {
                return this.getVersionAlgorithm();
            }
            case 1508158071: {
                return this.getVersionAlgorithm();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 765157229: {
                return this.getCopyrightLabelElement();
            }
            case 92645877: {
                return this.addActor();
            }
            case 555127957: {
                return this.addInstance();
            }
            case -309518737: {
                return this.addProcess();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 1508158071: {
                return new String[]{"string", "Coding"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 765157229: {
                return new String[]{"string"};
            }
            case 92645877: {
                return new String[0];
            }
            case 555127957: {
                return new String[0];
            }
            case -309518737: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.version");
        }
        if (name.equals("versionAlgorithmString")) {
            this.versionAlgorithm = new StringType();
            return this.versionAlgorithm;
        }
        if (name.equals("versionAlgorithmCoding")) {
            this.versionAlgorithm = new Coding();
            return this.versionAlgorithm;
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.name");
        }
        if (name.equals("title")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.copyright");
        }
        if (name.equals("copyrightLabel")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.copyrightLabel");
        }
        if (name.equals("actor")) {
            return this.addActor();
        }
        if (name.equals("instance")) {
            return this.addInstance();
        }
        if (name.equals("process")) {
            return this.addProcess();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ExampleScenario";
    }

    @Override
    public ExampleScenario copy() {
        ExampleScenario dst = new ExampleScenario();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ExampleScenario dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.versionAlgorithm = this.versionAlgorithm == null ? null : this.versionAlgorithm.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        StringType stringType2 = dst.copyrightLabel = this.copyrightLabel == null ? null : this.copyrightLabel.copy();
        if (this.actor != null) {
            dst.actor = new ArrayList<ExampleScenarioActorComponent>();
            for (ExampleScenarioActorComponent exampleScenarioActorComponent : this.actor) {
                dst.actor.add(exampleScenarioActorComponent.copy());
            }
        }
        if (this.instance != null) {
            dst.instance = new ArrayList<ExampleScenarioInstanceComponent>();
            for (ExampleScenarioInstanceComponent exampleScenarioInstanceComponent : this.instance) {
                dst.instance.add(exampleScenarioInstanceComponent.copy());
            }
        }
        if (this.process != null) {
            dst.process = new ArrayList<ExampleScenarioProcessComponent>();
            for (ExampleScenarioProcessComponent exampleScenarioProcessComponent : this.process) {
                dst.process.add(exampleScenarioProcessComponent.copy());
            }
        }
    }

    protected ExampleScenario typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ExampleScenario)) {
            return false;
        }
        ExampleScenario o = (ExampleScenario)other_;
        return ExampleScenario.compareDeep(this.url, o.url, true) && ExampleScenario.compareDeep(this.identifier, o.identifier, true) && ExampleScenario.compareDeep(this.version, o.version, true) && ExampleScenario.compareDeep(this.versionAlgorithm, o.versionAlgorithm, true) && ExampleScenario.compareDeep(this.name, o.name, true) && ExampleScenario.compareDeep(this.title, o.title, true) && ExampleScenario.compareDeep(this.status, o.status, true) && ExampleScenario.compareDeep(this.experimental, o.experimental, true) && ExampleScenario.compareDeep(this.date, o.date, true) && ExampleScenario.compareDeep(this.publisher, o.publisher, true) && ExampleScenario.compareDeep(this.contact, o.contact, true) && ExampleScenario.compareDeep(this.description, o.description, true) && ExampleScenario.compareDeep(this.useContext, o.useContext, true) && ExampleScenario.compareDeep(this.jurisdiction, o.jurisdiction, true) && ExampleScenario.compareDeep(this.purpose, o.purpose, true) && ExampleScenario.compareDeep(this.copyright, o.copyright, true) && ExampleScenario.compareDeep(this.copyrightLabel, o.copyrightLabel, true) && ExampleScenario.compareDeep(this.actor, o.actor, true) && ExampleScenario.compareDeep(this.instance, o.instance, true) && ExampleScenario.compareDeep(this.process, o.process, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ExampleScenario)) {
            return false;
        }
        ExampleScenario o = (ExampleScenario)other_;
        return ExampleScenario.compareValues(this.url, o.url, true) && ExampleScenario.compareValues(this.version, o.version, true) && ExampleScenario.compareValues(this.name, o.name, true) && ExampleScenario.compareValues(this.title, o.title, true) && ExampleScenario.compareValues(this.status, o.status, true) && ExampleScenario.compareValues(this.experimental, o.experimental, true) && ExampleScenario.compareValues(this.date, o.date, true) && ExampleScenario.compareValues(this.publisher, o.publisher, true) && ExampleScenario.compareValues(this.description, o.description, true) && ExampleScenario.compareValues(this.purpose, o.purpose, true) && ExampleScenario.compareValues(this.copyright, o.copyright, true) && ExampleScenario.compareValues(this.copyrightLabel, o.copyrightLabel, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.versionAlgorithm, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.copyrightLabel, this.actor, this.instance, this.process});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ExampleScenario;
    }

    @Block
    public static class ExampleScenarioActorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="key", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="ID or acronym of the actor", formalDefinition="A unique string within the scenario that is used to reference the actor.")
        protected StringType key;
        @Child(name="type", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="person | system", formalDefinition="The category of actor - person or system.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/examplescenario-actor-type")
        protected Enumeration<Enumerations.ExampleScenarioActorType> type;
        @Child(name="title", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for actor when rendering", formalDefinition="The human-readable name for the actor used when rendering the scenario.")
        protected StringType title;
        @Child(name="description", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Details about actor", formalDefinition="An explanation of who/what the actor is and its role in the scenario.")
        protected MarkdownType description;
        private static final long serialVersionUID = 267911906L;

        public ExampleScenarioActorComponent() {
        }

        public ExampleScenarioActorComponent(String key, Enumerations.ExampleScenarioActorType type, String title) {
            this.setKey(key);
            this.setType(type);
            this.setTitle(title);
        }

        public StringType getKeyElement() {
            if (this.key == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioActorComponent.key");
                }
                if (Configuration.doAutoCreate()) {
                    this.key = new StringType();
                }
            }
            return this.key;
        }

        public boolean hasKeyElement() {
            return this.key != null && !this.key.isEmpty();
        }

        public boolean hasKey() {
            return this.key != null && !this.key.isEmpty();
        }

        public ExampleScenarioActorComponent setKeyElement(StringType value) {
            this.key = value;
            return this;
        }

        public String getKey() {
            return this.key == null ? null : (String)this.key.getValue();
        }

        public ExampleScenarioActorComponent setKey(String value) {
            if (this.key == null) {
                this.key = new StringType();
            }
            this.key.setValue(value);
            return this;
        }

        public Enumeration<Enumerations.ExampleScenarioActorType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioActorComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.ExampleScenarioActorType>(new Enumerations.ExampleScenarioActorTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ExampleScenarioActorComponent setTypeElement(Enumeration<Enumerations.ExampleScenarioActorType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.ExampleScenarioActorType getType() {
            return this.type == null ? null : (Enumerations.ExampleScenarioActorType)((Object)this.type.getValue());
        }

        public ExampleScenarioActorComponent setType(Enumerations.ExampleScenarioActorType value) {
            if (this.type == null) {
                this.type = new Enumeration<Enumerations.ExampleScenarioActorType>(new Enumerations.ExampleScenarioActorTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioActorComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ExampleScenarioActorComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ExampleScenarioActorComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioActorComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioActorComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioActorComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("key", "string", "A unique string within the scenario that is used to reference the actor.", 0, 1, this.key));
            children.add(new Property("type", "code", "The category of actor - person or system.", 0, 1, this.type));
            children.add(new Property("title", "string", "The human-readable name for the actor used when rendering the scenario.", 0, 1, this.title));
            children.add(new Property("description", "markdown", "An explanation of who/what the actor is and its role in the scenario.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 106079: {
                    return new Property("key", "string", "A unique string within the scenario that is used to reference the actor.", 0, 1, this.key);
                }
                case 3575610: {
                    return new Property("type", "code", "The category of actor - person or system.", 0, 1, this.type);
                }
                case 110371416: {
                    return new Property("title", "string", "The human-readable name for the actor used when rendering the scenario.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "An explanation of who/what the actor is and its role in the scenario.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 106079: {
                    Base[] baseArray;
                    if (this.key == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.key;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 106079: {
                    this.key = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new Enumerations.ExampleScenarioActorTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("key")) {
                this.key = TypeConvertor.castToString(value);
            } else if (name.equals("type")) {
                value = new Enumerations.ExampleScenarioActorTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("key")) {
                this.key = null;
            } else if (name.equals("type")) {
                value = new Enumerations.ExampleScenarioActorTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("title")) {
                this.title = null;
            } else if (name.equals("description")) {
                this.description = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106079: {
                    return this.getKeyElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106079: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("key")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.actor.key");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.actor.type");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.actor.title");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.actor.description");
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioActorComponent copy() {
            ExampleScenarioActorComponent dst = new ExampleScenarioActorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioActorComponent dst) {
            super.copyValues(dst);
            dst.key = this.key == null ? null : this.key.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.title = this.title == null ? null : this.title.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioActorComponent)) {
                return false;
            }
            ExampleScenarioActorComponent o = (ExampleScenarioActorComponent)other_;
            return ExampleScenarioActorComponent.compareDeep(this.key, o.key, true) && ExampleScenarioActorComponent.compareDeep(this.type, o.type, true) && ExampleScenarioActorComponent.compareDeep(this.title, o.title, true) && ExampleScenarioActorComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioActorComponent)) {
                return false;
            }
            ExampleScenarioActorComponent o = (ExampleScenarioActorComponent)other_;
            return ExampleScenarioActorComponent.compareValues(this.key, o.key, true) && ExampleScenarioActorComponent.compareValues(this.type, o.type, true) && ExampleScenarioActorComponent.compareValues(this.title, o.title, true) && ExampleScenarioActorComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.key, this.type, this.title, this.description});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.actor";
        }
    }

    @Block
    public static class ExampleScenarioInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="key", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="ID or acronym of the instance", formalDefinition="A unique string within the scenario that is used to reference the instance.")
        protected StringType key;
        @Child(name="structureType", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Data structure for example", formalDefinition="A code indicating the kind of data structure (FHIR resource or some other standard) this is an instance of.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/examplescenario-instance-type")
        protected Coding structureType;
        @Child(name="structureVersion", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. 4.0.1", formalDefinition="Conveys the version of the data structure instantiated.  I.e. what release of FHIR, X12, OpenEHR, etc. is instance compliant with.")
        protected StringType structureVersion;
        @Child(name="structureProfile", type={CanonicalType.class, UriType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Rules instance adheres to", formalDefinition="Refers to a profile, template or other ruleset the instance adheres to.")
        protected DataType structureProfile;
        @Child(name="title", type={StringType.class}, order=5, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for instance", formalDefinition="A short descriptive label the instance to be used in tables or diagrams.")
        protected StringType title;
        @Child(name="description", type={MarkdownType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human-friendly description of the instance", formalDefinition="An explanation of what the instance contains and what it's for.")
        protected MarkdownType description;
        @Child(name="content", type={Reference.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Example instance data", formalDefinition="Points to an instance (typically an example) that shows the data that would corespond to this instance.")
        protected Reference content;
        @Child(name="version", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Snapshot of instance that changes", formalDefinition="Represents the instance as it was at a specific time-point.")
        protected List<ExampleScenarioInstanceVersionComponent> version;
        @Child(name="containedInstance", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Resources contained in the instance", formalDefinition="References to other instances that can be found within this instance (e.g. the observations contained in a bundle).")
        protected List<ExampleScenarioInstanceContainedInstanceComponent> containedInstance;
        private static final long serialVersionUID = -1366610733L;

        public ExampleScenarioInstanceComponent() {
        }

        public ExampleScenarioInstanceComponent(String key, Coding structureType, String title) {
            this.setKey(key);
            this.setStructureType(structureType);
            this.setTitle(title);
        }

        public StringType getKeyElement() {
            if (this.key == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.key");
                }
                if (Configuration.doAutoCreate()) {
                    this.key = new StringType();
                }
            }
            return this.key;
        }

        public boolean hasKeyElement() {
            return this.key != null && !this.key.isEmpty();
        }

        public boolean hasKey() {
            return this.key != null && !this.key.isEmpty();
        }

        public ExampleScenarioInstanceComponent setKeyElement(StringType value) {
            this.key = value;
            return this;
        }

        public String getKey() {
            return this.key == null ? null : (String)this.key.getValue();
        }

        public ExampleScenarioInstanceComponent setKey(String value) {
            if (this.key == null) {
                this.key = new StringType();
            }
            this.key.setValue(value);
            return this;
        }

        public Coding getStructureType() {
            if (this.structureType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.structureType");
                }
                if (Configuration.doAutoCreate()) {
                    this.structureType = new Coding();
                }
            }
            return this.structureType;
        }

        public boolean hasStructureType() {
            return this.structureType != null && !this.structureType.isEmpty();
        }

        public ExampleScenarioInstanceComponent setStructureType(Coding value) {
            this.structureType = value;
            return this;
        }

        public StringType getStructureVersionElement() {
            if (this.structureVersion == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.structureVersion");
                }
                if (Configuration.doAutoCreate()) {
                    this.structureVersion = new StringType();
                }
            }
            return this.structureVersion;
        }

        public boolean hasStructureVersionElement() {
            return this.structureVersion != null && !this.structureVersion.isEmpty();
        }

        public boolean hasStructureVersion() {
            return this.structureVersion != null && !this.structureVersion.isEmpty();
        }

        public ExampleScenarioInstanceComponent setStructureVersionElement(StringType value) {
            this.structureVersion = value;
            return this;
        }

        public String getStructureVersion() {
            return this.structureVersion == null ? null : (String)this.structureVersion.getValue();
        }

        public ExampleScenarioInstanceComponent setStructureVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.structureVersion = null;
            } else {
                if (this.structureVersion == null) {
                    this.structureVersion = new StringType();
                }
                this.structureVersion.setValue(value);
            }
            return this;
        }

        public DataType getStructureProfile() {
            return this.structureProfile;
        }

        public CanonicalType getStructureProfileCanonicalType() throws FHIRException {
            if (this.structureProfile == null) {
                this.structureProfile = new CanonicalType();
            }
            if (!(this.structureProfile instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.structureProfile.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.structureProfile;
        }

        public boolean hasStructureProfileCanonicalType() {
            return this.structureProfile instanceof CanonicalType;
        }

        public UriType getStructureProfileUriType() throws FHIRException {
            if (this.structureProfile == null) {
                this.structureProfile = new UriType();
            }
            if (!(this.structureProfile instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.structureProfile.getClass().getName() + " was encountered");
            }
            return (UriType)this.structureProfile;
        }

        public boolean hasStructureProfileUriType() {
            return this.structureProfile instanceof UriType;
        }

        public boolean hasStructureProfile() {
            return this.structureProfile != null && !this.structureProfile.isEmpty();
        }

        public ExampleScenarioInstanceComponent setStructureProfile(DataType value) {
            if (value != null && !(value instanceof CanonicalType) && !(value instanceof UriType)) {
                throw new FHIRException("Not the right type for ExampleScenario.instance.structureProfile[x]: " + value.fhirType());
            }
            this.structureProfile = value;
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ExampleScenarioInstanceComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ExampleScenarioInstanceComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioInstanceComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioInstanceComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Reference getContent() {
            if (this.content == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.content");
                }
                if (Configuration.doAutoCreate()) {
                    this.content = new Reference();
                }
            }
            return this.content;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public ExampleScenarioInstanceComponent setContent(Reference value) {
            this.content = value;
            return this;
        }

        public List<ExampleScenarioInstanceVersionComponent> getVersion() {
            if (this.version == null) {
                this.version = new ArrayList<ExampleScenarioInstanceVersionComponent>();
            }
            return this.version;
        }

        public ExampleScenarioInstanceComponent setVersion(List<ExampleScenarioInstanceVersionComponent> theVersion) {
            this.version = theVersion;
            return this;
        }

        public boolean hasVersion() {
            if (this.version == null) {
                return false;
            }
            for (ExampleScenarioInstanceVersionComponent item : this.version) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioInstanceVersionComponent addVersion() {
            ExampleScenarioInstanceVersionComponent t = new ExampleScenarioInstanceVersionComponent();
            if (this.version == null) {
                this.version = new ArrayList<ExampleScenarioInstanceVersionComponent>();
            }
            this.version.add(t);
            return t;
        }

        public ExampleScenarioInstanceComponent addVersion(ExampleScenarioInstanceVersionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.version == null) {
                this.version = new ArrayList<ExampleScenarioInstanceVersionComponent>();
            }
            this.version.add(t);
            return this;
        }

        public ExampleScenarioInstanceVersionComponent getVersionFirstRep() {
            if (this.getVersion().isEmpty()) {
                this.addVersion();
            }
            return this.getVersion().get(0);
        }

        public List<ExampleScenarioInstanceContainedInstanceComponent> getContainedInstance() {
            if (this.containedInstance == null) {
                this.containedInstance = new ArrayList<ExampleScenarioInstanceContainedInstanceComponent>();
            }
            return this.containedInstance;
        }

        public ExampleScenarioInstanceComponent setContainedInstance(List<ExampleScenarioInstanceContainedInstanceComponent> theContainedInstance) {
            this.containedInstance = theContainedInstance;
            return this;
        }

        public boolean hasContainedInstance() {
            if (this.containedInstance == null) {
                return false;
            }
            for (ExampleScenarioInstanceContainedInstanceComponent item : this.containedInstance) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioInstanceContainedInstanceComponent addContainedInstance() {
            ExampleScenarioInstanceContainedInstanceComponent t = new ExampleScenarioInstanceContainedInstanceComponent();
            if (this.containedInstance == null) {
                this.containedInstance = new ArrayList<ExampleScenarioInstanceContainedInstanceComponent>();
            }
            this.containedInstance.add(t);
            return t;
        }

        public ExampleScenarioInstanceComponent addContainedInstance(ExampleScenarioInstanceContainedInstanceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.containedInstance == null) {
                this.containedInstance = new ArrayList<ExampleScenarioInstanceContainedInstanceComponent>();
            }
            this.containedInstance.add(t);
            return this;
        }

        public ExampleScenarioInstanceContainedInstanceComponent getContainedInstanceFirstRep() {
            if (this.getContainedInstance().isEmpty()) {
                this.addContainedInstance();
            }
            return this.getContainedInstance().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("key", "string", "A unique string within the scenario that is used to reference the instance.", 0, 1, this.key));
            children.add(new Property("structureType", "Coding", "A code indicating the kind of data structure (FHIR resource or some other standard) this is an instance of.", 0, 1, this.structureType));
            children.add(new Property("structureVersion", "string", "Conveys the version of the data structure instantiated.  I.e. what release of FHIR, X12, OpenEHR, etc. is instance compliant with.", 0, 1, this.structureVersion));
            children.add(new Property("structureProfile[x]", "canonical|uri", "Refers to a profile, template or other ruleset the instance adheres to.", 0, 1, this.structureProfile));
            children.add(new Property("title", "string", "A short descriptive label the instance to be used in tables or diagrams.", 0, 1, this.title));
            children.add(new Property("description", "markdown", "An explanation of what the instance contains and what it's for.", 0, 1, this.description));
            children.add(new Property("content", "Reference", "Points to an instance (typically an example) that shows the data that would corespond to this instance.", 0, 1, this.content));
            children.add(new Property(ExampleScenario.SP_VERSION, "", "Represents the instance as it was at a specific time-point.", 0, Integer.MAX_VALUE, this.version));
            children.add(new Property("containedInstance", "", "References to other instances that can be found within this instance (e.g. the observations contained in a bundle).", 0, Integer.MAX_VALUE, this.containedInstance));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 106079: {
                    return new Property("key", "string", "A unique string within the scenario that is used to reference the instance.", 0, 1, this.key);
                }
                case -222609587: {
                    return new Property("structureType", "Coding", "A code indicating the kind of data structure (FHIR resource or some other standard) this is an instance of.", 0, 1, this.structureType);
                }
                case 872091621: {
                    return new Property("structureVersion", "string", "Conveys the version of the data structure instantiated.  I.e. what release of FHIR, X12, OpenEHR, etc. is instance compliant with.", 0, 1, this.structureVersion);
                }
                case -207739894: {
                    return new Property("structureProfile[x]", "canonical|uri", "Refers to a profile, template or other ruleset the instance adheres to.", 0, 1, this.structureProfile);
                }
                case 211057846: {
                    return new Property("structureProfile[x]", "canonical|uri", "Refers to a profile, template or other ruleset the instance adheres to.", 0, 1, this.structureProfile);
                }
                case -1044433698: {
                    return new Property("structureProfile[x]", "canonical", "Refers to a profile, template or other ruleset the instance adheres to.", 0, 1, this.structureProfile);
                }
                case -207745834: {
                    return new Property("structureProfile[x]", "uri", "Refers to a profile, template or other ruleset the instance adheres to.", 0, 1, this.structureProfile);
                }
                case 110371416: {
                    return new Property("title", "string", "A short descriptive label the instance to be used in tables or diagrams.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "An explanation of what the instance contains and what it's for.", 0, 1, this.description);
                }
                case 951530617: {
                    return new Property("content", "Reference", "Points to an instance (typically an example) that shows the data that would corespond to this instance.", 0, 1, this.content);
                }
                case 351608024: {
                    return new Property(ExampleScenario.SP_VERSION, "", "Represents the instance as it was at a specific time-point.", 0, Integer.MAX_VALUE, this.version);
                }
                case -417062360: {
                    return new Property("containedInstance", "", "References to other instances that can be found within this instance (e.g. the observations contained in a bundle).", 0, Integer.MAX_VALUE, this.containedInstance);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 106079: {
                    Base[] baseArray;
                    if (this.key == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.key;
                    }
                    return baseArray;
                }
                case -222609587: {
                    Base[] baseArray;
                    if (this.structureType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.structureType;
                    }
                    return baseArray;
                }
                case 872091621: {
                    Base[] baseArray;
                    if (this.structureVersion == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.structureVersion;
                    }
                    return baseArray;
                }
                case 211057846: {
                    Base[] baseArray;
                    if (this.structureProfile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.structureProfile;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.description;
                    }
                    return baseArray;
                }
                case 951530617: {
                    Base[] baseArray;
                    if (this.content == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.content;
                    }
                    return baseArray;
                }
                case 351608024: {
                    return this.version == null ? new Base[]{} : this.version.toArray(new Base[this.version.size()]);
                }
                case -417062360: {
                    return this.containedInstance == null ? new Base[]{} : this.containedInstance.toArray(new Base[this.containedInstance.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 106079: {
                    this.key = TypeConvertor.castToString(value);
                    return value;
                }
                case -222609587: {
                    this.structureType = TypeConvertor.castToCoding(value);
                    return value;
                }
                case 872091621: {
                    this.structureVersion = TypeConvertor.castToString(value);
                    return value;
                }
                case 211057846: {
                    this.structureProfile = TypeConvertor.castToType(value);
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 951530617: {
                    this.content = TypeConvertor.castToReference(value);
                    return value;
                }
                case 351608024: {
                    this.getVersion().add((ExampleScenarioInstanceVersionComponent)value);
                    return value;
                }
                case -417062360: {
                    this.getContainedInstance().add((ExampleScenarioInstanceContainedInstanceComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("key")) {
                this.key = TypeConvertor.castToString(value);
            } else if (name.equals("structureType")) {
                this.structureType = TypeConvertor.castToCoding(value);
            } else if (name.equals("structureVersion")) {
                this.structureVersion = TypeConvertor.castToString(value);
            } else if (name.equals("structureProfile[x]")) {
                this.structureProfile = TypeConvertor.castToType(value);
            } else if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("content")) {
                this.content = TypeConvertor.castToReference(value);
            } else if (name.equals(ExampleScenario.SP_VERSION)) {
                this.getVersion().add((ExampleScenarioInstanceVersionComponent)value);
            } else if (name.equals("containedInstance")) {
                this.getContainedInstance().add((ExampleScenarioInstanceContainedInstanceComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("key")) {
                this.key = null;
            } else if (name.equals("structureType")) {
                this.structureType = null;
            } else if (name.equals("structureVersion")) {
                this.structureVersion = null;
            } else if (name.equals("structureProfile[x]")) {
                this.structureProfile = null;
            } else if (name.equals("title")) {
                this.title = null;
            } else if (name.equals("description")) {
                this.description = null;
            } else if (name.equals("content")) {
                this.content = null;
            } else if (name.equals(ExampleScenario.SP_VERSION)) {
                this.getVersion().remove((ExampleScenarioInstanceVersionComponent)value);
            } else if (name.equals("containedInstance")) {
                this.getContainedInstance().remove((ExampleScenarioInstanceContainedInstanceComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106079: {
                    return this.getKeyElement();
                }
                case -222609587: {
                    return this.getStructureType();
                }
                case 872091621: {
                    return this.getStructureVersionElement();
                }
                case -207739894: {
                    return this.getStructureProfile();
                }
                case 211057846: {
                    return this.getStructureProfile();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 951530617: {
                    return this.getContent();
                }
                case 351608024: {
                    return this.addVersion();
                }
                case -417062360: {
                    return this.addContainedInstance();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106079: {
                    return new String[]{"string"};
                }
                case -222609587: {
                    return new String[]{"Coding"};
                }
                case 872091621: {
                    return new String[]{"string"};
                }
                case 211057846: {
                    return new String[]{"canonical", "uri"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 951530617: {
                    return new String[]{"Reference"};
                }
                case 351608024: {
                    return new String[0];
                }
                case -417062360: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("key")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.key");
            }
            if (name.equals("structureType")) {
                this.structureType = new Coding();
                return this.structureType;
            }
            if (name.equals("structureVersion")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.structureVersion");
            }
            if (name.equals("structureProfileCanonical")) {
                this.structureProfile = new CanonicalType();
                return this.structureProfile;
            }
            if (name.equals("structureProfileUri")) {
                this.structureProfile = new UriType();
                return this.structureProfile;
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.title");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.description");
            }
            if (name.equals("content")) {
                this.content = new Reference();
                return this.content;
            }
            if (name.equals(ExampleScenario.SP_VERSION)) {
                return this.addVersion();
            }
            if (name.equals("containedInstance")) {
                return this.addContainedInstance();
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioInstanceComponent copy() {
            ExampleScenarioInstanceComponent dst = new ExampleScenarioInstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioInstanceComponent dst) {
            super.copyValues(dst);
            dst.key = this.key == null ? null : this.key.copy();
            dst.structureType = this.structureType == null ? null : this.structureType.copy();
            dst.structureVersion = this.structureVersion == null ? null : this.structureVersion.copy();
            dst.structureProfile = this.structureProfile == null ? null : this.structureProfile.copy();
            dst.title = this.title == null ? null : this.title.copy();
            dst.description = this.description == null ? null : this.description.copy();
            Reference reference = dst.content = this.content == null ? null : this.content.copy();
            if (this.version != null) {
                dst.version = new ArrayList<ExampleScenarioInstanceVersionComponent>();
                for (ExampleScenarioInstanceVersionComponent exampleScenarioInstanceVersionComponent : this.version) {
                    dst.version.add(exampleScenarioInstanceVersionComponent.copy());
                }
            }
            if (this.containedInstance != null) {
                dst.containedInstance = new ArrayList<ExampleScenarioInstanceContainedInstanceComponent>();
                for (ExampleScenarioInstanceContainedInstanceComponent exampleScenarioInstanceContainedInstanceComponent : this.containedInstance) {
                    dst.containedInstance.add(exampleScenarioInstanceContainedInstanceComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceComponent)) {
                return false;
            }
            ExampleScenarioInstanceComponent o = (ExampleScenarioInstanceComponent)other_;
            return ExampleScenarioInstanceComponent.compareDeep(this.key, o.key, true) && ExampleScenarioInstanceComponent.compareDeep(this.structureType, o.structureType, true) && ExampleScenarioInstanceComponent.compareDeep(this.structureVersion, o.structureVersion, true) && ExampleScenarioInstanceComponent.compareDeep(this.structureProfile, o.structureProfile, true) && ExampleScenarioInstanceComponent.compareDeep(this.title, o.title, true) && ExampleScenarioInstanceComponent.compareDeep(this.description, o.description, true) && ExampleScenarioInstanceComponent.compareDeep(this.content, o.content, true) && ExampleScenarioInstanceComponent.compareDeep(this.version, o.version, true) && ExampleScenarioInstanceComponent.compareDeep(this.containedInstance, o.containedInstance, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceComponent)) {
                return false;
            }
            ExampleScenarioInstanceComponent o = (ExampleScenarioInstanceComponent)other_;
            return ExampleScenarioInstanceComponent.compareValues(this.key, o.key, true) && ExampleScenarioInstanceComponent.compareValues(this.structureVersion, o.structureVersion, true) && ExampleScenarioInstanceComponent.compareValues(this.title, o.title, true) && ExampleScenarioInstanceComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.key, this.structureType, this.structureVersion, this.structureProfile, this.title, this.description, this.content, this.version, this.containedInstance});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.instance";
        }
    }

    @Block
    public static class ExampleScenarioProcessComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Label for procss", formalDefinition="A short descriptive label the process to be used in tables or diagrams.")
        protected StringType title;
        @Child(name="description", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human-friendly description of the process", formalDefinition="An explanation of what the process represents and what it does.")
        protected MarkdownType description;
        @Child(name="preConditions", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Status before process starts", formalDefinition="Description of the initial state of the actors, environment and data before the process starts.")
        protected MarkdownType preConditions;
        @Child(name="postConditions", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Status after successful completion", formalDefinition="Description of the final state of the actors, environment and data after the process has been successfully completed.")
        protected MarkdownType postConditions;
        @Child(name="step", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Event within of the process", formalDefinition="A significant action that occurs as part of the process.")
        protected List<ExampleScenarioProcessStepComponent> step;
        private static final long serialVersionUID = 325578043L;

        public ExampleScenarioProcessComponent() {
        }

        public ExampleScenarioProcessComponent(String title) {
            this.setTitle(title);
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ExampleScenarioProcessComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ExampleScenarioProcessComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioProcessComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioProcessComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public MarkdownType getPreConditionsElement() {
            if (this.preConditions == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessComponent.preConditions");
                }
                if (Configuration.doAutoCreate()) {
                    this.preConditions = new MarkdownType();
                }
            }
            return this.preConditions;
        }

        public boolean hasPreConditionsElement() {
            return this.preConditions != null && !this.preConditions.isEmpty();
        }

        public boolean hasPreConditions() {
            return this.preConditions != null && !this.preConditions.isEmpty();
        }

        public ExampleScenarioProcessComponent setPreConditionsElement(MarkdownType value) {
            this.preConditions = value;
            return this;
        }

        public String getPreConditions() {
            return this.preConditions == null ? null : (String)this.preConditions.getValue();
        }

        public ExampleScenarioProcessComponent setPreConditions(String value) {
            if (Utilities.noString((String)value)) {
                this.preConditions = null;
            } else {
                if (this.preConditions == null) {
                    this.preConditions = new MarkdownType();
                }
                this.preConditions.setValue(value);
            }
            return this;
        }

        public MarkdownType getPostConditionsElement() {
            if (this.postConditions == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessComponent.postConditions");
                }
                if (Configuration.doAutoCreate()) {
                    this.postConditions = new MarkdownType();
                }
            }
            return this.postConditions;
        }

        public boolean hasPostConditionsElement() {
            return this.postConditions != null && !this.postConditions.isEmpty();
        }

        public boolean hasPostConditions() {
            return this.postConditions != null && !this.postConditions.isEmpty();
        }

        public ExampleScenarioProcessComponent setPostConditionsElement(MarkdownType value) {
            this.postConditions = value;
            return this;
        }

        public String getPostConditions() {
            return this.postConditions == null ? null : (String)this.postConditions.getValue();
        }

        public ExampleScenarioProcessComponent setPostConditions(String value) {
            if (Utilities.noString((String)value)) {
                this.postConditions = null;
            } else {
                if (this.postConditions == null) {
                    this.postConditions = new MarkdownType();
                }
                this.postConditions.setValue(value);
            }
            return this;
        }

        public List<ExampleScenarioProcessStepComponent> getStep() {
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            return this.step;
        }

        public ExampleScenarioProcessComponent setStep(List<ExampleScenarioProcessStepComponent> theStep) {
            this.step = theStep;
            return this;
        }

        public boolean hasStep() {
            if (this.step == null) {
                return false;
            }
            for (ExampleScenarioProcessStepComponent item : this.step) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioProcessStepComponent addStep() {
            ExampleScenarioProcessStepComponent t = new ExampleScenarioProcessStepComponent();
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            this.step.add(t);
            return t;
        }

        public ExampleScenarioProcessComponent addStep(ExampleScenarioProcessStepComponent t) {
            if (t == null) {
                return this;
            }
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            this.step.add(t);
            return this;
        }

        public ExampleScenarioProcessStepComponent getStepFirstRep() {
            if (this.getStep().isEmpty()) {
                this.addStep();
            }
            return this.getStep().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("title", "string", "A short descriptive label the process to be used in tables or diagrams.", 0, 1, this.title));
            children.add(new Property("description", "markdown", "An explanation of what the process represents and what it does.", 0, 1, this.description));
            children.add(new Property("preConditions", "markdown", "Description of the initial state of the actors, environment and data before the process starts.", 0, 1, this.preConditions));
            children.add(new Property("postConditions", "markdown", "Description of the final state of the actors, environment and data after the process has been successfully completed.", 0, 1, this.postConditions));
            children.add(new Property("step", "", "A significant action that occurs as part of the process.", 0, Integer.MAX_VALUE, this.step));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property("title", "string", "A short descriptive label the process to be used in tables or diagrams.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "An explanation of what the process represents and what it does.", 0, 1, this.description);
                }
                case -1006692933: {
                    return new Property("preConditions", "markdown", "Description of the initial state of the actors, environment and data before the process starts.", 0, 1, this.preConditions);
                }
                case 1738302328: {
                    return new Property("postConditions", "markdown", "Description of the final state of the actors, environment and data after the process has been successfully completed.", 0, 1, this.postConditions);
                }
                case 3540684: {
                    return new Property("step", "", "A significant action that occurs as part of the process.", 0, Integer.MAX_VALUE, this.step);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -1006692933: {
                    Base[] baseArray;
                    if (this.preConditions == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.preConditions;
                    }
                    return baseArray;
                }
                case 1738302328: {
                    Base[] baseArray;
                    if (this.postConditions == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.postConditions;
                    }
                    return baseArray;
                }
                case 3540684: {
                    return this.step == null ? new Base[]{} : this.step.toArray(new Base[this.step.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -1006692933: {
                    this.preConditions = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 1738302328: {
                    this.postConditions = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 3540684: {
                    this.getStep().add((ExampleScenarioProcessStepComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("preConditions")) {
                this.preConditions = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("postConditions")) {
                this.postConditions = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("step")) {
                this.getStep().add((ExampleScenarioProcessStepComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("title")) {
                this.title = null;
            } else if (name.equals("description")) {
                this.description = null;
            } else if (name.equals("preConditions")) {
                this.preConditions = null;
            } else if (name.equals("postConditions")) {
                this.postConditions = null;
            } else if (name.equals("step")) {
                this.getStep().remove((ExampleScenarioProcessStepComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1006692933: {
                    return this.getPreConditionsElement();
                }
                case 1738302328: {
                    return this.getPostConditionsElement();
                }
                case 3540684: {
                    return this.addStep();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case -1006692933: {
                    return new String[]{"markdown"};
                }
                case 1738302328: {
                    return new String[]{"markdown"};
                }
                case 3540684: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.title");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.description");
            }
            if (name.equals("preConditions")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.preConditions");
            }
            if (name.equals("postConditions")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.postConditions");
            }
            if (name.equals("step")) {
                return this.addStep();
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioProcessComponent copy() {
            ExampleScenarioProcessComponent dst = new ExampleScenarioProcessComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioProcessComponent dst) {
            super.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.preConditions = this.preConditions == null ? null : this.preConditions.copy();
            MarkdownType markdownType = dst.postConditions = this.postConditions == null ? null : this.postConditions.copy();
            if (this.step != null) {
                dst.step = new ArrayList<ExampleScenarioProcessStepComponent>();
                for (ExampleScenarioProcessStepComponent i : this.step) {
                    dst.step.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessComponent)) {
                return false;
            }
            ExampleScenarioProcessComponent o = (ExampleScenarioProcessComponent)other_;
            return ExampleScenarioProcessComponent.compareDeep(this.title, o.title, true) && ExampleScenarioProcessComponent.compareDeep(this.description, o.description, true) && ExampleScenarioProcessComponent.compareDeep(this.preConditions, o.preConditions, true) && ExampleScenarioProcessComponent.compareDeep(this.postConditions, o.postConditions, true) && ExampleScenarioProcessComponent.compareDeep(this.step, o.step, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessComponent)) {
                return false;
            }
            ExampleScenarioProcessComponent o = (ExampleScenarioProcessComponent)other_;
            return ExampleScenarioProcessComponent.compareValues(this.title, o.title, true) && ExampleScenarioProcessComponent.compareValues(this.description, o.description, true) && ExampleScenarioProcessComponent.compareValues(this.preConditions, o.preConditions, true) && ExampleScenarioProcessComponent.compareValues(this.postConditions, o.postConditions, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.title, this.description, this.preConditions, this.postConditions, this.step});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.process";
        }
    }

    @Block
    public static class ExampleScenarioProcessStepAlternativeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for alternative", formalDefinition="The label to display for the alternative that gives a sense of the circumstance in which the alternative should be invoked.")
        protected StringType title;
        @Child(name="description", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human-readable description of option", formalDefinition="A human-readable description of the alternative explaining when the alternative should occur rather than the base step.")
        protected MarkdownType description;
        @Child(name="step", type={ExampleScenarioProcessStepComponent.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Alternative action(s)", formalDefinition="Indicates the operation, sub-process or scenario that happens if the alternative option is selected.")
        protected List<ExampleScenarioProcessStepComponent> step;
        private static final long serialVersionUID = -254687460L;

        public ExampleScenarioProcessStepAlternativeComponent() {
        }

        public ExampleScenarioProcessStepAlternativeComponent(String title) {
            this.setTitle(title);
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepAlternativeComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ExampleScenarioProcessStepAlternativeComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ExampleScenarioProcessStepAlternativeComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepAlternativeComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioProcessStepAlternativeComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioProcessStepAlternativeComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<ExampleScenarioProcessStepComponent> getStep() {
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            return this.step;
        }

        public ExampleScenarioProcessStepAlternativeComponent setStep(List<ExampleScenarioProcessStepComponent> theStep) {
            this.step = theStep;
            return this;
        }

        public boolean hasStep() {
            if (this.step == null) {
                return false;
            }
            for (ExampleScenarioProcessStepComponent item : this.step) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioProcessStepComponent addStep() {
            ExampleScenarioProcessStepComponent t = new ExampleScenarioProcessStepComponent();
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            this.step.add(t);
            return t;
        }

        public ExampleScenarioProcessStepAlternativeComponent addStep(ExampleScenarioProcessStepComponent t) {
            if (t == null) {
                return this;
            }
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            this.step.add(t);
            return this;
        }

        public ExampleScenarioProcessStepComponent getStepFirstRep() {
            if (this.getStep().isEmpty()) {
                this.addStep();
            }
            return this.getStep().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("title", "string", "The label to display for the alternative that gives a sense of the circumstance in which the alternative should be invoked.", 0, 1, this.title));
            children.add(new Property("description", "markdown", "A human-readable description of the alternative explaining when the alternative should occur rather than the base step.", 0, 1, this.description));
            children.add(new Property("step", "@ExampleScenario.process.step", "Indicates the operation, sub-process or scenario that happens if the alternative option is selected.", 0, Integer.MAX_VALUE, this.step));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property("title", "string", "The label to display for the alternative that gives a sense of the circumstance in which the alternative should be invoked.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "A human-readable description of the alternative explaining when the alternative should occur rather than the base step.", 0, 1, this.description);
                }
                case 3540684: {
                    return new Property("step", "@ExampleScenario.process.step", "Indicates the operation, sub-process or scenario that happens if the alternative option is selected.", 0, Integer.MAX_VALUE, this.step);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 3540684: {
                    return this.step == null ? new Base[]{} : this.step.toArray(new Base[this.step.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 3540684: {
                    this.getStep().add((ExampleScenarioProcessStepComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("step")) {
                this.getStep().add((ExampleScenarioProcessStepComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("title")) {
                this.title = null;
            } else if (name.equals("description")) {
                this.description = null;
            } else if (name.equals("step")) {
                this.getStep().remove((ExampleScenarioProcessStepComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3540684: {
                    return this.addStep();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 3540684: {
                    return new String[]{"@ExampleScenario.process.step"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.alternative.title");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.alternative.description");
            }
            if (name.equals("step")) {
                return this.addStep();
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioProcessStepAlternativeComponent copy() {
            ExampleScenarioProcessStepAlternativeComponent dst = new ExampleScenarioProcessStepAlternativeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioProcessStepAlternativeComponent dst) {
            super.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.step != null) {
                dst.step = new ArrayList<ExampleScenarioProcessStepComponent>();
                for (ExampleScenarioProcessStepComponent i : this.step) {
                    dst.step.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepAlternativeComponent)) {
                return false;
            }
            ExampleScenarioProcessStepAlternativeComponent o = (ExampleScenarioProcessStepAlternativeComponent)other_;
            return ExampleScenarioProcessStepAlternativeComponent.compareDeep(this.title, o.title, true) && ExampleScenarioProcessStepAlternativeComponent.compareDeep(this.description, o.description, true) && ExampleScenarioProcessStepAlternativeComponent.compareDeep(this.step, o.step, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepAlternativeComponent)) {
                return false;
            }
            ExampleScenarioProcessStepAlternativeComponent o = (ExampleScenarioProcessStepAlternativeComponent)other_;
            return ExampleScenarioProcessStepAlternativeComponent.compareValues(this.title, o.title, true) && ExampleScenarioProcessStepAlternativeComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.title, this.description, this.step});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.process.step.alternative";
        }
    }

    @Block
    public static class ExampleScenarioProcessStepOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of action", formalDefinition="The standardized type of action (FHIR or otherwise).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/testscript-operation-codes")
        protected Coding type;
        @Child(name="title", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for step", formalDefinition="A short descriptive label the step to be used in tables or diagrams.")
        protected StringType title;
        @Child(name="initiator", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who starts the operation", formalDefinition="The system that invokes the action/transmits the data.")
        protected StringType initiator;
        @Child(name="receiver", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who receives the operation", formalDefinition="The system on which the action is invoked/receives the data.")
        protected StringType receiver;
        @Child(name="description", type={MarkdownType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human-friendly description of the operation", formalDefinition="An explanation of what the operation represents and what it does.")
        protected MarkdownType description;
        @Child(name="initiatorActive", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Initiator stays active?", formalDefinition="If false, the initiator is deactivated right after the operation.")
        protected BooleanType initiatorActive;
        @Child(name="receiverActive", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Receiver stays active?", formalDefinition="If false, the receiver is deactivated right after the operation.")
        protected BooleanType receiverActive;
        @Child(name="request", type={ExampleScenarioInstanceContainedInstanceComponent.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Instance transmitted on invocation", formalDefinition="A reference to the instance that is transmitted from requester to receiver as part of the invocation of the operation.")
        protected ExampleScenarioInstanceContainedInstanceComponent request;
        @Child(name="response", type={ExampleScenarioInstanceContainedInstanceComponent.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Instance transmitted on invocation response", formalDefinition="A reference to the instance that is transmitted from receiver to requester as part of the operation's synchronous response (if any).")
        protected ExampleScenarioInstanceContainedInstanceComponent response;
        private static final long serialVersionUID = -252586646L;

        public ExampleScenarioProcessStepOperationComponent() {
        }

        public ExampleScenarioProcessStepOperationComponent(String title) {
            this.setTitle(title);
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
            return this;
        }

        public StringType getInitiatorElement() {
            if (this.initiator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.initiator");
                }
                if (Configuration.doAutoCreate()) {
                    this.initiator = new StringType();
                }
            }
            return this.initiator;
        }

        public boolean hasInitiatorElement() {
            return this.initiator != null && !this.initiator.isEmpty();
        }

        public boolean hasInitiator() {
            return this.initiator != null && !this.initiator.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setInitiatorElement(StringType value) {
            this.initiator = value;
            return this;
        }

        public String getInitiator() {
            return this.initiator == null ? null : (String)this.initiator.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setInitiator(String value) {
            if (Utilities.noString((String)value)) {
                this.initiator = null;
            } else {
                if (this.initiator == null) {
                    this.initiator = new StringType();
                }
                this.initiator.setValue(value);
            }
            return this;
        }

        public StringType getReceiverElement() {
            if (this.receiver == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.receiver");
                }
                if (Configuration.doAutoCreate()) {
                    this.receiver = new StringType();
                }
            }
            return this.receiver;
        }

        public boolean hasReceiverElement() {
            return this.receiver != null && !this.receiver.isEmpty();
        }

        public boolean hasReceiver() {
            return this.receiver != null && !this.receiver.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setReceiverElement(StringType value) {
            this.receiver = value;
            return this;
        }

        public String getReceiver() {
            return this.receiver == null ? null : (String)this.receiver.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setReceiver(String value) {
            if (Utilities.noString((String)value)) {
                this.receiver = null;
            } else {
                if (this.receiver == null) {
                    this.receiver = new StringType();
                }
                this.receiver.setValue(value);
            }
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public BooleanType getInitiatorActiveElement() {
            if (this.initiatorActive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.initiatorActive");
                }
                if (Configuration.doAutoCreate()) {
                    this.initiatorActive = new BooleanType();
                }
            }
            return this.initiatorActive;
        }

        public boolean hasInitiatorActiveElement() {
            return this.initiatorActive != null && !this.initiatorActive.isEmpty();
        }

        public boolean hasInitiatorActive() {
            return this.initiatorActive != null && !this.initiatorActive.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setInitiatorActiveElement(BooleanType value) {
            this.initiatorActive = value;
            return this;
        }

        public boolean getInitiatorActive() {
            return this.initiatorActive == null || this.initiatorActive.isEmpty() ? false : (Boolean)this.initiatorActive.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setInitiatorActive(boolean value) {
            if (this.initiatorActive == null) {
                this.initiatorActive = new BooleanType();
            }
            this.initiatorActive.setValue((Object)value);
            return this;
        }

        public BooleanType getReceiverActiveElement() {
            if (this.receiverActive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.receiverActive");
                }
                if (Configuration.doAutoCreate()) {
                    this.receiverActive = new BooleanType();
                }
            }
            return this.receiverActive;
        }

        public boolean hasReceiverActiveElement() {
            return this.receiverActive != null && !this.receiverActive.isEmpty();
        }

        public boolean hasReceiverActive() {
            return this.receiverActive != null && !this.receiverActive.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setReceiverActiveElement(BooleanType value) {
            this.receiverActive = value;
            return this;
        }

        public boolean getReceiverActive() {
            return this.receiverActive == null || this.receiverActive.isEmpty() ? false : (Boolean)this.receiverActive.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setReceiverActive(boolean value) {
            if (this.receiverActive == null) {
                this.receiverActive = new BooleanType();
            }
            this.receiverActive.setValue((Object)value);
            return this;
        }

        public ExampleScenarioInstanceContainedInstanceComponent getRequest() {
            if (this.request == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.request");
                }
                if (Configuration.doAutoCreate()) {
                    this.request = new ExampleScenarioInstanceContainedInstanceComponent();
                }
            }
            return this.request;
        }

        public boolean hasRequest() {
            return this.request != null && !this.request.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setRequest(ExampleScenarioInstanceContainedInstanceComponent value) {
            this.request = value;
            return this;
        }

        public ExampleScenarioInstanceContainedInstanceComponent getResponse() {
            if (this.response == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.response");
                }
                if (Configuration.doAutoCreate()) {
                    this.response = new ExampleScenarioInstanceContainedInstanceComponent();
                }
            }
            return this.response;
        }

        public boolean hasResponse() {
            return this.response != null && !this.response.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setResponse(ExampleScenarioInstanceContainedInstanceComponent value) {
            this.response = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "Coding", "The standardized type of action (FHIR or otherwise).", 0, 1, this.type));
            children.add(new Property("title", "string", "A short descriptive label the step to be used in tables or diagrams.", 0, 1, this.title));
            children.add(new Property("initiator", "string", "The system that invokes the action/transmits the data.", 0, 1, this.initiator));
            children.add(new Property("receiver", "string", "The system on which the action is invoked/receives the data.", 0, 1, this.receiver));
            children.add(new Property("description", "markdown", "An explanation of what the operation represents and what it does.", 0, 1, this.description));
            children.add(new Property("initiatorActive", "boolean", "If false, the initiator is deactivated right after the operation.", 0, 1, this.initiatorActive));
            children.add(new Property("receiverActive", "boolean", "If false, the receiver is deactivated right after the operation.", 0, 1, this.receiverActive));
            children.add(new Property("request", "@ExampleScenario.instance.containedInstance", "A reference to the instance that is transmitted from requester to receiver as part of the invocation of the operation.", 0, 1, this.request));
            children.add(new Property("response", "@ExampleScenario.instance.containedInstance", "A reference to the instance that is transmitted from receiver to requester as part of the operation's synchronous response (if any).", 0, 1, this.response));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "Coding", "The standardized type of action (FHIR or otherwise).", 0, 1, this.type);
                }
                case 110371416: {
                    return new Property("title", "string", "A short descriptive label the step to be used in tables or diagrams.", 0, 1, this.title);
                }
                case -248987089: {
                    return new Property("initiator", "string", "The system that invokes the action/transmits the data.", 0, 1, this.initiator);
                }
                case -808719889: {
                    return new Property("receiver", "string", "The system on which the action is invoked/receives the data.", 0, 1, this.receiver);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "An explanation of what the operation represents and what it does.", 0, 1, this.description);
                }
                case 384339477: {
                    return new Property("initiatorActive", "boolean", "If false, the initiator is deactivated right after the operation.", 0, 1, this.initiatorActive);
                }
                case -285284907: {
                    return new Property("receiverActive", "boolean", "If false, the receiver is deactivated right after the operation.", 0, 1, this.receiverActive);
                }
                case 1095692943: {
                    return new Property("request", "@ExampleScenario.instance.containedInstance", "A reference to the instance that is transmitted from requester to receiver as part of the invocation of the operation.", 0, 1, this.request);
                }
                case -340323263: {
                    return new Property("response", "@ExampleScenario.instance.containedInstance", "A reference to the instance that is transmitted from receiver to requester as part of the operation's synchronous response (if any).", 0, 1, this.response);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.title;
                    }
                    return baseArray;
                }
                case -248987089: {
                    Base[] baseArray;
                    if (this.initiator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.initiator;
                    }
                    return baseArray;
                }
                case -808719889: {
                    Base[] baseArray;
                    if (this.receiver == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.receiver;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.description;
                    }
                    return baseArray;
                }
                case 384339477: {
                    Base[] baseArray;
                    if (this.initiatorActive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.initiatorActive;
                    }
                    return baseArray;
                }
                case -285284907: {
                    Base[] baseArray;
                    if (this.receiverActive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.receiverActive;
                    }
                    return baseArray;
                }
                case 1095692943: {
                    Base[] baseArray;
                    if (this.request == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.request;
                    }
                    return baseArray;
                }
                case -340323263: {
                    Base[] baseArray;
                    if (this.response == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.response;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCoding(value);
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -248987089: {
                    this.initiator = TypeConvertor.castToString(value);
                    return value;
                }
                case -808719889: {
                    this.receiver = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 384339477: {
                    this.initiatorActive = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -285284907: {
                    this.receiverActive = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1095692943: {
                    this.request = (ExampleScenarioInstanceContainedInstanceComponent)value;
                    return value;
                }
                case -340323263: {
                    this.response = (ExampleScenarioInstanceContainedInstanceComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCoding(value);
            } else if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("initiator")) {
                this.initiator = TypeConvertor.castToString(value);
            } else if (name.equals("receiver")) {
                this.receiver = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("initiatorActive")) {
                this.initiatorActive = TypeConvertor.castToBoolean(value);
            } else if (name.equals("receiverActive")) {
                this.receiverActive = TypeConvertor.castToBoolean(value);
            } else if (name.equals("request")) {
                this.request = (ExampleScenarioInstanceContainedInstanceComponent)value;
            } else if (name.equals("response")) {
                this.response = (ExampleScenarioInstanceContainedInstanceComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("title")) {
                this.title = null;
            } else if (name.equals("initiator")) {
                this.initiator = null;
            } else if (name.equals("receiver")) {
                this.receiver = null;
            } else if (name.equals("description")) {
                this.description = null;
            } else if (name.equals("initiatorActive")) {
                this.initiatorActive = null;
            } else if (name.equals("receiverActive")) {
                this.receiverActive = null;
            } else if (name.equals("request")) {
                this.request = (ExampleScenarioInstanceContainedInstanceComponent)value;
            } else if (name.equals("response")) {
                this.response = (ExampleScenarioInstanceContainedInstanceComponent)value;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case -248987089: {
                    return this.getInitiatorElement();
                }
                case -808719889: {
                    return this.getReceiverElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 384339477: {
                    return this.getInitiatorActiveElement();
                }
                case -285284907: {
                    return this.getReceiverActiveElement();
                }
                case 1095692943: {
                    return this.getRequest();
                }
                case -340323263: {
                    return this.getResponse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"Coding"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case -248987089: {
                    return new String[]{"string"};
                }
                case -808719889: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 384339477: {
                    return new String[]{"boolean"};
                }
                case -285284907: {
                    return new String[]{"boolean"};
                }
                case 1095692943: {
                    return new String[]{"@ExampleScenario.instance.containedInstance"};
                }
                case -340323263: {
                    return new String[]{"@ExampleScenario.instance.containedInstance"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.title");
            }
            if (name.equals("initiator")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.initiator");
            }
            if (name.equals("receiver")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.receiver");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.description");
            }
            if (name.equals("initiatorActive")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.initiatorActive");
            }
            if (name.equals("receiverActive")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.receiverActive");
            }
            if (name.equals("request")) {
                this.request = new ExampleScenarioInstanceContainedInstanceComponent();
                return this.request;
            }
            if (name.equals("response")) {
                this.response = new ExampleScenarioInstanceContainedInstanceComponent();
                return this.response;
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioProcessStepOperationComponent copy() {
            ExampleScenarioProcessStepOperationComponent dst = new ExampleScenarioProcessStepOperationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioProcessStepOperationComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.title = this.title == null ? null : this.title.copy();
            dst.initiator = this.initiator == null ? null : this.initiator.copy();
            dst.receiver = this.receiver == null ? null : this.receiver.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.initiatorActive = this.initiatorActive == null ? null : this.initiatorActive.copy();
            dst.receiverActive = this.receiverActive == null ? null : this.receiverActive.copy();
            dst.request = this.request == null ? null : this.request.copy();
            dst.response = this.response == null ? null : this.response.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepOperationComponent)) {
                return false;
            }
            ExampleScenarioProcessStepOperationComponent o = (ExampleScenarioProcessStepOperationComponent)other_;
            return ExampleScenarioProcessStepOperationComponent.compareDeep(this.type, o.type, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.title, o.title, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.initiator, o.initiator, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.receiver, o.receiver, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.description, o.description, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.initiatorActive, o.initiatorActive, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.receiverActive, o.receiverActive, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.request, o.request, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.response, o.response, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepOperationComponent)) {
                return false;
            }
            ExampleScenarioProcessStepOperationComponent o = (ExampleScenarioProcessStepOperationComponent)other_;
            return ExampleScenarioProcessStepOperationComponent.compareValues(this.title, o.title, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.initiator, o.initiator, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.receiver, o.receiver, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.description, o.description, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.initiatorActive, o.initiatorActive, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.receiverActive, o.receiverActive, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.title, this.initiator, this.receiver, this.description, this.initiatorActive, this.receiverActive, this.request, this.response});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.process.step.operation";
        }
    }

    @Block
    public static class ExampleScenarioProcessStepComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="number", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Sequential number of the step", formalDefinition="The sequential number of the step, e.g. 1.2.5.")
        protected StringType number;
        @Child(name="process", type={ExampleScenarioProcessComponent.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Step is nested process", formalDefinition="Indicates that the step is a complex sub-process with its own steps.")
        protected ExampleScenarioProcessComponent process;
        @Child(name="workflow", type={CanonicalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Step is nested workflow", formalDefinition="Indicates that the step is defined by a seaparate scenario instance.")
        protected CanonicalType workflow;
        @Child(name="operation", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Step is simple action", formalDefinition="The step represents a single operation invoked on receiver by sender.")
        protected ExampleScenarioProcessStepOperationComponent operation;
        @Child(name="alternative", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Alternate non-typical step action", formalDefinition="Indicates an alternative step that can be taken instead of the sub-process, scenario or operation.  E.g. to represent non-happy-path/exceptional/atypical circumstances.")
        protected List<ExampleScenarioProcessStepAlternativeComponent> alternative;
        @Child(name="pause", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Pause in the flow?", formalDefinition="If true, indicates that, following this step, there is a pause in the flow and the subsequent step will occur at some later time (triggered by some event).")
        protected BooleanType pause;
        private static final long serialVersionUID = 674607242L;

        public StringType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new StringType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public ExampleScenarioProcessStepComponent setNumberElement(StringType value) {
            this.number = value;
            return this;
        }

        public String getNumber() {
            return this.number == null ? null : (String)this.number.getValue();
        }

        public ExampleScenarioProcessStepComponent setNumber(String value) {
            if (Utilities.noString((String)value)) {
                this.number = null;
            } else {
                if (this.number == null) {
                    this.number = new StringType();
                }
                this.number.setValue(value);
            }
            return this;
        }

        public ExampleScenarioProcessComponent getProcess() {
            if (this.process == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepComponent.process");
                }
                if (Configuration.doAutoCreate()) {
                    this.process = new ExampleScenarioProcessComponent();
                }
            }
            return this.process;
        }

        public boolean hasProcess() {
            return this.process != null && !this.process.isEmpty();
        }

        public ExampleScenarioProcessStepComponent setProcess(ExampleScenarioProcessComponent value) {
            this.process = value;
            return this;
        }

        public CanonicalType getWorkflowElement() {
            if (this.workflow == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepComponent.workflow");
                }
                if (Configuration.doAutoCreate()) {
                    this.workflow = new CanonicalType();
                }
            }
            return this.workflow;
        }

        public boolean hasWorkflowElement() {
            return this.workflow != null && !this.workflow.isEmpty();
        }

        public boolean hasWorkflow() {
            return this.workflow != null && !this.workflow.isEmpty();
        }

        public ExampleScenarioProcessStepComponent setWorkflowElement(CanonicalType value) {
            this.workflow = value;
            return this;
        }

        public String getWorkflow() {
            return this.workflow == null ? null : (String)this.workflow.getValue();
        }

        public ExampleScenarioProcessStepComponent setWorkflow(String value) {
            if (Utilities.noString((String)value)) {
                this.workflow = null;
            } else {
                if (this.workflow == null) {
                    this.workflow = new CanonicalType();
                }
                this.workflow.setValue(value);
            }
            return this;
        }

        public ExampleScenarioProcessStepOperationComponent getOperation() {
            if (this.operation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepComponent.operation");
                }
                if (Configuration.doAutoCreate()) {
                    this.operation = new ExampleScenarioProcessStepOperationComponent();
                }
            }
            return this.operation;
        }

        public boolean hasOperation() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public ExampleScenarioProcessStepComponent setOperation(ExampleScenarioProcessStepOperationComponent value) {
            this.operation = value;
            return this;
        }

        public List<ExampleScenarioProcessStepAlternativeComponent> getAlternative() {
            if (this.alternative == null) {
                this.alternative = new ArrayList<ExampleScenarioProcessStepAlternativeComponent>();
            }
            return this.alternative;
        }

        public ExampleScenarioProcessStepComponent setAlternative(List<ExampleScenarioProcessStepAlternativeComponent> theAlternative) {
            this.alternative = theAlternative;
            return this;
        }

        public boolean hasAlternative() {
            if (this.alternative == null) {
                return false;
            }
            for (ExampleScenarioProcessStepAlternativeComponent item : this.alternative) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioProcessStepAlternativeComponent addAlternative() {
            ExampleScenarioProcessStepAlternativeComponent t = new ExampleScenarioProcessStepAlternativeComponent();
            if (this.alternative == null) {
                this.alternative = new ArrayList<ExampleScenarioProcessStepAlternativeComponent>();
            }
            this.alternative.add(t);
            return t;
        }

        public ExampleScenarioProcessStepComponent addAlternative(ExampleScenarioProcessStepAlternativeComponent t) {
            if (t == null) {
                return this;
            }
            if (this.alternative == null) {
                this.alternative = new ArrayList<ExampleScenarioProcessStepAlternativeComponent>();
            }
            this.alternative.add(t);
            return this;
        }

        public ExampleScenarioProcessStepAlternativeComponent getAlternativeFirstRep() {
            if (this.getAlternative().isEmpty()) {
                this.addAlternative();
            }
            return this.getAlternative().get(0);
        }

        public BooleanType getPauseElement() {
            if (this.pause == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepComponent.pause");
                }
                if (Configuration.doAutoCreate()) {
                    this.pause = new BooleanType();
                }
            }
            return this.pause;
        }

        public boolean hasPauseElement() {
            return this.pause != null && !this.pause.isEmpty();
        }

        public boolean hasPause() {
            return this.pause != null && !this.pause.isEmpty();
        }

        public ExampleScenarioProcessStepComponent setPauseElement(BooleanType value) {
            this.pause = value;
            return this;
        }

        public boolean getPause() {
            return this.pause == null || this.pause.isEmpty() ? false : (Boolean)this.pause.getValue();
        }

        public ExampleScenarioProcessStepComponent setPause(boolean value) {
            if (this.pause == null) {
                this.pause = new BooleanType();
            }
            this.pause.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("number", "string", "The sequential number of the step, e.g. 1.2.5.", 0, 1, this.number));
            children.add(new Property("process", "@ExampleScenario.process", "Indicates that the step is a complex sub-process with its own steps.", 0, 1, this.process));
            children.add(new Property("workflow", "canonical(ExampleScenario)", "Indicates that the step is defined by a seaparate scenario instance.", 0, 1, this.workflow));
            children.add(new Property("operation", "", "The step represents a single operation invoked on receiver by sender.", 0, 1, this.operation));
            children.add(new Property("alternative", "", "Indicates an alternative step that can be taken instead of the sub-process, scenario or operation.  E.g. to represent non-happy-path/exceptional/atypical circumstances.", 0, Integer.MAX_VALUE, this.alternative));
            children.add(new Property("pause", "boolean", "If true, indicates that, following this step, there is a pause in the flow and the subsequent step will occur at some later time (triggered by some event).", 0, 1, this.pause));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1034364087: {
                    return new Property("number", "string", "The sequential number of the step, e.g. 1.2.5.", 0, 1, this.number);
                }
                case -309518737: {
                    return new Property("process", "@ExampleScenario.process", "Indicates that the step is a complex sub-process with its own steps.", 0, 1, this.process);
                }
                case 35379135: {
                    return new Property("workflow", "canonical(ExampleScenario)", "Indicates that the step is defined by a seaparate scenario instance.", 0, 1, this.workflow);
                }
                case 1662702951: {
                    return new Property("operation", "", "The step represents a single operation invoked on receiver by sender.", 0, 1, this.operation);
                }
                case -196794451: {
                    return new Property("alternative", "", "Indicates an alternative step that can be taken instead of the sub-process, scenario or operation.  E.g. to represent non-happy-path/exceptional/atypical circumstances.", 0, Integer.MAX_VALUE, this.alternative);
                }
                case 106440182: {
                    return new Property("pause", "boolean", "If true, indicates that, following this step, there is a pause in the flow and the subsequent step will occur at some later time (triggered by some event).", 0, 1, this.pause);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.number;
                    }
                    return baseArray;
                }
                case -309518737: {
                    Base[] baseArray;
                    if (this.process == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.process;
                    }
                    return baseArray;
                }
                case 35379135: {
                    Base[] baseArray;
                    if (this.workflow == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.workflow;
                    }
                    return baseArray;
                }
                case 1662702951: {
                    Base[] baseArray;
                    if (this.operation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.operation;
                    }
                    return baseArray;
                }
                case -196794451: {
                    return this.alternative == null ? new Base[]{} : this.alternative.toArray(new Base[this.alternative.size()]);
                }
                case 106440182: {
                    Base[] baseArray;
                    if (this.pause == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.pause;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    this.number = TypeConvertor.castToString(value);
                    return value;
                }
                case -309518737: {
                    this.process = (ExampleScenarioProcessComponent)value;
                    return value;
                }
                case 35379135: {
                    this.workflow = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 1662702951: {
                    this.operation = (ExampleScenarioProcessStepOperationComponent)value;
                    return value;
                }
                case -196794451: {
                    this.getAlternative().add((ExampleScenarioProcessStepAlternativeComponent)value);
                    return value;
                }
                case 106440182: {
                    this.pause = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.number = TypeConvertor.castToString(value);
            } else if (name.equals("process")) {
                this.process = (ExampleScenarioProcessComponent)value;
            } else if (name.equals("workflow")) {
                this.workflow = TypeConvertor.castToCanonical(value);
            } else if (name.equals("operation")) {
                this.operation = (ExampleScenarioProcessStepOperationComponent)value;
            } else if (name.equals("alternative")) {
                this.getAlternative().add((ExampleScenarioProcessStepAlternativeComponent)value);
            } else if (name.equals("pause")) {
                this.pause = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.number = null;
            } else if (name.equals("process")) {
                this.process = (ExampleScenarioProcessComponent)value;
            } else if (name.equals("workflow")) {
                this.workflow = null;
            } else if (name.equals("operation")) {
                this.operation = (ExampleScenarioProcessStepOperationComponent)value;
            } else if (name.equals("alternative")) {
                this.getAlternative().remove((ExampleScenarioProcessStepAlternativeComponent)value);
            } else if (name.equals("pause")) {
                this.pause = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return this.getNumberElement();
                }
                case -309518737: {
                    return this.getProcess();
                }
                case 35379135: {
                    return this.getWorkflowElement();
                }
                case 1662702951: {
                    return this.getOperation();
                }
                case -196794451: {
                    return this.addAlternative();
                }
                case 106440182: {
                    return this.getPauseElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return new String[]{"string"};
                }
                case -309518737: {
                    return new String[]{"@ExampleScenario.process"};
                }
                case 35379135: {
                    return new String[]{"canonical"};
                }
                case 1662702951: {
                    return new String[0];
                }
                case -196794451: {
                    return new String[0];
                }
                case 106440182: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.number");
            }
            if (name.equals("process")) {
                this.process = new ExampleScenarioProcessComponent();
                return this.process;
            }
            if (name.equals("workflow")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.workflow");
            }
            if (name.equals("operation")) {
                this.operation = new ExampleScenarioProcessStepOperationComponent();
                return this.operation;
            }
            if (name.equals("alternative")) {
                return this.addAlternative();
            }
            if (name.equals("pause")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.pause");
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioProcessStepComponent copy() {
            ExampleScenarioProcessStepComponent dst = new ExampleScenarioProcessStepComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioProcessStepComponent dst) {
            super.copyValues(dst);
            dst.number = this.number == null ? null : this.number.copy();
            dst.process = this.process == null ? null : this.process.copy();
            dst.workflow = this.workflow == null ? null : this.workflow.copy();
            ExampleScenarioProcessStepOperationComponent exampleScenarioProcessStepOperationComponent = dst.operation = this.operation == null ? null : this.operation.copy();
            if (this.alternative != null) {
                dst.alternative = new ArrayList<ExampleScenarioProcessStepAlternativeComponent>();
                for (ExampleScenarioProcessStepAlternativeComponent i : this.alternative) {
                    dst.alternative.add(i.copy());
                }
            }
            dst.pause = this.pause == null ? null : this.pause.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepComponent)) {
                return false;
            }
            ExampleScenarioProcessStepComponent o = (ExampleScenarioProcessStepComponent)other_;
            return ExampleScenarioProcessStepComponent.compareDeep(this.number, o.number, true) && ExampleScenarioProcessStepComponent.compareDeep(this.process, o.process, true) && ExampleScenarioProcessStepComponent.compareDeep(this.workflow, o.workflow, true) && ExampleScenarioProcessStepComponent.compareDeep(this.operation, o.operation, true) && ExampleScenarioProcessStepComponent.compareDeep(this.alternative, o.alternative, true) && ExampleScenarioProcessStepComponent.compareDeep(this.pause, o.pause, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepComponent)) {
                return false;
            }
            ExampleScenarioProcessStepComponent o = (ExampleScenarioProcessStepComponent)other_;
            return ExampleScenarioProcessStepComponent.compareValues(this.number, o.number, true) && ExampleScenarioProcessStepComponent.compareValues(this.workflow, o.workflow, true) && ExampleScenarioProcessStepComponent.compareValues(this.pause, o.pause, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.number, this.process, this.workflow, this.operation, this.alternative, this.pause});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.process.step";
        }
    }

    @Block
    public static class ExampleScenarioInstanceContainedInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="instanceReference", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Key of contained instance", formalDefinition="A reference to the key of an instance found within this one.")
        protected StringType instanceReference;
        @Child(name="versionReference", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Key of contained instance version", formalDefinition="A reference to the key of a specific version of an instance in this instance.")
        protected StringType versionReference;
        private static final long serialVersionUID = 520704935L;

        public ExampleScenarioInstanceContainedInstanceComponent() {
        }

        public ExampleScenarioInstanceContainedInstanceComponent(String instanceReference) {
            this.setInstanceReference(instanceReference);
        }

        public StringType getInstanceReferenceElement() {
            if (this.instanceReference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceContainedInstanceComponent.instanceReference");
                }
                if (Configuration.doAutoCreate()) {
                    this.instanceReference = new StringType();
                }
            }
            return this.instanceReference;
        }

        public boolean hasInstanceReferenceElement() {
            return this.instanceReference != null && !this.instanceReference.isEmpty();
        }

        public boolean hasInstanceReference() {
            return this.instanceReference != null && !this.instanceReference.isEmpty();
        }

        public ExampleScenarioInstanceContainedInstanceComponent setInstanceReferenceElement(StringType value) {
            this.instanceReference = value;
            return this;
        }

        public String getInstanceReference() {
            return this.instanceReference == null ? null : (String)this.instanceReference.getValue();
        }

        public ExampleScenarioInstanceContainedInstanceComponent setInstanceReference(String value) {
            if (this.instanceReference == null) {
                this.instanceReference = new StringType();
            }
            this.instanceReference.setValue(value);
            return this;
        }

        public StringType getVersionReferenceElement() {
            if (this.versionReference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceContainedInstanceComponent.versionReference");
                }
                if (Configuration.doAutoCreate()) {
                    this.versionReference = new StringType();
                }
            }
            return this.versionReference;
        }

        public boolean hasVersionReferenceElement() {
            return this.versionReference != null && !this.versionReference.isEmpty();
        }

        public boolean hasVersionReference() {
            return this.versionReference != null && !this.versionReference.isEmpty();
        }

        public ExampleScenarioInstanceContainedInstanceComponent setVersionReferenceElement(StringType value) {
            this.versionReference = value;
            return this;
        }

        public String getVersionReference() {
            return this.versionReference == null ? null : (String)this.versionReference.getValue();
        }

        public ExampleScenarioInstanceContainedInstanceComponent setVersionReference(String value) {
            if (Utilities.noString((String)value)) {
                this.versionReference = null;
            } else {
                if (this.versionReference == null) {
                    this.versionReference = new StringType();
                }
                this.versionReference.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("instanceReference", "string", "A reference to the key of an instance found within this one.", 0, 1, this.instanceReference));
            children.add(new Property("versionReference", "string", "A reference to the key of a specific version of an instance in this instance.", 0, 1, this.versionReference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1675877834: {
                    return new Property("instanceReference", "string", "A reference to the key of an instance found within this one.", 0, 1, this.instanceReference);
                }
                case 357512531: {
                    return new Property("versionReference", "string", "A reference to the key of a specific version of an instance in this instance.", 0, 1, this.versionReference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1675877834: {
                    Base[] baseArray;
                    if (this.instanceReference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.instanceReference;
                    }
                    return baseArray;
                }
                case 357512531: {
                    Base[] baseArray;
                    if (this.versionReference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.versionReference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1675877834: {
                    this.instanceReference = TypeConvertor.castToString(value);
                    return value;
                }
                case 357512531: {
                    this.versionReference = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("instanceReference")) {
                this.instanceReference = TypeConvertor.castToString(value);
            } else if (name.equals("versionReference")) {
                this.versionReference = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("instanceReference")) {
                this.instanceReference = null;
            } else if (name.equals("versionReference")) {
                this.versionReference = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1675877834: {
                    return this.getInstanceReferenceElement();
                }
                case 357512531: {
                    return this.getVersionReferenceElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1675877834: {
                    return new String[]{"string"};
                }
                case 357512531: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("instanceReference")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.containedInstance.instanceReference");
            }
            if (name.equals("versionReference")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.containedInstance.versionReference");
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioInstanceContainedInstanceComponent copy() {
            ExampleScenarioInstanceContainedInstanceComponent dst = new ExampleScenarioInstanceContainedInstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioInstanceContainedInstanceComponent dst) {
            super.copyValues(dst);
            dst.instanceReference = this.instanceReference == null ? null : this.instanceReference.copy();
            dst.versionReference = this.versionReference == null ? null : this.versionReference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceContainedInstanceComponent)) {
                return false;
            }
            ExampleScenarioInstanceContainedInstanceComponent o = (ExampleScenarioInstanceContainedInstanceComponent)other_;
            return ExampleScenarioInstanceContainedInstanceComponent.compareDeep(this.instanceReference, o.instanceReference, true) && ExampleScenarioInstanceContainedInstanceComponent.compareDeep(this.versionReference, o.versionReference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceContainedInstanceComponent)) {
                return false;
            }
            ExampleScenarioInstanceContainedInstanceComponent o = (ExampleScenarioInstanceContainedInstanceComponent)other_;
            return ExampleScenarioInstanceContainedInstanceComponent.compareValues(this.instanceReference, o.instanceReference, true) && ExampleScenarioInstanceContainedInstanceComponent.compareValues(this.versionReference, o.versionReference, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.instanceReference, this.versionReference});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.instance.containedInstance";
        }
    }

    @Block
    public static class ExampleScenarioInstanceVersionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="key", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="ID or acronym of the version", formalDefinition="A unique string within the instance that is used to reference the version of the instance.")
        protected StringType key;
        @Child(name="title", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for instance version", formalDefinition="A short descriptive label the version to be used in tables or diagrams.")
        protected StringType title;
        @Child(name="description", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Details about version", formalDefinition="An explanation of what this specific version of the instance contains and represents.")
        protected MarkdownType description;
        @Child(name="content", type={Reference.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Example instance version data", formalDefinition="Points to an instance (typically an example) that shows the data that would flow at this point in the scenario.")
        protected Reference content;
        private static final long serialVersionUID = -1218548928L;

        public ExampleScenarioInstanceVersionComponent() {
        }

        public ExampleScenarioInstanceVersionComponent(String key, String title) {
            this.setKey(key);
            this.setTitle(title);
        }

        public StringType getKeyElement() {
            if (this.key == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceVersionComponent.key");
                }
                if (Configuration.doAutoCreate()) {
                    this.key = new StringType();
                }
            }
            return this.key;
        }

        public boolean hasKeyElement() {
            return this.key != null && !this.key.isEmpty();
        }

        public boolean hasKey() {
            return this.key != null && !this.key.isEmpty();
        }

        public ExampleScenarioInstanceVersionComponent setKeyElement(StringType value) {
            this.key = value;
            return this;
        }

        public String getKey() {
            return this.key == null ? null : (String)this.key.getValue();
        }

        public ExampleScenarioInstanceVersionComponent setKey(String value) {
            if (this.key == null) {
                this.key = new StringType();
            }
            this.key.setValue(value);
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceVersionComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ExampleScenarioInstanceVersionComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ExampleScenarioInstanceVersionComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceVersionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioInstanceVersionComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioInstanceVersionComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Reference getContent() {
            if (this.content == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceVersionComponent.content");
                }
                if (Configuration.doAutoCreate()) {
                    this.content = new Reference();
                }
            }
            return this.content;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public ExampleScenarioInstanceVersionComponent setContent(Reference value) {
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("key", "string", "A unique string within the instance that is used to reference the version of the instance.", 0, 1, this.key));
            children.add(new Property("title", "string", "A short descriptive label the version to be used in tables or diagrams.", 0, 1, this.title));
            children.add(new Property("description", "markdown", "An explanation of what this specific version of the instance contains and represents.", 0, 1, this.description));
            children.add(new Property("content", "Reference", "Points to an instance (typically an example) that shows the data that would flow at this point in the scenario.", 0, 1, this.content));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 106079: {
                    return new Property("key", "string", "A unique string within the instance that is used to reference the version of the instance.", 0, 1, this.key);
                }
                case 110371416: {
                    return new Property("title", "string", "A short descriptive label the version to be used in tables or diagrams.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "An explanation of what this specific version of the instance contains and represents.", 0, 1, this.description);
                }
                case 951530617: {
                    return new Property("content", "Reference", "Points to an instance (typically an example) that shows the data that would flow at this point in the scenario.", 0, 1, this.content);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 106079: {
                    Base[] baseArray;
                    if (this.key == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.key;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case 951530617: {
                    Base[] baseArray;
                    if (this.content == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.content;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 106079: {
                    this.key = TypeConvertor.castToString(value);
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 951530617: {
                    this.content = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("key")) {
                this.key = TypeConvertor.castToString(value);
            } else if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("content")) {
                this.content = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("key")) {
                this.key = null;
            } else if (name.equals("title")) {
                this.title = null;
            } else if (name.equals("description")) {
                this.description = null;
            } else if (name.equals("content")) {
                this.content = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106079: {
                    return this.getKeyElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 951530617: {
                    return this.getContent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106079: {
                    return new String[]{"string"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 951530617: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("key")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.version.key");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.version.title");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.version.description");
            }
            if (name.equals("content")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioInstanceVersionComponent copy() {
            ExampleScenarioInstanceVersionComponent dst = new ExampleScenarioInstanceVersionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioInstanceVersionComponent dst) {
            super.copyValues(dst);
            dst.key = this.key == null ? null : this.key.copy();
            dst.title = this.title == null ? null : this.title.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.content = this.content == null ? null : this.content.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceVersionComponent)) {
                return false;
            }
            ExampleScenarioInstanceVersionComponent o = (ExampleScenarioInstanceVersionComponent)other_;
            return ExampleScenarioInstanceVersionComponent.compareDeep(this.key, o.key, true) && ExampleScenarioInstanceVersionComponent.compareDeep(this.title, o.title, true) && ExampleScenarioInstanceVersionComponent.compareDeep(this.description, o.description, true) && ExampleScenarioInstanceVersionComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceVersionComponent)) {
                return false;
            }
            ExampleScenarioInstanceVersionComponent o = (ExampleScenarioInstanceVersionComponent)other_;
            return ExampleScenarioInstanceVersionComponent.compareValues(this.key, o.key, true) && ExampleScenarioInstanceVersionComponent.compareValues(this.title, o.title, true) && ExampleScenarioInstanceVersionComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.key, this.title, this.description, this.content});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.instance.version";
        }
    }
}

