/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Goal", profile="http://hl7.org/fhir/StructureDefinition/Goal")
public class Goal
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External Ids for this goal", formalDefinition="Business identifiers assigned to this goal by the performer or other systems which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="lifecycleStatus", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposed | planned | accepted | active | on-hold | completed | cancelled | entered-in-error | rejected", formalDefinition="The state of the goal throughout its lifecycle.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/goal-status")
    protected Enumeration<GoalLifecycleStatus> lifecycleStatus;
    @Child(name="achievementStatus", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="in-progress | improving | worsening | no-change | achieved | sustaining | not-achieved | no-progress | not-attainable", formalDefinition="Describes the progression, or lack thereof, towards the goal against the target.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/goal-achievement")
    protected CodeableConcept achievementStatus;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="E.g. Treatment, dietary, behavioral, etc", formalDefinition="Indicates a category the goal falls within.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/goal-category")
    protected List<CodeableConcept> category;
    @Child(name="continuous", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="After meeting the goal, ongoing activity is needed to sustain the goal objective", formalDefinition="After meeting the goal, ongoing activity is needed to sustain the goal objective.")
    protected BooleanType continuous;
    @Child(name="priority", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="high-priority | medium-priority | low-priority", formalDefinition="Identifies the mutually agreed level of importance associated with reaching/sustaining the goal.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/goal-priority")
    protected CodeableConcept priority;
    @Child(name="description", type={CodeableConcept.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code or text describing goal", formalDefinition="Human-readable and/or coded description of a specific desired objective of care, such as \"control blood pressure\" or \"negotiate an obstacle course\" or \"dance with child at wedding\".")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    protected CodeableConcept description;
    @Child(name="subject", type={Patient.class, Group.class, Organization.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who this goal is intended for", formalDefinition="Identifies the patient, group or organization for whom the goal is being established.")
    protected Reference subject;
    @Child(name="start", type={DateType.class, CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When goal pursuit begins", formalDefinition="The date or event after which the goal should begin being pursued.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/goal-start-event")
    protected DataType start;
    @Child(name="target", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Target outcome for the goal", formalDefinition="Indicates what should be done by when.")
    protected List<GoalTargetComponent> target;
    @Child(name="statusDate", type={DateType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When goal status took effect", formalDefinition="Identifies when the current status.  I.e. When initially created, when achieved, when cancelled, etc.")
    protected DateType statusDate;
    @Child(name="statusReason", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for current status", formalDefinition="Captures the reason for the current status.")
    protected StringType statusReason;
    @Child(name="source", type={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, CareTeam.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who's responsible for creating Goal?", formalDefinition="Indicates whose goal this is - patient goal, practitioner goal, etc.")
    protected Reference source;
    @Child(name="addresses", type={Condition.class, Observation.class, MedicationStatement.class, MedicationRequest.class, NutritionOrder.class, ServiceRequest.class, RiskAssessment.class, Procedure.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Issues addressed by this goal", formalDefinition="The identified conditions and other health record elements that are intended to be addressed by the goal.")
    protected List<Reference> addresses;
    @Child(name="note", type={Annotation.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments about the goal", formalDefinition="Any comments related to the goal.")
    protected List<Annotation> note;
    @Child(name="outcome", type={CodeableReference.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What result was achieved regarding the goal?", formalDefinition="Identifies the change (or lack of change) at the point when the status of the goal is assessed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    protected List<CodeableReference> outcome;
    private static final long serialVersionUID = -884300976L;
    @SearchParamDefinition(name="achievement-status", path="Goal.achievementStatus", description="in-progress | improving | worsening | no-change | achieved | sustaining | not-achieved | no-progress | not-attainable", type="token")
    public static final String SP_ACHIEVEMENT_STATUS = "achievement-status";
    public static final TokenClientParam ACHIEVEMENT_STATUS = new TokenClientParam("achievement-status");
    @SearchParamDefinition(name="addresses", path="Goal.addresses", description="Issues addressed by this goal", type="reference", target={Condition.class, MedicationRequest.class, MedicationStatement.class, NutritionOrder.class, Observation.class, Procedure.class, RiskAssessment.class, ServiceRequest.class})
    public static final String SP_ADDRESSES = "addresses";
    public static final ReferenceClientParam ADDRESSES = new ReferenceClientParam("addresses");
    public static final Include INCLUDE_ADDRESSES = new Include("Goal:addresses").toLocked();
    @SearchParamDefinition(name="category", path="Goal.category", description="E.g. Treatment, dietary, behavioral, etc.", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="description", path="Goal.description", description="Code or text describing goal", type="token")
    public static final String SP_DESCRIPTION = "description";
    public static final TokenClientParam DESCRIPTION = new TokenClientParam("description");
    @SearchParamDefinition(name="lifecycle-status", path="Goal.lifecycleStatus", description="proposed | planned | accepted | active | on-hold | completed | cancelled | entered-in-error | rejected", type="token")
    public static final String SP_LIFECYCLE_STATUS = "lifecycle-status";
    public static final TokenClientParam LIFECYCLE_STATUS = new TokenClientParam("lifecycle-status");
    @SearchParamDefinition(name="start-date", path="(Goal.start.ofType(date))", description="When goal pursuit begins", type="date")
    public static final String SP_START_DATE = "start-date";
    public static final DateClientParam START_DATE = new DateClientParam("start-date");
    @SearchParamDefinition(name="subject", path="Goal.subject", description="Who this goal is intended for", type="reference", target={Group.class, Organization.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Goal:subject").toLocked();
    @SearchParamDefinition(name="target-date", path="(Goal.target.due.ofType(date))", description="Reach goal on or before", type="date")
    public static final String SP_TARGET_DATE = "target-date";
    public static final DateClientParam TARGET_DATE = new DateClientParam("target-date");
    @SearchParamDefinition(name="target-measure", path="Goal.target.measure", description="The parameter whose value is being tracked", type="token")
    public static final String SP_TARGET_MEASURE = "target-measure";
    public static final TokenClientParam TARGET_MEASURE = new TokenClientParam("target-measure");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Goal:patient").toLocked();

    public Goal() {
    }

    public Goal(GoalLifecycleStatus lifecycleStatus, CodeableConcept description, Reference subject) {
        this.setLifecycleStatus(lifecycleStatus);
        this.setDescription(description);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Goal setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Goal addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<GoalLifecycleStatus> getLifecycleStatusElement() {
        if (this.lifecycleStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.lifecycleStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.lifecycleStatus = new Enumeration<GoalLifecycleStatus>(new GoalLifecycleStatusEnumFactory());
            }
        }
        return this.lifecycleStatus;
    }

    public boolean hasLifecycleStatusElement() {
        return this.lifecycleStatus != null && !this.lifecycleStatus.isEmpty();
    }

    public boolean hasLifecycleStatus() {
        return this.lifecycleStatus != null && !this.lifecycleStatus.isEmpty();
    }

    public Goal setLifecycleStatusElement(Enumeration<GoalLifecycleStatus> value) {
        this.lifecycleStatus = value;
        return this;
    }

    public GoalLifecycleStatus getLifecycleStatus() {
        return this.lifecycleStatus == null ? null : (GoalLifecycleStatus)((Object)this.lifecycleStatus.getValue());
    }

    public Goal setLifecycleStatus(GoalLifecycleStatus value) {
        if (this.lifecycleStatus == null) {
            this.lifecycleStatus = new Enumeration<GoalLifecycleStatus>(new GoalLifecycleStatusEnumFactory());
        }
        this.lifecycleStatus.setValue((Object)value);
        return this;
    }

    public CodeableConcept getAchievementStatus() {
        if (this.achievementStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.achievementStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.achievementStatus = new CodeableConcept();
            }
        }
        return this.achievementStatus;
    }

    public boolean hasAchievementStatus() {
        return this.achievementStatus != null && !this.achievementStatus.isEmpty();
    }

    public Goal setAchievementStatus(CodeableConcept value) {
        this.achievementStatus = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Goal setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Goal addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public BooleanType getContinuousElement() {
        if (this.continuous == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.continuous");
            }
            if (Configuration.doAutoCreate()) {
                this.continuous = new BooleanType();
            }
        }
        return this.continuous;
    }

    public boolean hasContinuousElement() {
        return this.continuous != null && !this.continuous.isEmpty();
    }

    public boolean hasContinuous() {
        return this.continuous != null && !this.continuous.isEmpty();
    }

    public Goal setContinuousElement(BooleanType value) {
        this.continuous = value;
        return this;
    }

    public boolean getContinuous() {
        return this.continuous == null || this.continuous.isEmpty() ? false : (Boolean)this.continuous.getValue();
    }

    public Goal setContinuous(boolean value) {
        if (this.continuous == null) {
            this.continuous = new BooleanType();
        }
        this.continuous.setValue((Object)value);
        return this;
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Goal setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public CodeableConcept getDescription() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new CodeableConcept();
            }
        }
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Goal setDescription(CodeableConcept value) {
        this.description = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Goal setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public DataType getStart() {
        return this.start;
    }

    public DateType getStartDateType() throws FHIRException {
        if (this.start == null) {
            this.start = new DateType();
        }
        if (!(this.start instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.start.getClass().getName() + " was encountered");
        }
        return (DateType)this.start;
    }

    public boolean hasStartDateType() {
        return this.start instanceof DateType;
    }

    public CodeableConcept getStartCodeableConcept() throws FHIRException {
        if (this.start == null) {
            this.start = new CodeableConcept();
        }
        if (!(this.start instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.start.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.start;
    }

    public boolean hasStartCodeableConcept() {
        return this.start instanceof CodeableConcept;
    }

    public boolean hasStart() {
        return this.start != null && !this.start.isEmpty();
    }

    public Goal setStart(DataType value) {
        if (value != null && !(value instanceof DateType) && !(value instanceof CodeableConcept)) {
            throw new FHIRException("Not the right type for Goal.start[x]: " + value.fhirType());
        }
        this.start = value;
        return this;
    }

    public List<GoalTargetComponent> getTarget() {
        if (this.target == null) {
            this.target = new ArrayList<GoalTargetComponent>();
        }
        return this.target;
    }

    public Goal setTarget(List<GoalTargetComponent> theTarget) {
        this.target = theTarget;
        return this;
    }

    public boolean hasTarget() {
        if (this.target == null) {
            return false;
        }
        for (GoalTargetComponent item : this.target) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public GoalTargetComponent addTarget() {
        GoalTargetComponent t = new GoalTargetComponent();
        if (this.target == null) {
            this.target = new ArrayList<GoalTargetComponent>();
        }
        this.target.add(t);
        return t;
    }

    public Goal addTarget(GoalTargetComponent t) {
        if (t == null) {
            return this;
        }
        if (this.target == null) {
            this.target = new ArrayList<GoalTargetComponent>();
        }
        this.target.add(t);
        return this;
    }

    public GoalTargetComponent getTargetFirstRep() {
        if (this.getTarget().isEmpty()) {
            this.addTarget();
        }
        return this.getTarget().get(0);
    }

    public DateType getStatusDateElement() {
        if (this.statusDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.statusDate");
            }
            if (Configuration.doAutoCreate()) {
                this.statusDate = new DateType();
            }
        }
        return this.statusDate;
    }

    public boolean hasStatusDateElement() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public boolean hasStatusDate() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public Goal setStatusDateElement(DateType value) {
        this.statusDate = value;
        return this;
    }

    public Date getStatusDate() {
        return this.statusDate == null ? null : (Date)this.statusDate.getValue();
    }

    public Goal setStatusDate(Date value) {
        if (value == null) {
            this.statusDate = null;
        } else {
            if (this.statusDate == null) {
                this.statusDate = new DateType();
            }
            this.statusDate.setValue(value);
        }
        return this;
    }

    public StringType getStatusReasonElement() {
        if (this.statusReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.statusReason");
            }
            if (Configuration.doAutoCreate()) {
                this.statusReason = new StringType();
            }
        }
        return this.statusReason;
    }

    public boolean hasStatusReasonElement() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public boolean hasStatusReason() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public Goal setStatusReasonElement(StringType value) {
        this.statusReason = value;
        return this;
    }

    public String getStatusReason() {
        return this.statusReason == null ? null : (String)this.statusReason.getValue();
    }

    public Goal setStatusReason(String value) {
        if (Utilities.noString((String)value)) {
            this.statusReason = null;
        } else {
            if (this.statusReason == null) {
                this.statusReason = new StringType();
            }
            this.statusReason.setValue(value);
        }
        return this;
    }

    public Reference getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new Reference();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public Goal setSource(Reference value) {
        this.source = value;
        return this;
    }

    public List<Reference> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        return this.addresses;
    }

    public Goal setAddresses(List<Reference> theAddresses) {
        this.addresses = theAddresses;
        return this;
    }

    public boolean hasAddresses() {
        if (this.addresses == null) {
            return false;
        }
        for (Reference item : this.addresses) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAddresses() {
        Reference t = new Reference();
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        this.addresses.add(t);
        return t;
    }

    public Goal addAddresses(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        this.addresses.add(t);
        return this;
    }

    public Reference getAddressesFirstRep() {
        if (this.getAddresses().isEmpty()) {
            this.addAddresses();
        }
        return this.getAddresses().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Goal setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Goal addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<CodeableReference> getOutcome() {
        if (this.outcome == null) {
            this.outcome = new ArrayList<CodeableReference>();
        }
        return this.outcome;
    }

    public Goal setOutcome(List<CodeableReference> theOutcome) {
        this.outcome = theOutcome;
        return this;
    }

    public boolean hasOutcome() {
        if (this.outcome == null) {
            return false;
        }
        for (CodeableReference item : this.outcome) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addOutcome() {
        CodeableReference t = new CodeableReference();
        if (this.outcome == null) {
            this.outcome = new ArrayList<CodeableReference>();
        }
        this.outcome.add(t);
        return t;
    }

    public Goal addOutcome(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.outcome == null) {
            this.outcome = new ArrayList<CodeableReference>();
        }
        this.outcome.add(t);
        return this;
    }

    public CodeableReference getOutcomeFirstRep() {
        if (this.getOutcome().isEmpty()) {
            this.addOutcome();
        }
        return this.getOutcome().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this goal by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("lifecycleStatus", "code", "The state of the goal throughout its lifecycle.", 0, 1, this.lifecycleStatus));
        children.add(new Property("achievementStatus", "CodeableConcept", "Describes the progression, or lack thereof, towards the goal against the target.", 0, 1, this.achievementStatus));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Indicates a category the goal falls within.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property("continuous", "boolean", "After meeting the goal, ongoing activity is needed to sustain the goal objective.", 0, 1, this.continuous));
        children.add(new Property("priority", "CodeableConcept", "Identifies the mutually agreed level of importance associated with reaching/sustaining the goal.", 0, 1, this.priority));
        children.add(new Property(SP_DESCRIPTION, "CodeableConcept", "Human-readable and/or coded description of a specific desired objective of care, such as \"control blood pressure\" or \"negotiate an obstacle course\" or \"dance with child at wedding\".", 0, 1, this.description));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Organization)", "Identifies the patient, group or organization for whom the goal is being established.", 0, 1, this.subject));
        children.add(new Property("start[x]", "date|CodeableConcept", "The date or event after which the goal should begin being pursued.", 0, 1, this.start));
        children.add(new Property("target", "", "Indicates what should be done by when.", 0, Integer.MAX_VALUE, this.target));
        children.add(new Property("statusDate", "date", "Identifies when the current status.  I.e. When initially created, when achieved, when cancelled, etc.", 0, 1, this.statusDate));
        children.add(new Property("statusReason", "string", "Captures the reason for the current status.", 0, 1, this.statusReason));
        children.add(new Property("source", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|CareTeam)", "Indicates whose goal this is - patient goal, practitioner goal, etc.", 0, 1, this.source));
        children.add(new Property(SP_ADDRESSES, "Reference(Condition|Observation|MedicationStatement|MedicationRequest|NutritionOrder|ServiceRequest|RiskAssessment|Procedure)", "The identified conditions and other health record elements that are intended to be addressed by the goal.", 0, Integer.MAX_VALUE, this.addresses));
        children.add(new Property("note", "Annotation", "Any comments related to the goal.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("outcome", "CodeableReference(Observation)", "Identifies the change (or lack of change) at the point when the status of the goal is assessed.", 0, Integer.MAX_VALUE, this.outcome));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this goal by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 1165552636: {
                return new Property("lifecycleStatus", "code", "The state of the goal throughout its lifecycle.", 0, 1, this.lifecycleStatus);
            }
            case 104524801: {
                return new Property("achievementStatus", "CodeableConcept", "Describes the progression, or lack thereof, towards the goal against the target.", 0, 1, this.achievementStatus);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Indicates a category the goal falls within.", 0, Integer.MAX_VALUE, this.category);
            }
            case 379114255: {
                return new Property("continuous", "boolean", "After meeting the goal, ongoing activity is needed to sustain the goal objective.", 0, 1, this.continuous);
            }
            case -1165461084: {
                return new Property("priority", "CodeableConcept", "Identifies the mutually agreed level of importance associated with reaching/sustaining the goal.", 0, 1, this.priority);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "CodeableConcept", "Human-readable and/or coded description of a specific desired objective of care, such as \"control blood pressure\" or \"negotiate an obstacle course\" or \"dance with child at wedding\".", 0, 1, this.description);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Organization)", "Identifies the patient, group or organization for whom the goal is being established.", 0, 1, this.subject);
            }
            case 1316793566: {
                return new Property("start[x]", "date|CodeableConcept", "The date or event after which the goal should begin being pursued.", 0, 1, this.start);
            }
            case 109757538: {
                return new Property("start[x]", "date|CodeableConcept", "The date or event after which the goal should begin being pursued.", 0, 1, this.start);
            }
            case -2129778896: {
                return new Property("start[x]", "date", "The date or event after which the goal should begin being pursued.", 0, 1, this.start);
            }
            case -1758833953: {
                return new Property("start[x]", "CodeableConcept", "The date or event after which the goal should begin being pursued.", 0, 1, this.start);
            }
            case -880905839: {
                return new Property("target", "", "Indicates what should be done by when.", 0, Integer.MAX_VALUE, this.target);
            }
            case 247524032: {
                return new Property("statusDate", "date", "Identifies when the current status.  I.e. When initially created, when achieved, when cancelled, etc.", 0, 1, this.statusDate);
            }
            case 2051346646: {
                return new Property("statusReason", "string", "Captures the reason for the current status.", 0, 1, this.statusReason);
            }
            case -896505829: {
                return new Property("source", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|CareTeam)", "Indicates whose goal this is - patient goal, practitioner goal, etc.", 0, 1, this.source);
            }
            case 874544034: {
                return new Property(SP_ADDRESSES, "Reference(Condition|Observation|MedicationStatement|MedicationRequest|NutritionOrder|ServiceRequest|RiskAssessment|Procedure)", "The identified conditions and other health record elements that are intended to be addressed by the goal.", 0, Integer.MAX_VALUE, this.addresses);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Any comments related to the goal.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1106507950: {
                return new Property("outcome", "CodeableReference(Observation)", "Identifies the change (or lack of change) at the point when the status of the goal is assessed.", 0, Integer.MAX_VALUE, this.outcome);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 1165552636: {
                Base[] baseArray;
                if (this.lifecycleStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.lifecycleStatus;
                }
                return baseArray;
            }
            case 104524801: {
                Base[] baseArray;
                if (this.achievementStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.achievementStatus;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 379114255: {
                Base[] baseArray;
                if (this.continuous == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.continuous;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.priority;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.description;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.subject;
                }
                return baseArray;
            }
            case 109757538: {
                Base[] baseArray;
                if (this.start == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.start;
                }
                return baseArray;
            }
            case -880905839: {
                return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
            }
            case 247524032: {
                Base[] baseArray;
                if (this.statusDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.statusDate;
                }
                return baseArray;
            }
            case 2051346646: {
                Base[] baseArray;
                if (this.statusReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.statusReason;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.source;
                }
                return baseArray;
            }
            case 874544034: {
                return this.addresses == null ? new Base[]{} : this.addresses.toArray(new Base[this.addresses.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1106507950: {
                return this.outcome == null ? new Base[]{} : this.outcome.toArray(new Base[this.outcome.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 1165552636: {
                value = new GoalLifecycleStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.lifecycleStatus = value;
                return value;
            }
            case 104524801: {
                this.achievementStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 379114255: {
                this.continuous = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1165461084: {
                this.priority = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 109757538: {
                this.start = TypeConvertor.castToType(value);
                return value;
            }
            case -880905839: {
                this.getTarget().add((GoalTargetComponent)((Object)value));
                return value;
            }
            case 247524032: {
                this.statusDate = TypeConvertor.castToDate(value);
                return value;
            }
            case 2051346646: {
                this.statusReason = TypeConvertor.castToString(value);
                return value;
            }
            case -896505829: {
                this.source = TypeConvertor.castToReference(value);
                return value;
            }
            case 874544034: {
                this.getAddresses().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -1106507950: {
                this.getOutcome().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("lifecycleStatus")) {
            value = new GoalLifecycleStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.lifecycleStatus = value;
        } else if (name.equals("achievementStatus")) {
            this.achievementStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("continuous")) {
            this.continuous = TypeConvertor.castToBoolean(value);
        } else if (name.equals("priority")) {
            this.priority = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("start[x]")) {
            this.start = TypeConvertor.castToType(value);
        } else if (name.equals("target")) {
            this.getTarget().add((GoalTargetComponent)((Object)value));
        } else if (name.equals("statusDate")) {
            this.statusDate = TypeConvertor.castToDate(value);
        } else if (name.equals("statusReason")) {
            this.statusReason = TypeConvertor.castToString(value);
        } else if (name.equals("source")) {
            this.source = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ADDRESSES)) {
            this.getAddresses().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("outcome")) {
            this.getOutcome().add(TypeConvertor.castToCodeableReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("lifecycleStatus")) {
            value = new GoalLifecycleStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.lifecycleStatus = value;
        } else if (name.equals("achievementStatus")) {
            this.achievementStatus = null;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().remove(value);
        } else if (name.equals("continuous")) {
            this.continuous = null;
        } else if (name.equals("priority")) {
            this.priority = null;
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = null;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals("start[x]")) {
            this.start = null;
        } else if (name.equals("target")) {
            this.getTarget().remove((GoalTargetComponent)((Object)value));
        } else if (name.equals("statusDate")) {
            this.statusDate = null;
        } else if (name.equals("statusReason")) {
            this.statusReason = null;
        } else if (name.equals("source")) {
            this.source = null;
        } else if (name.equals(SP_ADDRESSES)) {
            this.getAddresses().remove(value);
        } else if (name.equals("note")) {
            this.getNote().remove(value);
        } else if (name.equals("outcome")) {
            this.getOutcome().remove(value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 1165552636: {
                return this.getLifecycleStatusElement();
            }
            case 104524801: {
                return this.getAchievementStatus();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 379114255: {
                return this.getContinuousElement();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case -1724546052: {
                return this.getDescription();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1316793566: {
                return this.getStart();
            }
            case 109757538: {
                return this.getStart();
            }
            case -880905839: {
                return this.addTarget();
            }
            case 247524032: {
                return this.getStatusDateElement();
            }
            case 2051346646: {
                return this.getStatusReasonElement();
            }
            case -896505829: {
                return this.getSource();
            }
            case 874544034: {
                return this.addAddresses();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1106507950: {
                return this.addOutcome();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 1165552636: {
                return new String[]{"code"};
            }
            case 104524801: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 379114255: {
                return new String[]{"boolean"};
            }
            case -1165461084: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 109757538: {
                return new String[]{"date", "CodeableConcept"};
            }
            case -880905839: {
                return new String[0];
            }
            case 247524032: {
                return new String[]{"date"};
            }
            case 2051346646: {
                return new String[]{"string"};
            }
            case -896505829: {
                return new String[]{"Reference"};
            }
            case 874544034: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1106507950: {
                return new String[]{"CodeableReference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("lifecycleStatus")) {
            throw new FHIRException("Cannot call addChild on a singleton property Goal.lifecycleStatus");
        }
        if (name.equals("achievementStatus")) {
            this.achievementStatus = new CodeableConcept();
            return this.achievementStatus;
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals("continuous")) {
            throw new FHIRException("Cannot call addChild on a singleton property Goal.continuous");
        }
        if (name.equals("priority")) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals(SP_DESCRIPTION)) {
            this.description = new CodeableConcept();
            return this.description;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("startDate")) {
            this.start = new DateType();
            return this.start;
        }
        if (name.equals("startCodeableConcept")) {
            this.start = new CodeableConcept();
            return this.start;
        }
        if (name.equals("target")) {
            return this.addTarget();
        }
        if (name.equals("statusDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Goal.statusDate");
        }
        if (name.equals("statusReason")) {
            throw new FHIRException("Cannot call addChild on a singleton property Goal.statusReason");
        }
        if (name.equals("source")) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals(SP_ADDRESSES)) {
            return this.addAddresses();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("outcome")) {
            return this.addOutcome();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Goal";
    }

    @Override
    public Goal copy() {
        Goal dst = new Goal();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Goal dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.lifecycleStatus = this.lifecycleStatus == null ? null : this.lifecycleStatus.copy();
        CodeableConcept codeableConcept = dst.achievementStatus = this.achievementStatus == null ? null : this.achievementStatus.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.category) {
                dst.category.add(codeableConcept2.copy());
            }
        }
        dst.continuous = this.continuous == null ? null : this.continuous.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        DataType dataType = dst.start = this.start == null ? null : this.start.copy();
        if (this.target != null) {
            dst.target = new ArrayList<GoalTargetComponent>();
            for (GoalTargetComponent goalTargetComponent : this.target) {
                dst.target.add(goalTargetComponent.copy());
            }
        }
        dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
        dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
        Reference reference = dst.source = this.source == null ? null : this.source.copy();
        if (this.addresses != null) {
            dst.addresses = new ArrayList<Reference>();
            for (Reference reference2 : this.addresses) {
                dst.addresses.add(reference2.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.outcome != null) {
            dst.outcome = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.outcome) {
                dst.outcome.add(codeableReference.copy());
            }
        }
    }

    protected Goal typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Goal)) {
            return false;
        }
        Goal o = (Goal)other_;
        return Goal.compareDeep(this.identifier, o.identifier, true) && Goal.compareDeep(this.lifecycleStatus, o.lifecycleStatus, true) && Goal.compareDeep(this.achievementStatus, o.achievementStatus, true) && Goal.compareDeep(this.category, o.category, true) && Goal.compareDeep(this.continuous, o.continuous, true) && Goal.compareDeep(this.priority, o.priority, true) && Goal.compareDeep(this.description, o.description, true) && Goal.compareDeep(this.subject, o.subject, true) && Goal.compareDeep(this.start, o.start, true) && Goal.compareDeep(this.target, o.target, true) && Goal.compareDeep(this.statusDate, o.statusDate, true) && Goal.compareDeep(this.statusReason, o.statusReason, true) && Goal.compareDeep(this.source, o.source, true) && Goal.compareDeep(this.addresses, o.addresses, true) && Goal.compareDeep(this.note, o.note, true) && Goal.compareDeep(this.outcome, o.outcome, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Goal)) {
            return false;
        }
        Goal o = (Goal)other_;
        return Goal.compareValues(this.lifecycleStatus, o.lifecycleStatus, true) && Goal.compareValues(this.continuous, o.continuous, true) && Goal.compareValues(this.statusDate, o.statusDate, true) && Goal.compareValues(this.statusReason, o.statusReason, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.lifecycleStatus, this.achievementStatus, this.category, this.continuous, this.priority, this.description, this.subject, this.start, this.target, this.statusDate, this.statusReason, this.source, this.addresses, this.note, this.outcome});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Goal;
    }

    public static enum GoalLifecycleStatus {
        PROPOSED,
        PLANNED,
        ACCEPTED,
        ACTIVE,
        ONHOLD,
        COMPLETED,
        CANCELLED,
        ENTEREDINERROR,
        REJECTED,
        NULL;


        public static GoalLifecycleStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GoalLifecycleStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSED: {
                    return "proposed";
                }
                case PLANNED: {
                    return "planned";
                }
                case ACCEPTED: {
                    return "accepted";
                }
                case ACTIVE: {
                    return "active";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case REJECTED: {
                    return "rejected";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSED: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case PLANNED: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case ACCEPTED: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSED: {
                    return "A goal is proposed for this patient.";
                }
                case PLANNED: {
                    return "A goal is planned for this patient.";
                }
                case ACCEPTED: {
                    return "A proposed goal was accepted or acknowledged.";
                }
                case ACTIVE: {
                    return "The goal is being sought actively.";
                }
                case ONHOLD: {
                    return "The goal remains a long term objective but is no longer being actively pursued for a temporary period of time.";
                }
                case COMPLETED: {
                    return "The goal is no longer being sought.";
                }
                case CANCELLED: {
                    return "The goal has been abandoned.";
                }
                case ENTEREDINERROR: {
                    return "The goal was entered in error and voided.";
                }
                case REJECTED: {
                    return "A proposed goal was rejected.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSED: {
                    return "Proposed";
                }
                case PLANNED: {
                    return "Planned";
                }
                case ACCEPTED: {
                    return "Accepted";
                }
                case ACTIVE: {
                    return "Active";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class GoalLifecycleStatusEnumFactory
    implements EnumFactory<GoalLifecycleStatus> {
        @Override
        public GoalLifecycleStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return GoalLifecycleStatus.PROPOSED;
            }
            if ("planned".equals(codeString)) {
                return GoalLifecycleStatus.PLANNED;
            }
            if ("accepted".equals(codeString)) {
                return GoalLifecycleStatus.ACCEPTED;
            }
            if ("active".equals(codeString)) {
                return GoalLifecycleStatus.ACTIVE;
            }
            if ("on-hold".equals(codeString)) {
                return GoalLifecycleStatus.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return GoalLifecycleStatus.COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return GoalLifecycleStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return GoalLifecycleStatus.ENTEREDINERROR;
            }
            if ("rejected".equals(codeString)) {
                return GoalLifecycleStatus.REJECTED;
            }
            throw new IllegalArgumentException("Unknown GoalLifecycleStatus code '" + codeString + "'");
        }

        public Enumeration<GoalLifecycleStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GoalLifecycleStatus>(this, GoalLifecycleStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<GoalLifecycleStatus>(this, GoalLifecycleStatus.NULL, code);
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<GoalLifecycleStatus>(this, GoalLifecycleStatus.PROPOSED, code);
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<GoalLifecycleStatus>(this, GoalLifecycleStatus.PLANNED, code);
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<GoalLifecycleStatus>(this, GoalLifecycleStatus.ACCEPTED, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<GoalLifecycleStatus>(this, GoalLifecycleStatus.ACTIVE, code);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<GoalLifecycleStatus>(this, GoalLifecycleStatus.ONHOLD, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<GoalLifecycleStatus>(this, GoalLifecycleStatus.COMPLETED, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<GoalLifecycleStatus>(this, GoalLifecycleStatus.CANCELLED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<GoalLifecycleStatus>(this, GoalLifecycleStatus.ENTEREDINERROR, code);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<GoalLifecycleStatus>(this, GoalLifecycleStatus.REJECTED, code);
            }
            throw new FHIRException("Unknown GoalLifecycleStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(GoalLifecycleStatus code) {
            if (code == GoalLifecycleStatus.NULL) {
                return null;
            }
            if (code == GoalLifecycleStatus.PROPOSED) {
                return "proposed";
            }
            if (code == GoalLifecycleStatus.PLANNED) {
                return "planned";
            }
            if (code == GoalLifecycleStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == GoalLifecycleStatus.ACTIVE) {
                return "active";
            }
            if (code == GoalLifecycleStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == GoalLifecycleStatus.COMPLETED) {
                return "completed";
            }
            if (code == GoalLifecycleStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == GoalLifecycleStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == GoalLifecycleStatus.REJECTED) {
                return "rejected";
            }
            return "?";
        }

        @Override
        public String toSystem(GoalLifecycleStatus code) {
            return code.getSystem();
        }
    }

    @Block
    public static class GoalTargetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="measure", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The parameter whose value is being tracked", formalDefinition="The parameter whose value is being tracked, e.g. body weight, blood pressure, or hemoglobin A1c level.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
        protected CodeableConcept measure;
        @Child(name="detail", type={Quantity.class, Range.class, CodeableConcept.class, StringType.class, BooleanType.class, IntegerType.class, Ratio.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The target value to be achieved", formalDefinition="The target value of the focus to be achieved to signify the fulfillment of the goal, e.g. 150 pounds, 7.0%. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any focus value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any focus value at or above the low value.")
        protected DataType detail;
        @Child(name="due", type={DateType.class, Duration.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reach goal on or before", formalDefinition="Indicates either the date or the duration after start by which the goal should be met.")
        protected DataType due;
        private static final long serialVersionUID = 1975697830L;

        public CodeableConcept getMeasure() {
            if (this.measure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GoalTargetComponent.measure");
                }
                if (Configuration.doAutoCreate()) {
                    this.measure = new CodeableConcept();
                }
            }
            return this.measure;
        }

        public boolean hasMeasure() {
            return this.measure != null && !this.measure.isEmpty();
        }

        public GoalTargetComponent setMeasure(CodeableConcept value) {
            this.measure = value;
            return this;
        }

        public DataType getDetail() {
            return this.detail;
        }

        public Quantity getDetailQuantity() throws FHIRException {
            if (this.detail == null) {
                this.detail = new Quantity();
            }
            if (!(this.detail instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (Quantity)this.detail;
        }

        public boolean hasDetailQuantity() {
            return this.detail instanceof Quantity;
        }

        public Range getDetailRange() throws FHIRException {
            if (this.detail == null) {
                this.detail = new Range();
            }
            if (!(this.detail instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (Range)this.detail;
        }

        public boolean hasDetailRange() {
            return this.detail instanceof Range;
        }

        public CodeableConcept getDetailCodeableConcept() throws FHIRException {
            if (this.detail == null) {
                this.detail = new CodeableConcept();
            }
            if (!(this.detail instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.detail;
        }

        public boolean hasDetailCodeableConcept() {
            return this.detail instanceof CodeableConcept;
        }

        public StringType getDetailStringType() throws FHIRException {
            if (this.detail == null) {
                this.detail = new StringType();
            }
            if (!(this.detail instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (StringType)this.detail;
        }

        public boolean hasDetailStringType() {
            return this.detail instanceof StringType;
        }

        public BooleanType getDetailBooleanType() throws FHIRException {
            if (this.detail == null) {
                this.detail = new BooleanType();
            }
            if (!(this.detail instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.detail;
        }

        public boolean hasDetailBooleanType() {
            return this.detail instanceof BooleanType;
        }

        public IntegerType getDetailIntegerType() throws FHIRException {
            if (this.detail == null) {
                this.detail = new IntegerType();
            }
            if (!(this.detail instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.detail;
        }

        public boolean hasDetailIntegerType() {
            return this.detail instanceof IntegerType;
        }

        public Ratio getDetailRatio() throws FHIRException {
            if (this.detail == null) {
                this.detail = new Ratio();
            }
            if (!(this.detail instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (Ratio)this.detail;
        }

        public boolean hasDetailRatio() {
            return this.detail instanceof Ratio;
        }

        public boolean hasDetail() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public GoalTargetComponent setDetail(DataType value) {
            if (!(value == null || value instanceof Quantity || value instanceof Range || value instanceof CodeableConcept || value instanceof StringType || value instanceof BooleanType || value instanceof IntegerType || value instanceof Ratio)) {
                throw new FHIRException("Not the right type for Goal.target.detail[x]: " + value.fhirType());
            }
            this.detail = value;
            return this;
        }

        public DataType getDue() {
            return this.due;
        }

        public DateType getDueDateType() throws FHIRException {
            if (this.due == null) {
                this.due = new DateType();
            }
            if (!(this.due instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.due.getClass().getName() + " was encountered");
            }
            return (DateType)this.due;
        }

        public boolean hasDueDateType() {
            return this.due instanceof DateType;
        }

        public Duration getDueDuration() throws FHIRException {
            if (this.due == null) {
                this.due = new Duration();
            }
            if (!(this.due instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.due.getClass().getName() + " was encountered");
            }
            return (Duration)this.due;
        }

        public boolean hasDueDuration() {
            return this.due instanceof Duration;
        }

        public boolean hasDue() {
            return this.due != null && !this.due.isEmpty();
        }

        public GoalTargetComponent setDue(DataType value) {
            if (value != null && !(value instanceof DateType) && !(value instanceof Duration)) {
                throw new FHIRException("Not the right type for Goal.target.due[x]: " + value.fhirType());
            }
            this.due = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("measure", "CodeableConcept", "The parameter whose value is being tracked, e.g. body weight, blood pressure, or hemoglobin A1c level.", 0, 1, this.measure));
            children.add(new Property("detail[x]", "Quantity|Range|CodeableConcept|string|boolean|integer|Ratio", "The target value of the focus to be achieved to signify the fulfillment of the goal, e.g. 150 pounds, 7.0%. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any focus value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any focus value at or above the low value.", 0, 1, this.detail));
            children.add(new Property("due[x]", "date|Duration", "Indicates either the date or the duration after start by which the goal should be met.", 0, 1, this.due));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 938321246: {
                    return new Property("measure", "CodeableConcept", "The parameter whose value is being tracked, e.g. body weight, blood pressure, or hemoglobin A1c level.", 0, 1, this.measure);
                }
                case -1973084529: {
                    return new Property("detail[x]", "Quantity|Range|CodeableConcept|string|boolean|integer|Ratio", "The target value of the focus to be achieved to signify the fulfillment of the goal, e.g. 150 pounds, 7.0%. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any focus value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any focus value at or above the low value.", 0, 1, this.detail);
                }
                case -1335224239: {
                    return new Property("detail[x]", "Quantity|Range|CodeableConcept|string|boolean|integer|Ratio", "The target value of the focus to be achieved to signify the fulfillment of the goal, e.g. 150 pounds, 7.0%. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any focus value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any focus value at or above the low value.", 0, 1, this.detail);
                }
                case -1313079300: {
                    return new Property("detail[x]", "Quantity", "The target value of the focus to be achieved to signify the fulfillment of the goal, e.g. 150 pounds, 7.0%. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any focus value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any focus value at or above the low value.", 0, 1, this.detail);
                }
                case -2062632084: {
                    return new Property("detail[x]", "Range", "The target value of the focus to be achieved to signify the fulfillment of the goal, e.g. 150 pounds, 7.0%. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any focus value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any focus value at or above the low value.", 0, 1, this.detail);
                }
                case -175586544: {
                    return new Property("detail[x]", "CodeableConcept", "The target value of the focus to be achieved to signify the fulfillment of the goal, e.g. 150 pounds, 7.0%. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any focus value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any focus value at or above the low value.", 0, 1, this.detail);
                }
                case 529212354: {
                    return new Property("detail[x]", "string", "The target value of the focus to be achieved to signify the fulfillment of the goal, e.g. 150 pounds, 7.0%. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any focus value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any focus value at or above the low value.", 0, 1, this.detail);
                }
                case 1172184727: {
                    return new Property("detail[x]", "boolean", "The target value of the focus to be achieved to signify the fulfillment of the goal, e.g. 150 pounds, 7.0%. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any focus value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any focus value at or above the low value.", 0, 1, this.detail);
                }
                case -1229442131: {
                    return new Property("detail[x]", "integer", "The target value of the focus to be achieved to signify the fulfillment of the goal, e.g. 150 pounds, 7.0%. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any focus value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any focus value at or above the low value.", 0, 1, this.detail);
                }
                case -2062626246: {
                    return new Property("detail[x]", "Ratio", "The target value of the focus to be achieved to signify the fulfillment of the goal, e.g. 150 pounds, 7.0%. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any focus value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any focus value at or above the low value.", 0, 1, this.detail);
                }
                case -1320900084: {
                    return new Property("due[x]", "date|Duration", "Indicates either the date or the duration after start by which the goal should be met.", 0, 1, this.due);
                }
                case 99828: {
                    return new Property("due[x]", "date|Duration", "Indicates either the date or the duration after start by which the goal should be met.", 0, 1, this.due);
                }
                case 2001063874: {
                    return new Property("due[x]", "date", "Indicates either the date or the duration after start by which the goal should be met.", 0, 1, this.due);
                }
                case -620428376: {
                    return new Property("due[x]", "Duration", "Indicates either the date or the duration after start by which the goal should be met.", 0, 1, this.due);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 938321246: {
                    Base[] baseArray;
                    if (this.measure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.measure;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    Base[] baseArray;
                    if (this.detail == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.detail;
                    }
                    return baseArray;
                }
                case 99828: {
                    Base[] baseArray;
                    if (this.due == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.due;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 938321246: {
                    this.measure = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1335224239: {
                    this.detail = TypeConvertor.castToType(value);
                    return value;
                }
                case 99828: {
                    this.due = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("measure")) {
                this.measure = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("detail[x]")) {
                this.detail = TypeConvertor.castToType(value);
            } else if (name.equals("due[x]")) {
                this.due = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("measure")) {
                this.measure = null;
            } else if (name.equals("detail[x]")) {
                this.detail = null;
            } else if (name.equals("due[x]")) {
                this.due = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938321246: {
                    return this.getMeasure();
                }
                case -1973084529: {
                    return this.getDetail();
                }
                case -1335224239: {
                    return this.getDetail();
                }
                case -1320900084: {
                    return this.getDue();
                }
                case 99828: {
                    return this.getDue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938321246: {
                    return new String[]{"CodeableConcept"};
                }
                case -1335224239: {
                    return new String[]{"Quantity", "Range", "CodeableConcept", "string", "boolean", "integer", "Ratio"};
                }
                case 99828: {
                    return new String[]{"date", "Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("measure")) {
                this.measure = new CodeableConcept();
                return this.measure;
            }
            if (name.equals("detailQuantity")) {
                this.detail = new Quantity();
                return this.detail;
            }
            if (name.equals("detailRange")) {
                this.detail = new Range();
                return this.detail;
            }
            if (name.equals("detailCodeableConcept")) {
                this.detail = new CodeableConcept();
                return this.detail;
            }
            if (name.equals("detailString")) {
                this.detail = new StringType();
                return this.detail;
            }
            if (name.equals("detailBoolean")) {
                this.detail = new BooleanType();
                return this.detail;
            }
            if (name.equals("detailInteger")) {
                this.detail = new IntegerType();
                return this.detail;
            }
            if (name.equals("detailRatio")) {
                this.detail = new Ratio();
                return this.detail;
            }
            if (name.equals("dueDate")) {
                this.due = new DateType();
                return this.due;
            }
            if (name.equals("dueDuration")) {
                this.due = new Duration();
                return this.due;
            }
            return super.addChild(name);
        }

        @Override
        public GoalTargetComponent copy() {
            GoalTargetComponent dst = new GoalTargetComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(GoalTargetComponent dst) {
            super.copyValues(dst);
            dst.measure = this.measure == null ? null : this.measure.copy();
            dst.detail = this.detail == null ? null : this.detail.copy();
            dst.due = this.due == null ? null : this.due.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GoalTargetComponent)) {
                return false;
            }
            GoalTargetComponent o = (GoalTargetComponent)other_;
            return GoalTargetComponent.compareDeep(this.measure, o.measure, true) && GoalTargetComponent.compareDeep(this.detail, o.detail, true) && GoalTargetComponent.compareDeep(this.due, o.due, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GoalTargetComponent)) {
                return false;
            }
            GoalTargetComponent o = (GoalTargetComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.measure, this.detail, this.due});
        }

        @Override
        public String fhirType() {
            return "Goal.target";
        }
    }
}

