/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.CARE_ENTRY;
import org.hl7.fhir.r5.openehr.DV_DATE_TIME;
import org.hl7.fhir.r5.openehr.INSTRUCTION_DETAILS;
import org.hl7.fhir.r5.openehr.ISM_TRANSITION;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;

@DatatypeDef(name="ACTION")
public class ACTION
extends CARE_ENTRY
implements ICompositeType {
    @Child(name="time", type={DV_DATE_TIME.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Point in time at which this action completed", formalDefinition="Point in time at which this action completed. To indicate an unknown time, use a DV_DATE_TIME instance with value set to the time of creation (or some other known time before which the Action is known to have occurred, e.g. data accession timestamp from integration engine), and magnitude_status set to <.")
    protected DV_DATE_TIME time;
    @Child(name="ism_transition", type={ISM_TRANSITION.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details of transition in the Instruction state machine caused by this Action", formalDefinition="Details of transition in the Instruction state machine caused by this Action.")
    protected ISM_TRANSITION ism_transition;
    @Child(name="instruction_details", type={INSTRUCTION_DETAILS.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details of the Instruction that caused this Action to be performed, if there was one", formalDefinition="Details of the Instruction that caused this Action to be performed, if there was one.")
    protected INSTRUCTION_DETAILS instruction_details;
    @Child(name="description", type={ITEM_STRUCTURE.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description of the action that has been performed, in the form of an archetyped structure", formalDefinition="Description of the action that has been performed, in the form of an archetyped structure.")
    protected ITEM_STRUCTURE description;
    private static final long serialVersionUID = -850420733L;

    public ACTION() {
    }

    public ACTION(DV_DATE_TIME time, ISM_TRANSITION ism_transition, ITEM_STRUCTURE description) {
        this.setTime(time);
        this.setIsm_transition(ism_transition);
        this.setDescription(description);
    }

    public DV_DATE_TIME getTime() {
        if (this.time == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ACTION.time");
            }
            if (Configuration.doAutoCreate()) {
                this.time = new DV_DATE_TIME();
            }
        }
        return this.time;
    }

    public boolean hasTime() {
        return this.time != null && !this.time.isEmpty();
    }

    public ACTION setTime(DV_DATE_TIME value) {
        this.time = value;
        return this;
    }

    public ISM_TRANSITION getIsm_transition() {
        if (this.ism_transition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ACTION.ism_transition");
            }
            if (Configuration.doAutoCreate()) {
                this.ism_transition = new ISM_TRANSITION();
            }
        }
        return this.ism_transition;
    }

    public boolean hasIsm_transition() {
        return this.ism_transition != null && !this.ism_transition.isEmpty();
    }

    public ACTION setIsm_transition(ISM_TRANSITION value) {
        this.ism_transition = value;
        return this;
    }

    public INSTRUCTION_DETAILS getInstruction_details() {
        if (this.instruction_details == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ACTION.instruction_details");
            }
            if (Configuration.doAutoCreate()) {
                this.instruction_details = new INSTRUCTION_DETAILS();
            }
        }
        return this.instruction_details;
    }

    public boolean hasInstruction_details() {
        return this.instruction_details != null && !this.instruction_details.isEmpty();
    }

    public ACTION setInstruction_details(INSTRUCTION_DETAILS value) {
        this.instruction_details = value;
        return this;
    }

    public ITEM_STRUCTURE getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ACTION setDescription(ITEM_STRUCTURE value) {
        this.description = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("time", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Point in time at which this action completed. To indicate an unknown time, use a DV_DATE_TIME instance with value set to the time of creation (or some other known time before which the Action is known to have occurred, e.g. data accession timestamp from integration engine), and magnitude_status set to <.", 0, 1, this.time));
        children.add(new Property("ism_transition", "http://openehr.org/fhir/StructureDefinition/ISM-TRANSITION", "Details of transition in the Instruction state machine caused by this Action.", 0, 1, this.ism_transition));
        children.add(new Property("instruction_details", "http://openehr.org/fhir/StructureDefinition/INSTRUCTION-DETAILS", "Details of the Instruction that caused this Action to be performed, if there was one.", 0, 1, this.instruction_details));
        children.add(new Property("description", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Description of the action that has been performed, in the form of an archetyped structure.", 0, 1, this.description));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3560141: {
                return new Property("time", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Point in time at which this action completed. To indicate an unknown time, use a DV_DATE_TIME instance with value set to the time of creation (or some other known time before which the Action is known to have occurred, e.g. data accession timestamp from integration engine), and magnitude_status set to <.", 0, 1, this.time);
            }
            case -376386927: {
                return new Property("ism_transition", "http://openehr.org/fhir/StructureDefinition/ISM-TRANSITION", "Details of transition in the Instruction state machine caused by this Action.", 0, 1, this.ism_transition);
            }
            case -676653167: {
                return new Property("instruction_details", "http://openehr.org/fhir/StructureDefinition/INSTRUCTION-DETAILS", "Details of the Instruction that caused this Action to be performed, if there was one.", 0, 1, this.instruction_details);
            }
            case -1724546052: {
                return new Property("description", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Description of the action that has been performed, in the form of an archetyped structure.", 0, 1, this.description);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3560141: {
                Base[] baseArray;
                if (this.time == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.time;
                }
                return baseArray;
            }
            case -376386927: {
                Base[] baseArray;
                if (this.ism_transition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.ism_transition;
                }
                return baseArray;
            }
            case -676653167: {
                Base[] baseArray;
                if (this.instruction_details == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.instruction_details;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.description;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3560141: {
                this.time = (DV_DATE_TIME)value;
                return value;
            }
            case -376386927: {
                this.ism_transition = (ISM_TRANSITION)value;
                return value;
            }
            case -676653167: {
                this.instruction_details = (INSTRUCTION_DETAILS)value;
                return value;
            }
            case -1724546052: {
                this.description = (ITEM_STRUCTURE)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("time")) {
            this.time = (DV_DATE_TIME)value;
        } else if (name.equals("ism_transition")) {
            this.ism_transition = (ISM_TRANSITION)value;
        } else if (name.equals("instruction_details")) {
            this.instruction_details = (INSTRUCTION_DETAILS)value;
        } else if (name.equals("description")) {
            this.description = (ITEM_STRUCTURE)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3560141: {
                return this.getTime();
            }
            case -376386927: {
                return this.getIsm_transition();
            }
            case -676653167: {
                return this.getInstruction_details();
            }
            case -1724546052: {
                throw new Error("Unable to make an instance of the abstract property 'description'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3560141: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME"};
            }
            case -376386927: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ISM-TRANSITION"};
            }
            case -676653167: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/INSTRUCTION-DETAILS"};
            }
            case -1724546052: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("time")) {
            this.time = new DV_DATE_TIME();
            return this.time;
        }
        if (name.equals("ism_transition")) {
            this.ism_transition = new ISM_TRANSITION();
            return this.ism_transition;
        }
        if (name.equals("instruction_details")) {
            this.instruction_details = new INSTRUCTION_DETAILS();
            return this.instruction_details;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on an abstract type ACTION.description");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ACTION";
    }

    @Override
    public ACTION copy() {
        ACTION dst = new ACTION();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ACTION dst) {
        super.copyValues(dst);
        dst.time = this.time == null ? null : this.time.copy();
        dst.ism_transition = this.ism_transition == null ? null : this.ism_transition.copy();
        dst.instruction_details = this.instruction_details == null ? null : this.instruction_details.copy();
        dst.description = this.description == null ? null : this.description.copy();
    }

    protected ACTION typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ACTION)) {
            return false;
        }
        ACTION o = (ACTION)other_;
        return ACTION.compareDeep(this.time, o.time, true) && ACTION.compareDeep(this.ism_transition, o.ism_transition, true) && ACTION.compareDeep(this.instruction_details, o.instruction_details, true) && ACTION.compareDeep(this.description, o.description, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ACTION)) {
            return false;
        }
        ACTION o = (ACTION)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.time, this.ism_transition, this.instruction_details, this.description});
    }
}

