/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_PARSABLE;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;
import org.hl7.fhir.r5.openehr.LOCATABLE;

@DatatypeDef(name="ACTIVITY")
public class ACTIVITY
extends LOCATABLE
implements ICompositeType {
    @Child(name="timing", type={DV_PARSABLE.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Timing of the activity, in the form of a parsable string", formalDefinition="Timing of the activity, in the form of a parsable string. If used, the preferred syntax is ISO8601 'R' format, but other formats may be used including HL7 GTS.")
    protected DV_PARSABLE timing;
    @Child(name="action_archetype_id", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Perl-compliant regular expression pattern indicating the valid identifiers of archetypes for Actions corresponding to this Activity", formalDefinition="Perl-compliant regular expression pattern, enclosed in '//' delimiters, indicating the valid identifiers of archetypes for Actions corresponding to this Activity specification. Defaults to /.*/, meaning any archetype.")
    protected StringType action_archetype_id;
    @Child(name="description", type={ITEM_STRUCTURE.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description of the activity, in the form of an archetyped structure", formalDefinition="Description of the activity, in the form of an archetyped structure.")
    protected ITEM_STRUCTURE description;
    private static final long serialVersionUID = 1041755607L;

    public ACTIVITY() {
    }

    public ACTIVITY(String action_archetype_id, ITEM_STRUCTURE description) {
        this.setAction_archetype_id(action_archetype_id);
        this.setDescription(description);
    }

    public DV_PARSABLE getTiming() {
        if (this.timing == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ACTIVITY.timing");
            }
            if (Configuration.doAutoCreate()) {
                this.timing = new DV_PARSABLE();
            }
        }
        return this.timing;
    }

    public boolean hasTiming() {
        return this.timing != null && !this.timing.isEmpty();
    }

    public ACTIVITY setTiming(DV_PARSABLE value) {
        this.timing = value;
        return this;
    }

    public StringType getAction_archetype_idElement() {
        if (this.action_archetype_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ACTIVITY.action_archetype_id");
            }
            if (Configuration.doAutoCreate()) {
                this.action_archetype_id = new StringType();
            }
        }
        return this.action_archetype_id;
    }

    public boolean hasAction_archetype_idElement() {
        return this.action_archetype_id != null && !this.action_archetype_id.isEmpty();
    }

    public boolean hasAction_archetype_id() {
        return this.action_archetype_id != null && !this.action_archetype_id.isEmpty();
    }

    public ACTIVITY setAction_archetype_idElement(StringType value) {
        this.action_archetype_id = value;
        return this;
    }

    public String getAction_archetype_id() {
        return this.action_archetype_id == null ? null : (String)this.action_archetype_id.getValue();
    }

    public ACTIVITY setAction_archetype_id(String value) {
        if (this.action_archetype_id == null) {
            this.action_archetype_id = new StringType();
        }
        this.action_archetype_id.setValue(value);
        return this;
    }

    public ITEM_STRUCTURE getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ACTIVITY setDescription(ITEM_STRUCTURE value) {
        this.description = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("timing", "http://openehr.org/fhir/StructureDefinition/DV-PARSABLE", "Timing of the activity, in the form of a parsable string. If used, the preferred syntax is ISO8601 'R' format, but other formats may be used including HL7 GTS.", 0, 1, this.timing));
        children.add(new Property("action_archetype_id", "string", "Perl-compliant regular expression pattern, enclosed in '//' delimiters, indicating the valid identifiers of archetypes for Actions corresponding to this Activity specification. Defaults to /.*/, meaning any archetype.", 0, 1, this.action_archetype_id));
        children.add(new Property("description", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Description of the activity, in the form of an archetyped structure.", 0, 1, this.description));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -873664438: {
                return new Property("timing", "http://openehr.org/fhir/StructureDefinition/DV-PARSABLE", "Timing of the activity, in the form of a parsable string. If used, the preferred syntax is ISO8601 'R' format, but other formats may be used including HL7 GTS.", 0, 1, this.timing);
            }
            case 1059971578: {
                return new Property("action_archetype_id", "string", "Perl-compliant regular expression pattern, enclosed in '//' delimiters, indicating the valid identifiers of archetypes for Actions corresponding to this Activity specification. Defaults to /.*/, meaning any archetype.", 0, 1, this.action_archetype_id);
            }
            case -1724546052: {
                return new Property("description", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Description of the activity, in the form of an archetyped structure.", 0, 1, this.description);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -873664438: {
                Base[] baseArray;
                if (this.timing == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.timing;
                }
                return baseArray;
            }
            case 1059971578: {
                Base[] baseArray;
                if (this.action_archetype_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.action_archetype_id;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.description;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -873664438: {
                this.timing = (DV_PARSABLE)value;
                return value;
            }
            case 1059971578: {
                this.action_archetype_id = TypeConvertor.castToString(value);
                return value;
            }
            case -1724546052: {
                this.description = (ITEM_STRUCTURE)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("timing")) {
            this.timing = (DV_PARSABLE)value;
        } else if (name.equals("action_archetype_id")) {
            this.action_archetype_id = TypeConvertor.castToString(value);
        } else if (name.equals("description")) {
            this.description = (ITEM_STRUCTURE)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -873664438: {
                return this.getTiming();
            }
            case 1059971578: {
                return this.getAction_archetype_idElement();
            }
            case -1724546052: {
                throw new Error("Unable to make an instance of the abstract property 'description'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -873664438: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-PARSABLE"};
            }
            case 1059971578: {
                return new String[]{"string"};
            }
            case -1724546052: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("timing")) {
            this.timing = new DV_PARSABLE();
            return this.timing;
        }
        if (name.equals("action_archetype_id")) {
            throw new FHIRException("Cannot call addChild on a singleton property ACTIVITY.action_archetype_id");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on an abstract type ACTIVITY.description");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ACTIVITY";
    }

    @Override
    public ACTIVITY copy() {
        ACTIVITY dst = new ACTIVITY();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ACTIVITY dst) {
        super.copyValues(dst);
        dst.timing = this.timing == null ? null : this.timing.copy();
        dst.action_archetype_id = this.action_archetype_id == null ? null : this.action_archetype_id.copy();
        dst.description = this.description == null ? null : this.description.copy();
    }

    protected ACTIVITY typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ACTIVITY)) {
            return false;
        }
        ACTIVITY o = (ACTIVITY)other_;
        return ACTIVITY.compareDeep(this.timing, o.timing, true) && ACTIVITY.compareDeep(this.action_archetype_id, o.action_archetype_id, true) && ACTIVITY.compareDeep(this.description, o.description, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ACTIVITY)) {
            return false;
        }
        ACTIVITY o = (ACTIVITY)other_;
        return ACTIVITY.compareValues(this.action_archetype_id, o.action_archetype_id, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.timing, this.action_archetype_id, this.description});
    }
}

