/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.AUDIT_DETAILS;
import org.hl7.fhir.r5.openehr.DV_EHR_URI;
import org.hl7.fhir.r5.openehr.DV_MULTIMEDIA;
import org.hl7.fhir.r5.openehr.DV_TEXT;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="ATTESTATION")
public class ATTESTATION
extends AUDIT_DETAILS
implements ICompositeType {
    @Child(name="attested_view", type={DV_MULTIMEDIA.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional visual representation of content attested e.g. screen image", formalDefinition="Optional visual representation of content attested e.g. screen image.")
    protected DV_MULTIMEDIA attested_view;
    @Child(name="proof", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Proof of attestation", formalDefinition="Proof of attestation.")
    protected StringType proof;
    @Child(name="items", type={DV_EHR_URI.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Items attested, expressed as fully qualified runtime paths to the items in question", formalDefinition="Items attested, expressed as fully qualified runtime paths to the items in question. Although not recommended, these may include fine-grained items which have been attested in some other system. Otherwise it is assumed to be for the entire VERSION with which it is associated.")
    protected List<DV_EHR_URI> itemsList;
    @Child(name="reason", type={DV_TEXT.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason of this attestation", formalDefinition="Reason of this attestation. Optionally coded by the openEHR Terminology group attestation reason ; includes values like authorisation , witness etc.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-attestation_reason")
    protected DV_TEXT reason;
    @Child(name="is_pending", type={BooleanType.class}, order=4, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="True if this attestation is outstanding; False means it has been completed", formalDefinition="True if this attestation is outstanding; False means it has been completed.")
    protected BooleanType is_pending;
    private static final long serialVersionUID = 1016314460L;

    public ATTESTATION() {
    }

    public ATTESTATION(DV_TEXT reason, boolean is_pending) {
        this.setReason(reason);
        this.setIs_pending(is_pending);
    }

    public DV_MULTIMEDIA getAttested_view() {
        if (this.attested_view == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ATTESTATION.attested_view");
            }
            if (Configuration.doAutoCreate()) {
                this.attested_view = new DV_MULTIMEDIA();
            }
        }
        return this.attested_view;
    }

    public boolean hasAttested_view() {
        return this.attested_view != null && !this.attested_view.isEmpty();
    }

    public ATTESTATION setAttested_view(DV_MULTIMEDIA value) {
        this.attested_view = value;
        return this;
    }

    public StringType getProofElement() {
        if (this.proof == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ATTESTATION.proof");
            }
            if (Configuration.doAutoCreate()) {
                this.proof = new StringType();
            }
        }
        return this.proof;
    }

    public boolean hasProofElement() {
        return this.proof != null && !this.proof.isEmpty();
    }

    public boolean hasProof() {
        return this.proof != null && !this.proof.isEmpty();
    }

    public ATTESTATION setProofElement(StringType value) {
        this.proof = value;
        return this;
    }

    public String getProof() {
        return this.proof == null ? null : (String)this.proof.getValue();
    }

    public ATTESTATION setProof(String value) {
        if (Utilities.noString((String)value)) {
            this.proof = null;
        } else {
            if (this.proof == null) {
                this.proof = new StringType();
            }
            this.proof.setValue(value);
        }
        return this;
    }

    public List<DV_EHR_URI> getItemsList() {
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<DV_EHR_URI>();
        }
        return this.itemsList;
    }

    public ATTESTATION setItemsList(List<DV_EHR_URI> theItems) {
        this.itemsList = theItems;
        return this;
    }

    public boolean hasItems() {
        if (this.itemsList == null) {
            return false;
        }
        for (DV_EHR_URI item : this.itemsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DV_EHR_URI addItems() {
        DV_EHR_URI t = new DV_EHR_URI();
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<DV_EHR_URI>();
        }
        this.itemsList.add(t);
        return t;
    }

    public ATTESTATION addItems(DV_EHR_URI t) {
        if (t == null) {
            return this;
        }
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<DV_EHR_URI>();
        }
        this.itemsList.add(t);
        return this;
    }

    public DV_EHR_URI getItemsFirstRep() {
        if (this.getItemsList().isEmpty()) {
            this.addItems();
        }
        return this.getItemsList().get(0);
    }

    public DV_TEXT getReason() {
        if (this.reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ATTESTATION.reason");
            }
            if (Configuration.doAutoCreate()) {
                this.reason = new DV_TEXT();
            }
        }
        return this.reason;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public ATTESTATION setReason(DV_TEXT value) {
        this.reason = value;
        return this;
    }

    public BooleanType getIs_pendingElement() {
        if (this.is_pending == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ATTESTATION.is_pending");
            }
            if (Configuration.doAutoCreate()) {
                this.is_pending = new BooleanType();
            }
        }
        return this.is_pending;
    }

    public boolean hasIs_pendingElement() {
        return this.is_pending != null && !this.is_pending.isEmpty();
    }

    public boolean hasIs_pending() {
        return this.is_pending != null && !this.is_pending.isEmpty();
    }

    public ATTESTATION setIs_pendingElement(BooleanType value) {
        this.is_pending = value;
        return this;
    }

    public boolean getIs_pending() {
        return this.is_pending == null || this.is_pending.isEmpty() ? false : (Boolean)this.is_pending.getValue();
    }

    public ATTESTATION setIs_pending(boolean value) {
        if (this.is_pending == null) {
            this.is_pending = new BooleanType();
        }
        this.is_pending.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("attested_view", "http://openehr.org/fhir/StructureDefinition/DV-MULTIMEDIA", "Optional visual representation of content attested e.g. screen image.", 0, 1, this.attested_view));
        children.add(new Property("proof", "string", "Proof of attestation.", 0, 1, this.proof));
        children.add(new Property("items", "http://openehr.org/fhir/StructureDefinition/DV-EHR-URI", "Items attested, expressed as fully qualified runtime paths to the items in question. Although not recommended, these may include fine-grained items which have been attested in some other system. Otherwise it is assumed to be for the entire VERSION with which it is associated.", 0, Integer.MAX_VALUE, this.itemsList));
        children.add(new Property("reason", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Reason of this attestation. Optionally coded by the openEHR Terminology group attestation reason ; includes values like authorisation , witness etc.", 0, 1, this.reason));
        children.add(new Property("is_pending", "boolean", "True if this attestation is outstanding; False means it has been completed.", 0, 1, this.is_pending));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -261018784: {
                return new Property("attested_view", "http://openehr.org/fhir/StructureDefinition/DV-MULTIMEDIA", "Optional visual representation of content attested e.g. screen image.", 0, 1, this.attested_view);
            }
            case 106940740: {
                return new Property("proof", "string", "Proof of attestation.", 0, 1, this.proof);
            }
            case 100526016: {
                return new Property("items", "http://openehr.org/fhir/StructureDefinition/DV-EHR-URI", "Items attested, expressed as fully qualified runtime paths to the items in question. Although not recommended, these may include fine-grained items which have been attested in some other system. Otherwise it is assumed to be for the entire VERSION with which it is associated.", 0, Integer.MAX_VALUE, this.itemsList);
            }
            case -934964668: {
                return new Property("reason", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Reason of this attestation. Optionally coded by the openEHR Terminology group attestation reason ; includes values like authorisation , witness etc.", 0, 1, this.reason);
            }
            case 817722242: {
                return new Property("is_pending", "boolean", "True if this attestation is outstanding; False means it has been completed.", 0, 1, this.is_pending);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -261018784: {
                Base[] baseArray;
                if (this.attested_view == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.attested_view;
                }
                return baseArray;
            }
            case 106940740: {
                Base[] baseArray;
                if (this.proof == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.proof;
                }
                return baseArray;
            }
            case 100526016: {
                return this.itemsList == null ? new Base[]{} : this.itemsList.toArray(new Base[this.itemsList.size()]);
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.reason;
                }
                return baseArray;
            }
            case 817722242: {
                Base[] baseArray;
                if (this.is_pending == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.is_pending;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -261018784: {
                this.attested_view = (DV_MULTIMEDIA)value;
                return value;
            }
            case 106940740: {
                this.proof = TypeConvertor.castToString(value);
                return value;
            }
            case 100526016: {
                this.getItemsList().add((DV_EHR_URI)value);
                return value;
            }
            case -934964668: {
                this.reason = (DV_TEXT)value;
                return value;
            }
            case 817722242: {
                this.is_pending = TypeConvertor.castToBoolean(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("attested_view")) {
            this.attested_view = (DV_MULTIMEDIA)value;
        } else if (name.equals("proof")) {
            this.proof = TypeConvertor.castToString(value);
        } else if (name.equals("items")) {
            this.getItemsList().add((DV_EHR_URI)value);
        } else if (name.equals("reason")) {
            this.reason = (DV_TEXT)value;
        } else if (name.equals("is_pending")) {
            this.is_pending = TypeConvertor.castToBoolean(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -261018784: {
                return this.getAttested_view();
            }
            case 106940740: {
                return this.getProofElement();
            }
            case 100526016: {
                return this.addItems();
            }
            case -934964668: {
                return this.getReason();
            }
            case 817722242: {
                return this.getIs_pendingElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -261018784: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-MULTIMEDIA"};
            }
            case 106940740: {
                return new String[]{"string"};
            }
            case 100526016: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-EHR-URI"};
            }
            case -934964668: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-TEXT"};
            }
            case 817722242: {
                return new String[]{"boolean"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("attested_view")) {
            this.attested_view = new DV_MULTIMEDIA();
            return this.attested_view;
        }
        if (name.equals("proof")) {
            throw new FHIRException("Cannot call addChild on a singleton property ATTESTATION.proof");
        }
        if (name.equals("items")) {
            return this.addItems();
        }
        if (name.equals("reason")) {
            this.reason = new DV_TEXT();
            return this.reason;
        }
        if (name.equals("is_pending")) {
            throw new FHIRException("Cannot call addChild on a singleton property ATTESTATION.is_pending");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ATTESTATION";
    }

    @Override
    public ATTESTATION copy() {
        ATTESTATION dst = new ATTESTATION();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ATTESTATION dst) {
        super.copyValues(dst);
        dst.attested_view = this.attested_view == null ? null : this.attested_view.copy();
        StringType stringType = dst.proof = this.proof == null ? null : this.proof.copy();
        if (this.itemsList != null) {
            dst.itemsList = new ArrayList<DV_EHR_URI>();
            for (DV_EHR_URI i : this.itemsList) {
                dst.itemsList.add(i.copy());
            }
        }
        dst.reason = this.reason == null ? null : this.reason.copy();
        dst.is_pending = this.is_pending == null ? null : this.is_pending.copy();
    }

    @Override
    protected ATTESTATION typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ATTESTATION)) {
            return false;
        }
        ATTESTATION o = (ATTESTATION)other_;
        return ATTESTATION.compareDeep(this.attested_view, o.attested_view, true) && ATTESTATION.compareDeep(this.proof, o.proof, true) && ATTESTATION.compareDeep(this.itemsList, o.itemsList, true) && ATTESTATION.compareDeep(this.reason, o.reason, true) && ATTESTATION.compareDeep(this.is_pending, o.is_pending, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ATTESTATION)) {
            return false;
        }
        ATTESTATION o = (ATTESTATION)other_;
        return ATTESTATION.compareValues(this.proof, o.proof, true) && ATTESTATION.compareValues(this.is_pending, o.is_pending, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.attested_view, this.proof, this.itemsList, this.reason, this.is_pending});
    }
}

