/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.ADDRESS;
import org.hl7.fhir.r5.openehr.DV_INTERVAL;
import org.hl7.fhir.r5.openehr.LOCATABLE;

@DatatypeDef(name="CONTACT")
public class CONTACT
extends LOCATABLE
implements ICompositeType {
    @Child(name="addresses", type={ADDRESS.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A set of address alternatives for this contact purpose and time validity combination", formalDefinition="A set of address alternatives for this contact purpose and time validity combination.")
    protected List<ADDRESS> addressesList;
    @Child(name="time_validity", type={DV_INTERVAL.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Valid time interval for this contact descriptor", formalDefinition="Valid time interval for this contact descriptor.")
    protected DV_INTERVAL time_validity;
    private static final long serialVersionUID = 1314053334L;

    public List<ADDRESS> getAddressesList() {
        if (this.addressesList == null) {
            this.addressesList = new ArrayList<ADDRESS>();
        }
        return this.addressesList;
    }

    public CONTACT setAddressesList(List<ADDRESS> theAddresses) {
        this.addressesList = theAddresses;
        return this;
    }

    public boolean hasAddresses() {
        if (this.addressesList == null) {
            return false;
        }
        for (ADDRESS item : this.addressesList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ADDRESS addAddresses() {
        ADDRESS t = new ADDRESS();
        if (this.addressesList == null) {
            this.addressesList = new ArrayList<ADDRESS>();
        }
        this.addressesList.add(t);
        return t;
    }

    public CONTACT addAddresses(ADDRESS t) {
        if (t == null) {
            return this;
        }
        if (this.addressesList == null) {
            this.addressesList = new ArrayList<ADDRESS>();
        }
        this.addressesList.add(t);
        return this;
    }

    public ADDRESS getAddressesFirstRep() {
        if (this.getAddressesList().isEmpty()) {
            this.addAddresses();
        }
        return this.getAddressesList().get(0);
    }

    public DV_INTERVAL getTime_validity() {
        if (this.time_validity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CONTACT.time_validity");
            }
            if (Configuration.doAutoCreate()) {
                this.time_validity = new DV_INTERVAL();
            }
        }
        return this.time_validity;
    }

    public boolean hasTime_validity() {
        return this.time_validity != null && !this.time_validity.isEmpty();
    }

    public CONTACT setTime_validity(DV_INTERVAL value) {
        this.time_validity = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("addresses", "http://openehr.org/fhir/StructureDefinition/ADDRESS", "A set of address alternatives for this contact purpose and time validity combination.", 0, Integer.MAX_VALUE, this.addressesList));
        children.add(new Property("time_validity", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "Valid time interval for this contact descriptor.", 0, 1, this.time_validity));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 874544034: {
                return new Property("addresses", "http://openehr.org/fhir/StructureDefinition/ADDRESS", "A set of address alternatives for this contact purpose and time validity combination.", 0, Integer.MAX_VALUE, this.addressesList);
            }
            case -1304171420: {
                return new Property("time_validity", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "Valid time interval for this contact descriptor.", 0, 1, this.time_validity);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 874544034: {
                return this.addressesList == null ? new Base[]{} : this.addressesList.toArray(new Base[this.addressesList.size()]);
            }
            case -1304171420: {
                Base[] baseArray;
                if (this.time_validity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.time_validity;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 874544034: {
                this.getAddressesList().add((ADDRESS)value);
                return value;
            }
            case -1304171420: {
                this.time_validity = (DV_INTERVAL)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("addresses")) {
            this.getAddressesList().add((ADDRESS)value);
        } else if (name.equals("time_validity")) {
            this.time_validity = (DV_INTERVAL)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 874544034: {
                return this.addAddresses();
            }
            case -1304171420: {
                return this.getTime_validity();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 874544034: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ADDRESS"};
            }
            case -1304171420: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-INTERVAL"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("addresses")) {
            return this.addAddresses();
        }
        if (name.equals("time_validity")) {
            this.time_validity = new DV_INTERVAL();
            return this.time_validity;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CONTACT";
    }

    @Override
    public CONTACT copy() {
        CONTACT dst = new CONTACT();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CONTACT dst) {
        super.copyValues(dst);
        if (this.addressesList != null) {
            dst.addressesList = new ArrayList<ADDRESS>();
            for (ADDRESS i : this.addressesList) {
                dst.addressesList.add(i.copy());
            }
        }
        dst.time_validity = this.time_validity == null ? null : this.time_validity.copy();
    }

    protected CONTACT typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CONTACT)) {
            return false;
        }
        CONTACT o = (CONTACT)other_;
        return CONTACT.compareDeep(this.addressesList, o.addressesList, true) && CONTACT.compareDeep(this.time_validity, o.time_validity, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CONTACT)) {
            return false;
        }
        CONTACT o = (CONTACT)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.addressesList, this.time_validity});
    }
}

