/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DATA_VALUE;

@DatatypeDef(name="DV_BOOLEAN")
public class DV_BOOLEAN
extends DATA_VALUE
implements ICompositeType {
    @Child(name="value", type={BooleanType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Boolean value of this item", formalDefinition="Boolean value of this item. Actual values may be language or implementation dependent.")
    protected BooleanType value;
    private static final long serialVersionUID = 1687739447L;

    public DV_BOOLEAN() {
    }

    public DV_BOOLEAN(boolean value) {
        this.setValue(value);
    }

    public BooleanType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_BOOLEAN.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new BooleanType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public DV_BOOLEAN setValueElement(BooleanType value) {
        this.value = value;
        return this;
    }

    public boolean getValue() {
        return this.value == null || this.value.isEmpty() ? false : (Boolean)this.value.getValue();
    }

    public DV_BOOLEAN setValue(boolean value) {
        if (this.value == null) {
            this.value = new BooleanType();
        }
        this.value.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("value", "boolean", "Boolean value of this item. Actual values may be language or implementation dependent.", 0, 1, this.value));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 111972721: {
                return new Property("value", "boolean", "Boolean value of this item. Actual values may be language or implementation dependent.", 0, 1, this.value);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.value;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 111972721: {
                this.value = TypeConvertor.castToBoolean(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("value")) {
            return super.setProperty(name, value);
        }
        this.value = TypeConvertor.castToBoolean(value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return this.getValueElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return new String[]{"boolean"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_BOOLEAN.value");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_BOOLEAN";
    }

    @Override
    public DV_BOOLEAN copy() {
        DV_BOOLEAN dst = new DV_BOOLEAN();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_BOOLEAN dst) {
        super.copyValues(dst);
        dst.value = this.value == null ? null : this.value.copy();
    }

    protected DV_BOOLEAN typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_BOOLEAN)) {
            return false;
        }
        DV_BOOLEAN o = (DV_BOOLEAN)other_;
        return DV_BOOLEAN.compareDeep(this.value, o.value, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_BOOLEAN)) {
            return false;
        }
        DV_BOOLEAN o = (DV_BOOLEAN)other_;
        return DV_BOOLEAN.compareValues(this.value, o.value, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value});
    }
}

