/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DATA_VALUE;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="DV_IDENTIFIER")
public class DV_IDENTIFIER
extends DATA_VALUE
implements ICompositeType {
    @Child(name="issuer", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional authority which issues the kind of id used in the id field of this object", formalDefinition="Optional authority which issues the kind of id used in the id field of this object.")
    protected StringType issuer;
    @Child(name="assigner", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional organisation that assigned the id to the item being identified", formalDefinition="Optional organisation that assigned the id to the item being identified.")
    protected StringType assigner;
    @Child(name="id", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The identifier value", formalDefinition="The identifier value. Often structured, according to the definition of the issuing authority\u2019s rules.")
    protected StringType id;
    @Child(name="type", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional identifier type, such as prescription, or Social Security Number", formalDefinition="Optional identifier type, such as prescription, or Social Security Number. One day a controlled vocabulary might be possible for this.")
    protected StringType type;
    private static final long serialVersionUID = -1346721174L;

    public DV_IDENTIFIER() {
    }

    public DV_IDENTIFIER(String id) {
        this.setId(id);
    }

    public StringType getIssuerElement() {
        if (this.issuer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_IDENTIFIER.issuer");
            }
            if (Configuration.doAutoCreate()) {
                this.issuer = new StringType();
            }
        }
        return this.issuer;
    }

    public boolean hasIssuerElement() {
        return this.issuer != null && !this.issuer.isEmpty();
    }

    public boolean hasIssuer() {
        return this.issuer != null && !this.issuer.isEmpty();
    }

    public DV_IDENTIFIER setIssuerElement(StringType value) {
        this.issuer = value;
        return this;
    }

    public String getIssuer() {
        return this.issuer == null ? null : (String)this.issuer.getValue();
    }

    public DV_IDENTIFIER setIssuer(String value) {
        if (Utilities.noString((String)value)) {
            this.issuer = null;
        } else {
            if (this.issuer == null) {
                this.issuer = new StringType();
            }
            this.issuer.setValue(value);
        }
        return this;
    }

    public StringType getAssignerElement() {
        if (this.assigner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_IDENTIFIER.assigner");
            }
            if (Configuration.doAutoCreate()) {
                this.assigner = new StringType();
            }
        }
        return this.assigner;
    }

    public boolean hasAssignerElement() {
        return this.assigner != null && !this.assigner.isEmpty();
    }

    public boolean hasAssigner() {
        return this.assigner != null && !this.assigner.isEmpty();
    }

    public DV_IDENTIFIER setAssignerElement(StringType value) {
        this.assigner = value;
        return this;
    }

    public String getAssigner() {
        return this.assigner == null ? null : (String)this.assigner.getValue();
    }

    public DV_IDENTIFIER setAssigner(String value) {
        if (Utilities.noString((String)value)) {
            this.assigner = null;
        } else {
            if (this.assigner == null) {
                this.assigner = new StringType();
            }
            this.assigner.setValue(value);
        }
        return this;
    }

    public StringType getIdElement() {
        if (this.id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_IDENTIFIER.id");
            }
            if (Configuration.doAutoCreate()) {
                this.id = new StringType();
            }
        }
        return this.id;
    }

    public boolean hasIdElement() {
        return this.id != null && !this.id.isEmpty();
    }

    public boolean hasId() {
        return this.id != null && !this.id.isEmpty();
    }

    public DV_IDENTIFIER setIdElement(StringType value) {
        this.id = value;
        return this;
    }

    public String getId() {
        return this.id == null ? null : (String)this.id.getValue();
    }

    public DV_IDENTIFIER setId(String value) {
        if (this.id == null) {
            this.id = new StringType();
        }
        this.id.setValue(value);
        return this;
    }

    public StringType getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_IDENTIFIER.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new StringType();
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DV_IDENTIFIER setTypeElement(StringType value) {
        this.type = value;
        return this;
    }

    public String getType() {
        return this.type == null ? null : (String)this.type.getValue();
    }

    public DV_IDENTIFIER setType(String value) {
        if (Utilities.noString((String)value)) {
            this.type = null;
        } else {
            if (this.type == null) {
                this.type = new StringType();
            }
            this.type.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("issuer", "string", "Optional authority which issues the kind of id used in the id field of this object.", 0, 1, this.issuer));
        children.add(new Property("assigner", "string", "Optional organisation that assigned the id to the item being identified.", 0, 1, this.assigner));
        children.add(new Property("id", "string", "The identifier value. Often structured, according to the definition of the issuing authority\u2019s rules.", 0, 1, this.id));
        children.add(new Property("type", "string", "Optional identifier type, such as prescription, or Social Security Number. One day a controlled vocabulary might be possible for this.", 0, 1, this.type));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1179159879: {
                return new Property("issuer", "string", "Optional authority which issues the kind of id used in the id field of this object.", 0, 1, this.issuer);
            }
            case -369881636: {
                return new Property("assigner", "string", "Optional organisation that assigned the id to the item being identified.", 0, 1, this.assigner);
            }
            case 3355: {
                return new Property("id", "string", "The identifier value. Often structured, according to the definition of the issuing authority\u2019s rules.", 0, 1, this.id);
            }
            case 3575610: {
                return new Property("type", "string", "Optional identifier type, such as prescription, or Social Security Number. One day a controlled vocabulary might be possible for this.", 0, 1, this.type);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1179159879: {
                Base[] baseArray;
                if (this.issuer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.issuer;
                }
                return baseArray;
            }
            case -369881636: {
                Base[] baseArray;
                if (this.assigner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.assigner;
                }
                return baseArray;
            }
            case 3355: {
                Base[] baseArray;
                if (this.id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.id;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.type;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1179159879: {
                this.issuer = TypeConvertor.castToString(value);
                return value;
            }
            case -369881636: {
                this.assigner = TypeConvertor.castToString(value);
                return value;
            }
            case 3355: {
                this.id = TypeConvertor.castToString(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("issuer")) {
            this.issuer = TypeConvertor.castToString(value);
        } else if (name.equals("assigner")) {
            this.assigner = TypeConvertor.castToString(value);
        } else if (name.equals("id")) {
            this.id = TypeConvertor.castToString(value);
        } else if (name.equals("type")) {
            this.type = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1179159879: {
                return this.getIssuerElement();
            }
            case -369881636: {
                return this.getAssignerElement();
            }
            case 3355: {
                return this.getIdElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1179159879: {
                return new String[]{"string"};
            }
            case -369881636: {
                return new String[]{"string"};
            }
            case 3355: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("issuer")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_IDENTIFIER.issuer");
        }
        if (name.equals("assigner")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_IDENTIFIER.assigner");
        }
        if (name.equals("id")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_IDENTIFIER.id");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_IDENTIFIER.type");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_IDENTIFIER";
    }

    @Override
    public DV_IDENTIFIER copy() {
        DV_IDENTIFIER dst = new DV_IDENTIFIER();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_IDENTIFIER dst) {
        super.copyValues(dst);
        dst.issuer = this.issuer == null ? null : this.issuer.copy();
        dst.assigner = this.assigner == null ? null : this.assigner.copy();
        dst.id = this.id == null ? null : this.id.copy();
        dst.type = this.type == null ? null : this.type.copy();
    }

    protected DV_IDENTIFIER typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_IDENTIFIER)) {
            return false;
        }
        DV_IDENTIFIER o = (DV_IDENTIFIER)other_;
        return DV_IDENTIFIER.compareDeep(this.issuer, o.issuer, true) && DV_IDENTIFIER.compareDeep(this.assigner, o.assigner, true) && DV_IDENTIFIER.compareDeep(this.id, o.id, true) && DV_IDENTIFIER.compareDeep(this.type, o.type, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_IDENTIFIER)) {
            return false;
        }
        DV_IDENTIFIER o = (DV_IDENTIFIER)other_;
        return DV_IDENTIFIER.compareValues(this.issuer, o.issuer, true) && DV_IDENTIFIER.compareValues(this.assigner, o.assigner, true) && DV_IDENTIFIER.compareValues(this.id, o.id, true) && DV_IDENTIFIER.compareValues(this.type, o.type, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.issuer, this.assigner, this.id, this.type});
    }
}

