/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.CODE_PHRASE;
import org.hl7.fhir.r5.openehr.DV_ENCAPSULATED;
import org.hl7.fhir.r5.openehr.DV_URI;

@DatatypeDef(name="DV_MULTIMEDIA")
public class DV_MULTIMEDIA
extends DV_ENCAPSULATED
implements ICompositeType {
    @Child(name="alternate_text", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Text to display in lieu of multimedia display/replay", formalDefinition="Text to display in lieu of multimedia display/replay.")
    protected StringType alternate_text;
    @Child(name="uri", type={DV_URI.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="URI reference to electronic information stored outside the record as a file, database entry etc, if supplied as a reference", formalDefinition="URI reference to electronic information stored outside the record as a file, database entry etc, if supplied as a reference.")
    protected DV_URI uri;
    @Child(name="data", type={Base64BinaryType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The actual data found at uri, if supplied inline", formalDefinition="The actual data found at uri, if supplied inline.")
    protected Base64BinaryType data;
    @Child(name="media_type", type={CODE_PHRASE.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Data media type coded from openEHR code set media types: IANA MIME types", formalDefinition="Data media type coded from openEHR code set media types (interface for the IANA MIME types code set).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
    protected CODE_PHRASE media_type;
    @Child(name="compression_algorithm", type={CODE_PHRASE.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Compression type, a coded value from the openEHR Integrity check code set. Absence means no compression", formalDefinition="Compression type, a coded value from the openEHR Integrity check code set. Void means no compression.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-compression_algorithms")
    protected CODE_PHRASE compression_algorithm;
    @Child(name="integrity_check", type={Base64BinaryType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Binary cryptographic integrity checksum", formalDefinition="Binary cryptographic integrity checksum.")
    protected Base64BinaryType integrity_check;
    @Child(name="integrity_check_algorithm", type={CODE_PHRASE.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of integrity check, a coded value from the openEHR Integrity check code set", formalDefinition="Type of integrity check, a coded value from the openEHR Integrity check code set.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-integrity_check_algorithms")
    protected CODE_PHRASE integrity_check_algorithm;
    @Child(name="thumbnail", type={DV_MULTIMEDIA.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The thumbnail for this item, if one exists; mainly for graphics formats", formalDefinition="The thumbnail for this item, if one exists; mainly for graphics formats.")
    protected DV_MULTIMEDIA thumbnail;
    @Child(name="size", type={IntegerType.class}, order=8, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Original size in bytes of unencoded encapsulated data", formalDefinition="Original size in bytes of unencoded encapsulated data. I.e. encodings such as base64, hexadecimal etc do not change the value of this attribute.")
    protected IntegerType size;
    private static final long serialVersionUID = 271994043L;

    public DV_MULTIMEDIA() {
    }

    public DV_MULTIMEDIA(String alternate_text, CODE_PHRASE media_type, int size) {
        this.setAlternate_text(alternate_text);
        this.setMedia_type(media_type);
        this.setSize(size);
    }

    public StringType getAlternate_textElement() {
        if (this.alternate_text == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_MULTIMEDIA.alternate_text");
            }
            if (Configuration.doAutoCreate()) {
                this.alternate_text = new StringType();
            }
        }
        return this.alternate_text;
    }

    public boolean hasAlternate_textElement() {
        return this.alternate_text != null && !this.alternate_text.isEmpty();
    }

    public boolean hasAlternate_text() {
        return this.alternate_text != null && !this.alternate_text.isEmpty();
    }

    public DV_MULTIMEDIA setAlternate_textElement(StringType value) {
        this.alternate_text = value;
        return this;
    }

    public String getAlternate_text() {
        return this.alternate_text == null ? null : (String)this.alternate_text.getValue();
    }

    public DV_MULTIMEDIA setAlternate_text(String value) {
        if (this.alternate_text == null) {
            this.alternate_text = new StringType();
        }
        this.alternate_text.setValue(value);
        return this;
    }

    public DV_URI getUri() {
        if (this.uri == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_MULTIMEDIA.uri");
            }
            if (Configuration.doAutoCreate()) {
                this.uri = new DV_URI();
            }
        }
        return this.uri;
    }

    public boolean hasUri() {
        return this.uri != null && !this.uri.isEmpty();
    }

    public DV_MULTIMEDIA setUri(DV_URI value) {
        this.uri = value;
        return this;
    }

    public Base64BinaryType getDataElement() {
        if (this.data == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_MULTIMEDIA.data");
            }
            if (Configuration.doAutoCreate()) {
                this.data = new Base64BinaryType();
            }
        }
        return this.data;
    }

    public boolean hasDataElement() {
        return this.data != null && !this.data.isEmpty();
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public DV_MULTIMEDIA setDataElement(Base64BinaryType value) {
        this.data = value;
        return this;
    }

    public byte[] getData() {
        return this.data == null ? null : this.data.getValue();
    }

    public DV_MULTIMEDIA setData(byte[] value) {
        if (value == null) {
            this.data = null;
        } else {
            if (this.data == null) {
                this.data = new Base64BinaryType();
            }
            this.data.setValue(value);
        }
        return this;
    }

    public CODE_PHRASE getMedia_type() {
        if (this.media_type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_MULTIMEDIA.media_type");
            }
            if (Configuration.doAutoCreate()) {
                this.media_type = new CODE_PHRASE();
            }
        }
        return this.media_type;
    }

    public boolean hasMedia_type() {
        return this.media_type != null && !this.media_type.isEmpty();
    }

    public DV_MULTIMEDIA setMedia_type(CODE_PHRASE value) {
        this.media_type = value;
        return this;
    }

    public CODE_PHRASE getCompression_algorithm() {
        if (this.compression_algorithm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_MULTIMEDIA.compression_algorithm");
            }
            if (Configuration.doAutoCreate()) {
                this.compression_algorithm = new CODE_PHRASE();
            }
        }
        return this.compression_algorithm;
    }

    public boolean hasCompression_algorithm() {
        return this.compression_algorithm != null && !this.compression_algorithm.isEmpty();
    }

    public DV_MULTIMEDIA setCompression_algorithm(CODE_PHRASE value) {
        this.compression_algorithm = value;
        return this;
    }

    public Base64BinaryType getIntegrity_checkElement() {
        if (this.integrity_check == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_MULTIMEDIA.integrity_check");
            }
            if (Configuration.doAutoCreate()) {
                this.integrity_check = new Base64BinaryType();
            }
        }
        return this.integrity_check;
    }

    public boolean hasIntegrity_checkElement() {
        return this.integrity_check != null && !this.integrity_check.isEmpty();
    }

    public boolean hasIntegrity_check() {
        return this.integrity_check != null && !this.integrity_check.isEmpty();
    }

    public DV_MULTIMEDIA setIntegrity_checkElement(Base64BinaryType value) {
        this.integrity_check = value;
        return this;
    }

    public byte[] getIntegrity_check() {
        return this.integrity_check == null ? null : this.integrity_check.getValue();
    }

    public DV_MULTIMEDIA setIntegrity_check(byte[] value) {
        if (value == null) {
            this.integrity_check = null;
        } else {
            if (this.integrity_check == null) {
                this.integrity_check = new Base64BinaryType();
            }
            this.integrity_check.setValue(value);
        }
        return this;
    }

    public CODE_PHRASE getIntegrity_check_algorithm() {
        if (this.integrity_check_algorithm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_MULTIMEDIA.integrity_check_algorithm");
            }
            if (Configuration.doAutoCreate()) {
                this.integrity_check_algorithm = new CODE_PHRASE();
            }
        }
        return this.integrity_check_algorithm;
    }

    public boolean hasIntegrity_check_algorithm() {
        return this.integrity_check_algorithm != null && !this.integrity_check_algorithm.isEmpty();
    }

    public DV_MULTIMEDIA setIntegrity_check_algorithm(CODE_PHRASE value) {
        this.integrity_check_algorithm = value;
        return this;
    }

    public DV_MULTIMEDIA getThumbnail() {
        if (this.thumbnail == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_MULTIMEDIA.thumbnail");
            }
            if (Configuration.doAutoCreate()) {
                this.thumbnail = new DV_MULTIMEDIA();
            }
        }
        return this.thumbnail;
    }

    public boolean hasThumbnail() {
        return this.thumbnail != null && !this.thumbnail.isEmpty();
    }

    public DV_MULTIMEDIA setThumbnail(DV_MULTIMEDIA value) {
        this.thumbnail = value;
        return this;
    }

    public IntegerType getSizeElement() {
        if (this.size == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_MULTIMEDIA.size");
            }
            if (Configuration.doAutoCreate()) {
                this.size = new IntegerType();
            }
        }
        return this.size;
    }

    public boolean hasSizeElement() {
        return this.size != null && !this.size.isEmpty();
    }

    public boolean hasSize() {
        return this.size != null && !this.size.isEmpty();
    }

    public DV_MULTIMEDIA setSizeElement(IntegerType value) {
        this.size = value;
        return this;
    }

    public int getSize() {
        return this.size == null || this.size.isEmpty() ? 0 : (Integer)this.size.getValue();
    }

    public DV_MULTIMEDIA setSize(int value) {
        if (this.size == null) {
            this.size = new IntegerType();
        }
        this.size.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("alternate_text", "string", "Text to display in lieu of multimedia display/replay.", 0, 1, this.alternate_text));
        children.add(new Property("uri", "http://openehr.org/fhir/StructureDefinition/DV-URI", "URI reference to electronic information stored outside the record as a file, database entry etc, if supplied as a reference.", 0, 1, this.uri));
        children.add(new Property("data", "base64Binary", "The actual data found at uri, if supplied inline.", 0, 1, this.data));
        children.add(new Property("media_type", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Data media type coded from openEHR code set media types (interface for the IANA MIME types code set).", 0, 1, this.media_type));
        children.add(new Property("compression_algorithm", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Compression type, a coded value from the openEHR Integrity check code set. Void means no compression.", 0, 1, this.compression_algorithm));
        children.add(new Property("integrity_check", "base64Binary", "Binary cryptographic integrity checksum.", 0, 1, this.integrity_check));
        children.add(new Property("integrity_check_algorithm", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Type of integrity check, a coded value from the openEHR Integrity check code set.", 0, 1, this.integrity_check_algorithm));
        children.add(new Property("thumbnail", "http://openehr.org/fhir/StructureDefinition/DV-MULTIMEDIA", "The thumbnail for this item, if one exists; mainly for graphics formats.", 0, 1, this.thumbnail));
        children.add(new Property("size", "integer", "Original size in bytes of unencoded encapsulated data. I.e. encodings such as base64, hexadecimal etc do not change the value of this attribute.", 0, 1, this.size));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -208340526: {
                return new Property("alternate_text", "string", "Text to display in lieu of multimedia display/replay.", 0, 1, this.alternate_text);
            }
            case 116076: {
                return new Property("uri", "http://openehr.org/fhir/StructureDefinition/DV-URI", "URI reference to electronic information stored outside the record as a file, database entry etc, if supplied as a reference.", 0, 1, this.uri);
            }
            case 3076010: {
                return new Property("data", "base64Binary", "The actual data found at uri, if supplied inline.", 0, 1, this.data);
            }
            case 1939875509: {
                return new Property("media_type", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Data media type coded from openEHR code set media types (interface for the IANA MIME types code set).", 0, 1, this.media_type);
            }
            case 1993343190: {
                return new Property("compression_algorithm", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Compression type, a coded value from the openEHR Integrity check code set. Void means no compression.", 0, 1, this.compression_algorithm);
            }
            case 1076156822: {
                return new Property("integrity_check", "base64Binary", "Binary cryptographic integrity checksum.", 0, 1, this.integrity_check);
            }
            case 828114182: {
                return new Property("integrity_check_algorithm", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Type of integrity check, a coded value from the openEHR Integrity check code set.", 0, 1, this.integrity_check_algorithm);
            }
            case 1330532588: {
                return new Property("thumbnail", "http://openehr.org/fhir/StructureDefinition/DV-MULTIMEDIA", "The thumbnail for this item, if one exists; mainly for graphics formats.", 0, 1, this.thumbnail);
            }
            case 3530753: {
                return new Property("size", "integer", "Original size in bytes of unencoded encapsulated data. I.e. encodings such as base64, hexadecimal etc do not change the value of this attribute.", 0, 1, this.size);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -208340526: {
                Base[] baseArray;
                if (this.alternate_text == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.alternate_text;
                }
                return baseArray;
            }
            case 116076: {
                Base[] baseArray;
                if (this.uri == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.uri;
                }
                return baseArray;
            }
            case 3076010: {
                Base[] baseArray;
                if (this.data == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.data;
                }
                return baseArray;
            }
            case 1939875509: {
                Base[] baseArray;
                if (this.media_type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.media_type;
                }
                return baseArray;
            }
            case 1993343190: {
                Base[] baseArray;
                if (this.compression_algorithm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.compression_algorithm;
                }
                return baseArray;
            }
            case 1076156822: {
                Base[] baseArray;
                if (this.integrity_check == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.integrity_check;
                }
                return baseArray;
            }
            case 828114182: {
                Base[] baseArray;
                if (this.integrity_check_algorithm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.integrity_check_algorithm;
                }
                return baseArray;
            }
            case 1330532588: {
                Base[] baseArray;
                if (this.thumbnail == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.thumbnail;
                }
                return baseArray;
            }
            case 3530753: {
                Base[] baseArray;
                if (this.size == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.size;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -208340526: {
                this.alternate_text = TypeConvertor.castToString(value);
                return value;
            }
            case 116076: {
                this.uri = (DV_URI)value;
                return value;
            }
            case 3076010: {
                this.data = TypeConvertor.castToBase64Binary(value);
                return value;
            }
            case 1939875509: {
                this.media_type = (CODE_PHRASE)value;
                return value;
            }
            case 1993343190: {
                this.compression_algorithm = (CODE_PHRASE)value;
                return value;
            }
            case 1076156822: {
                this.integrity_check = TypeConvertor.castToBase64Binary(value);
                return value;
            }
            case 828114182: {
                this.integrity_check_algorithm = (CODE_PHRASE)value;
                return value;
            }
            case 1330532588: {
                this.thumbnail = (DV_MULTIMEDIA)value;
                return value;
            }
            case 3530753: {
                this.size = TypeConvertor.castToInteger(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("alternate_text")) {
            this.alternate_text = TypeConvertor.castToString(value);
        } else if (name.equals("uri")) {
            this.uri = (DV_URI)value;
        } else if (name.equals("data")) {
            this.data = TypeConvertor.castToBase64Binary(value);
        } else if (name.equals("media_type")) {
            this.media_type = (CODE_PHRASE)value;
        } else if (name.equals("compression_algorithm")) {
            this.compression_algorithm = (CODE_PHRASE)value;
        } else if (name.equals("integrity_check")) {
            this.integrity_check = TypeConvertor.castToBase64Binary(value);
        } else if (name.equals("integrity_check_algorithm")) {
            this.integrity_check_algorithm = (CODE_PHRASE)value;
        } else if (name.equals("thumbnail")) {
            this.thumbnail = (DV_MULTIMEDIA)value;
        } else if (name.equals("size")) {
            this.size = TypeConvertor.castToInteger(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -208340526: {
                return this.getAlternate_textElement();
            }
            case 116076: {
                return this.getUri();
            }
            case 3076010: {
                return this.getDataElement();
            }
            case 1939875509: {
                return this.getMedia_type();
            }
            case 1993343190: {
                return this.getCompression_algorithm();
            }
            case 1076156822: {
                return this.getIntegrity_checkElement();
            }
            case 828114182: {
                return this.getIntegrity_check_algorithm();
            }
            case 1330532588: {
                return this.getThumbnail();
            }
            case 3530753: {
                return this.getSizeElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -208340526: {
                return new String[]{"string"};
            }
            case 116076: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-URI"};
            }
            case 3076010: {
                return new String[]{"base64Binary"};
            }
            case 1939875509: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
            case 1993343190: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
            case 1076156822: {
                return new String[]{"base64Binary"};
            }
            case 828114182: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
            case 1330532588: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-MULTIMEDIA"};
            }
            case 3530753: {
                return new String[]{"integer"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("alternate_text")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_MULTIMEDIA.alternate_text");
        }
        if (name.equals("uri")) {
            this.uri = new DV_URI();
            return this.uri;
        }
        if (name.equals("data")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_MULTIMEDIA.data");
        }
        if (name.equals("media_type")) {
            this.media_type = new CODE_PHRASE();
            return this.media_type;
        }
        if (name.equals("compression_algorithm")) {
            this.compression_algorithm = new CODE_PHRASE();
            return this.compression_algorithm;
        }
        if (name.equals("integrity_check")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_MULTIMEDIA.integrity_check");
        }
        if (name.equals("integrity_check_algorithm")) {
            this.integrity_check_algorithm = new CODE_PHRASE();
            return this.integrity_check_algorithm;
        }
        if (name.equals("thumbnail")) {
            this.thumbnail = new DV_MULTIMEDIA();
            return this.thumbnail;
        }
        if (name.equals("size")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_MULTIMEDIA.size");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_MULTIMEDIA";
    }

    @Override
    public DV_MULTIMEDIA copy() {
        DV_MULTIMEDIA dst = new DV_MULTIMEDIA();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_MULTIMEDIA dst) {
        super.copyValues(dst);
        dst.alternate_text = this.alternate_text == null ? null : this.alternate_text.copy();
        dst.uri = this.uri == null ? null : this.uri.copy();
        dst.data = this.data == null ? null : this.data.copy();
        dst.media_type = this.media_type == null ? null : this.media_type.copy();
        dst.compression_algorithm = this.compression_algorithm == null ? null : this.compression_algorithm.copy();
        dst.integrity_check = this.integrity_check == null ? null : this.integrity_check.copy();
        dst.integrity_check_algorithm = this.integrity_check_algorithm == null ? null : this.integrity_check_algorithm.copy();
        dst.thumbnail = this.thumbnail == null ? null : this.thumbnail.copy();
        dst.size = this.size == null ? null : this.size.copy();
    }

    protected DV_MULTIMEDIA typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_MULTIMEDIA)) {
            return false;
        }
        DV_MULTIMEDIA o = (DV_MULTIMEDIA)other_;
        return DV_MULTIMEDIA.compareDeep(this.alternate_text, o.alternate_text, true) && DV_MULTIMEDIA.compareDeep(this.uri, o.uri, true) && DV_MULTIMEDIA.compareDeep(this.data, o.data, true) && DV_MULTIMEDIA.compareDeep(this.media_type, o.media_type, true) && DV_MULTIMEDIA.compareDeep(this.compression_algorithm, o.compression_algorithm, true) && DV_MULTIMEDIA.compareDeep(this.integrity_check, o.integrity_check, true) && DV_MULTIMEDIA.compareDeep(this.integrity_check_algorithm, o.integrity_check_algorithm, true) && DV_MULTIMEDIA.compareDeep(this.thumbnail, o.thumbnail, true) && DV_MULTIMEDIA.compareDeep(this.size, o.size, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_MULTIMEDIA)) {
            return false;
        }
        DV_MULTIMEDIA o = (DV_MULTIMEDIA)other_;
        return DV_MULTIMEDIA.compareValues(this.alternate_text, o.alternate_text, true) && DV_MULTIMEDIA.compareValues(this.data, o.data, true) && DV_MULTIMEDIA.compareValues(this.integrity_check, o.integrity_check, true) && DV_MULTIMEDIA.compareValues(this.size, o.size, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.alternate_text, this.uri, this.data, this.media_type, this.compression_algorithm, this.integrity_check, this.integrity_check_algorithm, this.thumbnail, this.size});
    }
}

