/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.CODE_PHRASE;
import org.hl7.fhir.r5.openehr.DATA_VALUE;
import org.hl7.fhir.r5.openehr.DV_INTERVAL;
import org.hl7.fhir.r5.openehr.REFERENCE_RANGE;

@DatatypeDef(name="DV_ORDERED")
public abstract class DV_ORDERED
extends DATA_VALUE
implements ICompositeType {
    @Child(name="normal_status", type={CODE_PHRASE.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional normal status indicator of value with respect to normal range for this value", formalDefinition="Optional normal status indicator of value with respect to normal range for this value. Often included by lab, even if the normal range itself is not included. Coded by ordinals in series HHH, HH, H, (nothing), L, LL, LLL; see openEHR terminology group normal_status.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-normal_statuses")
    protected CODE_PHRASE normal_status;
    @Child(name="normal_range", type={DV_INTERVAL.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional normal range", formalDefinition="Optional normal range.")
    protected DV_INTERVAL normal_range;
    @Child(name="other_reference_ranges", type={REFERENCE_RANGE.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Optional tagged other reference ranges for this value in its particular measurement context", formalDefinition="Optional tagged other reference ranges for this value in its particular measurement context.")
    protected List<REFERENCE_RANGE> other_reference_rangesList;
    private static final long serialVersionUID = 1994158948L;

    public CODE_PHRASE getNormal_status() {
        if (this.normal_status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_ORDERED.normal_status");
            }
            if (Configuration.doAutoCreate()) {
                this.normal_status = new CODE_PHRASE();
            }
        }
        return this.normal_status;
    }

    public boolean hasNormal_status() {
        return this.normal_status != null && !this.normal_status.isEmpty();
    }

    public DV_ORDERED setNormal_status(CODE_PHRASE value) {
        this.normal_status = value;
        return this;
    }

    public DV_INTERVAL getNormal_range() {
        if (this.normal_range == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_ORDERED.normal_range");
            }
            if (Configuration.doAutoCreate()) {
                this.normal_range = new DV_INTERVAL();
            }
        }
        return this.normal_range;
    }

    public boolean hasNormal_range() {
        return this.normal_range != null && !this.normal_range.isEmpty();
    }

    public DV_ORDERED setNormal_range(DV_INTERVAL value) {
        this.normal_range = value;
        return this;
    }

    public List<REFERENCE_RANGE> getOther_reference_rangesList() {
        if (this.other_reference_rangesList == null) {
            this.other_reference_rangesList = new ArrayList<REFERENCE_RANGE>();
        }
        return this.other_reference_rangesList;
    }

    public DV_ORDERED setOther_reference_rangesList(List<REFERENCE_RANGE> theOther_reference_ranges) {
        this.other_reference_rangesList = theOther_reference_ranges;
        return this;
    }

    public boolean hasOther_reference_ranges() {
        if (this.other_reference_rangesList == null) {
            return false;
        }
        for (REFERENCE_RANGE item : this.other_reference_rangesList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public REFERENCE_RANGE addOther_reference_ranges() {
        REFERENCE_RANGE t = new REFERENCE_RANGE();
        if (this.other_reference_rangesList == null) {
            this.other_reference_rangesList = new ArrayList<REFERENCE_RANGE>();
        }
        this.other_reference_rangesList.add(t);
        return t;
    }

    public DV_ORDERED addOther_reference_ranges(REFERENCE_RANGE t) {
        if (t == null) {
            return this;
        }
        if (this.other_reference_rangesList == null) {
            this.other_reference_rangesList = new ArrayList<REFERENCE_RANGE>();
        }
        this.other_reference_rangesList.add(t);
        return this;
    }

    public REFERENCE_RANGE getOther_reference_rangesFirstRep() {
        if (this.getOther_reference_rangesList().isEmpty()) {
            this.addOther_reference_ranges();
        }
        return this.getOther_reference_rangesList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("normal_status", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Optional normal status indicator of value with respect to normal range for this value. Often included by lab, even if the normal range itself is not included. Coded by ordinals in series HHH, HH, H, (nothing), L, LL, LLL; see openEHR terminology group normal_status.", 0, 1, this.normal_status));
        children.add(new Property("normal_range", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "Optional normal range.", 0, 1, this.normal_range));
        children.add(new Property("other_reference_ranges", "http://openehr.org/fhir/StructureDefinition/REFERENCE-RANGE", "Optional tagged other reference ranges for this value in its particular measurement context.", 0, Integer.MAX_VALUE, this.other_reference_rangesList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1868886454: {
                return new Property("normal_status", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Optional normal status indicator of value with respect to normal range for this value. Often included by lab, even if the normal range itself is not included. Coded by ordinals in series HHH, HH, H, (nothing), L, LL, LLL; see openEHR terminology group normal_status.", 0, 1, this.normal_status);
            }
            case 492425189: {
                return new Property("normal_range", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "Optional normal range.", 0, 1, this.normal_range);
            }
            case -1668425831: {
                return new Property("other_reference_ranges", "http://openehr.org/fhir/StructureDefinition/REFERENCE-RANGE", "Optional tagged other reference ranges for this value in its particular measurement context.", 0, Integer.MAX_VALUE, this.other_reference_rangesList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1868886454: {
                Base[] baseArray;
                if (this.normal_status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.normal_status;
                }
                return baseArray;
            }
            case 492425189: {
                Base[] baseArray;
                if (this.normal_range == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.normal_range;
                }
                return baseArray;
            }
            case -1668425831: {
                return this.other_reference_rangesList == null ? new Base[]{} : this.other_reference_rangesList.toArray(new Base[this.other_reference_rangesList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1868886454: {
                this.normal_status = (CODE_PHRASE)value;
                return value;
            }
            case 492425189: {
                this.normal_range = (DV_INTERVAL)value;
                return value;
            }
            case -1668425831: {
                this.getOther_reference_rangesList().add((REFERENCE_RANGE)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("normal_status")) {
            this.normal_status = (CODE_PHRASE)value;
        } else if (name.equals("normal_range")) {
            this.normal_range = (DV_INTERVAL)value;
        } else if (name.equals("other_reference_ranges")) {
            this.getOther_reference_rangesList().add((REFERENCE_RANGE)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1868886454: {
                return this.getNormal_status();
            }
            case 492425189: {
                return this.getNormal_range();
            }
            case -1668425831: {
                return this.addOther_reference_ranges();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1868886454: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
            case 492425189: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-INTERVAL"};
            }
            case -1668425831: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/REFERENCE-RANGE"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("normal_status")) {
            this.normal_status = new CODE_PHRASE();
            return this.normal_status;
        }
        if (name.equals("normal_range")) {
            this.normal_range = new DV_INTERVAL();
            return this.normal_range;
        }
        if (name.equals("other_reference_ranges")) {
            return this.addOther_reference_ranges();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_ORDERED";
    }

    @Override
    public abstract DV_ORDERED copy();

    public void copyValues(DV_ORDERED dst) {
        super.copyValues(dst);
        dst.normal_status = this.normal_status == null ? null : this.normal_status.copy();
        DV_INTERVAL dV_INTERVAL = dst.normal_range = this.normal_range == null ? null : this.normal_range.copy();
        if (this.other_reference_rangesList != null) {
            dst.other_reference_rangesList = new ArrayList<REFERENCE_RANGE>();
            for (REFERENCE_RANGE i : this.other_reference_rangesList) {
                dst.other_reference_rangesList.add(i.copy());
            }
        }
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_ORDERED)) {
            return false;
        }
        DV_ORDERED o = (DV_ORDERED)other_;
        return DV_ORDERED.compareDeep(this.normal_status, o.normal_status, true) && DV_ORDERED.compareDeep(this.normal_range, o.normal_range, true) && DV_ORDERED.compareDeep(this.other_reference_rangesList, o.other_reference_rangesList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_ORDERED)) {
            return false;
        }
        DV_ORDERED o = (DV_ORDERED)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.normal_status, this.normal_range, this.other_reference_rangesList});
    }
}

