/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_ENCAPSULATED;

@DatatypeDef(name="DV_PARSABLE")
public class DV_PARSABLE
extends DV_ENCAPSULATED
implements ICompositeType {
    @Child(name="value", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The string, which may validly be empty in some syntaxes", formalDefinition="The string, which may validly be empty in some syntaxes.")
    protected StringType value;
    @Child(name="formalism", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of the formalism, e.g. GLIF 1.0 , Proforma etc", formalDefinition="Name of the formalism, e.g. GLIF 1.0 , Proforma etc.")
    protected StringType formalism;
    private static final long serialVersionUID = -1693649635L;

    public DV_PARSABLE() {
    }

    public DV_PARSABLE(String value, String formalism) {
        this.setValue(value);
        this.setFormalism(formalism);
    }

    public StringType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_PARSABLE.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new StringType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public DV_PARSABLE setValueElement(StringType value) {
        this.value = value;
        return this;
    }

    public String getValue() {
        return this.value == null ? null : (String)this.value.getValue();
    }

    public DV_PARSABLE setValue(String value) {
        if (this.value == null) {
            this.value = new StringType();
        }
        this.value.setValue(value);
        return this;
    }

    public StringType getFormalismElement() {
        if (this.formalism == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_PARSABLE.formalism");
            }
            if (Configuration.doAutoCreate()) {
                this.formalism = new StringType();
            }
        }
        return this.formalism;
    }

    public boolean hasFormalismElement() {
        return this.formalism != null && !this.formalism.isEmpty();
    }

    public boolean hasFormalism() {
        return this.formalism != null && !this.formalism.isEmpty();
    }

    public DV_PARSABLE setFormalismElement(StringType value) {
        this.formalism = value;
        return this;
    }

    public String getFormalism() {
        return this.formalism == null ? null : (String)this.formalism.getValue();
    }

    public DV_PARSABLE setFormalism(String value) {
        if (this.formalism == null) {
            this.formalism = new StringType();
        }
        this.formalism.setValue(value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("value", "string", "The string, which may validly be empty in some syntaxes.", 0, 1, this.value));
        children.add(new Property("formalism", "string", "Name of the formalism, e.g. GLIF 1.0 , Proforma etc.", 0, 1, this.formalism));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 111972721: {
                return new Property("value", "string", "The string, which may validly be empty in some syntaxes.", 0, 1, this.value);
            }
            case 1811342900: {
                return new Property("formalism", "string", "Name of the formalism, e.g. GLIF 1.0 , Proforma etc.", 0, 1, this.formalism);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.value;
                }
                return baseArray;
            }
            case 1811342900: {
                Base[] baseArray;
                if (this.formalism == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.formalism;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 111972721: {
                this.value = TypeConvertor.castToString(value);
                return value;
            }
            case 1811342900: {
                this.formalism = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("value")) {
            this.value = TypeConvertor.castToString(value);
        } else if (name.equals("formalism")) {
            this.formalism = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return this.getValueElement();
            }
            case 1811342900: {
                return this.getFormalismElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return new String[]{"string"};
            }
            case 1811342900: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_PARSABLE.value");
        }
        if (name.equals("formalism")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_PARSABLE.formalism");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_PARSABLE";
    }

    @Override
    public DV_PARSABLE copy() {
        DV_PARSABLE dst = new DV_PARSABLE();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_PARSABLE dst) {
        super.copyValues(dst);
        dst.value = this.value == null ? null : this.value.copy();
        dst.formalism = this.formalism == null ? null : this.formalism.copy();
    }

    protected DV_PARSABLE typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_PARSABLE)) {
            return false;
        }
        DV_PARSABLE o = (DV_PARSABLE)other_;
        return DV_PARSABLE.compareDeep(this.value, o.value, true) && DV_PARSABLE.compareDeep(this.formalism, o.formalism, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_PARSABLE)) {
            return false;
        }
        DV_PARSABLE o = (DV_PARSABLE)other_;
        return DV_PARSABLE.compareValues(this.value, o.value, true) && DV_PARSABLE.compareValues(this.formalism, o.formalism, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value, this.formalism});
    }
}

