/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.CODE_PHRASE;
import org.hl7.fhir.r5.openehr.DATA_VALUE;
import org.hl7.fhir.r5.openehr.DV_URI;
import org.hl7.fhir.r5.openehr.TERM_MAPPING;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="DV_TEXT")
public class DV_TEXT
extends DATA_VALUE
implements ICompositeType {
    @Child(name="value", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Displayable rendition of the item, regardless of its underlying structure", formalDefinition="Displayable rendition of the item, regardless of its underlying structure. For DV_CODED_TEXT, this is the rubric of the complete term as provided by the terminology service.")
    protected StringType value;
    @Child(name="hyperlink", type={DV_URI.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="DEPRECATED: this field is deprecated; use markdown", formalDefinition="DEPRECATED: this field is deprecated; use markdown link/text in the value attribute, and 'markdown' as the value of the formatting field.")
    protected DV_URI hyperlink;
    @Child(name="formatting", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="plain | plain_no_newlines | markdown", formalDefinition="If set, contains one of the following values:\n\n'plain': use for plain text, possibly containing newlines, but otherwise unformatted (same as Void);\n* 'plain_no_newlines': use for text containing no newlines or other formatting;\n* 'markdown': use for markdown formatted text, strongly recommended in the format of the CommonMark specification.\n\nDEPRECATED usage: contains a string of the form ```'name:value; name:value\u2026\u200b'``` , e.g. ```'font-weight : bold; font-family : Arial; font-size : 12pt;'```. Values taken from W3C CSS2 properties lists for background and font")
    protected StringType formatting;
    @Child(name="mappings", type={TERM_MAPPING.class}, order=3, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Terms from other terminologies most closely matching this term", formalDefinition="Terms from other terminologies most closely matching this term, typically used where the originator (e.g. pathology lab) of information uses a local terminology but also supplies one or more equivalents from well known terminologies (e.g. LOINC).")
    protected List<TERM_MAPPING> mappingsList;
    @Child(name="language", type={CODE_PHRASE.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional indicator of the localised language in which the value is written", formalDefinition="Optional indicator of the localised language in which the value is written. Coded from openEHR Code Set languages . Only used when either the text object is in a different language from the enclosing ENTRY, or else the text object is being used outside of an ENTRY or other enclosing structure which indicates the language.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-languages")
    protected CODE_PHRASE language;
    @Child(name="encoding", type={CODE_PHRASE.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of character encoding scheme in which this value is encoded", formalDefinition="Name of character encoding scheme in which this value is encoded. Coded from openEHR Code Set character sets . Unicode is the default assumption in openEHR, with UTF-8 being the assumed encoding. This attribute allows for variations from these assumptions.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-character_sets")
    protected CODE_PHRASE encoding;
    private static final long serialVersionUID = 1126979256L;

    public DV_TEXT() {
    }

    public DV_TEXT(String value, TERM_MAPPING mappings) {
        this.setValue(value);
        this.addMappings(mappings);
    }

    public StringType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_TEXT.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new StringType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public DV_TEXT setValueElement(StringType value) {
        this.value = value;
        return this;
    }

    public String getValue() {
        return this.value == null ? null : (String)this.value.getValue();
    }

    public DV_TEXT setValue(String value) {
        if (this.value == null) {
            this.value = new StringType();
        }
        this.value.setValue(value);
        return this;
    }

    public DV_URI getHyperlink() {
        if (this.hyperlink == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_TEXT.hyperlink");
            }
            if (Configuration.doAutoCreate()) {
                this.hyperlink = new DV_URI();
            }
        }
        return this.hyperlink;
    }

    public boolean hasHyperlink() {
        return this.hyperlink != null && !this.hyperlink.isEmpty();
    }

    public DV_TEXT setHyperlink(DV_URI value) {
        this.hyperlink = value;
        return this;
    }

    public StringType getFormattingElement() {
        if (this.formatting == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_TEXT.formatting");
            }
            if (Configuration.doAutoCreate()) {
                this.formatting = new StringType();
            }
        }
        return this.formatting;
    }

    public boolean hasFormattingElement() {
        return this.formatting != null && !this.formatting.isEmpty();
    }

    public boolean hasFormatting() {
        return this.formatting != null && !this.formatting.isEmpty();
    }

    public DV_TEXT setFormattingElement(StringType value) {
        this.formatting = value;
        return this;
    }

    public String getFormatting() {
        return this.formatting == null ? null : (String)this.formatting.getValue();
    }

    public DV_TEXT setFormatting(String value) {
        if (Utilities.noString((String)value)) {
            this.formatting = null;
        } else {
            if (this.formatting == null) {
                this.formatting = new StringType();
            }
            this.formatting.setValue(value);
        }
        return this;
    }

    public List<TERM_MAPPING> getMappingsList() {
        if (this.mappingsList == null) {
            this.mappingsList = new ArrayList<TERM_MAPPING>();
        }
        return this.mappingsList;
    }

    public DV_TEXT setMappingsList(List<TERM_MAPPING> theMappings) {
        this.mappingsList = theMappings;
        return this;
    }

    public boolean hasMappings() {
        if (this.mappingsList == null) {
            return false;
        }
        for (TERM_MAPPING item : this.mappingsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TERM_MAPPING addMappings() {
        TERM_MAPPING t = new TERM_MAPPING();
        if (this.mappingsList == null) {
            this.mappingsList = new ArrayList<TERM_MAPPING>();
        }
        this.mappingsList.add(t);
        return t;
    }

    public DV_TEXT addMappings(TERM_MAPPING t) {
        if (t == null) {
            return this;
        }
        if (this.mappingsList == null) {
            this.mappingsList = new ArrayList<TERM_MAPPING>();
        }
        this.mappingsList.add(t);
        return this;
    }

    public TERM_MAPPING getMappingsFirstRep() {
        if (this.getMappingsList().isEmpty()) {
            this.addMappings();
        }
        return this.getMappingsList().get(0);
    }

    public CODE_PHRASE getLanguage() {
        if (this.language == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_TEXT.language");
            }
            if (Configuration.doAutoCreate()) {
                this.language = new CODE_PHRASE();
            }
        }
        return this.language;
    }

    public boolean hasLanguage() {
        return this.language != null && !this.language.isEmpty();
    }

    public DV_TEXT setLanguage(CODE_PHRASE value) {
        this.language = value;
        return this;
    }

    public CODE_PHRASE getEncoding() {
        if (this.encoding == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_TEXT.encoding");
            }
            if (Configuration.doAutoCreate()) {
                this.encoding = new CODE_PHRASE();
            }
        }
        return this.encoding;
    }

    public boolean hasEncoding() {
        return this.encoding != null && !this.encoding.isEmpty();
    }

    public DV_TEXT setEncoding(CODE_PHRASE value) {
        this.encoding = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("value", "string", "Displayable rendition of the item, regardless of its underlying structure. For DV_CODED_TEXT, this is the rubric of the complete term as provided by the terminology service.", 0, 1, this.value));
        children.add(new Property("hyperlink", "http://openehr.org/fhir/StructureDefinition/DV-URI", "DEPRECATED: this field is deprecated; use markdown link/text in the value attribute, and 'markdown' as the value of the formatting field.", 0, 1, this.hyperlink));
        children.add(new Property("formatting", "string", "If set, contains one of the following values:\n\n'plain': use for plain text, possibly containing newlines, but otherwise unformatted (same as Void);\n* 'plain_no_newlines': use for text containing no newlines or other formatting;\n* 'markdown': use for markdown formatted text, strongly recommended in the format of the CommonMark specification.\n\nDEPRECATED usage: contains a string of the form ```'name:value; name:value\u2026\u200b'``` , e.g. ```'font-weight : bold; font-family : Arial; font-size : 12pt;'```. Values taken from W3C CSS2 properties lists for background and font", 0, 1, this.formatting));
        children.add(new Property("mappings", "http://openehr.org/fhir/StructureDefinition/TERM-MAPPING", "Terms from other terminologies most closely matching this term, typically used where the originator (e.g. pathology lab) of information uses a local terminology but also supplies one or more equivalents from well known terminologies (e.g. LOINC).", 0, Integer.MAX_VALUE, this.mappingsList));
        children.add(new Property("language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Optional indicator of the localised language in which the value is written. Coded from openEHR Code Set languages . Only used when either the text object is in a different language from the enclosing ENTRY, or else the text object is being used outside of an ENTRY or other enclosing structure which indicates the language.", 0, 1, this.language));
        children.add(new Property("encoding", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Name of character encoding scheme in which this value is encoded. Coded from openEHR Code Set character sets . Unicode is the default assumption in openEHR, with UTF-8 being the assumed encoding. This attribute allows for variations from these assumptions.", 0, 1, this.encoding));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 111972721: {
                return new Property("value", "string", "Displayable rendition of the item, regardless of its underlying structure. For DV_CODED_TEXT, this is the rubric of the complete term as provided by the terminology service.", 0, 1, this.value);
            }
            case 751294566: {
                return new Property("hyperlink", "http://openehr.org/fhir/StructureDefinition/DV-URI", "DEPRECATED: this field is deprecated; use markdown link/text in the value attribute, and 'markdown' as the value of the formatting field.", 0, 1, this.hyperlink);
            }
            case 324761445: {
                return new Property("formatting", "string", "If set, contains one of the following values:\n\n'plain': use for plain text, possibly containing newlines, but otherwise unformatted (same as Void);\n* 'plain_no_newlines': use for text containing no newlines or other formatting;\n* 'markdown': use for markdown formatted text, strongly recommended in the format of the CommonMark specification.\n\nDEPRECATED usage: contains a string of the form ```'name:value; name:value\u2026\u200b'``` , e.g. ```'font-weight : bold; font-family : Arial; font-size : 12pt;'```. Values taken from W3C CSS2 properties lists for background and font", 0, 1, this.formatting);
            }
            case 194445669: {
                return new Property("mappings", "http://openehr.org/fhir/StructureDefinition/TERM-MAPPING", "Terms from other terminologies most closely matching this term, typically used where the originator (e.g. pathology lab) of information uses a local terminology but also supplies one or more equivalents from well known terminologies (e.g. LOINC).", 0, Integer.MAX_VALUE, this.mappingsList);
            }
            case -1613589672: {
                return new Property("language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Optional indicator of the localised language in which the value is written. Coded from openEHR Code Set languages . Only used when either the text object is in a different language from the enclosing ENTRY, or else the text object is being used outside of an ENTRY or other enclosing structure which indicates the language.", 0, 1, this.language);
            }
            case 1711222099: {
                return new Property("encoding", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Name of character encoding scheme in which this value is encoded. Coded from openEHR Code Set character sets . Unicode is the default assumption in openEHR, with UTF-8 being the assumed encoding. This attribute allows for variations from these assumptions.", 0, 1, this.encoding);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.value;
                }
                return baseArray;
            }
            case 751294566: {
                Base[] baseArray;
                if (this.hyperlink == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.hyperlink;
                }
                return baseArray;
            }
            case 324761445: {
                Base[] baseArray;
                if (this.formatting == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.formatting;
                }
                return baseArray;
            }
            case 194445669: {
                return this.mappingsList == null ? new Base[]{} : this.mappingsList.toArray(new Base[this.mappingsList.size()]);
            }
            case -1613589672: {
                Base[] baseArray;
                if (this.language == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.language;
                }
                return baseArray;
            }
            case 1711222099: {
                Base[] baseArray;
                if (this.encoding == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.encoding;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 111972721: {
                this.value = TypeConvertor.castToString(value);
                return value;
            }
            case 751294566: {
                this.hyperlink = (DV_URI)value;
                return value;
            }
            case 324761445: {
                this.formatting = TypeConvertor.castToString(value);
                return value;
            }
            case 194445669: {
                this.getMappingsList().add((TERM_MAPPING)value);
                return value;
            }
            case -1613589672: {
                this.language = (CODE_PHRASE)value;
                return value;
            }
            case 1711222099: {
                this.encoding = (CODE_PHRASE)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("value")) {
            this.value = TypeConvertor.castToString(value);
        } else if (name.equals("hyperlink")) {
            this.hyperlink = (DV_URI)value;
        } else if (name.equals("formatting")) {
            this.formatting = TypeConvertor.castToString(value);
        } else if (name.equals("mappings")) {
            this.getMappingsList().add((TERM_MAPPING)value);
        } else if (name.equals("language")) {
            this.language = (CODE_PHRASE)value;
        } else if (name.equals("encoding")) {
            this.encoding = (CODE_PHRASE)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return this.getValueElement();
            }
            case 751294566: {
                return this.getHyperlink();
            }
            case 324761445: {
                return this.getFormattingElement();
            }
            case 194445669: {
                return this.addMappings();
            }
            case -1613589672: {
                return this.getLanguage();
            }
            case 1711222099: {
                return this.getEncoding();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return new String[]{"string"};
            }
            case 751294566: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-URI"};
            }
            case 324761445: {
                return new String[]{"string"};
            }
            case 194445669: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/TERM-MAPPING"};
            }
            case -1613589672: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
            case 1711222099: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_TEXT.value");
        }
        if (name.equals("hyperlink")) {
            this.hyperlink = new DV_URI();
            return this.hyperlink;
        }
        if (name.equals("formatting")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_TEXT.formatting");
        }
        if (name.equals("mappings")) {
            return this.addMappings();
        }
        if (name.equals("language")) {
            this.language = new CODE_PHRASE();
            return this.language;
        }
        if (name.equals("encoding")) {
            this.encoding = new CODE_PHRASE();
            return this.encoding;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_TEXT";
    }

    @Override
    public DV_TEXT copy() {
        DV_TEXT dst = new DV_TEXT();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_TEXT dst) {
        super.copyValues(dst);
        dst.value = this.value == null ? null : this.value.copy();
        dst.hyperlink = this.hyperlink == null ? null : this.hyperlink.copy();
        StringType stringType = dst.formatting = this.formatting == null ? null : this.formatting.copy();
        if (this.mappingsList != null) {
            dst.mappingsList = new ArrayList<TERM_MAPPING>();
            for (TERM_MAPPING i : this.mappingsList) {
                dst.mappingsList.add(i.copy());
            }
        }
        dst.language = this.language == null ? null : this.language.copy();
        dst.encoding = this.encoding == null ? null : this.encoding.copy();
    }

    protected DV_TEXT typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_TEXT)) {
            return false;
        }
        DV_TEXT o = (DV_TEXT)other_;
        return DV_TEXT.compareDeep(this.value, o.value, true) && DV_TEXT.compareDeep(this.hyperlink, o.hyperlink, true) && DV_TEXT.compareDeep(this.formatting, o.formatting, true) && DV_TEXT.compareDeep(this.mappingsList, o.mappingsList, true) && DV_TEXT.compareDeep(this.language, o.language, true) && DV_TEXT.compareDeep(this.encoding, o.encoding, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_TEXT)) {
            return false;
        }
        DV_TEXT o = (DV_TEXT)other_;
        return DV_TEXT.compareValues(this.value, o.value, true) && DV_TEXT.compareValues(this.formatting, o.formatting, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.value, this.hyperlink, this.formatting, this.mappingsList, this.language, this.encoding});
    }
}

