/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.Any;
import org.hl7.fhir.r5.openehr.DV_DATE_TIME;
import org.hl7.fhir.r5.openehr.HIER_OBJECT_ID;
import org.hl7.fhir.r5.openehr.OBJECT_REF;

@DatatypeDef(name="EHR")
public class EHR
extends Any
implements ICompositeType {
    @Child(name="system_id", type={HIER_OBJECT_ID.class}, order=0, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The identifier of the logical EHR management system in which this EHR was created", formalDefinition="The identifier of the logical EHR management system in which this EHR was created.")
    protected List<HIER_OBJECT_ID> system_idList;
    @Child(name="ehr_id", type={HIER_OBJECT_ID.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The unique identifier of this EHR", formalDefinition="The unique identifier of this EHR. NOTE: it is strongly recommended that a UUID always be used for this field.")
    protected HIER_OBJECT_ID ehr_id;
    @Child(name="contributions", type={OBJECT_REF.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of contributions causing changes to this EHR", formalDefinition="List of contributions causing changes to this EHR. Each contribution contains a list of versions, which may include references to any number of VERSION instances, i.e. items of type VERSIONED_COMPOSITION and VERSIONED_FOLDER.")
    protected List<OBJECT_REF> contributionsList;
    @Child(name="ehr_status", type={OBJECT_REF.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to EHR_STATUS object for this EHR", formalDefinition="Reference to EHR_STATUS object for this EHR.")
    protected OBJECT_REF ehr_status;
    @Child(name="ehr_access", type={OBJECT_REF.class}, order=4, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to EHR_ACCESS object for this EH", formalDefinition="Reference to EHR_ACCESS object for this EHR.")
    protected OBJECT_REF ehr_access;
    @Child(name="compositions", type={OBJECT_REF.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Master list of all Versioned Composition references in this EHR", formalDefinition="Master list of all Versioned Composition references in this EHR.")
    protected List<OBJECT_REF> compositionsList;
    @Child(name="directory", type={OBJECT_REF.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional directory structure for this EHR. If present, this is a reference to the first member of folders", formalDefinition="Optional directory structure for this EHR. If present, this is a reference to the first member of folders.")
    protected OBJECT_REF directory;
    @Child(name="time_created", type={DV_DATE_TIME.class}, order=7, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time of creation of the EHR", formalDefinition="Time of creation of the EHR.")
    protected DV_DATE_TIME time_created;
    @Child(name="folders", type={OBJECT_REF.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Optional additional Folder structures for this EHR", formalDefinition="Optional additional Folder structures for this EHR. If set, the directory attribute refers to the first member")
    protected List<OBJECT_REF> foldersList;
    @Child(name="tags", type={OBJECT_REF.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Optional list of tags associated with this EHR", formalDefinition="Optional list of tags associated with this EHR. Tag target values can only be within the same EHR.")
    protected List<OBJECT_REF> tagsList;
    private static final long serialVersionUID = 1319457127L;

    public EHR() {
    }

    public EHR(HIER_OBJECT_ID system_id, HIER_OBJECT_ID ehr_id, OBJECT_REF ehr_status, OBJECT_REF ehr_access, DV_DATE_TIME time_created) {
        this.addSystem_id(system_id);
        this.setEhr_id(ehr_id);
        this.setEhr_status(ehr_status);
        this.setEhr_access(ehr_access);
        this.setTime_created(time_created);
    }

    public List<HIER_OBJECT_ID> getSystem_idList() {
        if (this.system_idList == null) {
            this.system_idList = new ArrayList<HIER_OBJECT_ID>();
        }
        return this.system_idList;
    }

    public EHR setSystem_idList(List<HIER_OBJECT_ID> theSystem_id) {
        this.system_idList = theSystem_id;
        return this;
    }

    public boolean hasSystem_id() {
        if (this.system_idList == null) {
            return false;
        }
        for (HIER_OBJECT_ID item : this.system_idList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HIER_OBJECT_ID addSystem_id() {
        HIER_OBJECT_ID t = new HIER_OBJECT_ID();
        if (this.system_idList == null) {
            this.system_idList = new ArrayList<HIER_OBJECT_ID>();
        }
        this.system_idList.add(t);
        return t;
    }

    public EHR addSystem_id(HIER_OBJECT_ID t) {
        if (t == null) {
            return this;
        }
        if (this.system_idList == null) {
            this.system_idList = new ArrayList<HIER_OBJECT_ID>();
        }
        this.system_idList.add(t);
        return this;
    }

    public HIER_OBJECT_ID getSystem_idFirstRep() {
        if (this.getSystem_idList().isEmpty()) {
            this.addSystem_id();
        }
        return this.getSystem_idList().get(0);
    }

    public HIER_OBJECT_ID getEhr_id() {
        if (this.ehr_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EHR.ehr_id");
            }
            if (Configuration.doAutoCreate()) {
                this.ehr_id = new HIER_OBJECT_ID();
            }
        }
        return this.ehr_id;
    }

    public boolean hasEhr_id() {
        return this.ehr_id != null && !this.ehr_id.isEmpty();
    }

    public EHR setEhr_id(HIER_OBJECT_ID value) {
        this.ehr_id = value;
        return this;
    }

    public List<OBJECT_REF> getContributionsList() {
        if (this.contributionsList == null) {
            this.contributionsList = new ArrayList<OBJECT_REF>();
        }
        return this.contributionsList;
    }

    public EHR setContributionsList(List<OBJECT_REF> theContributions) {
        this.contributionsList = theContributions;
        return this;
    }

    public boolean hasContributions() {
        if (this.contributionsList == null) {
            return false;
        }
        for (OBJECT_REF item : this.contributionsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OBJECT_REF addContributions() {
        OBJECT_REF t = new OBJECT_REF();
        if (this.contributionsList == null) {
            this.contributionsList = new ArrayList<OBJECT_REF>();
        }
        this.contributionsList.add(t);
        return t;
    }

    public EHR addContributions(OBJECT_REF t) {
        if (t == null) {
            return this;
        }
        if (this.contributionsList == null) {
            this.contributionsList = new ArrayList<OBJECT_REF>();
        }
        this.contributionsList.add(t);
        return this;
    }

    public OBJECT_REF getContributionsFirstRep() {
        if (this.getContributionsList().isEmpty()) {
            this.addContributions();
        }
        return this.getContributionsList().get(0);
    }

    public OBJECT_REF getEhr_status() {
        if (this.ehr_status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EHR.ehr_status");
            }
            if (Configuration.doAutoCreate()) {
                this.ehr_status = new OBJECT_REF();
            }
        }
        return this.ehr_status;
    }

    public boolean hasEhr_status() {
        return this.ehr_status != null && !this.ehr_status.isEmpty();
    }

    public EHR setEhr_status(OBJECT_REF value) {
        this.ehr_status = value;
        return this;
    }

    public OBJECT_REF getEhr_access() {
        if (this.ehr_access == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EHR.ehr_access");
            }
            if (Configuration.doAutoCreate()) {
                this.ehr_access = new OBJECT_REF();
            }
        }
        return this.ehr_access;
    }

    public boolean hasEhr_access() {
        return this.ehr_access != null && !this.ehr_access.isEmpty();
    }

    public EHR setEhr_access(OBJECT_REF value) {
        this.ehr_access = value;
        return this;
    }

    public List<OBJECT_REF> getCompositionsList() {
        if (this.compositionsList == null) {
            this.compositionsList = new ArrayList<OBJECT_REF>();
        }
        return this.compositionsList;
    }

    public EHR setCompositionsList(List<OBJECT_REF> theCompositions) {
        this.compositionsList = theCompositions;
        return this;
    }

    public boolean hasCompositions() {
        if (this.compositionsList == null) {
            return false;
        }
        for (OBJECT_REF item : this.compositionsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OBJECT_REF addCompositions() {
        OBJECT_REF t = new OBJECT_REF();
        if (this.compositionsList == null) {
            this.compositionsList = new ArrayList<OBJECT_REF>();
        }
        this.compositionsList.add(t);
        return t;
    }

    public EHR addCompositions(OBJECT_REF t) {
        if (t == null) {
            return this;
        }
        if (this.compositionsList == null) {
            this.compositionsList = new ArrayList<OBJECT_REF>();
        }
        this.compositionsList.add(t);
        return this;
    }

    public OBJECT_REF getCompositionsFirstRep() {
        if (this.getCompositionsList().isEmpty()) {
            this.addCompositions();
        }
        return this.getCompositionsList().get(0);
    }

    public OBJECT_REF getDirectory() {
        if (this.directory == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EHR.directory");
            }
            if (Configuration.doAutoCreate()) {
                this.directory = new OBJECT_REF();
            }
        }
        return this.directory;
    }

    public boolean hasDirectory() {
        return this.directory != null && !this.directory.isEmpty();
    }

    public EHR setDirectory(OBJECT_REF value) {
        this.directory = value;
        return this;
    }

    public DV_DATE_TIME getTime_created() {
        if (this.time_created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EHR.time_created");
            }
            if (Configuration.doAutoCreate()) {
                this.time_created = new DV_DATE_TIME();
            }
        }
        return this.time_created;
    }

    public boolean hasTime_created() {
        return this.time_created != null && !this.time_created.isEmpty();
    }

    public EHR setTime_created(DV_DATE_TIME value) {
        this.time_created = value;
        return this;
    }

    public List<OBJECT_REF> getFoldersList() {
        if (this.foldersList == null) {
            this.foldersList = new ArrayList<OBJECT_REF>();
        }
        return this.foldersList;
    }

    public EHR setFoldersList(List<OBJECT_REF> theFolders) {
        this.foldersList = theFolders;
        return this;
    }

    public boolean hasFolders() {
        if (this.foldersList == null) {
            return false;
        }
        for (OBJECT_REF item : this.foldersList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OBJECT_REF addFolders() {
        OBJECT_REF t = new OBJECT_REF();
        if (this.foldersList == null) {
            this.foldersList = new ArrayList<OBJECT_REF>();
        }
        this.foldersList.add(t);
        return t;
    }

    public EHR addFolders(OBJECT_REF t) {
        if (t == null) {
            return this;
        }
        if (this.foldersList == null) {
            this.foldersList = new ArrayList<OBJECT_REF>();
        }
        this.foldersList.add(t);
        return this;
    }

    public OBJECT_REF getFoldersFirstRep() {
        if (this.getFoldersList().isEmpty()) {
            this.addFolders();
        }
        return this.getFoldersList().get(0);
    }

    public List<OBJECT_REF> getTagsList() {
        if (this.tagsList == null) {
            this.tagsList = new ArrayList<OBJECT_REF>();
        }
        return this.tagsList;
    }

    public EHR setTagsList(List<OBJECT_REF> theTags) {
        this.tagsList = theTags;
        return this;
    }

    public boolean hasTags() {
        if (this.tagsList == null) {
            return false;
        }
        for (OBJECT_REF item : this.tagsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OBJECT_REF addTags() {
        OBJECT_REF t = new OBJECT_REF();
        if (this.tagsList == null) {
            this.tagsList = new ArrayList<OBJECT_REF>();
        }
        this.tagsList.add(t);
        return t;
    }

    public EHR addTags(OBJECT_REF t) {
        if (t == null) {
            return this;
        }
        if (this.tagsList == null) {
            this.tagsList = new ArrayList<OBJECT_REF>();
        }
        this.tagsList.add(t);
        return this;
    }

    public OBJECT_REF getTagsFirstRep() {
        if (this.getTagsList().isEmpty()) {
            this.addTags();
        }
        return this.getTagsList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("system_id", "http://openehr.org/fhir/StructureDefinition/HIER-OBJECT-ID", "The identifier of the logical EHR management system in which this EHR was created.", 0, Integer.MAX_VALUE, this.system_idList));
        children.add(new Property("ehr_id", "http://openehr.org/fhir/StructureDefinition/HIER-OBJECT-ID", "The unique identifier of this EHR. NOTE: it is strongly recommended that a UUID always be used for this field.", 0, 1, this.ehr_id));
        children.add(new Property("contributions", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "List of contributions causing changes to this EHR. Each contribution contains a list of versions, which may include references to any number of VERSION instances, i.e. items of type VERSIONED_COMPOSITION and VERSIONED_FOLDER.", 0, Integer.MAX_VALUE, this.contributionsList));
        children.add(new Property("ehr_status", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Reference to EHR_STATUS object for this EHR.", 0, 1, this.ehr_status));
        children.add(new Property("ehr_access", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Reference to EHR_ACCESS object for this EHR.", 0, 1, this.ehr_access));
        children.add(new Property("compositions", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Master list of all Versioned Composition references in this EHR.", 0, Integer.MAX_VALUE, this.compositionsList));
        children.add(new Property("directory", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Optional directory structure for this EHR. If present, this is a reference to the first member of folders.", 0, 1, this.directory));
        children.add(new Property("time_created", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Time of creation of the EHR.", 0, 1, this.time_created));
        children.add(new Property("folders", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Optional additional Folder structures for this EHR. If set, the directory attribute refers to the first member", 0, Integer.MAX_VALUE, this.foldersList));
        children.add(new Property("tags", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Optional list of tags associated with this EHR. Tag target values can only be within the same EHR.", 0, Integer.MAX_VALUE, this.tagsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1129127211: {
                return new Property("system_id", "http://openehr.org/fhir/StructureDefinition/HIER-OBJECT-ID", "The identifier of the logical EHR management system in which this EHR was created.", 0, Integer.MAX_VALUE, this.system_idList);
            }
            case -1303886037: {
                return new Property("ehr_id", "http://openehr.org/fhir/StructureDefinition/HIER-OBJECT-ID", "The unique identifier of this EHR. NOTE: it is strongly recommended that a UUID always be used for this field.", 0, 1, this.ehr_id);
            }
            case -294592925: {
                return new Property("contributions", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "List of contributions causing changes to this EHR. Each contribution contains a list of versions, which may include references to any number of VERSION instances, i.e. items of type VERSIONED_COMPOSITION and VERSIONED_FOLDER.", 0, Integer.MAX_VALUE, this.contributionsList);
            }
            case 1263174146: {
                return new Property("ehr_status", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Reference to EHR_STATUS object for this EHR.", 0, 1, this.ehr_status);
            }
            case 732194676: {
                return new Property("ehr_access", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Reference to EHR_ACCESS object for this EHR.", 0, 1, this.ehr_access);
            }
            case -236835831: {
                return new Property("compositions", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Master list of all Versioned Composition references in this EHR.", 0, Integer.MAX_VALUE, this.compositionsList);
            }
            case -962584979: {
                return new Property("directory", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Optional directory structure for this EHR. If present, this is a reference to the first member of folders.", 0, 1, this.directory);
            }
            case -630236298: {
                return new Property("time_created", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Time of creation of the EHR.", 0, 1, this.time_created);
            }
            case -683249211: {
                return new Property("folders", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Optional additional Folder structures for this EHR. If set, the directory attribute refers to the first member", 0, Integer.MAX_VALUE, this.foldersList);
            }
            case 3552281: {
                return new Property("tags", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Optional list of tags associated with this EHR. Tag target values can only be within the same EHR.", 0, Integer.MAX_VALUE, this.tagsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1129127211: {
                return this.system_idList == null ? new Base[]{} : this.system_idList.toArray(new Base[this.system_idList.size()]);
            }
            case -1303886037: {
                Base[] baseArray;
                if (this.ehr_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.ehr_id;
                }
                return baseArray;
            }
            case -294592925: {
                return this.contributionsList == null ? new Base[]{} : this.contributionsList.toArray(new Base[this.contributionsList.size()]);
            }
            case 1263174146: {
                Base[] baseArray;
                if (this.ehr_status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.ehr_status;
                }
                return baseArray;
            }
            case 732194676: {
                Base[] baseArray;
                if (this.ehr_access == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.ehr_access;
                }
                return baseArray;
            }
            case -236835831: {
                return this.compositionsList == null ? new Base[]{} : this.compositionsList.toArray(new Base[this.compositionsList.size()]);
            }
            case -962584979: {
                Base[] baseArray;
                if (this.directory == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.directory;
                }
                return baseArray;
            }
            case -630236298: {
                Base[] baseArray;
                if (this.time_created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.time_created;
                }
                return baseArray;
            }
            case -683249211: {
                return this.foldersList == null ? new Base[]{} : this.foldersList.toArray(new Base[this.foldersList.size()]);
            }
            case 3552281: {
                return this.tagsList == null ? new Base[]{} : this.tagsList.toArray(new Base[this.tagsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1129127211: {
                this.getSystem_idList().add((HIER_OBJECT_ID)value);
                return value;
            }
            case -1303886037: {
                this.ehr_id = (HIER_OBJECT_ID)value;
                return value;
            }
            case -294592925: {
                this.getContributionsList().add((OBJECT_REF)value);
                return value;
            }
            case 1263174146: {
                this.ehr_status = (OBJECT_REF)value;
                return value;
            }
            case 732194676: {
                this.ehr_access = (OBJECT_REF)value;
                return value;
            }
            case -236835831: {
                this.getCompositionsList().add((OBJECT_REF)value);
                return value;
            }
            case -962584979: {
                this.directory = (OBJECT_REF)value;
                return value;
            }
            case -630236298: {
                this.time_created = (DV_DATE_TIME)value;
                return value;
            }
            case -683249211: {
                this.getFoldersList().add((OBJECT_REF)value);
                return value;
            }
            case 3552281: {
                this.getTagsList().add((OBJECT_REF)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("system_id")) {
            this.getSystem_idList().add((HIER_OBJECT_ID)value);
        } else if (name.equals("ehr_id")) {
            this.ehr_id = (HIER_OBJECT_ID)value;
        } else if (name.equals("contributions")) {
            this.getContributionsList().add((OBJECT_REF)value);
        } else if (name.equals("ehr_status")) {
            this.ehr_status = (OBJECT_REF)value;
        } else if (name.equals("ehr_access")) {
            this.ehr_access = (OBJECT_REF)value;
        } else if (name.equals("compositions")) {
            this.getCompositionsList().add((OBJECT_REF)value);
        } else if (name.equals("directory")) {
            this.directory = (OBJECT_REF)value;
        } else if (name.equals("time_created")) {
            this.time_created = (DV_DATE_TIME)value;
        } else if (name.equals("folders")) {
            this.getFoldersList().add((OBJECT_REF)value);
        } else if (name.equals("tags")) {
            this.getTagsList().add((OBJECT_REF)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1129127211: {
                return this.addSystem_id();
            }
            case -1303886037: {
                return this.getEhr_id();
            }
            case -294592925: {
                return this.addContributions();
            }
            case 1263174146: {
                return this.getEhr_status();
            }
            case 732194676: {
                return this.getEhr_access();
            }
            case -236835831: {
                return this.addCompositions();
            }
            case -962584979: {
                return this.getDirectory();
            }
            case -630236298: {
                return this.getTime_created();
            }
            case -683249211: {
                return this.addFolders();
            }
            case 3552281: {
                return this.addTags();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1129127211: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/HIER-OBJECT-ID"};
            }
            case -1303886037: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/HIER-OBJECT-ID"};
            }
            case -294592925: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
            case 1263174146: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
            case 732194676: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
            case -236835831: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
            case -962584979: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
            case -630236298: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME"};
            }
            case -683249211: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
            case 3552281: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("system_id")) {
            return this.addSystem_id();
        }
        if (name.equals("ehr_id")) {
            this.ehr_id = new HIER_OBJECT_ID();
            return this.ehr_id;
        }
        if (name.equals("contributions")) {
            return this.addContributions();
        }
        if (name.equals("ehr_status")) {
            this.ehr_status = new OBJECT_REF();
            return this.ehr_status;
        }
        if (name.equals("ehr_access")) {
            this.ehr_access = new OBJECT_REF();
            return this.ehr_access;
        }
        if (name.equals("compositions")) {
            return this.addCompositions();
        }
        if (name.equals("directory")) {
            this.directory = new OBJECT_REF();
            return this.directory;
        }
        if (name.equals("time_created")) {
            this.time_created = new DV_DATE_TIME();
            return this.time_created;
        }
        if (name.equals("folders")) {
            return this.addFolders();
        }
        if (name.equals("tags")) {
            return this.addTags();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EHR";
    }

    @Override
    public EHR copy() {
        EHR dst = new EHR();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EHR dst) {
        super.copyValues(dst);
        if (this.system_idList != null) {
            dst.system_idList = new ArrayList<HIER_OBJECT_ID>();
            for (HIER_OBJECT_ID hIER_OBJECT_ID : this.system_idList) {
                dst.system_idList.add(hIER_OBJECT_ID.copy());
            }
        }
        HIER_OBJECT_ID hIER_OBJECT_ID = dst.ehr_id = this.ehr_id == null ? null : this.ehr_id.copy();
        if (this.contributionsList != null) {
            dst.contributionsList = new ArrayList<OBJECT_REF>();
            for (OBJECT_REF oBJECT_REF : this.contributionsList) {
                dst.contributionsList.add(oBJECT_REF.copy());
            }
        }
        dst.ehr_status = this.ehr_status == null ? null : this.ehr_status.copy();
        OBJECT_REF oBJECT_REF = dst.ehr_access = this.ehr_access == null ? null : this.ehr_access.copy();
        if (this.compositionsList != null) {
            dst.compositionsList = new ArrayList<OBJECT_REF>();
            for (OBJECT_REF oBJECT_REF2 : this.compositionsList) {
                dst.compositionsList.add(oBJECT_REF2.copy());
            }
        }
        dst.directory = this.directory == null ? null : this.directory.copy();
        DV_DATE_TIME dV_DATE_TIME = dst.time_created = this.time_created == null ? null : this.time_created.copy();
        if (this.foldersList != null) {
            dst.foldersList = new ArrayList<OBJECT_REF>();
            for (OBJECT_REF oBJECT_REF3 : this.foldersList) {
                dst.foldersList.add(oBJECT_REF3.copy());
            }
        }
        if (this.tagsList != null) {
            dst.tagsList = new ArrayList<OBJECT_REF>();
            for (OBJECT_REF oBJECT_REF4 : this.tagsList) {
                dst.tagsList.add(oBJECT_REF4.copy());
            }
        }
    }

    protected EHR typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EHR)) {
            return false;
        }
        EHR o = (EHR)other_;
        return EHR.compareDeep(this.system_idList, o.system_idList, true) && EHR.compareDeep(this.ehr_id, o.ehr_id, true) && EHR.compareDeep(this.contributionsList, o.contributionsList, true) && EHR.compareDeep(this.ehr_status, o.ehr_status, true) && EHR.compareDeep(this.ehr_access, o.ehr_access, true) && EHR.compareDeep(this.compositionsList, o.compositionsList, true) && EHR.compareDeep(this.directory, o.directory, true) && EHR.compareDeep(this.time_created, o.time_created, true) && EHR.compareDeep(this.foldersList, o.foldersList, true) && EHR.compareDeep(this.tagsList, o.tagsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EHR)) {
            return false;
        }
        EHR o = (EHR)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.system_idList, this.ehr_id, this.contributionsList, this.ehr_status, this.ehr_access, this.compositionsList, this.directory, this.time_created, this.foldersList, this.tagsList});
    }
}

