/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.DATA_VALUE;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;
import org.hl7.fhir.r5.openehr.DV_TEXT;
import org.hl7.fhir.r5.openehr.ITEM;

@DatatypeDef(name="ELEMENT")
public class ELEMENT
extends ITEM
implements ICompositeType {
    @Child(name="null_flavour", type={DV_CODED_TEXT.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Flavour of null value, e.g. 253|unknown|, 271|no information|, 272|masked|, and 273|not applicable|", formalDefinition="Flavour of null value, e.g. 253|unknown|, 271|no information|, 272|masked|, and 273|not applicable|.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-null_flavours")
    protected DV_CODED_TEXT null_flavour;
    @Child(name="value", type={DATA_VALUE.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Property representing leaf value object of ELEMENT (any concrete subtype of DATA_VALUE)", formalDefinition="Property representing leaf value object of ELEMENT. In real data, any concrete subtype of DATA_VALUE can be used.")
    protected DATA_VALUE value;
    @Child(name="null_reason", type={DV_TEXT.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional specific reason for null value; if set, null_flavour must be set", formalDefinition="Optional specific reason for null value; if set, null_flavour must be set. Null reason may apply only to a minority of clinical data, commonly needed in reporting contexts.")
    protected DV_TEXT null_reason;
    private static final long serialVersionUID = -741031778L;

    public DV_CODED_TEXT getNull_flavour() {
        if (this.null_flavour == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ELEMENT.null_flavour");
            }
            if (Configuration.doAutoCreate()) {
                this.null_flavour = new DV_CODED_TEXT();
            }
        }
        return this.null_flavour;
    }

    public boolean hasNull_flavour() {
        return this.null_flavour != null && !this.null_flavour.isEmpty();
    }

    public ELEMENT setNull_flavour(DV_CODED_TEXT value) {
        this.null_flavour = value;
        return this;
    }

    public DATA_VALUE getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public ELEMENT setValue(DATA_VALUE value) {
        this.value = value;
        return this;
    }

    public DV_TEXT getNull_reason() {
        if (this.null_reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ELEMENT.null_reason");
            }
            if (Configuration.doAutoCreate()) {
                this.null_reason = new DV_TEXT();
            }
        }
        return this.null_reason;
    }

    public boolean hasNull_reason() {
        return this.null_reason != null && !this.null_reason.isEmpty();
    }

    public ELEMENT setNull_reason(DV_TEXT value) {
        this.null_reason = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("null_flavour", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Flavour of null value, e.g. 253|unknown|, 271|no information|, 272|masked|, and 273|not applicable|.", 0, 1, this.null_flavour));
        children.add(new Property("value", "http://openehr.org/fhir/StructureDefinition/DATA-VALUE", "Property representing leaf value object of ELEMENT. In real data, any concrete subtype of DATA_VALUE can be used.", 0, 1, this.value));
        children.add(new Property("null_reason", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Optional specific reason for null value; if set, null_flavour must be set. Null reason may apply only to a minority of clinical data, commonly needed in reporting contexts.", 0, 1, this.null_reason));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1423585081: {
                return new Property("null_flavour", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Flavour of null value, e.g. 253|unknown|, 271|no information|, 272|masked|, and 273|not applicable|.", 0, 1, this.null_flavour);
            }
            case 111972721: {
                return new Property("value", "http://openehr.org/fhir/StructureDefinition/DATA-VALUE", "Property representing leaf value object of ELEMENT. In real data, any concrete subtype of DATA_VALUE can be used.", 0, 1, this.value);
            }
            case 1768477692: {
                return new Property("null_reason", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Optional specific reason for null value; if set, null_flavour must be set. Null reason may apply only to a minority of clinical data, commonly needed in reporting contexts.", 0, 1, this.null_reason);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1423585081: {
                Base[] baseArray;
                if (this.null_flavour == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.null_flavour;
                }
                return baseArray;
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.value;
                }
                return baseArray;
            }
            case 1768477692: {
                Base[] baseArray;
                if (this.null_reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.null_reason;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1423585081: {
                this.null_flavour = (DV_CODED_TEXT)value;
                return value;
            }
            case 111972721: {
                this.value = (DATA_VALUE)value;
                return value;
            }
            case 1768477692: {
                this.null_reason = (DV_TEXT)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("null_flavour")) {
            this.null_flavour = (DV_CODED_TEXT)value;
        } else if (name.equals("value")) {
            this.value = (DATA_VALUE)value;
        } else if (name.equals("null_reason")) {
            this.null_reason = (DV_TEXT)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1423585081: {
                return this.getNull_flavour();
            }
            case 111972721: {
                throw new Error("Unable to make an instance of the abstract property 'value'");
            }
            case 1768477692: {
                return this.getNull_reason();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1423585081: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
            case 111972721: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DATA-VALUE"};
            }
            case 1768477692: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-TEXT"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("null_flavour")) {
            this.null_flavour = new DV_CODED_TEXT();
            return this.null_flavour;
        }
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on an abstract type ELEMENT.value");
        }
        if (name.equals("null_reason")) {
            this.null_reason = new DV_TEXT();
            return this.null_reason;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ELEMENT";
    }

    @Override
    public ELEMENT copy() {
        ELEMENT dst = new ELEMENT();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ELEMENT dst) {
        super.copyValues(dst);
        dst.null_flavour = this.null_flavour == null ? null : this.null_flavour.copy();
        dst.value = this.value == null ? null : this.value.copy();
        dst.null_reason = this.null_reason == null ? null : this.null_reason.copy();
    }

    protected ELEMENT typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ELEMENT)) {
            return false;
        }
        ELEMENT o = (ELEMENT)other_;
        return ELEMENT.compareDeep(this.null_flavour, o.null_flavour, true) && ELEMENT.compareDeep(this.value, o.value, true) && ELEMENT.compareDeep(this.null_reason, o.null_reason, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ELEMENT)) {
            return false;
        }
        ELEMENT o = (ELEMENT)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.null_flavour, this.value, this.null_reason});
    }
}

