/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.CODE_PHRASE;
import org.hl7.fhir.r5.openehr.CONTENT_ITEM;
import org.hl7.fhir.r5.openehr.OBJECT_REF;
import org.hl7.fhir.r5.openehr.PARTICIPATION;
import org.hl7.fhir.r5.openehr.PARTY_PROXY;

@DatatypeDef(name="ENTRY")
public abstract class ENTRY
extends CONTENT_ITEM
implements ICompositeType {
    @Child(name="language", type={CODE_PHRASE.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Mandatory indicator of the localised language in which this Entry is written. Coded from openEHR Code Set languages", formalDefinition="Mandatory indicator of the localised language in which this Entry is written. Coded from openEHR Code Set languages.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-languages")
    protected CODE_PHRASE language;
    @Child(name="encoding", type={CODE_PHRASE.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of character set in which text values in this Entry are encoded", formalDefinition="Name of character set in which text values in this Entry are encoded. Coded from openEHR Code Set character sets.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-character_sets")
    protected CODE_PHRASE encoding;
    @Child(name="other_participations", type={PARTICIPATION.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Other participations at ENTRY level", formalDefinition="Other participations at ENTRY level.")
    protected List<PARTICIPATION> other_participationsList;
    @Child(name="workflow_id", type={OBJECT_REF.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Identifier of externally held workflow engine data for this workflow execution, for this subject of care", formalDefinition="Identifier of externally held workflow engine data for this workflow execution, for this subject of care.")
    protected OBJECT_REF workflow_id;
    @Child(name="subject", type={PARTY_PROXY.class}, order=4, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Id of human subject of this ENTRY, e.g. organ donor, foetus, a family member, or another clinically relevant person", formalDefinition="Id of human subject of this ENTRY, e.g.:\r\n\r\n* organ donor\r\n* foetus\r\n* a family member\r\n* another clinically relevant person")
    protected PARTY_PROXY subject;
    @Child(name="provider", type={PARTY_PROXY.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional identification of provider of the information in this ENTRY, which might be the patient, a patient agent, the clinician, a device", formalDefinition="Optional identification of provider of the information in this ENTRY, which might be:\r\n\r\n* the patient\r\n* a patient agent, e.g. parent, guardian\r\n* the clinician\r\n* a device or software\r\n\r\n\r\nGenerally only used when the recorder needs to make it explicit. Otherwise, Composition composer and other participants are assumed.")
    protected PARTY_PROXY provider;
    private static final long serialVersionUID = -1650881402L;

    public ENTRY() {
    }

    public ENTRY(CODE_PHRASE language, CODE_PHRASE encoding, PARTY_PROXY subject) {
        this.setLanguage(language);
        this.setEncoding(encoding);
        this.setSubject(subject);
    }

    public CODE_PHRASE getLanguage() {
        if (this.language == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ENTRY.language");
            }
            if (Configuration.doAutoCreate()) {
                this.language = new CODE_PHRASE();
            }
        }
        return this.language;
    }

    public boolean hasLanguage() {
        return this.language != null && !this.language.isEmpty();
    }

    public ENTRY setLanguage(CODE_PHRASE value) {
        this.language = value;
        return this;
    }

    public CODE_PHRASE getEncoding() {
        if (this.encoding == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ENTRY.encoding");
            }
            if (Configuration.doAutoCreate()) {
                this.encoding = new CODE_PHRASE();
            }
        }
        return this.encoding;
    }

    public boolean hasEncoding() {
        return this.encoding != null && !this.encoding.isEmpty();
    }

    public ENTRY setEncoding(CODE_PHRASE value) {
        this.encoding = value;
        return this;
    }

    public List<PARTICIPATION> getOther_participationsList() {
        if (this.other_participationsList == null) {
            this.other_participationsList = new ArrayList<PARTICIPATION>();
        }
        return this.other_participationsList;
    }

    public ENTRY setOther_participationsList(List<PARTICIPATION> theOther_participations) {
        this.other_participationsList = theOther_participations;
        return this;
    }

    public boolean hasOther_participations() {
        if (this.other_participationsList == null) {
            return false;
        }
        for (PARTICIPATION item : this.other_participationsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PARTICIPATION addOther_participations() {
        PARTICIPATION t = new PARTICIPATION();
        if (this.other_participationsList == null) {
            this.other_participationsList = new ArrayList<PARTICIPATION>();
        }
        this.other_participationsList.add(t);
        return t;
    }

    public ENTRY addOther_participations(PARTICIPATION t) {
        if (t == null) {
            return this;
        }
        if (this.other_participationsList == null) {
            this.other_participationsList = new ArrayList<PARTICIPATION>();
        }
        this.other_participationsList.add(t);
        return this;
    }

    public PARTICIPATION getOther_participationsFirstRep() {
        if (this.getOther_participationsList().isEmpty()) {
            this.addOther_participations();
        }
        return this.getOther_participationsList().get(0);
    }

    public OBJECT_REF getWorkflow_id() {
        if (this.workflow_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ENTRY.workflow_id");
            }
            if (Configuration.doAutoCreate()) {
                this.workflow_id = new OBJECT_REF();
            }
        }
        return this.workflow_id;
    }

    public boolean hasWorkflow_id() {
        return this.workflow_id != null && !this.workflow_id.isEmpty();
    }

    public ENTRY setWorkflow_id(OBJECT_REF value) {
        this.workflow_id = value;
        return this;
    }

    public PARTY_PROXY getSubject() {
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ENTRY setSubject(PARTY_PROXY value) {
        this.subject = value;
        return this;
    }

    public PARTY_PROXY getProvider() {
        return this.provider;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public ENTRY setProvider(PARTY_PROXY value) {
        this.provider = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Mandatory indicator of the localised language in which this Entry is written. Coded from openEHR Code Set languages.", 0, 1, this.language));
        children.add(new Property("encoding", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Name of character set in which text values in this Entry are encoded. Coded from openEHR Code Set character sets.", 0, 1, this.encoding));
        children.add(new Property("other_participations", "http://openehr.org/fhir/StructureDefinition/PARTICIPATION", "Other participations at ENTRY level.", 0, Integer.MAX_VALUE, this.other_participationsList));
        children.add(new Property("workflow_id", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Identifier of externally held workflow engine data for this workflow execution, for this subject of care.", 0, 1, this.workflow_id));
        children.add(new Property("subject", "http://openehr.org/fhir/StructureDefinition/PARTY-PROXY", "Id of human subject of this ENTRY, e.g.:\r\n\r\n* organ donor\r\n* foetus\r\n* a family member\r\n* another clinically relevant person", 0, 1, this.subject));
        children.add(new Property("provider", "http://openehr.org/fhir/StructureDefinition/PARTY-PROXY", "Optional identification of provider of the information in this ENTRY, which might be:\r\n\r\n* the patient\r\n* a patient agent, e.g. parent, guardian\r\n* the clinician\r\n* a device or software\r\n\r\n\r\nGenerally only used when the recorder needs to make it explicit. Otherwise, Composition composer and other participants are assumed.", 0, 1, this.provider));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1613589672: {
                return new Property("language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Mandatory indicator of the localised language in which this Entry is written. Coded from openEHR Code Set languages.", 0, 1, this.language);
            }
            case 1711222099: {
                return new Property("encoding", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Name of character set in which text values in this Entry are encoded. Coded from openEHR Code Set character sets.", 0, 1, this.encoding);
            }
            case 607783009: {
                return new Property("other_participations", "http://openehr.org/fhir/StructureDefinition/PARTICIPATION", "Other participations at ENTRY level.", 0, Integer.MAX_VALUE, this.other_participationsList);
            }
            case 1712917915: {
                return new Property("workflow_id", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Identifier of externally held workflow engine data for this workflow execution, for this subject of care.", 0, 1, this.workflow_id);
            }
            case -1867885268: {
                return new Property("subject", "http://openehr.org/fhir/StructureDefinition/PARTY-PROXY", "Id of human subject of this ENTRY, e.g.:\r\n\r\n* organ donor\r\n* foetus\r\n* a family member\r\n* another clinically relevant person", 0, 1, this.subject);
            }
            case -987494927: {
                return new Property("provider", "http://openehr.org/fhir/StructureDefinition/PARTY-PROXY", "Optional identification of provider of the information in this ENTRY, which might be:\r\n\r\n* the patient\r\n* a patient agent, e.g. parent, guardian\r\n* the clinician\r\n* a device or software\r\n\r\n\r\nGenerally only used when the recorder needs to make it explicit. Otherwise, Composition composer and other participants are assumed.", 0, 1, this.provider);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                Base[] baseArray;
                if (this.language == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.language;
                }
                return baseArray;
            }
            case 1711222099: {
                Base[] baseArray;
                if (this.encoding == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.encoding;
                }
                return baseArray;
            }
            case 607783009: {
                return this.other_participationsList == null ? new Base[]{} : this.other_participationsList.toArray(new Base[this.other_participationsList.size()]);
            }
            case 1712917915: {
                Base[] baseArray;
                if (this.workflow_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.workflow_id;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case -987494927: {
                Base[] baseArray;
                if (this.provider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.provider;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                this.language = (CODE_PHRASE)value;
                return value;
            }
            case 1711222099: {
                this.encoding = (CODE_PHRASE)value;
                return value;
            }
            case 607783009: {
                this.getOther_participationsList().add((PARTICIPATION)value);
                return value;
            }
            case 1712917915: {
                this.workflow_id = (OBJECT_REF)value;
                return value;
            }
            case -1867885268: {
                this.subject = (PARTY_PROXY)value;
                return value;
            }
            case -987494927: {
                this.provider = (PARTY_PROXY)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("language")) {
            this.language = (CODE_PHRASE)value;
        } else if (name.equals("encoding")) {
            this.encoding = (CODE_PHRASE)value;
        } else if (name.equals("other_participations")) {
            this.getOther_participationsList().add((PARTICIPATION)value);
        } else if (name.equals("workflow_id")) {
            this.workflow_id = (OBJECT_REF)value;
        } else if (name.equals("subject")) {
            this.subject = (PARTY_PROXY)value;
        } else if (name.equals("provider")) {
            this.provider = (PARTY_PROXY)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                return this.getLanguage();
            }
            case 1711222099: {
                return this.getEncoding();
            }
            case 607783009: {
                return this.addOther_participations();
            }
            case 1712917915: {
                return this.getWorkflow_id();
            }
            case -1867885268: {
                throw new Error("Unable to make an instance of the abstract property 'subject'");
            }
            case -987494927: {
                throw new Error("Unable to make an instance of the abstract property 'provider'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
            case 1711222099: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
            case 607783009: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTICIPATION"};
            }
            case 1712917915: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
            case -1867885268: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-PROXY"};
            }
            case -987494927: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-PROXY"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("language")) {
            this.language = new CODE_PHRASE();
            return this.language;
        }
        if (name.equals("encoding")) {
            this.encoding = new CODE_PHRASE();
            return this.encoding;
        }
        if (name.equals("other_participations")) {
            return this.addOther_participations();
        }
        if (name.equals("workflow_id")) {
            this.workflow_id = new OBJECT_REF();
            return this.workflow_id;
        }
        if (name.equals("subject")) {
            throw new FHIRException("Cannot call addChild on an abstract type ENTRY.subject");
        }
        if (name.equals("provider")) {
            throw new FHIRException("Cannot call addChild on an abstract type ENTRY.provider");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ENTRY";
    }

    @Override
    public abstract ENTRY copy();

    public void copyValues(ENTRY dst) {
        super.copyValues(dst);
        dst.language = this.language == null ? null : this.language.copy();
        CODE_PHRASE cODE_PHRASE = dst.encoding = this.encoding == null ? null : this.encoding.copy();
        if (this.other_participationsList != null) {
            dst.other_participationsList = new ArrayList<PARTICIPATION>();
            for (PARTICIPATION i : this.other_participationsList) {
                dst.other_participationsList.add(i.copy());
            }
        }
        dst.workflow_id = this.workflow_id == null ? null : this.workflow_id.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ENTRY)) {
            return false;
        }
        ENTRY o = (ENTRY)other_;
        return ENTRY.compareDeep(this.language, o.language, true) && ENTRY.compareDeep(this.encoding, o.encoding, true) && ENTRY.compareDeep(this.other_participationsList, o.other_participationsList, true) && ENTRY.compareDeep(this.workflow_id, o.workflow_id, true) && ENTRY.compareDeep(this.subject, o.subject, true) && ENTRY.compareDeep(this.provider, o.provider, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ENTRY)) {
            return false;
        }
        ENTRY o = (ENTRY)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.language, this.encoding, this.other_participationsList, this.workflow_id, this.subject, this.provider});
    }
}

