/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.openehr.Any;
import org.hl7.fhir.r5.openehr.DV_DATE_TIME;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;
import org.hl7.fhir.r5.openehr.LOCATABLE;

@DatatypeDef(name="EVENT")
public abstract class EVENT
extends LOCATABLE
implements ICompositeType {
    @Child(name="time", type={DV_DATE_TIME.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time of this event", formalDefinition="Time of this event. If the width is non-zero, it is the time point of the trailing edge of the event")
    protected DV_DATE_TIME time;
    @Child(name="state", type={ITEM_STRUCTURE.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional state data for this event", formalDefinition="Optional state data for this event.")
    protected ITEM_STRUCTURE state;
    @Child(name="data", type={Reference.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The data of this event", formalDefinition="The data of this event.")
    protected Any data;
    private static final long serialVersionUID = 1692464616L;

    public EVENT() {
    }

    public EVENT(DV_DATE_TIME time, Any data) {
        this.setTime(time);
        this.setData(data);
    }

    public DV_DATE_TIME getTime() {
        if (this.time == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EVENT.time");
            }
            if (Configuration.doAutoCreate()) {
                this.time = new DV_DATE_TIME();
            }
        }
        return this.time;
    }

    public boolean hasTime() {
        return this.time != null && !this.time.isEmpty();
    }

    public EVENT setTime(DV_DATE_TIME value) {
        this.time = value;
        return this;
    }

    public ITEM_STRUCTURE getState() {
        return this.state;
    }

    public boolean hasState() {
        return this.state != null && !this.state.isEmpty();
    }

    public EVENT setState(ITEM_STRUCTURE value) {
        this.state = value;
        return this;
    }

    public Any getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public EVENT setData(Any value) {
        this.data = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("time", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Time of this event. If the width is non-zero, it is the time point of the trailing edge of the event", 0, 1, this.time));
        children.add(new Property("state", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Optional state data for this event.", 0, 1, this.state));
        children.add(new Property("data", "http://openehr.org/fhir/StructureDefinition/Any", "The data of this event.", 0, 1, this.data));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3560141: {
                return new Property("time", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Time of this event. If the width is non-zero, it is the time point of the trailing edge of the event", 0, 1, this.time);
            }
            case 109757585: {
                return new Property("state", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Optional state data for this event.", 0, 1, this.state);
            }
            case 3076010: {
                return new Property("data", "http://openehr.org/fhir/StructureDefinition/Any", "The data of this event.", 0, 1, this.data);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3560141: {
                Base[] baseArray;
                if (this.time == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.time;
                }
                return baseArray;
            }
            case 109757585: {
                Base[] baseArray;
                if (this.state == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.state;
                }
                return baseArray;
            }
            case 3076010: {
                Base[] baseArray;
                if (this.data == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.data;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3560141: {
                this.time = (DV_DATE_TIME)value;
                return value;
            }
            case 109757585: {
                this.state = (ITEM_STRUCTURE)value;
                return value;
            }
            case 3076010: {
                this.data = (Any)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("time")) {
            this.time = (DV_DATE_TIME)value;
        } else if (name.equals("state")) {
            this.state = (ITEM_STRUCTURE)value;
        } else if (name.equals("data")) {
            this.data = (Any)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3560141: {
                return this.getTime();
            }
            case 109757585: {
                throw new Error("Unable to make an instance of the abstract property 'state'");
            }
            case 3076010: {
                throw new Error("Unable to make an instance of the abstract property 'data'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3560141: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME"};
            }
            case 109757585: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
            case 3076010: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/Any"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("time")) {
            this.time = new DV_DATE_TIME();
            return this.time;
        }
        if (name.equals("state")) {
            throw new FHIRException("Cannot call addChild on an abstract type EVENT.state");
        }
        if (name.equals("data")) {
            throw new FHIRException("Cannot call addChild on an abstract type EVENT.data");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EVENT";
    }

    @Override
    public abstract EVENT copy();

    public void copyValues(EVENT dst) {
        super.copyValues(dst);
        dst.time = this.time == null ? null : this.time.copy();
        dst.state = this.state == null ? null : this.state.copy();
        dst.data = this.data == null ? null : this.data.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EVENT)) {
            return false;
        }
        EVENT o = (EVENT)other_;
        return EVENT.compareDeep(this.time, o.time, true) && EVENT.compareDeep(this.state, o.state, true) && EVENT.compareDeep(this.data, o.data, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EVENT)) {
            return false;
        }
        EVENT o = (EVENT)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.time, this.state, this.data});
    }
}

