/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.DATA_STRUCTURE;
import org.hl7.fhir.r5.openehr.DV_DATE_TIME;
import org.hl7.fhir.r5.openehr.DV_DURATION;
import org.hl7.fhir.r5.openehr.EVENT;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;

@DatatypeDef(name="HISTORY")
public class HISTORY
extends DATA_STRUCTURE
implements ICompositeType {
    @Child(name="origin", type={DV_DATE_TIME.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time origin of this event history", formalDefinition="Time origin of this event history. The first event is not necessarily at the origin point.")
    protected DV_DATE_TIME origin;
    @Child(name="period", type={DV_DURATION.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Period between samples in this segment if periodic", formalDefinition="Period between samples in this segment if periodic.")
    protected DV_DURATION period;
    @Child(name="duration", type={DV_DURATION.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Duration of the entire History", formalDefinition="Duration of the entire History; either corresponds to the duration of all the events, and/or the duration represented by the summary, if it exists.")
    protected DV_DURATION duration;
    @Child(name="summary", type={ITEM_STRUCTURE.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional summary data that aggregates, organizes, reduces and transforms the event series", formalDefinition="Optional summary data that aggregates, organizes, reduces and transforms the event series. This may be a text or image that presents a graphical presentation, or some data that assists with the interpretation of the data")
    protected ITEM_STRUCTURE summary;
    @Child(name="events", type={EVENT.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The events in the series", formalDefinition="The events in the series. This attribute is of a generic type whose parameter must be a descendant of ITEM_STRUCTURE")
    protected List<EVENT> eventsList;
    private static final long serialVersionUID = 1582352314L;

    public HISTORY() {
    }

    public HISTORY(DV_DATE_TIME origin) {
        this.setOrigin(origin);
    }

    public DV_DATE_TIME getOrigin() {
        if (this.origin == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HISTORY.origin");
            }
            if (Configuration.doAutoCreate()) {
                this.origin = new DV_DATE_TIME();
            }
        }
        return this.origin;
    }

    public boolean hasOrigin() {
        return this.origin != null && !this.origin.isEmpty();
    }

    public HISTORY setOrigin(DV_DATE_TIME value) {
        this.origin = value;
        return this;
    }

    public DV_DURATION getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HISTORY.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new DV_DURATION();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public HISTORY setPeriod(DV_DURATION value) {
        this.period = value;
        return this;
    }

    public DV_DURATION getDuration() {
        if (this.duration == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HISTORY.duration");
            }
            if (Configuration.doAutoCreate()) {
                this.duration = new DV_DURATION();
            }
        }
        return this.duration;
    }

    public boolean hasDuration() {
        return this.duration != null && !this.duration.isEmpty();
    }

    public HISTORY setDuration(DV_DURATION value) {
        this.duration = value;
        return this;
    }

    public ITEM_STRUCTURE getSummary() {
        return this.summary;
    }

    public boolean hasSummary() {
        return this.summary != null && !this.summary.isEmpty();
    }

    public HISTORY setSummary(ITEM_STRUCTURE value) {
        this.summary = value;
        return this;
    }

    public List<EVENT> getEventsList() {
        if (this.eventsList == null) {
            this.eventsList = new ArrayList<EVENT>();
        }
        return this.eventsList;
    }

    public HISTORY setEventsList(List<EVENT> theEvents) {
        this.eventsList = theEvents;
        return this;
    }

    public boolean hasEvents() {
        if (this.eventsList == null) {
            return false;
        }
        for (EVENT item : this.eventsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HISTORY addEvents(EVENT t) {
        if (t == null) {
            return this;
        }
        if (this.eventsList == null) {
            this.eventsList = new ArrayList<EVENT>();
        }
        this.eventsList.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("origin", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Time origin of this event history. The first event is not necessarily at the origin point.", 0, 1, this.origin));
        children.add(new Property("period", "http://openehr.org/fhir/StructureDefinition/DV-DURATION", "Period between samples in this segment if periodic.", 0, 1, this.period));
        children.add(new Property("duration", "http://openehr.org/fhir/StructureDefinition/DV-DURATION", "Duration of the entire History; either corresponds to the duration of all the events, and/or the duration represented by the summary, if it exists.", 0, 1, this.duration));
        children.add(new Property("summary", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Optional summary data that aggregates, organizes, reduces and transforms the event series. This may be a text or image that presents a graphical presentation, or some data that assists with the interpretation of the data", 0, 1, this.summary));
        children.add(new Property("events", "http://openehr.org/fhir/StructureDefinition/EVENT", "The events in the series. This attribute is of a generic type whose parameter must be a descendant of ITEM_STRUCTURE", 0, Integer.MAX_VALUE, this.eventsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1008619738: {
                return new Property("origin", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Time origin of this event history. The first event is not necessarily at the origin point.", 0, 1, this.origin);
            }
            case -991726143: {
                return new Property("period", "http://openehr.org/fhir/StructureDefinition/DV-DURATION", "Period between samples in this segment if periodic.", 0, 1, this.period);
            }
            case -1992012396: {
                return new Property("duration", "http://openehr.org/fhir/StructureDefinition/DV-DURATION", "Duration of the entire History; either corresponds to the duration of all the events, and/or the duration represented by the summary, if it exists.", 0, 1, this.duration);
            }
            case -1857640538: {
                return new Property("summary", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Optional summary data that aggregates, organizes, reduces and transforms the event series. This may be a text or image that presents a graphical presentation, or some data that assists with the interpretation of the data", 0, 1, this.summary);
            }
            case -1291329255: {
                return new Property("events", "http://openehr.org/fhir/StructureDefinition/EVENT", "The events in the series. This attribute is of a generic type whose parameter must be a descendant of ITEM_STRUCTURE", 0, Integer.MAX_VALUE, this.eventsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1008619738: {
                Base[] baseArray;
                if (this.origin == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.origin;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.period;
                }
                return baseArray;
            }
            case -1992012396: {
                Base[] baseArray;
                if (this.duration == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.duration;
                }
                return baseArray;
            }
            case -1857640538: {
                Base[] baseArray;
                if (this.summary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.summary;
                }
                return baseArray;
            }
            case -1291329255: {
                return this.eventsList == null ? new Base[]{} : this.eventsList.toArray(new Base[this.eventsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1008619738: {
                this.origin = (DV_DATE_TIME)value;
                return value;
            }
            case -991726143: {
                this.period = (DV_DURATION)value;
                return value;
            }
            case -1992012396: {
                this.duration = (DV_DURATION)value;
                return value;
            }
            case -1857640538: {
                this.summary = (ITEM_STRUCTURE)value;
                return value;
            }
            case -1291329255: {
                this.getEventsList().add((EVENT)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("origin")) {
            this.origin = (DV_DATE_TIME)value;
        } else if (name.equals("period")) {
            this.period = (DV_DURATION)value;
        } else if (name.equals("duration")) {
            this.duration = (DV_DURATION)value;
        } else if (name.equals("summary")) {
            this.summary = (ITEM_STRUCTURE)value;
        } else if (name.equals("events")) {
            this.getEventsList().add((EVENT)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1008619738: {
                return this.getOrigin();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -1992012396: {
                return this.getDuration();
            }
            case -1857640538: {
                throw new Error("Unable to make an instance of the abstract property 'summary'");
            }
            case -1291329255: {
                throw new Error("Unable to make an instance of the abstract property 'events'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1008619738: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME"};
            }
            case -991726143: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-DURATION"};
            }
            case -1992012396: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-DURATION"};
            }
            case -1857640538: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
            case -1291329255: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/EVENT"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("origin")) {
            this.origin = new DV_DATE_TIME();
            return this.origin;
        }
        if (name.equals("period")) {
            this.period = new DV_DURATION();
            return this.period;
        }
        if (name.equals("duration")) {
            this.duration = new DV_DURATION();
            return this.duration;
        }
        if (name.equals("summary")) {
            throw new FHIRException("Cannot call addChild on an abstract type HISTORY.summary");
        }
        if (name.equals("events")) {
            throw new FHIRException("Cannot call addChild on an abstract type HISTORY.events");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "HISTORY";
    }

    @Override
    public HISTORY copy() {
        HISTORY dst = new HISTORY();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(HISTORY dst) {
        super.copyValues(dst);
        dst.origin = this.origin == null ? null : this.origin.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.duration = this.duration == null ? null : this.duration.copy();
        ITEM_STRUCTURE iTEM_STRUCTURE = dst.summary = this.summary == null ? null : this.summary.copy();
        if (this.eventsList != null) {
            dst.eventsList = new ArrayList<EVENT>();
            for (EVENT i : this.eventsList) {
                dst.eventsList.add(i.copy());
            }
        }
    }

    protected HISTORY typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof HISTORY)) {
            return false;
        }
        HISTORY o = (HISTORY)other_;
        return HISTORY.compareDeep(this.origin, o.origin, true) && HISTORY.compareDeep(this.period, o.period, true) && HISTORY.compareDeep(this.duration, o.duration, true) && HISTORY.compareDeep(this.summary, o.summary, true) && HISTORY.compareDeep(this.eventsList, o.eventsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof HISTORY)) {
            return false;
        }
        HISTORY o = (HISTORY)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.origin, this.period, this.duration, this.summary, this.eventsList});
    }
}

