/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.ORIGINAL_VERSION;
import org.hl7.fhir.r5.openehr.VERSION;

@DatatypeDef(name="IMPORTED_VERSION")
public class IMPORTED_VERSION
extends VERSION
implements ICompositeType {
    @Child(name="item", type={ORIGINAL_VERSION.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Versions whose content is an ORIGINAL_VERSION copied from another location", formalDefinition="Versions whose content is an ORIGINAL_VERSION copied from another location; this class inherits commit_audit and contribution from VERSION<T>, providing imported versions with their own audit trail and Contribution, distinct from those of the imported ORIGINAL_VERSION.")
    protected ORIGINAL_VERSION item;
    private static final long serialVersionUID = -1476960895L;

    public IMPORTED_VERSION() {
    }

    public IMPORTED_VERSION(ORIGINAL_VERSION item) {
        this.setItem(item);
    }

    public ORIGINAL_VERSION getItem() {
        if (this.item == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create IMPORTED_VERSION.item");
            }
            if (Configuration.doAutoCreate()) {
                this.item = new ORIGINAL_VERSION();
            }
        }
        return this.item;
    }

    public boolean hasItem() {
        return this.item != null && !this.item.isEmpty();
    }

    public IMPORTED_VERSION setItem(ORIGINAL_VERSION value) {
        this.item = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("item", "http://openehr.org/fhir/StructureDefinition/ORIGINAL-VERSION", "Versions whose content is an ORIGINAL_VERSION copied from another location; this class inherits commit_audit and contribution from VERSION<T>, providing imported versions with their own audit trail and Contribution, distinct from those of the imported ORIGINAL_VERSION.", 0, 1, this.item));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3242771: {
                return new Property("item", "http://openehr.org/fhir/StructureDefinition/ORIGINAL-VERSION", "Versions whose content is an ORIGINAL_VERSION copied from another location; this class inherits commit_audit and contribution from VERSION<T>, providing imported versions with their own audit trail and Contribution, distinct from those of the imported ORIGINAL_VERSION.", 0, 1, this.item);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3242771: {
                Base[] baseArray;
                if (this.item == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.item;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3242771: {
                this.item = (ORIGINAL_VERSION)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("item")) {
            return super.setProperty(name, value);
        }
        this.item = (ORIGINAL_VERSION)value;
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3242771: {
                return this.getItem();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3242771: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ORIGINAL-VERSION"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("item")) {
            this.item = new ORIGINAL_VERSION();
            return this.item;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "IMPORTED_VERSION";
    }

    @Override
    public IMPORTED_VERSION copy() {
        IMPORTED_VERSION dst = new IMPORTED_VERSION();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(IMPORTED_VERSION dst) {
        super.copyValues(dst);
        dst.item = this.item == null ? null : this.item.copy();
    }

    protected IMPORTED_VERSION typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof IMPORTED_VERSION)) {
            return false;
        }
        IMPORTED_VERSION o = (IMPORTED_VERSION)other_;
        return IMPORTED_VERSION.compareDeep(this.item, o.item, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof IMPORTED_VERSION)) {
            return false;
        }
        IMPORTED_VERSION o = (IMPORTED_VERSION)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item});
    }
}

