/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.ACTIVITY;
import org.hl7.fhir.r5.openehr.CARE_ENTRY;
import org.hl7.fhir.r5.openehr.DV_DATE_TIME;
import org.hl7.fhir.r5.openehr.DV_PARSABLE;
import org.hl7.fhir.r5.openehr.DV_TEXT;

@DatatypeDef(name="INSTRUCTION")
public class INSTRUCTION
extends CARE_ENTRY
implements ICompositeType {
    @Child(name="narrative", type={DV_TEXT.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Mandatory human-readable version of what the Instruction is about", formalDefinition="Mandatory human-readable version of what the Instruction is about.")
    protected DV_TEXT narrative;
    @Child(name="expiry_time", type={DV_DATE_TIME.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional expiry date/time to assist determination of when an Instruction can be assumed to have expired", formalDefinition="Optional expiry date/time to assist determination of when an Instruction can be assumed to have expired. This helps prevent false listing of Instructions as Active when they clearly must have been terminated in some way or other.")
    protected DV_DATE_TIME expiry_time;
    @Child(name="wf_definition", type={DV_PARSABLE.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional workflow engine executable expression of the Instruction", formalDefinition="Optional workflow engine executable expression of the Instruction.")
    protected DV_PARSABLE wf_definition;
    @Child(name="activities", type={ACTIVITY.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of all activities in Instruction", formalDefinition="List of all activities in Instruction.")
    protected List<ACTIVITY> activitiesList;
    private static final long serialVersionUID = -797234340L;

    public INSTRUCTION() {
    }

    public INSTRUCTION(DV_TEXT narrative) {
        this.setNarrative(narrative);
    }

    public DV_TEXT getNarrative() {
        if (this.narrative == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create INSTRUCTION.narrative");
            }
            if (Configuration.doAutoCreate()) {
                this.narrative = new DV_TEXT();
            }
        }
        return this.narrative;
    }

    public boolean hasNarrative() {
        return this.narrative != null && !this.narrative.isEmpty();
    }

    public INSTRUCTION setNarrative(DV_TEXT value) {
        this.narrative = value;
        return this;
    }

    public DV_DATE_TIME getExpiry_time() {
        if (this.expiry_time == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create INSTRUCTION.expiry_time");
            }
            if (Configuration.doAutoCreate()) {
                this.expiry_time = new DV_DATE_TIME();
            }
        }
        return this.expiry_time;
    }

    public boolean hasExpiry_time() {
        return this.expiry_time != null && !this.expiry_time.isEmpty();
    }

    public INSTRUCTION setExpiry_time(DV_DATE_TIME value) {
        this.expiry_time = value;
        return this;
    }

    public DV_PARSABLE getWf_definition() {
        if (this.wf_definition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create INSTRUCTION.wf_definition");
            }
            if (Configuration.doAutoCreate()) {
                this.wf_definition = new DV_PARSABLE();
            }
        }
        return this.wf_definition;
    }

    public boolean hasWf_definition() {
        return this.wf_definition != null && !this.wf_definition.isEmpty();
    }

    public INSTRUCTION setWf_definition(DV_PARSABLE value) {
        this.wf_definition = value;
        return this;
    }

    public List<ACTIVITY> getActivitiesList() {
        if (this.activitiesList == null) {
            this.activitiesList = new ArrayList<ACTIVITY>();
        }
        return this.activitiesList;
    }

    public INSTRUCTION setActivitiesList(List<ACTIVITY> theActivities) {
        this.activitiesList = theActivities;
        return this;
    }

    public boolean hasActivities() {
        if (this.activitiesList == null) {
            return false;
        }
        for (ACTIVITY item : this.activitiesList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ACTIVITY addActivities() {
        ACTIVITY t = new ACTIVITY();
        if (this.activitiesList == null) {
            this.activitiesList = new ArrayList<ACTIVITY>();
        }
        this.activitiesList.add(t);
        return t;
    }

    public INSTRUCTION addActivities(ACTIVITY t) {
        if (t == null) {
            return this;
        }
        if (this.activitiesList == null) {
            this.activitiesList = new ArrayList<ACTIVITY>();
        }
        this.activitiesList.add(t);
        return this;
    }

    public ACTIVITY getActivitiesFirstRep() {
        if (this.getActivitiesList().isEmpty()) {
            this.addActivities();
        }
        return this.getActivitiesList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("narrative", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Mandatory human-readable version of what the Instruction is about.", 0, 1, this.narrative));
        children.add(new Property("expiry_time", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Optional expiry date/time to assist determination of when an Instruction can be assumed to have expired. This helps prevent false listing of Instructions as Active when they clearly must have been terminated in some way or other.", 0, 1, this.expiry_time));
        children.add(new Property("wf_definition", "http://openehr.org/fhir/StructureDefinition/DV-PARSABLE", "Optional workflow engine executable expression of the Instruction.", 0, 1, this.wf_definition));
        children.add(new Property("activities", "http://openehr.org/fhir/StructureDefinition/ACTIVITY", "List of all activities in Instruction.", 0, Integer.MAX_VALUE, this.activitiesList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1750452338: {
                return new Property("narrative", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Mandatory human-readable version of what the Instruction is about.", 0, 1, this.narrative);
            }
            case 476403289: {
                return new Property("expiry_time", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Optional expiry date/time to assist determination of when an Instruction can be assumed to have expired. This helps prevent false listing of Instructions as Active when they clearly must have been terminated in some way or other.", 0, 1, this.expiry_time);
            }
            case -199789373: {
                return new Property("wf_definition", "http://openehr.org/fhir/StructureDefinition/DV-PARSABLE", "Optional workflow engine executable expression of the Instruction.", 0, 1, this.wf_definition);
            }
            case 2048605165: {
                return new Property("activities", "http://openehr.org/fhir/StructureDefinition/ACTIVITY", "List of all activities in Instruction.", 0, Integer.MAX_VALUE, this.activitiesList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1750452338: {
                Base[] baseArray;
                if (this.narrative == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.narrative;
                }
                return baseArray;
            }
            case 476403289: {
                Base[] baseArray;
                if (this.expiry_time == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.expiry_time;
                }
                return baseArray;
            }
            case -199789373: {
                Base[] baseArray;
                if (this.wf_definition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.wf_definition;
                }
                return baseArray;
            }
            case 2048605165: {
                return this.activitiesList == null ? new Base[]{} : this.activitiesList.toArray(new Base[this.activitiesList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1750452338: {
                this.narrative = (DV_TEXT)value;
                return value;
            }
            case 476403289: {
                this.expiry_time = (DV_DATE_TIME)value;
                return value;
            }
            case -199789373: {
                this.wf_definition = (DV_PARSABLE)value;
                return value;
            }
            case 2048605165: {
                this.getActivitiesList().add((ACTIVITY)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("narrative")) {
            this.narrative = (DV_TEXT)value;
        } else if (name.equals("expiry_time")) {
            this.expiry_time = (DV_DATE_TIME)value;
        } else if (name.equals("wf_definition")) {
            this.wf_definition = (DV_PARSABLE)value;
        } else if (name.equals("activities")) {
            this.getActivitiesList().add((ACTIVITY)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1750452338: {
                return this.getNarrative();
            }
            case 476403289: {
                return this.getExpiry_time();
            }
            case -199789373: {
                return this.getWf_definition();
            }
            case 2048605165: {
                return this.addActivities();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1750452338: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-TEXT"};
            }
            case 476403289: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME"};
            }
            case -199789373: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-PARSABLE"};
            }
            case 2048605165: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ACTIVITY"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("narrative")) {
            this.narrative = new DV_TEXT();
            return this.narrative;
        }
        if (name.equals("expiry_time")) {
            this.expiry_time = new DV_DATE_TIME();
            return this.expiry_time;
        }
        if (name.equals("wf_definition")) {
            this.wf_definition = new DV_PARSABLE();
            return this.wf_definition;
        }
        if (name.equals("activities")) {
            return this.addActivities();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "INSTRUCTION";
    }

    @Override
    public INSTRUCTION copy() {
        INSTRUCTION dst = new INSTRUCTION();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(INSTRUCTION dst) {
        super.copyValues(dst);
        dst.narrative = this.narrative == null ? null : this.narrative.copy();
        dst.expiry_time = this.expiry_time == null ? null : this.expiry_time.copy();
        DV_PARSABLE dV_PARSABLE = dst.wf_definition = this.wf_definition == null ? null : this.wf_definition.copy();
        if (this.activitiesList != null) {
            dst.activitiesList = new ArrayList<ACTIVITY>();
            for (ACTIVITY i : this.activitiesList) {
                dst.activitiesList.add(i.copy());
            }
        }
    }

    protected INSTRUCTION typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof INSTRUCTION)) {
            return false;
        }
        INSTRUCTION o = (INSTRUCTION)other_;
        return INSTRUCTION.compareDeep(this.narrative, o.narrative, true) && INSTRUCTION.compareDeep(this.expiry_time, o.expiry_time, true) && INSTRUCTION.compareDeep(this.wf_definition, o.wf_definition, true) && INSTRUCTION.compareDeep(this.activitiesList, o.activitiesList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof INSTRUCTION)) {
            return false;
        }
        INSTRUCTION o = (INSTRUCTION)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.narrative, this.expiry_time, this.wf_definition, this.activitiesList});
    }
}

