/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.OBJECT_REF;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="LOCATABLE_REF")
public class LOCATABLE_REF
extends OBJECT_REF
implements ICompositeType {
    @Child(name="path", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to a LOCATABLE instance inside the top-level content structure inside a VERSION<T> identified by the id attribute", formalDefinition="Reference to a LOCATABLE instance inside the top-level content structure inside a VERSION<T> identified by the id attribute. The path attribute is applied to the object that VERSION.data points to")
    protected StringType path;
    private static final long serialVersionUID = 1599579760L;

    public StringType getPathElement() {
        if (this.path == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create LOCATABLE_REF.path");
            }
            if (Configuration.doAutoCreate()) {
                this.path = new StringType();
            }
        }
        return this.path;
    }

    public boolean hasPathElement() {
        return this.path != null && !this.path.isEmpty();
    }

    public boolean hasPath() {
        return this.path != null && !this.path.isEmpty();
    }

    public LOCATABLE_REF setPathElement(StringType value) {
        this.path = value;
        return this;
    }

    public String getPath() {
        return this.path == null ? null : (String)this.path.getValue();
    }

    public LOCATABLE_REF setPath(String value) {
        if (Utilities.noString((String)value)) {
            this.path = null;
        } else {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("path", "string", "Reference to a LOCATABLE instance inside the top-level content structure inside a VERSION<T> identified by the id attribute. The path attribute is applied to the object that VERSION.data points to", 0, 1, this.path));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3433509: {
                return new Property("path", "string", "Reference to a LOCATABLE instance inside the top-level content structure inside a VERSION<T> identified by the id attribute. The path attribute is applied to the object that VERSION.data points to", 0, 1, this.path);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3433509: {
                Base[] baseArray;
                if (this.path == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.path;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3433509: {
                this.path = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("path")) {
            return super.setProperty(name, value);
        }
        this.path = TypeConvertor.castToString(value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3433509: {
                return this.getPathElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3433509: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("path")) {
            throw new FHIRException("Cannot call addChild on a singleton property LOCATABLE_REF.path");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "LOCATABLE_REF";
    }

    @Override
    public LOCATABLE_REF copy() {
        LOCATABLE_REF dst = new LOCATABLE_REF();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(LOCATABLE_REF dst) {
        super.copyValues(dst);
        dst.path = this.path == null ? null : this.path.copy();
    }

    @Override
    protected LOCATABLE_REF typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof LOCATABLE_REF)) {
            return false;
        }
        LOCATABLE_REF o = (LOCATABLE_REF)other_;
        return LOCATABLE_REF.compareDeep(this.path, o.path, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof LOCATABLE_REF)) {
            return false;
        }
        LOCATABLE_REF o = (LOCATABLE_REF)other_;
        return LOCATABLE_REF.compareValues(this.path, o.path, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.path});
    }
}

