/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.formats.JsonCreator;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.openehr.ACCESS_CONTROL_SETTINGS;
import org.hl7.fhir.r5.openehr.ACTION;
import org.hl7.fhir.r5.openehr.ACTIVITY;
import org.hl7.fhir.r5.openehr.ACTOR;
import org.hl7.fhir.r5.openehr.ADDRESS;
import org.hl7.fhir.r5.openehr.ADMIN_ENTRY;
import org.hl7.fhir.r5.openehr.AGENT;
import org.hl7.fhir.r5.openehr.ARCHETYPED;
import org.hl7.fhir.r5.openehr.ARCHETYPE_ID;
import org.hl7.fhir.r5.openehr.ATTESTATION;
import org.hl7.fhir.r5.openehr.AUDIT_DETAILS;
import org.hl7.fhir.r5.openehr.AUTHORED_RESOURCE;
import org.hl7.fhir.r5.openehr.Annotations;
import org.hl7.fhir.r5.openehr.Any;
import org.hl7.fhir.r5.openehr.CAPABILITY;
import org.hl7.fhir.r5.openehr.CARE_ENTRY;
import org.hl7.fhir.r5.openehr.CLUSTER;
import org.hl7.fhir.r5.openehr.CODE_PHRASE;
import org.hl7.fhir.r5.openehr.COMPOSITION;
import org.hl7.fhir.r5.openehr.CONTACT;
import org.hl7.fhir.r5.openehr.CONTENT_ITEM;
import org.hl7.fhir.r5.openehr.CONTRIBUTION;
import org.hl7.fhir.r5.openehr.DATA_STRUCTURE;
import org.hl7.fhir.r5.openehr.DATA_VALUE;
import org.hl7.fhir.r5.openehr.DV_ABSOLUTE_QUANTITY;
import org.hl7.fhir.r5.openehr.DV_AMOUNT;
import org.hl7.fhir.r5.openehr.DV_BOOLEAN;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;
import org.hl7.fhir.r5.openehr.DV_COUNT;
import org.hl7.fhir.r5.openehr.DV_DATE;
import org.hl7.fhir.r5.openehr.DV_DATE_TIME;
import org.hl7.fhir.r5.openehr.DV_DURATION;
import org.hl7.fhir.r5.openehr.DV_EHR_URI;
import org.hl7.fhir.r5.openehr.DV_ENCAPSULATED;
import org.hl7.fhir.r5.openehr.DV_GENERAL_TIME_SPECIFICATION;
import org.hl7.fhir.r5.openehr.DV_IDENTIFIER;
import org.hl7.fhir.r5.openehr.DV_INTERVAL;
import org.hl7.fhir.r5.openehr.DV_MULTIMEDIA;
import org.hl7.fhir.r5.openehr.DV_ORDERED;
import org.hl7.fhir.r5.openehr.DV_ORDINAL;
import org.hl7.fhir.r5.openehr.DV_PARAGRAPH;
import org.hl7.fhir.r5.openehr.DV_PARSABLE;
import org.hl7.fhir.r5.openehr.DV_PERIODIC_TIME_SPECIFICATION;
import org.hl7.fhir.r5.openehr.DV_PROPORTION;
import org.hl7.fhir.r5.openehr.DV_QUANTIFIED;
import org.hl7.fhir.r5.openehr.DV_QUANTITY;
import org.hl7.fhir.r5.openehr.DV_SCALE;
import org.hl7.fhir.r5.openehr.DV_STATE;
import org.hl7.fhir.r5.openehr.DV_TEMPORAL;
import org.hl7.fhir.r5.openehr.DV_TEXT;
import org.hl7.fhir.r5.openehr.DV_TIME;
import org.hl7.fhir.r5.openehr.DV_TIME_SPECIFICATION;
import org.hl7.fhir.r5.openehr.DV_URI;
import org.hl7.fhir.r5.openehr.EHR;
import org.hl7.fhir.r5.openehr.EHR_ACCESS;
import org.hl7.fhir.r5.openehr.EHR_STATUS;
import org.hl7.fhir.r5.openehr.ELEMENT;
import org.hl7.fhir.r5.openehr.ENTRY;
import org.hl7.fhir.r5.openehr.EVALUATION;
import org.hl7.fhir.r5.openehr.EVENT;
import org.hl7.fhir.r5.openehr.EVENT_CONTEXT;
import org.hl7.fhir.r5.openehr.FEEDER_AUDIT;
import org.hl7.fhir.r5.openehr.FEEDER_AUDIT_DETAILS;
import org.hl7.fhir.r5.openehr.FOLDER;
import org.hl7.fhir.r5.openehr.GENERIC_ID;
import org.hl7.fhir.r5.openehr.GROUP;
import org.hl7.fhir.r5.openehr.HIER_OBJECT_ID;
import org.hl7.fhir.r5.openehr.HISTORY;
import org.hl7.fhir.r5.openehr.IMPORTED_VERSION;
import org.hl7.fhir.r5.openehr.INSTRUCTION;
import org.hl7.fhir.r5.openehr.INSTRUCTION_DETAILS;
import org.hl7.fhir.r5.openehr.INTERNET_ID;
import org.hl7.fhir.r5.openehr.INTERVAL_EVENT;
import org.hl7.fhir.r5.openehr.ISM_TRANSITION;
import org.hl7.fhir.r5.openehr.ISO_OID;
import org.hl7.fhir.r5.openehr.ITEM;
import org.hl7.fhir.r5.openehr.ITEM_LIST;
import org.hl7.fhir.r5.openehr.ITEM_SINGLE;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;
import org.hl7.fhir.r5.openehr.ITEM_TABLE;
import org.hl7.fhir.r5.openehr.ITEM_TAG;
import org.hl7.fhir.r5.openehr.ITEM_TREE;
import org.hl7.fhir.r5.openehr.LINK;
import org.hl7.fhir.r5.openehr.LOCATABLE;
import org.hl7.fhir.r5.openehr.LOCATABLE_REF;
import org.hl7.fhir.r5.openehr.OBJECT_ID;
import org.hl7.fhir.r5.openehr.OBJECT_REF;
import org.hl7.fhir.r5.openehr.OBJECT_VERSION_ID;
import org.hl7.fhir.r5.openehr.OBSERVATION;
import org.hl7.fhir.r5.openehr.ORGANISATION;
import org.hl7.fhir.r5.openehr.ORIGINAL_VERSION;
import org.hl7.fhir.r5.openehr.PARTICIPATION;
import org.hl7.fhir.r5.openehr.PARTY;
import org.hl7.fhir.r5.openehr.PARTY_IDENTIFIED;
import org.hl7.fhir.r5.openehr.PARTY_IDENTITY;
import org.hl7.fhir.r5.openehr.PARTY_PROXY;
import org.hl7.fhir.r5.openehr.PARTY_REF;
import org.hl7.fhir.r5.openehr.PARTY_RELATED;
import org.hl7.fhir.r5.openehr.PARTY_RELATIONSHIP;
import org.hl7.fhir.r5.openehr.PARTY_SELF;
import org.hl7.fhir.r5.openehr.PATHABLE;
import org.hl7.fhir.r5.openehr.PERSON;
import org.hl7.fhir.r5.openehr.POINT_EVENT;
import org.hl7.fhir.r5.openehr.REFERENCE_RANGE;
import org.hl7.fhir.r5.openehr.RESOURCE_DESCRIPTION;
import org.hl7.fhir.r5.openehr.RESOURCE_DESCRIPTION_ITEM;
import org.hl7.fhir.r5.openehr.REVISION_HISTORY;
import org.hl7.fhir.r5.openehr.REVISION_HISTORY_ITEM;
import org.hl7.fhir.r5.openehr.ROLE;
import org.hl7.fhir.r5.openehr.SECTION;
import org.hl7.fhir.r5.openehr.TEMPLATE_ID;
import org.hl7.fhir.r5.openehr.TERMINOLOGY_ID;
import org.hl7.fhir.r5.openehr.TERM_MAPPING;
import org.hl7.fhir.r5.openehr.TRANSLATION_DETAILS;
import org.hl7.fhir.r5.openehr.TranslatedString;
import org.hl7.fhir.r5.openehr.UID;
import org.hl7.fhir.r5.openehr.UID_BASED_ID;
import org.hl7.fhir.r5.openehr.UUID;
import org.hl7.fhir.r5.openehr.VERSION;
import org.hl7.fhir.r5.openehr.VERSIONED_COMPOSITION;
import org.hl7.fhir.r5.openehr.VERSIONED_EHR_ACCESS;
import org.hl7.fhir.r5.openehr.VERSIONED_EHR_STATUS;
import org.hl7.fhir.r5.openehr.VERSIONED_FOLDER;
import org.hl7.fhir.r5.openehr.VERSIONED_OBJECT;
import org.hl7.fhir.r5.openehr.VERSIONED_PARTY;
import org.hl7.fhir.r5.openehr.VERSION_TREE_ID;
import org.hl7.fhir.r5.openehr.WebTemplate;
import org.hl7.fhir.r5.openehr.WebTemplateInput;
import org.hl7.fhir.r5.openehr.WebTemplateInputListItem;
import org.hl7.fhir.r5.openehr.WebTemplateInputValidation;
import org.hl7.fhir.r5.openehr.WebTemplateInputValidationRange;
import org.hl7.fhir.r5.openehr.WebTemplateItem;
import org.hl7.fhir.r5.openehr.WebTemplateTermBinding;
import org.hl7.fhir.r5.openehr.WebTemplateTermBindingValue;
import org.hl7.fhir.utilities.Utilities;

public class OpenehrJsonParser
extends JsonParser {
    public OpenehrJsonParser(JsonCreator json) {
        this.json = json;
    }

    public OpenehrJsonParser(boolean allowUnknownContent, boolean allowComments) {
        this.setAllowUnknownContent(allowUnknownContent);
        this.setAllowComments(allowComments);
    }

    @Override
    public Resource parseResource(JsonObject json) throws IOException, FHIRFormatError {
        if (!json.has("resourceType")) {
            throw new FHIRFormatError("Unable to find resource type - maybe not a FHIR resource?");
        }
        String t = json.get("resourceType").getAsString();
        if (Utilities.noString((String)t)) {
            throw new FHIRFormatError("Unable to find resource type - maybe not a FHIR resource?");
        }
        throw new FHIRFormatError("Unknown/Unrecognised resource type '" + t + "' (in property 'resourceType')");
    }

    protected ACCESS_CONTROL_SETTINGS parseACCESS_CONTROL_SETTINGS(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            default: 
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseACCESS_CONTROL_SETTINGSProperties(JsonObject json, ACCESS_CONTROL_SETTINGS res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
    }

    protected ACTOR parseACTOR(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "AGENT": {
                return this.parseAGENT(json);
            }
            case "GROUP": {
                return this.parseGROUP(json);
            }
            case "PERSON": {
                return this.parsePERSON(json);
            }
            case "ORGANISATION": {
                return this.parseORGANISATION(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseACTORProperties(JsonObject json, ACTOR res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parsePARTYProperties(json, res);
        if (json.has("languages")) {
            array = this.getJArray(json, "languages");
            for (i = 0; i < array.size(); ++i) {
                res.getLanguagesList().add(this.parseDV_TEXT(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("roles")) {
            array = this.getJArray(json, "roles");
            for (i = 0; i < array.size(); ++i) {
                res.getRolesList().add(this.parsePARTY_REF(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected AUTHORED_RESOURCE parseAUTHORED_RESOURCE(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            default: 
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseAUTHORED_RESOURCEProperties(JsonObject json, AUTHORED_RESOURCE res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("original_language")) {
            res.setOriginal_language(this.parseCODE_PHRASE(this.getJObject(json, "original_language")));
        }
        if (json.has("is_controlled")) {
            res.setIs_controlledElement(this.parseBoolean(json.get("is_controlled").getAsBoolean()));
        }
        if (json.has("_is_controlled")) {
            this.parseElementProperties(this.getJObject(json, "_is_controlled"), res.getIs_controlledElement());
        }
        if (json.has("translations")) {
            JsonArray array = this.getJArray(json, "translations");
            for (int i = 0; i < array.size(); ++i) {
                res.getTranslationsList().add(this.parseTRANSLATION_DETAILS(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescription(this.parseRESOURCE_DESCRIPTION(this.getJObject(json, "description")));
        }
        if (json.has("revision_history")) {
            res.setRevision_history(this.parseREVISION_HISTORY(this.getJObject(json, "revision_history")));
        }
    }

    protected Any parseAny(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "EHR": {
                return this.parseEHR(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseAnyProperties(JsonObject json, Any res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
    }

    protected CARE_ENTRY parseCARE_ENTRY(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "INSTRUCTION": {
                return this.parseINSTRUCTION(json);
            }
            case "OBSERVATION": {
                return this.parseOBSERVATION(json);
            }
            case "ACTION": {
                return this.parseACTION(json);
            }
            case "EVALUATION": {
                return this.parseEVALUATION(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseCARE_ENTRYProperties(JsonObject json, CARE_ENTRY res) throws IOException, FHIRFormatError {
        this.parseENTRYProperties(json, res);
        if (json.has("protocol")) {
            res.setProtocol(this.parseITEM_STRUCTURE(this.getJObject(json, "protocol")));
        }
        if (json.has("guideline_id")) {
            res.setGuideline_id(this.parseOBJECT_REF(this.getJObject(json, "guideline_id")));
        }
    }

    protected CONTENT_ITEM parseCONTENT_ITEM(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "SECTION": {
                return this.parseSECTION(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseCONTENT_ITEMProperties(JsonObject json, CONTENT_ITEM res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
    }

    protected DATA_STRUCTURE parseDATA_STRUCTURE(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "HISTORY": {
                return this.parseHISTORY(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseDATA_STRUCTUREProperties(JsonObject json, DATA_STRUCTURE res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
    }

    protected DATA_VALUE parseDATA_VALUE(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "DV-TEXT": {
                return this.parseDV_TEXT(json);
            }
            case "DV-IDENTIFIER": {
                return this.parseDV_IDENTIFIER(json);
            }
            case "DV-BOOLEAN": {
                return this.parseDV_BOOLEAN(json);
            }
            case "DV-PARAGRAPH": {
                return this.parseDV_PARAGRAPH(json);
            }
            case "DV-URI": {
                return this.parseDV_URI(json);
            }
            case "DV-STATE": {
                return this.parseDV_STATE(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseDATA_VALUEProperties(JsonObject json, DATA_VALUE res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
    }

    protected DV_ABSOLUTE_QUANTITY parseDV_ABSOLUTE_QUANTITY(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            default: 
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseDV_ABSOLUTE_QUANTITYProperties(JsonObject json, DV_ABSOLUTE_QUANTITY res) throws IOException, FHIRFormatError {
        this.parseDV_QUANTIFIEDProperties(json, res);
    }

    protected DV_AMOUNT parseDV_AMOUNT(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "DV-DURATION": {
                return this.parseDV_DURATION(json);
            }
            case "DV-COUNT": {
                return this.parseDV_COUNT(json);
            }
            case "DV-PROPORTION": {
                return this.parseDV_PROPORTION(json);
            }
            case "DV-QUANTITY": {
                return this.parseDV_QUANTITY(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseDV_AMOUNTProperties(JsonObject json, DV_AMOUNT res) throws IOException, FHIRFormatError {
        this.parseDV_QUANTIFIEDProperties(json, res);
        if (json.has("accuracy_is_percent")) {
            res.setAccuracy_is_percentElement(this.parseBoolean(json.get("accuracy_is_percent").getAsBoolean()));
        }
        if (json.has("_accuracy_is_percent")) {
            this.parseElementProperties(this.getJObject(json, "_accuracy_is_percent"), res.getAccuracy_is_percentElement());
        }
    }

    protected DV_ENCAPSULATED parseDV_ENCAPSULATED(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "DV-MULTIMEDIA": {
                return this.parseDV_MULTIMEDIA(json);
            }
            case "DV-PARSABLE": {
                return this.parseDV_PARSABLE(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseDV_ENCAPSULATEDProperties(JsonObject json, DV_ENCAPSULATED res) throws IOException, FHIRFormatError {
        this.parseDV_AMOUNTProperties(json, res);
        if (json.has("charset")) {
            res.setCharset(this.parseCODE_PHRASE(this.getJObject(json, "charset")));
        }
        if (json.has("language")) {
            res.setLanguage(this.parseCODE_PHRASE(this.getJObject(json, "language")));
        }
    }

    protected DV_ORDERED parseDV_ORDERED(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "DV-DATE-TIME": {
                return this.parseDV_DATE_TIME(json);
            }
            case "DV-TIME": {
                return this.parseDV_TIME(json);
            }
            case "DV-INTERVAL": {
                return this.parseDV_INTERVAL(json);
            }
            case "DV-ORDINAL": {
                return this.parseDV_ORDINAL(json);
            }
            case "DV-SCALE": {
                return this.parseDV_SCALE(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseDV_ORDEREDProperties(JsonObject json, DV_ORDERED res) throws IOException, FHIRFormatError {
        this.parseDATA_VALUEProperties(json, res);
        if (json.has("normal_status")) {
            res.setNormal_status(this.parseCODE_PHRASE(this.getJObject(json, "normal_status")));
        }
        if (json.has("normal_range")) {
            res.setNormal_range(this.parseDV_INTERVAL(this.getJObject(json, "normal_range")));
        }
        if (json.has("other_reference_ranges")) {
            JsonArray array = this.getJArray(json, "other_reference_ranges");
            for (int i = 0; i < array.size(); ++i) {
                res.getOther_reference_rangesList().add(this.parseREFERENCE_RANGE(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DV_QUANTIFIED parseDV_QUANTIFIED(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            default: 
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseDV_QUANTIFIEDProperties(JsonObject json, DV_QUANTIFIED res) throws IOException, FHIRFormatError {
        this.parseDV_ORDEREDProperties(json, res);
        if (json.has("magnitude_status")) {
            res.setMagnitude_statusElement(this.parseString(json.get("magnitude_status").getAsString()));
        }
        if (json.has("_magnitude_status")) {
            this.parseElementProperties(this.getJObject(json, "_magnitude_status"), res.getMagnitude_statusElement());
        }
        if (json.has("accuracy")) {
            res.setAccuracy(this.parseBase(this.getJObject(json, "accuracy")));
        }
    }

    protected DV_TEMPORAL parseDV_TEMPORAL(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "DV-DATE": {
                return this.parseDV_DATE(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseDV_TEMPORALProperties(JsonObject json, DV_TEMPORAL res) throws IOException, FHIRFormatError {
        this.parseDV_ABSOLUTE_QUANTITYProperties(json, res);
    }

    protected DV_TIME_SPECIFICATION parseDV_TIME_SPECIFICATION(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "DV-GENERAL-TIME-SPECIFICATION": {
                return this.parseDV_GENERAL_TIME_SPECIFICATION(json);
            }
            case "DV-PERIODIC-TIME-SPECIFICATION": {
                return this.parseDV_PERIODIC_TIME_SPECIFICATION(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseDV_TIME_SPECIFICATIONProperties(JsonObject json, DV_TIME_SPECIFICATION res) throws IOException, FHIRFormatError {
        this.parseDATA_VALUEProperties(json, res);
        if (json.has("DV_PARSABLE")) {
            res.setDV_PARSABLEElement(this.parseString(json.get("DV_PARSABLE").getAsString()));
        }
        if (json.has("_DV_PARSABLE")) {
            this.parseElementProperties(this.getJObject(json, "_DV_PARSABLE"), res.getDV_PARSABLEElement());
        }
    }

    protected ENTRY parseENTRY(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "ADMIN-ENTRY": {
                return this.parseADMIN_ENTRY(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseENTRYProperties(JsonObject json, ENTRY res) throws IOException, FHIRFormatError {
        this.parseCONTENT_ITEMProperties(json, res);
        if (json.has("language")) {
            res.setLanguage(this.parseCODE_PHRASE(this.getJObject(json, "language")));
        }
        if (json.has("encoding")) {
            res.setEncoding(this.parseCODE_PHRASE(this.getJObject(json, "encoding")));
        }
        if (json.has("other_participations")) {
            JsonArray array = this.getJArray(json, "other_participations");
            for (int i = 0; i < array.size(); ++i) {
                res.getOther_participationsList().add(this.parsePARTICIPATION(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("workflow_id")) {
            res.setWorkflow_id(this.parseOBJECT_REF(this.getJObject(json, "workflow_id")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parsePARTY_PROXY(this.getJObject(json, "subject")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parsePARTY_PROXY(this.getJObject(json, "provider")));
        }
    }

    protected EVENT parseEVENT(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "INTERVAL-EVENT": {
                return this.parseINTERVAL_EVENT(json);
            }
            case "POINT-EVENT": {
                return this.parsePOINT_EVENT(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseEVENTProperties(JsonObject json, EVENT res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
        if (json.has("time")) {
            res.setTime(this.parseDV_DATE_TIME(this.getJObject(json, "time")));
        }
        if (json.has("state")) {
            res.setState(this.parseITEM_STRUCTURE(this.getJObject(json, "state")));
        }
        if (json.has("data")) {
            res.setData(this.parseAny(this.getJObject(json, "data")));
        }
    }

    protected ITEM_STRUCTURE parseITEM_STRUCTURE(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "ITEM-SINGLE": {
                return this.parseITEM_SINGLE(json);
            }
            case "ITEM-TREE": {
                return this.parseITEM_TREE(json);
            }
            case "ITEM-TABLE": {
                return this.parseITEM_TABLE(json);
            }
            case "ITEM-LIST": {
                return this.parseITEM_LIST(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseITEM_STRUCTUREProperties(JsonObject json, ITEM_STRUCTURE res) throws IOException, FHIRFormatError {
        this.parseDATA_STRUCTUREProperties(json, res);
    }

    protected ITEM parseITEM(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "ELEMENT": {
                return this.parseELEMENT(json);
            }
            case "CLUSTER": {
                return this.parseCLUSTER(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseITEMProperties(JsonObject json, ITEM res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
    }

    protected LOCATABLE parseLOCATABLE(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "CONTACT": {
                return this.parseCONTACT(json);
            }
            case "EVENT-CONTEXT": {
                return this.parseEVENT_CONTEXT(json);
            }
            case "EHR-STATUS": {
                return this.parseEHR_STATUS(json);
            }
            case "PARTY-IDENTITY": {
                return this.parsePARTY_IDENTITY(json);
            }
            case "ADDRESS": {
                return this.parseADDRESS(json);
            }
            case "COMPOSITION": {
                return this.parseCOMPOSITION(json);
            }
            case "PARTY-RELATIONSHIP": {
                return this.parsePARTY_RELATIONSHIP(json);
            }
            case "CAPABILITY": {
                return this.parseCAPABILITY(json);
            }
            case "EHR-ACCESS": {
                return this.parseEHR_ACCESS(json);
            }
            case "ACTIVITY": {
                return this.parseACTIVITY(json);
            }
            case "FOLDER": {
                return this.parseFOLDER(json);
            }
            case "PARTICIPATION": {
                return this.parsePARTICIPATION(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseLOCATABLEProperties(JsonObject json, LOCATABLE res) throws IOException, FHIRFormatError {
        this.parsePATHABLEProperties(json, res);
    }

    protected OBJECT_ID parseOBJECT_ID(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "TEMPLATE-ID": {
                return this.parseTEMPLATE_ID(json);
            }
            case "ARCHETYPE-ID": {
                return this.parseARCHETYPE_ID(json);
            }
            case "GENERIC-ID": {
                return this.parseGENERIC_ID(json);
            }
            case "TERMINOLOGY-ID": {
                return this.parseTERMINOLOGY_ID(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseOBJECT_IDProperties(JsonObject json, OBJECT_ID res) throws IOException, FHIRFormatError {
        this.parseUIDProperties(json, res);
    }

    protected PARTY_PROXY parsePARTY_PROXY(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "PARTY-SELF": {
                return this.parsePARTY_SELF(json);
            }
            case "PARTY-IDENTIFIED": {
                return this.parsePARTY_IDENTIFIED(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parsePARTY_PROXYProperties(JsonObject json, PARTY_PROXY res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("external_ref")) {
            res.setExternal_ref(this.parsePARTY_REF(this.getJObject(json, "external_ref")));
        }
    }

    protected PARTY parsePARTY(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "ROLE": {
                return this.parseROLE(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parsePARTYProperties(JsonObject json, PARTY res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseLOCATABLEProperties(json, res);
        if (json.has("identities")) {
            array = this.getJArray(json, "identities");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentitiesList().add(this.parsePARTY_IDENTITY(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contacts")) {
            res.setContacts(this.parseCONTACT(this.getJObject(json, "contacts")));
        }
        if (json.has("details")) {
            res.setDetails(this.parseITEM_STRUCTURE(this.getJObject(json, "details")));
        }
        if (json.has("reverse_relationships")) {
            array = this.getJArray(json, "reverse_relationships");
            for (i = 0; i < array.size(); ++i) {
                res.getReverse_relationshipsList().add(this.parseLOCATABLE_REF(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relationships")) {
            array = this.getJArray(json, "relationships");
            for (i = 0; i < array.size(); ++i) {
                res.getRelationshipsList().add(this.parsePARTY_RELATIONSHIP(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected PATHABLE parsePATHABLE(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "INSTRUCTION-DETAILS": {
                return this.parseINSTRUCTION_DETAILS(json);
            }
            case "ISM-TRANSITION": {
                return this.parseISM_TRANSITION(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parsePATHABLEProperties(JsonObject json, PATHABLE res) throws IOException, FHIRFormatError {
        this.parseAnyProperties(json, res);
        if (json.has("name")) {
            res.setName(this.parseDV_TEXT(this.getJObject(json, "name")));
        }
        if (json.has("archetype_node_id")) {
            res.setArchetype_node_idElement(this.parseString(json.get("archetype_node_id").getAsString()));
        }
        if (json.has("_archetype_node_id")) {
            this.parseElementProperties(this.getJObject(json, "_archetype_node_id"), res.getArchetype_node_idElement());
        }
        if (json.has("uid")) {
            res.setUid(this.parseUID_BASED_ID(this.getJObject(json, "uid")));
        }
        if (json.has("links")) {
            JsonArray array = this.getJArray(json, "links");
            for (int i = 0; i < array.size(); ++i) {
                res.getLinksList().add(this.parseLINK(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("archetype_details")) {
            res.setArchetype_details(this.parseARCHETYPED(this.getJObject(json, "archetype_details")));
        }
        if (json.has("feeder_audit")) {
            res.setFeeder_audit(this.parseFEEDER_AUDIT(this.getJObject(json, "feeder_audit")));
        }
    }

    protected UID_BASED_ID parseUID_BASED_ID(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "OBJECT-VERSION-ID": {
                return this.parseOBJECT_VERSION_ID(json);
            }
            case "HIER-OBJECT-ID": {
                return this.parseHIER_OBJECT_ID(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseUID_BASED_IDProperties(JsonObject json, UID_BASED_ID res) throws IOException, FHIRFormatError {
        this.parseOBJECT_IDProperties(json, res);
    }

    protected UID parseUID(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "ISO-OID": {
                return this.parseISO_OID(json);
            }
            case "UUID": {
                return this.parseUUID(json);
            }
            case "INTERNET-ID": {
                return this.parseINTERNET_ID(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseUIDProperties(JsonObject json, UID res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected VERSION parseVERSION(JsonObject json) throws IOException, FHIRFormatError {
        String type;
        if (json.has("_type")) {
            throw new FHIRException("'_type' property not found");
        }
        switch (type = json.get("_type").getAsString()) {
            case "IMPORTED-VERSION": {
                return this.parseIMPORTED_VERSION(json);
            }
            case "ORIGINAL-VERSION": {
                return this.parseORIGINAL_VERSION(json);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected void parseVERSIONProperties(JsonObject json, VERSION res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("contribution")) {
            res.setContribution(this.parseOBJECT_REF(this.getJObject(json, "contribution")));
        }
        if (json.has("signature")) {
            res.setSignatureElement(this.parseString(json.get("signature").getAsString()));
        }
        if (json.has("_signature")) {
            this.parseElementProperties(this.getJObject(json, "_signature"), res.getSignatureElement());
        }
        if (json.has("commit_audit")) {
            res.setCommit_audit(this.parseAUDIT_DETAILS(this.getJObject(json, "commit_audit")));
        }
    }

    protected ACTION parseACTION(JsonObject json) throws IOException, FHIRFormatError {
        ACTION res = new ACTION();
        this.parseACTIONProperties(json, res);
        return res;
    }

    protected void parseACTIONProperties(JsonObject json, ACTION res) throws IOException, FHIRFormatError {
        this.parseCARE_ENTRYProperties(json, res);
        if (json.has("time")) {
            res.setTime(this.parseDV_DATE_TIME(this.getJObject(json, "time")));
        }
        if (json.has("ism_transition")) {
            res.setIsm_transition(this.parseISM_TRANSITION(this.getJObject(json, "ism_transition")));
        }
        if (json.has("instruction_details")) {
            res.setInstruction_details(this.parseINSTRUCTION_DETAILS(this.getJObject(json, "instruction_details")));
        }
        if (json.has("description")) {
            res.setDescription(this.parseITEM_STRUCTURE(this.getJObject(json, "description")));
        }
    }

    protected ACTIVITY parseACTIVITY(JsonObject json) throws IOException, FHIRFormatError {
        ACTIVITY res = new ACTIVITY();
        this.parseACTIVITYProperties(json, res);
        return res;
    }

    protected void parseACTIVITYProperties(JsonObject json, ACTIVITY res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
        if (json.has("timing")) {
            res.setTiming(this.parseDV_PARSABLE(this.getJObject(json, "timing")));
        }
        if (json.has("action_archetype_id")) {
            res.setAction_archetype_idElement(this.parseString(json.get("action_archetype_id").getAsString()));
        }
        if (json.has("_action_archetype_id")) {
            this.parseElementProperties(this.getJObject(json, "_action_archetype_id"), res.getAction_archetype_idElement());
        }
        if (json.has("description")) {
            res.setDescription(this.parseITEM_STRUCTURE(this.getJObject(json, "description")));
        }
    }

    protected ADDRESS parseADDRESS(JsonObject json) throws IOException, FHIRFormatError {
        ADDRESS res = new ADDRESS();
        this.parseADDRESSProperties(json, res);
        return res;
    }

    protected void parseADDRESSProperties(JsonObject json, ADDRESS res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
        if (json.has("details")) {
            res.setDetails(this.parseITEM_STRUCTURE(this.getJObject(json, "details")));
        }
    }

    protected ADMIN_ENTRY parseADMIN_ENTRY(JsonObject json) throws IOException, FHIRFormatError {
        ADMIN_ENTRY res = new ADMIN_ENTRY();
        this.parseADMIN_ENTRYProperties(json, res);
        return res;
    }

    protected void parseADMIN_ENTRYProperties(JsonObject json, ADMIN_ENTRY res) throws IOException, FHIRFormatError {
        this.parseENTRYProperties(json, res);
        if (json.has("data")) {
            res.setData(this.parseITEM_STRUCTURE(this.getJObject(json, "data")));
        }
    }

    protected AGENT parseAGENT(JsonObject json) throws IOException, FHIRFormatError {
        AGENT res = new AGENT();
        this.parseAGENTProperties(json, res);
        return res;
    }

    protected void parseAGENTProperties(JsonObject json, AGENT res) throws IOException, FHIRFormatError {
        this.parseACTORProperties(json, res);
    }

    protected ARCHETYPE_ID parseARCHETYPE_ID(JsonObject json) throws IOException, FHIRFormatError {
        ARCHETYPE_ID res = new ARCHETYPE_ID();
        this.parseARCHETYPE_IDProperties(json, res);
        return res;
    }

    protected void parseARCHETYPE_IDProperties(JsonObject json, ARCHETYPE_ID res) throws IOException, FHIRFormatError {
        this.parseOBJECT_IDProperties(json, res);
    }

    protected ARCHETYPED parseARCHETYPED(JsonObject json) throws IOException, FHIRFormatError {
        ARCHETYPED res = new ARCHETYPED();
        this.parseARCHETYPEDProperties(json, res);
        return res;
    }

    protected void parseARCHETYPEDProperties(JsonObject json, ARCHETYPED res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("archetype_id")) {
            res.setArchetype_id(this.parseARCHETYPE_ID(this.getJObject(json, "archetype_id")));
        }
        if (json.has("template_id")) {
            res.setTemplate_id(this.parseTEMPLATE_ID(this.getJObject(json, "template_id")));
        }
        if (json.has("rm_version")) {
            res.setRm_versionElement(this.parseString(json.get("rm_version").getAsString()));
        }
        if (json.has("_rm_version")) {
            this.parseElementProperties(this.getJObject(json, "_rm_version"), res.getRm_versionElement());
        }
    }

    protected ATTESTATION parseATTESTATION(JsonObject json) throws IOException, FHIRFormatError {
        ATTESTATION res = new ATTESTATION();
        this.parseATTESTATIONProperties(json, res);
        return res;
    }

    protected void parseATTESTATIONProperties(JsonObject json, ATTESTATION res) throws IOException, FHIRFormatError {
        this.parseAUDIT_DETAILSProperties(json, res);
        if (json.has("attested_view")) {
            res.setAttested_view(this.parseDV_MULTIMEDIA(this.getJObject(json, "attested_view")));
        }
        if (json.has("proof")) {
            res.setProofElement(this.parseString(json.get("proof").getAsString()));
        }
        if (json.has("_proof")) {
            this.parseElementProperties(this.getJObject(json, "_proof"), res.getProofElement());
        }
        if (json.has("items")) {
            JsonArray array = this.getJArray(json, "items");
            for (int i = 0; i < array.size(); ++i) {
                res.getItemsList().add(this.parseDV_EHR_URI(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reason")) {
            res.setReason(this.parseDV_TEXT(this.getJObject(json, "reason")));
        }
        if (json.has("is_pending")) {
            res.setIs_pendingElement(this.parseBoolean(json.get("is_pending").getAsBoolean()));
        }
        if (json.has("_is_pending")) {
            this.parseElementProperties(this.getJObject(json, "_is_pending"), res.getIs_pendingElement());
        }
    }

    protected AUDIT_DETAILS parseAUDIT_DETAILS(JsonObject json) throws IOException, FHIRFormatError {
        AUDIT_DETAILS res = new AUDIT_DETAILS();
        this.parseAUDIT_DETAILSProperties(json, res);
        return res;
    }

    protected void parseAUDIT_DETAILSProperties(JsonObject json, AUDIT_DETAILS res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("system_id")) {
            res.setSystem_idElement(this.parseString(json.get("system_id").getAsString()));
        }
        if (json.has("_system_id")) {
            this.parseElementProperties(this.getJObject(json, "_system_id"), res.getSystem_idElement());
        }
        if (json.has("time_committed")) {
            res.setTime_committed(this.parseDV_DATE_TIME(this.getJObject(json, "time_committed")));
        }
        if (json.has("change_type")) {
            res.setChange_type(this.parseDV_CODED_TEXT(this.getJObject(json, "change_type")));
        }
        if (json.has("description")) {
            res.setDescription(this.parseDV_TEXT(this.getJObject(json, "description")));
        }
        if (json.has("committer")) {
            res.setCommitter(this.parsePARTY_PROXY(this.getJObject(json, "committer")));
        }
    }

    protected Annotations parseAnnotations(JsonObject json) throws IOException, FHIRFormatError {
        Annotations res = new Annotations();
        this.parseAnnotationsProperties(json, res);
        return res;
    }

    protected void parseAnnotationsProperties(JsonObject json, Annotations res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
        if (json.has("fhir_mapping")) {
            res.setFhir_mappingElement(this.parseString(json.get("fhir_mapping").getAsString()));
        }
        if (json.has("_fhir_mapping")) {
            this.parseElementProperties(this.getJObject(json, "_fhir_mapping"), res.getFhir_mappingElement());
        }
        if (json.has("vset_description")) {
            res.setVset_descriptionElement(this.parseString(json.get("vset_description").getAsString()));
        }
        if (json.has("_vset_description")) {
            this.parseElementProperties(this.getJObject(json, "_vset_description"), res.getVset_descriptionElement());
        }
        if (json.has("hl7v2_mapping")) {
            res.setHl7v2_mappingElement(this.parseString(json.get("hl7v2_mapping").getAsString()));
        }
        if (json.has("_hl7v2_mapping")) {
            this.parseElementProperties(this.getJObject(json, "_hl7v2_mapping"), res.getHl7v2_mappingElement());
        }
        if (json.has("visibleInView")) {
            res.setVisibleInViewElement(this.parseString(json.get("visibleInView").getAsString()));
        }
        if (json.has("_visibleInView")) {
            this.parseElementProperties(this.getJObject(json, "_visibleInView"), res.getVisibleInViewElement());
        }
    }

    protected CAPABILITY parseCAPABILITY(JsonObject json) throws IOException, FHIRFormatError {
        CAPABILITY res = new CAPABILITY();
        this.parseCAPABILITYProperties(json, res);
        return res;
    }

    protected void parseCAPABILITYProperties(JsonObject json, CAPABILITY res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
        if (json.has("credentials")) {
            res.setCredentials(this.parseITEM_STRUCTURE(this.getJObject(json, "credentials")));
        }
        if (json.has("time_validity")) {
            res.setTime_validity(this.parseDV_INTERVAL(this.getJObject(json, "time_validity")));
        }
    }

    protected CLUSTER parseCLUSTER(JsonObject json) throws IOException, FHIRFormatError {
        CLUSTER res = new CLUSTER();
        this.parseCLUSTERProperties(json, res);
        return res;
    }

    protected void parseCLUSTERProperties(JsonObject json, CLUSTER res) throws IOException, FHIRFormatError {
        this.parseITEMProperties(json, res);
        if (json.has("items")) {
            JsonArray array = this.getJArray(json, "items");
            for (int i = 0; i < array.size(); ++i) {
                res.getItemsList().add(this.parseITEM(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CODE_PHRASE parseCODE_PHRASE(JsonObject json) throws IOException, FHIRFormatError {
        CODE_PHRASE res = new CODE_PHRASE();
        this.parseCODE_PHRASEProperties(json, res);
        return res;
    }

    protected void parseCODE_PHRASEProperties(JsonObject json, CODE_PHRASE res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("terminology_id")) {
            res.setTerminology_id(this.parseTERMINOLOGY_ID(this.getJObject(json, "terminology_id")));
        }
        if (json.has("code_string")) {
            res.setCode_stringElement(this.parseString(json.get("code_string").getAsString()));
        }
        if (json.has("_code_string")) {
            this.parseElementProperties(this.getJObject(json, "_code_string"), res.getCode_stringElement());
        }
        if (json.has("preferred_term")) {
            res.setPreferred_termElement(this.parseString(json.get("preferred_term").getAsString()));
        }
        if (json.has("_preferred_term")) {
            this.parseElementProperties(this.getJObject(json, "_preferred_term"), res.getPreferred_termElement());
        }
    }

    protected COMPOSITION parseCOMPOSITION(JsonObject json) throws IOException, FHIRFormatError {
        COMPOSITION res = new COMPOSITION();
        this.parseCOMPOSITIONProperties(json, res);
        return res;
    }

    protected void parseCOMPOSITIONProperties(JsonObject json, COMPOSITION res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
        if (json.has("language")) {
            res.setLanguage(this.parseCODE_PHRASE(this.getJObject(json, "language")));
        }
        if (json.has("territory")) {
            res.setTerritory(this.parseCODE_PHRASE(this.getJObject(json, "territory")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseDV_CODED_TEXT(this.getJObject(json, "category")));
        }
        if (json.has("context")) {
            res.setContext(this.parseEVENT_CONTEXT(this.getJObject(json, "context")));
        }
        if (json.has("composer")) {
            res.setComposer(this.parsePARTY_PROXY(this.getJObject(json, "composer")));
        }
        if (json.has("content")) {
            JsonArray array = this.getJArray(json, "content");
            for (int i = 0; i < array.size(); ++i) {
                res.getContentList().add(this.parseCONTENT_ITEM(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CONTACT parseCONTACT(JsonObject json) throws IOException, FHIRFormatError {
        CONTACT res = new CONTACT();
        this.parseCONTACTProperties(json, res);
        return res;
    }

    protected void parseCONTACTProperties(JsonObject json, CONTACT res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
        if (json.has("addresses")) {
            JsonArray array = this.getJArray(json, "addresses");
            for (int i = 0; i < array.size(); ++i) {
                res.getAddressesList().add(this.parseADDRESS(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("time_validity")) {
            res.setTime_validity(this.parseDV_INTERVAL(this.getJObject(json, "time_validity")));
        }
    }

    protected CONTRIBUTION parseCONTRIBUTION(JsonObject json) throws IOException, FHIRFormatError {
        CONTRIBUTION res = new CONTRIBUTION();
        this.parseCONTRIBUTIONProperties(json, res);
        return res;
    }

    protected void parseCONTRIBUTIONProperties(JsonObject json, CONTRIBUTION res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("uid")) {
            res.setUid(this.parseHIER_OBJECT_ID(this.getJObject(json, "uid")));
        }
        if (json.has("versions")) {
            JsonArray array = this.getJArray(json, "versions");
            for (int i = 0; i < array.size(); ++i) {
                res.getVersionsList().add(this.parseOBJECT_REF(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("audit")) {
            res.setAudit(this.parseAUDIT_DETAILS(this.getJObject(json, "audit")));
        }
    }

    protected DV_BOOLEAN parseDV_BOOLEAN(JsonObject json) throws IOException, FHIRFormatError {
        DV_BOOLEAN res = new DV_BOOLEAN();
        this.parseDV_BOOLEANProperties(json, res);
        return res;
    }

    protected void parseDV_BOOLEANProperties(JsonObject json, DV_BOOLEAN res) throws IOException, FHIRFormatError {
        this.parseDATA_VALUEProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseBoolean(json.get("value").getAsBoolean()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected DV_CODED_TEXT parseDV_CODED_TEXT(JsonObject json) throws IOException, FHIRFormatError {
        DV_CODED_TEXT res = new DV_CODED_TEXT();
        this.parseDV_CODED_TEXTProperties(json, res);
        return res;
    }

    protected void parseDV_CODED_TEXTProperties(JsonObject json, DV_CODED_TEXT res) throws IOException, FHIRFormatError {
        this.parseDV_TEXTProperties(json, res);
        if (json.has("defining_code")) {
            res.setDefining_code(this.parseCODE_PHRASE(this.getJObject(json, "defining_code")));
        }
    }

    protected DV_COUNT parseDV_COUNT(JsonObject json) throws IOException, FHIRFormatError {
        DV_COUNT res = new DV_COUNT();
        this.parseDV_COUNTProperties(json, res);
        return res;
    }

    protected void parseDV_COUNTProperties(JsonObject json, DV_COUNT res) throws IOException, FHIRFormatError {
        this.parseDV_AMOUNTProperties(json, res);
        if (json.has("magnitude")) {
            res.setMagnitudeElement(this.parseDecimal(json.get("magnitude").getAsBigDecimal()));
        }
        if (json.has("_magnitude")) {
            this.parseElementProperties(this.getJObject(json, "_magnitude"), res.getMagnitudeElement());
        }
    }

    protected DV_DATE_TIME parseDV_DATE_TIME(JsonObject json) throws IOException, FHIRFormatError {
        DV_DATE_TIME res = new DV_DATE_TIME();
        this.parseDV_DATE_TIMEProperties(json, res);
        return res;
    }

    protected void parseDV_DATE_TIMEProperties(JsonObject json, DV_DATE_TIME res) throws IOException, FHIRFormatError {
        this.parseDV_ORDEREDProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDateTime(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected DV_DATE parseDV_DATE(JsonObject json) throws IOException, FHIRFormatError {
        DV_DATE res = new DV_DATE();
        this.parseDV_DATEProperties(json, res);
        return res;
    }

    protected void parseDV_DATEProperties(JsonObject json, DV_DATE res) throws IOException, FHIRFormatError {
        this.parseDV_TEMPORALProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDateTime(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected DV_DURATION parseDV_DURATION(JsonObject json) throws IOException, FHIRFormatError {
        DV_DURATION res = new DV_DURATION();
        this.parseDV_DURATIONProperties(json, res);
        return res;
    }

    protected void parseDV_DURATIONProperties(JsonObject json, DV_DURATION res) throws IOException, FHIRFormatError {
        this.parseDV_AMOUNTProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected DV_EHR_URI parseDV_EHR_URI(JsonObject json) throws IOException, FHIRFormatError {
        DV_EHR_URI res = new DV_EHR_URI();
        this.parseDV_EHR_URIProperties(json, res);
        return res;
    }

    protected void parseDV_EHR_URIProperties(JsonObject json, DV_EHR_URI res) throws IOException, FHIRFormatError {
        this.parseDV_URIProperties(json, res);
    }

    protected DV_GENERAL_TIME_SPECIFICATION parseDV_GENERAL_TIME_SPECIFICATION(JsonObject json) throws IOException, FHIRFormatError {
        DV_GENERAL_TIME_SPECIFICATION res = new DV_GENERAL_TIME_SPECIFICATION();
        this.parseDV_GENERAL_TIME_SPECIFICATIONProperties(json, res);
        return res;
    }

    protected void parseDV_GENERAL_TIME_SPECIFICATIONProperties(JsonObject json, DV_GENERAL_TIME_SPECIFICATION res) throws IOException, FHIRFormatError {
        this.parseDV_TIME_SPECIFICATIONProperties(json, res);
    }

    protected DV_IDENTIFIER parseDV_IDENTIFIER(JsonObject json) throws IOException, FHIRFormatError {
        DV_IDENTIFIER res = new DV_IDENTIFIER();
        this.parseDV_IDENTIFIERProperties(json, res);
        return res;
    }

    protected void parseDV_IDENTIFIERProperties(JsonObject json, DV_IDENTIFIER res) throws IOException, FHIRFormatError {
        this.parseDATA_VALUEProperties(json, res);
        if (json.has("issuer")) {
            res.setIssuerElement(this.parseString(json.get("issuer").getAsString()));
        }
        if (json.has("_issuer")) {
            this.parseElementProperties(this.getJObject(json, "_issuer"), res.getIssuerElement());
        }
        if (json.has("assigner")) {
            res.setAssignerElement(this.parseString(json.get("assigner").getAsString()));
        }
        if (json.has("_assigner")) {
            this.parseElementProperties(this.getJObject(json, "_assigner"), res.getAssignerElement());
        }
        if (json.has("id")) {
            res.setIdElement(this.parseString(json.get("id").getAsString()));
        }
        if (json.has("_id")) {
            this.parseElementProperties(this.getJObject(json, "_id"), res.getIdElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseString(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
    }

    protected DV_INTERVAL parseDV_INTERVAL(JsonObject json) throws IOException, FHIRFormatError {
        DV_INTERVAL res = new DV_INTERVAL();
        this.parseDV_INTERVALProperties(json, res);
        return res;
    }

    protected void parseDV_INTERVALProperties(JsonObject json, DV_INTERVAL res) throws IOException, FHIRFormatError {
        this.parseDV_ORDEREDProperties(json, res);
    }

    protected DV_MULTIMEDIA parseDV_MULTIMEDIA(JsonObject json) throws IOException, FHIRFormatError {
        DV_MULTIMEDIA res = new DV_MULTIMEDIA();
        this.parseDV_MULTIMEDIAProperties(json, res);
        return res;
    }

    protected void parseDV_MULTIMEDIAProperties(JsonObject json, DV_MULTIMEDIA res) throws IOException, FHIRFormatError {
        this.parseDV_ENCAPSULATEDProperties(json, res);
        if (json.has("alternate_text")) {
            res.setAlternate_textElement(this.parseString(json.get("alternate_text").getAsString()));
        }
        if (json.has("_alternate_text")) {
            this.parseElementProperties(this.getJObject(json, "_alternate_text"), res.getAlternate_textElement());
        }
        if (json.has("uri")) {
            res.setUri(this.parseDV_URI(this.getJObject(json, "uri")));
        }
        if (json.has("data")) {
            res.setDataElement(this.parseBase64Binary(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(this.getJObject(json, "_data"), res.getDataElement());
        }
        if (json.has("media_type")) {
            res.setMedia_type(this.parseCODE_PHRASE(this.getJObject(json, "media_type")));
        }
        if (json.has("compression_algorithm")) {
            res.setCompression_algorithm(this.parseCODE_PHRASE(this.getJObject(json, "compression_algorithm")));
        }
        if (json.has("integrity_check")) {
            res.setIntegrity_checkElement(this.parseBase64Binary(json.get("integrity_check").getAsString()));
        }
        if (json.has("_integrity_check")) {
            this.parseElementProperties(this.getJObject(json, "_integrity_check"), res.getIntegrity_checkElement());
        }
        if (json.has("integrity_check_algorithm")) {
            res.setIntegrity_check_algorithm(this.parseCODE_PHRASE(this.getJObject(json, "integrity_check_algorithm")));
        }
        if (json.has("thumbnail")) {
            res.setThumbnail(this.parseDV_MULTIMEDIA(this.getJObject(json, "thumbnail")));
        }
        if (json.has("size")) {
            res.setSizeElement(this.parseInteger(json.get("size").getAsLong()));
        }
        if (json.has("_size")) {
            this.parseElementProperties(this.getJObject(json, "_size"), res.getSizeElement());
        }
    }

    protected DV_ORDINAL parseDV_ORDINAL(JsonObject json) throws IOException, FHIRFormatError {
        DV_ORDINAL res = new DV_ORDINAL();
        this.parseDV_ORDINALProperties(json, res);
        return res;
    }

    protected void parseDV_ORDINALProperties(JsonObject json, DV_ORDINAL res) throws IOException, FHIRFormatError {
        this.parseDV_ORDEREDProperties(json, res);
        if (json.has("symbol")) {
            res.setSymbol(this.parseDV_CODED_TEXT(this.getJObject(json, "symbol")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseInteger(json.get("value").getAsLong()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected DV_PARAGRAPH parseDV_PARAGRAPH(JsonObject json) throws IOException, FHIRFormatError {
        DV_PARAGRAPH res = new DV_PARAGRAPH();
        this.parseDV_PARAGRAPHProperties(json, res);
        return res;
    }

    protected void parseDV_PARAGRAPHProperties(JsonObject json, DV_PARAGRAPH res) throws IOException, FHIRFormatError {
        this.parseDATA_VALUEProperties(json, res);
        if (json.has("items")) {
            JsonArray array = this.getJArray(json, "items");
            for (int i = 0; i < array.size(); ++i) {
                res.getItemsList().add(this.parseDV_TEXT(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DV_PARSABLE parseDV_PARSABLE(JsonObject json) throws IOException, FHIRFormatError {
        DV_PARSABLE res = new DV_PARSABLE();
        this.parseDV_PARSABLEProperties(json, res);
        return res;
    }

    protected void parseDV_PARSABLEProperties(JsonObject json, DV_PARSABLE res) throws IOException, FHIRFormatError {
        this.parseDV_ENCAPSULATEDProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("formalism")) {
            res.setFormalismElement(this.parseString(json.get("formalism").getAsString()));
        }
        if (json.has("_formalism")) {
            this.parseElementProperties(this.getJObject(json, "_formalism"), res.getFormalismElement());
        }
    }

    protected DV_PERIODIC_TIME_SPECIFICATION parseDV_PERIODIC_TIME_SPECIFICATION(JsonObject json) throws IOException, FHIRFormatError {
        DV_PERIODIC_TIME_SPECIFICATION res = new DV_PERIODIC_TIME_SPECIFICATION();
        this.parseDV_PERIODIC_TIME_SPECIFICATIONProperties(json, res);
        return res;
    }

    protected void parseDV_PERIODIC_TIME_SPECIFICATIONProperties(JsonObject json, DV_PERIODIC_TIME_SPECIFICATION res) throws IOException, FHIRFormatError {
        this.parseDV_TIME_SPECIFICATIONProperties(json, res);
    }

    protected DV_PROPORTION parseDV_PROPORTION(JsonObject json) throws IOException, FHIRFormatError {
        DV_PROPORTION res = new DV_PROPORTION();
        this.parseDV_PROPORTIONProperties(json, res);
        return res;
    }

    protected void parseDV_PROPORTIONProperties(JsonObject json, DV_PROPORTION res) throws IOException, FHIRFormatError {
        this.parseDV_AMOUNTProperties(json, res);
        if (json.has("numerator")) {
            res.setNumeratorElement(this.parseDecimal(json.get("numerator").getAsBigDecimal()));
        }
        if (json.has("_numerator")) {
            this.parseElementProperties(this.getJObject(json, "_numerator"), res.getNumeratorElement());
        }
        if (json.has("denominator")) {
            res.setDenominatorElement(this.parseDecimal(json.get("denominator").getAsBigDecimal()));
        }
        if (json.has("_denominator")) {
            this.parseElementProperties(this.getJObject(json, "_denominator"), res.getDenominatorElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("precision")) {
            res.setPrecisionElement(this.parseInteger(json.get("precision").getAsLong()));
        }
        if (json.has("_precision")) {
            this.parseElementProperties(this.getJObject(json, "_precision"), res.getPrecisionElement());
        }
    }

    protected DV_QUANTITY parseDV_QUANTITY(JsonObject json) throws IOException, FHIRFormatError {
        DV_QUANTITY res = new DV_QUANTITY();
        this.parseDV_QUANTITYProperties(json, res);
        return res;
    }

    protected void parseDV_QUANTITYProperties(JsonObject json, DV_QUANTITY res) throws IOException, FHIRFormatError {
        this.parseDV_AMOUNTProperties(json, res);
        if (json.has("magnitude")) {
            res.setMagnitudeElement(this.parseDecimal(json.get("magnitude").getAsBigDecimal()));
        }
        if (json.has("_magnitude")) {
            this.parseElementProperties(this.getJObject(json, "_magnitude"), res.getMagnitudeElement());
        }
        if (json.has("precision")) {
            res.setPrecisionElement(this.parseInteger(json.get("precision").getAsLong()));
        }
        if (json.has("_precision")) {
            this.parseElementProperties(this.getJObject(json, "_precision"), res.getPrecisionElement());
        }
        if (json.has("units")) {
            res.setUnitsElement(this.parseString(json.get("units").getAsString()));
        }
        if (json.has("_units")) {
            this.parseElementProperties(this.getJObject(json, "_units"), res.getUnitsElement());
        }
        if (json.has("units_system")) {
            res.setUnits_systemElement(this.parseString(json.get("units_system").getAsString()));
        }
        if (json.has("_units_system")) {
            this.parseElementProperties(this.getJObject(json, "_units_system"), res.getUnits_systemElement());
        }
        if (json.has("units_display_name")) {
            res.setUnits_display_nameElement(this.parseString(json.get("units_display_name").getAsString()));
        }
        if (json.has("_units_display_name")) {
            this.parseElementProperties(this.getJObject(json, "_units_display_name"), res.getUnits_display_nameElement());
        }
    }

    protected DV_SCALE parseDV_SCALE(JsonObject json) throws IOException, FHIRFormatError {
        DV_SCALE res = new DV_SCALE();
        this.parseDV_SCALEProperties(json, res);
        return res;
    }

    protected void parseDV_SCALEProperties(JsonObject json, DV_SCALE res) throws IOException, FHIRFormatError {
        this.parseDV_ORDEREDProperties(json, res);
        if (json.has("symbol")) {
            res.setSymbol(this.parseDV_CODED_TEXT(this.getJObject(json, "symbol")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected DV_STATE parseDV_STATE(JsonObject json) throws IOException, FHIRFormatError {
        DV_STATE res = new DV_STATE();
        this.parseDV_STATEProperties(json, res);
        return res;
    }

    protected void parseDV_STATEProperties(JsonObject json, DV_STATE res) throws IOException, FHIRFormatError {
        this.parseDATA_VALUEProperties(json, res);
        if (json.has("value")) {
            res.setValue(this.parseDV_CODED_TEXT(this.getJObject(json, "value")));
        }
        if (json.has("is_terminal")) {
            res.setIs_terminalElement(this.parseBoolean(json.get("is_terminal").getAsBoolean()));
        }
        if (json.has("_is_terminal")) {
            this.parseElementProperties(this.getJObject(json, "_is_terminal"), res.getIs_terminalElement());
        }
    }

    protected DV_TEXT parseDV_TEXT(JsonObject json) throws IOException, FHIRFormatError {
        DV_TEXT res = new DV_TEXT();
        this.parseDV_TEXTProperties(json, res);
        return res;
    }

    protected void parseDV_TEXTProperties(JsonObject json, DV_TEXT res) throws IOException, FHIRFormatError {
        this.parseDATA_VALUEProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("hyperlink")) {
            res.setHyperlink(this.parseDV_URI(this.getJObject(json, "hyperlink")));
        }
        if (json.has("formatting")) {
            res.setFormattingElement(this.parseString(json.get("formatting").getAsString()));
        }
        if (json.has("_formatting")) {
            this.parseElementProperties(this.getJObject(json, "_formatting"), res.getFormattingElement());
        }
        if (json.has("mappings")) {
            JsonArray array = this.getJArray(json, "mappings");
            for (int i = 0; i < array.size(); ++i) {
                res.getMappingsList().add(this.parseTERM_MAPPING(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("language")) {
            res.setLanguage(this.parseCODE_PHRASE(this.getJObject(json, "language")));
        }
        if (json.has("encoding")) {
            res.setEncoding(this.parseCODE_PHRASE(this.getJObject(json, "encoding")));
        }
    }

    protected DV_TIME parseDV_TIME(JsonObject json) throws IOException, FHIRFormatError {
        DV_TIME res = new DV_TIME();
        this.parseDV_TIMEProperties(json, res);
        return res;
    }

    protected void parseDV_TIMEProperties(JsonObject json, DV_TIME res) throws IOException, FHIRFormatError {
        this.parseDV_ORDEREDProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected DV_URI parseDV_URI(JsonObject json) throws IOException, FHIRFormatError {
        DV_URI res = new DV_URI();
        this.parseDV_URIProperties(json, res);
        return res;
    }

    protected void parseDV_URIProperties(JsonObject json, DV_URI res) throws IOException, FHIRFormatError {
        this.parseDATA_VALUEProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseUri(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected EHR_ACCESS parseEHR_ACCESS(JsonObject json) throws IOException, FHIRFormatError {
        EHR_ACCESS res = new EHR_ACCESS();
        this.parseEHR_ACCESSProperties(json, res);
        return res;
    }

    protected void parseEHR_ACCESSProperties(JsonObject json, EHR_ACCESS res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
        if (json.has("settings")) {
            res.setSettings(this.parseACCESS_CONTROL_SETTINGS(this.getJObject(json, "settings")));
        }
    }

    protected EHR_STATUS parseEHR_STATUS(JsonObject json) throws IOException, FHIRFormatError {
        EHR_STATUS res = new EHR_STATUS();
        this.parseEHR_STATUSProperties(json, res);
        return res;
    }

    protected void parseEHR_STATUSProperties(JsonObject json, EHR_STATUS res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
        if (json.has("subject")) {
            res.setSubject(this.parsePARTY_SELF(this.getJObject(json, "subject")));
        }
        if (json.has("is_queryable")) {
            res.setIs_queryableElement(this.parseBoolean(json.get("is_queryable").getAsBoolean()));
        }
        if (json.has("_is_queryable")) {
            this.parseElementProperties(this.getJObject(json, "_is_queryable"), res.getIs_queryableElement());
        }
        if (json.has("is_modifiable")) {
            res.setIs_modifiableElement(this.parseBoolean(json.get("is_modifiable").getAsBoolean()));
        }
        if (json.has("_is_modifiable")) {
            this.parseElementProperties(this.getJObject(json, "_is_modifiable"), res.getIs_modifiableElement());
        }
        if (json.has("other_details")) {
            res.setOther_details(this.parseITEM_STRUCTURE(this.getJObject(json, "other_details")));
        }
    }

    protected EHR parseEHR(JsonObject json) throws IOException, FHIRFormatError {
        EHR res = new EHR();
        this.parseEHRProperties(json, res);
        return res;
    }

    protected void parseEHRProperties(JsonObject json, EHR res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseAnyProperties(json, res);
        if (json.has("system_id")) {
            array = this.getJArray(json, "system_id");
            for (i = 0; i < array.size(); ++i) {
                res.getSystem_idList().add(this.parseHIER_OBJECT_ID(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("ehr_id")) {
            res.setEhr_id(this.parseHIER_OBJECT_ID(this.getJObject(json, "ehr_id")));
        }
        if (json.has("contributions")) {
            array = this.getJArray(json, "contributions");
            for (i = 0; i < array.size(); ++i) {
                res.getContributionsList().add(this.parseOBJECT_REF(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("ehr_status")) {
            res.setEhr_status(this.parseOBJECT_REF(this.getJObject(json, "ehr_status")));
        }
        if (json.has("ehr_access")) {
            res.setEhr_access(this.parseOBJECT_REF(this.getJObject(json, "ehr_access")));
        }
        if (json.has("compositions")) {
            array = this.getJArray(json, "compositions");
            for (i = 0; i < array.size(); ++i) {
                res.getCompositionsList().add(this.parseOBJECT_REF(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("directory")) {
            res.setDirectory(this.parseOBJECT_REF(this.getJObject(json, "directory")));
        }
        if (json.has("time_created")) {
            res.setTime_created(this.parseDV_DATE_TIME(this.getJObject(json, "time_created")));
        }
        if (json.has("folders")) {
            array = this.getJArray(json, "folders");
            for (i = 0; i < array.size(); ++i) {
                res.getFoldersList().add(this.parseOBJECT_REF(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("tags")) {
            array = this.getJArray(json, "tags");
            for (i = 0; i < array.size(); ++i) {
                res.getTagsList().add(this.parseOBJECT_REF(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ELEMENT parseELEMENT(JsonObject json) throws IOException, FHIRFormatError {
        ELEMENT res = new ELEMENT();
        this.parseELEMENTProperties(json, res);
        return res;
    }

    protected void parseELEMENTProperties(JsonObject json, ELEMENT res) throws IOException, FHIRFormatError {
        this.parseITEMProperties(json, res);
        if (json.has("null_flavour")) {
            res.setNull_flavour(this.parseDV_CODED_TEXT(this.getJObject(json, "null_flavour")));
        }
        if (json.has("value")) {
            res.setValue(this.parseDATA_VALUE(this.getJObject(json, "value")));
        }
        if (json.has("null_reason")) {
            res.setNull_reason(this.parseDV_TEXT(this.getJObject(json, "null_reason")));
        }
    }

    protected EVALUATION parseEVALUATION(JsonObject json) throws IOException, FHIRFormatError {
        EVALUATION res = new EVALUATION();
        this.parseEVALUATIONProperties(json, res);
        return res;
    }

    protected void parseEVALUATIONProperties(JsonObject json, EVALUATION res) throws IOException, FHIRFormatError {
        this.parseCARE_ENTRYProperties(json, res);
        if (json.has("data")) {
            res.setData(this.parseITEM_STRUCTURE(this.getJObject(json, "data")));
        }
    }

    protected EVENT_CONTEXT parseEVENT_CONTEXT(JsonObject json) throws IOException, FHIRFormatError {
        EVENT_CONTEXT res = new EVENT_CONTEXT();
        this.parseEVENT_CONTEXTProperties(json, res);
        return res;
    }

    protected void parseEVENT_CONTEXTProperties(JsonObject json, EVENT_CONTEXT res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
        if (json.has("start_time")) {
            res.setStart_time(this.parseDV_DATE_TIME(this.getJObject(json, "start_time")));
        }
        if (json.has("end_time")) {
            res.setEnd_time(this.parseDV_DATE_TIME(this.getJObject(json, "end_time")));
        }
        if (json.has("location")) {
            res.setLocationElement(this.parseString(json.get("location").getAsString()));
        }
        if (json.has("_location")) {
            this.parseElementProperties(this.getJObject(json, "_location"), res.getLocationElement());
        }
        if (json.has("setting")) {
            res.setSetting(this.parseDV_CODED_TEXT(this.getJObject(json, "setting")));
        }
        if (json.has("other_context")) {
            res.setOther_context(this.parseITEM_STRUCTURE(this.getJObject(json, "other_context")));
        }
        if (json.has("health_care_facility")) {
            res.setHealth_care_facility(this.parsePARTY_IDENTIFIED(this.getJObject(json, "health_care_facility")));
        }
        if (json.has("participations")) {
            JsonArray array = this.getJArray(json, "participations");
            for (int i = 0; i < array.size(); ++i) {
                res.getParticipationsList().add(this.parsePARTICIPATION(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected FEEDER_AUDIT_DETAILS parseFEEDER_AUDIT_DETAILS(JsonObject json) throws IOException, FHIRFormatError {
        FEEDER_AUDIT_DETAILS res = new FEEDER_AUDIT_DETAILS();
        this.parseFEEDER_AUDIT_DETAILSProperties(json, res);
        return res;
    }

    protected void parseFEEDER_AUDIT_DETAILSProperties(JsonObject json, FEEDER_AUDIT_DETAILS res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("system_id")) {
            res.setSystem_idElement(this.parseString(json.get("system_id").getAsString()));
        }
        if (json.has("_system_id")) {
            this.parseElementProperties(this.getJObject(json, "_system_id"), res.getSystem_idElement());
        }
        if (json.has("location")) {
            res.setLocation(this.parsePARTY_IDENTIFIED(this.getJObject(json, "location")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parsePARTY_PROXY(this.getJObject(json, "subject")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parsePARTY_IDENTIFIED(this.getJObject(json, "provider")));
        }
        if (json.has("time")) {
            res.setTime(this.parseDV_DATE_TIME(this.getJObject(json, "time")));
        }
        if (json.has("version_id")) {
            res.setVersion_idElement(this.parseString(json.get("version_id").getAsString()));
        }
        if (json.has("_version_id")) {
            this.parseElementProperties(this.getJObject(json, "_version_id"), res.getVersion_idElement());
        }
        if (json.has("other_details")) {
            res.setOther_details(this.parseITEM_STRUCTURE(this.getJObject(json, "other_details")));
        }
    }

    protected FEEDER_AUDIT parseFEEDER_AUDIT(JsonObject json) throws IOException, FHIRFormatError {
        FEEDER_AUDIT res = new FEEDER_AUDIT();
        this.parseFEEDER_AUDITProperties(json, res);
        return res;
    }

    protected void parseFEEDER_AUDITProperties(JsonObject json, FEEDER_AUDIT res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBaseProperties(json, res);
        if (json.has("originating_system_item_ids")) {
            array = this.getJArray(json, "originating_system_item_ids");
            for (i = 0; i < array.size(); ++i) {
                res.getOriginating_system_item_idsList().add(this.parseDV_IDENTIFIER(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("feeder_system_item_ids")) {
            array = this.getJArray(json, "feeder_system_item_ids");
            for (i = 0; i < array.size(); ++i) {
                res.getFeeder_system_item_idsList().add(this.parseDV_IDENTIFIER(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("original_content")) {
            res.setOriginal_content(this.parseDV_ENCAPSULATED(this.getJObject(json, "original_content")));
        }
        if (json.has("originating_system_audit")) {
            res.setOriginating_system_audit(this.parseFEEDER_AUDIT_DETAILS(this.getJObject(json, "originating_system_audit")));
        }
        if (json.has("feeder_system_audit")) {
            res.setFeeder_system_audit(this.parseFEEDER_AUDIT_DETAILS(this.getJObject(json, "feeder_system_audit")));
        }
    }

    protected FOLDER parseFOLDER(JsonObject json) throws IOException, FHIRFormatError {
        FOLDER res = new FOLDER();
        this.parseFOLDERProperties(json, res);
        return res;
    }

    protected void parseFOLDERProperties(JsonObject json, FOLDER res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseLOCATABLEProperties(json, res);
        if (json.has("items")) {
            array = this.getJArray(json, "items");
            for (i = 0; i < array.size(); ++i) {
                res.getItemsList().add(this.parseOBJECT_REF(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("folders")) {
            array = this.getJArray(json, "folders");
            for (i = 0; i < array.size(); ++i) {
                res.getFoldersList().add(this.parseFOLDER(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("details")) {
            res.setDetails(this.parseITEM_STRUCTURE(this.getJObject(json, "details")));
        }
    }

    protected GENERIC_ID parseGENERIC_ID(JsonObject json) throws IOException, FHIRFormatError {
        GENERIC_ID res = new GENERIC_ID();
        this.parseGENERIC_IDProperties(json, res);
        return res;
    }

    protected void parseGENERIC_IDProperties(JsonObject json, GENERIC_ID res) throws IOException, FHIRFormatError {
        this.parseOBJECT_IDProperties(json, res);
    }

    protected GROUP parseGROUP(JsonObject json) throws IOException, FHIRFormatError {
        GROUP res = new GROUP();
        this.parseGROUPProperties(json, res);
        return res;
    }

    protected void parseGROUPProperties(JsonObject json, GROUP res) throws IOException, FHIRFormatError {
        this.parseACTORProperties(json, res);
    }

    protected HIER_OBJECT_ID parseHIER_OBJECT_ID(JsonObject json) throws IOException, FHIRFormatError {
        HIER_OBJECT_ID res = new HIER_OBJECT_ID();
        this.parseHIER_OBJECT_IDProperties(json, res);
        return res;
    }

    protected void parseHIER_OBJECT_IDProperties(JsonObject json, HIER_OBJECT_ID res) throws IOException, FHIRFormatError {
        this.parseUID_BASED_IDProperties(json, res);
    }

    protected HISTORY parseHISTORY(JsonObject json) throws IOException, FHIRFormatError {
        HISTORY res = new HISTORY();
        this.parseHISTORYProperties(json, res);
        return res;
    }

    protected void parseHISTORYProperties(JsonObject json, HISTORY res) throws IOException, FHIRFormatError {
        this.parseDATA_STRUCTUREProperties(json, res);
        if (json.has("origin")) {
            res.setOrigin(this.parseDV_DATE_TIME(this.getJObject(json, "origin")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parseDV_DURATION(this.getJObject(json, "period")));
        }
        if (json.has("duration")) {
            res.setDuration(this.parseDV_DURATION(this.getJObject(json, "duration")));
        }
        if (json.has("summary")) {
            res.setSummary(this.parseITEM_STRUCTURE(this.getJObject(json, "summary")));
        }
        if (json.has("events")) {
            JsonArray array = this.getJArray(json, "events");
            for (int i = 0; i < array.size(); ++i) {
                res.getEventsList().add(this.parseEVENT(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected IMPORTED_VERSION parseIMPORTED_VERSION(JsonObject json) throws IOException, FHIRFormatError {
        IMPORTED_VERSION res = new IMPORTED_VERSION();
        this.parseIMPORTED_VERSIONProperties(json, res);
        return res;
    }

    protected void parseIMPORTED_VERSIONProperties(JsonObject json, IMPORTED_VERSION res) throws IOException, FHIRFormatError {
        this.parseVERSIONProperties(json, res);
        if (json.has("item")) {
            res.setItem(this.parseORIGINAL_VERSION(this.getJObject(json, "item")));
        }
    }

    protected INSTRUCTION_DETAILS parseINSTRUCTION_DETAILS(JsonObject json) throws IOException, FHIRFormatError {
        INSTRUCTION_DETAILS res = new INSTRUCTION_DETAILS();
        this.parseINSTRUCTION_DETAILSProperties(json, res);
        return res;
    }

    protected void parseINSTRUCTION_DETAILSProperties(JsonObject json, INSTRUCTION_DETAILS res) throws IOException, FHIRFormatError {
        this.parsePATHABLEProperties(json, res);
        if (json.has("instruction_id")) {
            res.setInstruction_id(this.parseLOCATABLE_REF(this.getJObject(json, "instruction_id")));
        }
        if (json.has("activity_id")) {
            res.setActivity_idElement(this.parseString(json.get("activity_id").getAsString()));
        }
        if (json.has("_activity_id")) {
            this.parseElementProperties(this.getJObject(json, "_activity_id"), res.getActivity_idElement());
        }
        if (json.has("wf_details")) {
            res.setWf_details(this.parseITEM_STRUCTURE(this.getJObject(json, "wf_details")));
        }
    }

    protected INSTRUCTION parseINSTRUCTION(JsonObject json) throws IOException, FHIRFormatError {
        INSTRUCTION res = new INSTRUCTION();
        this.parseINSTRUCTIONProperties(json, res);
        return res;
    }

    protected void parseINSTRUCTIONProperties(JsonObject json, INSTRUCTION res) throws IOException, FHIRFormatError {
        this.parseCARE_ENTRYProperties(json, res);
        if (json.has("narrative")) {
            res.setNarrative(this.parseDV_TEXT(this.getJObject(json, "narrative")));
        }
        if (json.has("expiry_time")) {
            res.setExpiry_time(this.parseDV_DATE_TIME(this.getJObject(json, "expiry_time")));
        }
        if (json.has("wf_definition")) {
            res.setWf_definition(this.parseDV_PARSABLE(this.getJObject(json, "wf_definition")));
        }
        if (json.has("activities")) {
            JsonArray array = this.getJArray(json, "activities");
            for (int i = 0; i < array.size(); ++i) {
                res.getActivitiesList().add(this.parseACTIVITY(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected INTERNET_ID parseINTERNET_ID(JsonObject json) throws IOException, FHIRFormatError {
        INTERNET_ID res = new INTERNET_ID();
        this.parseINTERNET_IDProperties(json, res);
        return res;
    }

    protected void parseINTERNET_IDProperties(JsonObject json, INTERNET_ID res) throws IOException, FHIRFormatError {
        this.parseUIDProperties(json, res);
    }

    protected INTERVAL_EVENT parseINTERVAL_EVENT(JsonObject json) throws IOException, FHIRFormatError {
        INTERVAL_EVENT res = new INTERVAL_EVENT();
        this.parseINTERVAL_EVENTProperties(json, res);
        return res;
    }

    protected void parseINTERVAL_EVENTProperties(JsonObject json, INTERVAL_EVENT res) throws IOException, FHIRFormatError {
        this.parseEVENTProperties(json, res);
        if (json.has("width")) {
            res.setWidth(this.parseDV_DURATION(this.getJObject(json, "width")));
        }
        if (json.has("sample_count")) {
            res.setSample_countElement(this.parseInteger(json.get("sample_count").getAsLong()));
        }
        if (json.has("_sample_count")) {
            this.parseElementProperties(this.getJObject(json, "_sample_count"), res.getSample_countElement());
        }
        if (json.has("math_function")) {
            res.setMath_function(this.parseDV_CODED_TEXT(this.getJObject(json, "math_function")));
        }
    }

    protected ISM_TRANSITION parseISM_TRANSITION(JsonObject json) throws IOException, FHIRFormatError {
        ISM_TRANSITION res = new ISM_TRANSITION();
        this.parseISM_TRANSITIONProperties(json, res);
        return res;
    }

    protected void parseISM_TRANSITIONProperties(JsonObject json, ISM_TRANSITION res) throws IOException, FHIRFormatError {
        this.parsePATHABLEProperties(json, res);
        if (json.has("current_state")) {
            res.setCurrent_state(this.parseDV_CODED_TEXT(this.getJObject(json, "current_state")));
        }
        if (json.has("transition")) {
            res.setTransition(this.parseDV_CODED_TEXT(this.getJObject(json, "transition")));
        }
        if (json.has("careflow_step")) {
            res.setCareflow_step(this.parseDV_CODED_TEXT(this.getJObject(json, "careflow_step")));
        }
        if (json.has("reason")) {
            JsonArray array = this.getJArray(json, "reason");
            for (int i = 0; i < array.size(); ++i) {
                res.getReasonList().add(this.parseDV_TEXT(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ISO_OID parseISO_OID(JsonObject json) throws IOException, FHIRFormatError {
        ISO_OID res = new ISO_OID();
        this.parseISO_OIDProperties(json, res);
        return res;
    }

    protected void parseISO_OIDProperties(JsonObject json, ISO_OID res) throws IOException, FHIRFormatError {
        this.parseUIDProperties(json, res);
    }

    protected ITEM_LIST parseITEM_LIST(JsonObject json) throws IOException, FHIRFormatError {
        ITEM_LIST res = new ITEM_LIST();
        this.parseITEM_LISTProperties(json, res);
        return res;
    }

    protected void parseITEM_LISTProperties(JsonObject json, ITEM_LIST res) throws IOException, FHIRFormatError {
        this.parseITEM_STRUCTUREProperties(json, res);
        if (json.has("items")) {
            JsonArray array = this.getJArray(json, "items");
            for (int i = 0; i < array.size(); ++i) {
                res.getItemsList().add(this.parseELEMENT(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ITEM_SINGLE parseITEM_SINGLE(JsonObject json) throws IOException, FHIRFormatError {
        ITEM_SINGLE res = new ITEM_SINGLE();
        this.parseITEM_SINGLEProperties(json, res);
        return res;
    }

    protected void parseITEM_SINGLEProperties(JsonObject json, ITEM_SINGLE res) throws IOException, FHIRFormatError {
        this.parseITEM_STRUCTUREProperties(json, res);
        if (json.has("item")) {
            res.setItem(this.parseELEMENT(this.getJObject(json, "item")));
        }
    }

    protected ITEM_TABLE parseITEM_TABLE(JsonObject json) throws IOException, FHIRFormatError {
        ITEM_TABLE res = new ITEM_TABLE();
        this.parseITEM_TABLEProperties(json, res);
        return res;
    }

    protected void parseITEM_TABLEProperties(JsonObject json, ITEM_TABLE res) throws IOException, FHIRFormatError {
        this.parseITEM_STRUCTUREProperties(json, res);
        if (json.has("rows")) {
            JsonArray array = this.getJArray(json, "rows");
            for (int i = 0; i < array.size(); ++i) {
                res.getRowsList().add(this.parseCLUSTER(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ITEM_TAG parseITEM_TAG(JsonObject json) throws IOException, FHIRFormatError {
        ITEM_TAG res = new ITEM_TAG();
        this.parseITEM_TAGProperties(json, res);
        return res;
    }

    protected void parseITEM_TAGProperties(JsonObject json, ITEM_TAG res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("key")) {
            res.setKeyElement(this.parseString(json.get("key").getAsString()));
        }
        if (json.has("_key")) {
            this.parseElementProperties(this.getJObject(json, "_key"), res.getKeyElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseUID_BASED_ID(this.getJObject(json, "target")));
        }
        if (json.has("target_path")) {
            res.setTarget_pathElement(this.parseString(json.get("target_path").getAsString()));
        }
        if (json.has("_target_path")) {
            this.parseElementProperties(this.getJObject(json, "_target_path"), res.getTarget_pathElement());
        }
        if (json.has("owner_id")) {
            res.setOwner_id(this.parseOBJECT_REF(this.getJObject(json, "owner_id")));
        }
    }

    protected ITEM_TREE parseITEM_TREE(JsonObject json) throws IOException, FHIRFormatError {
        ITEM_TREE res = new ITEM_TREE();
        this.parseITEM_TREEProperties(json, res);
        return res;
    }

    protected void parseITEM_TREEProperties(JsonObject json, ITEM_TREE res) throws IOException, FHIRFormatError {
        this.parseITEM_STRUCTUREProperties(json, res);
        if (json.has("items")) {
            JsonArray array = this.getJArray(json, "items");
            for (int i = 0; i < array.size(); ++i) {
                res.getItemsList().add(this.parseITEM(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected LINK parseLINK(JsonObject json) throws IOException, FHIRFormatError {
        LINK res = new LINK();
        this.parseLINKProperties(json, res);
        return res;
    }

    protected void parseLINKProperties(JsonObject json, LINK res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("meaning")) {
            res.setMeaning(this.parseDV_TEXT(this.getJObject(json, "meaning")));
        }
        if (json.has("type")) {
            res.setType(this.parseDV_TEXT(this.getJObject(json, "type")));
        }
        if (json.has("target")) {
            res.setTarget(this.parseDV_EHR_URI(this.getJObject(json, "target")));
        }
    }

    protected LOCATABLE_REF parseLOCATABLE_REF(JsonObject json) throws IOException, FHIRFormatError {
        LOCATABLE_REF res = new LOCATABLE_REF();
        this.parseLOCATABLE_REFProperties(json, res);
        return res;
    }

    protected void parseLOCATABLE_REFProperties(JsonObject json, LOCATABLE_REF res) throws IOException, FHIRFormatError {
        this.parseOBJECT_REFProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
    }

    protected OBJECT_REF parseOBJECT_REF(JsonObject json) throws IOException, FHIRFormatError {
        OBJECT_REF res = new OBJECT_REF();
        this.parseOBJECT_REFProperties(json, res);
        return res;
    }

    protected void parseOBJECT_REFProperties(JsonObject json, OBJECT_REF res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("namespace")) {
            res.setNamespaceElement(this.parseString(json.get("namespace").getAsString()));
        }
        if (json.has("_namespace")) {
            this.parseElementProperties(this.getJObject(json, "_namespace"), res.getNamespaceElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseString(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("id")) {
            res.setId(this.parseOBJECT_ID(this.getJObject(json, "id")));
        }
    }

    protected OBJECT_VERSION_ID parseOBJECT_VERSION_ID(JsonObject json) throws IOException, FHIRFormatError {
        OBJECT_VERSION_ID res = new OBJECT_VERSION_ID();
        this.parseOBJECT_VERSION_IDProperties(json, res);
        return res;
    }

    protected void parseOBJECT_VERSION_IDProperties(JsonObject json, OBJECT_VERSION_ID res) throws IOException, FHIRFormatError {
        this.parseUID_BASED_IDProperties(json, res);
    }

    protected OBSERVATION parseOBSERVATION(JsonObject json) throws IOException, FHIRFormatError {
        OBSERVATION res = new OBSERVATION();
        this.parseOBSERVATIONProperties(json, res);
        return res;
    }

    protected void parseOBSERVATIONProperties(JsonObject json, OBSERVATION res) throws IOException, FHIRFormatError {
        this.parseCARE_ENTRYProperties(json, res);
        if (json.has("data")) {
            res.setData(this.parseHISTORY(this.getJObject(json, "data")));
        }
        if (json.has("state")) {
            res.setState(this.parseHISTORY(this.getJObject(json, "state")));
        }
    }

    protected ORGANISATION parseORGANISATION(JsonObject json) throws IOException, FHIRFormatError {
        ORGANISATION res = new ORGANISATION();
        this.parseORGANISATIONProperties(json, res);
        return res;
    }

    protected void parseORGANISATIONProperties(JsonObject json, ORGANISATION res) throws IOException, FHIRFormatError {
        this.parseACTORProperties(json, res);
    }

    protected ORIGINAL_VERSION parseORIGINAL_VERSION(JsonObject json) throws IOException, FHIRFormatError {
        ORIGINAL_VERSION res = new ORIGINAL_VERSION();
        this.parseORIGINAL_VERSIONProperties(json, res);
        return res;
    }

    protected void parseORIGINAL_VERSIONProperties(JsonObject json, ORIGINAL_VERSION res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseVERSIONProperties(json, res);
        if (json.has("uid")) {
            res.setUid(this.parseOBJECT_VERSION_ID(this.getJObject(json, "uid")));
        }
        if (json.has("preceding_version_uid")) {
            res.setPreceding_version_uid(this.parseOBJECT_VERSION_ID(this.getJObject(json, "preceding_version_uid")));
        }
        if (json.has("other_input_version_uids")) {
            array = this.getJArray(json, "other_input_version_uids");
            for (i = 0; i < array.size(); ++i) {
                res.getOther_input_version_uidsList().add(this.parseOBJECT_VERSION_ID(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("lifecycle_state")) {
            res.setLifecycle_state(this.parseDV_CODED_TEXT(this.getJObject(json, "lifecycle_state")));
        }
        if (json.has("attestations")) {
            array = this.getJArray(json, "attestations");
            for (i = 0; i < array.size(); ++i) {
                res.getAttestationsList().add(this.parseATTESTATION(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("data")) {
            res.setData(this.parseAny(this.getJObject(json, "data")));
        }
    }

    protected PARTICIPATION parsePARTICIPATION(JsonObject json) throws IOException, FHIRFormatError {
        PARTICIPATION res = new PARTICIPATION();
        this.parsePARTICIPATIONProperties(json, res);
        return res;
    }

    protected void parsePARTICIPATIONProperties(JsonObject json, PARTICIPATION res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
        if (json.has("function")) {
            res.setFunction(this.parseDV_TEXT(this.getJObject(json, "function")));
        }
        if (json.has("mode")) {
            res.setMode(this.parseDV_CODED_TEXT(this.getJObject(json, "mode")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parsePARTY_PROXY(this.getJObject(json, "performer")));
        }
        if (json.has("time")) {
            res.setTime(this.parseDV_INTERVAL(this.getJObject(json, "time")));
        }
    }

    protected PARTY_IDENTIFIED parsePARTY_IDENTIFIED(JsonObject json) throws IOException, FHIRFormatError {
        PARTY_IDENTIFIED res = new PARTY_IDENTIFIED();
        this.parsePARTY_IDENTIFIEDProperties(json, res);
        return res;
    }

    protected void parsePARTY_IDENTIFIEDProperties(JsonObject json, PARTY_IDENTIFIED res) throws IOException, FHIRFormatError {
        this.parsePARTY_PROXYProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("identifiers")) {
            JsonArray array = this.getJArray(json, "identifiers");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifiersList().add(this.parseDV_IDENTIFIER(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected PARTY_IDENTITY parsePARTY_IDENTITY(JsonObject json) throws IOException, FHIRFormatError {
        PARTY_IDENTITY res = new PARTY_IDENTITY();
        this.parsePARTY_IDENTITYProperties(json, res);
        return res;
    }

    protected void parsePARTY_IDENTITYProperties(JsonObject json, PARTY_IDENTITY res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
        if (json.has("details")) {
            res.setDetails(this.parseITEM_STRUCTURE(this.getJObject(json, "details")));
        }
    }

    protected PARTY_REF parsePARTY_REF(JsonObject json) throws IOException, FHIRFormatError {
        PARTY_REF res = new PARTY_REF();
        this.parsePARTY_REFProperties(json, res);
        return res;
    }

    protected void parsePARTY_REFProperties(JsonObject json, PARTY_REF res) throws IOException, FHIRFormatError {
        this.parseOBJECT_REFProperties(json, res);
    }

    protected PARTY_RELATED parsePARTY_RELATED(JsonObject json) throws IOException, FHIRFormatError {
        PARTY_RELATED res = new PARTY_RELATED();
        this.parsePARTY_RELATEDProperties(json, res);
        return res;
    }

    protected void parsePARTY_RELATEDProperties(JsonObject json, PARTY_RELATED res) throws IOException, FHIRFormatError {
        this.parsePARTY_IDENTIFIEDProperties(json, res);
        if (json.has("relationship")) {
            res.setRelationship(this.parseDV_CODED_TEXT(this.getJObject(json, "relationship")));
        }
    }

    protected PARTY_RELATIONSHIP parsePARTY_RELATIONSHIP(JsonObject json) throws IOException, FHIRFormatError {
        PARTY_RELATIONSHIP res = new PARTY_RELATIONSHIP();
        this.parsePARTY_RELATIONSHIPProperties(json, res);
        return res;
    }

    protected void parsePARTY_RELATIONSHIPProperties(JsonObject json, PARTY_RELATIONSHIP res) throws IOException, FHIRFormatError {
        this.parseLOCATABLEProperties(json, res);
        if (json.has("details")) {
            res.setDetails(this.parseITEM_STRUCTURE(this.getJObject(json, "details")));
        }
        if (json.has("target")) {
            res.setTarget(this.parsePARTY_REF(this.getJObject(json, "target")));
        }
        if (json.has("time_validity")) {
            res.setTime_validity(this.parseDV_INTERVAL(this.getJObject(json, "time_validity")));
        }
        if (json.has("source")) {
            res.setSource(this.parsePARTY_REF(this.getJObject(json, "source")));
        }
    }

    protected PARTY_SELF parsePARTY_SELF(JsonObject json) throws IOException, FHIRFormatError {
        PARTY_SELF res = new PARTY_SELF();
        this.parsePARTY_SELFProperties(json, res);
        return res;
    }

    protected void parsePARTY_SELFProperties(JsonObject json, PARTY_SELF res) throws IOException, FHIRFormatError {
        this.parsePARTY_PROXYProperties(json, res);
    }

    protected PERSON parsePERSON(JsonObject json) throws IOException, FHIRFormatError {
        PERSON res = new PERSON();
        this.parsePERSONProperties(json, res);
        return res;
    }

    protected void parsePERSONProperties(JsonObject json, PERSON res) throws IOException, FHIRFormatError {
        this.parseACTORProperties(json, res);
    }

    protected POINT_EVENT parsePOINT_EVENT(JsonObject json) throws IOException, FHIRFormatError {
        POINT_EVENT res = new POINT_EVENT();
        this.parsePOINT_EVENTProperties(json, res);
        return res;
    }

    protected void parsePOINT_EVENTProperties(JsonObject json, POINT_EVENT res) throws IOException, FHIRFormatError {
        this.parseEVENTProperties(json, res);
    }

    protected REFERENCE_RANGE parseREFERENCE_RANGE(JsonObject json) throws IOException, FHIRFormatError {
        REFERENCE_RANGE res = new REFERENCE_RANGE();
        this.parseREFERENCE_RANGEProperties(json, res);
        return res;
    }

    protected void parseREFERENCE_RANGEProperties(JsonObject json, REFERENCE_RANGE res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("meaning")) {
            res.setMeaning(this.parseDV_TEXT(this.getJObject(json, "meaning")));
        }
        if (json.has("range")) {
            res.setRange(this.parseDV_INTERVAL(this.getJObject(json, "range")));
        }
    }

    protected RESOURCE_DESCRIPTION_ITEM parseRESOURCE_DESCRIPTION_ITEM(JsonObject json) throws IOException, FHIRFormatError {
        RESOURCE_DESCRIPTION_ITEM res = new RESOURCE_DESCRIPTION_ITEM();
        this.parseRESOURCE_DESCRIPTION_ITEMProperties(json, res);
        return res;
    }

    protected void parseRESOURCE_DESCRIPTION_ITEMProperties(JsonObject json, RESOURCE_DESCRIPTION_ITEM res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBaseProperties(json, res);
        if (json.has("language")) {
            res.setLanguage(this.parseCODE_PHRASE(this.getJObject(json, "language")));
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseString(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("keywords")) {
            array = this.getJArray(json, "keywords");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getKeywordsList().add(new StringType());
                    continue;
                }
                res.getKeywordsList().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_keywords")) {
            array = this.getJArray(json, "_keywords");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getKeywordsList().size()) {
                    res.getKeywordsList().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getKeywordsList().get(i));
            }
        }
        if (json.has("use")) {
            res.setUseElement(this.parseString(json.get("use").getAsString()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("misuse")) {
            res.setMisuseElement(this.parseString(json.get("misuse").getAsString()));
        }
        if (json.has("_misuse")) {
            this.parseElementProperties(this.getJObject(json, "_misuse"), res.getMisuseElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("original_resource_uri")) {
            array = this.getJArray(json, "original_resource_uri");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getOriginal_resource_uriList().add(new StringType());
                    continue;
                }
                res.getOriginal_resource_uriList().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_original_resource_uri")) {
            array = this.getJArray(json, "_original_resource_uri");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getOriginal_resource_uriList().size()) {
                    res.getOriginal_resource_uriList().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getOriginal_resource_uriList().get(i));
            }
        }
        if (json.has("other_details")) {
            array = this.getJArray(json, "other_details");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getOther_detailsList().add(new StringType());
                    continue;
                }
                res.getOther_detailsList().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_other_details")) {
            array = this.getJArray(json, "_other_details");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getOther_detailsList().size()) {
                    res.getOther_detailsList().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getOther_detailsList().get(i));
            }
        }
    }

    protected RESOURCE_DESCRIPTION parseRESOURCE_DESCRIPTION(JsonObject json) throws IOException, FHIRFormatError {
        RESOURCE_DESCRIPTION res = new RESOURCE_DESCRIPTION();
        this.parseRESOURCE_DESCRIPTIONProperties(json, res);
        return res;
    }

    protected void parseRESOURCE_DESCRIPTIONProperties(JsonObject json, RESOURCE_DESCRIPTION res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBaseProperties(json, res);
        if (json.has("original_author")) {
            array = this.getJArray(json, "original_author");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getOriginal_authorList().add(new StringType());
                    continue;
                }
                res.getOriginal_authorList().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_original_author")) {
            array = this.getJArray(json, "_original_author");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getOriginal_authorList().size()) {
                    res.getOriginal_authorList().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getOriginal_authorList().get(i));
            }
        }
        if (json.has("other_contributors")) {
            array = this.getJArray(json, "other_contributors");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getOther_contributorsList().add(new StringType());
                    continue;
                }
                res.getOther_contributorsList().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_other_contributors")) {
            array = this.getJArray(json, "_other_contributors");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getOther_contributorsList().size()) {
                    res.getOther_contributorsList().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getOther_contributorsList().get(i));
            }
        }
        if (json.has("lifecycle_state")) {
            res.setLifecycle_stateElement(this.parseString(json.get("lifecycle_state").getAsString()));
        }
        if (json.has("_lifecycle_state")) {
            this.parseElementProperties(this.getJObject(json, "_lifecycle_state"), res.getLifecycle_stateElement());
        }
        if (json.has("resource_package_uri")) {
            res.setResource_package_uriElement(this.parseString(json.get("resource_package_uri").getAsString()));
        }
        if (json.has("_resource_package_uri")) {
            this.parseElementProperties(this.getJObject(json, "_resource_package_uri"), res.getResource_package_uriElement());
        }
        if (json.has("other_details")) {
            array = this.getJArray(json, "other_details");
            for (i = 0; i < array.size(); ++i) {
                res.getOther_detailsList().add(this.parseOBJECT_REF(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("parent_resource")) {
            res.setParent_resource(this.parseAUTHORED_RESOURCE(this.getJObject(json, "parent_resource")));
        }
        if (json.has("details")) {
            array = this.getJArray(json, "details");
            for (i = 0; i < array.size(); ++i) {
                res.getDetailsList().add(this.parseRESOURCE_DESCRIPTION_ITEM(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected REVISION_HISTORY_ITEM parseREVISION_HISTORY_ITEM(JsonObject json) throws IOException, FHIRFormatError {
        REVISION_HISTORY_ITEM res = new REVISION_HISTORY_ITEM();
        this.parseREVISION_HISTORY_ITEMProperties(json, res);
        return res;
    }

    protected void parseREVISION_HISTORY_ITEMProperties(JsonObject json, REVISION_HISTORY_ITEM res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("version_id")) {
            res.setVersion_id(this.parseOBJECT_VERSION_ID(this.getJObject(json, "version_id")));
        }
        if (json.has("audits")) {
            JsonArray array = this.getJArray(json, "audits");
            for (int i = 0; i < array.size(); ++i) {
                res.getAuditsList().add(this.parseAUDIT_DETAILS(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected REVISION_HISTORY parseREVISION_HISTORY(JsonObject json) throws IOException, FHIRFormatError {
        REVISION_HISTORY res = new REVISION_HISTORY();
        this.parseREVISION_HISTORYProperties(json, res);
        return res;
    }

    protected void parseREVISION_HISTORYProperties(JsonObject json, REVISION_HISTORY res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("most_recent_version")) {
            res.setMost_recent_versionElement(this.parseString(json.get("most_recent_version").getAsString()));
        }
        if (json.has("_most_recent_version")) {
            this.parseElementProperties(this.getJObject(json, "_most_recent_version"), res.getMost_recent_versionElement());
        }
        if (json.has("most_recent_version_time_committed")) {
            res.setMost_recent_version_time_committedElement(this.parseString(json.get("most_recent_version_time_committed").getAsString()));
        }
        if (json.has("_most_recent_version_time_committed")) {
            this.parseElementProperties(this.getJObject(json, "_most_recent_version_time_committed"), res.getMost_recent_version_time_committedElement());
        }
    }

    protected ROLE parseROLE(JsonObject json) throws IOException, FHIRFormatError {
        ROLE res = new ROLE();
        this.parseROLEProperties(json, res);
        return res;
    }

    protected void parseROLEProperties(JsonObject json, ROLE res) throws IOException, FHIRFormatError {
        this.parsePARTYProperties(json, res);
        if (json.has("time_validity")) {
            res.setTime_validity(this.parseDV_INTERVAL(this.getJObject(json, "time_validity")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parsePARTY_REF(this.getJObject(json, "performer")));
        }
        if (json.has("capabilities")) {
            JsonArray array = this.getJArray(json, "capabilities");
            for (int i = 0; i < array.size(); ++i) {
                res.getCapabilitiesList().add(this.parseCAPABILITY(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected SECTION parseSECTION(JsonObject json) throws IOException, FHIRFormatError {
        SECTION res = new SECTION();
        this.parseSECTIONProperties(json, res);
        return res;
    }

    protected void parseSECTIONProperties(JsonObject json, SECTION res) throws IOException, FHIRFormatError {
        this.parseCONTENT_ITEMProperties(json, res);
        if (json.has("items")) {
            JsonArray array = this.getJArray(json, "items");
            for (int i = 0; i < array.size(); ++i) {
                res.getItemsList().add(this.parseCONTENT_ITEM(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected TEMPLATE_ID parseTEMPLATE_ID(JsonObject json) throws IOException, FHIRFormatError {
        TEMPLATE_ID res = new TEMPLATE_ID();
        this.parseTEMPLATE_IDProperties(json, res);
        return res;
    }

    protected void parseTEMPLATE_IDProperties(JsonObject json, TEMPLATE_ID res) throws IOException, FHIRFormatError {
        this.parseOBJECT_IDProperties(json, res);
    }

    protected TERM_MAPPING parseTERM_MAPPING(JsonObject json) throws IOException, FHIRFormatError {
        TERM_MAPPING res = new TERM_MAPPING();
        this.parseTERM_MAPPINGProperties(json, res);
        return res;
    }

    protected void parseTERM_MAPPINGProperties(JsonObject json, TERM_MAPPING res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("match")) {
            res.setMatchElement(this.parseString(json.get("match").getAsString()));
        }
        if (json.has("_match")) {
            this.parseElementProperties(this.getJObject(json, "_match"), res.getMatchElement());
        }
        if (json.has("purpose")) {
            res.setPurpose(this.parseDV_CODED_TEXT(this.getJObject(json, "purpose")));
        }
        if (json.has("target")) {
            res.setTarget(this.parseCODE_PHRASE(this.getJObject(json, "target")));
        }
    }

    protected TERMINOLOGY_ID parseTERMINOLOGY_ID(JsonObject json) throws IOException, FHIRFormatError {
        TERMINOLOGY_ID res = new TERMINOLOGY_ID();
        this.parseTERMINOLOGY_IDProperties(json, res);
        return res;
    }

    protected void parseTERMINOLOGY_IDProperties(JsonObject json, TERMINOLOGY_ID res) throws IOException, FHIRFormatError {
        this.parseOBJECT_IDProperties(json, res);
    }

    protected TRANSLATION_DETAILS parseTRANSLATION_DETAILS(JsonObject json) throws IOException, FHIRFormatError {
        TRANSLATION_DETAILS res = new TRANSLATION_DETAILS();
        this.parseTRANSLATION_DETAILSProperties(json, res);
        return res;
    }

    protected void parseTRANSLATION_DETAILSProperties(JsonObject json, TRANSLATION_DETAILS res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBaseProperties(json, res);
        if (json.has("language")) {
            res.setLanguage(this.parseCODE_PHRASE(this.getJObject(json, "language")));
        }
        if (json.has("author")) {
            array = this.getJArray(json, "author");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getAuthorList().add(new StringType());
                    continue;
                }
                res.getAuthorList().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_author")) {
            array = this.getJArray(json, "_author");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getAuthorList().size()) {
                    res.getAuthorList().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getAuthorList().get(i));
            }
        }
        if (json.has("accreditation")) {
            res.setAccreditationElement(this.parseString(json.get("accreditation").getAsString()));
        }
        if (json.has("_accreditation")) {
            this.parseElementProperties(this.getJObject(json, "_accreditation"), res.getAccreditationElement());
        }
        if (json.has("other_details")) {
            array = this.getJArray(json, "other_details");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getOther_detailsList().add(new StringType());
                    continue;
                }
                res.getOther_detailsList().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_other_details")) {
            array = this.getJArray(json, "_other_details");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getOther_detailsList().size()) {
                    res.getOther_detailsList().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getOther_detailsList().get(i));
            }
        }
    }

    protected TranslatedString parseTranslatedString(JsonObject json) throws IOException, FHIRFormatError {
        TranslatedString res = new TranslatedString();
        this.parseTranslatedStringProperties(json, res);
        return res;
    }

    protected void parseTranslatedStringProperties(JsonObject json, TranslatedString res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(this.getJObject(json, "_language"), res.getLanguageElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected UUID parseUUID(JsonObject json) throws IOException, FHIRFormatError {
        UUID res = new UUID();
        this.parseUUIDProperties(json, res);
        return res;
    }

    protected void parseUUIDProperties(JsonObject json, UUID res) throws IOException, FHIRFormatError {
        this.parseUIDProperties(json, res);
    }

    protected VERSION_TREE_ID parseVERSION_TREE_ID(JsonObject json) throws IOException, FHIRFormatError {
        VERSION_TREE_ID res = new VERSION_TREE_ID();
        this.parseVERSION_TREE_IDProperties(json, res);
        return res;
    }

    protected void parseVERSION_TREE_IDProperties(JsonObject json, VERSION_TREE_ID res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected VERSIONED_COMPOSITION parseVERSIONED_COMPOSITION(JsonObject json) throws IOException, FHIRFormatError {
        VERSIONED_COMPOSITION res = new VERSIONED_COMPOSITION();
        this.parseVERSIONED_COMPOSITIONProperties(json, res);
        return res;
    }

    protected void parseVERSIONED_COMPOSITIONProperties(JsonObject json, VERSIONED_COMPOSITION res) throws IOException, FHIRFormatError {
        this.parseVERSIONED_OBJECTProperties(json, res);
    }

    protected VERSIONED_EHR_ACCESS parseVERSIONED_EHR_ACCESS(JsonObject json) throws IOException, FHIRFormatError {
        VERSIONED_EHR_ACCESS res = new VERSIONED_EHR_ACCESS();
        this.parseVERSIONED_EHR_ACCESSProperties(json, res);
        return res;
    }

    protected void parseVERSIONED_EHR_ACCESSProperties(JsonObject json, VERSIONED_EHR_ACCESS res) throws IOException, FHIRFormatError {
        this.parseVERSIONED_OBJECTProperties(json, res);
    }

    protected VERSIONED_EHR_STATUS parseVERSIONED_EHR_STATUS(JsonObject json) throws IOException, FHIRFormatError {
        VERSIONED_EHR_STATUS res = new VERSIONED_EHR_STATUS();
        this.parseVERSIONED_EHR_STATUSProperties(json, res);
        return res;
    }

    protected void parseVERSIONED_EHR_STATUSProperties(JsonObject json, VERSIONED_EHR_STATUS res) throws IOException, FHIRFormatError {
        this.parseVERSIONED_OBJECTProperties(json, res);
    }

    protected VERSIONED_FOLDER parseVERSIONED_FOLDER(JsonObject json) throws IOException, FHIRFormatError {
        VERSIONED_FOLDER res = new VERSIONED_FOLDER();
        this.parseVERSIONED_FOLDERProperties(json, res);
        return res;
    }

    protected void parseVERSIONED_FOLDERProperties(JsonObject json, VERSIONED_FOLDER res) throws IOException, FHIRFormatError {
        this.parseVERSIONED_OBJECTProperties(json, res);
    }

    protected VERSIONED_OBJECT parseVERSIONED_OBJECT(JsonObject json) throws IOException, FHIRFormatError {
        VERSIONED_OBJECT res = new VERSIONED_OBJECT();
        this.parseVERSIONED_OBJECTProperties(json, res);
        return res;
    }

    protected void parseVERSIONED_OBJECTProperties(JsonObject json, VERSIONED_OBJECT res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("uid")) {
            res.setUid(this.parseHIER_OBJECT_ID(this.getJObject(json, "uid")));
        }
        if (json.has("owner_id")) {
            res.setOwner_id(this.parseOBJECT_REF(this.getJObject(json, "owner_id")));
        }
        if (json.has("time_created")) {
            res.setTime_created(this.parseDV_DATE_TIME(this.getJObject(json, "time_created")));
        }
    }

    protected VERSIONED_PARTY parseVERSIONED_PARTY(JsonObject json) throws IOException, FHIRFormatError {
        VERSIONED_PARTY res = new VERSIONED_PARTY();
        this.parseVERSIONED_PARTYProperties(json, res);
        return res;
    }

    protected void parseVERSIONED_PARTYProperties(JsonObject json, VERSIONED_PARTY res) throws IOException, FHIRFormatError {
        this.parseVERSIONED_OBJECTProperties(json, res);
    }

    protected WebTemplate parseWebTemplate(JsonObject json) throws IOException, FHIRFormatError {
        WebTemplate res = new WebTemplate();
        this.parseWebTemplateProperties(json, res);
        return res;
    }

    protected void parseWebTemplateProperties(JsonObject json, WebTemplate res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBaseProperties(json, res);
        if (json.has("templateId")) {
            res.setTemplateIdElement(this.parseString(json.get("templateId").getAsString()));
        }
        if (json.has("_templateId")) {
            this.parseElementProperties(this.getJObject(json, "_templateId"), res.getTemplateIdElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("semver")) {
            res.setSemverElement(this.parseString(json.get("semver").getAsString()));
        }
        if (json.has("_semver")) {
            this.parseElementProperties(this.getJObject(json, "_semver"), res.getSemverElement());
        }
        if (json.has("defaultLanguage")) {
            res.setDefaultLanguageElement(this.parseString(json.get("defaultLanguage").getAsString()));
        }
        if (json.has("_defaultLanguage")) {
            this.parseElementProperties(this.getJObject(json, "_defaultLanguage"), res.getDefaultLanguageElement());
        }
        if (json.has("languages")) {
            array = this.getJArray(json, "languages");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getLanguagesList().add(new StringType());
                    continue;
                }
                res.getLanguagesList().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_languages")) {
            array = this.getJArray(json, "_languages");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLanguagesList().size()) {
                    res.getLanguagesList().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getLanguagesList().get(i));
            }
        }
        if (json.has("tree")) {
            res.setTree(this.parseWebTemplateItem(this.getJObject(json, "tree")));
        }
    }

    protected WebTemplateInput parseWebTemplateInput(JsonObject json) throws IOException, FHIRFormatError {
        WebTemplateInput res = new WebTemplateInput();
        this.parseWebTemplateInputProperties(json, res);
        return res;
    }

    protected void parseWebTemplateInputProperties(JsonObject json, WebTemplateInput res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("suffix")) {
            res.setSuffixElement(this.parseString(json.get("suffix").getAsString()));
        }
        if (json.has("_suffix")) {
            this.parseElementProperties(this.getJObject(json, "_suffix"), res.getSuffixElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("defaultValue")) {
            res.setDefaultValue(this.parseNativePrimitive(json, "defaultValue"));
        }
        if (json.has("terminology")) {
            res.setTerminologyElement(this.parseCode(json.get("terminology").getAsString()));
        }
        if (json.has("_terminology")) {
            this.parseElementProperties(this.getJObject(json, "_terminology"), res.getTerminologyElement());
        }
        if (json.has("validation")) {
            res.setValidation(this.parseWebTemplateInputValidation(this.getJObject(json, "validation")));
        }
        if (json.has("list")) {
            JsonArray array = this.getJArray(json, "list");
            for (int i = 0; i < array.size(); ++i) {
                res.getListList().add(this.parseWebTemplateInputListItem(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("listOpen")) {
            res.setListOpenElement(this.parseBoolean(json.get("listOpen").getAsBoolean()));
        }
        if (json.has("_listOpen")) {
            this.parseElementProperties(this.getJObject(json, "_listOpen"), res.getListOpenElement());
        }
    }

    protected WebTemplateInputListItem parseWebTemplateInputListItem(JsonObject json) throws IOException, FHIRFormatError {
        WebTemplateInputListItem res = new WebTemplateInputListItem();
        this.parseWebTemplateInputListItemProperties(json, res);
        return res;
    }

    protected void parseWebTemplateInputListItemProperties(JsonObject json, WebTemplateInputListItem res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBaseProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseCode(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(this.getJObject(json, "_label"), res.getLabelElement());
        }
        if (json.has("ordinal")) {
            res.setOrdinalElement(this.parseString(json.get("ordinal").getAsString()));
        }
        if (json.has("_ordinal")) {
            this.parseElementProperties(this.getJObject(json, "_ordinal"), res.getOrdinalElement());
        }
        if (json.has("localizedLabels")) {
            array = this.getJArray(json, "localizedLabels");
            for (i = 0; i < array.size(); ++i) {
                res.getLocalizedLabelsList().add(this.parseTranslatedString(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("localizedDescriptions")) {
            array = this.getJArray(json, "localizedDescriptions");
            for (i = 0; i < array.size(); ++i) {
                res.getLocalizedDescriptionsList().add(this.parseTranslatedString(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("currentStates")) {
            res.setCurrentStatesElement(this.parseString(json.get("currentStates").getAsString()));
        }
        if (json.has("_currentStates")) {
            this.parseElementProperties(this.getJObject(json, "_currentStates"), res.getCurrentStatesElement());
        }
        if (json.has("range")) {
            res.setRangeElement(this.parseString(json.get("range").getAsString()));
        }
        if (json.has("_range")) {
            this.parseElementProperties(this.getJObject(json, "_range"), res.getRangeElement());
        }
        if (json.has("precision")) {
            res.setPrecisionElement(this.parseString(json.get("precision").getAsString()));
        }
        if (json.has("_precision")) {
            this.parseElementProperties(this.getJObject(json, "_precision"), res.getPrecisionElement());
        }
        if (json.has("termBindings")) {
            array = this.getJArray(json, "termBindings");
            for (i = 0; i < array.size(); ++i) {
                res.getTermBindingsList().add(this.parseWebTemplateTermBinding(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected WebTemplateInputValidation parseWebTemplateInputValidation(JsonObject json) throws IOException, FHIRFormatError {
        WebTemplateInputValidation res = new WebTemplateInputValidation();
        this.parseWebTemplateInputValidationProperties(json, res);
        return res;
    }

    protected void parseWebTemplateInputValidationProperties(JsonObject json, WebTemplateInputValidation res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("range")) {
            res.setRange(this.parseWebTemplateInputValidationRange(this.getJObject(json, "range")));
        }
        if (json.has("precision")) {
            res.setPrecision(this.parseWebTemplateInputValidationRange(this.getJObject(json, "precision")));
        }
    }

    protected WebTemplateInputValidationRange parseWebTemplateInputValidationRange(JsonObject json) throws IOException, FHIRFormatError {
        WebTemplateInputValidationRange res = new WebTemplateInputValidationRange();
        this.parseWebTemplateInputValidationRangeProperties(json, res);
        return res;
    }

    protected void parseWebTemplateInputValidationRangeProperties(JsonObject json, WebTemplateInputValidationRange res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("minOp")) {
            res.setMinOpElement(this.parseCode(json.get("minOp").getAsString()));
        }
        if (json.has("_minOp")) {
            this.parseElementProperties(this.getJObject(json, "_minOp"), res.getMinOpElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseDecimal(json.get("min").getAsBigDecimal()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(this.getJObject(json, "_min"), res.getMinElement());
        }
        if (json.has("maxOp")) {
            res.setMaxOpElement(this.parseCode(json.get("maxOp").getAsString()));
        }
        if (json.has("_maxOp")) {
            this.parseElementProperties(this.getJObject(json, "_maxOp"), res.getMaxOpElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseDecimal(json.get("max").getAsBigDecimal()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(this.getJObject(json, "_max"), res.getMaxElement());
        }
    }

    protected WebTemplateItem parseWebTemplateItem(JsonObject json) throws IOException, FHIRFormatError {
        WebTemplateItem res = new WebTemplateItem();
        this.parseWebTemplateItemProperties(json, res);
        return res;
    }

    protected void parseWebTemplateItemProperties(JsonObject json, WebTemplateItem res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBaseProperties(json, res);
        if (json.has("id")) {
            res.setIdElement(this.parseString(json.get("id").getAsString()));
        }
        if (json.has("_id")) {
            this.parseElementProperties(this.getJObject(json, "_id"), res.getIdElement());
        }
        if (json.has("depth")) {
            res.setDepthElement(this.parseInteger(json.get("depth").getAsLong()));
        }
        if (json.has("_depth")) {
            this.parseElementProperties(this.getJObject(json, "_depth"), res.getDepthElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("localizedName")) {
            res.setLocalizedNameElement(this.parseString(json.get("localizedName").getAsString()));
        }
        if (json.has("_localizedName")) {
            this.parseElementProperties(this.getJObject(json, "_localizedName"), res.getLocalizedNameElement());
        }
        if (json.has("rmType")) {
            res.setRmTypeElement(this.parseCode(json.get("rmType").getAsString()));
        }
        if (json.has("_rmType")) {
            this.parseElementProperties(this.getJObject(json, "_rmType"), res.getRmTypeElement());
        }
        if (json.has("nodeId")) {
            res.setNodeIdElement(this.parseString(json.get("nodeId").getAsString()));
        }
        if (json.has("_nodeId")) {
            this.parseElementProperties(this.getJObject(json, "_nodeId"), res.getNodeIdElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseString(json.get("min").getAsString()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(this.getJObject(json, "_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(this.getJObject(json, "_max"), res.getMaxElement());
        }
        if (json.has("dependsOn")) {
            res.setDependsOnElement(this.parseString(json.get("dependsOn").getAsString()));
        }
        if (json.has("_dependsOn")) {
            this.parseElementProperties(this.getJObject(json, "_dependsOn"), res.getDependsOnElement());
        }
        if (json.has("localizedNames")) {
            array = this.getJArray(json, "localizedNames");
            for (i = 0; i < array.size(); ++i) {
                res.getLocalizedNamesList().add(this.parseTranslatedString(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("localizedDescriptions")) {
            array = this.getJArray(json, "localizedDescriptions");
            for (i = 0; i < array.size(); ++i) {
                res.getLocalizedDescriptionsList().add(this.parseTranslatedString(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("annotations")) {
            res.setAnnotations(this.parseAnnotations(this.getJObject(json, "annotations")));
        }
        if (json.has("archetype_id")) {
            res.setArchetype_idElement(this.parseString(json.get("archetype_id").getAsString()));
        }
        if (json.has("_archetype_id")) {
            this.parseElementProperties(this.getJObject(json, "_archetype_id"), res.getArchetype_idElement());
        }
        if (json.has("aqlPath")) {
            res.setAqlPathElement(this.parseString(json.get("aqlPath").getAsString()));
        }
        if (json.has("_aqlPath")) {
            this.parseElementProperties(this.getJObject(json, "_aqlPath"), res.getAqlPathElement());
        }
        if (json.has("custodian_namespace")) {
            res.setCustodian_namespaceElement(this.parseString(json.get("custodian_namespace").getAsString()));
        }
        if (json.has("_custodian_namespace")) {
            this.parseElementProperties(this.getJObject(json, "_custodian_namespace"), res.getCustodian_namespaceElement());
        }
        if (json.has("custodian_organisation")) {
            res.setCustodian_organisationElement(this.parseString(json.get("custodian_organisation").getAsString()));
        }
        if (json.has("_custodian_organisation")) {
            this.parseElementProperties(this.getJObject(json, "_custodian_organisation"), res.getCustodian_organisationElement());
        }
        if (json.has("lifecycleState")) {
            res.setLifecycleStateElement(this.parseCode(json.get("lifecycleState").getAsString()));
        }
        if (json.has("_lifecycleState")) {
            this.parseElementProperties(this.getJObject(json, "_lifecycleState"), res.getLifecycleStateElement());
        }
        if (json.has("original_namespace")) {
            res.setOriginal_namespaceElement(this.parseString(json.get("original_namespace").getAsString()));
        }
        if (json.has("_original_namespace")) {
            this.parseElementProperties(this.getJObject(json, "_original_namespace"), res.getOriginal_namespaceElement());
        }
        if (json.has("original_publisher")) {
            res.setOriginal_publisherElement(this.parseString(json.get("original_publisher").getAsString()));
        }
        if (json.has("_original_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_original_publisher"), res.getOriginal_publisherElement());
        }
        if (json.has("proportionTypes")) {
            res.setProportionTypesElement(this.parseCode(json.get("proportionTypes").getAsString()));
        }
        if (json.has("_proportionTypes")) {
            this.parseElementProperties(this.getJObject(json, "_proportionTypes"), res.getProportionTypesElement());
        }
        if (json.has("revision")) {
            res.setRevisionElement(this.parseString(json.get("revision").getAsString()));
        }
        if (json.has("_revision")) {
            this.parseElementProperties(this.getJObject(json, "_revision"), res.getRevisionElement());
        }
        if (json.has("inContext")) {
            res.setInContextElement(this.parseBoolean(json.get("inContext").getAsBoolean()));
        }
        if (json.has("_inContext")) {
            this.parseElementProperties(this.getJObject(json, "_inContext"), res.getInContextElement());
        }
        if (json.has("inputs")) {
            array = this.getJArray(json, "inputs");
            for (i = 0; i < array.size(); ++i) {
                res.getInputsList().add(this.parseWebTemplateInput(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("termBindings")) {
            array = this.getJArray(json, "termBindings");
            for (i = 0; i < array.size(); ++i) {
                res.getTermBindingsList().add(this.parseWebTemplateTermBinding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("children")) {
            array = this.getJArray(json, "children");
            for (i = 0; i < array.size(); ++i) {
                res.getChildrenList().add(this.parseWebTemplateItem(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected WebTemplateTermBinding parseWebTemplateTermBinding(JsonObject json) throws IOException, FHIRFormatError {
        WebTemplateTermBinding res = new WebTemplateTermBinding();
        this.parseWebTemplateTermBindingProperties(json, res);
        return res;
    }

    protected void parseWebTemplateTermBindingProperties(JsonObject json, WebTemplateTermBinding res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("value")) {
            res.setValue(this.parseWebTemplateTermBindingValue(this.getJObject(json, "value")));
        }
    }

    protected WebTemplateTermBindingValue parseWebTemplateTermBindingValue(JsonObject json) throws IOException, FHIRFormatError {
        WebTemplateTermBindingValue res = new WebTemplateTermBindingValue();
        this.parseWebTemplateTermBindingValueProperties(json, res);
        return res;
    }

    protected void parseWebTemplateTermBindingValueProperties(JsonObject json, WebTemplateTermBindingValue res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("terminologyId")) {
            res.setTerminologyIdElement(this.parseString(json.get("terminologyId").getAsString()));
        }
        if (json.has("_terminologyId")) {
            this.parseElementProperties(this.getJObject(json, "_terminologyId"), res.getTerminologyIdElement());
        }
    }

    protected void composeACCESS_CONTROL_SETTINGS(String name, ACCESS_CONTROL_SETTINGS element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                default: 
            }
            throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
        }
    }

    protected void composeACCESS_CONTROL_SETTINGSProperties(ACCESS_CONTROL_SETTINGS element) throws IOException {
        this.composeBaseProperties(element);
    }

    protected void composeACTOR(String name, ACTOR element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "AGENT": {
                    this.composeAGENTProperties((AGENT)element);
                    this.close();
                    break;
                }
                case "GROUP": {
                    this.composeGROUPProperties((GROUP)element);
                    this.close();
                    break;
                }
                case "PERSON": {
                    this.composePERSONProperties((PERSON)element);
                    this.close();
                    break;
                }
                case "ORGANISATION": {
                    this.composeORGANISATIONProperties((ORGANISATION)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeACTORProperties(ACTOR element) throws IOException {
        this.composePARTYProperties(element);
        if (element.hasLanguages()) {
            this.openArray("languages");
            for (DV_TEXT dV_TEXT : element.getLanguagesList()) {
                this.composeDV_TEXT(null, dV_TEXT);
            }
            this.closeArray();
        }
        if (element.hasRoles()) {
            this.openArray("roles");
            for (PARTY_REF pARTY_REF : element.getRolesList()) {
                this.composePARTY_REF(null, pARTY_REF);
            }
            this.closeArray();
        }
    }

    protected void composeAUTHORED_RESOURCE(String name, AUTHORED_RESOURCE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                default: 
            }
            throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
        }
    }

    protected void composeAUTHORED_RESOURCEProperties(AUTHORED_RESOURCE element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasOriginal_language()) {
            this.composeCODE_PHRASE("original_language", element.getOriginal_language());
        }
        if (element.hasIs_controlledElement()) {
            this.composeBooleanCore("is_controlled", element.getIs_controlledElement(), false);
            this.composeBooleanExtras("is_controlled", element.getIs_controlledElement(), false);
        }
        if (element.hasTranslations()) {
            this.openArray("translations");
            for (TRANSLATION_DETAILS e : element.getTranslationsList()) {
                this.composeTRANSLATION_DETAILS(null, e);
            }
            this.closeArray();
        }
        if (element.hasDescription()) {
            this.composeRESOURCE_DESCRIPTION("description", element.getDescription());
        }
        if (element.hasRevision_history()) {
            this.composeREVISION_HISTORY("revision_history", element.getRevision_history());
        }
    }

    protected void composeAny(String name, Any element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "EHR": {
                    this.composeEHRProperties((EHR)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeAnyProperties(Any element) throws IOException {
        this.composeBaseProperties(element);
    }

    protected void composeCARE_ENTRY(String name, CARE_ENTRY element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "INSTRUCTION": {
                    this.composeINSTRUCTIONProperties((INSTRUCTION)element);
                    this.close();
                    break;
                }
                case "OBSERVATION": {
                    this.composeOBSERVATIONProperties((OBSERVATION)element);
                    this.close();
                    break;
                }
                case "ACTION": {
                    this.composeACTIONProperties((ACTION)element);
                    this.close();
                    break;
                }
                case "EVALUATION": {
                    this.composeEVALUATIONProperties((EVALUATION)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeCARE_ENTRYProperties(CARE_ENTRY element) throws IOException {
        this.composeENTRYProperties(element);
        if (element.hasProtocol()) {
            this.composeITEM_STRUCTURE("protocol", element.getProtocol());
        }
        if (element.hasGuideline_id()) {
            this.composeOBJECT_REF("guideline_id", element.getGuideline_id());
        }
    }

    protected void composeCONTENT_ITEM(String name, CONTENT_ITEM element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "SECTION": {
                    this.composeSECTIONProperties((SECTION)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeCONTENT_ITEMProperties(CONTENT_ITEM element) throws IOException {
        this.composeLOCATABLEProperties(element);
    }

    protected void composeDATA_STRUCTURE(String name, DATA_STRUCTURE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "HISTORY": {
                    this.composeHISTORYProperties((HISTORY)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDATA_STRUCTUREProperties(DATA_STRUCTURE element) throws IOException {
        this.composeLOCATABLEProperties(element);
    }

    protected void composeDATA_VALUE(String name, DATA_VALUE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "DV-TEXT": {
                    this.composeDV_TEXTProperties((DV_TEXT)element);
                    this.close();
                    break;
                }
                case "DV-IDENTIFIER": {
                    this.composeDV_IDENTIFIERProperties((DV_IDENTIFIER)element);
                    this.close();
                    break;
                }
                case "DV-BOOLEAN": {
                    this.composeDV_BOOLEANProperties((DV_BOOLEAN)element);
                    this.close();
                    break;
                }
                case "DV-PARAGRAPH": {
                    this.composeDV_PARAGRAPHProperties((DV_PARAGRAPH)element);
                    this.close();
                    break;
                }
                case "DV-URI": {
                    this.composeDV_URIProperties((DV_URI)element);
                    this.close();
                    break;
                }
                case "DV-STATE": {
                    this.composeDV_STATEProperties((DV_STATE)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDATA_VALUEProperties(DATA_VALUE element) throws IOException {
        this.composeBaseProperties(element);
    }

    protected void composeDV_ABSOLUTE_QUANTITY(String name, DV_ABSOLUTE_QUANTITY element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                default: 
            }
            throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
        }
    }

    protected void composeDV_ABSOLUTE_QUANTITYProperties(DV_ABSOLUTE_QUANTITY element) throws IOException {
        this.composeDV_QUANTIFIEDProperties(element);
    }

    protected void composeDV_AMOUNT(String name, DV_AMOUNT element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "DV-DURATION": {
                    this.composeDV_DURATIONProperties((DV_DURATION)element);
                    this.close();
                    break;
                }
                case "DV-COUNT": {
                    this.composeDV_COUNTProperties((DV_COUNT)element);
                    this.close();
                    break;
                }
                case "DV-PROPORTION": {
                    this.composeDV_PROPORTIONProperties((DV_PROPORTION)element);
                    this.close();
                    break;
                }
                case "DV-QUANTITY": {
                    this.composeDV_QUANTITYProperties((DV_QUANTITY)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDV_AMOUNTProperties(DV_AMOUNT element) throws IOException {
        this.composeDV_QUANTIFIEDProperties(element);
        if (element.hasAccuracy_is_percentElement()) {
            this.composeBooleanCore("accuracy_is_percent", element.getAccuracy_is_percentElement(), false);
            this.composeBooleanExtras("accuracy_is_percent", element.getAccuracy_is_percentElement(), false);
        }
    }

    protected void composeDV_ENCAPSULATED(String name, DV_ENCAPSULATED element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "DV-MULTIMEDIA": {
                    this.composeDV_MULTIMEDIAProperties((DV_MULTIMEDIA)element);
                    this.close();
                    break;
                }
                case "DV-PARSABLE": {
                    this.composeDV_PARSABLEProperties((DV_PARSABLE)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDV_ENCAPSULATEDProperties(DV_ENCAPSULATED element) throws IOException {
        this.composeDV_AMOUNTProperties(element);
        if (element.hasCharset()) {
            this.composeCODE_PHRASE("charset", element.getCharset());
        }
        if (element.hasLanguage()) {
            this.composeCODE_PHRASE("language", element.getLanguage());
        }
    }

    protected void composeDV_ORDERED(String name, DV_ORDERED element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "DV-DATE-TIME": {
                    this.composeDV_DATE_TIMEProperties((DV_DATE_TIME)element);
                    this.close();
                    break;
                }
                case "DV-TIME": {
                    this.composeDV_TIMEProperties((DV_TIME)element);
                    this.close();
                    break;
                }
                case "DV-INTERVAL": {
                    this.composeDV_INTERVALProperties((DV_INTERVAL)element);
                    this.close();
                    break;
                }
                case "DV-ORDINAL": {
                    this.composeDV_ORDINALProperties((DV_ORDINAL)element);
                    this.close();
                    break;
                }
                case "DV-SCALE": {
                    this.composeDV_SCALEProperties((DV_SCALE)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDV_ORDEREDProperties(DV_ORDERED element) throws IOException {
        this.composeDATA_VALUEProperties(element);
        if (element.hasNormal_status()) {
            this.composeCODE_PHRASE("normal_status", element.getNormal_status());
        }
        if (element.hasNormal_range()) {
            this.composeDV_INTERVAL("normal_range", element.getNormal_range());
        }
        if (element.hasOther_reference_ranges()) {
            this.openArray("other_reference_ranges");
            for (REFERENCE_RANGE e : element.getOther_reference_rangesList()) {
                this.composeREFERENCE_RANGE(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeDV_QUANTIFIED(String name, DV_QUANTIFIED element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                default: 
            }
            throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
        }
    }

    protected void composeDV_QUANTIFIEDProperties(DV_QUANTIFIED element) throws IOException {
        this.composeDV_ORDEREDProperties(element);
        if (element.hasMagnitude_statusElement()) {
            this.composeStringCore("magnitude_status", element.getMagnitude_statusElement(), false);
            this.composeStringExtras("magnitude_status", element.getMagnitude_statusElement(), false);
        }
        if (element.hasAccuracy()) {
            this.composeBase("accuracy", element.getAccuracy());
        }
    }

    protected void composeDV_TEMPORAL(String name, DV_TEMPORAL element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "DV-DATE": {
                    this.composeDV_DATEProperties((DV_DATE)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDV_TEMPORALProperties(DV_TEMPORAL element) throws IOException {
        this.composeDV_ABSOLUTE_QUANTITYProperties(element);
    }

    protected void composeDV_TIME_SPECIFICATION(String name, DV_TIME_SPECIFICATION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "DV-GENERAL-TIME-SPECIFICATION": {
                    this.composeDV_GENERAL_TIME_SPECIFICATIONProperties((DV_GENERAL_TIME_SPECIFICATION)element);
                    this.close();
                    break;
                }
                case "DV-PERIODIC-TIME-SPECIFICATION": {
                    this.composeDV_PERIODIC_TIME_SPECIFICATIONProperties((DV_PERIODIC_TIME_SPECIFICATION)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDV_TIME_SPECIFICATIONProperties(DV_TIME_SPECIFICATION element) throws IOException {
        this.composeDATA_VALUEProperties(element);
        if (element.hasDV_PARSABLEElement()) {
            this.composeStringCore("DV_PARSABLE", element.getDV_PARSABLEElement(), false);
            this.composeStringExtras("DV_PARSABLE", element.getDV_PARSABLEElement(), false);
        }
    }

    protected void composeENTRY(String name, ENTRY element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "ADMIN-ENTRY": {
                    this.composeADMIN_ENTRYProperties((ADMIN_ENTRY)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeENTRYProperties(ENTRY element) throws IOException {
        this.composeCONTENT_ITEMProperties(element);
        if (element.hasLanguage()) {
            this.composeCODE_PHRASE("language", element.getLanguage());
        }
        if (element.hasEncoding()) {
            this.composeCODE_PHRASE("encoding", element.getEncoding());
        }
        if (element.hasOther_participations()) {
            this.openArray("other_participations");
            for (PARTICIPATION e : element.getOther_participationsList()) {
                this.composePARTICIPATION(null, e);
            }
            this.closeArray();
        }
        if (element.hasWorkflow_id()) {
            this.composeOBJECT_REF("workflow_id", element.getWorkflow_id());
        }
        if (element.hasSubject()) {
            this.composePARTY_PROXY("subject", element.getSubject());
        }
        if (element.hasProvider()) {
            this.composePARTY_PROXY("provider", element.getProvider());
        }
    }

    protected void composeEVENT(String name, EVENT element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "INTERVAL-EVENT": {
                    this.composeINTERVAL_EVENTProperties((INTERVAL_EVENT)element);
                    this.close();
                    break;
                }
                case "POINT-EVENT": {
                    this.composePOINT_EVENTProperties((POINT_EVENT)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeEVENTProperties(EVENT element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasTime()) {
            this.composeDV_DATE_TIME("time", element.getTime());
        }
        if (element.hasState()) {
            this.composeITEM_STRUCTURE("state", element.getState());
        }
        if (element.hasData()) {
            this.composeAny("data", element.getData());
        }
    }

    protected void composeITEM_STRUCTURE(String name, ITEM_STRUCTURE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "ITEM-SINGLE": {
                    this.composeITEM_SINGLEProperties((ITEM_SINGLE)element);
                    this.close();
                    break;
                }
                case "ITEM-TREE": {
                    this.composeITEM_TREEProperties((ITEM_TREE)element);
                    this.close();
                    break;
                }
                case "ITEM-TABLE": {
                    this.composeITEM_TABLEProperties((ITEM_TABLE)element);
                    this.close();
                    break;
                }
                case "ITEM-LIST": {
                    this.composeITEM_LISTProperties((ITEM_LIST)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeITEM_STRUCTUREProperties(ITEM_STRUCTURE element) throws IOException {
        this.composeDATA_STRUCTUREProperties(element);
    }

    protected void composeITEM(String name, ITEM element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "ELEMENT": {
                    this.composeELEMENTProperties((ELEMENT)element);
                    this.close();
                    break;
                }
                case "CLUSTER": {
                    this.composeCLUSTERProperties((CLUSTER)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeITEMProperties(ITEM element) throws IOException {
        this.composeLOCATABLEProperties(element);
    }

    protected void composeLOCATABLE(String name, LOCATABLE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "CONTACT": {
                    this.composeCONTACTProperties((CONTACT)element);
                    this.close();
                    break;
                }
                case "EVENT-CONTEXT": {
                    this.composeEVENT_CONTEXTProperties((EVENT_CONTEXT)element);
                    this.close();
                    break;
                }
                case "EHR-STATUS": {
                    this.composeEHR_STATUSProperties((EHR_STATUS)element);
                    this.close();
                    break;
                }
                case "PARTY-IDENTITY": {
                    this.composePARTY_IDENTITYProperties((PARTY_IDENTITY)element);
                    this.close();
                    break;
                }
                case "ADDRESS": {
                    this.composeADDRESSProperties((ADDRESS)element);
                    this.close();
                    break;
                }
                case "COMPOSITION": {
                    this.composeCOMPOSITIONProperties((COMPOSITION)element);
                    this.close();
                    break;
                }
                case "PARTY-RELATIONSHIP": {
                    this.composePARTY_RELATIONSHIPProperties((PARTY_RELATIONSHIP)element);
                    this.close();
                    break;
                }
                case "CAPABILITY": {
                    this.composeCAPABILITYProperties((CAPABILITY)element);
                    this.close();
                    break;
                }
                case "EHR-ACCESS": {
                    this.composeEHR_ACCESSProperties((EHR_ACCESS)element);
                    this.close();
                    break;
                }
                case "ACTIVITY": {
                    this.composeACTIVITYProperties((ACTIVITY)element);
                    this.close();
                    break;
                }
                case "FOLDER": {
                    this.composeFOLDERProperties((FOLDER)element);
                    this.close();
                    break;
                }
                case "PARTICIPATION": {
                    this.composePARTICIPATIONProperties((PARTICIPATION)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeLOCATABLEProperties(LOCATABLE element) throws IOException {
        this.composePATHABLEProperties(element);
    }

    protected void composeOBJECT_ID(String name, OBJECT_ID element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "TEMPLATE-ID": {
                    this.composeTEMPLATE_IDProperties((TEMPLATE_ID)element);
                    this.close();
                    break;
                }
                case "ARCHETYPE-ID": {
                    this.composeARCHETYPE_IDProperties((ARCHETYPE_ID)element);
                    this.close();
                    break;
                }
                case "GENERIC-ID": {
                    this.composeGENERIC_IDProperties((GENERIC_ID)element);
                    this.close();
                    break;
                }
                case "TERMINOLOGY-ID": {
                    this.composeTERMINOLOGY_IDProperties((TERMINOLOGY_ID)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeOBJECT_IDProperties(OBJECT_ID element) throws IOException {
        this.composeUIDProperties(element);
    }

    protected void composePARTY_PROXY(String name, PARTY_PROXY element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "PARTY-SELF": {
                    this.composePARTY_SELFProperties((PARTY_SELF)element);
                    this.close();
                    break;
                }
                case "PARTY-IDENTIFIED": {
                    this.composePARTY_IDENTIFIEDProperties((PARTY_IDENTIFIED)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composePARTY_PROXYProperties(PARTY_PROXY element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasExternal_ref()) {
            this.composePARTY_REF("external_ref", element.getExternal_ref());
        }
    }

    protected void composePARTY(String name, PARTY element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "ROLE": {
                    this.composeROLEProperties((ROLE)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composePARTYProperties(PARTY element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasIdentities()) {
            this.openArray("identities");
            for (PARTY_IDENTITY pARTY_IDENTITY : element.getIdentitiesList()) {
                this.composePARTY_IDENTITY(null, pARTY_IDENTITY);
            }
            this.closeArray();
        }
        if (element.hasContacts()) {
            this.composeCONTACT("contacts", element.getContacts());
        }
        if (element.hasDetails()) {
            this.composeITEM_STRUCTURE("details", element.getDetails());
        }
        if (element.hasReverse_relationships()) {
            this.openArray("reverse_relationships");
            for (LOCATABLE_REF lOCATABLE_REF : element.getReverse_relationshipsList()) {
                this.composeLOCATABLE_REF(null, lOCATABLE_REF);
            }
            this.closeArray();
        }
        if (element.hasRelationships()) {
            this.openArray("relationships");
            for (PARTY_RELATIONSHIP pARTY_RELATIONSHIP : element.getRelationshipsList()) {
                this.composePARTY_RELATIONSHIP(null, pARTY_RELATIONSHIP);
            }
            this.closeArray();
        }
    }

    protected void composePATHABLE(String name, PATHABLE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "INSTRUCTION-DETAILS": {
                    this.composeINSTRUCTION_DETAILSProperties((INSTRUCTION_DETAILS)element);
                    this.close();
                    break;
                }
                case "ISM-TRANSITION": {
                    this.composeISM_TRANSITIONProperties((ISM_TRANSITION)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composePATHABLEProperties(PATHABLE element) throws IOException {
        this.composeAnyProperties(element);
        if (element.hasName()) {
            this.composeDV_TEXT("name", element.getName());
        }
        if (element.hasArchetype_node_idElement()) {
            this.composeStringCore("archetype_node_id", element.getArchetype_node_idElement(), false);
            this.composeStringExtras("archetype_node_id", element.getArchetype_node_idElement(), false);
        }
        if (element.hasUid()) {
            this.composeUID_BASED_ID("uid", element.getUid());
        }
        if (element.hasLinks()) {
            this.openArray("links");
            for (LINK e : element.getLinksList()) {
                this.composeLINK(null, e);
            }
            this.closeArray();
        }
        if (element.hasArchetype_details()) {
            this.composeARCHETYPED("archetype_details", element.getArchetype_details());
        }
        if (element.hasFeeder_audit()) {
            this.composeFEEDER_AUDIT("feeder_audit", element.getFeeder_audit());
        }
    }

    protected void composeUID_BASED_ID(String name, UID_BASED_ID element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "OBJECT-VERSION-ID": {
                    this.composeOBJECT_VERSION_IDProperties((OBJECT_VERSION_ID)element);
                    this.close();
                    break;
                }
                case "HIER-OBJECT-ID": {
                    this.composeHIER_OBJECT_IDProperties((HIER_OBJECT_ID)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeUID_BASED_IDProperties(UID_BASED_ID element) throws IOException {
        this.composeOBJECT_IDProperties(element);
    }

    protected void composeUID(String name, UID element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "ISO-OID": {
                    this.composeISO_OIDProperties((ISO_OID)element);
                    this.close();
                    break;
                }
                case "UUID": {
                    this.composeUUIDProperties((UUID)element);
                    this.close();
                    break;
                }
                case "INTERNET-ID": {
                    this.composeINTERNET_IDProperties((INTERNET_ID)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeUIDProperties(UID element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasValueElement()) {
            this.composeStringCore("value", element.getValueElement(), false);
            this.composeStringExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeVERSION(String name, VERSION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.prop("_type", element.fhirType());
            switch (element.fhirType()) {
                case "IMPORTED-VERSION": {
                    this.composeIMPORTED_VERSIONProperties((IMPORTED_VERSION)element);
                    this.close();
                    break;
                }
                case "ORIGINAL-VERSION": {
                    this.composeORIGINAL_VERSIONProperties((ORIGINAL_VERSION)element);
                    this.close();
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeVERSIONProperties(VERSION element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasContribution()) {
            this.composeOBJECT_REF("contribution", element.getContribution());
        }
        if (element.hasSignatureElement()) {
            this.composeStringCore("signature", element.getSignatureElement(), false);
            this.composeStringExtras("signature", element.getSignatureElement(), false);
        }
        if (element.hasCommit_audit()) {
            this.composeAUDIT_DETAILS("commit_audit", element.getCommit_audit());
        }
    }

    protected void composeACTION(String name, ACTION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeACTIONProperties(element);
            this.close();
        }
    }

    protected void composeACTIONProperties(ACTION element) throws IOException {
        this.composeCARE_ENTRYProperties(element);
        if (element.hasTime()) {
            this.composeDV_DATE_TIME("time", element.getTime());
        }
        if (element.hasIsm_transition()) {
            this.composeISM_TRANSITION("ism_transition", element.getIsm_transition());
        }
        if (element.hasInstruction_details()) {
            this.composeINSTRUCTION_DETAILS("instruction_details", element.getInstruction_details());
        }
        if (element.hasDescription()) {
            this.composeITEM_STRUCTURE("description", element.getDescription());
        }
    }

    protected void composeACTIVITY(String name, ACTIVITY element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeACTIVITYProperties(element);
            this.close();
        }
    }

    protected void composeACTIVITYProperties(ACTIVITY element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasTiming()) {
            this.composeDV_PARSABLE("timing", element.getTiming());
        }
        if (element.hasAction_archetype_idElement()) {
            this.composeStringCore("action_archetype_id", element.getAction_archetype_idElement(), false);
            this.composeStringExtras("action_archetype_id", element.getAction_archetype_idElement(), false);
        }
        if (element.hasDescription()) {
            this.composeITEM_STRUCTURE("description", element.getDescription());
        }
    }

    protected void composeADDRESS(String name, ADDRESS element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeADDRESSProperties(element);
            this.close();
        }
    }

    protected void composeADDRESSProperties(ADDRESS element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasDetails()) {
            this.composeITEM_STRUCTURE("details", element.getDetails());
        }
    }

    protected void composeADMIN_ENTRY(String name, ADMIN_ENTRY element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeADMIN_ENTRYProperties(element);
            this.close();
        }
    }

    protected void composeADMIN_ENTRYProperties(ADMIN_ENTRY element) throws IOException {
        this.composeENTRYProperties(element);
        if (element.hasData()) {
            this.composeITEM_STRUCTURE("data", element.getData());
        }
    }

    protected void composeAGENT(String name, AGENT element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAGENTProperties(element);
            this.close();
        }
    }

    protected void composeAGENTProperties(AGENT element) throws IOException {
        this.composeACTORProperties(element);
    }

    protected void composeARCHETYPE_ID(String name, ARCHETYPE_ID element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeARCHETYPE_IDProperties(element);
            this.close();
        }
    }

    protected void composeARCHETYPE_IDProperties(ARCHETYPE_ID element) throws IOException {
        this.composeOBJECT_IDProperties(element);
    }

    protected void composeARCHETYPED(String name, ARCHETYPED element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeARCHETYPEDProperties(element);
            this.close();
        }
    }

    protected void composeARCHETYPEDProperties(ARCHETYPED element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasArchetype_id()) {
            this.composeARCHETYPE_ID("archetype_id", element.getArchetype_id());
        }
        if (element.hasTemplate_id()) {
            this.composeTEMPLATE_ID("template_id", element.getTemplate_id());
        }
        if (element.hasRm_versionElement()) {
            this.composeStringCore("rm_version", element.getRm_versionElement(), false);
            this.composeStringExtras("rm_version", element.getRm_versionElement(), false);
        }
    }

    protected void composeATTESTATION(String name, ATTESTATION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeATTESTATIONProperties(element);
            this.close();
        }
    }

    protected void composeATTESTATIONProperties(ATTESTATION element) throws IOException {
        this.composeAUDIT_DETAILSProperties(element);
        if (element.hasAttested_view()) {
            this.composeDV_MULTIMEDIA("attested_view", element.getAttested_view());
        }
        if (element.hasProofElement()) {
            this.composeStringCore("proof", element.getProofElement(), false);
            this.composeStringExtras("proof", element.getProofElement(), false);
        }
        if (element.hasItems()) {
            this.openArray("items");
            for (DV_EHR_URI e : element.getItemsList()) {
                this.composeDV_EHR_URI(null, e);
            }
            this.closeArray();
        }
        if (element.hasReason()) {
            this.composeDV_TEXT("reason", element.getReason());
        }
        if (element.hasIs_pendingElement()) {
            this.composeBooleanCore("is_pending", element.getIs_pendingElement(), false);
            this.composeBooleanExtras("is_pending", element.getIs_pendingElement(), false);
        }
    }

    protected void composeAUDIT_DETAILS(String name, AUDIT_DETAILS element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAUDIT_DETAILSProperties(element);
            this.close();
        }
    }

    protected void composeAUDIT_DETAILSProperties(AUDIT_DETAILS element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasSystem_idElement()) {
            this.composeStringCore("system_id", element.getSystem_idElement(), false);
            this.composeStringExtras("system_id", element.getSystem_idElement(), false);
        }
        if (element.hasTime_committed()) {
            this.composeDV_DATE_TIME("time_committed", element.getTime_committed());
        }
        if (element.hasChange_type()) {
            this.composeDV_CODED_TEXT("change_type", element.getChange_type());
        }
        if (element.hasDescription()) {
            this.composeDV_TEXT("description", element.getDescription());
        }
        if (element.hasCommitter()) {
            this.composePARTY_PROXY("committer", element.getCommitter());
        }
    }

    protected void composeAnnotations(String name, Annotations element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAnnotationsProperties(element);
            this.close();
        }
    }

    protected void composeAnnotationsProperties(Annotations element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasCommentElement()) {
            this.composeStringCore("comment", element.getCommentElement(), false);
            this.composeStringExtras("comment", element.getCommentElement(), false);
        }
        if (element.hasFhir_mappingElement()) {
            this.composeStringCore("fhir_mapping", element.getFhir_mappingElement(), false);
            this.composeStringExtras("fhir_mapping", element.getFhir_mappingElement(), false);
        }
        if (element.hasVset_descriptionElement()) {
            this.composeStringCore("vset_description", element.getVset_descriptionElement(), false);
            this.composeStringExtras("vset_description", element.getVset_descriptionElement(), false);
        }
        if (element.hasHl7v2_mappingElement()) {
            this.composeStringCore("hl7v2_mapping", element.getHl7v2_mappingElement(), false);
            this.composeStringExtras("hl7v2_mapping", element.getHl7v2_mappingElement(), false);
        }
        if (element.hasVisibleInViewElement()) {
            this.composeStringCore("visibleInView", element.getVisibleInViewElement(), false);
            this.composeStringExtras("visibleInView", element.getVisibleInViewElement(), false);
        }
    }

    protected void composeCAPABILITY(String name, CAPABILITY element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCAPABILITYProperties(element);
            this.close();
        }
    }

    protected void composeCAPABILITYProperties(CAPABILITY element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasCredentials()) {
            this.composeITEM_STRUCTURE("credentials", element.getCredentials());
        }
        if (element.hasTime_validity()) {
            this.composeDV_INTERVAL("time_validity", element.getTime_validity());
        }
    }

    protected void composeCLUSTER(String name, CLUSTER element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCLUSTERProperties(element);
            this.close();
        }
    }

    protected void composeCLUSTERProperties(CLUSTER element) throws IOException {
        this.composeITEMProperties(element);
        if (element.hasItems()) {
            this.openArray("items");
            for (ITEM e : element.getItemsList()) {
                this.composeITEM(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeCODE_PHRASE(String name, CODE_PHRASE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCODE_PHRASEProperties(element);
            this.close();
        }
    }

    protected void composeCODE_PHRASEProperties(CODE_PHRASE element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasTerminology_id()) {
            this.composeTERMINOLOGY_ID("terminology_id", element.getTerminology_id());
        }
        if (element.hasCode_stringElement()) {
            this.composeStringCore("code_string", element.getCode_stringElement(), false);
            this.composeStringExtras("code_string", element.getCode_stringElement(), false);
        }
        if (element.hasPreferred_termElement()) {
            this.composeStringCore("preferred_term", element.getPreferred_termElement(), false);
            this.composeStringExtras("preferred_term", element.getPreferred_termElement(), false);
        }
    }

    protected void composeCOMPOSITION(String name, COMPOSITION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCOMPOSITIONProperties(element);
            this.close();
        }
    }

    protected void composeCOMPOSITIONProperties(COMPOSITION element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasLanguage()) {
            this.composeCODE_PHRASE("language", element.getLanguage());
        }
        if (element.hasTerritory()) {
            this.composeCODE_PHRASE("territory", element.getTerritory());
        }
        if (element.hasCategory()) {
            this.composeDV_CODED_TEXT("category", element.getCategory());
        }
        if (element.hasContext()) {
            this.composeEVENT_CONTEXT("context", element.getContext());
        }
        if (element.hasComposer()) {
            this.composePARTY_PROXY("composer", element.getComposer());
        }
        if (element.hasContent()) {
            this.openArray("content");
            for (CONTENT_ITEM e : element.getContentList()) {
                this.composeCONTENT_ITEM(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeCONTACT(String name, CONTACT element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCONTACTProperties(element);
            this.close();
        }
    }

    protected void composeCONTACTProperties(CONTACT element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasAddresses()) {
            this.openArray("addresses");
            for (ADDRESS e : element.getAddressesList()) {
                this.composeADDRESS(null, e);
            }
            this.closeArray();
        }
        if (element.hasTime_validity()) {
            this.composeDV_INTERVAL("time_validity", element.getTime_validity());
        }
    }

    protected void composeCONTRIBUTION(String name, CONTRIBUTION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCONTRIBUTIONProperties(element);
            this.close();
        }
    }

    protected void composeCONTRIBUTIONProperties(CONTRIBUTION element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasUid()) {
            this.composeHIER_OBJECT_ID("uid", element.getUid());
        }
        if (element.hasVersions()) {
            this.openArray("versions");
            for (OBJECT_REF e : element.getVersionsList()) {
                this.composeOBJECT_REF(null, e);
            }
            this.closeArray();
        }
        if (element.hasAudit()) {
            this.composeAUDIT_DETAILS("audit", element.getAudit());
        }
    }

    protected void composeDV_BOOLEAN(String name, DV_BOOLEAN element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_BOOLEANProperties(element);
            this.close();
        }
    }

    protected void composeDV_BOOLEANProperties(DV_BOOLEAN element) throws IOException {
        this.composeDATA_VALUEProperties(element);
        if (element.hasValueElement()) {
            this.composeBooleanCore("value", element.getValueElement(), false);
            this.composeBooleanExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeDV_CODED_TEXT(String name, DV_CODED_TEXT element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_CODED_TEXTProperties(element);
            this.close();
        }
    }

    protected void composeDV_CODED_TEXTProperties(DV_CODED_TEXT element) throws IOException {
        this.composeDV_TEXTProperties(element);
        if (element.hasDefining_code()) {
            this.composeCODE_PHRASE("defining_code", element.getDefining_code());
        }
    }

    protected void composeDV_COUNT(String name, DV_COUNT element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_COUNTProperties(element);
            this.close();
        }
    }

    protected void composeDV_COUNTProperties(DV_COUNT element) throws IOException {
        this.composeDV_AMOUNTProperties(element);
        if (element.hasMagnitudeElement()) {
            this.composeDecimalCore("magnitude", element.getMagnitudeElement(), false);
            this.composeDecimalExtras("magnitude", element.getMagnitudeElement(), false);
        }
    }

    protected void composeDV_DATE_TIME(String name, DV_DATE_TIME element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_DATE_TIMEProperties(element);
            this.close();
        }
    }

    protected void composeDV_DATE_TIMEProperties(DV_DATE_TIME element) throws IOException {
        this.composeDV_ORDEREDProperties(element);
        if (element.hasValueElement()) {
            this.composeDateTimeCore("value", element.getValueElement(), false);
            this.composeDateTimeExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeDV_DATE(String name, DV_DATE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_DATEProperties(element);
            this.close();
        }
    }

    protected void composeDV_DATEProperties(DV_DATE element) throws IOException {
        this.composeDV_TEMPORALProperties(element);
        if (element.hasValueElement()) {
            this.composeDateTimeCore("value", element.getValueElement(), false);
            this.composeDateTimeExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeDV_DURATION(String name, DV_DURATION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_DURATIONProperties(element);
            this.close();
        }
    }

    protected void composeDV_DURATIONProperties(DV_DURATION element) throws IOException {
        this.composeDV_AMOUNTProperties(element);
        if (element.hasValueElement()) {
            this.composeStringCore("value", element.getValueElement(), false);
            this.composeStringExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeDV_EHR_URI(String name, DV_EHR_URI element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_EHR_URIProperties(element);
            this.close();
        }
    }

    protected void composeDV_EHR_URIProperties(DV_EHR_URI element) throws IOException {
        this.composeDV_URIProperties(element);
    }

    protected void composeDV_GENERAL_TIME_SPECIFICATION(String name, DV_GENERAL_TIME_SPECIFICATION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_GENERAL_TIME_SPECIFICATIONProperties(element);
            this.close();
        }
    }

    protected void composeDV_GENERAL_TIME_SPECIFICATIONProperties(DV_GENERAL_TIME_SPECIFICATION element) throws IOException {
        this.composeDV_TIME_SPECIFICATIONProperties(element);
    }

    protected void composeDV_IDENTIFIER(String name, DV_IDENTIFIER element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_IDENTIFIERProperties(element);
            this.close();
        }
    }

    protected void composeDV_IDENTIFIERProperties(DV_IDENTIFIER element) throws IOException {
        this.composeDATA_VALUEProperties(element);
        if (element.hasIssuerElement()) {
            this.composeStringCore("issuer", element.getIssuerElement(), false);
            this.composeStringExtras("issuer", element.getIssuerElement(), false);
        }
        if (element.hasAssignerElement()) {
            this.composeStringCore("assigner", element.getAssignerElement(), false);
            this.composeStringExtras("assigner", element.getAssignerElement(), false);
        }
        if (element.hasIdElement()) {
            this.composeStringCore("id", element.getIdElement(), false);
            this.composeStringExtras("id", element.getIdElement(), false);
        }
        if (element.hasTypeElement()) {
            this.composeStringCore("type", element.getTypeElement(), false);
            this.composeStringExtras("type", element.getTypeElement(), false);
        }
    }

    protected void composeDV_INTERVAL(String name, DV_INTERVAL element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_INTERVALProperties(element);
            this.close();
        }
    }

    protected void composeDV_INTERVALProperties(DV_INTERVAL element) throws IOException {
        this.composeDV_ORDEREDProperties(element);
    }

    protected void composeDV_MULTIMEDIA(String name, DV_MULTIMEDIA element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_MULTIMEDIAProperties(element);
            this.close();
        }
    }

    protected void composeDV_MULTIMEDIAProperties(DV_MULTIMEDIA element) throws IOException {
        this.composeDV_ENCAPSULATEDProperties(element);
        if (element.hasAlternate_textElement()) {
            this.composeStringCore("alternate_text", element.getAlternate_textElement(), false);
            this.composeStringExtras("alternate_text", element.getAlternate_textElement(), false);
        }
        if (element.hasUri()) {
            this.composeDV_URI("uri", element.getUri());
        }
        if (element.hasDataElement()) {
            this.composeBase64BinaryCore("data", element.getDataElement(), false);
            this.composeBase64BinaryExtras("data", element.getDataElement(), false);
        }
        if (element.hasMedia_type()) {
            this.composeCODE_PHRASE("media_type", element.getMedia_type());
        }
        if (element.hasCompression_algorithm()) {
            this.composeCODE_PHRASE("compression_algorithm", element.getCompression_algorithm());
        }
        if (element.hasIntegrity_checkElement()) {
            this.composeBase64BinaryCore("integrity_check", element.getIntegrity_checkElement(), false);
            this.composeBase64BinaryExtras("integrity_check", element.getIntegrity_checkElement(), false);
        }
        if (element.hasIntegrity_check_algorithm()) {
            this.composeCODE_PHRASE("integrity_check_algorithm", element.getIntegrity_check_algorithm());
        }
        if (element.hasThumbnail()) {
            this.composeDV_MULTIMEDIA("thumbnail", element.getThumbnail());
        }
        if (element.hasSizeElement()) {
            this.composeIntegerCore("size", element.getSizeElement(), false);
            this.composeIntegerExtras("size", element.getSizeElement(), false);
        }
    }

    protected void composeDV_ORDINAL(String name, DV_ORDINAL element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_ORDINALProperties(element);
            this.close();
        }
    }

    protected void composeDV_ORDINALProperties(DV_ORDINAL element) throws IOException {
        this.composeDV_ORDEREDProperties(element);
        if (element.hasSymbol()) {
            this.composeDV_CODED_TEXT("symbol", element.getSymbol());
        }
        if (element.hasValueElement()) {
            this.composeIntegerCore("value", element.getValueElement(), false);
            this.composeIntegerExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeDV_PARAGRAPH(String name, DV_PARAGRAPH element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_PARAGRAPHProperties(element);
            this.close();
        }
    }

    protected void composeDV_PARAGRAPHProperties(DV_PARAGRAPH element) throws IOException {
        this.composeDATA_VALUEProperties(element);
        if (element.hasItems()) {
            this.openArray("items");
            for (DV_TEXT e : element.getItemsList()) {
                this.composeDV_TEXT(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeDV_PARSABLE(String name, DV_PARSABLE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_PARSABLEProperties(element);
            this.close();
        }
    }

    protected void composeDV_PARSABLEProperties(DV_PARSABLE element) throws IOException {
        this.composeDV_ENCAPSULATEDProperties(element);
        if (element.hasValueElement()) {
            this.composeStringCore("value", element.getValueElement(), false);
            this.composeStringExtras("value", element.getValueElement(), false);
        }
        if (element.hasFormalismElement()) {
            this.composeStringCore("formalism", element.getFormalismElement(), false);
            this.composeStringExtras("formalism", element.getFormalismElement(), false);
        }
    }

    protected void composeDV_PERIODIC_TIME_SPECIFICATION(String name, DV_PERIODIC_TIME_SPECIFICATION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_PERIODIC_TIME_SPECIFICATIONProperties(element);
            this.close();
        }
    }

    protected void composeDV_PERIODIC_TIME_SPECIFICATIONProperties(DV_PERIODIC_TIME_SPECIFICATION element) throws IOException {
        this.composeDV_TIME_SPECIFICATIONProperties(element);
    }

    protected void composeDV_PROPORTION(String name, DV_PROPORTION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_PROPORTIONProperties(element);
            this.close();
        }
    }

    protected void composeDV_PROPORTIONProperties(DV_PROPORTION element) throws IOException {
        this.composeDV_AMOUNTProperties(element);
        if (element.hasNumeratorElement()) {
            this.composeDecimalCore("numerator", element.getNumeratorElement(), false);
            this.composeDecimalExtras("numerator", element.getNumeratorElement(), false);
        }
        if (element.hasDenominatorElement()) {
            this.composeDecimalCore("denominator", element.getDenominatorElement(), false);
            this.composeDecimalExtras("denominator", element.getDenominatorElement(), false);
        }
        if (element.hasTypeElement()) {
            this.composeCodeCore("type", element.getTypeElement(), false);
            this.composeCodeExtras("type", element.getTypeElement(), false);
        }
        if (element.hasPrecisionElement()) {
            this.composeIntegerCore("precision", element.getPrecisionElement(), false);
            this.composeIntegerExtras("precision", element.getPrecisionElement(), false);
        }
    }

    protected void composeDV_QUANTITY(String name, DV_QUANTITY element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_QUANTITYProperties(element);
            this.close();
        }
    }

    protected void composeDV_QUANTITYProperties(DV_QUANTITY element) throws IOException {
        this.composeDV_AMOUNTProperties(element);
        if (element.hasMagnitudeElement()) {
            this.composeDecimalCore("magnitude", element.getMagnitudeElement(), false);
            this.composeDecimalExtras("magnitude", element.getMagnitudeElement(), false);
        }
        if (element.hasPrecisionElement()) {
            this.composeIntegerCore("precision", element.getPrecisionElement(), false);
            this.composeIntegerExtras("precision", element.getPrecisionElement(), false);
        }
        if (element.hasUnitsElement()) {
            this.composeStringCore("units", element.getUnitsElement(), false);
            this.composeStringExtras("units", element.getUnitsElement(), false);
        }
        if (element.hasUnits_systemElement()) {
            this.composeStringCore("units_system", element.getUnits_systemElement(), false);
            this.composeStringExtras("units_system", element.getUnits_systemElement(), false);
        }
        if (element.hasUnits_display_nameElement()) {
            this.composeStringCore("units_display_name", element.getUnits_display_nameElement(), false);
            this.composeStringExtras("units_display_name", element.getUnits_display_nameElement(), false);
        }
    }

    protected void composeDV_SCALE(String name, DV_SCALE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_SCALEProperties(element);
            this.close();
        }
    }

    protected void composeDV_SCALEProperties(DV_SCALE element) throws IOException {
        this.composeDV_ORDEREDProperties(element);
        if (element.hasSymbol()) {
            this.composeDV_CODED_TEXT("symbol", element.getSymbol());
        }
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeDV_STATE(String name, DV_STATE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_STATEProperties(element);
            this.close();
        }
    }

    protected void composeDV_STATEProperties(DV_STATE element) throws IOException {
        this.composeDATA_VALUEProperties(element);
        if (element.hasValue()) {
            this.composeDV_CODED_TEXT("value", element.getValue());
        }
        if (element.hasIs_terminalElement()) {
            this.composeBooleanCore("is_terminal", element.getIs_terminalElement(), false);
            this.composeBooleanExtras("is_terminal", element.getIs_terminalElement(), false);
        }
    }

    protected void composeDV_TEXT(String name, DV_TEXT element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_TEXTProperties(element);
            this.close();
        }
    }

    protected void composeDV_TEXTProperties(DV_TEXT element) throws IOException {
        this.composeDATA_VALUEProperties(element);
        if (element.hasValueElement()) {
            this.composeStringCore("value", element.getValueElement(), false);
            this.composeStringExtras("value", element.getValueElement(), false);
        }
        if (element.hasHyperlink()) {
            this.composeDV_URI("hyperlink", element.getHyperlink());
        }
        if (element.hasFormattingElement()) {
            this.composeStringCore("formatting", element.getFormattingElement(), false);
            this.composeStringExtras("formatting", element.getFormattingElement(), false);
        }
        if (element.hasMappings()) {
            this.openArray("mappings");
            for (TERM_MAPPING e : element.getMappingsList()) {
                this.composeTERM_MAPPING(null, e);
            }
            this.closeArray();
        }
        if (element.hasLanguage()) {
            this.composeCODE_PHRASE("language", element.getLanguage());
        }
        if (element.hasEncoding()) {
            this.composeCODE_PHRASE("encoding", element.getEncoding());
        }
    }

    protected void composeDV_TIME(String name, DV_TIME element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_TIMEProperties(element);
            this.close();
        }
    }

    protected void composeDV_TIMEProperties(DV_TIME element) throws IOException {
        this.composeDV_ORDEREDProperties(element);
        if (element.hasValueElement()) {
            this.composeStringCore("value", element.getValueElement(), false);
            this.composeStringExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeDV_URI(String name, DV_URI element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDV_URIProperties(element);
            this.close();
        }
    }

    protected void composeDV_URIProperties(DV_URI element) throws IOException {
        this.composeDATA_VALUEProperties(element);
        if (element.hasValueElement()) {
            this.composeUriCore("value", element.getValueElement(), false);
            this.composeUriExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeEHR_ACCESS(String name, EHR_ACCESS element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeEHR_ACCESSProperties(element);
            this.close();
        }
    }

    protected void composeEHR_ACCESSProperties(EHR_ACCESS element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasSettings()) {
            this.composeACCESS_CONTROL_SETTINGS("settings", element.getSettings());
        }
    }

    protected void composeEHR_STATUS(String name, EHR_STATUS element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeEHR_STATUSProperties(element);
            this.close();
        }
    }

    protected void composeEHR_STATUSProperties(EHR_STATUS element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasSubject()) {
            this.composePARTY_SELF("subject", element.getSubject());
        }
        if (element.hasIs_queryableElement()) {
            this.composeBooleanCore("is_queryable", element.getIs_queryableElement(), false);
            this.composeBooleanExtras("is_queryable", element.getIs_queryableElement(), false);
        }
        if (element.hasIs_modifiableElement()) {
            this.composeBooleanCore("is_modifiable", element.getIs_modifiableElement(), false);
            this.composeBooleanExtras("is_modifiable", element.getIs_modifiableElement(), false);
        }
        if (element.hasOther_details()) {
            this.composeITEM_STRUCTURE("other_details", element.getOther_details());
        }
    }

    protected void composeEHR(String name, EHR element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeEHRProperties(element);
            this.close();
        }
    }

    protected void composeEHRProperties(EHR element) throws IOException {
        this.composeAnyProperties(element);
        if (element.hasSystem_id()) {
            this.openArray("system_id");
            for (HIER_OBJECT_ID hIER_OBJECT_ID : element.getSystem_idList()) {
                this.composeHIER_OBJECT_ID(null, hIER_OBJECT_ID);
            }
            this.closeArray();
        }
        if (element.hasEhr_id()) {
            this.composeHIER_OBJECT_ID("ehr_id", element.getEhr_id());
        }
        if (element.hasContributions()) {
            this.openArray("contributions");
            for (OBJECT_REF oBJECT_REF : element.getContributionsList()) {
                this.composeOBJECT_REF(null, oBJECT_REF);
            }
            this.closeArray();
        }
        if (element.hasEhr_status()) {
            this.composeOBJECT_REF("ehr_status", element.getEhr_status());
        }
        if (element.hasEhr_access()) {
            this.composeOBJECT_REF("ehr_access", element.getEhr_access());
        }
        if (element.hasCompositions()) {
            this.openArray("compositions");
            for (OBJECT_REF oBJECT_REF : element.getCompositionsList()) {
                this.composeOBJECT_REF(null, oBJECT_REF);
            }
            this.closeArray();
        }
        if (element.hasDirectory()) {
            this.composeOBJECT_REF("directory", element.getDirectory());
        }
        if (element.hasTime_created()) {
            this.composeDV_DATE_TIME("time_created", element.getTime_created());
        }
        if (element.hasFolders()) {
            this.openArray("folders");
            for (OBJECT_REF oBJECT_REF : element.getFoldersList()) {
                this.composeOBJECT_REF(null, oBJECT_REF);
            }
            this.closeArray();
        }
        if (element.hasTags()) {
            this.openArray("tags");
            for (OBJECT_REF oBJECT_REF : element.getTagsList()) {
                this.composeOBJECT_REF(null, oBJECT_REF);
            }
            this.closeArray();
        }
    }

    protected void composeELEMENT(String name, ELEMENT element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeELEMENTProperties(element);
            this.close();
        }
    }

    protected void composeELEMENTProperties(ELEMENT element) throws IOException {
        this.composeITEMProperties(element);
        if (element.hasNull_flavour()) {
            this.composeDV_CODED_TEXT("null_flavour", element.getNull_flavour());
        }
        if (element.hasValue()) {
            this.composeDATA_VALUE("value", element.getValue());
        }
        if (element.hasNull_reason()) {
            this.composeDV_TEXT("null_reason", element.getNull_reason());
        }
    }

    protected void composeEVALUATION(String name, EVALUATION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeEVALUATIONProperties(element);
            this.close();
        }
    }

    protected void composeEVALUATIONProperties(EVALUATION element) throws IOException {
        this.composeCARE_ENTRYProperties(element);
        if (element.hasData()) {
            this.composeITEM_STRUCTURE("data", element.getData());
        }
    }

    protected void composeEVENT_CONTEXT(String name, EVENT_CONTEXT element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeEVENT_CONTEXTProperties(element);
            this.close();
        }
    }

    protected void composeEVENT_CONTEXTProperties(EVENT_CONTEXT element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasStart_time()) {
            this.composeDV_DATE_TIME("start_time", element.getStart_time());
        }
        if (element.hasEnd_time()) {
            this.composeDV_DATE_TIME("end_time", element.getEnd_time());
        }
        if (element.hasLocationElement()) {
            this.composeStringCore("location", element.getLocationElement(), false);
            this.composeStringExtras("location", element.getLocationElement(), false);
        }
        if (element.hasSetting()) {
            this.composeDV_CODED_TEXT("setting", element.getSetting());
        }
        if (element.hasOther_context()) {
            this.composeITEM_STRUCTURE("other_context", element.getOther_context());
        }
        if (element.hasHealth_care_facility()) {
            this.composePARTY_IDENTIFIED("health_care_facility", element.getHealth_care_facility());
        }
        if (element.hasParticipations()) {
            this.openArray("participations");
            for (PARTICIPATION e : element.getParticipationsList()) {
                this.composePARTICIPATION(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeFEEDER_AUDIT_DETAILS(String name, FEEDER_AUDIT_DETAILS element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeFEEDER_AUDIT_DETAILSProperties(element);
            this.close();
        }
    }

    protected void composeFEEDER_AUDIT_DETAILSProperties(FEEDER_AUDIT_DETAILS element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasSystem_idElement()) {
            this.composeStringCore("system_id", element.getSystem_idElement(), false);
            this.composeStringExtras("system_id", element.getSystem_idElement(), false);
        }
        if (element.hasLocation()) {
            this.composePARTY_IDENTIFIED("location", element.getLocation());
        }
        if (element.hasSubject()) {
            this.composePARTY_PROXY("subject", element.getSubject());
        }
        if (element.hasProvider()) {
            this.composePARTY_IDENTIFIED("provider", element.getProvider());
        }
        if (element.hasTime()) {
            this.composeDV_DATE_TIME("time", element.getTime());
        }
        if (element.hasVersion_idElement()) {
            this.composeStringCore("version_id", element.getVersion_idElement(), false);
            this.composeStringExtras("version_id", element.getVersion_idElement(), false);
        }
        if (element.hasOther_details()) {
            this.composeITEM_STRUCTURE("other_details", element.getOther_details());
        }
    }

    protected void composeFEEDER_AUDIT(String name, FEEDER_AUDIT element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeFEEDER_AUDITProperties(element);
            this.close();
        }
    }

    protected void composeFEEDER_AUDITProperties(FEEDER_AUDIT element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasOriginating_system_item_ids()) {
            this.openArray("originating_system_item_ids");
            for (DV_IDENTIFIER e : element.getOriginating_system_item_idsList()) {
                this.composeDV_IDENTIFIER(null, e);
            }
            this.closeArray();
        }
        if (element.hasFeeder_system_item_ids()) {
            this.openArray("feeder_system_item_ids");
            for (DV_IDENTIFIER e : element.getFeeder_system_item_idsList()) {
                this.composeDV_IDENTIFIER(null, e);
            }
            this.closeArray();
        }
        if (element.hasOriginal_content()) {
            this.composeDV_ENCAPSULATED("original_content", element.getOriginal_content());
        }
        if (element.hasOriginating_system_audit()) {
            this.composeFEEDER_AUDIT_DETAILS("originating_system_audit", element.getOriginating_system_audit());
        }
        if (element.hasFeeder_system_audit()) {
            this.composeFEEDER_AUDIT_DETAILS("feeder_system_audit", element.getFeeder_system_audit());
        }
    }

    protected void composeFOLDER(String name, FOLDER element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeFOLDERProperties(element);
            this.close();
        }
    }

    protected void composeFOLDERProperties(FOLDER element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasItems()) {
            this.openArray("items");
            for (OBJECT_REF oBJECT_REF : element.getItemsList()) {
                this.composeOBJECT_REF(null, oBJECT_REF);
            }
            this.closeArray();
        }
        if (element.hasFolders()) {
            this.openArray("folders");
            for (FOLDER fOLDER : element.getFoldersList()) {
                this.composeFOLDER(null, fOLDER);
            }
            this.closeArray();
        }
        if (element.hasDetails()) {
            this.composeITEM_STRUCTURE("details", element.getDetails());
        }
    }

    protected void composeGENERIC_ID(String name, GENERIC_ID element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeGENERIC_IDProperties(element);
            this.close();
        }
    }

    protected void composeGENERIC_IDProperties(GENERIC_ID element) throws IOException {
        this.composeOBJECT_IDProperties(element);
    }

    protected void composeGROUP(String name, GROUP element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeGROUPProperties(element);
            this.close();
        }
    }

    protected void composeGROUPProperties(GROUP element) throws IOException {
        this.composeACTORProperties(element);
    }

    protected void composeHIER_OBJECT_ID(String name, HIER_OBJECT_ID element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeHIER_OBJECT_IDProperties(element);
            this.close();
        }
    }

    protected void composeHIER_OBJECT_IDProperties(HIER_OBJECT_ID element) throws IOException {
        this.composeUID_BASED_IDProperties(element);
    }

    protected void composeHISTORY(String name, HISTORY element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeHISTORYProperties(element);
            this.close();
        }
    }

    protected void composeHISTORYProperties(HISTORY element) throws IOException {
        this.composeDATA_STRUCTUREProperties(element);
        if (element.hasOrigin()) {
            this.composeDV_DATE_TIME("origin", element.getOrigin());
        }
        if (element.hasPeriod()) {
            this.composeDV_DURATION("period", element.getPeriod());
        }
        if (element.hasDuration()) {
            this.composeDV_DURATION("duration", element.getDuration());
        }
        if (element.hasSummary()) {
            this.composeITEM_STRUCTURE("summary", element.getSummary());
        }
        if (element.hasEvents()) {
            this.openArray("events");
            for (EVENT e : element.getEventsList()) {
                this.composeEVENT(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeIMPORTED_VERSION(String name, IMPORTED_VERSION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeIMPORTED_VERSIONProperties(element);
            this.close();
        }
    }

    protected void composeIMPORTED_VERSIONProperties(IMPORTED_VERSION element) throws IOException {
        this.composeVERSIONProperties(element);
        if (element.hasItem()) {
            this.composeORIGINAL_VERSION("item", element.getItem());
        }
    }

    protected void composeINSTRUCTION_DETAILS(String name, INSTRUCTION_DETAILS element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeINSTRUCTION_DETAILSProperties(element);
            this.close();
        }
    }

    protected void composeINSTRUCTION_DETAILSProperties(INSTRUCTION_DETAILS element) throws IOException {
        this.composePATHABLEProperties(element);
        if (element.hasInstruction_id()) {
            this.composeLOCATABLE_REF("instruction_id", element.getInstruction_id());
        }
        if (element.hasActivity_idElement()) {
            this.composeStringCore("activity_id", element.getActivity_idElement(), false);
            this.composeStringExtras("activity_id", element.getActivity_idElement(), false);
        }
        if (element.hasWf_details()) {
            this.composeITEM_STRUCTURE("wf_details", element.getWf_details());
        }
    }

    protected void composeINSTRUCTION(String name, INSTRUCTION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeINSTRUCTIONProperties(element);
            this.close();
        }
    }

    protected void composeINSTRUCTIONProperties(INSTRUCTION element) throws IOException {
        this.composeCARE_ENTRYProperties(element);
        if (element.hasNarrative()) {
            this.composeDV_TEXT("narrative", element.getNarrative());
        }
        if (element.hasExpiry_time()) {
            this.composeDV_DATE_TIME("expiry_time", element.getExpiry_time());
        }
        if (element.hasWf_definition()) {
            this.composeDV_PARSABLE("wf_definition", element.getWf_definition());
        }
        if (element.hasActivities()) {
            this.openArray("activities");
            for (ACTIVITY e : element.getActivitiesList()) {
                this.composeACTIVITY(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeINTERNET_ID(String name, INTERNET_ID element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeINTERNET_IDProperties(element);
            this.close();
        }
    }

    protected void composeINTERNET_IDProperties(INTERNET_ID element) throws IOException {
        this.composeUIDProperties(element);
    }

    protected void composeINTERVAL_EVENT(String name, INTERVAL_EVENT element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeINTERVAL_EVENTProperties(element);
            this.close();
        }
    }

    protected void composeINTERVAL_EVENTProperties(INTERVAL_EVENT element) throws IOException {
        this.composeEVENTProperties(element);
        if (element.hasWidth()) {
            this.composeDV_DURATION("width", element.getWidth());
        }
        if (element.hasSample_countElement()) {
            this.composeIntegerCore("sample_count", element.getSample_countElement(), false);
            this.composeIntegerExtras("sample_count", element.getSample_countElement(), false);
        }
        if (element.hasMath_function()) {
            this.composeDV_CODED_TEXT("math_function", element.getMath_function());
        }
    }

    protected void composeISM_TRANSITION(String name, ISM_TRANSITION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeISM_TRANSITIONProperties(element);
            this.close();
        }
    }

    protected void composeISM_TRANSITIONProperties(ISM_TRANSITION element) throws IOException {
        this.composePATHABLEProperties(element);
        if (element.hasCurrent_state()) {
            this.composeDV_CODED_TEXT("current_state", element.getCurrent_state());
        }
        if (element.hasTransition()) {
            this.composeDV_CODED_TEXT("transition", element.getTransition());
        }
        if (element.hasCareflow_step()) {
            this.composeDV_CODED_TEXT("careflow_step", element.getCareflow_step());
        }
        if (element.hasReason()) {
            this.openArray("reason");
            for (DV_TEXT e : element.getReasonList()) {
                this.composeDV_TEXT(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeISO_OID(String name, ISO_OID element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeISO_OIDProperties(element);
            this.close();
        }
    }

    protected void composeISO_OIDProperties(ISO_OID element) throws IOException {
        this.composeUIDProperties(element);
    }

    protected void composeITEM_LIST(String name, ITEM_LIST element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeITEM_LISTProperties(element);
            this.close();
        }
    }

    protected void composeITEM_LISTProperties(ITEM_LIST element) throws IOException {
        this.composeITEM_STRUCTUREProperties(element);
        if (element.hasItems()) {
            this.openArray("items");
            for (ELEMENT e : element.getItemsList()) {
                this.composeELEMENT(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeITEM_SINGLE(String name, ITEM_SINGLE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeITEM_SINGLEProperties(element);
            this.close();
        }
    }

    protected void composeITEM_SINGLEProperties(ITEM_SINGLE element) throws IOException {
        this.composeITEM_STRUCTUREProperties(element);
        if (element.hasItem()) {
            this.composeELEMENT("item", element.getItem());
        }
    }

    protected void composeITEM_TABLE(String name, ITEM_TABLE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeITEM_TABLEProperties(element);
            this.close();
        }
    }

    protected void composeITEM_TABLEProperties(ITEM_TABLE element) throws IOException {
        this.composeITEM_STRUCTUREProperties(element);
        if (element.hasRows()) {
            this.openArray("rows");
            for (CLUSTER e : element.getRowsList()) {
                this.composeCLUSTER(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeITEM_TAG(String name, ITEM_TAG element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeITEM_TAGProperties(element);
            this.close();
        }
    }

    protected void composeITEM_TAGProperties(ITEM_TAG element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasKeyElement()) {
            this.composeStringCore("key", element.getKeyElement(), false);
            this.composeStringExtras("key", element.getKeyElement(), false);
        }
        if (element.hasValueElement()) {
            this.composeStringCore("value", element.getValueElement(), false);
            this.composeStringExtras("value", element.getValueElement(), false);
        }
        if (element.hasTarget()) {
            this.composeUID_BASED_ID("target", element.getTarget());
        }
        if (element.hasTarget_pathElement()) {
            this.composeStringCore("target_path", element.getTarget_pathElement(), false);
            this.composeStringExtras("target_path", element.getTarget_pathElement(), false);
        }
        if (element.hasOwner_id()) {
            this.composeOBJECT_REF("owner_id", element.getOwner_id());
        }
    }

    protected void composeITEM_TREE(String name, ITEM_TREE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeITEM_TREEProperties(element);
            this.close();
        }
    }

    protected void composeITEM_TREEProperties(ITEM_TREE element) throws IOException {
        this.composeITEM_STRUCTUREProperties(element);
        if (element.hasItems()) {
            this.openArray("items");
            for (ITEM e : element.getItemsList()) {
                this.composeITEM(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeLINK(String name, LINK element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeLINKProperties(element);
            this.close();
        }
    }

    protected void composeLINKProperties(LINK element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasMeaning()) {
            this.composeDV_TEXT("meaning", element.getMeaning());
        }
        if (element.hasType()) {
            this.composeDV_TEXT("type", element.getType());
        }
        if (element.hasTarget()) {
            this.composeDV_EHR_URI("target", element.getTarget());
        }
    }

    protected void composeLOCATABLE_REF(String name, LOCATABLE_REF element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeLOCATABLE_REFProperties(element);
            this.close();
        }
    }

    protected void composeLOCATABLE_REFProperties(LOCATABLE_REF element) throws IOException {
        this.composeOBJECT_REFProperties(element);
        if (element.hasPathElement()) {
            this.composeStringCore("path", element.getPathElement(), false);
            this.composeStringExtras("path", element.getPathElement(), false);
        }
    }

    protected void composeOBJECT_REF(String name, OBJECT_REF element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeOBJECT_REFProperties(element);
            this.close();
        }
    }

    protected void composeOBJECT_REFProperties(OBJECT_REF element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasNamespaceElement()) {
            this.composeStringCore("namespace", element.getNamespaceElement(), false);
            this.composeStringExtras("namespace", element.getNamespaceElement(), false);
        }
        if (element.hasTypeElement()) {
            this.composeStringCore("type", element.getTypeElement(), false);
            this.composeStringExtras("type", element.getTypeElement(), false);
        }
        if (element.hasId()) {
            this.composeOBJECT_ID("id", element.getId());
        }
    }

    protected void composeOBJECT_VERSION_ID(String name, OBJECT_VERSION_ID element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeOBJECT_VERSION_IDProperties(element);
            this.close();
        }
    }

    protected void composeOBJECT_VERSION_IDProperties(OBJECT_VERSION_ID element) throws IOException {
        this.composeUID_BASED_IDProperties(element);
    }

    protected void composeOBSERVATION(String name, OBSERVATION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeOBSERVATIONProperties(element);
            this.close();
        }
    }

    protected void composeOBSERVATIONProperties(OBSERVATION element) throws IOException {
        this.composeCARE_ENTRYProperties(element);
        if (element.hasData()) {
            this.composeHISTORY("data", element.getData());
        }
        if (element.hasState()) {
            this.composeHISTORY("state", element.getState());
        }
    }

    protected void composeORGANISATION(String name, ORGANISATION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeORGANISATIONProperties(element);
            this.close();
        }
    }

    protected void composeORGANISATIONProperties(ORGANISATION element) throws IOException {
        this.composeACTORProperties(element);
    }

    protected void composeORIGINAL_VERSION(String name, ORIGINAL_VERSION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeORIGINAL_VERSIONProperties(element);
            this.close();
        }
    }

    protected void composeORIGINAL_VERSIONProperties(ORIGINAL_VERSION element) throws IOException {
        this.composeVERSIONProperties(element);
        if (element.hasUid()) {
            this.composeOBJECT_VERSION_ID("uid", element.getUid());
        }
        if (element.hasPreceding_version_uid()) {
            this.composeOBJECT_VERSION_ID("preceding_version_uid", element.getPreceding_version_uid());
        }
        if (element.hasOther_input_version_uids()) {
            this.openArray("other_input_version_uids");
            for (OBJECT_VERSION_ID oBJECT_VERSION_ID : element.getOther_input_version_uidsList()) {
                this.composeOBJECT_VERSION_ID(null, oBJECT_VERSION_ID);
            }
            this.closeArray();
        }
        if (element.hasLifecycle_state()) {
            this.composeDV_CODED_TEXT("lifecycle_state", element.getLifecycle_state());
        }
        if (element.hasAttestations()) {
            this.openArray("attestations");
            for (ATTESTATION aTTESTATION : element.getAttestationsList()) {
                this.composeATTESTATION(null, aTTESTATION);
            }
            this.closeArray();
        }
        if (element.hasData()) {
            this.composeAny("data", element.getData());
        }
    }

    protected void composePARTICIPATION(String name, PARTICIPATION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composePARTICIPATIONProperties(element);
            this.close();
        }
    }

    protected void composePARTICIPATIONProperties(PARTICIPATION element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasFunction()) {
            this.composeDV_TEXT("function", element.getFunction());
        }
        if (element.hasMode()) {
            this.composeDV_CODED_TEXT("mode", element.getMode());
        }
        if (element.hasPerformer()) {
            this.composePARTY_PROXY("performer", element.getPerformer());
        }
        if (element.hasTime()) {
            this.composeDV_INTERVAL("time", element.getTime());
        }
    }

    protected void composePARTY_IDENTIFIED(String name, PARTY_IDENTIFIED element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composePARTY_IDENTIFIEDProperties(element);
            this.close();
        }
    }

    protected void composePARTY_IDENTIFIEDProperties(PARTY_IDENTIFIED element) throws IOException {
        this.composePARTY_PROXYProperties(element);
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasIdentifiers()) {
            this.openArray("identifiers");
            for (DV_IDENTIFIER e : element.getIdentifiersList()) {
                this.composeDV_IDENTIFIER(null, e);
            }
            this.closeArray();
        }
    }

    protected void composePARTY_IDENTITY(String name, PARTY_IDENTITY element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composePARTY_IDENTITYProperties(element);
            this.close();
        }
    }

    protected void composePARTY_IDENTITYProperties(PARTY_IDENTITY element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasDetails()) {
            this.composeITEM_STRUCTURE("details", element.getDetails());
        }
    }

    protected void composePARTY_REF(String name, PARTY_REF element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composePARTY_REFProperties(element);
            this.close();
        }
    }

    protected void composePARTY_REFProperties(PARTY_REF element) throws IOException {
        this.composeOBJECT_REFProperties(element);
    }

    protected void composePARTY_RELATED(String name, PARTY_RELATED element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composePARTY_RELATEDProperties(element);
            this.close();
        }
    }

    protected void composePARTY_RELATEDProperties(PARTY_RELATED element) throws IOException {
        this.composePARTY_IDENTIFIEDProperties(element);
        if (element.hasRelationship()) {
            this.composeDV_CODED_TEXT("relationship", element.getRelationship());
        }
    }

    protected void composePARTY_RELATIONSHIP(String name, PARTY_RELATIONSHIP element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composePARTY_RELATIONSHIPProperties(element);
            this.close();
        }
    }

    protected void composePARTY_RELATIONSHIPProperties(PARTY_RELATIONSHIP element) throws IOException {
        this.composeLOCATABLEProperties(element);
        if (element.hasDetails()) {
            this.composeITEM_STRUCTURE("details", element.getDetails());
        }
        if (element.hasTarget()) {
            this.composePARTY_REF("target", element.getTarget());
        }
        if (element.hasTime_validity()) {
            this.composeDV_INTERVAL("time_validity", element.getTime_validity());
        }
        if (element.hasSource()) {
            this.composePARTY_REF("source", element.getSource());
        }
    }

    protected void composePARTY_SELF(String name, PARTY_SELF element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composePARTY_SELFProperties(element);
            this.close();
        }
    }

    protected void composePARTY_SELFProperties(PARTY_SELF element) throws IOException {
        this.composePARTY_PROXYProperties(element);
    }

    protected void composePERSON(String name, PERSON element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composePERSONProperties(element);
            this.close();
        }
    }

    protected void composePERSONProperties(PERSON element) throws IOException {
        this.composeACTORProperties(element);
    }

    protected void composePOINT_EVENT(String name, POINT_EVENT element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composePOINT_EVENTProperties(element);
            this.close();
        }
    }

    protected void composePOINT_EVENTProperties(POINT_EVENT element) throws IOException {
        this.composeEVENTProperties(element);
    }

    protected void composeREFERENCE_RANGE(String name, REFERENCE_RANGE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeREFERENCE_RANGEProperties(element);
            this.close();
        }
    }

    protected void composeREFERENCE_RANGEProperties(REFERENCE_RANGE element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasMeaning()) {
            this.composeDV_TEXT("meaning", element.getMeaning());
        }
        if (element.hasRange()) {
            this.composeDV_INTERVAL("range", element.getRange());
        }
    }

    protected void composeRESOURCE_DESCRIPTION_ITEM(String name, RESOURCE_DESCRIPTION_ITEM element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeRESOURCE_DESCRIPTION_ITEMProperties(element);
            this.close();
        }
    }

    protected void composeRESOURCE_DESCRIPTION_ITEMProperties(RESOURCE_DESCRIPTION_ITEM element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasLanguage()) {
            this.composeCODE_PHRASE("language", element.getLanguage());
        }
        if (element.hasPurposeElement()) {
            this.composeStringCore("purpose", element.getPurposeElement(), false);
            this.composeStringExtras("purpose", element.getPurposeElement(), false);
        }
        if (element.hasKeywords()) {
            if (this.anyHasValue(element.getKeywordsList())) {
                this.openArray("keywords");
                for (StringType e : element.getKeywordsList()) {
                    this.composeStringCore(null, e, e != element.getKeywordsList().get(element.getKeywordsList().size() - 1));
                }
                this.closeArray();
            }
            if (this.anyHasExtras(element.getKeywordsList())) {
                this.openArray("_keywords");
                for (StringType e : element.getKeywordsList()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasUseElement()) {
            this.composeStringCore("use", element.getUseElement(), false);
            this.composeStringExtras("use", element.getUseElement(), false);
        }
        if (element.hasMisuseElement()) {
            this.composeStringCore("misuse", element.getMisuseElement(), false);
            this.composeStringExtras("misuse", element.getMisuseElement(), false);
        }
        if (element.hasCopyrightElement()) {
            this.composeStringCore("copyright", element.getCopyrightElement(), false);
            this.composeStringExtras("copyright", element.getCopyrightElement(), false);
        }
        if (element.hasOriginal_resource_uri()) {
            if (this.anyHasValue(element.getOriginal_resource_uriList())) {
                this.openArray("original_resource_uri");
                for (StringType e : element.getOriginal_resource_uriList()) {
                    this.composeStringCore(null, e, e != element.getOriginal_resource_uriList().get(element.getOriginal_resource_uriList().size() - 1));
                }
                this.closeArray();
            }
            if (this.anyHasExtras(element.getOriginal_resource_uriList())) {
                this.openArray("_original_resource_uri");
                for (StringType e : element.getOriginal_resource_uriList()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasOther_details()) {
            if (this.anyHasValue(element.getOther_detailsList())) {
                this.openArray("other_details");
                for (StringType e : element.getOther_detailsList()) {
                    this.composeStringCore(null, e, e != element.getOther_detailsList().get(element.getOther_detailsList().size() - 1));
                }
                this.closeArray();
            }
            if (this.anyHasExtras(element.getOther_detailsList())) {
                this.openArray("_other_details");
                for (StringType e : element.getOther_detailsList()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
    }

    protected void composeRESOURCE_DESCRIPTION(String name, RESOURCE_DESCRIPTION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeRESOURCE_DESCRIPTIONProperties(element);
            this.close();
        }
    }

    protected void composeRESOURCE_DESCRIPTIONProperties(RESOURCE_DESCRIPTION element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasOriginal_author()) {
            if (this.anyHasValue(element.getOriginal_authorList())) {
                this.openArray("original_author");
                for (StringType stringType : element.getOriginal_authorList()) {
                    this.composeStringCore(null, stringType, stringType != element.getOriginal_authorList().get(element.getOriginal_authorList().size() - 1));
                }
                this.closeArray();
            }
            if (this.anyHasExtras(element.getOriginal_authorList())) {
                this.openArray("_original_author");
                for (StringType stringType : element.getOriginal_authorList()) {
                    this.composeStringExtras(null, stringType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasOther_contributors()) {
            if (this.anyHasValue(element.getOther_contributorsList())) {
                this.openArray("other_contributors");
                for (StringType stringType : element.getOther_contributorsList()) {
                    this.composeStringCore(null, stringType, stringType != element.getOther_contributorsList().get(element.getOther_contributorsList().size() - 1));
                }
                this.closeArray();
            }
            if (this.anyHasExtras(element.getOther_contributorsList())) {
                this.openArray("_other_contributors");
                for (StringType stringType : element.getOther_contributorsList()) {
                    this.composeStringExtras(null, stringType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasLifecycle_stateElement()) {
            this.composeStringCore("lifecycle_state", element.getLifecycle_stateElement(), false);
            this.composeStringExtras("lifecycle_state", element.getLifecycle_stateElement(), false);
        }
        if (element.hasResource_package_uriElement()) {
            this.composeStringCore("resource_package_uri", element.getResource_package_uriElement(), false);
            this.composeStringExtras("resource_package_uri", element.getResource_package_uriElement(), false);
        }
        if (element.hasOther_details()) {
            this.openArray("other_details");
            for (OBJECT_REF oBJECT_REF : element.getOther_detailsList()) {
                this.composeOBJECT_REF(null, oBJECT_REF);
            }
            this.closeArray();
        }
        if (element.hasParent_resource()) {
            this.composeAUTHORED_RESOURCE("parent_resource", element.getParent_resource());
        }
        if (element.hasDetails()) {
            this.openArray("details");
            for (RESOURCE_DESCRIPTION_ITEM rESOURCE_DESCRIPTION_ITEM : element.getDetailsList()) {
                this.composeRESOURCE_DESCRIPTION_ITEM(null, rESOURCE_DESCRIPTION_ITEM);
            }
            this.closeArray();
        }
    }

    protected void composeREVISION_HISTORY_ITEM(String name, REVISION_HISTORY_ITEM element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeREVISION_HISTORY_ITEMProperties(element);
            this.close();
        }
    }

    protected void composeREVISION_HISTORY_ITEMProperties(REVISION_HISTORY_ITEM element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasVersion_id()) {
            this.composeOBJECT_VERSION_ID("version_id", element.getVersion_id());
        }
        if (element.hasAudits()) {
            this.openArray("audits");
            for (AUDIT_DETAILS e : element.getAuditsList()) {
                this.composeAUDIT_DETAILS(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeREVISION_HISTORY(String name, REVISION_HISTORY element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeREVISION_HISTORYProperties(element);
            this.close();
        }
    }

    protected void composeREVISION_HISTORYProperties(REVISION_HISTORY element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasMost_recent_versionElement()) {
            this.composeStringCore("most_recent_version", element.getMost_recent_versionElement(), false);
            this.composeStringExtras("most_recent_version", element.getMost_recent_versionElement(), false);
        }
        if (element.hasMost_recent_version_time_committedElement()) {
            this.composeStringCore("most_recent_version_time_committed", element.getMost_recent_version_time_committedElement(), false);
            this.composeStringExtras("most_recent_version_time_committed", element.getMost_recent_version_time_committedElement(), false);
        }
    }

    protected void composeROLE(String name, ROLE element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeROLEProperties(element);
            this.close();
        }
    }

    protected void composeROLEProperties(ROLE element) throws IOException {
        this.composePARTYProperties(element);
        if (element.hasTime_validity()) {
            this.composeDV_INTERVAL("time_validity", element.getTime_validity());
        }
        if (element.hasPerformer()) {
            this.composePARTY_REF("performer", element.getPerformer());
        }
        if (element.hasCapabilities()) {
            this.openArray("capabilities");
            for (CAPABILITY e : element.getCapabilitiesList()) {
                this.composeCAPABILITY(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeSECTION(String name, SECTION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeSECTIONProperties(element);
            this.close();
        }
    }

    protected void composeSECTIONProperties(SECTION element) throws IOException {
        this.composeCONTENT_ITEMProperties(element);
        if (element.hasItems()) {
            this.openArray("items");
            for (CONTENT_ITEM e : element.getItemsList()) {
                this.composeCONTENT_ITEM(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeTEMPLATE_ID(String name, TEMPLATE_ID element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeTEMPLATE_IDProperties(element);
            this.close();
        }
    }

    protected void composeTEMPLATE_IDProperties(TEMPLATE_ID element) throws IOException {
        this.composeOBJECT_IDProperties(element);
    }

    protected void composeTERM_MAPPING(String name, TERM_MAPPING element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeTERM_MAPPINGProperties(element);
            this.close();
        }
    }

    protected void composeTERM_MAPPINGProperties(TERM_MAPPING element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasMatchElement()) {
            this.composeStringCore("match", element.getMatchElement(), false);
            this.composeStringExtras("match", element.getMatchElement(), false);
        }
        if (element.hasPurpose()) {
            this.composeDV_CODED_TEXT("purpose", element.getPurpose());
        }
        if (element.hasTarget()) {
            this.composeCODE_PHRASE("target", element.getTarget());
        }
    }

    protected void composeTERMINOLOGY_ID(String name, TERMINOLOGY_ID element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeTERMINOLOGY_IDProperties(element);
            this.close();
        }
    }

    protected void composeTERMINOLOGY_IDProperties(TERMINOLOGY_ID element) throws IOException {
        this.composeOBJECT_IDProperties(element);
    }

    protected void composeTRANSLATION_DETAILS(String name, TRANSLATION_DETAILS element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeTRANSLATION_DETAILSProperties(element);
            this.close();
        }
    }

    protected void composeTRANSLATION_DETAILSProperties(TRANSLATION_DETAILS element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasLanguage()) {
            this.composeCODE_PHRASE("language", element.getLanguage());
        }
        if (element.hasAuthor()) {
            if (this.anyHasValue(element.getAuthorList())) {
                this.openArray("author");
                for (StringType e : element.getAuthorList()) {
                    this.composeStringCore(null, e, e != element.getAuthorList().get(element.getAuthorList().size() - 1));
                }
                this.closeArray();
            }
            if (this.anyHasExtras(element.getAuthorList())) {
                this.openArray("_author");
                for (StringType e : element.getAuthorList()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasAccreditationElement()) {
            this.composeStringCore("accreditation", element.getAccreditationElement(), false);
            this.composeStringExtras("accreditation", element.getAccreditationElement(), false);
        }
        if (element.hasOther_details()) {
            if (this.anyHasValue(element.getOther_detailsList())) {
                this.openArray("other_details");
                for (StringType e : element.getOther_detailsList()) {
                    this.composeStringCore(null, e, e != element.getOther_detailsList().get(element.getOther_detailsList().size() - 1));
                }
                this.closeArray();
            }
            if (this.anyHasExtras(element.getOther_detailsList())) {
                this.openArray("_other_details");
                for (StringType e : element.getOther_detailsList()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
    }

    protected void composeTranslatedString(String name, TranslatedString element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeTranslatedStringProperties(element);
            this.close();
        }
    }

    protected void composeTranslatedStringProperties(TranslatedString element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasLanguageElement()) {
            this.composeCodeCore("language", element.getLanguageElement(), false);
            this.composeCodeExtras("language", element.getLanguageElement(), false);
        }
        if (element.hasValueElement()) {
            this.composeStringCore("value", element.getValueElement(), false);
            this.composeStringExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeUUID(String name, UUID element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeUUIDProperties(element);
            this.close();
        }
    }

    protected void composeUUIDProperties(UUID element) throws IOException {
        this.composeUIDProperties(element);
    }

    protected void composeVERSION_TREE_ID(String name, VERSION_TREE_ID element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeVERSION_TREE_IDProperties(element);
            this.close();
        }
    }

    protected void composeVERSION_TREE_IDProperties(VERSION_TREE_ID element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasValueElement()) {
            this.composeStringCore("value", element.getValueElement(), false);
            this.composeStringExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeVERSIONED_COMPOSITION(String name, VERSIONED_COMPOSITION element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeVERSIONED_COMPOSITIONProperties(element);
            this.close();
        }
    }

    protected void composeVERSIONED_COMPOSITIONProperties(VERSIONED_COMPOSITION element) throws IOException {
        this.composeVERSIONED_OBJECTProperties(element);
    }

    protected void composeVERSIONED_EHR_ACCESS(String name, VERSIONED_EHR_ACCESS element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeVERSIONED_EHR_ACCESSProperties(element);
            this.close();
        }
    }

    protected void composeVERSIONED_EHR_ACCESSProperties(VERSIONED_EHR_ACCESS element) throws IOException {
        this.composeVERSIONED_OBJECTProperties(element);
    }

    protected void composeVERSIONED_EHR_STATUS(String name, VERSIONED_EHR_STATUS element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeVERSIONED_EHR_STATUSProperties(element);
            this.close();
        }
    }

    protected void composeVERSIONED_EHR_STATUSProperties(VERSIONED_EHR_STATUS element) throws IOException {
        this.composeVERSIONED_OBJECTProperties(element);
    }

    protected void composeVERSIONED_FOLDER(String name, VERSIONED_FOLDER element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeVERSIONED_FOLDERProperties(element);
            this.close();
        }
    }

    protected void composeVERSIONED_FOLDERProperties(VERSIONED_FOLDER element) throws IOException {
        this.composeVERSIONED_OBJECTProperties(element);
    }

    protected void composeVERSIONED_OBJECT(String name, VERSIONED_OBJECT element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeVERSIONED_OBJECTProperties(element);
            this.close();
        }
    }

    protected void composeVERSIONED_OBJECTProperties(VERSIONED_OBJECT element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasUid()) {
            this.composeHIER_OBJECT_ID("uid", element.getUid());
        }
        if (element.hasOwner_id()) {
            this.composeOBJECT_REF("owner_id", element.getOwner_id());
        }
        if (element.hasTime_created()) {
            this.composeDV_DATE_TIME("time_created", element.getTime_created());
        }
    }

    protected void composeVERSIONED_PARTY(String name, VERSIONED_PARTY element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeVERSIONED_PARTYProperties(element);
            this.close();
        }
    }

    protected void composeVERSIONED_PARTYProperties(VERSIONED_PARTY element) throws IOException {
        this.composeVERSIONED_OBJECTProperties(element);
    }

    protected void composeWebTemplate(String name, WebTemplate element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeWebTemplateProperties(element);
            this.close();
        }
    }

    protected void composeWebTemplateProperties(WebTemplate element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasTemplateIdElement()) {
            this.composeStringCore("templateId", element.getTemplateIdElement(), false);
            this.composeStringExtras("templateId", element.getTemplateIdElement(), false);
        }
        if (element.hasVersionElement()) {
            this.composeStringCore("version", element.getVersionElement(), false);
            this.composeStringExtras("version", element.getVersionElement(), false);
        }
        if (element.hasSemverElement()) {
            this.composeStringCore("semver", element.getSemverElement(), false);
            this.composeStringExtras("semver", element.getSemverElement(), false);
        }
        if (element.hasDefaultLanguageElement()) {
            this.composeStringCore("defaultLanguage", element.getDefaultLanguageElement(), false);
            this.composeStringExtras("defaultLanguage", element.getDefaultLanguageElement(), false);
        }
        if (element.hasLanguages()) {
            if (this.anyHasValue(element.getLanguagesList())) {
                this.openArray("languages");
                for (StringType e : element.getLanguagesList()) {
                    this.composeStringCore(null, e, e != element.getLanguagesList().get(element.getLanguagesList().size() - 1));
                }
                this.closeArray();
            }
            if (this.anyHasExtras(element.getLanguagesList())) {
                this.openArray("_languages");
                for (StringType e : element.getLanguagesList()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasTree()) {
            this.composeWebTemplateItem("tree", element.getTree());
        }
    }

    protected void composeWebTemplateInput(String name, WebTemplateInput element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeWebTemplateInputProperties(element);
            this.close();
        }
    }

    protected void composeWebTemplateInputProperties(WebTemplateInput element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasSuffixElement()) {
            this.composeStringCore("suffix", element.getSuffixElement(), false);
            this.composeStringExtras("suffix", element.getSuffixElement(), false);
        }
        if (element.hasTypeElement()) {
            this.composeCodeCore("type", element.getTypeElement(), false);
            this.composeCodeExtras("type", element.getTypeElement(), false);
        }
        if (element.hasDefaultValue()) {
            this.composeNativePrimitive("defaultValue", element.getDefaultValue());
        }
        if (element.hasTerminologyElement()) {
            this.composeCodeCore("terminology", element.getTerminologyElement(), false);
            this.composeCodeExtras("terminology", element.getTerminologyElement(), false);
        }
        if (element.hasValidation()) {
            this.composeWebTemplateInputValidation("validation", element.getValidation());
        }
        if (element.hasList()) {
            this.openArray("list");
            for (WebTemplateInputListItem e : element.getListList()) {
                this.composeWebTemplateInputListItem(null, e);
            }
            this.closeArray();
        }
        if (element.hasListOpenElement()) {
            this.composeBooleanCore("listOpen", element.getListOpenElement(), false);
            this.composeBooleanExtras("listOpen", element.getListOpenElement(), false);
        }
    }

    protected void composeWebTemplateInputListItem(String name, WebTemplateInputListItem element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeWebTemplateInputListItemProperties(element);
            this.close();
        }
    }

    protected void composeWebTemplateInputListItemProperties(WebTemplateInputListItem element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasValueElement()) {
            this.composeCodeCore("value", element.getValueElement(), false);
            this.composeCodeExtras("value", element.getValueElement(), false);
        }
        if (element.hasLabelElement()) {
            this.composeStringCore("label", element.getLabelElement(), false);
            this.composeStringExtras("label", element.getLabelElement(), false);
        }
        if (element.hasOrdinalElement()) {
            this.composeStringCore("ordinal", element.getOrdinalElement(), false);
            this.composeStringExtras("ordinal", element.getOrdinalElement(), false);
        }
        if (element.hasLocalizedLabels()) {
            this.openArray("localizedLabels");
            for (TranslatedString translatedString : element.getLocalizedLabelsList()) {
                this.composeTranslatedString(null, translatedString);
            }
            this.closeArray();
        }
        if (element.hasLocalizedDescriptions()) {
            this.openArray("localizedDescriptions");
            for (TranslatedString translatedString : element.getLocalizedDescriptionsList()) {
                this.composeTranslatedString(null, translatedString);
            }
            this.closeArray();
        }
        if (element.hasCurrentStatesElement()) {
            this.composeStringCore("currentStates", element.getCurrentStatesElement(), false);
            this.composeStringExtras("currentStates", element.getCurrentStatesElement(), false);
        }
        if (element.hasRangeElement()) {
            this.composeStringCore("range", element.getRangeElement(), false);
            this.composeStringExtras("range", element.getRangeElement(), false);
        }
        if (element.hasPrecisionElement()) {
            this.composeStringCore("precision", element.getPrecisionElement(), false);
            this.composeStringExtras("precision", element.getPrecisionElement(), false);
        }
        if (element.hasTermBindings()) {
            this.openArray("termBindings");
            for (WebTemplateTermBinding webTemplateTermBinding : element.getTermBindingsList()) {
                this.composeWebTemplateTermBinding(null, webTemplateTermBinding);
            }
            this.closeArray();
        }
    }

    protected void composeWebTemplateInputValidation(String name, WebTemplateInputValidation element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeWebTemplateInputValidationProperties(element);
            this.close();
        }
    }

    protected void composeWebTemplateInputValidationProperties(WebTemplateInputValidation element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasRange()) {
            this.composeWebTemplateInputValidationRange("range", element.getRange());
        }
        if (element.hasPrecision()) {
            this.composeWebTemplateInputValidationRange("precision", element.getPrecision());
        }
    }

    protected void composeWebTemplateInputValidationRange(String name, WebTemplateInputValidationRange element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeWebTemplateInputValidationRangeProperties(element);
            this.close();
        }
    }

    protected void composeWebTemplateInputValidationRangeProperties(WebTemplateInputValidationRange element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasMinOpElement()) {
            this.composeCodeCore("minOp", element.getMinOpElement(), false);
            this.composeCodeExtras("minOp", element.getMinOpElement(), false);
        }
        if (element.hasMinElement()) {
            this.composeDecimalCore("min", element.getMinElement(), false);
            this.composeDecimalExtras("min", element.getMinElement(), false);
        }
        if (element.hasMaxOpElement()) {
            this.composeCodeCore("maxOp", element.getMaxOpElement(), false);
            this.composeCodeExtras("maxOp", element.getMaxOpElement(), false);
        }
        if (element.hasMaxElement()) {
            this.composeDecimalCore("max", element.getMaxElement(), false);
            this.composeDecimalExtras("max", element.getMaxElement(), false);
        }
    }

    protected void composeWebTemplateItem(String name, WebTemplateItem element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeWebTemplateItemProperties(element);
            this.close();
        }
    }

    protected void composeWebTemplateItemProperties(WebTemplateItem element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasIdElement()) {
            this.composeStringCore("id", element.getIdElement(), false);
            this.composeStringExtras("id", element.getIdElement(), false);
        }
        if (element.hasDepthElement()) {
            this.composeIntegerCore("depth", element.getDepthElement(), false);
            this.composeIntegerExtras("depth", element.getDepthElement(), false);
        }
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasLocalizedNameElement()) {
            this.composeStringCore("localizedName", element.getLocalizedNameElement(), false);
            this.composeStringExtras("localizedName", element.getLocalizedNameElement(), false);
        }
        if (element.hasRmTypeElement()) {
            this.composeCodeCore("rmType", element.getRmTypeElement(), false);
            this.composeCodeExtras("rmType", element.getRmTypeElement(), false);
        }
        if (element.hasNodeIdElement()) {
            this.composeStringCore("nodeId", element.getNodeIdElement(), false);
            this.composeStringExtras("nodeId", element.getNodeIdElement(), false);
        }
        if (element.hasMinElement()) {
            this.composeStringCore("min", element.getMinElement(), false);
            this.composeStringExtras("min", element.getMinElement(), false);
        }
        if (element.hasMaxElement()) {
            this.composeStringCore("max", element.getMaxElement(), false);
            this.composeStringExtras("max", element.getMaxElement(), false);
        }
        if (element.hasDependsOnElement()) {
            this.composeStringCore("dependsOn", element.getDependsOnElement(), false);
            this.composeStringExtras("dependsOn", element.getDependsOnElement(), false);
        }
        if (element.hasLocalizedNames()) {
            this.openArray("localizedNames");
            for (TranslatedString translatedString : element.getLocalizedNamesList()) {
                this.composeTranslatedString(null, translatedString);
            }
            this.closeArray();
        }
        if (element.hasLocalizedDescriptions()) {
            this.openArray("localizedDescriptions");
            for (TranslatedString translatedString : element.getLocalizedDescriptionsList()) {
                this.composeTranslatedString(null, translatedString);
            }
            this.closeArray();
        }
        if (element.hasAnnotations()) {
            this.composeAnnotations("annotations", element.getAnnotations());
        }
        if (element.hasArchetype_idElement()) {
            this.composeStringCore("archetype_id", element.getArchetype_idElement(), false);
            this.composeStringExtras("archetype_id", element.getArchetype_idElement(), false);
        }
        if (element.hasAqlPathElement()) {
            this.composeStringCore("aqlPath", element.getAqlPathElement(), false);
            this.composeStringExtras("aqlPath", element.getAqlPathElement(), false);
        }
        if (element.hasCustodian_namespaceElement()) {
            this.composeStringCore("custodian_namespace", element.getCustodian_namespaceElement(), false);
            this.composeStringExtras("custodian_namespace", element.getCustodian_namespaceElement(), false);
        }
        if (element.hasCustodian_organisationElement()) {
            this.composeStringCore("custodian_organisation", element.getCustodian_organisationElement(), false);
            this.composeStringExtras("custodian_organisation", element.getCustodian_organisationElement(), false);
        }
        if (element.hasLifecycleStateElement()) {
            this.composeCodeCore("lifecycleState", element.getLifecycleStateElement(), false);
            this.composeCodeExtras("lifecycleState", element.getLifecycleStateElement(), false);
        }
        if (element.hasOriginal_namespaceElement()) {
            this.composeStringCore("original_namespace", element.getOriginal_namespaceElement(), false);
            this.composeStringExtras("original_namespace", element.getOriginal_namespaceElement(), false);
        }
        if (element.hasOriginal_publisherElement()) {
            this.composeStringCore("original_publisher", element.getOriginal_publisherElement(), false);
            this.composeStringExtras("original_publisher", element.getOriginal_publisherElement(), false);
        }
        if (element.hasProportionTypesElement()) {
            this.composeCodeCore("proportionTypes", element.getProportionTypesElement(), false);
            this.composeCodeExtras("proportionTypes", element.getProportionTypesElement(), false);
        }
        if (element.hasRevisionElement()) {
            this.composeStringCore("revision", element.getRevisionElement(), false);
            this.composeStringExtras("revision", element.getRevisionElement(), false);
        }
        if (element.hasInContextElement()) {
            this.composeBooleanCore("inContext", element.getInContextElement(), false);
            this.composeBooleanExtras("inContext", element.getInContextElement(), false);
        }
        if (element.hasInputs()) {
            this.openArray("inputs");
            for (WebTemplateInput webTemplateInput : element.getInputsList()) {
                this.composeWebTemplateInput(null, webTemplateInput);
            }
            this.closeArray();
        }
        if (element.hasTermBindings()) {
            this.openArray("termBindings");
            for (WebTemplateTermBinding webTemplateTermBinding : element.getTermBindingsList()) {
                this.composeWebTemplateTermBinding(null, webTemplateTermBinding);
            }
            this.closeArray();
        }
        if (element.hasChildren()) {
            this.openArray("children");
            for (WebTemplateItem webTemplateItem : element.getChildrenList()) {
                this.composeWebTemplateItem(null, webTemplateItem);
            }
            this.closeArray();
        }
    }

    protected void composeWebTemplateTermBinding(String name, WebTemplateTermBinding element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeWebTemplateTermBindingProperties(element);
            this.close();
        }
    }

    protected void composeWebTemplateTermBindingProperties(WebTemplateTermBinding element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
        if (element.hasValue()) {
            this.composeWebTemplateTermBindingValue("value", element.getValue());
        }
    }

    protected void composeWebTemplateTermBindingValue(String name, WebTemplateTermBindingValue element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeWebTemplateTermBindingValueProperties(element);
            this.close();
        }
    }

    protected void composeWebTemplateTermBindingValueProperties(WebTemplateTermBindingValue element) throws IOException {
        this.composeBaseProperties(element);
        if (element.hasValueElement()) {
            this.composeStringCore("value", element.getValueElement(), false);
            this.composeStringExtras("value", element.getValueElement(), false);
        }
        if (element.hasTerminologyIdElement()) {
            this.composeStringCore("terminologyId", element.getTerminologyIdElement(), false);
            this.composeStringExtras("terminologyId", element.getTerminologyIdElement(), false);
        }
    }

    @Override
    protected void composeResource(Resource resource) throws IOException {
        if (resource == null) {
            throw new Error("Unhandled resource type " + resource.getClass().getName());
        }
        throw new Error("Unhandled resource type " + resource.getClass().getName());
    }
}

