/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.DV_INTERVAL;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;
import org.hl7.fhir.r5.openehr.LOCATABLE;
import org.hl7.fhir.r5.openehr.PARTY_REF;

@DatatypeDef(name="PARTY_RELATIONSHIP")
public class PARTY_RELATIONSHIP
extends LOCATABLE
implements ICompositeType {
    @Child(name="details", type={ITEM_STRUCTURE.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The detailed description of the relationship", formalDefinition="The detailed description of the relationship.")
    protected ITEM_STRUCTURE details;
    @Child(name="target", type={PARTY_REF.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Target of relationship", formalDefinition="Target of relationship.")
    protected PARTY_REF target;
    @Child(name="time_validity", type={DV_INTERVAL.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Valid time interval for this relationship", formalDefinition="Valid time interval for this relationship.")
    protected DV_INTERVAL time_validity;
    @Child(name="source", type={PARTY_REF.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Source of relationship", formalDefinition="Source of relationship.")
    protected PARTY_REF source;
    private static final long serialVersionUID = -1906999521L;

    public PARTY_RELATIONSHIP() {
    }

    public PARTY_RELATIONSHIP(PARTY_REF target, PARTY_REF source) {
        this.setTarget(target);
        this.setSource(source);
    }

    public ITEM_STRUCTURE getDetails() {
        return this.details;
    }

    public boolean hasDetails() {
        return this.details != null && !this.details.isEmpty();
    }

    public PARTY_RELATIONSHIP setDetails(ITEM_STRUCTURE value) {
        this.details = value;
        return this;
    }

    public PARTY_REF getTarget() {
        if (this.target == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PARTY_RELATIONSHIP.target");
            }
            if (Configuration.doAutoCreate()) {
                this.target = new PARTY_REF();
            }
        }
        return this.target;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public PARTY_RELATIONSHIP setTarget(PARTY_REF value) {
        this.target = value;
        return this;
    }

    public DV_INTERVAL getTime_validity() {
        if (this.time_validity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PARTY_RELATIONSHIP.time_validity");
            }
            if (Configuration.doAutoCreate()) {
                this.time_validity = new DV_INTERVAL();
            }
        }
        return this.time_validity;
    }

    public boolean hasTime_validity() {
        return this.time_validity != null && !this.time_validity.isEmpty();
    }

    public PARTY_RELATIONSHIP setTime_validity(DV_INTERVAL value) {
        this.time_validity = value;
        return this;
    }

    public PARTY_REF getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PARTY_RELATIONSHIP.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new PARTY_REF();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public PARTY_RELATIONSHIP setSource(PARTY_REF value) {
        this.source = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("details", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "The detailed description of the relationship.", 0, 1, this.details));
        children.add(new Property("target", "http://openehr.org/fhir/StructureDefinition/PARTY-REF", "Target of relationship.", 0, 1, this.target));
        children.add(new Property("time_validity", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "Valid time interval for this relationship.", 0, 1, this.time_validity));
        children.add(new Property("source", "http://openehr.org/fhir/StructureDefinition/PARTY-REF", "Source of relationship.", 0, 1, this.source));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1557721666: {
                return new Property("details", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "The detailed description of the relationship.", 0, 1, this.details);
            }
            case -880905839: {
                return new Property("target", "http://openehr.org/fhir/StructureDefinition/PARTY-REF", "Target of relationship.", 0, 1, this.target);
            }
            case -1304171420: {
                return new Property("time_validity", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "Valid time interval for this relationship.", 0, 1, this.time_validity);
            }
            case -896505829: {
                return new Property("source", "http://openehr.org/fhir/StructureDefinition/PARTY-REF", "Source of relationship.", 0, 1, this.source);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1557721666: {
                Base[] baseArray;
                if (this.details == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.details;
                }
                return baseArray;
            }
            case -880905839: {
                Base[] baseArray;
                if (this.target == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.target;
                }
                return baseArray;
            }
            case -1304171420: {
                Base[] baseArray;
                if (this.time_validity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.time_validity;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.source;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1557721666: {
                this.details = (ITEM_STRUCTURE)value;
                return value;
            }
            case -880905839: {
                this.target = (PARTY_REF)value;
                return value;
            }
            case -1304171420: {
                this.time_validity = (DV_INTERVAL)value;
                return value;
            }
            case -896505829: {
                this.source = (PARTY_REF)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("details")) {
            this.details = (ITEM_STRUCTURE)value;
        } else if (name.equals("target")) {
            this.target = (PARTY_REF)value;
        } else if (name.equals("time_validity")) {
            this.time_validity = (DV_INTERVAL)value;
        } else if (name.equals("source")) {
            this.source = (PARTY_REF)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1557721666: {
                throw new Error("Unable to make an instance of the abstract property 'details'");
            }
            case -880905839: {
                return this.getTarget();
            }
            case -1304171420: {
                return this.getTime_validity();
            }
            case -896505829: {
                return this.getSource();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1557721666: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
            case -880905839: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-REF"};
            }
            case -1304171420: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-INTERVAL"};
            }
            case -896505829: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-REF"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("details")) {
            throw new FHIRException("Cannot call addChild on an abstract type PARTY_RELATIONSHIP.details");
        }
        if (name.equals("target")) {
            this.target = new PARTY_REF();
            return this.target;
        }
        if (name.equals("time_validity")) {
            this.time_validity = new DV_INTERVAL();
            return this.time_validity;
        }
        if (name.equals("source")) {
            this.source = new PARTY_REF();
            return this.source;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PARTY_RELATIONSHIP";
    }

    @Override
    public PARTY_RELATIONSHIP copy() {
        PARTY_RELATIONSHIP dst = new PARTY_RELATIONSHIP();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(PARTY_RELATIONSHIP dst) {
        super.copyValues(dst);
        dst.details = this.details == null ? null : this.details.copy();
        dst.target = this.target == null ? null : this.target.copy();
        dst.time_validity = this.time_validity == null ? null : this.time_validity.copy();
        dst.source = this.source == null ? null : this.source.copy();
    }

    protected PARTY_RELATIONSHIP typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PARTY_RELATIONSHIP)) {
            return false;
        }
        PARTY_RELATIONSHIP o = (PARTY_RELATIONSHIP)other_;
        return PARTY_RELATIONSHIP.compareDeep(this.details, o.details, true) && PARTY_RELATIONSHIP.compareDeep(this.target, o.target, true) && PARTY_RELATIONSHIP.compareDeep(this.time_validity, o.time_validity, true) && PARTY_RELATIONSHIP.compareDeep(this.source, o.source, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PARTY_RELATIONSHIP)) {
            return false;
        }
        PARTY_RELATIONSHIP o = (PARTY_RELATIONSHIP)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.details, this.target, this.time_validity, this.source});
    }
}

