/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.WebTemplateItem;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="WebTemplate")
public class WebTemplate
extends LogicalBase
implements ICompositeType {
    @Child(name="templateId", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Operational template ID", formalDefinition="")
    protected StringType templateId;
    @Child(name="version", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Web template structure version", formalDefinition="")
    protected StringType version;
    @Child(name="semver", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The semantic version number of the openEHR template", formalDefinition="")
    protected StringType semver;
    @Child(name="defaultLanguage", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Default labels for fields will be in this language", formalDefinition="")
    protected StringType defaultLanguage;
    @Child(name="languages", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Array of additional languages. Labels for fields and coded texts will also be available in these additional languages, provided that the operational template has them", formalDefinition="")
    protected List<StringType> languagesList;
    @Child(name="tree", type={WebTemplateItem.class}, order=5, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Hierarchical structure of nodes each one potentially having further children", formalDefinition="")
    protected WebTemplateItem tree;
    private static final long serialVersionUID = 1714233507L;

    public WebTemplate() {
    }

    public WebTemplate(String templateId, String version, String defaultLanguage, WebTemplateItem tree) {
        this.setTemplateId(templateId);
        this.setVersion(version);
        this.setDefaultLanguage(defaultLanguage);
        this.setTree(tree);
    }

    public StringType getTemplateIdElement() {
        if (this.templateId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplate.templateId");
            }
            if (Configuration.doAutoCreate()) {
                this.templateId = new StringType();
            }
        }
        return this.templateId;
    }

    public boolean hasTemplateIdElement() {
        return this.templateId != null && !this.templateId.isEmpty();
    }

    public boolean hasTemplateId() {
        return this.templateId != null && !this.templateId.isEmpty();
    }

    public WebTemplate setTemplateIdElement(StringType value) {
        this.templateId = value;
        return this;
    }

    public String getTemplateId() {
        return this.templateId == null ? null : (String)this.templateId.getValue();
    }

    public WebTemplate setTemplateId(String value) {
        if (this.templateId == null) {
            this.templateId = new StringType();
        }
        this.templateId.setValue(value);
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplate.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public WebTemplate setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public WebTemplate setVersion(String value) {
        if (this.version == null) {
            this.version = new StringType();
        }
        this.version.setValue(value);
        return this;
    }

    public StringType getSemverElement() {
        if (this.semver == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplate.semver");
            }
            if (Configuration.doAutoCreate()) {
                this.semver = new StringType();
            }
        }
        return this.semver;
    }

    public boolean hasSemverElement() {
        return this.semver != null && !this.semver.isEmpty();
    }

    public boolean hasSemver() {
        return this.semver != null && !this.semver.isEmpty();
    }

    public WebTemplate setSemverElement(StringType value) {
        this.semver = value;
        return this;
    }

    public String getSemver() {
        return this.semver == null ? null : (String)this.semver.getValue();
    }

    public WebTemplate setSemver(String value) {
        if (Utilities.noString((String)value)) {
            this.semver = null;
        } else {
            if (this.semver == null) {
                this.semver = new StringType();
            }
            this.semver.setValue(value);
        }
        return this;
    }

    public StringType getDefaultLanguageElement() {
        if (this.defaultLanguage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplate.defaultLanguage");
            }
            if (Configuration.doAutoCreate()) {
                this.defaultLanguage = new StringType();
            }
        }
        return this.defaultLanguage;
    }

    public boolean hasDefaultLanguageElement() {
        return this.defaultLanguage != null && !this.defaultLanguage.isEmpty();
    }

    public boolean hasDefaultLanguage() {
        return this.defaultLanguage != null && !this.defaultLanguage.isEmpty();
    }

    public WebTemplate setDefaultLanguageElement(StringType value) {
        this.defaultLanguage = value;
        return this;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage == null ? null : (String)this.defaultLanguage.getValue();
    }

    public WebTemplate setDefaultLanguage(String value) {
        if (this.defaultLanguage == null) {
            this.defaultLanguage = new StringType();
        }
        this.defaultLanguage.setValue(value);
        return this;
    }

    public List<StringType> getLanguagesList() {
        if (this.languagesList == null) {
            this.languagesList = new ArrayList<StringType>();
        }
        return this.languagesList;
    }

    public WebTemplate setLanguagesList(List<StringType> theLanguages) {
        this.languagesList = theLanguages;
        return this;
    }

    public boolean hasLanguages() {
        if (this.languagesList == null) {
            return false;
        }
        for (StringType item : this.languagesList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addLanguagesElement() {
        StringType t = new StringType();
        if (this.languagesList == null) {
            this.languagesList = new ArrayList<StringType>();
        }
        this.languagesList.add(t);
        return t;
    }

    public WebTemplate addLanguages(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.languagesList == null) {
            this.languagesList = new ArrayList<StringType>();
        }
        this.languagesList.add(t);
        return this;
    }

    public boolean hasLanguages(String value) {
        if (this.languagesList == null) {
            return false;
        }
        for (StringType v : this.languagesList) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public WebTemplateItem getTree() {
        if (this.tree == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplate.tree");
            }
            if (Configuration.doAutoCreate()) {
                this.tree = new WebTemplateItem();
            }
        }
        return this.tree;
    }

    public boolean hasTree() {
        return this.tree != null && !this.tree.isEmpty();
    }

    public WebTemplate setTree(WebTemplateItem value) {
        this.tree = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("templateId", "string", "", 0, 1, this.templateId));
        children.add(new Property("version", "string", "", 0, 1, this.version));
        children.add(new Property("semver", "string", "", 0, 1, this.semver));
        children.add(new Property("defaultLanguage", "string", "", 0, 1, this.defaultLanguage));
        children.add(new Property("languages", "string", "", 0, Integer.MAX_VALUE, this.languagesList));
        children.add(new Property("tree", "http://openehr.org/fhir/StructureDefinition/WebTemplateItem", "", 0, 1, this.tree));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1304010549: {
                return new Property("templateId", "string", "", 0, 1, this.templateId);
            }
            case 351608024: {
                return new Property("version", "string", "", 0, 1, this.version);
            }
            case -905975448: {
                return new Property("semver", "string", "", 0, 1, this.semver);
            }
            case 384498873: {
                return new Property("defaultLanguage", "string", "", 0, 1, this.defaultLanguage);
            }
            case 1518327835: {
                return new Property("languages", "string", "", 0, Integer.MAX_VALUE, this.languagesList);
            }
            case 3568542: {
                return new Property("tree", "http://openehr.org/fhir/StructureDefinition/WebTemplateItem", "", 0, 1, this.tree);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1304010549: {
                Base[] baseArray;
                if (this.templateId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.templateId;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case -905975448: {
                Base[] baseArray;
                if (this.semver == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.semver;
                }
                return baseArray;
            }
            case 384498873: {
                Base[] baseArray;
                if (this.defaultLanguage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.defaultLanguage;
                }
                return baseArray;
            }
            case 1518327835: {
                return this.languagesList == null ? new Base[]{} : this.languagesList.toArray(new Base[this.languagesList.size()]);
            }
            case 3568542: {
                Base[] baseArray;
                if (this.tree == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.tree;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1304010549: {
                this.templateId = TypeConvertor.castToString(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case -905975448: {
                this.semver = TypeConvertor.castToString(value);
                return value;
            }
            case 384498873: {
                this.defaultLanguage = TypeConvertor.castToString(value);
                return value;
            }
            case 1518327835: {
                this.getLanguagesList().add(TypeConvertor.castToString(value));
                return value;
            }
            case 3568542: {
                this.tree = (WebTemplateItem)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("templateId")) {
            this.templateId = TypeConvertor.castToString(value);
        } else if (name.equals("version")) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("semver")) {
            this.semver = TypeConvertor.castToString(value);
        } else if (name.equals("defaultLanguage")) {
            this.defaultLanguage = TypeConvertor.castToString(value);
        } else if (name.equals("languages")) {
            this.getLanguagesList().add(TypeConvertor.castToString(value));
        } else if (name.equals("tree")) {
            this.tree = (WebTemplateItem)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1304010549: {
                return this.getTemplateIdElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -905975448: {
                return this.getSemverElement();
            }
            case 384498873: {
                return this.getDefaultLanguageElement();
            }
            case 1518327835: {
                return this.addLanguagesElement();
            }
            case 3568542: {
                return this.getTree();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1304010549: {
                return new String[]{"string"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case -905975448: {
                return new String[]{"string"};
            }
            case 384498873: {
                return new String[]{"string"};
            }
            case 1518327835: {
                return new String[]{"string"};
            }
            case 3568542: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/WebTemplateItem"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("templateId")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplate.templateId");
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplate.version");
        }
        if (name.equals("semver")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplate.semver");
        }
        if (name.equals("defaultLanguage")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplate.defaultLanguage");
        }
        if (name.equals("languages")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplate.languages");
        }
        if (name.equals("tree")) {
            this.tree = new WebTemplateItem();
            return this.tree;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "WebTemplate";
    }

    @Override
    public WebTemplate copy() {
        WebTemplate dst = new WebTemplate();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(WebTemplate dst) {
        super.copyValues(dst);
        dst.templateId = this.templateId == null ? null : this.templateId.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.semver = this.semver == null ? null : this.semver.copy();
        StringType stringType = dst.defaultLanguage = this.defaultLanguage == null ? null : this.defaultLanguage.copy();
        if (this.languagesList != null) {
            dst.languagesList = new ArrayList<StringType>();
            for (StringType i : this.languagesList) {
                dst.languagesList.add(i.copy());
            }
        }
        dst.tree = this.tree == null ? null : this.tree.copy();
    }

    protected WebTemplate typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplate)) {
            return false;
        }
        WebTemplate o = (WebTemplate)other_;
        return WebTemplate.compareDeep(this.templateId, o.templateId, true) && WebTemplate.compareDeep(this.version, o.version, true) && WebTemplate.compareDeep(this.semver, o.semver, true) && WebTemplate.compareDeep(this.defaultLanguage, o.defaultLanguage, true) && WebTemplate.compareDeep(this.languagesList, o.languagesList, true) && WebTemplate.compareDeep(this.tree, o.tree, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplate)) {
            return false;
        }
        WebTemplate o = (WebTemplate)other_;
        return WebTemplate.compareValues(this.templateId, o.templateId, true) && WebTemplate.compareValues(this.version, o.version, true) && WebTemplate.compareValues(this.semver, o.semver, true) && WebTemplate.compareValues(this.defaultLanguage, o.defaultLanguage, true) && WebTemplate.compareValues(this.languagesList, o.languagesList, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.templateId, this.version, this.semver, this.defaultLanguage, this.languagesList, this.tree});
    }
}

