/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;

@DatatypeDef(name="WebTemplateTermBindingValue")
public class WebTemplateTermBindingValue
extends LogicalBase
implements ICompositeType {
    @Child(name="value", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType value;
    @Child(name="terminologyId", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType terminologyId;
    private static final long serialVersionUID = 1023496547L;

    public WebTemplateTermBindingValue() {
    }

    public WebTemplateTermBindingValue(String value, String terminologyId) {
        this.setValue(value);
        this.setTerminologyId(terminologyId);
    }

    public StringType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateTermBindingValue.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new StringType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public WebTemplateTermBindingValue setValueElement(StringType value) {
        this.value = value;
        return this;
    }

    public String getValue() {
        return this.value == null ? null : (String)this.value.getValue();
    }

    public WebTemplateTermBindingValue setValue(String value) {
        if (this.value == null) {
            this.value = new StringType();
        }
        this.value.setValue(value);
        return this;
    }

    public StringType getTerminologyIdElement() {
        if (this.terminologyId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateTermBindingValue.terminologyId");
            }
            if (Configuration.doAutoCreate()) {
                this.terminologyId = new StringType();
            }
        }
        return this.terminologyId;
    }

    public boolean hasTerminologyIdElement() {
        return this.terminologyId != null && !this.terminologyId.isEmpty();
    }

    public boolean hasTerminologyId() {
        return this.terminologyId != null && !this.terminologyId.isEmpty();
    }

    public WebTemplateTermBindingValue setTerminologyIdElement(StringType value) {
        this.terminologyId = value;
        return this;
    }

    public String getTerminologyId() {
        return this.terminologyId == null ? null : (String)this.terminologyId.getValue();
    }

    public WebTemplateTermBindingValue setTerminologyId(String value) {
        if (this.terminologyId == null) {
            this.terminologyId = new StringType();
        }
        this.terminologyId.setValue(value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("value", "string", "", 0, 1, this.value));
        children.add(new Property("terminologyId", "string", "", 0, 1, this.terminologyId));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 111972721: {
                return new Property("value", "string", "", 0, 1, this.value);
            }
            case -1898927314: {
                return new Property("terminologyId", "string", "", 0, 1, this.terminologyId);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.value;
                }
                return baseArray;
            }
            case -1898927314: {
                Base[] baseArray;
                if (this.terminologyId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.terminologyId;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 111972721: {
                this.value = TypeConvertor.castToString(value);
                return value;
            }
            case -1898927314: {
                this.terminologyId = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("value")) {
            this.value = TypeConvertor.castToString(value);
        } else if (name.equals("terminologyId")) {
            this.terminologyId = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return this.getValueElement();
            }
            case -1898927314: {
                return this.getTerminologyIdElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return new String[]{"string"};
            }
            case -1898927314: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateTermBindingValue.value");
        }
        if (name.equals("terminologyId")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateTermBindingValue.terminologyId");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "WebTemplateTermBindingValue";
    }

    @Override
    public WebTemplateTermBindingValue copy() {
        WebTemplateTermBindingValue dst = new WebTemplateTermBindingValue();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(WebTemplateTermBindingValue dst) {
        super.copyValues(dst);
        dst.value = this.value == null ? null : this.value.copy();
        dst.terminologyId = this.terminologyId == null ? null : this.terminologyId.copy();
    }

    protected WebTemplateTermBindingValue typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplateTermBindingValue)) {
            return false;
        }
        WebTemplateTermBindingValue o = (WebTemplateTermBindingValue)other_;
        return WebTemplateTermBindingValue.compareDeep(this.value, o.value, true) && WebTemplateTermBindingValue.compareDeep(this.terminologyId, o.terminologyId, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplateTermBindingValue)) {
            return false;
        }
        WebTemplateTermBindingValue o = (WebTemplateTermBindingValue)other_;
        return WebTemplateTermBindingValue.compareValues(this.value, o.value, true) && WebTemplateTermBindingValue.compareValues(this.terminologyId, o.terminologyId, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value, this.terminologyId});
    }
}

