/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.profilemodel;

import java.util.List;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.profilemodel.PEDefinition;
import org.hl7.fhir.r5.profilemodel.PEType;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;

public class PEDefinitionElement
extends PEDefinition {
    public PEDefinitionElement(PEBuilder builder, StructureDefinition profile, ElementDefinition definition, String ppath) {
        super(builder, definition.getName(), profile, definition, ppath);
    }

    public PEDefinitionElement(PEBuilder builder, String name, StructureDefinition profile, ElementDefinition definition, String ppath) {
        super(builder, name, profile, definition, ppath);
    }

    @Override
    public void listTypes(List<PEType> types) {
        for (ElementDefinition.TypeRefComponent t : this.definition.getType()) {
            if (t.hasProfile()) {
                for (CanonicalType u : t.getProfile()) {
                    types.add(this.builder.makeType(t, u));
                }
                continue;
            }
            if (t.getCode().startsWith("http://hl7.org/fhirpath/")) continue;
            types.add(new PEType(t.getWorkingCode(), t.getWorkingCode(), "http://hl7.org/fhir/StructureDefinition/" + t.getWorkingCode()));
        }
    }

    @Override
    protected void makeChildren(String typeUrl, List<PEDefinition> children, boolean allFixed) {
        children.addAll(this.builder.listChildren(allFixed, this, this.profile, this.definition, typeUrl, new String[0]));
    }

    @Override
    public String fhirpath() {
        String base = this.definition.getName().replace("[x]", "");
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(" or ");
        if (this.getSlices() != null) {
            for (PEDefinition slice : this.getSlices()) {
                b.append("(" + this.builder.makeSliceExpression(slice.profile, this.definition.getSlicing(), slice.definition()) + ")");
            }
        } else if (this.definition.hasSlicing()) {
            List<PEDefinition> slices = this.builder.listSlices(this.profile, this.definition, this);
            for (PEDefinition slice : slices) {
                b.append("(" + this.builder.makeSliceExpression(this.profile, this.definition.getSlicing(), slice.definition()) + ")");
            }
        }
        if (b.count() == 0) {
            return base;
        }
        return base + ".where((" + b.toString() + ").not())";
    }
}

