/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.renderers.DataRenderer;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public abstract class ResourceRenderer
extends DataRenderer {
    private static final String EXT_NS_URL = "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.url";
    protected XVerExtensionManager xverManager;
    protected boolean multiLangMode;
    protected boolean inner;

    public ResourceRenderer(RenderingContext context) {
        super(context);
    }

    public boolean isMultiLangMode() {
        return this.multiLangMode;
    }

    public ResourceRenderer setMultiLangMode(boolean multiLangMode) {
        this.multiLangMode = multiLangMode;
        return this;
    }

    public boolean renderingUsesValidation() {
        return false;
    }

    public boolean isInner() {
        return this.inner;
    }

    public ResourceRenderer setInner(boolean inner) {
        this.inner = inner;
        return this;
    }

    public XhtmlNode buildNarrative(ResourceWrapper dr) throws FHIRFormatError, DefinitionException, FHIRException, IOException, EOperationOutcome {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        this.buildNarrative(new Renderer.RenderingStatus(), x, dr);
        this.checkForDuplicateIds(x);
        return x;
    }

    private void checkForDuplicateIds(XhtmlNode x) {
        if (this.context.isTrackNarrativeSource()) {
            HashSet<String> ids = new HashSet<String>();
            this.checkForDuplicateIds(ids, x);
        }
    }

    private void checkForDuplicateIds(Set<String> ids, XhtmlNode x) {
        if (x.hasAttribute("id")) {
            String id = x.getAttribute("id");
            if (ids.contains(id)) {
                throw new Error("Duplicate id '" + id + "' on " + x.allText());
            }
            ids.add(id);
        }
        if (x.hasChildren()) {
            for (XhtmlNode c : x.getChildNodes()) {
                this.checkForDuplicateIds(ids, c);
            }
        }
    }

    public void renderResource(ResourceWrapper r) throws IOException, FHIRException, EOperationOutcome {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        Renderer.RenderingStatus status = new Renderer.RenderingStatus();
        this.buildNarrative(status, x, r);
        String an = r.fhirType() + "_" + r.getId();
        if (this.context.isAddName() && !this.hasAnchorName(x, an)) {
            this.injectAnchorName(x, an);
        }
        this.inject(r, x, status.getExtensions() ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
    }

    public XhtmlNode checkNarrative(ResourceWrapper r) throws IOException, FHIRException, EOperationOutcome {
        XhtmlNode x = r.getNarrative();
        String an = r.fhirType() + "_" + r.getId();
        if (this.context.isAddName() && !this.hasAnchorName(x, an)) {
            this.injectAnchorName(x, an);
        }
        return x;
    }

    private void injectAnchorName(XhtmlNode x, String an) {
        XhtmlNode ip = x;
        while (ip.hasChildren() && "div".equals(ip.getChildNodes().get(0).getName())) {
            ip = ip.getChildNodes().get(0);
        }
        ip.addTag(0, "a").setAttribute("name", an).tx(" ");
    }

    protected boolean hasAnchorName(XhtmlNode x, String an) {
        if ("a".equals(x.getName()) && an.equals(x.getAttribute("name"))) {
            return true;
        }
        if (x.hasChildren()) {
            for (XhtmlNode c : x.getChildNodes()) {
                if (!this.hasAnchorName(c, an)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract void buildNarrative(Renderer.RenderingStatus var1, XhtmlNode var2, ResourceWrapper var3) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome;

    public abstract String buildSummary(ResourceWrapper var1) throws UnsupportedEncodingException, IOException;

    public void buildSummary(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        x.tx(this.buildSummary(r));
    }

    public String canonicalTitle(ResourceWrapper r) {
        if (r.has("title")) {
            return r.primitiveValue("title");
        }
        if (r.has("name")) {
            return r.primitiveValue("name");
        }
        if (r.has("id")) {
            return r.primitiveValue("id");
        }
        return "?title?";
    }

    public void describe(XhtmlNode x, ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        x.tx(this.displayDataType(r));
    }

    public void inject(ResourceWrapper r, XhtmlNode x, Narrative.NarrativeStatus status) throws IOException {
        r.setNarrative(x, status.toCode(), this.multiLangMode, this.context.getLocale(), this.context.isPretty());
    }

    public void markLanguage(XhtmlNode x) {
        x.setAttribute("lang", this.context.getLocale().toLanguageTag());
        x.setAttribute("xml:lang", this.context.getLocale().toLanguageTag());
        x.addTag(0, "hr");
        x.addTag(0, "p").b().tx(this.context.getLocale().getDisplayName());
        x.addTag(0, "hr");
    }

    @Override
    protected void renderCanonical(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper type) throws FHIRFormatError, DefinitionException, IOException {
        this.renderCanonical(status, x, Resource.class, type);
    }

    public <T extends Resource> void renderCanonical(Renderer.RenderingStatus status, XhtmlNode x, Class<T> class_, ResourceWrapper canonical) throws UnsupportedEncodingException, IOException {
        if (!this.renderPrimitiveWithNoValue(status, x, canonical)) {
            CanonicalResource target = (CanonicalResource)this.context.getWorker().fetchResource(class_, canonical.primitiveValue(), canonical.getResourceNative());
            if (target != null && target.hasWebPath()) {
                if (canonical.primitiveValue().contains("|")) {
                    x.ah(this.context.prefixLocalHref(target.getWebPath())).tx(target.present() + this.context.formatPhrase("RES_REND_VER", new Object[0]) + target.getVersion() + ")");
                } else {
                    x.ah(this.context.prefixLocalHref(target.getWebPath())).tx(target.present());
                }
                return;
            }
            Resolver.ResourceWithReference rr = this.resolveReference(canonical);
            if (rr == null) {
                x.code(canonical.primitiveValue());
            } else if (rr.getResource() == null) {
                x.ah(this.context.prefixLocalHref(rr.getWebPath())).tx(canonical.primitiveValue());
            } else {
                x.ah(this.context.prefixLocalHref(rr.getWebPath())).tx(RendererFactory.factory(rr.getResource(), this.context.forContained()).buildSummary(rr.getResource()));
            }
        }
    }

    protected String displayCanonical(ResourceWrapper canonical) {
        if (canonical == null || !canonical.hasPrimitiveValue()) {
            return "";
        }
        String url = canonical.primitiveValue();
        Resource target = this.context.getWorker().fetchResource(Resource.class, url, canonical.getResourceNative());
        if (target == null || !(target instanceof CanonicalResource)) {
            return url;
        }
        CanonicalResource cr = (CanonicalResource)target;
        return "->" + cr.present();
    }

    @Override
    protected String displayReference(ResourceWrapper type) {
        if (type == null) {
            return "";
        }
        ResourceWrapper display = null;
        ResourceWrapper actual = null;
        ResourceWrapper id = null;
        if (type.fhirType().equals("CodeableReference")) {
            if (type.has("reference")) {
                type = type.child("reference");
            } else {
                return this.displayCodeableConcept(type.child("concept"));
            }
        }
        if (type.fhirType().equals("Reference")) {
            display = type.child("display");
            actual = type.child("reference");
            id = type.child("identifier");
        } else {
            actual = type;
        }
        if (actual != null && actual.hasPrimitiveValue()) {
            String disp;
            if ("#".equals(actual.primitiveValue())) {
                return "this resource";
            }
            Resolver.ResourceWithReference rr = this.resolveReference(actual);
            if (rr == null) {
                String disp2 = display != null && display.hasPrimitiveValue() ? this.displayDataType(display) : actual.primitiveValue();
                return "->" + disp2;
            }
            try {
                disp = display != null && display.hasPrimitiveValue() ? this.displayDataType(display) : RendererFactory.factory(rr.getResource(), this.context.forContained()).buildSummary(rr.getResource());
            }
            catch (IOException e) {
                disp = e.getMessage();
            }
            return "->" + disp;
        }
        if (display != null) {
            return "->" + String.valueOf(display);
        }
        if (id != null) {
            return "id: " + this.displayIdentifier(id);
        }
        return "?ref?";
    }

    public <T extends Resource> void renderCanonical(Renderer.RenderingStatus status, ResourceWrapper res, XhtmlNode x, Class<T> class_, CanonicalType canonical) throws UnsupportedEncodingException, IOException {
        if (canonical == null || !canonical.hasPrimitiveValue()) {
            return;
        }
        String url = canonical.asStringValue();
        Resource target = this.context.getWorker().fetchResource(Resource.class, url, res.getResourceNative());
        if (target == null || !(target instanceof CanonicalResource)) {
            x.code().tx(url);
        } else {
            CanonicalResource cr = (CanonicalResource)target;
            if (!target.hasWebPath()) {
                if (url.contains("|")) {
                    x.code().tx(cr.getUrl());
                    x.tx(this.context.formatPhrase("RES_REND_VER", new Object[]{cr.getVersion()}));
                    x.tx(" (" + cr.present() + ")");
                } else {
                    x.code().tx(url);
                    x.tx(" (" + cr.present() + ")");
                }
            } else if (url.contains("|")) {
                x.ah(this.context.prefixLocalHref(target.getWebPath())).tx(cr.present() + this.context.formatPhrase("RES_REND_VER", new Object[0]) + cr.getVersion() + ")");
            } else {
                x.ah(this.context.prefixLocalHref(target.getWebPath())).tx(cr.present());
            }
        }
    }

    @Override
    public void renderReference(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper type) throws FHIRFormatError, DefinitionException, IOException {
        if (type == null) {
            return;
        }
        this.xlinkNarrative(x, type);
        ResourceWrapper display = null;
        ResourceWrapper actual = null;
        ResourceWrapper id = null;
        if (type.fhirType().equals("CodeableReference")) {
            if (type.has("reference")) {
                type = type.child("reference");
            } else {
                this.renderCodeableConcept(status, x, type.child("concept"));
                return;
            }
        }
        if (type.fhirType().equals("Reference")) {
            display = type.child("display");
            actual = type.child("reference");
            id = type.child("identifier");
        } else {
            actual = type;
        }
        if (actual != null && actual.hasPrimitiveValue()) {
            Resolver.ResourceWithReference rr = this.resolveReference(actual);
            if (rr == null) {
                String disp;
                String string = disp = display != null && display.hasPrimitiveValue() ? this.displayDataType(display) : actual.primitiveValue();
                if (Utilities.isAbsoluteUrlLinkable((String)actual.primitiveValue()) || this.isLocalReference(actual.primitiveValue()) && !this.context.isUnknownLocalReferencesNotLinks()) {
                    x.ah(this.context.prefixLocalHref(actual.primitiveValue())).tx(disp);
                } else {
                    x.code().tx(disp);
                }
            } else if (rr.getResource() == null) {
                String disp = display != null && display.hasPrimitiveValue() ? this.displayDataType(display) : rr.getUrlReference();
                x.ah(this.context.prefixLocalHref(rr.getWebPath())).tx(disp);
            } else if (rr.getResource() != null) {
                String disp = display != null && display.hasPrimitiveValue() ? this.displayDataType(display) : RendererFactory.factory(rr.getResource(), this.context.forContained()).buildSummary(rr.getResource());
                x.ah(this.context.prefixLocalHref(rr.getWebPath())).tx(disp);
            } else {
                String disp = display != null && display.hasPrimitiveValue() ? this.displayDataType(display) : "?rref2?";
                x.ah(this.context.prefixLocalHref(rr.getWebPath())).tx(disp);
            }
        } else if (display != null && id != null) {
            this.renderDataType(status, x, display);
            x.tx(" (Identifier: ");
            this.renderIdentifier(status, x, id);
            x.tx(")");
        } else if (display != null) {
            this.renderDataType(status, x, display);
        } else if (id != null) {
            x.tx("Identifier: ");
            this.renderIdentifier(status, x, id);
        } else {
            x.tx("?rref?");
        }
        this.checkRenderExtensions(status, x, type);
    }

    private boolean isLocalReference(String url) {
        if (url == null) {
            return false;
        }
        if (url.contains("/_history")) {
            url = url.substring(0, url.indexOf("/_hist"));
        }
        return url.matches("(Account|ActivityDefinition|ActorDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|ArtifactAssessment|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BiologicallyDerivedProductDispense|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|ChargeItem|ChargeItemDefinition|Citation|Claim|ClaimResponse|ClinicalImpression|ClinicalUseDefinition|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceAssociation|DeviceDefinition|DeviceDispense|DeviceMetric|DeviceRequest|DeviceUsage|DiagnosticReport|DocumentReference|Encounter|EncounterHistory|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceReport|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|FormularyItem|GenomicStudy|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingSelection|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|InventoryItem|InventoryReport|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|NutritionProduct|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Parameters|Patient|PaymentNotice|PaymentReconciliation|Permission|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestOrchestration|Requirements|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|SubscriptionStatus|SubscriptionTopic|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestPlan|TestReport|TestScript|Transport|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}");
    }

    public void renderReference(ResourceWrapper res, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Piece> pieces, Reference r, boolean allowLinks) throws UnsupportedEncodingException, IOException {
        String name;
        if (r == null) {
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "null!", null));
            return;
        }
        Resolver.ResourceWithReference tr = null;
        String link = null;
        StringBuilder text = new StringBuilder();
        if (r.hasReferenceElement() && allowLinks) {
            tr = this.resolveReference(res, r.getReference(), true);
            if (!r.getReference().startsWith("#")) {
                if (tr != null && tr.getWebPath() != null) {
                    link = tr.getWebPath();
                } else if (r.getReference().contains("?")) {
                    text.append(this.context.formatPhrase("RES_REND_COND_REF", new Object[0]) + " ");
                } else {
                    link = r.getReference();
                }
            }
        }
        if (tr != null && tr.getWebPath() != null && tr.getWebPath().startsWith("#")) {
            text.append(this.context.formatPhrase("RES_REND_SEE_ON_THIS_PAGE", new Object[0]) + " ");
        }
        String display = r.hasDisplayElement() ? r.getDisplay() : null;
        String string = name = tr != null && tr.getResource() != null ? this.getNameForResource(tr.getResource()) : null;
        if (display == null && (tr == null || tr.getResource() == null)) {
            if (!Utilities.noString((String)r.getReference())) {
                text.append(r.getReference());
            } else if (r.hasIdentifier()) {
                text.append(this.displayIdentifier(this.wrapWC(res, r.getIdentifier())));
            } else {
                text.append("?r-ref?");
            }
        } else if (this.context.isTechnicalMode()) {
            text.append(r.getReference());
            if (display != null) {
                text.append(": " + display);
            }
            if ((tr == null || tr.getWebPath() != null && !tr.getWebPath().startsWith("#")) && name != null) {
                text.append(" \"" + name + "\"");
            }
            if (r.hasExtension("http://hl7.org/fhir/StructureDefinition/targetElement") || r.hasExtension("http://hl7.org/fhir/StructureDefinition/targetPath")) {
                text.append("(");
                for (Extension ex : r.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/targetElement")) {
                    if (!ex.hasValue()) continue;
                    text.append(", ");
                    text.append("#" + ex.getValue().primitiveValue());
                }
                for (Extension ex : r.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/targetPath")) {
                    if (!ex.hasValue()) continue;
                    text.append(", ");
                    text.append("/#" + ex.getValue().primitiveValue());
                }
                text.append(")");
            }
        } else if (display != null) {
            text.append(display);
        } else if (name != null) {
            text.append(name);
        } else {
            text.append(this.context.formatPhrase("RES_REND_DESC", new Object[0]));
        }
        if (tr != null && tr.getWebPath() != null && tr.getWebPath().startsWith("#")) {
            text.append(")");
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, link, text.toString(), null));
    }

    public void renderReference(ResourceWrapper res, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Piece> pieces, ResourceWrapper r, boolean allowLinks) throws UnsupportedEncodingException, IOException {
        String name;
        if (r == null) {
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "null!", null));
            return;
        }
        Resolver.ResourceWithReference trt = null;
        String link = null;
        StringBuilder text = new StringBuilder();
        if (r.has("reference") && allowLinks) {
            trt = this.resolveReference(res, r.primitiveValue("reference"), true);
            if (!r.primitiveValue("reference").startsWith("#")) {
                if (trt != null && trt.getWebPath() != null) {
                    link = trt.getWebPath();
                } else if (r.primitiveValue("reference").contains("?")) {
                    text.append(this.context.formatPhrase("RES_REND_COND_REF", new Object[0]) + " ");
                } else {
                    link = r.primitiveValue("reference");
                }
            }
        }
        if (trt != null && trt.getWebPath() != null && trt.getWebPath().startsWith("#")) {
            text.append(this.context.formatPhrase("RES_REND_SEE_ON_THIS_PAGE", new Object[0]) + " ");
        }
        String display = r.has("display") ? r.primitiveValue("display") : null;
        String string = name = trt != null && trt.getResource() != null ? this.getNameForResource(trt.getResource()) : null;
        if (display == null && (trt == null || trt.getResource() == null)) {
            if (!Utilities.noString((String)r.primitiveValue("reference"))) {
                text.append(r.primitiveValue("reference"));
            } else if (r.has("identifier")) {
                text.append(this.displayIdentifier(r.child("identifier")));
            } else {
                text.append("?r-ref2?");
            }
        } else if (this.context.isTechnicalMode()) {
            text.append(r.primitiveValue("reference"));
            if (display != null) {
                text.append(": " + display);
            }
            if ((trt == null || trt.getWebPath() != null && !trt.getWebPath().startsWith("#")) && name != null) {
                text.append(" \"" + name + "\"");
            }
            if (r.hasExtension("http://hl7.org/fhir/StructureDefinition/targetElement") || r.hasExtension("http://hl7.org/fhir/StructureDefinition/targetPath")) {
                text.append("(");
                for (ResourceWrapper ex : r.extensions("http://hl7.org/fhir/StructureDefinition/targetElement")) {
                    if (!ex.has("value")) continue;
                    text.append(", ");
                    text.append("#" + ex.primitiveValue("value"));
                }
                for (ResourceWrapper ex : r.extensions("http://hl7.org/fhir/StructureDefinition/targetPath")) {
                    if (!ex.has("value")) continue;
                    text.append(", ");
                    text.append("#" + ex.primitiveValue("value"));
                }
                text.append(")");
            }
        } else if (display != null) {
            text.append(display);
        } else if (name != null) {
            text.append(name);
        } else {
            text.append(this.context.formatPhrase("RES_REND_DESC", new Object[0]));
        }
        if (trt != null && trt.getWebPath() != null && trt.getWebPath().startsWith("#")) {
            text.append(")");
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, link, text.toString(), null));
    }

    protected String getNameForResource(ResourceWrapper resource) {
        String n;
        ResourceWrapper name = resource.firstChild("name");
        if (name != null && !name.isEmpty()) {
            if (name.isPrimitive()) {
                return name.primitiveValue();
            }
            if (name.fhirType().equals("HumanName")) {
                String family = name.primitiveValue("family");
                String given = name.firstPrimitiveValue("given");
                return family == null ? given : (given == null ? family : family + " " + given);
            }
            n = name.primitiveValueMN("name", "text", "value");
            if (n != null) {
                return n;
            }
        }
        if ((n = resource.primitiveValue("productName")) == null) {
            throw new Error("What to render for 'name'? Type is " + resource.fhirType());
        }
        return n;
    }

    protected void renderUri(Renderer.RenderingStatus status, ResourceWrapper resource, XhtmlNode x, UriType uri) throws FHIRFormatError, DefinitionException, IOException {
        if (!this.renderPrimitiveWithNoValue(status, x, uri)) {
            String v = uri.primitiveValue();
            if (v.startsWith("mailto:")) {
                x.ah(this.context.prefixLocalHref(v)).addText(v.substring(7));
            } else {
                Resolver.ResourceWithReference rr = this.resolveReference(resource, uri.primitiveValue(), false);
                if (rr != null) {
                    x.ah(rr.getWebPath()).addText(RendererFactory.factory(rr.getResource(), this.context.forContained()).buildSummary(rr.getResource()));
                } else {
                    Resource r = this.context.getContext().fetchResource(Resource.class, v);
                    if (r != null && r.getWebPath() != null) {
                        x.ah(this.context.prefixLocalHref(r.getWebPath())).addText(RendererFactory.factory(r, this.context.forContained()).buildSummary(this.wrap(r)));
                    } else {
                        String url;
                        String string = url = this.context.getResolver() != null ? this.context.getResolver().resolveUri(this.context, v) : null;
                        if (url != null) {
                            x.ah(this.context.prefixLocalHref(url)).addText(v);
                        } else if (Utilities.isAbsoluteUrlLinkable((String)v) && !uri.fhirType().equals("id")) {
                            x.ah(this.context.prefixLocalHref(v)).addText(v);
                        } else {
                            x.addText(v);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void renderUri(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper uri) throws FHIRFormatError, DefinitionException, IOException {
        if (!this.renderPrimitiveWithNoValue(status, x, uri)) {
            Object v = uri.primitiveValue();
            boolean local = false;
            if (this.context.getContextUtilities().isResource((String)v)) {
                v = "http://hl7.org/fhir/StructureDefinition/" + (String)v;
                local = true;
            }
            if (((String)v).startsWith("mailto:")) {
                x.ah((String)v).addText(((String)v).substring(7));
            } else {
                String link = this.getLinkForCode((String)v, null, null);
                if (link != null) {
                    x.ah(this.context.prefixLocalHref(link)).addText((String)v);
                } else {
                    Resolver.ResourceWithReference rr;
                    Resolver.ResourceWithReference resourceWithReference = rr = local ? this.resolveReference(uri.resource(), (String)v, true) : this.resolveReference(uri);
                    if (rr != null) {
                        if (rr.getResource() == null) {
                            x.ah(this.context.prefixLocalHref(rr.getWebPath())).addText(rr.getUrlReference());
                        } else {
                            x.ah(this.context.prefixLocalHref(rr.getWebPath())).addText(RendererFactory.factory(rr.getResource(), this.context.forContained()).buildSummary(rr.getResource()));
                        }
                    } else {
                        Resource r = this.context.getContext().fetchResource(Resource.class, (String)v);
                        if (r != null && r.getWebPath() != null) {
                            x.ah(this.context.prefixLocalHref(r.getWebPath())).addText(RendererFactory.factory(r, this.context.forContained()).buildSummary(this.wrap(r)));
                        } else if (r != null) {
                            x.ah(this.context.prefixLocalHref((String)v)).addText(RendererFactory.factory(r, this.context.forContained()).buildSummary(this.wrap(r)));
                        } else {
                            String url;
                            String string = url = this.context.getResolver() != null ? this.context.getResolver().resolveUri(this.context, (String)v) : null;
                            if (url != null) {
                                x.ah(this.context.prefixLocalHref(url)).addText((String)v);
                            } else if (Utilities.isAbsoluteUrlLinkable((String)v) && !uri.fhirType().equals("id")) {
                                x.ah(this.context.prefixLocalHref((String)v)).addText((String)v);
                            } else {
                                x.addText((String)v);
                            }
                        }
                    }
                }
            }
        }
    }

    protected <T extends Resource> T findCanonical(Class<T> class_, UriType canonical, ResourceWrapper sourceOfReference) {
        return this.context.getContext().fetchResource(class_, canonical.asStringValue(), sourceOfReference.getResourceNative());
    }

    protected <T extends Resource> T findCanonical(Class<T> class_, String canonical, ResourceWrapper sourceOfReference) {
        return this.context.getContext().fetchResource(class_, canonical, sourceOfReference.getResourceNative());
    }

    private Resolver.ResourceWithReference resolveContained(ResourceWrapper resource, String url) {
        ResourceWrapper container = this.findContainer(resource);
        if (container == null) {
            return null;
        }
        if ("#".equals(url)) {
            return new Resolver.ResourceWithReference(Resolver.ResourceReferenceKind.CONTAINER, url, "#hc" + container.getScopedId(), container);
        }
        String tid = url.substring(1);
        for (ResourceWrapper c : container.children("contained")) {
            if (!tid.equals(c.getId())) continue;
            return new Resolver.ResourceWithReference(Resolver.ResourceReferenceKind.CONTAINED, url, "#hc" + c.getScopedId(), c);
        }
        return null;
    }

    private ResourceWrapper findContainer(ResourceWrapper resource) {
        ResourceWrapper container;
        for (container = resource; !(container == null || container.isResource() && container.kind() != ResourceWrapper.ElementKind.ContainedResource); container = container.parent()) {
        }
        return container;
    }

    private Resolver.ResourceWithReference resolveOutside(ResourceWrapper resource, String url, String version, boolean followLinks) throws IOException {
        Resolver.ResourceWithReference rr;
        ResourceWrapper container = this.findContainer(resource);
        if (container != null) {
            while (container != null) {
                if (container.isResource() && container.fhirType().equals("Bundle") && (rr = this.findInBundle(resource, url)) != null) {
                    return null;
                }
                container = container.parent();
            }
        }
        if (followLinks) {
            if (this.context.getResolver() != null && (rr = this.context.getResolver().resolve(this.context, url, version)) != null) {
                return rr;
            }
            Resource r = this.context.getWorker().fetchResource(Resource.class, url, version);
            if (r != null) {
                return new Resolver.ResourceWithReference(Resolver.ResourceReferenceKind.EXTERNAL, url, r.getWebPath(), this.wrap(r));
            }
        }
        return null;
    }

    private Resolver.ResourceWithReference findInBundle(ResourceWrapper resource, String url) {
        if (url.equals("Bundle/" + resource.getId())) {
            return new Resolver.ResourceWithReference(Resolver.ResourceReferenceKind.BUNDLE, url, "#" + resource.getScopedId(), resource);
        }
        for (ResourceWrapper entry : resource.children("entry")) {
            Resolver.ResourceWithReference rr;
            String fu;
            if (!entry.has("resource")) continue;
            ResourceWrapper res = entry.child("resource");
            if (entry.has("fullUrl") && url.equals(fu = entry.primitiveValue("fullUrl"))) {
                return new Resolver.ResourceWithReference(Resolver.ResourceReferenceKind.BUNDLE, url, "#" + res.getScopedId(), res);
            }
            if (!"Bundle".equals(res.fhirType()) || (rr = this.findInBundle(res, url)) == null) continue;
            return rr;
        }
        return null;
    }

    protected Resolver.ResourceWithReference resolveReference(ResourceWrapper resource, String url, boolean followLinks) throws IOException {
        if (url == null) {
            return null;
        }
        if (url.startsWith("#")) {
            return this.resolveContained(resource, url);
        }
        String version = null;
        if (url.contains("/_history/")) {
            version = url.substring(url.indexOf("/_history/") + 10);
            url = url.substring(0, url.indexOf("/_history/"));
        }
        return this.resolveOutside(resource, url, version, followLinks);
    }

    protected Resolver.ResourceWithReference resolveReference(ResourceWrapper reference) {
        try {
            if (reference.fhirType().equals("CodeableReference")) {
                if (reference.has("reference")) {
                    return this.resolveReference(reference.child("reference"));
                }
                return null;
            }
            if (reference.fhirType().equals("Reference")) {
                return this.resolveReference(reference.getResourceWrapper(), reference.primitiveValue("reference"), true);
            }
            return this.resolveReference(reference.getResourceWrapper(), reference.primitiveValue(), true);
        }
        catch (IOException e) {
            if (this.context.isDebug()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected String makeIdFromBundleEntry(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("urn:uuid:")) {
            return url.substring(9).toLowerCase();
        }
        return this.fullUrlToAnchor(url);
    }

    private String fullUrlToAnchor(String url) {
        return url.replace(":", "").replace("/", "_");
    }

    protected void generateCopyright(XhtmlNode x, ResourceWrapper cs) {
        XhtmlNode p = x.para();
        p.b().tx(this.getContext().formatPhrase("RESOURCE_COPYRIGHT", new Object[0]));
        this.smartAddText(p, " " + this.context.getTranslated(cs.child("copyright")));
    }

    protected void generateCopyrightTableRow(XhtmlNode tbl, ResourceWrapper cs) {
        XhtmlNode tr = tbl.tr();
        tr.td().b().tx(this.getContext().formatPhrase("RESOURCE_COPYRIGHT", new Object[0]));
        this.smartAddText(tr.td(), " " + this.context.getTranslated(cs.child("copyright")));
    }

    public String displayReference(Resource res, Reference r) throws UnsupportedEncodingException, IOException {
        return this.context.formatPhrase("GENERAL_TODO", new Object[0]);
    }

    public Base parseType(String string, String type) {
        return null;
    }

    protected String describeStatus(Enumerations.PublicationStatus status, boolean experimental) {
        switch (status) {
            case ACTIVE: {
                return experimental ? this.context.formatPhrase("GENERAL_EXPER", new Object[0]) : this.context.formatPhrase("RES_REND_ACT", new Object[0]);
            }
            case DRAFT: {
                return this.context.formatPhrase("RES_REND_DRAFT", new Object[0]);
            }
            case RETIRED: {
                return this.context.formatPhrase("RES_REND_RET", new Object[0]);
            }
        }
        return this.context.formatPhrase("RES_REND_UNKNOWN", new Object[0]);
    }

    protected void renderCommitteeLink(XhtmlNode x, CanonicalResource cr) {
        String code = ToolingExtensions.readStringExtension((DomainResource)cr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
        CodeSystem cs = this.context.getWorker().fetchCodeSystem("http://terminology.hl7.org/CodeSystem/hl7-work-group");
        if (cs == null || !cs.hasWebPath()) {
            x.tx(code);
        } else {
            CodeSystem.ConceptDefinitionComponent cd = CodeSystemUtilities.findCode(cs.getConcept(), code);
            if (cd == null) {
                x.tx(code);
            } else {
                x.ah(this.context.prefixLocalHref(cs.getWebPath() + "#" + cs.getId() + "-" + cd.getCode())).tx(cd.getDisplay());
            }
        }
    }

    public static String makeInternalBundleLink(ResourceWrapper bundle, String fullUrl) {
        boolean inBundle = false;
        for (ResourceWrapper rw = bundle.parent(); rw != null; rw = rw.parent()) {
            if (!rw.fhirType().equals("Bundle")) continue;
            inBundle = true;
        }
        if (inBundle) {
            return bundle.getScopedId() + "/" + fullUrl.replace(":", "-");
        }
        return fullUrl.replace(":", "-");
    }

    public boolean canRender(Resource resource) {
        return true;
    }

    protected XhtmlNode renderResourceTechDetails(ResourceWrapper r, XhtmlNode x) throws UnsupportedEncodingException, FHIRException, IOException {
        return this.renderResourceTechDetails(r, x, (String)(this.context.isContained() && r.getId() != null ? "#" + r.getId() : r.getId()));
    }

    protected XhtmlNode renderResourceTechDetails(ResourceWrapper r, XhtmlNode x, String id) throws UnsupportedEncodingException, FHIRException, IOException {
        Object sid;
        XhtmlNode p = x.para().attribute("class", "res-header-id");
        this.markGenerated(p);
        if (!this.context.isNoHeader()) {
            String ft = this.context.getTranslatedCode(r.fhirType(), VersionUtilities.getResourceTypesUrl((String)this.context.getContext().getVersion()));
            if (id == null) {
                p.b().tx(this.context.formatPhrase(this.context.isTechnicalMode() && !this.isInner() ? "PROF_DRIV_GEN_NARR_TECH" : "PROF_DRIV_GEN_NARR", new Object[]{ft, ""}));
            } else {
                p.b().tx(this.context.formatPhrase(this.context.isTechnicalMode() && !this.isInner() ? "PROF_DRIV_GEN_NARR_TECH" : "PROF_DRIV_GEN_NARR", new Object[]{ft, id}));
            }
        }
        if (!Utilities.noString((String)r.getId()) && (sid = r.getScopedId()) != null && !this.willRenderId(r)) {
            if (!this.context.hasAnchor((String)sid)) {
                this.context.addAnchor((String)sid);
                x.an(this.context.prefixAnchor((String)sid));
            }
            if (!this.context.hasAnchor((String)(sid = "hc" + (String)sid))) {
                this.context.addAnchor((String)sid);
                x.an(this.context.prefixAnchor((String)sid));
            }
        }
        if (this.context.isTechnicalMode()) {
            ResourceWrapper source;
            Renderer.RenderingStatus status = new Renderer.RenderingStatus();
            String lang = r.primitiveValue("language");
            String ir = r.primitiveValue("implicitRules");
            ResourceWrapper meta = r.has("meta") && !r.child("meta").isEmpty() ? r.child("meta") : null;
            ResourceWrapper versionId = meta == null ? null : meta.child("versionId");
            ResourceWrapper lastUpdated = meta == null ? null : meta.child("lastUpdated");
            ResourceWrapper resourceWrapper = source = meta == null ? null : meta.child("source");
            if (lang != null || versionId != null || lastUpdated != null || ir != null || source != null || meta != null) {
                XhtmlNode div = x.div().style("display: inline-block").style("background-color: #d9e0e7").style("padding: 6px").style("margin: 4px").style("border: 1px solid #8da1b4").style("border-radius: 5px").style("line-height: 60%");
                boolean sfirst = true;
                p = this.plateStyle(div.para());
                if (versionId != null) {
                    p.tx(this.context.formatPhrase("RES_REND_VER", new Object[]{versionId.primitiveValue()}));
                    sfirst = false;
                }
                if (lastUpdated != null) {
                    if (!sfirst) {
                        p.tx("; ");
                    }
                    p.tx(this.context.formatPhrase("RES_REND_UPDATED", new Object[]{this.displayDataType(lastUpdated)}));
                    sfirst = false;
                }
                if (lang != null) {
                    if (!sfirst) {
                        p.tx("; ");
                    }
                    p.tx(this.context.formatPhrase("RES_REND_LANGUAGE", new Object[]{lang}));
                    sfirst = false;
                }
                if (source != null) {
                    if (!sfirst) {
                        p.tx("; ");
                    }
                    XhtmlNode pp = this.plateStyle(div.para());
                    pp.startScript("source");
                    this.renderDataType(status, pp.param("source"), source);
                    pp.execScript(this.context.formatPhrase("RES_REND_INFO_SOURCE", new Object[0]));
                    pp.closeScript();
                    sfirst = false;
                }
                if (ir != null) {
                    if (!sfirst) {
                        p.tx("; ");
                    }
                    this.plateStyle(div.para()).b().tx(this.context.formatPhrase("RES_REND_SPEC_RULES", new Object[]{ir}));
                    sfirst = false;
                }
                if (meta != null) {
                    boolean first;
                    List<ResourceWrapper> items = meta.children("profile");
                    if (!items.isEmpty()) {
                        p = this.plateStyle(div.para());
                        p.tx(Utilities.pluralize((String)this.context.formatPhrase("GENERAL_PROF", new Object[0]), (int)items.size()) + ": ");
                        first = true;
                        for (ResourceWrapper bw : items) {
                            if (first) {
                                first = false;
                            } else {
                                p.tx(", ");
                            }
                            this.renderCanonical(status, p, StructureDefinition.class, bw);
                        }
                    }
                    if (!(items = meta.children("tag")).isEmpty()) {
                        p = this.plateStyle(div.para());
                        p.tx(Utilities.pluralize((String)this.context.formatPhrase("RES_REND_TAG", new Object[0]), (int)items.size()) + ": ");
                        first = true;
                        for (ResourceWrapper bw : items) {
                            if (first) {
                                first = false;
                            } else {
                                p.tx(", ");
                            }
                            this.renderCoding(status, p, bw);
                        }
                    }
                    if (!(items = meta.children("security")).isEmpty()) {
                        p = this.plateStyle(div.para());
                        p.tx(Utilities.pluralize((String)this.context.formatPhrase("GENERAL_SECURITY_LABEL", new Object[0]), (int)items.size()) + ": ");
                        first = true;
                        for (ResourceWrapper bw : items) {
                            if (first) {
                                first = false;
                            } else {
                                p.tx(", ");
                            }
                            this.renderCoding(status, p, bw);
                        }
                    }
                }
                return div;
            }
        }
        return null;
    }

    protected boolean willRenderId(ResourceWrapper r) {
        return false;
    }

    protected XhtmlNode plateStyle(XhtmlNode para) {
        return para.style("margin-bottom: 0px");
    }

    public RendererType getRendererType() {
        return RendererType.NATIVE;
    }

    public void renderTable(Renderer.RenderingStatus status, TableData provider, XhtmlNode x) throws FHIRFormatError, DefinitionException, IOException {
        ArrayList<String> columns = new ArrayList<String>();
        for (String name : provider.getColumns()) {
            boolean hasData = false;
            for (TableRowData row : provider.getRows()) {
                if (!row.hasCol(name)) continue;
                hasData = true;
            }
            if (!hasData) continue;
            columns.add(name);
        }
        if (columns.size() > 0) {
            XhtmlNode table = x.table("grid", false);
            if (provider.getTitle() != null) {
                table.tr().td().colspan(columns.size()).b().tx(provider.getTitle());
            }
            XhtmlNode tr = table.tr();
            for (String col : columns) {
                tr.th().b().tx(col);
            }
            for (TableRowData row : provider.getRows()) {
                tr = table.tr();
                for (String col : columns) {
                    XhtmlNode td = tr.td();
                    boolean first = true;
                    List<ResourceWrapper> list = row.get(col);
                    if (list == null) continue;
                    for (ResourceWrapper value : list) {
                        if (first) {
                            first = false;
                        } else {
                            td.tx(", ");
                        }
                        this.renderDataType(status, td, value);
                    }
                }
            }
        }
    }

    public void renderOrError(ResourceWrapper dr) throws IOException {
        try {
            this.renderResource(dr);
        }
        catch (Exception e) {
            XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
            x.para().tx("Error rendering: " + e.getMessage());
            this.inject(dr, x, Narrative.NarrativeStatus.GENERATED);
        }
    }

    public boolean genSummaryTable(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper cr) throws IOException {
        if (this.context.isShowSummaryTable() && cr != null) {
            XhtmlNode tbl = x.table("grid", false);
            this.genSummaryTableContent(status, tbl, cr);
            return true;
        }
        return false;
    }

    protected void genSummaryTableContent(Renderer.RenderingStatus status, XhtmlNode tbl, ResourceWrapper cr) throws IOException {
        XhtmlNode tr;
        if (cr.has("url")) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_DEFINING_URL", new Object[0]) + ":");
            this.xlinkNarrative(tr.td(), cr.child("url")).code().tx(cr.primitiveValue("url"));
        } else if (cr.hasExtension(EXT_NS_URL)) {
            status.setExtensions(true);
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_DEFINING_URL", new Object[0]) + ":");
            this.xlinkNarrative(tr.td(), cr.extension(EXT_NS_URL)).code().tx(cr.extensionString(EXT_NS_URL));
        } else if (!this.context.isContained()) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_DEFINING_URL", new Object[0]));
            tr.td();
        }
        if (cr.has("version")) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_VER", new Object[0]) + ":");
            this.renderDataType(status, tr.td(), cr.child("version"));
        } else if (cr.hasExtension("http://terminology.hl7.org/StructureDefinition/ext-namingsystem-version")) {
            status.setExtensions(true);
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_VER", new Object[0]) + ":");
            this.renderDataType(status, tr.td(), cr.extensionValue("http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.version"));
        }
        String name = this.context.getTranslated(cr.child("name"));
        String title = this.context.getTranslated(cr.child("title"));
        if (name != null) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_NAME", new Object[0]) + ":");
            this.xlinkNarrative(tr.td(), cr.child("name")).tx(name);
        }
        if (title != null && !title.equalsIgnoreCase(name)) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_TITLE", new Object[0]) + ":");
            this.xlinkNarrative(tr.td(), cr.child("title")).tx(title);
        }
        if (cr.has("status") && !this.context.isContained()) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_STATUS", new Object[0]) + ":");
            this.xlinkNarrative(tr.td(), cr.child("status")).tx(this.describeStatus(status, cr));
        }
        if (cr.has("description")) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_DEFINITION", new Object[0]) + ":");
            this.xlinkNarrative(tr.td(), cr.child("description")).markdown(this.context.getTranslated(cr.child("description")), "description");
        }
        if (cr.has("publisher")) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("CANON_REND_PUBLISHER", new Object[0]) + ":");
            this.buildPublisherLinks(tr.td(), cr);
        }
        if (cr.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg")) {
            status.setExtensions(true);
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("CANON_REND_COMMITTEE", new Object[0]) + ":");
            this.renderCommitteeLink(tr.td(), cr);
        }
        if (cr.has("copyright")) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_COPYRIGHT", new Object[0]) + ":");
            this.xlinkNarrative(tr.td(), cr.child("copyright")).markdown(this.context.getTranslated(cr.child("copyright")), "copyright");
        }
        if (cr.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm")) {
            status.setExtensions(true);
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).ah("http://hl7.org/fhir/versions.html#maturity", "Maturity Level").attribute("class", "fmm").tx(this.context.formatPhrase("CANON_REND_COMMITTEE", new Object[0]) + ":");
            this.renderDataType(status, tr.td(), cr.extensionValue("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm"));
        }
    }

    public void genSummaryTable(Renderer.RenderingStatus status, XhtmlNode x, CanonicalResource cr) throws IOException {
        if (this.context.isShowSummaryTable() && cr != null) {
            XhtmlNode tbl = x.table("grid", false);
            this.genSummaryTableContent(status, tbl, cr);
        }
    }

    protected void genSummaryTableContent(Renderer.RenderingStatus status, XhtmlNode tbl, CanonicalResource cr) throws IOException {
        String title;
        XhtmlNode tr;
        if (cr.hasUrl()) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_DEFINING_URL", new Object[0]) + ":");
            tr.td().code().tx(cr.getUrl());
        } else if (cr.hasExtension(EXT_NS_URL)) {
            status.setExtensions(true);
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_DEFINING_URL", new Object[0]));
            tr.td().code().tx(ToolingExtensions.readStringExtension((DomainResource)cr, EXT_NS_URL) + ":");
        } else if (!this.context.isContained()) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_DEFINING_URL", new Object[0]));
            tr.td();
        }
        if (cr.hasVersion()) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_VER", new Object[0]) + ":");
            tr.td().tx(cr.getVersion());
        } else if (cr.hasExtension("http://terminology.hl7.org/StructureDefinition/ext-namingsystem-version")) {
            status.setExtensions(true);
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_VER", new Object[0]) + ":");
            tr.td().tx(ToolingExtensions.readStringExtension((DomainResource)cr, "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.version"));
        }
        String name = cr.hasName() ? this.context.getTranslated(cr.getNameElement()) : null;
        String string = title = cr.hasTitle() ? this.context.getTranslated(cr.getTitleElement()) : null;
        if (name != null) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_NAME", new Object[0]) + ":");
            tr.td().tx(name);
        }
        if (title != null && !title.equalsIgnoreCase(name)) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_TITLE", new Object[0]) + ":");
            tr.td().tx(title);
        }
        if (cr.hasStatus() && !this.context.isContained()) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_STATUS", new Object[0]) + ":");
            tr.td().tx(this.describeStatus(status, cr));
        }
        if (cr.hasDescription()) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_DEFINITION", new Object[0]) + ":");
            tr.td().markdown(cr.getDescription(), "description");
        }
        if (cr.hasPublisher()) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("CANON_REND_PUBLISHER", new Object[0]) + ":");
            this.buildPublisherLinks(tr.td(), cr);
        }
        if (cr.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg")) {
            status.setExtensions(true);
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("CANON_REND_COMMITTEE", new Object[0]) + ":");
            this.renderCommitteeLink(tr.td(), cr);
        }
        if (cr.hasCopyright()) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_COPYRIGHT", new Object[0]) + ":");
            tr.td().markdown(cr.getDescription(), "copyright");
        }
        if (ToolingExtensions.hasExtension(cr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm")) {
            status.setExtensions(true);
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).ah("http://hl7.org/fhir/versions.html#maturity", "Maturity Level").attribute("class", "fmm").tx(this.context.formatPhrase("CANON_REND_COMMITTEE", new Object[0]) + ":");
            tr.td().tx(ToolingExtensions.readStringExtension((DomainResource)cr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm"));
        }
    }

    protected void renderCommitteeLink(XhtmlNode x, ResourceWrapper cr) {
        String code = cr.extensionString("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
        CodeSystem cs = this.context.getContext().fetchCodeSystem("http://terminology.hl7.org/CodeSystem/hl7-work-group");
        if (cs == null || !cs.hasWebPath()) {
            x.tx(code);
        } else {
            CodeSystem.ConceptDefinitionComponent cd = CodeSystemUtilities.findCode(cs.getConcept(), code);
            if (cd == null) {
                x.tx(code);
            } else {
                x.ah(cs.getWebPath() + "#" + cs.getId() + "-" + cd.getCode()).tx(cd.getDisplay());
            }
        }
    }

    private void buildPublisherLinks(XhtmlNode x, CanonicalResource cr) {
        boolean useName = false;
        for (ContactDetail cd : cr.getContact()) {
            if (cd.hasName()) continue;
            useName = true;
        }
        boolean first = true;
        if (!useName) {
            x.tx(Utilities.escapeXml((String)cr.getPublisher()));
            first = false;
        }
        for (ContactDetail cd : cr.getContact()) {
            String name;
            String string = name = cd.hasName() ? cd.getName() : cr.getPublisher();
            if (!cd.hasTelecom()) continue;
            if (first) {
                first = false;
            } else {
                x.tx(". ");
            }
            this.renderContact(x, name, cd.getTelecom());
        }
    }

    private void buildPublisherLinks(XhtmlNode x, ResourceWrapper cr) {
        boolean useName = false;
        for (ResourceWrapper cd : cr.children("contact")) {
            if (cd.has("name")) continue;
            useName = true;
        }
        boolean first = true;
        if (!useName) {
            x.tx(Utilities.escapeXml((String)cr.primitiveValue("publisher")));
            first = false;
        }
        for (ResourceWrapper cd : cr.children("contact")) {
            String name;
            String string = name = cd.has("name") ? cd.primitiveValue("name") : cr.primitiveValue("publisher");
            if (!cd.has("telecom")) continue;
            if (first) {
                first = false;
            } else {
                x.tx(". ");
            }
            this.renderContactW(this.spanIfTracking(x, cd), name, cd.children("telecom"));
        }
    }

    private void renderContactW(XhtmlNode x, String name, List<ResourceWrapper> telecom) {
        ArrayList<String> urls = new ArrayList<String>();
        for (ResourceWrapper t : telecom) {
            if (!"url".equals(t.primitiveValue()) || !t.has("value")) continue;
            urls.add(t.primitiveValue("value"));
        }
        if (urls.size() == 1) {
            x.ah((String)urls.get(0)).tx(name);
        } else {
            x.tx(name);
        }
        for (ResourceWrapper t : telecom) {
            String system = t.primitiveValue("system");
            String value = t.primitiveValue("value");
            if ("url".equals(system) && value != null && urls.size() != 1) {
                x.tx(", ");
                x.ah(t.primitiveValue("value")).tx("Link");
            }
            if ("email".equals(system) && value != null) {
                x.tx(", ");
                x.ah("mailto:" + t.primitiveValue("value")).tx("Email");
            }
            if ("phone".equals(system) && value != null) {
                x.tx(", ");
                x.tx(t.primitiveValue("value"));
            }
            if (!"fax".equals(system) || value == null) continue;
            x.tx(", ");
            x.tx("Fax:" + t.primitiveValue("value"));
        }
    }

    private void renderContact(XhtmlNode x, String name, List<ContactPoint> telecom) {
        ArrayList<String> urls = new ArrayList<String>();
        for (ContactPoint t : telecom) {
            if (t.getSystem() != ContactPoint.ContactPointSystem.URL || !t.hasValue()) continue;
            urls.add(t.getValue());
        }
        if (urls.size() == 1) {
            x.ah((String)urls.get(0)).tx(name);
        } else {
            x.tx(name);
        }
        for (ContactPoint t : telecom) {
            if (t.getSystem() == ContactPoint.ContactPointSystem.URL && t.hasValue() && urls.size() != 1) {
                x.tx(", ");
                x.ah(t.getValue()).tx("Link");
            }
            if (t.getSystem() == ContactPoint.ContactPointSystem.EMAIL && t.hasValue()) {
                x.tx(", ");
                x.ah("mailto:" + t.getValue()).tx("Email");
            }
            if (t.getSystem() == ContactPoint.ContactPointSystem.PHONE && t.hasValue()) {
                x.tx(", ");
                x.tx(t.getValue());
            }
            if (t.getSystem() != ContactPoint.ContactPointSystem.FAX || !t.hasValue()) continue;
            x.tx(", ");
            x.tx("Fax:" + t.getValue());
        }
    }

    protected String describeStatus(Renderer.RenderingStatus status, ResourceWrapper cr) {
        Object s = this.describeStatus(cr.primitiveValue("status"), cr.primitiveValue("experimental"), cr.child("date"), cr.extensionString("http://hl7.org/fhir/StructureDefinition/valueset-deprecated"));
        if (cr.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status")) {
            status.setExtensions(true);
            s = (String)s + this.presentStandardsStatus(cr.extensionString("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status"));
        }
        return s;
    }

    protected String describeStatus(Renderer.RenderingStatus status, CanonicalResource cr) {
        Object s = this.describeStatus(cr.getStatus(), cr.hasExperimental() ? cr.getExperimental() : false, cr.hasDate() ? cr.getDateElement() : null, ToolingExtensions.readBooleanExtension(cr, "http://hl7.org/fhir/StructureDefinition/valueset-deprecated"));
        if (cr.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status")) {
            status.setExtensions(true);
            s = (String)s + this.presentStandardsStatus(ToolingExtensions.readStringExtension((DomainResource)cr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status"));
        }
        return s;
    }

    private String presentStandardsStatus(String code) {
        String pfx = " (<a href=\"http://hl7.org/fhir/codesystem-standards-status.html#" + code + "\">Standards Status</a>: ";
        switch (code) {
            case "draft": {
                return pfx + "Draft)";
            }
            case "normative": {
                return pfx + "Normative)";
            }
            case "trial-use": {
                return pfx + "Trial Use)";
            }
            case "informative": {
                return pfx + "Informative)";
            }
            case "deprecated": {
                return pfx + "<span style=\"color: maroon; font-weight: bold\">Deprecated</span>)";
            }
            case "external": {
                return pfx + "External)";
            }
        }
        return "";
    }

    protected String describeStatus(Enumerations.PublicationStatus status, boolean experimental, DateTimeType dt, Boolean deprecated) {
        String sfx;
        String string = sfx = dt != null ? " as of " + this.displayDataType(dt) : "";
        if (deprecated != null && deprecated.booleanValue()) {
            if (status == Enumerations.PublicationStatus.RETIRED) {
                return "Deprecated + Retired" + sfx;
            }
            return "Deprecated" + sfx;
        }
        switch (status) {
            case ACTIVE: {
                return (experimental ? "Experimental" : "Active") + sfx;
            }
            case DRAFT: {
                return "Draft" + sfx;
            }
            case RETIRED: {
                return "Retired" + sfx;
            }
        }
        return "Unknown" + sfx;
    }

    protected String describeStatus(String status, String experimental, ResourceWrapper dt, String deprecated) {
        String sfx;
        String string = sfx = dt != null ? " as of " + this.displayDataType(dt) : "";
        if ("true".equals(deprecated)) {
            if ("retired".equals(status)) {
                return "Deprecated + Retired" + sfx;
            }
            return "Deprecated" + sfx;
        }
        switch (status) {
            case "active": {
                return ("true".equals(experimental) ? "Experimental" : "Active") + sfx;
            }
            case "draft": {
                return "Draft" + sfx;
            }
            case "retired": {
                return "Retired" + sfx;
            }
        }
        return "Unknown" + sfx;
    }

    protected void addContained(Renderer.RenderingStatus status, XhtmlNode x, List<ResourceWrapper> list) throws FHIRFormatError, DefinitionException, FHIRException, IOException, EOperationOutcome {
        for (ResourceWrapper c : list) {
            x.hr();
            String id = c.getScopedId();
            if (!this.context.hasAnchor(id)) {
                this.context.addAnchor(id);
                x.an(this.context.prefixAnchor(id));
            }
            RendererFactory.factory(c, this.context.forContained()).setInner(true).buildNarrative(status, x, c);
        }
    }

    protected void selfLink(XhtmlNode node, String link) {
        XhtmlNode a = node.addTag("a");
        if (node.hasAttribute("class")) {
            node.setAttribute("class", node.getAttribute("class") + " self-link-parent");
        } else {
            node.setAttribute("class", "self-link-parent");
        }
        a.setAttribute("href", "#" + link);
        a.setAttribute("title", "link to here");
        a.setAttribute("class", "self-link");
        XhtmlNode svg = a.addTag("svg");
        XhtmlNode path = svg.addTag("path");
        String pathData = "M1520 1216q0-40-28-68l-208-208q-28-28-68-28-42 0-72 32 3 3 19 18.5t21.5 21.5 15 19 13 25.5 3.5 27.5q0 40-28 68t-68 28q-15 0-27.5-3.5t-25.5-13-19-15-21.5-21.5-18.5-19q-33 31-33 73 0 40 28 68l206 207q27 27 68 27 40 0 68-26l147-146q28-28 28-67zm-703-705q0-40-28-68l-206-207q-28-28-68-28-39 0-68 27l-147 146q-28 28-28 67 0 40 28 68l208 208q27 27 68 27 42 0 72-31-3-3-19-18.5t-21.5-21.5-15-19-13-25.5-3.5-27.5q0-40 28-68t68-28q15 0 27.5 3.5t25.5 13 19 15 21.5 21.5 18.5 19q33-31 33-73zm895 705q0 120-85 203l-147 146q-83 83-203 83-121 0-204-85l-206-207q-83-83-83-203 0-123 88-209l-88-88q-86 88-208 88-120 0-204-84l-208-208q-84-84-84-204t85-203l147-146q83-83 203-83 121 0 204 85l206 207q83 83 83 203 0 123-88 209l88 88q86-88 208-88 120 0 204 84l208 208q84 84 84 204z";
        svg.attribute("height", "20").attribute("width", "20").attribute("viewBox", "0 0 1792 1792").attribute("class", "self-link");
        path.attribute("d", pathData).attribute("fill", "navy");
    }

    public static enum RendererType {
        NATIVE,
        PROFILE,
        LIQUID;

    }

    public class TableData {
        private String title;
        private List<String> columns = new ArrayList<String>();
        private List<TableRowData> rows = new ArrayList<TableRowData>();

        public TableData(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public List<TableRowData> getRows() {
            return this.rows;
        }

        public void addColumn(String name) {
            this.columns.add(name);
        }

        public TableRowData addRow() {
            TableRowData res = new TableRowData();
            this.rows.add(res);
            res.data = this;
            return res;
        }
    }

    public class TableRowData {
        private Map<String, List<ResourceWrapper>> cols = new HashMap<String, List<ResourceWrapper>>();
        private TableData data;

        public void value(String name, ResourceWrapper value) {
            if (!this.cols.containsKey(name)) {
                this.cols.put(name, new ArrayList());
            }
            if (!this.data.columns.contains(name)) {
                this.data.columns.add(name);
            }
            this.cols.get(name).add(value);
        }

        public boolean hasCol(String name) {
            return this.cols.containsKey(name);
        }

        public List<ResourceWrapper> get(String name) {
            return this.cols.get(name);
        }
    }
}

