/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class SubscriptionTopicRenderer
extends ResourceRenderer {
    public SubscriptionTopicRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper st) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        ResourceRenderer.TableRowData tr;
        ResourceRenderer.TableData td;
        this.renderResourceTechDetails(st, x);
        this.genSummaryTable(status, x, (CanonicalResource)st.getResourceNative());
        XhtmlNode tbl = x.table("grid", false);
        XhtmlNode ttr = tbl.tr();
        ttr.td().b().tx("SubscriptionTopic");
        ttr.td().tx(this.context.getTranslated(st.has("title") ? st.child("title") : st.child("name")));
        if (st.has("description")) {
            ttr = tbl.tr();
            ttr.td().b().tx("Description");
            this.addMarkdown(ttr.td(), st.primitiveValue("description"));
        }
        if (st.has("copyright")) {
            this.generateCopyrightTableRow(tbl, st);
        }
        if (st.has("resourceTrigger")) {
            td = new ResourceRenderer.TableData(this.context.formatPhrase("SUB_TOPIC_RES_TRIG", new Object[0]));
            for (ResourceWrapper rt : st.children("resourceTrigger")) {
                tr = td.addRow();
                if (rt.has("resource")) {
                    tr.value(this.context.formatPhrase("GENERAL_RESOURCE", new Object[0]), rt.child("resource"));
                }
                for (ResourceWrapper t : rt.children("supportedInteraction")) {
                    tr.value(this.context.formatPhrase("SUB_TOPIC_INT", new Object[0]), t);
                }
                if (rt.has("queryCriteria")) {
                    StringBuilder md = new StringBuilder();
                    ResourceWrapper qc = rt.child("queryCriteria");
                    if (qc.has("previous")) {
                        md.append(this.context.formatPhrase("SUB_TOPIC_PREV", new Object[]{qc.primitiveValue("previous") + "\r\n"}) + " ");
                    }
                    if (qc.has("resultForCreate")) {
                        md.append(this.context.formatPhrase("SUB_TOPIC_CREATE", new Object[]{qc.primitiveValue("resultForCreate") + "\r\n"}) + " ");
                    }
                    if (qc.has("current")) {
                        md.append(this.context.formatPhrase("SUB_TOPIC_CURR", new Object[]{qc.primitiveValue("current") + "\r\n"}) + " ");
                    }
                    if (qc.has("previous")) {
                        md.append(this.context.formatPhrase("SUB_TOPIC_DELETE", new Object[]{qc.primitiveValue("resultForDelete") + "\r\n"}) + " ");
                    }
                    if (qc.has("requireBoth")) {
                        md.append(this.context.formatPhrase("SUB_TOPIC_REQ", new Object[]{qc.primitiveValue("requireBoth") + "\r\n"}) + " ");
                    }
                    tr.value(this.context.formatPhrase("GENERAL_CRIT", new Object[0]), this.wrapNC(new MarkdownType(md.toString())));
                }
                if (rt.has("fhirPathCriteria")) {
                    tr.value(this.context.formatPhrase("SUB_TOPIC_FHIR_PATH", new Object[0]), rt.child("fhirPathCriteria"));
                }
                if (!rt.has("description")) continue;
                tr.value(this.context.formatPhrase("GENERAL_DESC", new Object[0]), rt.child("description"));
            }
            this.renderTable(status, td, x);
        }
        if (st.has("eventTrigger")) {
            td = new ResourceRenderer.TableData("Event Triggers");
            for (ResourceWrapper rt : st.children("eventTrigger")) {
                tr = td.addRow();
                if (rt.has("resource")) {
                    tr.value(this.context.formatPhrase("GENERAL_RESOURCE", new Object[0]), rt.child("resource"));
                }
                if (rt.has("event(")) {
                    tr.value(this.context.formatPhrase("SUB_TOPIC_EVENT", new Object[0]), rt.child("event"));
                }
                if (!rt.has("description")) continue;
                tr.value(this.context.formatPhrase("GENERAL_DESC", new Object[0]), rt.child("description"));
            }
            this.renderTable(status, td, x);
        }
        if (st.has("canFilterBy")) {
            td = new ResourceRenderer.TableData("Can Filter By");
            for (ResourceWrapper rt : st.children("canFilterBy")) {
                tr = td.addRow();
                if (rt.has("resource")) {
                    tr.value(this.context.formatPhrase("GENERAL_RESOURCE", new Object[0]), rt.child("resource"));
                }
                if (rt.has("filterParameter")) {
                    tr.value(this.context.formatPhrase("SUB_TOPIC_FILT_PAR", new Object[0]), rt.child("filterParameter"));
                }
                if (rt.has("filterDefinition")) {
                    tr.value(this.context.formatPhrase("SUB_TOPIC_FILT_DEF", new Object[0]), rt.child("filterDefinition"));
                }
                for (ResourceWrapper t : rt.children("comparator")) {
                    tr.value(this.context.formatPhrase("GENERAL_COMPARATORS", new Object[0]), t);
                }
                for (ResourceWrapper t : rt.children("modifier")) {
                    tr.value(this.context.formatPhrase("GENERAL_MODIFIERS", new Object[0]), t);
                }
            }
            this.renderTable(status, td, x);
        }
        if (st.has("notificationShape")) {
            td = new ResourceRenderer.TableData("Notification Shapes");
            for (ResourceWrapper rt : st.children("notificationShape")) {
                tr = td.addRow();
                if (rt.has("resource")) {
                    tr.value(this.context.formatPhrase("GENERAL_RESOURCE", new Object[0]), rt.child("resource"));
                }
                for (ResourceWrapper t : rt.children("include")) {
                    tr.value(this.context.formatPhrase("SUB_TOPIC_INCL", new Object[0]), t);
                }
                for (ResourceWrapper t : rt.children("revInclude")) {
                    tr.value(this.context.formatPhrase("SUB_TOPIC_REV_INCL", new Object[0]), t);
                }
            }
            this.renderTable(status, td, x);
        }
    }
}

