/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.spreadsheets;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.renderers.DataRenderer;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class SpreadsheetGenerator {
    private static final int MAX_SENSITIVE_SHEET_NAME_LEN = 31;
    protected IWorkerContext context;
    protected XSSFWorkbook wb = new XSSFWorkbook();
    protected Map<String, CellStyle> styles;
    protected DataRenderer dr;
    private Map<String, Sheet> sheetNames = new HashMap<String, Sheet>();

    public SpreadsheetGenerator(IWorkerContext context) {
        this.context = context;
        this.styles = SpreadsheetGenerator.createStyles((Workbook)this.wb);
        this.dr = new DataRenderer(context);
    }

    public void finish(OutputStream outStream) throws IOException {
        this.wb.write(outStream);
        outStream.flush();
        outStream.close();
    }

    protected boolean hasSheet(String name) {
        if (name.length() > 29) {
            name = name.substring(0, 29);
        }
        String s = this.fixSheetNameChars(name);
        return this.sheetNames.containsKey(s);
    }

    protected Sheet getSheet(String name) {
        if (name.length() > 29) {
            name = name.substring(0, 29);
        }
        String s = this.fixSheetNameChars(name);
        return this.sheetNames.get(s);
    }

    protected Sheet makeSheet(String name) {
        Object s;
        if (name.length() > 29) {
            name = name.substring(0, 29);
        }
        if (this.sheetNames.containsKey(s = (name = this.fixSheetNameChars(name)))) {
            int i = 1;
            while (this.sheetNames.containsKey(s = name + " " + Integer.toString(++i))) {
            }
        }
        XSSFSheet res = this.wb.createSheet((String)s);
        this.sheetNames.put((String)s, (Sheet)res);
        return res;
    }

    private String fixSheetNameChars(String name) {
        StringBuilder b = new StringBuilder();
        block3: for (char ch : name.toCharArray()) {
            switch (ch) {
                case '*': 
                case '/': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': {
                    b.append('_');
                    continue block3;
                }
                default: {
                    b.append(ch);
                }
            }
        }
        return b.toString();
    }

    private static Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        Font headerFont = wb.createFont();
        headerFont.setBold(true);
        CellStyle style = SpreadsheetGenerator.createBorderedStyle(wb);
        style.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setWrapText(true);
        style.setFont(headerFont);
        styles.put("header", style);
        style = SpreadsheetGenerator.createBorderedStyle(wb);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setWrapText(true);
        styles.put("body", style);
        return styles;
    }

    private static CellStyle createBorderedStyle(Workbook wb) {
        BorderStyle thin = BorderStyle.THIN;
        short black = IndexedColors.GREY_50_PERCENT.getIndex();
        CellStyle style = wb.createCellStyle();
        style.setBorderRight(thin);
        style.setRightBorderColor(black);
        style.setBorderBottom(thin);
        style.setBottomBorderColor(black);
        style.setBorderLeft(thin);
        style.setLeftBorderColor(black);
        style.setBorderTop(thin);
        style.setTopBorderColor(black);
        return style;
    }

    protected void addCell(Row row, int pos, String content) {
        this.addCell(row, pos, content, this.styles.get("body"));
    }

    protected void addCell(Row row, int pos, boolean b) {
        this.addCell(row, pos, b ? "Y" : "");
    }

    protected void addCell(Row row, int pos, int content) {
        this.addCell(row, pos, Integer.toString(content));
    }

    protected void addCell(Row row, int pos, String content, CellStyle style) {
        Cell cell = row.createCell(pos);
        cell.setCellValue(content);
        cell.setCellStyle(style);
    }

    protected int columnPixels(double columns) {
        double WIDTH_FACTOR = 256.0;
        double PADDING = 180.0;
        return (int)Math.floor(columns * WIDTH_FACTOR + PADDING);
    }

    protected void addHeaders(Sheet sheet, String ... titles) {
        Row headerRow = sheet.createRow(sheet.getRow(0) == null ? 0 : sheet.getLastRowNum() + 1);
        for (int i = 0; i < titles.length; ++i) {
            this.addCell(headerRow, i, titles[i], this.styles.get("header"));
        }
    }

    protected void addRow(Sheet sheet, String ... values) {
        Row row = sheet.createRow(sheet.getLastRowNum() + 1);
        for (int i = 0; i < values.length; ++i) {
            this.addCell(row, i, values[i], this.styles.get("body"));
        }
    }

    public void dump() {
        this.wb = null;
        this.styles = null;
        this.dr = null;
        this.sheetNames = null;
    }
}

