/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.DataRenderer;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class ElementTable {
    private RenderingContext context;
    private List<TableGroup> groups;
    private DataRenderer dr;
    private boolean replaceCardinality;

    public ElementTable(RenderingContext context, List<TableGroup> groups, DataRenderer dr, boolean replaceCardinality) {
        this.context = context;
        this.groups = groups;
        this.dr = dr;
        this.replaceCardinality = replaceCardinality;
    }

    public void build(HierarchicalTableGenerator gen, HierarchicalTableGenerator.TableModel table) throws FHIRFormatError, DefinitionException, IOException {
        Collections.sort(this.groups, new TableGroupSorter());
        table.setBorder(true);
        table.setShowHeadings(false);
        for (TableGroup grp : this.groups) {
            if (grp.getElements().size() <= 0 && !grp.buildIfEmpty) continue;
            this.renderGroup(gen, table, grp);
        }
    }

    private void renderGroup(HierarchicalTableGenerator gen, HierarchicalTableGenerator.TableModel table, TableGroup grp) throws FHIRFormatError, DefinitionException, IOException {
        HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
        table.getRows().add(row);
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, grp.getName(), null, null);
        row.getCells().add(cell);
        cell.span(3);
        row.setColor("#dfdfdf");
        cell.addStyle("vertical-align: middle");
        cell.addStyle("font-weight: bold");
        cell.addStyle("font-size: 14px");
        cell.addStyle("padding-top: 10px");
        cell.addStyle("padding-bottom: 10px");
        boolean first = true;
        for (TableElement e : grp.elements) {
            this.renderElement(gen, row.getSubRows(), e, first);
            first = false;
        }
    }

    private void renderElement(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, TableElement e, boolean first) throws FHIRFormatError, DefinitionException, IOException {
        HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
        rows.add(row);
        if (!first) {
            row.setTopLine("silver");
        }
        this.renderElementIdentity(gen, row, e);
        this.renderElementDefinition(gen, row, e);
        this.renderElementConstraints(gen, row, e);
        for (TableElement child : e.getChildElements()) {
            this.renderElement(gen, row.getSubRows(), child, false);
        }
    }

    public void renderElementIdentity(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, TableElement e) {
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(gen);
        cell.addCellStyle("min-width: 220px");
        row.getCells().add(cell);
        cell.setInnerTable(true);
        cell.addText(e.getName()).addStyle("font-weight: bold");
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
        if (!this.replaceCardinality) {
            cell.addText("Cardinality: " + e.min + ".." + e.max);
        } else if ("1".equals(e.min) && "1".equals(e.max)) {
            cell.addText("Required");
        } else if ("0".equals(e.min) && "*".equals(e.max)) {
            cell.addText("Optional, Repeating");
        } else if ("0".equals(e.min) && "1".equals(e.max)) {
            cell.addText("Optional");
        } else if ("1".equals(e.min) && "*".equals(e.max)) {
            cell.addText("Repeating");
        } else {
            cell.addText("Cardinality: " + e.min + ".." + e.max);
        }
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, "br"));
        cell.addImg(e.getTypeIcon(), e.getTypeHint(), e.getTypeLink());
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, e.getTypeLink(), " " + e.getTypeName(), e.getTypeHint()));
    }

    public void renderElementConstraints(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, TableElement e) throws FHIRFormatError, DefinitionException, IOException {
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(gen);
        cell.addCellStyle("min-width: 300px");
        row.getCells().add(cell);
        XhtmlNode div = new XhtmlNode(NodeType.Element, "div");
        Collections.sort(e.getConstraints(), new ConstraintsSorter());
        boolean first = true;
        for (TableElementConstraint c : e.getConstraints()) {
            if (first) {
                first = false;
            } else {
                div.br();
            }
            switch (c.type) {
                case BINDING: {
                    this.renderBindingConstraint(div, c);
                    break;
                }
                case CHOICE: {
                    this.renderChoiceConstraint(div, c);
                    break;
                }
                case FIXED: {
                    this.renderValueConstraint(div, c);
                    break;
                }
                case MAXLENGTH: {
                    this.renderValueConstraint(div, c);
                    break;
                }
                case PATTERN: {
                    this.renderValueConstraint(div, c);
                    break;
                }
                case PROFILE: {
                    this.renderListConstraint(div, c);
                    break;
                }
                case RANGE: {
                    this.renderRangeConstraint(div, c);
                    break;
                }
                case TARGET: {
                    this.renderListConstraint(div, c);
                    break;
                }
                case CARDINALITY: {
                    this.renderCardinalityConstraint(div, c);
                    break;
                }
            }
        }
        cell.addXhtml(div);
    }

    private void renderBindingConstraint(XhtmlNode x, TableElementConstraint c) {
        String name = c.path == null ? "value" : c.path;
        x.code().tx(name);
        this.renderBinding(x, c, " is bound to ");
    }

    private void renderBinding(XhtmlNode x, TableElementConstraint c, String phrase) {
        ValueSet vs = this.context.getContext().findTxResource(ValueSet.class, c.valueSet);
        if (vs == null) {
            x.tx(phrase + "an unknown valueset ");
            x.code().tx(c.valueSet);
        } else {
            x.tx(phrase);
            x.ah(vs.getWebPath()).tx(vs.present());
            try {
                ValueSetExpansionOutcome exp = this.context.getContext().expandVS(vs, true, false);
                if (!exp.isOk()) {
                    x.span().attribute("title", exp.getError()).tx(" (??)");
                } else if (exp.getValueset().getExpansion().getContains().size() == 1000) {
                    x.tx(" (>1000 codes)");
                } else if (exp.getValueset().getExpansion().getContains().size() > 6) {
                    x.tx(" (" + exp.getValueset().getExpansion().getContains().size() + " codes)");
                } else {
                    x.tx(".  Codes:");
                    XhtmlNode ul = x.ul();
                    for (ValueSet.ValueSetExpansionContainsComponent cc : exp.getValueset().getExpansion().getContains()) {
                        String url = cc.hasSystem() && cc.hasCode() ? this.dr.getLinkForCode(cc.getSystem(), cc.getVersion(), cc.getCode()) : null;
                        XhtmlNode li = ul.li();
                        li.ahOrNot(url).tx(this.dr.displayCodeSource(cc.getSystem(), cc.getVersion()) + ": " + cc.getCode());
                        if (!cc.hasDisplay()) continue;
                        li.tx(" \"" + cc.getDisplay() + "\"");
                    }
                }
            }
            catch (Exception e) {
                x.span().attribute("title", e.getMessage()).tx(" (??)");
            }
        }
    }

    private void renderChoiceConstraint(XhtmlNode x, TableElementConstraint c) {
        String name = c.path == null ? "value" : c.path;
        x.code().tx(name);
        x.tx(" is a choice of:");
        XhtmlNode ul = x.ul();
        for (ElementDefinition.TypeRefComponent tr : c.types) {
            StructureDefinition sd;
            if (tr.hasProfile()) {
                for (CanonicalType ct : tr.getProfile()) {
                    StructureDefinition sd2 = this.context.getContext().fetchTypeDefinition(ct.primitiveValue());
                    if (sd2 == null || !sd2.hasWebPath()) {
                        ul.li().ah(ct.primitiveValue()).tx(ct.primitiveValue());
                        continue;
                    }
                    ul.li().ah(sd2.getWebPath()).tx(sd2.present());
                }
                continue;
            }
            if (tr.hasTarget()) {
                sd = this.context.getContext().fetchTypeDefinition(tr.getWorkingCode());
                XhtmlNode li = ul.li();
                li.ah(sd.getWebPath()).tx(sd.present());
                li.tx(" pointing to ");
                this.renderTypeList(x, tr.getTargetProfile());
                continue;
            }
            sd = this.context.getContext().fetchTypeDefinition(tr.getWorkingCode());
            if (sd == null || !sd.hasWebPath()) {
                ul.li().code().tx(tr.getWorkingCode());
                continue;
            }
            ul.li().ah(sd.getWebPath()).tx(sd.present());
        }
    }

    private void renderValueConstraint(XhtmlNode x, TableElementConstraint c) throws FHIRFormatError, DefinitionException, IOException {
        String name = c.path == null ? "value" : c.path;
        x.code().tx(name);
        switch (c.type) {
            case FIXED: {
                x.tx(" is fixed to ");
                break;
            }
            case MAXLENGTH: {
                x.tx(" is limited  in length to ");
                break;
            }
            case PATTERN: {
                if (c.value.isPrimitive()) {
                    x.tx(" is fixed to ");
                    break;
                }
                x.tx(" must match ");
                break;
            }
        }
        this.renderValue(x, c.value);
        if (c.strength != null && c.valueSet != null) {
            this.renderBinding(x, c, " from ");
        }
    }

    public void renderValue(XhtmlNode x, DataType v) throws IOException {
        if (v.isPrimitive()) {
            String s = v.primitiveValue();
            if (Utilities.isAbsoluteUrl((String)s)) {
                Resource res = this.context.getContext().fetchResource(Resource.class, s);
                if (res != null && res.hasWebPath()) {
                    x.ah(res.getWebPath()).tx(res instanceof CanonicalResource ? ((CanonicalResource)res).present() : s);
                } else if (Utilities.isAbsoluteUrlLinkable((String)s)) {
                    x.ah(s).code().tx(s);
                } else {
                    x.code().tx(s);
                }
            } else {
                x.code().tx(s);
            }
        } else if (v instanceof Quantity) {
            this.genQuantity(x, (Quantity)v);
        } else if (v instanceof Coding) {
            this.genCoding(x, (Coding)v);
        } else if (v instanceof CodeableConcept) {
            this.genCodeableConcept(x, (CodeableConcept)v);
        } else {
            this.dr.renderBase(new Renderer.RenderingStatus(), x, v);
        }
    }

    private void genCodeableConcept(XhtmlNode div, CodeableConcept cc) {
        boolean first = true;
        for (Coding c : cc.getCoding()) {
            if (first) {
                first = false;
            } else {
                div.tx(",");
            }
            this.genCoding(div, c);
        }
        if (cc.hasText()) {
            div.code().tx(" \"" + cc.getText() + "\"");
        }
    }

    public void genQuantity(XhtmlNode div, Quantity q) {
        String url = q.hasSystem() && q.hasUnit() ? this.dr.getLinkForCode(q.getSystem(), null, q.getCode()) : null;
        XhtmlNode code = div.code();
        if (q.hasComparator()) {
            code.tx(q.getComparator().toCode());
        }
        code.tx(q.getValueElement().asStringValue());
        code.ahOrNot(url).tx(q.getUnit());
    }

    public void genCoding(XhtmlNode div, Coding c) {
        String url = c.hasSystem() && c.hasCode() ? this.dr.getLinkForCode(c.getSystem(), c.getVersion(), c.getCode()) : null;
        XhtmlNode code = div.code();
        code.ahOrNot(url).tx(this.dr.displayCodeSource(c.getSystem(), c.getVersion()) + ": " + c.getCode());
        if (c.hasDisplay()) {
            code.tx(" \"" + c.getDisplay() + "\"");
        } else {
            String s = this.dr.lookupCode(c.getSystem(), c.getVersion(), c.getCode());
            if (s != null) {
                div.span().style("opacity: 0.5").tx("(\"" + s + "\")");
            }
        }
    }

    private void renderRangeConstraint(XhtmlNode x, TableElementConstraint c) throws IOException {
        String name;
        String string = name = c.path == null ? "value" : c.path;
        if (c.value != null && c.value2 != null) {
            x.tx(name + " between ");
            this.renderValue(x, c.value);
            x.tx(" and ");
            this.renderValue(x, c.value2);
        } else if (c.value != null) {
            x.tx(name + " more than ");
            this.renderValue(x, c.value);
        } else {
            x.tx(name + " less than ");
            this.renderValue(x, c.value2);
        }
    }

    private void renderCardinalityConstraint(XhtmlNode x, TableElementConstraint c) throws IOException {
        String name = c.path == null ? "value" : c.path;
        x.code().tx(name);
        String min = c.value.primitiveValue();
        String max = c.value2.primitiveValue();
        if (!this.replaceCardinality) {
            x.tx("has cardinality: " + min + ".." + max);
        } else if ("1".equals(min) && "1".equals(max)) {
            x.tx("is required");
        } else if ("0".equals(min) && "*".equals(max)) {
            x.tx("is Optional and repeats");
        } else if ("0".equals(min) && "1".equals(max)) {
            x.tx("is Optional");
        } else if ("1".equals(min) && "*".equals(max)) {
            x.tx("repeats");
        } else {
            x.tx("has cardinality: " + min + ".." + max);
        }
    }

    private void renderListConstraint(XhtmlNode x, TableElementConstraint c) {
        String name = c.path == null ? "value" : c.path;
        x.code().tx(name);
        switch (c.type) {
            case PROFILE: {
                x.tx(" must be ");
                break;
            }
            case TARGET: {
                x.tx(" must point to ");
                break;
            }
        }
        this.renderTypeList(x, c.list);
    }

    private void renderTypeList(XhtmlNode x, List<CanonicalType> list) {
        if (list.size() == 1) {
            x.tx("a ");
        } else {
            x.tx("one of ");
        }
        boolean first = true;
        for (int i = 0; i < list.size(); ++i) {
            if (first) {
                first = false;
            } else if (i == list.size() - 1) {
                x.tx(" or ");
            } else {
                x.tx(", ");
            }
            String s = list.get(i).primitiveValue();
            Resource res = this.context.getContext().fetchResource(Resource.class, s);
            if (res != null && res.hasWebPath()) {
                x.ah(res.getWebPath()).tx(res instanceof CanonicalResource ? ((CanonicalResource)res).present() : s);
                continue;
            }
            x.ah(s).tx(s);
        }
    }

    public void renderElementDefinition(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, TableElement e) {
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(gen);
        row.getCells().add(cell);
        for (TableElementDefinition d : e.definitions) {
            if (d.getType() == TableElementDefinitionType.DEFINITION) {
                cell.addMarkdown(d.getMarkdown());
                continue;
            }
            if (d.getType() != TableElementDefinitionType.COMMENT) continue;
            cell.addMarkdown("Comment: " + d.getMarkdown(), "font-style: italic");
        }
    }

    private void renderElementInvariants(XhtmlNode td, TableElement e) {
        XhtmlNode ul = td.ul();
        for (TableElementInvariant t : e.invariants) {
            XhtmlNode li = ul.li();
            li.tx(t.level + ": " + t.human);
            li.tx(" ");
            li.code().tx(t.other != null ? t.other : t.fhirPath);
        }
    }

    public static class TableGroupSorter
    implements Comparator<TableGroup> {
        @Override
        public int compare(TableGroup o1, TableGroup o2) {
            if (o1.priorty == o2.priorty) {
                return Integer.compare(o1.counter, o2.counter);
            }
            return Integer.compare(o2.priorty, o1.priorty);
        }
    }

    public static class TableGroup {
        private String name;
        private String documentation;
        private boolean buildIfEmpty;
        private String emptyNote;
        private List<TableElement> elements = new ArrayList<TableElement>();
        private int priorty;
        private int counter;
        private ElementTableGrouping definition;

        public TableGroup(int counter, ElementTableGrouping definition) {
            this.counter = counter;
            this.definition = definition;
            this.name = definition.getName();
            this.priorty = definition.getPriority();
            this.buildIfEmpty = false;
        }

        public String getName() {
            return this.name;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public boolean isBuildIfEmpty() {
            return this.buildIfEmpty;
        }

        public String getEmptyNote() {
            return this.emptyNote;
        }

        public List<TableElement> getElements() {
            return this.elements;
        }

        public int getPriorty() {
            return this.priorty;
        }

        public int getCounter() {
            return this.counter;
        }

        public ElementTableGrouping getDefinition() {
            return this.definition;
        }
    }

    public static class TableElement {
        private String path;
        private String name;
        private String min;
        private String max;
        private String typeName;
        private String typeIcon;
        private String typeLink;
        private String typeHint;
        private List<TableElementDefinition> definitions = new ArrayList<TableElementDefinition>();
        private List<TableElementConstraint> constraints = new ArrayList<TableElementConstraint>();
        private List<TableElementInvariant> invariants = new ArrayList<TableElementInvariant>();
        private List<TableElement> childElements = new ArrayList<TableElement>();

        public TableElement(String path, String name, String min, String max) {
            this.path = path;
            this.name = name;
            this.min = min;
            this.max = max;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public String getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getTypeIcon() {
            return this.typeIcon;
        }

        public String getTypeLink() {
            return this.typeLink;
        }

        public String getTypeHint() {
            return this.typeHint;
        }

        public List<TableElementDefinition> getDefinitions() {
            return this.definitions;
        }

        public List<TableElementConstraint> getConstraints() {
            return this.constraints;
        }

        public List<TableElementInvariant> getInvariants() {
            return this.invariants;
        }

        public List<TableElement> getChildElements() {
            return this.childElements;
        }

        public TableElement setPath(String path) {
            this.path = path;
            return this;
        }

        public TableElement setName(String name) {
            this.name = name;
            return this;
        }

        public TableElement setMin(String min) {
            this.min = min;
            return this;
        }

        public TableElement setMax(String max) {
            this.max = max;
            return this;
        }

        public void setType(String name, String link, String hint, String icon) {
            this.typeName = name;
            this.typeIcon = icon;
            this.typeLink = link;
            this.typeHint = hint;
        }
    }

    public class ConstraintsSorter
    implements Comparator<TableElementConstraint> {
        @Override
        public int compare(TableElementConstraint o1, TableElementConstraint o2) {
            int r = StringUtils.compare((String)o1.path, (String)o2.path);
            return r == 0 ? o1.type.compareTo(o2.type) : r;
        }
    }

    public static class TableElementConstraint {
        private TableElementConstraintType type;
        private DataType value;
        private DataType value2;
        private String path;
        private Enumerations.BindingStrength strength;
        private String valueSet;
        private List<ElementDefinition.TypeRefComponent> types;
        private List<CanonicalType> list;

        public static TableElementConstraint makeValue(TableElementConstraintType type, String path, DataType value) {
            TableElementConstraint self = new TableElementConstraint();
            self.type = type;
            self.path = path;
            self.value = value;
            return self;
        }

        public static TableElementConstraint makeValueVS(TableElementConstraintType type, String path, DataType value, Enumerations.BindingStrength strength, String valueSet) {
            TableElementConstraint self = new TableElementConstraint();
            self.type = type;
            self.path = path;
            self.value = value;
            self.strength = strength;
            self.valueSet = valueSet;
            return self;
        }

        public static TableElementConstraint makeRange(TableElementConstraintType type, String path, DataType value, DataType value2) {
            TableElementConstraint self = new TableElementConstraint();
            self.type = type;
            self.path = path;
            self.value = value;
            self.value2 = value2;
            return self;
        }

        public static TableElementConstraint makeBinding(TableElementConstraintType type, String path, Enumerations.BindingStrength strength, String valueSet) {
            TableElementConstraint self = new TableElementConstraint();
            self.type = type;
            self.path = path;
            self.strength = strength;
            self.valueSet = valueSet;
            return self;
        }

        public static TableElementConstraint makeTypes(TableElementConstraintType type, String path, List<ElementDefinition.TypeRefComponent> types) {
            TableElementConstraint self = new TableElementConstraint();
            self.type = type;
            self.path = path;
            self.types = types;
            return self;
        }

        public static TableElementConstraint makeList(TableElementConstraintType type, String path, List<CanonicalType> list) {
            TableElementConstraint self = new TableElementConstraint();
            self.type = type;
            self.path = path;
            self.list = list;
            return self;
        }
    }

    public static enum TableElementConstraintType {
        CHOICE,
        PROFILE,
        TARGET,
        BINDING,
        RANGE,
        FIXED,
        PATTERN,
        MAXLENGTH,
        CARDINALITY;

    }

    public static class TableElementDefinition {
        private TableElementDefinitionType type;
        private String markdown;

        public TableElementDefinition(TableElementDefinitionType type, String markdown) {
            this.type = type;
            this.markdown = markdown;
        }

        public TableElementDefinitionType getType() {
            return this.type;
        }

        public String getMarkdown() {
            return this.markdown;
        }
    }

    public static enum TableElementDefinitionType {
        DEFINITION,
        COMMENT,
        REQUIREMENTS;

    }

    public static class TableElementInvariant {
        private String level;
        private String human;
        private String fhirPath;
        private String other;
        private String otherFormat;
    }

    public static class HintDrivenGroupingEngine
    extends ElementTableGroupingEngine {
        private List<ElementDefinition> list;

        public HintDrivenGroupingEngine(List<ElementDefinition> list) {
            this.list = list;
        }

        @Override
        public ElementTableGroupingState groupState(ElementDefinition ed) {
            if (ed.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/view-hint")) {
                List<Extension> exl = ed.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/view-hint");
                for (Extension ex : exl) {
                    if (!"element-view-group".equals(ex.getExtensionString("name"))) continue;
                    return ElementTableGroupingState.DEFINES_GROUP;
                }
            }
            return ElementTableGroupingState.UNKNOWN;
        }

        @Override
        public ElementTableGrouping getGroup(ElementDefinition ed) {
            if (ed.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/view-hint")) {
                String n = null;
                int order = 0;
                List<Extension> exl = ed.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/view-hint");
                for (Extension ex : exl) {
                    if ("element-view-group".equals(ex.getExtensionString("name"))) {
                        n = ex.getExtensionString("value");
                    }
                    if (!"element-view-order".equals(ex.getExtensionString("name"))) continue;
                    order = ToolingExtensions.readIntegerExtension(ex, "value", 0);
                }
                if (n != null) {
                    return new ElementTableGrouping(ed.getName().hashCode(), n, order);
                }
            }
            return null;
        }
    }

    public static class JsonDrivenGroupingEngine
    extends ElementTableGroupingEngine {
        private JsonArray groups;

        public JsonDrivenGroupingEngine(JsonArray groups) {
            this.groups = groups;
        }

        @Override
        public ElementTableGroupingState groupState(ElementDefinition ed) {
            String name = ed.getName();
            for (JsonObject o : this.groups.asJsonObjects()) {
                if (!this.nameMatches(name, o.getStrings("elements"))) continue;
                return ElementTableGroupingState.IN_GROUP;
            }
            for (JsonObject o : this.groups.asJsonObjects()) {
                if (!o.asBoolean("all")) continue;
                return ElementTableGroupingState.IN_GROUP;
            }
            return ElementTableGroupingState.UNKNOWN;
        }

        @Override
        public ElementTableGrouping getGroup(ElementDefinition ed) {
            String name = ed.getName();
            int c = 0;
            for (JsonObject o : this.groups.asJsonObjects()) {
                ++c;
                if (!this.nameMatches(name, o.getStrings("elements"))) continue;
                return new ElementTableGrouping(c, o.asString("name"), this.groups.size() - c);
            }
            c = 0;
            for (JsonObject o : this.groups.asJsonObjects()) {
                ++c;
                if (!o.asBoolean("all")) continue;
                return new ElementTableGrouping(c, o.asString("name"), this.groups.size() - c);
            }
            return null;
        }
    }

    public static abstract class ElementTableGroupingEngine {
        public abstract ElementTableGroupingState groupState(ElementDefinition var1);

        public abstract ElementTableGrouping getGroup(ElementDefinition var1);

        protected boolean nameMatches(String name, List<String> strings) {
            for (String s : strings) {
                if (!this.nameMatches(name, s)) continue;
                return true;
            }
            return false;
        }

        public boolean nameMatches(String name, String test) {
            if (test.equals(name)) {
                return true;
            }
            return test.endsWith("[x]") && name.startsWith(test.substring(0, test.length() - 3));
        }
    }

    public static enum ElementTableGroupingState {
        UNKNOWN,
        DEFINES_GROUP,
        IN_GROUP;

    }

    public static class ElementTableGrouping {
        private long key;
        private String name;
        private int priority;

        public ElementTableGrouping(long key, String name, int priority) {
            this.key = key;
            this.name = name;
            this.priority = priority;
        }

        public String getName() {
            return this.name;
        }

        public int getPriority() {
            return this.priority;
        }

        public long getKey() {
            return this.key;
        }
    }
}

