/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.terminologies.client.ITerminologyClient;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyCache;
import org.hl7.fhir.utilities.ENoDump;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.VersionUtilities;

@MarkedToMoveToAdjunctPackage
public class TerminologyClientContext {
    private static final String MIN_TEST_VERSION = "1.6.0";
    private static boolean allowNonConformantServers = false;
    private static boolean canAllowNonConformantServers = false;
    private static boolean canUseCacheId;
    private ITerminologyClient client;
    private boolean initialised = false;
    private CapabilityStatement capabilitiesStatement;
    private TerminologyCapabilities txcaps;
    private TerminologyCache txCache;
    private Map<String, TerminologyClientContextUseCount> useCounts = new HashMap<String, TerminologyClientContextUseCount>();
    private boolean isTxCaching;
    private final Set<String> cached = new HashSet<String>();
    private boolean master;
    private String cacheId;

    protected TerminologyClientContext(ITerminologyClient client, String cacheId, boolean master) {
        this.client = client;
        this.cacheId = cacheId;
        this.master = master;
    }

    public Map<String, TerminologyClientContextUseCount> getUseCounts() {
        return this.useCounts;
    }

    public boolean isMaster() {
        return this.master;
    }

    public ITerminologyClient getClient() {
        return this.client;
    }

    public void seeUse(Set<String> systems, TerminologyClientContextUseType useType) {
        if (systems != null) {
            for (String s : systems) {
                this.seeUse(s, useType);
            }
        }
    }

    public void seeUse(String s, TerminologyClientContextUseType useType) {
        TerminologyClientContextUseCount uc = this.useCounts.get(s);
        if (uc == null) {
            uc = new TerminologyClientContextUseCount();
            this.useCounts.put(s, uc);
        }
        switch (useType) {
            case expand: {
                ++uc.expands;
                break;
            }
            case readVS: {
                ++uc.readVS;
                break;
            }
            case readCS: {
                ++uc.readCS;
                break;
            }
            case validate: {
                ++uc.validates;
                break;
            }
        }
    }

    public TerminologyCapabilities getTxCapabilities() {
        return this.txcaps;
    }

    public void setTxCapabilities(TerminologyCapabilities txcaps) {
        this.txcaps = txcaps;
    }

    public Set<String> getCached() {
        return this.cached;
    }

    public boolean alreadyCached(CanonicalResource cr) {
        return this.cached.contains(cr.getVUrl());
    }

    public void addToCache(CanonicalResource cr) {
        this.cached.add(cr.getVUrl());
    }

    public String getAddress() {
        return this.client.getAddress();
    }

    public int getUseCount() {
        return this.getClient().getUseCount();
    }

    public boolean isTxCaching() {
        return this.isTxCaching;
    }

    public void setTxCaching(boolean isTxCaching) {
        this.isTxCaching = isTxCaching;
    }

    public boolean usingCache() {
        return this.isTxCaching && this.cacheId != null;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public TerminologyCache getTxCache() {
        return this.txCache;
    }

    public void setTxCache(TerminologyCache txCache) {
        this.txCache = txCache;
    }

    public void initialize() throws IOException {
        if (!this.initialised) {
            this.capabilitiesStatement = this.client.getCapabilitiesStatement();
            this.checkFeature();
            if (this.txCache != null && this.txCache.hasTerminologyCapabilities(this.getAddress())) {
                this.txcaps = this.txCache.getTerminologyCapabilities(this.getAddress());
                if (this.txcaps.getSoftware().hasVersion() && !this.txcaps.getSoftware().getVersion().equals(this.capabilitiesStatement.getSoftware().getVersion())) {
                    this.txcaps = null;
                }
            }
            if (this.txcaps == null) {
                this.txcaps = this.client.getTerminologyCapabilities();
                if (this.txCache != null) {
                    this.txCache.cacheTerminologyCapabilities(this.getAddress(), this.txcaps);
                }
            }
            if (this.txcaps != null && canUseCacheId) {
                for (TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent t : this.txcaps.getExpansion().getParameter()) {
                    if (!"cache-id".equals(t.getName())) continue;
                    this.setTxCaching(true);
                    break;
                }
            }
            this.initialised = true;
        }
    }

    private void checkFeature() {
        if (!allowNonConformantServers && this.capabilitiesStatement != null) {
            String testVersion = null;
            boolean csParams = false;
            for (Extension t : this.capabilitiesStatement.getExtension()) {
                if (!"http://hl7.org/fhir/uv/application-feature/StructureDefinition/feature".equals(t.getUrl())) continue;
                String defn = t.getExtensionString("definition");
                if ("http://hl7.org/fhir/uv/tx-tests/FeatureDefinition/test-version".equals(defn)) {
                    testVersion = t.getExtensionString("value");
                    continue;
                }
                if (!"http://hl7.org/fhir/uv/tx-ecosystem/FeatureDefinition/CodeSystemAsParameter".equals(defn)) continue;
                csParams = "true".equals(t.getExtensionString("value"));
            }
            if (testVersion == null) {
                if (canAllowNonConformantServers) {
                    throw new ENoDump("The terminology server " + this.client.getAddress() + " is not approved for use with this software (it does not pass the required tests).\r\nIf you wish to use this server, add the parameter -authorise-non-conformant-tx-servers to the command line parameters");
                }
                throw new ENoDump("The terminology server " + this.client.getAddress() + " is not approved for use with this software (it does not pass the required tests)");
            }
            if (!VersionUtilities.isThisOrLater((String)MIN_TEST_VERSION, testVersion)) {
                if (canAllowNonConformantServers) {
                    throw new ENoDump("The terminology server " + this.client.getAddress() + " is not approved for use with this software as it is too old (test version = " + testVersion + ").\r\nIf you wish to use this server, add the parameter -authorise-non-conformant-tx-servers to the command line parameters");
                }
                throw new ENoDump("The terminology server " + this.client.getAddress() + " is not approved for use with this software as it is too old (test version = " + testVersion + ")");
            }
            if (!csParams) {
                if (canAllowNonConformantServers) {
                    throw new ENoDump("The terminology server " + this.client.getAddress() + " is not approved for use as it does not accept code systems in the tx-resource parameter.\r\nIf you wish to use this server, add the parameter -authorise-non-conformant-tx-servers to the command line parameters");
                }
                throw new ENoDump("The terminology server " + this.client.getAddress() + " is not approved for use as it does not accept code systems in the tx-resource parameter");
            }
        }
    }

    public boolean supportsSystem(String system) throws IOException {
        this.initialize();
        for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent tccs : this.txcaps.getCodeSystem()) {
            if (!system.equals(tccs.getUri())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.client.getAddress();
    }

    public static boolean isCanUseCacheId() {
        return canUseCacheId;
    }

    public static void setCanUseCacheId(boolean canUseCacheId) {
        TerminologyClientContext.canUseCacheId = canUseCacheId;
    }

    public String getHost() {
        try {
            URL uri = new URL(this.getAddress());
            return uri.getHost();
        }
        catch (MalformedURLException e) {
            return this.getAddress();
        }
    }

    public static boolean isAllowNonConformantServers() {
        return allowNonConformantServers;
    }

    public static void setAllowNonConformantServers(boolean allowNonConformantServers) {
        TerminologyClientContext.allowNonConformantServers = allowNonConformantServers;
    }

    public static boolean isCanAllowNonConformantServers() {
        return canAllowNonConformantServers;
    }

    public static void setCanAllowNonConformantServers(boolean canAllowNonConformantServers) {
        TerminologyClientContext.canAllowNonConformantServers = canAllowNonConformantServers;
    }

    public static enum TerminologyClientContextUseType {
        expand,
        validate,
        readVS,
        readCS;

    }

    public class TerminologyClientContextUseCount {
        private int expands;
        private int validates;
        private int readVS;
        private int readCS;

        public int getReadVS() {
            return this.readVS;
        }

        public void setReadVS(int readVS) {
            this.readVS = readVS;
        }

        public int getReadCS() {
            return this.readCS;
        }

        public void setReadCS(int readCS) {
            this.readCS = readCS;
        }

        public int getExpands() {
            return this.expands;
        }

        public void setExpands(int expands) {
            this.expands = expands;
        }

        public int getValidates() {
            return this.validates;
        }

        public void setValidates(int validates) {
            this.validates = validates;
        }
    }
}

