/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.client;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.terminologies.client.ITerminologyClient;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientContext;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyCache;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;

@MarkedToMoveToAdjunctPackage
public class TerminologyClientManager {
    public static final String UNRESOLVED_VALUESET = "--unknown--";
    private static final boolean IGNORE_TX_REGISTRY = false;
    private ITerminologyClientFactory factory;
    private String cacheId;
    private List<TerminologyClientContext> serverList = new ArrayList<TerminologyClientContext>();
    private Map<String, TerminologyClientContext> serverMap = new HashMap<String, TerminologyClientContext>();
    private Map<String, ServerOptionList> resMap = new HashMap<String, ServerOptionList>();
    private List<InternalLogEvent> internalLog = new ArrayList<InternalLogEvent>();
    protected Parameters expParameters;
    private TerminologyCache cache;
    private File cacheFile;
    private String usage;
    private String monitorServiceURL;
    private boolean useEcosystem;
    private ILoggingService logger;
    private int ecosystemfailCount;

    public ITerminologyClientFactory getFactory() {
        return this.factory;
    }

    public TerminologyClientManager(ITerminologyClientFactory factory, String cacheId, ILoggingService logger) {
        this.factory = factory;
        this.cacheId = cacheId;
        this.logger = logger;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public void copy(TerminologyClientManager other) {
        this.cacheId = other.cacheId;
        this.serverList.addAll(other.serverList);
        this.serverMap.putAll(other.serverMap);
        this.resMap.putAll(other.resMap);
        this.useEcosystem = other.useEcosystem;
        this.monitorServiceURL = other.monitorServiceURL;
        this.factory = other.factory;
        this.usage = other.usage;
        this.internalLog = other.internalLog;
    }

    public TerminologyClientContext chooseServer(ValueSet vs, Set<String> systems, boolean expand) throws TerminologyServiceException {
        boolean ok;
        if (this.serverList.isEmpty()) {
            return null;
        }
        if (systems.contains(UNRESOLVED_VALUESET) || systems.isEmpty()) {
            return this.serverList.get(0);
        }
        ArrayList<ServerOptionList> choices = new ArrayList<ServerOptionList>();
        for (String string : systems) {
            choices.add(this.findServerForSystem(string, expand));
        }
        for (ServerOptionList serverOptionList : choices) {
            for (String s : serverOptionList.authoritative) {
                ok = true;
                for (ServerOptionList t : choices) {
                    if (t.authoritative.contains(s)) continue;
                    ok = false;
                }
                if (!ok) continue;
                this.log(vs, s, systems, choices, "Found authoritative server " + s);
                return this.findClient(s, systems, expand);
            }
        }
        for (ServerOptionList serverOptionList : choices) {
            for (String s : serverOptionList.authoritative) {
                ok = true;
                for (ServerOptionList t : choices) {
                    if (t.authoritative.contains(s) || t.candidates.contains(s)) continue;
                    ok = false;
                }
                if (!ok) continue;
                this.log(vs, s, systems, choices, "Found partially authoritative server " + s);
                return this.findClient(s, systems, expand);
            }
        }
        for (ServerOptionList serverOptionList : choices) {
            for (String s : serverOptionList.candidates) {
                ok = true;
                for (ServerOptionList t : choices) {
                    if (t.candidates.contains(s)) continue;
                    ok = false;
                }
                if (!ok) continue;
                this.log(vs, s, systems, choices, "Found candidate server " + s);
                return this.findClient(s, systems, expand);
            }
        }
        for (String string : systems) {
            String uri;
            String string2 = uri = string.contains("|") ? string.substring(0, string.indexOf("|")) : string;
            if (!Utilities.existsInList((String)uri, (String[])new String[]{"http://unitsofmeasure.org", "http://loinc.org", "http://snomed.info/sct", "http://www.nlm.nih.gov/research/umls/rxnorm", "http://hl7.org/fhir/sid/cvx", "urn:ietf:bcp:13", "urn:ietf:bcp:47", "urn:ietf:rfc:3986", "http://www.ama-assn.org/go/cpt", "urn:oid:1.2.36.1.2001.1005.17", "urn:iso:std:iso:3166", "http://varnomen.hgvs.org", "http://unstats.un.org/unsd/methods/m49/m49.htm", "urn:iso:std:iso:4217", "http://hl7.org/fhir/sid/ndc", "http://fhir.ohdsi.org/CodeSystem/concepts", "http://fdasis.nlm.nih.gov", "https://www.usps.com/"})) continue;
            this.log(vs, this.serverList.get(0).getAddress(), systems, choices, "Use primary server for " + uri);
            return this.serverList.get(0);
        }
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (ServerOptionList ol : choices) {
            for (String s : ol.authoritative) {
                counts.put(s, counts.getOrDefault(s, 0) + 1);
            }
        }
        String string = counts.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
        if (string != null) {
            this.log(vs, string, systems, choices, "Found most authoritative server " + string);
            return this.findClient(string, systems, expand);
        }
        if (vs != null) {
            if (vs.hasUserData("External.Link")) {
                String el = vs.getUserString("External.Link");
                if ("https://vsac.nlm.nih.gov".equals(el)) {
                    el = this.getMaster().getAddress();
                }
                if (systems.size() == 1) {
                    this.log(vs, el, systems, choices, "Not handled by any servers. Using source @ '" + el + "'");
                } else {
                    this.log(vs, el, systems, choices, "Handled by multiple servers. Using source @ '" + el + "'");
                }
                return this.findClient(el, systems, expand);
            }
            if (systems.size() == 1) {
                this.log(vs, this.serverList.get(0).getAddress(), systems, choices, "System not handled by any servers. Using primary server");
            } else {
                this.log(vs, this.serverList.get(0).getAddress(), systems, choices, "Systems handled by multiple servers. Using primary server");
            }
            return this.findClient(this.serverList.get(0).getAddress(), systems, expand);
        }
        if (systems.size() == 1) {
            this.log(vs, this.serverList.get(0).getAddress(), systems, choices, "System not handled by any servers. Using primary server");
        } else {
            this.log(vs, this.serverList.get(0).getAddress(), systems, choices, "Systems handled by multiple servers. Using primary server");
        }
        this.log(vs, this.serverList.get(0).getAddress(), systems, choices, "Fallback: primary server");
        return this.findClient(this.serverList.get(0).getAddress(), systems, expand);
    }

    public TerminologyClientContext chooseServer(String vs, boolean expand) throws TerminologyServiceException {
        if (this.serverList.isEmpty()) {
            return null;
        }
        if (!this.useEcosystem) {
            return this.findClient(this.getMasterClient().getAddress(), null, expand);
        }
        Object request = Utilities.pathURL((String[])new String[]{this.monitorServiceURL, "resolve?fhirVersion=" + this.factory.getVersion() + "&valueSet=" + Utilities.URLEncode((String)vs)});
        if (this.usage != null) {
            request = (String)request + "&usage=" + this.usage;
        }
        try {
            JsonObject json = JsonParser.parseObjectFromUrl((String)request);
            Iterator iterator = json.getJsonObjects("authoritative").iterator();
            if (iterator.hasNext()) {
                JsonObject item = (JsonObject)iterator.next();
                return this.findClient(item.asString("url"), null, expand);
            }
            iterator = json.getJsonObjects("candidates").iterator();
            if (iterator.hasNext()) {
                JsonObject item = (JsonObject)iterator.next();
                return this.findClient(item.asString("url"), null, expand);
            }
        }
        catch (Exception e) {
            String msg = "Error resolving valueSet " + vs + ": " + e.getMessage();
            if (!this.hasMessage(msg)) {
                this.internalLog.add(new InternalLogEvent(msg, vs, (String)request));
            }
            this.logger.logDebugMessage(ILoggingService.LogCategory.TX, ExceptionUtils.getStackTrace((Throwable)e));
        }
        return null;
    }

    private void log(ValueSet vs, String server, Set<String> systems, List<ServerOptionList> choices, String message) {
        String sys;
        String svs;
        String string = svs = vs == null ? "null" : vs.getVersionedUrl();
        String string2 = systems.isEmpty() ? "--" : (sys = systems.size() == 1 ? systems.iterator().next() : systems.toString());
        String sch = choices.isEmpty() ? "--" : (choices.size() == 1 ? choices.iterator().next().toString() : choices.toString());
        this.internalLog.add(new InternalLogEvent(message, server, svs, sys, sch));
    }

    private TerminologyClientContext findClient(String server, Set<String> systems, boolean expand) {
        TerminologyClientContext client = this.serverMap.get(server);
        if (client == null) {
            try {
                client = new TerminologyClientContext(this.factory.makeClient("id" + (this.serverList.size() + 1), ManagedWebAccess.makeSecureRef((String)server), this.getMasterClient().getUserAgent(), this.getMasterClient().getLogger()), this.cacheId, false);
            }
            catch (URISyntaxException e) {
                throw new TerminologyServiceException((Throwable)e);
            }
            client.setTxCache(this.cache);
            this.serverList.add(client);
            this.serverMap.put(server, client);
        }
        client.seeUse(systems, expand ? TerminologyClientContext.TerminologyClientContextUseType.expand : TerminologyClientContext.TerminologyClientContextUseType.validate);
        return client;
    }

    private ServerOptionList findServerForSystem(String s, boolean expand) throws TerminologyServiceException {
        ServerOptionList serverList = this.resMap.get(s);
        if (serverList == null) {
            serverList = this.decideWhichServer(s);
            try {
                serverList.replace("tx.fhir.org", this.host());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.save();
        }
        return serverList;
    }

    private String host() throws MalformedURLException {
        URL url = new URL(this.getMasterClient().getAddress());
        if (url.getPort() > 0) {
            return url.getHost() + ":" + url.getPort();
        }
        return url.getHost();
    }

    private ServerOptionList decideWhichServer(String url) {
        if (!this.useEcosystem) {
            return new ServerOptionList(this.getMasterClient().getAddress());
        }
        if (this.expParameters != null) {
            if (!url.contains("|")) {
                for (Parameters.ParametersParameterComponent p : this.expParameters.getParameter()) {
                    if (!Utilities.existsInList((String)p.getName(), (String[])new String[]{"system-version", "force-system-version"}) || !p.hasValuePrimitive() || !p.getValue().primitiveValue().startsWith(url + "|")) continue;
                    url = p.getValue().primitiveValue();
                }
            } else {
                for (Parameters.ParametersParameterComponent p : this.expParameters.getParameter()) {
                    if (!Utilities.existsInList((String)p.getName(), (String[])new String[]{"force-system-version"}) || !p.hasValueCanonicalType() || !p.getValue().primitiveValue().startsWith(url + "|")) continue;
                    url = p.getValue().primitiveValue();
                }
            }
        }
        Object request = Utilities.pathURL((String[])new String[]{this.monitorServiceURL, "resolve?fhirVersion=" + this.factory.getVersion() + "&url=" + Utilities.URLEncode((String)url)});
        if (this.usage != null) {
            request = (String)request + "&usage=" + this.usage;
        }
        try {
            ServerOptionList ret = new ServerOptionList();
            JsonObject json = JsonParser.parseObjectFromUrl((String)request);
            for (JsonObject item : json.getJsonObjects("authoritative")) {
                ret.authoritative.add(item.asString("url"));
            }
            for (JsonObject item : json.getJsonObjects("candidates")) {
                ret.candidates.add(item.asString("url"));
            }
            return ret;
        }
        catch (Exception e) {
            String msg = "Error resolving system " + url + ": " + e.getMessage();
            if (!this.hasMessage(msg)) {
                this.internalLog.add(new InternalLogEvent(msg, url, (String)request));
            }
            this.logger.logDebugMessage(ILoggingService.LogCategory.TX, ExceptionUtils.getStackTrace((Throwable)e));
            return new ServerOptionList(this.getMasterClient().getAddress());
        }
    }

    private boolean hasMessage(String msg) {
        for (InternalLogEvent log : this.internalLog) {
            if (!msg.equals(log.message)) continue;
            return true;
        }
        return false;
    }

    public List<TerminologyClientContext> serverList() {
        return this.serverList;
    }

    public boolean hasClient() {
        return !this.serverList.isEmpty();
    }

    public int getRetryCount() {
        return this.hasClient() ? this.getMasterClient().getRetryCount() : 0;
    }

    public void setRetryCount(int value) {
        if (this.hasClient()) {
            this.getMasterClient().setRetryCount(value);
        }
    }

    public void setUserAgent(String value) {
        if (this.hasClient()) {
            this.getMasterClient().setUserAgent(value);
        }
    }

    public void setLogger(ToolingClientLogger txLog) {
        if (this.hasClient()) {
            this.getMasterClient().setLogger(txLog);
        }
    }

    public TerminologyClientContext setMasterClient(ITerminologyClient client, boolean useEcosystem) {
        this.useEcosystem = useEcosystem;
        TerminologyClientContext details = new TerminologyClientContext(client, this.cacheId, true);
        details.setTxCache(this.cache);
        this.serverList.clear();
        this.serverList.add(details);
        this.serverMap.put(client.getAddress(), details);
        this.monitorServiceURL = Utilities.pathURL((String[])new String[]{Utilities.getDirectoryForURL((String)client.getAddress()), "tx-reg"});
        return details;
    }

    public TerminologyClientContext getMaster() {
        return this.serverList.isEmpty() ? null : this.serverList.get(0);
    }

    public ITerminologyClient getMasterClient() {
        return this.serverList.isEmpty() ? null : this.serverList.get(0).getClient();
    }

    public Map<String, TerminologyClientContext> serverMap() {
        HashMap<String, TerminologyClientContext> map = new HashMap<String, TerminologyClientContext>();
        for (TerminologyClientContext t : this.serverList) {
            map.put(t.getClient().getAddress(), t);
        }
        return map;
    }

    public void setFactory(ITerminologyClientFactory factory) {
        this.factory = factory;
    }

    public void setCache(TerminologyCache cache) {
        this.cache = cache;
        this.cacheFile = null;
        if (cache != null && cache.getFolder() != null) {
            try {
                this.cacheFile = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{cache.getFolder(), "system-map.json"}));
                if (this.cacheFile.exists()) {
                    JsonObject json = JsonParser.parseObject((File)this.cacheFile);
                    for (JsonObject pair : json.getJsonObjects("systems")) {
                        if (pair.has("server")) {
                            this.resMap.put(pair.asString("system"), new ServerOptionList(pair.asString("server")));
                            continue;
                        }
                        this.resMap.put(pair.asString("system"), new ServerOptionList(pair.getStrings("authoritative"), pair.getStrings("candidates")));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void save() {
        if (this.cacheFile != null && this.cache.getFolder() != null) {
            JsonObject json = new JsonObject();
            for (String s : Utilities.sorted(this.resMap.keySet())) {
                JsonObject si = new JsonObject();
                json.forceArray("systems").add((JsonElement)si);
                si.add("system", s);
                si.add("authoritative", this.resMap.get((Object)s).authoritative);
                si.add("candidates", this.resMap.get((Object)s).candidates);
            }
            try {
                JsonParser.compose((JsonElement)json, (File)this.cacheFile, (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public List<TerminologyClientContext> getServerList() {
        return this.serverList;
    }

    public Map<String, TerminologyClientContext> getServerMap() {
        return this.serverMap;
    }

    public String getMonitorServiceURL() {
        return this.monitorServiceURL;
    }

    public Parameters getExpansionParameters() {
        return this.expParameters;
    }

    public void setExpansionParameters(Parameters expParameters) {
        this.expParameters = expParameters;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public TerminologyCache.SourcedValueSet findValueSetOnServer(String canonical) {
        if (this.getMasterClient() == null) {
            return null;
        }
        Object request = null;
        boolean isImplicit = false;
        String iVersion = null;
        if (ValueSetUtilities.isImplicitSCTValueSet(canonical)) {
            isImplicit = true;
            iVersion = canonical.substring(0, canonical.indexOf("?fhir_vs"));
            if ("http://snomed.info/sct".equals(iVersion) && canonical.contains("|")) {
                iVersion = canonical.substring(canonical.indexOf("|") + 1);
            }
            iVersion = ValueSetUtilities.versionFromExpansionParams(this.expParameters, "http://snomed.info/sct", iVersion);
            request = Utilities.pathURL((String[])new String[]{this.monitorServiceURL, "resolve?fhirVersion=" + this.factory.getVersion() + "&url=" + Utilities.URLEncode((String)("http://snomed.info/sct" + (String)(iVersion == null ? "" : "|" + iVersion)))});
        } else if (ValueSetUtilities.isImplicitLoincValueSet(canonical)) {
            isImplicit = true;
            iVersion = null;
            if (canonical.contains("|")) {
                iVersion = canonical.substring(canonical.indexOf("|") + 1);
            }
            iVersion = ValueSetUtilities.versionFromExpansionParams(this.expParameters, "http://loinc.org", iVersion);
            request = Utilities.pathURL((String[])new String[]{this.monitorServiceURL, "resolve?fhirVersion=" + this.factory.getVersion() + "&url=" + Utilities.URLEncode((String)("http://loinc.org" + (String)(iVersion == null ? "" : "|" + iVersion)))});
        } else {
            request = Utilities.pathURL((String[])new String[]{this.monitorServiceURL, "resolve?fhirVersion=" + this.factory.getVersion() + "&valueSet=" + Utilities.URLEncode((String)canonical)});
        }
        String server = null;
        try {
            String rid;
            TerminologyClientContext client;
            block36: {
                if (!this.useEcosystem) {
                    server = this.getMasterClient().getAddress();
                } else {
                    this.ecosystemfailCount = 0;
                    try {
                        if (this.usage != null) {
                            request = (String)request + "&usage=" + this.usage;
                        }
                        JsonObject json = JsonParser.parseObjectFromUrl((String)request);
                        for (JsonObject item : json.getJsonObjects("authoritative")) {
                            if (server != null) continue;
                            server = item.asString("url");
                        }
                        for (JsonObject item : json.getJsonObjects("candidates")) {
                            if (server != null) continue;
                            server = item.asString("url");
                        }
                        if (server == null) {
                            server = this.getMasterClient().getAddress();
                        }
                        if (server.contains("://tx.fhir.org")) {
                            try {
                                server = server.replace("tx.fhir.org", this.host());
                            }
                            catch (MalformedURLException malformedURLException) {}
                        }
                    }
                    catch (Exception e) {
                        String msg = "Error resolving valueSet " + canonical + ": " + e.getMessage();
                        if (!this.hasMessage(msg)) {
                            this.internalLog.add(new InternalLogEvent(msg, canonical, (String)request));
                        }
                        this.logger.logDebugMessage(ILoggingService.LogCategory.TX, ExceptionUtils.getStackTrace((Throwable)e));
                        ++this.ecosystemfailCount;
                        if (this.ecosystemfailCount > 3) {
                            this.useEcosystem = false;
                        }
                        server = this.getMasterClient().getAddress();
                    }
                }
                client = this.serverMap.get(server);
                if (client == null) {
                    try {
                        client = new TerminologyClientContext(this.factory.makeClient("id" + (this.serverList.size() + 1), ManagedWebAccess.makeSecureRef((String)server), this.getMasterClient().getUserAgent(), this.getMasterClient().getLogger()), this.cacheId, false);
                    }
                    catch (URISyntaxException e) {
                        throw new TerminologyServiceException((Throwable)e);
                    }
                    client.setTxCache(this.cache);
                    this.serverList.add(client);
                    this.serverMap.put(server, client);
                }
                client.seeUse(canonical, TerminologyClientContext.TerminologyClientContextUseType.readVS);
                String criteria = canonical.contains("|") ? "?_format=json&url=" + Utilities.URLEncode((String)canonical.substring(0, canonical.lastIndexOf("|"))) + "&version=" + Utilities.URLEncode((String)canonical.substring(canonical.lastIndexOf("|") + 1)) : "?_format=json&url=" + Utilities.URLEncode((String)canonical);
                request = Utilities.pathURL((String[])new String[]{client.getAddress(), "ValueSet" + criteria});
                Bundle bnd = client.getClient().search("ValueSet", criteria);
                rid = null;
                if (bnd.getEntry().size() == 0) {
                    if (isImplicit) {
                        Parameters p = new Parameters();
                        p.addParameter("url", new UriType(canonical));
                        p.addParameter("count", 0);
                        p.addParameters(this.expParameters);
                        try {
                            ValueSet vs = client.getClient().expandValueset(null, p);
                            if (vs != null) {
                                return new TerminologyCache.SourcedValueSet(server, ValueSetUtilities.makeImplicitValueSet(canonical, iVersion));
                            }
                            break block36;
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                    return null;
                }
                if (bnd.getEntry().size() > 1) {
                    ArrayList<ValueSet> vslist = new ArrayList<ValueSet>();
                    for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
                        if (!be.hasResource() || !(be.getResource() instanceof ValueSet)) continue;
                        vslist.add((ValueSet)be.getResource());
                    }
                    Collections.sort(vslist, new ValueSetUtilities.ValueSetSorter());
                    rid = ((ValueSet)vslist.get(vslist.size() - 1)).getIdBase();
                } else if (bnd.getEntryFirstRep().hasResource() && bnd.getEntryFirstRep().getResource() instanceof ValueSet) {
                    rid = bnd.getEntryFirstRep().getResource().getIdBase();
                }
            }
            if (rid == null) {
                return null;
            }
            ValueSet vs = (ValueSet)client.getClient().read("ValueSet", rid);
            return new TerminologyCache.SourcedValueSet(server, vs);
        }
        catch (Exception e) {
            String msg = "Error resolving valueSet " + canonical + ": " + e.getMessage();
            if (!this.hasMessage(msg)) {
                this.internalLog.add(new InternalLogEvent(msg, canonical, (String)request));
            }
            this.logger.logDebugMessage(ILoggingService.LogCategory.TX, ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public TerminologyCache.SourcedCodeSystem findCodeSystemOnServer(String canonical) {
        if (this.getMasterClient() == null || !this.useEcosystem) {
            return null;
        }
        Object request = Utilities.pathURL((String[])new String[]{this.monitorServiceURL, "resolve?fhirVersion=" + this.factory.getVersion() + "&url=" + Utilities.URLEncode((String)canonical)});
        if (this.usage != null) {
            request = (String)request + "&usage=" + this.usage;
        }
        String server = null;
        try {
            TerminologyClientContext client;
            JsonObject json = JsonParser.parseObjectFromUrl((String)request);
            for (JsonObject item : json.getJsonObjects("authoritative")) {
                if (server != null) continue;
                server = item.asString("url");
            }
            for (JsonObject item : json.getJsonObjects("candidates")) {
                if (server != null) continue;
                server = item.asString("url");
            }
            if (server == null) {
                return null;
            }
            if (server.contains("://tx.fhir.org")) {
                try {
                    server = server.replace("tx.fhir.org", this.host());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if ((client = this.serverMap.get(server)) == null) {
                try {
                    client = new TerminologyClientContext(this.factory.makeClient("id" + (this.serverList.size() + 1), ManagedWebAccess.makeSecureRef((String)server), this.getMasterClient().getUserAgent(), this.getMasterClient().getLogger()), this.cacheId, false);
                }
                catch (URISyntaxException e) {
                    throw new TerminologyServiceException((Throwable)e);
                }
                client.setTxCache(this.cache);
                this.serverList.add(client);
                this.serverMap.put(server, client);
            }
            client.seeUse(canonical, TerminologyClientContext.TerminologyClientContextUseType.readCS);
            String criteria = canonical.contains("|") ? "?_format=json&url=" + Utilities.URLEncode((String)canonical.substring(0, canonical.lastIndexOf("|"))) + (String)(canonical.contains("|") ? "&version=" + Utilities.URLEncode((String)canonical.substring(canonical.lastIndexOf("|") + 1)) : "") : "?_format=json&url=" + Utilities.URLEncode((String)canonical);
            request = Utilities.pathURL((String[])new String[]{client.getAddress(), "CodeSystem" + criteria});
            Bundle bnd = client.getClient().search("CodeSystem", criteria);
            String rid = null;
            if (bnd.getEntry().size() == 0) {
                return null;
            }
            if (bnd.getEntry().size() > 1) {
                ArrayList<CodeSystem> cslist = new ArrayList<CodeSystem>();
                for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
                    if (!be.hasResource() || !(be.getResource() instanceof CodeSystem)) continue;
                    cslist.add((CodeSystem)be.getResource());
                }
                Collections.sort(cslist, new CodeSystemUtilities.CodeSystemSorter());
                rid = ((CodeSystem)cslist.get(cslist.size() - 1)).getIdBase();
            } else if (bnd.getEntryFirstRep().hasResource() && bnd.getEntryFirstRep().getResource() instanceof CodeSystem) {
                rid = bnd.getEntryFirstRep().getResource().getIdBase();
            }
            if (rid == null) {
                return null;
            }
            CodeSystem vs = (CodeSystem)client.getClient().read("CodeSystem", rid);
            return new TerminologyCache.SourcedCodeSystem(server, vs);
        }
        catch (Exception e) {
            String msg = "Error resolving CodeSystem " + canonical + ": " + e.getMessage();
            if (!this.hasMessage(msg)) {
                this.internalLog.add(new InternalLogEvent(msg, canonical, (String)request));
            }
            this.logger.logDebugMessage(ILoggingService.LogCategory.TX, ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public boolean supportsSystem(String system) throws IOException {
        for (TerminologyClientContext client : this.serverList) {
            if (!client.supportsSystem(system)) continue;
            return true;
        }
        return false;
    }

    public List<InternalLogEvent> getInternalLog() {
        return this.internalLog;
    }

    public ILoggingService getLogger() {
        return this.logger;
    }

    public void setLogger(ILoggingService logger) {
        this.logger = logger;
    }

    public static interface ITerminologyClientFactory {
        public ITerminologyClient makeClient(String var1, String var2, String var3, ToolingClientLogger var4) throws URISyntaxException;

        public String getVersion();
    }

    public class ServerOptionList {
        private List<String> authoritative = new ArrayList<String>();
        private List<String> candidates = new ArrayList<String>();

        public ServerOptionList(String address) {
            this.candidates.add(address);
        }

        public ServerOptionList() {
        }

        public ServerOptionList(List<String> auth, List<String> cand) {
            this.authoritative.addAll(auth);
            this.candidates.addAll(cand);
        }

        public void replace(String src, String dst) {
            int i;
            for (i = 0; i < this.candidates.size(); ++i) {
                if (!this.candidates.get(i).contains("://" + src)) continue;
                this.candidates.set(i, this.candidates.get(i).replace("://" + src, "://" + dst));
            }
            for (i = 0; i < this.authoritative.size(); ++i) {
                if (!this.authoritative.get(i).contains("://" + src)) continue;
                this.authoritative.set(i, this.authoritative.get(i).replace("://" + src, "://" + dst));
            }
        }

        public String toString() {
            return "auth = " + CommaSeparatedStringBuilder.join((String)"|", this.authoritative) + ", candidates=" + CommaSeparatedStringBuilder.join((String)"|", this.candidates);
        }
    }

    public class InternalLogEvent {
        private boolean error;
        private String message;
        private String server;
        private String vs;
        private String systems;
        private String choices;
        private String context;
        private String request;

        protected InternalLogEvent(String message, String server, String vs, String systems, String choices) {
            this.message = message;
            this.server = server;
            this.vs = vs;
            this.systems = systems;
            this.choices = choices;
        }

        protected InternalLogEvent(String message, String ctxt, String request) {
            this.error = true;
            this.message = message;
            this.context = ctxt;
            this.request = request;
        }

        public String getMessage() {
            return this.message;
        }

        public String getVs() {
            return this.vs;
        }

        public String getSystems() {
            return this.systems;
        }

        public String getChoices() {
            return this.choices;
        }

        public String getServer() {
            return this.server;
        }

        public boolean isError() {
            return this.error;
        }

        public String getContext() {
            return this.context;
        }

        public String getRequest() {
            return this.request;
        }
    }
}

