/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.testfactory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.liquid.BaseTableWrapper;
import org.hl7.fhir.r5.liquid.LiquidEngine;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.testfactory.ProfileBasedFactory;
import org.hl7.fhir.r5.testfactory.dataprovider.TableDataProvider;
import org.hl7.fhir.r5.testfactory.dataprovider.ValueSetDataProvider;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MarkedToMoveToAdjunctPackage
public class TestDataFactory {
    private static final Logger log = LoggerFactory.getLogger(TestDataFactory.class);
    private String rootFolder;
    private LiquidEngine liquid;
    private PrintStream testLog;
    private IWorkerContext context;
    private String canonical;
    private Manager.FhirFormat format;
    private File localData;
    private FHIRPathEngine fpe;
    private JsonObject details;
    private String name;
    private boolean testing;
    private Map<String, String> profileMap;
    private Locale locale;

    public TestDataFactory(IWorkerContext context, JsonObject details, LiquidEngine liquid, FHIRPathEngine fpe, String canonical, String rootFolder, String logFolder, Map<String, String> profileMap, Locale locale) throws IOException {
        this.context = context;
        this.rootFolder = rootFolder;
        this.canonical = canonical;
        this.details = details;
        this.liquid = liquid;
        this.fpe = fpe;
        this.profileMap = profileMap;
        this.locale = locale;
        this.name = details.asString("name");
        if (Utilities.noString((String)this.name)) {
            throw new FHIRException("Factory has no name");
        }
        this.testLog = new PrintStream(new FileOutputStream(Utilities.path((String[])new String[]{logFolder, this.name + ".log"})));
        this.format = "json".equals(details.asString("format")) ? Manager.FhirFormat.JSON : Manager.FhirFormat.XML;
    }

    public String getName() {
        return this.name;
    }

    public void execute() throws FHIRException, IOException {
        String mode = this.details.asString("mode");
        if ("liquid".equals(mode)) {
            this.executeLiquid();
        } else if ("profile".equals(mode)) {
            this.executeProfile();
        } else {
            this.error("Factory " + this.getName() + " mode '" + mode + "' unknown");
        }
        this.log("finished successfully");
        this.testLog.close();
    }

    private void logDataScheme(DataTable tbl, Map<String, DataTable> tables) throws IOException {
        this.log("data: " + CommaSeparatedStringBuilder.join((String)",", tbl.getColumns()));
        for (String tn : Utilities.sorted(tables.keySet())) {
            this.log("tn: " + CommaSeparatedStringBuilder.join((String)",", tables.get(tn).getColumns()));
        }
    }

    private void logDataScheme(TableDataProvider tbl, Map<String, DataTable> tables) throws IOException {
        this.log("data: " + CommaSeparatedStringBuilder.join((String)",", tbl.columns()));
        for (String tn : Utilities.sorted(tables.keySet())) {
            this.log("tn: " + CommaSeparatedStringBuilder.join((String)",", tables.get(tn).getColumns()));
        }
    }

    private void executeProfile() throws IOException {
        try {
            this.checkDownloadBaseData();
            TableDataProvider tbl = this.loadTable(Utilities.path((String[])new String[]{this.rootFolder, this.details.asString("data")}));
            HashMap<String, DataTable> tables = new HashMap<String, DataTable>();
            if (this.details.has("tables")) {
                JsonObject tablesJ = this.details.getJsonObject("tables");
                for (String n : tablesJ.getNames()) {
                    tables.put(n, this.loadData(Utilities.path((String[])new String[]{this.rootFolder, tablesJ.asString(n)})));
                }
            }
            this.logDataScheme(tbl, tables);
            ProfileBasedFactory factory = new ProfileBasedFactory(this.fpe, this.localData.getAbsolutePath(), tbl, tables, this.details.forceArray("mappings"));
            factory.setLog(this.testLog);
            factory.setTesting(this.testing);
            factory.setMarkProfile(this.details.asBoolean("mark-profile"));
            String purl = this.details.asString("profile");
            StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, purl);
            if (profile == null) {
                this.error("Unable to find profile " + purl);
            } else if (!profile.hasSnapshot()) {
                this.error("Profile " + purl + " doesn't have a snapshot");
            }
            if ("true".equals(this.details.asString("bundle"))) {
                byte[] data = this.runBundle(profile, factory, tbl);
                String fn = Utilities.path((String[])new String[]{this.rootFolder, this.details.asString("filename")});
                FileUtilities.bytesToFile((byte[])data, (String)fn);
                this.profileMap.put(FileUtilities.changeFileExt((String)fn, (String)""), profile.getVersionedUrl());
            } else {
                while (tbl.nextRow()) {
                    if (!this.rowPasses(factory)) continue;
                    byte[] data = factory.generateFormat(profile, this.format);
                    String fn = Utilities.path((String[])new String[]{this.rootFolder, this.getFileName(this.details.asString("filename"), tbl.columns(), tbl.cells())});
                    FileUtilities.createDirectory((String)FileUtilities.getDirectoryForFile((String)fn));
                    FileUtilities.bytesToFile((byte[])data, (String)fn);
                    this.profileMap.put(FileUtilities.changeFileExt((String)fn, (String)""), profile.getVersionedUrl());
                }
            }
        }
        catch (Exception e) {
            log.error("Error running test factory '" + this.getName() + "': " + e.getMessage());
            this.log("Error running test case '" + this.getName() + "': " + e.getMessage());
            e.printStackTrace(this.testLog);
            throw new FHIRException((Throwable)e);
        }
    }

    private void checkDownloadBaseData() throws IOException {
        block6: {
            this.localData = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{"[tmp]", "fhir-test-data.db"}));
            File localInfo = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{"[tmp]", "fhir-test-data.json"}));
            try {
                JsonObject local = localInfo.exists() ? JsonParser.parseObject((File)localInfo) : null;
                JsonObject json = JsonParser.parseObjectFromUrl((String)"http://fhir.org/downloads/test-data-versions.json");
                JsonObject current = json.forceArray("versions").get(0).asJsonObject();
                if (current == null) {
                    throw new FHIRException("No current information about FHIR downloads");
                }
                String date = current.asString("date");
                if (date == null) {
                    throw new FHIRException("No date on current information about FHIR downloads");
                }
                String filename = current.asString("filename");
                if (filename == null) {
                    throw new FHIRException("No filename on current information about FHIR downloads");
                }
                if (local == null || !date.equals(local.asString("date"))) {
                    HTTPResult data = ManagedWebAccess.get((Iterable)Utilities.strings((String[])new String[]{"general"}), (String)("http://fhir.org/downloads/" + filename));
                    FileUtilities.bytesToFile((byte[])data.getContent(), (File)this.localData);
                    local = new JsonObject();
                    local.set("date", date);
                    JsonParser.compose((JsonElement)current, (File)localInfo, (boolean)true);
                }
            }
            catch (Exception e) {
                if (this.localData.exists()) break block6;
                this.log("Unable to download copy of FHIR testing data: " + e.getMessage());
                throw new FHIRException("Unable to download copy of FHIR testing data", (Throwable)e);
            }
        }
    }

    private byte[] runBundle(StructureDefinition profile, ProfileBasedFactory factory, TableDataProvider tbl) throws IOException, FHIRException, SQLException {
        Element bundle = Manager.parse(this.context, this.bundleShell(), Manager.FhirFormat.JSON).get(0).getElement();
        bundle.makeElement("id").setValue(UUID.randomUUID().toString().toLowerCase());
        while (tbl.nextRow()) {
            if (!this.rowPasses(factory)) continue;
            Element resource = factory.generate(profile);
            Element be = bundle.makeElement("entry");
            be.makeElement("fullUrl").setValue(Utilities.pathURL((String[])new String[]{this.canonical, "test", resource.fhirType(), resource.getIdBase()}));
            be.makeElement("resource").getChildren().addAll(resource.getChildren());
        }
        this.log("Saving Bundle");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        Manager.compose(this.context, bundle, bs, this.format, IParser.OutputStyle.PRETTY, null);
        return bs.toByteArray();
    }

    private boolean rowPasses(ProfileBasedFactory factory) throws IOException {
        if (this.details.has("filter")) {
            ArrayList<String> ls = new ArrayList<String>();
            String res = factory.evaluateExpression(ls, this.details.get("filter"), "filter");
            for (String l : ls) {
                this.log(l);
            }
            return Utilities.existsInList((String)res, (String[])new String[]{"1", "true"});
        }
        return true;
    }

    private TableDataProvider loadTable(String path) throws IOException, InvalidFormatException {
        this.log("Load Data From " + path);
        return this.loadTableProvider(path, this.locale);
    }

    private void error(String msg) throws IOException {
        this.log(msg);
        this.testLog.close();
        throw new FHIRException(msg);
    }

    private void log(String msg) throws IOException {
        this.testLog.append(msg + "\r\n");
    }

    public void executeLiquid() throws IOException {
        try {
            LiquidEngine.LiquidDocument template = this.liquid.parse(FileUtilities.fileToString((String)Utilities.path((String[])new String[]{this.rootFolder, this.details.asString("liquid")})), "liquid");
            this.log("liquid compiled");
            DataTable dt = this.loadData(Utilities.path((String[])new String[]{this.rootFolder, this.details.asString("data")}));
            HashMap<String, DataTable> tables = new HashMap<String, DataTable>();
            this.liquid.getVars().clear();
            if (this.details.has("tables")) {
                JsonObject tablesJ = this.details.getJsonObject("tables");
                for (String n : tablesJ.getNames()) {
                    DataTable v = this.loadData(Utilities.path((String[])new String[]{this.rootFolder, tablesJ.asString(n)}));
                    this.liquid.getVars().put(n, v);
                    tables.put(n, v);
                }
            }
            this.logDataScheme(dt, tables);
            this.logStrings("columns", dt.columns);
            if ("true".equals(this.details.asString("bundle"))) {
                byte[] data = this.runBundle(template, dt);
                FileUtilities.bytesToFile((byte[])data, (String)Utilities.path((String[])new String[]{this.rootFolder, this.details.asString("filename")}));
            } else {
                for (List<String> row : dt.rows) {
                    byte[] data = this.runInstance(template, dt.columns, row);
                    FileUtilities.bytesToFile((byte[])data, (String)Utilities.path((String[])new String[]{this.rootFolder, this.getFileName(this.details.asString("filename"), dt.columns, row)}));
                }
            }
        }
        catch (Exception e) {
            log.error("Error running test factory '" + this.getName() + "': " + e.getMessage());
            this.log("Error running test case '" + this.getName() + "': " + e.getMessage());
            e.printStackTrace(this.testLog);
            throw new FHIRException((Throwable)e);
        }
    }

    private void logStrings(String name, List<String> columns) throws IOException {
        this.log(name + ": " + CommaSeparatedStringBuilder.join((String)", ", columns));
    }

    private String getFileName(String name, List<String> columns, List<String> values) {
        for (int i = 0; i < columns.size(); ++i) {
            name = name.replace("$" + columns.get(i) + "$", values.get(i));
        }
        return name;
    }

    private byte[] runInstance(LiquidEngine.LiquidDocument template, List<String> columns, List<String> row) throws JsonException, IOException {
        this.logStrings("row", row);
        BaseTableWrapper base = BaseTableWrapper.forRow(columns, row);
        String cnt = this.liquid.evaluate(template, base, this).trim();
        if (this.format == Manager.FhirFormat.JSON) {
            JsonObject j = JsonParser.parseObject((String)cnt, (boolean)true);
            return JsonParser.composeBytes((JsonElement)j, (boolean)true);
        }
        return FileUtilities.stringToBytes((String)cnt);
    }

    private byte[] runBundle(LiquidEngine.LiquidDocument template, DataTable dt) throws JsonException, IOException {
        Element bundle = Manager.parse(this.context, this.bundleShell(), Manager.FhirFormat.JSON).get(0).getElement();
        bundle.makeElement("id").setValue(UUID.randomUUID().toString().toLowerCase());
        for (List<String> row : dt.rows) {
            byte[] data = this.runInstance(template, dt.columns, row);
            Element resource = Manager.parse(this.context, new ByteArrayInputStream(data), this.format).get(0).getElement();
            Element be = bundle.makeElement("entry");
            be.makeElement("fullUrl").setValue(Utilities.pathURL((String[])new String[]{this.canonical, "test", resource.fhirType(), resource.getIdBase()}));
            be.makeElement("resource").getChildren().addAll(resource.getChildren());
        }
        this.log("Saving Bundle");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        Manager.compose(this.context, bundle, bs, this.format, IParser.OutputStyle.PRETTY, null);
        return bs.toByteArray();
    }

    private InputStream bundleShell() throws IOException {
        String bundle = "{\"resourceType\" : \"Bundle\", \"type\" : \"collection\"}";
        return new ByteArrayInputStream(FileUtilities.stringToBytes((String)bundle));
    }

    private DataTable loadData(String path) throws FHIRException, IOException, InvalidFormatException {
        this.log("Load Data From " + path);
        TableDataProvider tbl = this.loadTableProvider(path, this.locale);
        DataTable dt = new DataTable();
        for (String n : tbl.columns()) {
            dt.columns.add(n);
        }
        int t = dt.columns.size();
        while (tbl.nextRow()) {
            ArrayList<String> values = new ArrayList<String>();
            for (String b : tbl.cells()) {
                values.add(b);
            }
            while (values.size() < t) {
                values.add("");
            }
            while (values.size() > t) {
                values.remove(values.size() - 1);
            }
            dt.rows.add(values);
        }
        return dt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TableDataProvider loadTableProvider(String path, Locale locale) {
        if (!Utilities.isAbsoluteUrl((String)path)) return TableDataProvider.forFile(path, locale);
        ValueSet vs = this.context.findTxResource(ValueSet.class, path);
        if (vs == null) {
            throw new FHIRException("ValueSet " + path + " not found");
        }
        ValueSetExpansionOutcome exp = this.context.expandVS(vs, true, false);
        if (!exp.isOk()) throw new FHIRException("ValueSet " + path + " coult not be expanded: " + exp.getError());
        return new ValueSetDataProvider(exp.getValueset().getExpansion());
    }

    public String statedLog() {
        return this.name + ".log";
    }

    public boolean isTesting() {
        return this.testing;
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
    }

    public static class DataTable
    extends Base {
        List<String> columns = new ArrayList<String>();
        List<List<String>> rows = new ArrayList<List<String>>();

        @Override
        public String fhirType() {
            return "DataTable";
        }

        @Override
        public String getIdBase() {
            return null;
        }

        @Override
        public void setIdBase(String value) {
            throw new Error("Readonly");
        }

        @Override
        public Base copy() {
            return this;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public List<List<String>> getRows() {
            return this.rows;
        }

        @Override
        public FhirPublication getFHIRPublicationVersion() {
            return FhirPublication.R5;
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            if (this.rows != null && "rows".equals(name)) {
                Base[] l = new Base[this.rows.size()];
                for (int i = 0; i < this.rows.size(); ++i) {
                    l[i] = BaseTableWrapper.forRow(this.columns, this.rows.get(i));
                }
                return l;
            }
            return super.getProperty(hash, name, checkValid);
        }

        public String cell(int row, String col) {
            if (row >= 0 && row < this.rows.size()) {
                List<String> r = this.rows.get(row);
                int c = -1;
                c = Utilities.isInteger((String)col) ? Utilities.parseInt((String)col, (int)-1) : this.columns.indexOf(col);
                if (c > -1 && c < r.size()) {
                    return r.get(c);
                }
            }
            return null;
        }

        public String lookup(String lcol, String val, String rcol) {
            for (int i = 0; i < this.rows.size(); ++i) {
                if (!val.equals(this.cell(i, lcol))) continue;
                return this.cell(i, rcol);
            }
            return null;
        }
    }

    public static class TableLookupFunction
    extends FHIRPathEngine.IEvaluationContext.FunctionDefinition {
        @Override
        public String name() {
            return "lookup";
        }

        @Override
        public FHIRPathUtilityClasses.FunctionDetails details() {
            return new FHIRPathUtilityClasses.FunctionDetails("Lookup a value in a table", 4, 4);
        }

        @Override
        public TypeDetails check(FHIRPathEngine engine, Object appContext, TypeDetails focus, List<TypeDetails> parameters) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
        }

        @Override
        public List<Base> execute(FHIRPathEngine engine, Object appContext, List<Base> focus, List<List<Base>> parameters) {
            ArrayList<Base> res = new ArrayList<Base>();
            if (focus.get(0) instanceof BaseTableWrapper && parameters.size() == 4 && parameters.get(0).size() == 1 && parameters.get(1).size() == 1 && parameters.get(2).size() == 1 && parameters.get(3).size() == 1) {
                String s;
                DataTable tbl;
                BaseTableWrapper dt = (BaseTableWrapper)focus.get(0);
                String table = parameters.get(0).get(0).primitiveValue();
                String lcol = parameters.get(1).get(0).primitiveValue();
                String val = parameters.get(2).get(0).primitiveValue();
                String rcol = parameters.get(3).get(0).primitiveValue();
                if (table != null && lcol != null && val != null && rcol != null && (tbl = dt.getTables().get(table)) != null && !Utilities.noString((String)(s = tbl.lookup(lcol, val, rcol)))) {
                    res.add(new StringType(s));
                }
            }
            return res;
        }
    }

    public static class CellLookupFunction
    extends FHIRPathEngine.IEvaluationContext.FunctionDefinition {
        @Override
        public String name() {
            return "cell";
        }

        @Override
        public FHIRPathUtilityClasses.FunctionDetails details() {
            return new FHIRPathUtilityClasses.FunctionDetails("Lookup a data element", 2, 2);
        }

        @Override
        public TypeDetails check(FHIRPathEngine engine, Object appContext, TypeDetails focus, List<TypeDetails> parameters) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
        }

        @Override
        public List<Base> execute(FHIRPathEngine engine, Object appContext, List<Base> focus, List<List<Base>> parameters) {
            int row = Utilities.parseInt((String)parameters.get(0).get(0).primitiveValue(), (int)0);
            String col = parameters.get(1).get(0).primitiveValue();
            DataTable dt = (DataTable)focus.get(0);
            ArrayList<Base> res = new ArrayList<Base>();
            String s = dt.cell(row, col);
            if (!Utilities.noString((String)s)) {
                res.add(new StringType(s));
            }
            return res;
        }
    }
}

