/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.testfactory.dataprovider;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class BaseDataTableProvider {
    private Connection connection;
    Map<String, String> elements = new HashMap<String, String>();
    Map<String, String> types = new HashMap<String, String>();
    private boolean testing;

    public BaseDataTableProvider(String filename) throws SQLException {
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + filename);
        ResultSet rs = this.connection.createStatement().executeQuery("select * from TestElements");
        while (rs.next()) {
            this.elements.put(rs.getString("ElementId"), rs.getString("ElementKey"));
        }
        rs = this.connection.createStatement().executeQuery("select * from TestTypes");
        while (rs.next()) {
            this.types.put(rs.getString("TypeName"), rs.getString("TypeKey"));
        }
    }

    public String getPrimitiveValue(String elementId, String typeName) throws SQLException {
        ResultSet rs;
        String ek = this.elements.get(elementId);
        String tk = this.types.get(typeName);
        if (tk == null) {
            return null;
        }
        if (ek != null && (rs = this.connection.createStatement().executeQuery("select ValueData from TestValues where ElementKey = " + ek + " and TypeKey = " + tk + (this.testing ? " ORDER BY ValueKey" : " ORDER BY RANDOM() LIMIT 1"))).next()) {
            return rs.getString(1);
        }
        rs = this.connection.createStatement().executeQuery("select ValueData from TestValues where TypeKey = " + tk + (this.testing ? " ORDER BY ValueKey" : " ORDER BY RANDOM() LIMIT 1"));
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    public Map<String, String> getComplexValue(String elementId, String typeName) throws SQLException {
        ResultSet rs;
        String sql;
        String ek = this.elements.get(elementId);
        String tk = this.types.get(typeName);
        if (tk == null) {
            return null;
        }
        if (ek != null) {
            sql = "select ValueData from TestValues where ElementKey = " + ek + " and TypeKey = " + tk + (this.testing ? " ORDER BY ValueKey" : " ORDER BY RANDOM() LIMIT 1");
            rs = this.connection.createStatement().executeQuery(sql);
            if (rs.next()) {
                return this.parse(rs.getString(1));
            }
        }
        sql = "select ValueData from TestValues where TypeKey = " + tk + (this.testing ? " ORDER BY ValueKey" : " ORDER BY RANDOM() LIMIT 1");
        rs = this.connection.createStatement().executeQuery(sql);
        if (rs.next()) {
            return this.parse(rs.getString(1));
        }
        return null;
    }

    private Map<String, String> parse(String value) {
        String[] parts;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String p : parts = value.split("\\|\\:\\|")) {
            String n = p.substring(0, p.indexOf(":"));
            String v = p.substring(p.indexOf(":") + 1);
            map.put(n.trim(), v.trim());
        }
        return map;
    }

    public boolean isTesting() {
        return this.testing;
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
    }
}

