/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.testfactory.dataprovider;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.testfactory.dataprovider.TableDataProvider;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class SQLDataProvider
extends TableDataProvider {
    private Connection connection;
    private String tableName;
    private List<String> columnHeaders;
    private ResultSet resultSet;
    private ResultSetMetaData metaData;
    private Map<String, Integer> columnIndexMap = new HashMap<String, Integer>();
    private int counter;

    public SQLDataProvider(Connection connection, String tableName) throws IOException {
        this.connection = connection;
        this.tableName = tableName;
        this.reset();
    }

    private void loadColumnHeaders() throws IOException {
        try (Statement statement = this.connection.createStatement();
             ResultSet rs = statement.executeQuery("SELECT * FROM " + this.tableName + " WHERE 1=0");){
            this.metaData = rs.getMetaData();
            this.columnHeaders = new ArrayList<String>();
            this.columnHeaders.add("counter");
            for (int i = 1; i <= this.metaData.getColumnCount(); ++i) {
                String columnName = this.metaData.getColumnName(i);
                this.columnHeaders.add(columnName);
                this.columnIndexMap.put(columnName, i);
            }
        }
        catch (SQLException e) {
            throw new FHIRException("Error loading column headers: " + e.getMessage(), (Throwable)e);
        }
    }

    private void prepareResultSet() throws IOException {
        try {
            Statement statement = this.connection.createStatement();
            this.resultSet = statement.executeQuery("SELECT * FROM " + this.tableName);
        }
        catch (SQLException e) {
            throw new IOException("Error preparing result set: " + e.getMessage(), e);
        }
    }

    @Override
    public List<String> columns() {
        return this.columnHeaders;
    }

    @Override
    public boolean nextRow() throws FHIRException {
        try {
            ++this.counter;
            return this.resultSet.next();
        }
        catch (SQLException e) {
            throw new FHIRException("Error moving to next row: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<String> cells() throws FHIRException {
        try {
            ArrayList<String> cellValues = new ArrayList<String>();
            cellValues.add("" + this.counter);
            for (int i = 1; i <= this.metaData.getColumnCount(); ++i) {
                cellValues.add(this.resultSet.getString(i));
            }
            return cellValues;
        }
        catch (SQLException e) {
            throw new FHIRException("Error retrieving row cells: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String cell(String name) throws FHIRException {
        if ("counter".equals(name)) {
            return "" + this.counter;
        }
        try {
            Integer columnIndex = this.columnIndexMap.get(name);
            if (columnIndex == null) {
                return null;
            }
            return this.resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new FHIRException("Error retrieving cell value: " + e.getMessage(), (Throwable)e);
        }
    }

    public void close() throws IOException {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new IOException("Error closing resources: " + e.getMessage(), e);
        }
    }

    @Override
    public void reset() throws FHIRException {
        try {
            this.loadColumnHeaders();
            this.prepareResultSet();
        }
        catch (Exception e) {
            throw new FHIRException("Error closing resources: " + e.getMessage(), (Throwable)e);
        }
    }
}

