/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.tools;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.tools.CDSHooksElement;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="CDSHooksResponse")
public class CDSHooksResponse
extends CDSHooksElement
implements ICompositeType {
    @Child(name="cards", type={CDSHooksElement.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An array of Cards that provide information, suggested actions, and links", formalDefinition="An array of Cards. Cards can provide a combination of information (for reading), suggested actions (to be applied if a user selects them), and links (to launch an app if the user selects them).")
    protected List<CDSHooksResponseCardsComponent> cardsList;
    @Child(name="systemActions", type={CDSHooksResponseCardsSuggestionsActionsComponent.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An array of Actions that the CDS Service proposes to auto-apply", formalDefinition="An array of Actions that the CDS Service proposes to auto-apply")
    protected List<CDSHooksResponseCardsSuggestionsActionsComponent> systemActionsList;
    private static final long serialVersionUID = -131860217L;

    public List<CDSHooksResponseCardsComponent> getCardsList() {
        if (this.cardsList == null) {
            this.cardsList = new ArrayList<CDSHooksResponseCardsComponent>();
        }
        return this.cardsList;
    }

    public CDSHooksResponse setCardsList(List<CDSHooksResponseCardsComponent> theCards) {
        this.cardsList = theCards;
        return this;
    }

    public boolean hasCards() {
        if (this.cardsList == null) {
            return false;
        }
        for (CDSHooksResponseCardsComponent item : this.cardsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CDSHooksResponseCardsComponent addCards() {
        CDSHooksResponseCardsComponent t = new CDSHooksResponseCardsComponent();
        if (this.cardsList == null) {
            this.cardsList = new ArrayList<CDSHooksResponseCardsComponent>();
        }
        this.cardsList.add(t);
        return t;
    }

    public CDSHooksResponse addCards(CDSHooksResponseCardsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.cardsList == null) {
            this.cardsList = new ArrayList<CDSHooksResponseCardsComponent>();
        }
        this.cardsList.add(t);
        return this;
    }

    public CDSHooksResponseCardsComponent getCardsFirstRep() {
        if (this.getCardsList().isEmpty()) {
            this.addCards();
        }
        return this.getCardsList().get(0);
    }

    public List<CDSHooksResponseCardsSuggestionsActionsComponent> getSystemActionsList() {
        if (this.systemActionsList == null) {
            this.systemActionsList = new ArrayList<CDSHooksResponseCardsSuggestionsActionsComponent>();
        }
        return this.systemActionsList;
    }

    public CDSHooksResponse setSystemActionsList(List<CDSHooksResponseCardsSuggestionsActionsComponent> theSystemActions) {
        this.systemActionsList = theSystemActions;
        return this;
    }

    public boolean hasSystemActions() {
        if (this.systemActionsList == null) {
            return false;
        }
        for (CDSHooksResponseCardsSuggestionsActionsComponent item : this.systemActionsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CDSHooksResponseCardsSuggestionsActionsComponent addSystemActions() {
        CDSHooksResponseCardsSuggestionsActionsComponent t = new CDSHooksResponseCardsSuggestionsActionsComponent();
        if (this.systemActionsList == null) {
            this.systemActionsList = new ArrayList<CDSHooksResponseCardsSuggestionsActionsComponent>();
        }
        this.systemActionsList.add(t);
        return t;
    }

    public CDSHooksResponse addSystemActions(CDSHooksResponseCardsSuggestionsActionsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.systemActionsList == null) {
            this.systemActionsList = new ArrayList<CDSHooksResponseCardsSuggestionsActionsComponent>();
        }
        this.systemActionsList.add(t);
        return this;
    }

    public CDSHooksResponseCardsSuggestionsActionsComponent getSystemActionsFirstRep() {
        if (this.getSystemActionsList().isEmpty()) {
            this.addSystemActions();
        }
        return this.getSystemActionsList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("cards", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "An array of Cards. Cards can provide a combination of information (for reading), suggested actions (to be applied if a user selects them), and links (to launch an app if the user selects them).", 0, Integer.MAX_VALUE, this.cardsList));
        children.add(new Property("systemActions", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksResponse@CDSHooksResponse.cards.suggestions.actions", "An array of Actions that the CDS Service proposes to auto-apply", 0, Integer.MAX_VALUE, this.systemActionsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 94431075: {
                return new Property("cards", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "An array of Cards. Cards can provide a combination of information (for reading), suggested actions (to be applied if a user selects them), and links (to launch an app if the user selects them).", 0, Integer.MAX_VALUE, this.cardsList);
            }
            case 867134414: {
                return new Property("systemActions", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksResponse@CDSHooksResponse.cards.suggestions.actions", "An array of Actions that the CDS Service proposes to auto-apply", 0, Integer.MAX_VALUE, this.systemActionsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 94431075: {
                return this.cardsList == null ? new Base[]{} : this.cardsList.toArray(new Base[this.cardsList.size()]);
            }
            case 867134414: {
                return this.systemActionsList == null ? new Base[]{} : this.systemActionsList.toArray(new Base[this.systemActionsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 94431075: {
                this.getCardsList().add((CDSHooksResponseCardsComponent)value);
                return value;
            }
            case 867134414: {
                this.getSystemActionsList().add((CDSHooksResponseCardsSuggestionsActionsComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("cards")) {
            this.getCardsList().add((CDSHooksResponseCardsComponent)value);
        } else if (name.equals("systemActions")) {
            this.getSystemActionsList().add((CDSHooksResponseCardsSuggestionsActionsComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 94431075: {
                return this.addCards();
            }
            case 867134414: {
                return this.addSystemActions();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 94431075: {
                return new String[]{"http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement"};
            }
            case 867134414: {
                return new String[]{"http://hl7.org/fhir/tools/StructureDefinition/CDSHooksResponse@CDSHooksResponse.cards.suggestions.actions"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("cards")) {
            throw new FHIRException("Cannot call addChild on an abstract type CDSHooksResponse.cards");
        }
        if (name.equals("systemActions")) {
            return this.addSystemActions();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CDSHooksResponse";
    }

    @Override
    public CDSHooksResponse copy() {
        CDSHooksResponse dst = new CDSHooksResponse();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CDSHooksResponse dst) {
        super.copyValues(dst);
        if (this.cardsList != null) {
            dst.cardsList = new ArrayList<CDSHooksResponseCardsComponent>();
            for (CDSHooksResponseCardsComponent cDSHooksResponseCardsComponent : this.cardsList) {
                dst.cardsList.add(cDSHooksResponseCardsComponent.copy());
            }
        }
        if (this.systemActionsList != null) {
            dst.systemActionsList = new ArrayList<CDSHooksResponseCardsSuggestionsActionsComponent>();
            for (CDSHooksResponseCardsSuggestionsActionsComponent cDSHooksResponseCardsSuggestionsActionsComponent : this.systemActionsList) {
                dst.systemActionsList.add(cDSHooksResponseCardsSuggestionsActionsComponent.copy());
            }
        }
    }

    protected CDSHooksResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CDSHooksResponse)) {
            return false;
        }
        CDSHooksResponse o = (CDSHooksResponse)other_;
        return CDSHooksResponse.compareDeep(this.cardsList, o.cardsList, true) && CDSHooksResponse.compareDeep(this.systemActionsList, o.systemActionsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CDSHooksResponse)) {
            return false;
        }
        CDSHooksResponse o = (CDSHooksResponse)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.cardsList, this.systemActionsList});
    }

    @Block
    public static class CDSHooksResponseCardsComponent
    extends CDSHooksElement {
        @Child(name="uuid", type={UuidType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Unique identifier of the card (for logging/feedback)", formalDefinition="Unique identifier of the card. MAY be used for auditing and logging cards and SHALL be included in any subsequent calls to the CDS service's feedback endpoint.")
        protected UuidType uuid;
        @Child(name="summary", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Summary message for display to the user (<140 char)", formalDefinition="One-sentence, <140-character summary message for display to the user inside of this card.")
        protected StringType summary;
        @Child(name="detail", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Optional detailed information to display (GitHub Flavored Markdown)", formalDefinition="Optional detailed information to display; if provided MUST be represented in (GitHub Flavored) Markdown. (For non-urgent cards, the CDS Client MAY hide these details until the user clicks a link like 'view more details...').")
        protected MarkdownType detail;
        @Child(name="indicator", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="info, warning, critical - Urgency/importance of what this card conveys", formalDefinition="Urgency/importance of what this card conveys. Allowed values, in order of increasing urgency, are: info, warning, critical.")
        @Binding(valueSet="http://hl7.org/fhir/tools/ValueSet/CDSIndicator")
        protected Enumeration<CDSIndicatorCodesVS> indicator;
        @Child(name="source", type={CDSHooksElement.class}, order=5, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The primary source of guidance for the content the card represents.", formalDefinition="The source should be the primary source of guidance for the decision support the card represents.")
        protected CDSHooksResponseCardsSourceComponent source;
        @Child(name="suggestions", type={CDSHooksElement.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Suggest a set of changes in the context of the current activity", formalDefinition="Allows a service to suggest a set of changes in the context of the current activity (e.g. changing the dose of a medication currently being prescribed, for the order-sign activity).")
        protected List<CDSHooksResponseCardsSuggestionsComponent> suggestionsList;
        @Child(name="selectionBehavior", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="at-most-one, any - intended selection behavior of the suggestions in the card", formalDefinition="Describes the intended selection behavior of the suggestions in the card. Allowed values are: at-most-one, indicating that the user may choose none or at most one of the suggestions; any, indicating that the end user may choose any number of suggestions including none of them and all of them")
        @Binding(valueSet="http://hl7.org/fhir/tools/ValueSet/CDSSelectionBehavior")
        protected Enumeration<CDSSelectionBehaviorCodesVS> selectionBehavior;
        @Child(name="overrideReasons", type={Coding.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Can be selected by the end user when overriding a card without taking the suggested recommendations.", formalDefinition="Override reasons can be selected by the end user when overriding a card without taking the suggested recommendations. The CDS service MAY return a list of override reasons to the CDS client.")
        protected List<Coding> overrideReasonsList;
        @Child(name="links", type={CDSHooksElement.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Link to an app that the user might want to run for additional information or to help guide a decision", formalDefinition="Allows a service to suggest a link to an app that the user might want to run for additional information or to help guide a decision.")
        protected List<CDSHooksResponseCardsLinksComponent> linksList;
        private static final long serialVersionUID = -1553644263L;

        public CDSHooksResponseCardsComponent() {
        }

        public CDSHooksResponseCardsComponent(String summary, CDSHooksResponseCardsSourceComponent source) {
            this.setSummary(summary);
            this.setSource(source);
        }

        public UuidType getUuidElement() {
            if (this.uuid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsComponent.uuid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uuid = new UuidType();
                }
            }
            return this.uuid;
        }

        public boolean hasUuidElement() {
            return this.uuid != null && !this.uuid.isEmpty();
        }

        public boolean hasUuid() {
            return this.uuid != null && !this.uuid.isEmpty();
        }

        public CDSHooksResponseCardsComponent setUuidElement(UuidType value) {
            this.uuid = value;
            return this;
        }

        public String getUuid() {
            return this.uuid == null ? null : (String)this.uuid.getValue();
        }

        public CDSHooksResponseCardsComponent setUuid(String value) {
            if (Utilities.noString((String)value)) {
                this.uuid = null;
            } else {
                if (this.uuid == null) {
                    this.uuid = new UuidType();
                }
                this.uuid.setValue(value);
            }
            return this;
        }

        public StringType getSummaryElement() {
            if (this.summary == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsComponent.summary");
                }
                if (Configuration.doAutoCreate()) {
                    this.summary = new StringType();
                }
            }
            return this.summary;
        }

        public boolean hasSummaryElement() {
            return this.summary != null && !this.summary.isEmpty();
        }

        public boolean hasSummary() {
            return this.summary != null && !this.summary.isEmpty();
        }

        public CDSHooksResponseCardsComponent setSummaryElement(StringType value) {
            this.summary = value;
            return this;
        }

        public String getSummary() {
            return this.summary == null ? null : (String)this.summary.getValue();
        }

        public CDSHooksResponseCardsComponent setSummary(String value) {
            if (this.summary == null) {
                this.summary = new StringType();
            }
            this.summary.setValue(value);
            return this;
        }

        public MarkdownType getDetailElement() {
            if (this.detail == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsComponent.detail");
                }
                if (Configuration.doAutoCreate()) {
                    this.detail = new MarkdownType();
                }
            }
            return this.detail;
        }

        public boolean hasDetailElement() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public boolean hasDetail() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public CDSHooksResponseCardsComponent setDetailElement(MarkdownType value) {
            this.detail = value;
            return this;
        }

        public String getDetail() {
            return this.detail == null ? null : (String)this.detail.getValue();
        }

        public CDSHooksResponseCardsComponent setDetail(String value) {
            if (Utilities.noString((String)value)) {
                this.detail = null;
            } else {
                if (this.detail == null) {
                    this.detail = new MarkdownType();
                }
                this.detail.setValue(value);
            }
            return this;
        }

        public Enumeration<CDSIndicatorCodesVS> getIndicatorElement() {
            if (this.indicator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsComponent.indicator");
                }
                if (Configuration.doAutoCreate()) {
                    this.indicator = new Enumeration<CDSIndicatorCodesVS>(new CDSIndicatorCodesVSEnumFactory());
                }
            }
            return this.indicator;
        }

        public boolean hasIndicatorElement() {
            return this.indicator != null && !this.indicator.isEmpty();
        }

        public boolean hasIndicator() {
            return this.indicator != null && !this.indicator.isEmpty();
        }

        public CDSHooksResponseCardsComponent setIndicatorElement(Enumeration<CDSIndicatorCodesVS> value) {
            this.indicator = value;
            return this;
        }

        public CDSIndicatorCodesVS getIndicator() {
            return this.indicator == null ? null : (CDSIndicatorCodesVS)((Object)this.indicator.getValue());
        }

        public CDSHooksResponseCardsComponent setIndicator(CDSIndicatorCodesVS value) {
            if (value == null) {
                this.indicator = null;
            } else {
                if (this.indicator == null) {
                    this.indicator = new Enumeration<CDSIndicatorCodesVS>(new CDSIndicatorCodesVSEnumFactory());
                }
                this.indicator.setValue((Object)value);
            }
            return this;
        }

        public CDSHooksResponseCardsSourceComponent getSource() {
            return this.source;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public CDSHooksResponseCardsComponent setSource(CDSHooksResponseCardsSourceComponent value) {
            this.source = value;
            return this;
        }

        public List<CDSHooksResponseCardsSuggestionsComponent> getSuggestionsList() {
            if (this.suggestionsList == null) {
                this.suggestionsList = new ArrayList<CDSHooksResponseCardsSuggestionsComponent>();
            }
            return this.suggestionsList;
        }

        public CDSHooksResponseCardsComponent setSuggestionsList(List<CDSHooksResponseCardsSuggestionsComponent> theSuggestions) {
            this.suggestionsList = theSuggestions;
            return this;
        }

        public boolean hasSuggestions() {
            if (this.suggestionsList == null) {
                return false;
            }
            for (CDSHooksResponseCardsSuggestionsComponent item : this.suggestionsList) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CDSHooksResponseCardsSuggestionsComponent addSuggestions() {
            CDSHooksResponseCardsSuggestionsComponent t = new CDSHooksResponseCardsSuggestionsComponent();
            if (this.suggestionsList == null) {
                this.suggestionsList = new ArrayList<CDSHooksResponseCardsSuggestionsComponent>();
            }
            this.suggestionsList.add(t);
            return t;
        }

        public CDSHooksResponseCardsComponent addSuggestions(CDSHooksResponseCardsSuggestionsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.suggestionsList == null) {
                this.suggestionsList = new ArrayList<CDSHooksResponseCardsSuggestionsComponent>();
            }
            this.suggestionsList.add(t);
            return this;
        }

        public CDSHooksResponseCardsSuggestionsComponent getSuggestionsFirstRep() {
            if (this.getSuggestionsList().isEmpty()) {
                this.addSuggestions();
            }
            return this.getSuggestionsList().get(0);
        }

        public Enumeration<CDSSelectionBehaviorCodesVS> getSelectionBehaviorElement() {
            if (this.selectionBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsComponent.selectionBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.selectionBehavior = new Enumeration<CDSSelectionBehaviorCodesVS>(new CDSSelectionBehaviorCodesVSEnumFactory());
                }
            }
            return this.selectionBehavior;
        }

        public boolean hasSelectionBehaviorElement() {
            return this.selectionBehavior != null && !this.selectionBehavior.isEmpty();
        }

        public boolean hasSelectionBehavior() {
            return this.selectionBehavior != null && !this.selectionBehavior.isEmpty();
        }

        public CDSHooksResponseCardsComponent setSelectionBehaviorElement(Enumeration<CDSSelectionBehaviorCodesVS> value) {
            this.selectionBehavior = value;
            return this;
        }

        public CDSSelectionBehaviorCodesVS getSelectionBehavior() {
            return this.selectionBehavior == null ? null : (CDSSelectionBehaviorCodesVS)((Object)this.selectionBehavior.getValue());
        }

        public CDSHooksResponseCardsComponent setSelectionBehavior(CDSSelectionBehaviorCodesVS value) {
            if (value == null) {
                this.selectionBehavior = null;
            } else {
                if (this.selectionBehavior == null) {
                    this.selectionBehavior = new Enumeration<CDSSelectionBehaviorCodesVS>(new CDSSelectionBehaviorCodesVSEnumFactory());
                }
                this.selectionBehavior.setValue((Object)value);
            }
            return this;
        }

        public List<Coding> getOverrideReasonsList() {
            if (this.overrideReasonsList == null) {
                this.overrideReasonsList = new ArrayList<Coding>();
            }
            return this.overrideReasonsList;
        }

        public CDSHooksResponseCardsComponent setOverrideReasonsList(List<Coding> theOverrideReasons) {
            this.overrideReasonsList = theOverrideReasons;
            return this;
        }

        public boolean hasOverrideReasons() {
            if (this.overrideReasonsList == null) {
                return false;
            }
            for (Coding item : this.overrideReasonsList) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addOverrideReasons() {
            Coding t = new Coding();
            if (this.overrideReasonsList == null) {
                this.overrideReasonsList = new ArrayList<Coding>();
            }
            this.overrideReasonsList.add(t);
            return t;
        }

        public CDSHooksResponseCardsComponent addOverrideReasons(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.overrideReasonsList == null) {
                this.overrideReasonsList = new ArrayList<Coding>();
            }
            this.overrideReasonsList.add(t);
            return this;
        }

        public Coding getOverrideReasonsFirstRep() {
            if (this.getOverrideReasonsList().isEmpty()) {
                this.addOverrideReasons();
            }
            return this.getOverrideReasonsList().get(0);
        }

        public List<CDSHooksResponseCardsLinksComponent> getLinksList() {
            if (this.linksList == null) {
                this.linksList = new ArrayList<CDSHooksResponseCardsLinksComponent>();
            }
            return this.linksList;
        }

        public CDSHooksResponseCardsComponent setLinksList(List<CDSHooksResponseCardsLinksComponent> theLinks) {
            this.linksList = theLinks;
            return this;
        }

        public boolean hasLinks() {
            if (this.linksList == null) {
                return false;
            }
            for (CDSHooksResponseCardsLinksComponent item : this.linksList) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CDSHooksResponseCardsLinksComponent addLinks() {
            CDSHooksResponseCardsLinksComponent t = new CDSHooksResponseCardsLinksComponent();
            if (this.linksList == null) {
                this.linksList = new ArrayList<CDSHooksResponseCardsLinksComponent>();
            }
            this.linksList.add(t);
            return t;
        }

        public CDSHooksResponseCardsComponent addLinks(CDSHooksResponseCardsLinksComponent t) {
            if (t == null) {
                return this;
            }
            if (this.linksList == null) {
                this.linksList = new ArrayList<CDSHooksResponseCardsLinksComponent>();
            }
            this.linksList.add(t);
            return this;
        }

        public CDSHooksResponseCardsLinksComponent getLinksFirstRep() {
            if (this.getLinksList().isEmpty()) {
                this.addLinks();
            }
            return this.getLinksList().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("uuid", "uuid", "Unique identifier of the card. MAY be used for auditing and logging cards and SHALL be included in any subsequent calls to the CDS service's feedback endpoint.", 0, 1, this.uuid));
            children.add(new Property("summary", "string", "One-sentence, <140-character summary message for display to the user inside of this card.", 0, 1, this.summary));
            children.add(new Property("detail", "markdown", "Optional detailed information to display; if provided MUST be represented in (GitHub Flavored) Markdown. (For non-urgent cards, the CDS Client MAY hide these details until the user clicks a link like 'view more details...').", 0, 1, this.detail));
            children.add(new Property("indicator", "code", "Urgency/importance of what this card conveys. Allowed values, in order of increasing urgency, are: info, warning, critical.", 0, 1, this.indicator));
            children.add(new Property("source", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "The source should be the primary source of guidance for the decision support the card represents.", 0, 1, this.source));
            children.add(new Property("suggestions", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "Allows a service to suggest a set of changes in the context of the current activity (e.g. changing the dose of a medication currently being prescribed, for the order-sign activity).", 0, Integer.MAX_VALUE, this.suggestionsList));
            children.add(new Property("selectionBehavior", "code", "Describes the intended selection behavior of the suggestions in the card. Allowed values are: at-most-one, indicating that the user may choose none or at most one of the suggestions; any, indicating that the end user may choose any number of suggestions including none of them and all of them", 0, 1, this.selectionBehavior));
            children.add(new Property("overrideReasons", "Coding", "Override reasons can be selected by the end user when overriding a card without taking the suggested recommendations. The CDS service MAY return a list of override reasons to the CDS client.", 0, Integer.MAX_VALUE, this.overrideReasonsList));
            children.add(new Property("links", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "Allows a service to suggest a link to an app that the user might want to run for additional information or to help guide a decision.", 0, Integer.MAX_VALUE, this.linksList));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3601339: {
                    return new Property("uuid", "uuid", "Unique identifier of the card. MAY be used for auditing and logging cards and SHALL be included in any subsequent calls to the CDS service's feedback endpoint.", 0, 1, this.uuid);
                }
                case -1857640538: {
                    return new Property("summary", "string", "One-sentence, <140-character summary message for display to the user inside of this card.", 0, 1, this.summary);
                }
                case -1335224239: {
                    return new Property("detail", "markdown", "Optional detailed information to display; if provided MUST be represented in (GitHub Flavored) Markdown. (For non-urgent cards, the CDS Client MAY hide these details until the user clicks a link like 'view more details...').", 0, 1, this.detail);
                }
                case -711999985: {
                    return new Property("indicator", "code", "Urgency/importance of what this card conveys. Allowed values, in order of increasing urgency, are: info, warning, critical.", 0, 1, this.indicator);
                }
                case -896505829: {
                    return new Property("source", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "The source should be the primary source of guidance for the decision support the card represents.", 0, 1, this.source);
                }
                case -1525319953: {
                    return new Property("suggestions", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "Allows a service to suggest a set of changes in the context of the current activity (e.g. changing the dose of a medication currently being prescribed, for the order-sign activity).", 0, Integer.MAX_VALUE, this.suggestionsList);
                }
                case 168639486: {
                    return new Property("selectionBehavior", "code", "Describes the intended selection behavior of the suggestions in the card. Allowed values are: at-most-one, indicating that the user may choose none or at most one of the suggestions; any, indicating that the end user may choose any number of suggestions including none of them and all of them", 0, 1, this.selectionBehavior);
                }
                case -1554410173: {
                    return new Property("overrideReasons", "Coding", "Override reasons can be selected by the end user when overriding a card without taking the suggested recommendations. The CDS service MAY return a list of override reasons to the CDS client.", 0, Integer.MAX_VALUE, this.overrideReasonsList);
                }
                case 102977465: {
                    return new Property("links", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "Allows a service to suggest a link to an app that the user might want to run for additional information or to help guide a decision.", 0, Integer.MAX_VALUE, this.linksList);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3601339: {
                    Base[] baseArray;
                    if (this.uuid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uuid;
                    }
                    return baseArray;
                }
                case -1857640538: {
                    Base[] baseArray;
                    if (this.summary == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.summary;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    Base[] baseArray;
                    if (this.detail == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.detail;
                    }
                    return baseArray;
                }
                case -711999985: {
                    Base[] baseArray;
                    if (this.indicator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.indicator;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.source;
                    }
                    return baseArray;
                }
                case -1525319953: {
                    return this.suggestionsList == null ? new Base[]{} : this.suggestionsList.toArray(new Base[this.suggestionsList.size()]);
                }
                case 168639486: {
                    Base[] baseArray;
                    if (this.selectionBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.selectionBehavior;
                    }
                    return baseArray;
                }
                case -1554410173: {
                    return this.overrideReasonsList == null ? new Base[]{} : this.overrideReasonsList.toArray(new Base[this.overrideReasonsList.size()]);
                }
                case 102977465: {
                    return this.linksList == null ? new Base[]{} : this.linksList.toArray(new Base[this.linksList.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3601339: {
                    this.uuid = TypeConvertor.castToUuid(value);
                    return value;
                }
                case -1857640538: {
                    this.summary = TypeConvertor.castToString(value);
                    return value;
                }
                case -1335224239: {
                    this.detail = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -711999985: {
                    value = new CDSIndicatorCodesVSEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.indicator = value;
                    return value;
                }
                case -896505829: {
                    this.source = (CDSHooksResponseCardsSourceComponent)((Object)value);
                    return value;
                }
                case -1525319953: {
                    this.getSuggestionsList().add((CDSHooksResponseCardsSuggestionsComponent)((Object)value));
                    return value;
                }
                case 168639486: {
                    value = new CDSSelectionBehaviorCodesVSEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.selectionBehavior = value;
                    return value;
                }
                case -1554410173: {
                    this.getOverrideReasonsList().add(TypeConvertor.castToCoding(value));
                    return value;
                }
                case 102977465: {
                    this.getLinksList().add((CDSHooksResponseCardsLinksComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uuid")) {
                this.uuid = TypeConvertor.castToUuid(value);
            } else if (name.equals("summary")) {
                this.summary = TypeConvertor.castToString(value);
            } else if (name.equals("detail")) {
                this.detail = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("indicator")) {
                value = new CDSIndicatorCodesVSEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.indicator = value;
            } else if (name.equals("source")) {
                this.source = (CDSHooksResponseCardsSourceComponent)((Object)value);
            } else if (name.equals("suggestions")) {
                this.getSuggestionsList().add((CDSHooksResponseCardsSuggestionsComponent)((Object)value));
            } else if (name.equals("selectionBehavior")) {
                value = new CDSSelectionBehaviorCodesVSEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.selectionBehavior = value;
            } else if (name.equals("overrideReasons")) {
                this.getOverrideReasonsList().add(TypeConvertor.castToCoding(value));
            } else if (name.equals("links")) {
                this.getLinksList().add((CDSHooksResponseCardsLinksComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3601339: {
                    return this.getUuidElement();
                }
                case -1857640538: {
                    return this.getSummaryElement();
                }
                case -1335224239: {
                    return this.getDetailElement();
                }
                case -711999985: {
                    return this.getIndicatorElement();
                }
                case -896505829: {
                    return this.getSource();
                }
                case -1525319953: {
                    return this.addSuggestions();
                }
                case 168639486: {
                    return this.getSelectionBehaviorElement();
                }
                case -1554410173: {
                    return this.addOverrideReasons();
                }
                case 102977465: {
                    return this.addLinks();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3601339: {
                    return new String[]{"uuid"};
                }
                case -1857640538: {
                    return new String[]{"string"};
                }
                case -1335224239: {
                    return new String[]{"markdown"};
                }
                case -711999985: {
                    return new String[]{"code"};
                }
                case -896505829: {
                    return new String[]{"http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement"};
                }
                case -1525319953: {
                    return new String[]{"http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement"};
                }
                case 168639486: {
                    return new String[]{"code"};
                }
                case -1554410173: {
                    return new String[]{"Coding"};
                }
                case 102977465: {
                    return new String[]{"http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uuid")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.uuid");
            }
            if (name.equals("summary")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.summary");
            }
            if (name.equals("detail")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.detail");
            }
            if (name.equals("indicator")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.indicator");
            }
            if (name.equals("source")) {
                throw new FHIRException("Cannot call addChild on an abstract type CDSHooksResponse.cards.source");
            }
            if (name.equals("suggestions")) {
                throw new FHIRException("Cannot call addChild on an abstract type CDSHooksResponse.cards.suggestions");
            }
            if (name.equals("selectionBehavior")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.selectionBehavior");
            }
            if (name.equals("overrideReasons")) {
                return this.addOverrideReasons();
            }
            if (name.equals("links")) {
                throw new FHIRException("Cannot call addChild on an abstract type CDSHooksResponse.cards.links");
            }
            return super.addChild(name);
        }

        @Override
        public CDSHooksResponseCardsComponent copy() {
            CDSHooksResponseCardsComponent dst = new CDSHooksResponseCardsComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CDSHooksResponseCardsComponent dst) {
            super.copyValues(dst);
            dst.uuid = this.uuid == null ? null : this.uuid.copy();
            dst.summary = this.summary == null ? null : this.summary.copy();
            dst.detail = this.detail == null ? null : this.detail.copy();
            dst.indicator = this.indicator == null ? null : this.indicator.copy();
            CDSHooksResponseCardsSourceComponent cDSHooksResponseCardsSourceComponent = dst.source = this.source == null ? null : this.source.copy();
            if (this.suggestionsList != null) {
                dst.suggestionsList = new ArrayList<CDSHooksResponseCardsSuggestionsComponent>();
                for (CDSHooksResponseCardsSuggestionsComponent cDSHooksResponseCardsSuggestionsComponent : this.suggestionsList) {
                    dst.suggestionsList.add(cDSHooksResponseCardsSuggestionsComponent.copy());
                }
            }
            Enumeration<CDSSelectionBehaviorCodesVS> enumeration = dst.selectionBehavior = this.selectionBehavior == null ? null : this.selectionBehavior.copy();
            if (this.overrideReasonsList != null) {
                dst.overrideReasonsList = new ArrayList<Coding>();
                for (Coding coding : this.overrideReasonsList) {
                    dst.overrideReasonsList.add(coding.copy());
                }
            }
            if (this.linksList != null) {
                dst.linksList = new ArrayList<CDSHooksResponseCardsLinksComponent>();
                for (CDSHooksResponseCardsLinksComponent cDSHooksResponseCardsLinksComponent : this.linksList) {
                    dst.linksList.add(cDSHooksResponseCardsLinksComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksResponseCardsComponent)) {
                return false;
            }
            CDSHooksResponseCardsComponent o = (CDSHooksResponseCardsComponent)other_;
            return CDSHooksResponseCardsComponent.compareDeep(this.uuid, o.uuid, true) && CDSHooksResponseCardsComponent.compareDeep(this.summary, o.summary, true) && CDSHooksResponseCardsComponent.compareDeep(this.detail, o.detail, true) && CDSHooksResponseCardsComponent.compareDeep(this.indicator, o.indicator, true) && CDSHooksResponseCardsComponent.compareDeep(this.source, o.source, true) && CDSHooksResponseCardsComponent.compareDeep(this.suggestionsList, o.suggestionsList, true) && CDSHooksResponseCardsComponent.compareDeep(this.selectionBehavior, o.selectionBehavior, true) && CDSHooksResponseCardsComponent.compareDeep(this.overrideReasonsList, o.overrideReasonsList, true) && CDSHooksResponseCardsComponent.compareDeep(this.linksList, o.linksList, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksResponseCardsComponent)) {
                return false;
            }
            CDSHooksResponseCardsComponent o = (CDSHooksResponseCardsComponent)other_;
            return CDSHooksResponseCardsComponent.compareValues(this.uuid, o.uuid, true) && CDSHooksResponseCardsComponent.compareValues(this.summary, o.summary, true) && CDSHooksResponseCardsComponent.compareValues(this.detail, o.detail, true) && CDSHooksResponseCardsComponent.compareValues(this.indicator, o.indicator, true) && CDSHooksResponseCardsComponent.compareValues(this.selectionBehavior, o.selectionBehavior, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.uuid, this.summary, this.detail, this.indicator, this.source, this.suggestionsList, this.selectionBehavior, this.overrideReasonsList, this.linksList});
        }

        @Override
        public String fhirType() {
            return "CDSHooksResponse.cards";
        }
    }

    @Block
    public static class CDSHooksResponseCardsSuggestionsActionsComponent
    extends CDSHooksElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="create, update, delete - type of action performed", formalDefinition="The type of action being performed. Allowed values are: create, update, delete.")
        @Binding(valueSet="http://hl7.org/fhir/tools/ValueSet/CDSActionType")
        protected Enumeration<CDSActionTypeCodesVS> type;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human-readable description of the suggested action (MAY be presented to the end-user)", formalDefinition="Human-readable description of the suggested action that MAY be presented to the end-user.")
        protected StringType description;
        @Child(name="resource", type={Resource.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="FHIR resource to create/update", formalDefinition="When the type attribute is create, the resource attribute SHALL contain a new FHIR resource to be created. For update, this holds the updated resource in its entirety and not just the changed fields.")
        protected Resource resource;
        @Child(name="resourceId", type={UrlType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A relative reference to the relevant resource.", formalDefinition="A relative reference to the relevant resource. SHOULD be provided when the type attribute is delete.")
        protected UrlType resourceId;
        private static final long serialVersionUID = -1667751535L;

        public CDSHooksResponseCardsSuggestionsActionsComponent() {
        }

        public CDSHooksResponseCardsSuggestionsActionsComponent(CDSActionTypeCodesVS type) {
            this.setType(type);
        }

        public Enumeration<CDSActionTypeCodesVS> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsSuggestionsActionsComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<CDSActionTypeCodesVS>(new CDSActionTypeCodesVSEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CDSHooksResponseCardsSuggestionsActionsComponent setTypeElement(Enumeration<CDSActionTypeCodesVS> value) {
            this.type = value;
            return this;
        }

        public CDSActionTypeCodesVS getType() {
            return this.type == null ? null : (CDSActionTypeCodesVS)((Object)this.type.getValue());
        }

        public CDSHooksResponseCardsSuggestionsActionsComponent setType(CDSActionTypeCodesVS value) {
            if (this.type == null) {
                this.type = new Enumeration<CDSActionTypeCodesVS>(new CDSActionTypeCodesVSEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsSuggestionsActionsComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public CDSHooksResponseCardsSuggestionsActionsComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public CDSHooksResponseCardsSuggestionsActionsComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Resource getResource() {
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public CDSHooksResponseCardsSuggestionsActionsComponent setResource(Resource value) {
            this.resource = value;
            return this;
        }

        public UrlType getResourceIdElement() {
            if (this.resourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsSuggestionsActionsComponent.resourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.resourceId = new UrlType();
                }
            }
            return this.resourceId;
        }

        public boolean hasResourceIdElement() {
            return this.resourceId != null && !this.resourceId.isEmpty();
        }

        public boolean hasResourceId() {
            return this.resourceId != null && !this.resourceId.isEmpty();
        }

        public CDSHooksResponseCardsSuggestionsActionsComponent setResourceIdElement(UrlType value) {
            this.resourceId = value;
            return this;
        }

        public String getResourceId() {
            return this.resourceId == null ? null : (String)this.resourceId.getValue();
        }

        public CDSHooksResponseCardsSuggestionsActionsComponent setResourceId(String value) {
            if (Utilities.noString((String)value)) {
                this.resourceId = null;
            } else {
                if (this.resourceId == null) {
                    this.resourceId = new UrlType();
                }
                this.resourceId.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "The type of action being performed. Allowed values are: create, update, delete.", 0, 1, this.type));
            children.add(new Property("description", "string", "Human-readable description of the suggested action that MAY be presented to the end-user.", 0, 1, this.description));
            children.add(new Property("resource", "Resource", "When the type attribute is create, the resource attribute SHALL contain a new FHIR resource to be created. For update, this holds the updated resource in its entirety and not just the changed fields.", 0, 1, this.resource));
            children.add(new Property("resourceId", "url", "A relative reference to the relevant resource. SHOULD be provided when the type attribute is delete.", 0, 1, this.resourceId));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "The type of action being performed. Allowed values are: create, update, delete.", 0, 1, this.type);
                }
                case -1724546052: {
                    return new Property("description", "string", "Human-readable description of the suggested action that MAY be presented to the end-user.", 0, 1, this.description);
                }
                case -341064690: {
                    return new Property("resource", "Resource", "When the type attribute is create, the resource attribute SHALL contain a new FHIR resource to be created. For update, this holds the updated resource in its entirety and not just the changed fields.", 0, 1, this.resource);
                }
                case -1345650231: {
                    return new Property("resourceId", "url", "A relative reference to the relevant resource. SHOULD be provided when the type attribute is delete.", 0, 1, this.resourceId);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.resource;
                    }
                    return baseArray;
                }
                case -1345650231: {
                    Base[] baseArray;
                    if (this.resourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.resourceId;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new CDSActionTypeCodesVSEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -341064690: {
                    this.resource = (Resource)((Object)value);
                    return value;
                }
                case -1345650231: {
                    this.resourceId = TypeConvertor.castToUrl(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new CDSActionTypeCodesVSEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("resource")) {
                this.resource = (Resource)((Object)value);
            } else if (name.equals("resourceId")) {
                this.resourceId = TypeConvertor.castToUrl(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -341064690: {
                    throw new FHIRException("Cannot make property resource as it is not a complex type");
                }
                case -1345650231: {
                    return this.getResourceIdElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -341064690: {
                    return new String[]{"Resource"};
                }
                case -1345650231: {
                    return new String[]{"url"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.suggestions.actions.type");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.suggestions.actions.description");
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on an abstract type CDSHooksResponse.cards.suggestions.actions.resource");
            }
            if (name.equals("resourceId")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.suggestions.actions.resourceId");
            }
            return super.addChild(name);
        }

        @Override
        public CDSHooksResponseCardsSuggestionsActionsComponent copy() {
            CDSHooksResponseCardsSuggestionsActionsComponent dst = new CDSHooksResponseCardsSuggestionsActionsComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CDSHooksResponseCardsSuggestionsActionsComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            dst.resourceId = this.resourceId == null ? null : this.resourceId.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksResponseCardsSuggestionsActionsComponent)) {
                return false;
            }
            CDSHooksResponseCardsSuggestionsActionsComponent o = (CDSHooksResponseCardsSuggestionsActionsComponent)other_;
            return CDSHooksResponseCardsSuggestionsActionsComponent.compareDeep(this.type, o.type, true) && CDSHooksResponseCardsSuggestionsActionsComponent.compareDeep(this.description, o.description, true) && CDSHooksResponseCardsSuggestionsActionsComponent.compareDeep(this.resource, o.resource, true) && CDSHooksResponseCardsSuggestionsActionsComponent.compareDeep(this.resourceId, o.resourceId, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksResponseCardsSuggestionsActionsComponent)) {
                return false;
            }
            CDSHooksResponseCardsSuggestionsActionsComponent o = (CDSHooksResponseCardsSuggestionsActionsComponent)other_;
            return CDSHooksResponseCardsSuggestionsActionsComponent.compareValues(this.type, o.type, true) && CDSHooksResponseCardsSuggestionsActionsComponent.compareValues(this.description, o.description, true) && CDSHooksResponseCardsSuggestionsActionsComponent.compareValues(this.resourceId, o.resourceId, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.description, this.resource, this.resourceId});
        }

        @Override
        public String fhirType() {
            return "CDSHooksResponse.cards.suggestions.actions";
        }
    }

    @Block
    public static class CDSHooksResponseCardsLinksComponent
    extends CDSHooksElement {
        @Child(name="label", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human-readable label to display for this link (e.g. the CDS Client might render this as the underlined text of a clickable link).", formalDefinition="Human-readable label to display for this link (e.g. the CDS Client might render this as the underlined text of a clickable link).")
        protected StringType label;
        @Child(name="url", type={UrlType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="URL to load (via GET, in a browser context) when a user clicks on this link. Note that this MAY be a 'deep link' with context embedded in path segments, query parameters, or a hash.", formalDefinition="URL to load (via GET, in a browser context) when a user clicks on this link. Note that this MAY be a 'deep link' with context embedded in path segments, query parameters, or a hash.")
        protected UrlType url;
        @Child(name="type", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="absolute, smart - how to use the link", formalDefinition="The type of the given URL. There are two possible values for this field. A type of absolute indicates that the URL is absolute and should be treated as-is. A type of smart indicates that the URL is a SMART app launch URL and the CDS Client should ensure the SMART app launch URL is populated with the appropriate SMART launch parameters")
        @Binding(valueSet="http://hl7.org/fhir/tools/ValueSet/CDSLinkType")
        protected Enumeration<CDSLinkTypeCodesVS> type;
        @Child(name="appContext", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Allows the CDS Service to share information from the CDS card with a subsequently launched SMART app", formalDefinition="An optional field that allows the CDS Service to share information from the CDS card with a subsequently launched SMART app. The appContext field should only be valued if the link type is smart and is not valid for absolute links. The appContext field and value will be sent to the SMART app as part of the OAuth 2.0 access token response, alongside the other SMART launch parameters when the SMART app is launched. Note that appContext could be escaped JSON, base64 encoded XML, or even a simple string, so long as the SMART app can recognize it.")
        protected StringType appContext;
        private static final long serialVersionUID = 1992417446L;

        public CDSHooksResponseCardsLinksComponent() {
        }

        public CDSHooksResponseCardsLinksComponent(String label, String url) {
            this.setLabel(label);
            this.setUrl(url);
        }

        public StringType getLabelElement() {
            if (this.label == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsLinksComponent.label");
                }
                if (Configuration.doAutoCreate()) {
                    this.label = new StringType();
                }
            }
            return this.label;
        }

        public boolean hasLabelElement() {
            return this.label != null && !this.label.isEmpty();
        }

        public boolean hasLabel() {
            return this.label != null && !this.label.isEmpty();
        }

        public CDSHooksResponseCardsLinksComponent setLabelElement(StringType value) {
            this.label = value;
            return this;
        }

        public String getLabel() {
            return this.label == null ? null : (String)this.label.getValue();
        }

        public CDSHooksResponseCardsLinksComponent setLabel(String value) {
            if (this.label == null) {
                this.label = new StringType();
            }
            this.label.setValue(value);
            return this;
        }

        public UrlType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsLinksComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UrlType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public CDSHooksResponseCardsLinksComponent setUrlElement(UrlType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public CDSHooksResponseCardsLinksComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UrlType();
            }
            this.url.setValue(value);
            return this;
        }

        public Enumeration<CDSLinkTypeCodesVS> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsLinksComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<CDSLinkTypeCodesVS>(new CDSLinkTypeCodesVSEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CDSHooksResponseCardsLinksComponent setTypeElement(Enumeration<CDSLinkTypeCodesVS> value) {
            this.type = value;
            return this;
        }

        public CDSLinkTypeCodesVS getType() {
            return this.type == null ? null : (CDSLinkTypeCodesVS)((Object)this.type.getValue());
        }

        public CDSHooksResponseCardsLinksComponent setType(CDSLinkTypeCodesVS value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<CDSLinkTypeCodesVS>(new CDSLinkTypeCodesVSEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public StringType getAppContextElement() {
            if (this.appContext == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsLinksComponent.appContext");
                }
                if (Configuration.doAutoCreate()) {
                    this.appContext = new StringType();
                }
            }
            return this.appContext;
        }

        public boolean hasAppContextElement() {
            return this.appContext != null && !this.appContext.isEmpty();
        }

        public boolean hasAppContext() {
            return this.appContext != null && !this.appContext.isEmpty();
        }

        public CDSHooksResponseCardsLinksComponent setAppContextElement(StringType value) {
            this.appContext = value;
            return this;
        }

        public String getAppContext() {
            return this.appContext == null ? null : (String)this.appContext.getValue();
        }

        public CDSHooksResponseCardsLinksComponent setAppContext(String value) {
            if (Utilities.noString((String)value)) {
                this.appContext = null;
            } else {
                if (this.appContext == null) {
                    this.appContext = new StringType();
                }
                this.appContext.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("label", "string", "Human-readable label to display for this link (e.g. the CDS Client might render this as the underlined text of a clickable link).", 0, 1, this.label));
            children.add(new Property("url", "url", "URL to load (via GET, in a browser context) when a user clicks on this link. Note that this MAY be a 'deep link' with context embedded in path segments, query parameters, or a hash.", 0, 1, this.url));
            children.add(new Property("type", "code", "The type of the given URL. There are two possible values for this field. A type of absolute indicates that the URL is absolute and should be treated as-is. A type of smart indicates that the URL is a SMART app launch URL and the CDS Client should ensure the SMART app launch URL is populated with the appropriate SMART launch parameters", 0, 1, this.type));
            children.add(new Property("appContext", "string", "An optional field that allows the CDS Service to share information from the CDS card with a subsequently launched SMART app. The appContext field should only be valued if the link type is smart and is not valid for absolute links. The appContext field and value will be sent to the SMART app as part of the OAuth 2.0 access token response, alongside the other SMART launch parameters when the SMART app is launched. Note that appContext could be escaped JSON, base64 encoded XML, or even a simple string, so long as the SMART app can recognize it.", 0, 1, this.appContext));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 102727412: {
                    return new Property("label", "string", "Human-readable label to display for this link (e.g. the CDS Client might render this as the underlined text of a clickable link).", 0, 1, this.label);
                }
                case 116079: {
                    return new Property("url", "url", "URL to load (via GET, in a browser context) when a user clicks on this link. Note that this MAY be a 'deep link' with context embedded in path segments, query parameters, or a hash.", 0, 1, this.url);
                }
                case 3575610: {
                    return new Property("type", "code", "The type of the given URL. There are two possible values for this field. A type of absolute indicates that the URL is absolute and should be treated as-is. A type of smart indicates that the URL is a SMART app launch URL and the CDS Client should ensure the SMART app launch URL is populated with the appropriate SMART launch parameters", 0, 1, this.type);
                }
                case 2084035662: {
                    return new Property("appContext", "string", "An optional field that allows the CDS Service to share information from the CDS card with a subsequently launched SMART app. The appContext field should only be valued if the link type is smart and is not valid for absolute links. The appContext field and value will be sent to the SMART app as part of the OAuth 2.0 access token response, alongside the other SMART launch parameters when the SMART app is launched. Note that appContext could be escaped JSON, base64 encoded XML, or even a simple string, so long as the SMART app can recognize it.", 0, 1, this.appContext);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    Base[] baseArray;
                    if (this.label == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.label;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.type;
                    }
                    return baseArray;
                }
                case 2084035662: {
                    Base[] baseArray;
                    if (this.appContext == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.appContext;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    this.label = TypeConvertor.castToString(value);
                    return value;
                }
                case 116079: {
                    this.url = TypeConvertor.castToUrl(value);
                    return value;
                }
                case 3575610: {
                    value = new CDSLinkTypeCodesVSEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 2084035662: {
                    this.appContext = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("label")) {
                this.label = TypeConvertor.castToString(value);
            } else if (name.equals("url")) {
                this.url = TypeConvertor.castToUrl(value);
            } else if (name.equals("type")) {
                value = new CDSLinkTypeCodesVSEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("appContext")) {
                this.appContext = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return this.getLabelElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 2084035662: {
                    return this.getAppContextElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return new String[]{"string"};
                }
                case 116079: {
                    return new String[]{"url"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
                case 2084035662: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("label")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.links.label");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.links.url");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.links.type");
            }
            if (name.equals("appContext")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.links.appContext");
            }
            return super.addChild(name);
        }

        @Override
        public CDSHooksResponseCardsLinksComponent copy() {
            CDSHooksResponseCardsLinksComponent dst = new CDSHooksResponseCardsLinksComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CDSHooksResponseCardsLinksComponent dst) {
            super.copyValues(dst);
            dst.label = this.label == null ? null : this.label.copy();
            dst.url = this.url == null ? null : this.url.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.appContext = this.appContext == null ? null : this.appContext.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksResponseCardsLinksComponent)) {
                return false;
            }
            CDSHooksResponseCardsLinksComponent o = (CDSHooksResponseCardsLinksComponent)other_;
            return CDSHooksResponseCardsLinksComponent.compareDeep(this.label, o.label, true) && CDSHooksResponseCardsLinksComponent.compareDeep(this.url, o.url, true) && CDSHooksResponseCardsLinksComponent.compareDeep(this.type, o.type, true) && CDSHooksResponseCardsLinksComponent.compareDeep(this.appContext, o.appContext, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksResponseCardsLinksComponent)) {
                return false;
            }
            CDSHooksResponseCardsLinksComponent o = (CDSHooksResponseCardsLinksComponent)other_;
            return CDSHooksResponseCardsLinksComponent.compareValues(this.label, o.label, true) && CDSHooksResponseCardsLinksComponent.compareValues(this.url, o.url, true) && CDSHooksResponseCardsLinksComponent.compareValues(this.type, o.type, true) && CDSHooksResponseCardsLinksComponent.compareValues(this.appContext, o.appContext, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.label, this.url, this.type, this.appContext});
        }

        @Override
        public String fhirType() {
            return "CDSHooksResponse.cards.links";
        }
    }

    @Block
    public static class CDSHooksResponseCardsSuggestionsComponent
    extends CDSHooksElement {
        @Child(name="label", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human-readable label to display for this suggestion", formalDefinition="Human-readable label to display for this suggestion")
        protected StringType label;
        @Child(name="uuid", type={UuidType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Unique identifier, used for auditing and logging suggestions", formalDefinition="Unique identifier, used for auditing and logging suggestions")
        protected UuidType uuid;
        @Child(name="isRecommended", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="When there are multiple suggestions, allows a service to indicate that a specific suggestion is recommended from all the available suggestions on the card")
        protected BooleanType isRecommended;
        @Child(name="actions", type={CDSHooksElement.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Defines a suggested action (all apply)", formalDefinition="Defines a suggested action. Within a suggestion, all actions are logically AND'd together, such that a user selecting a suggestion selects all of the actions within it")
        protected List<CDSHooksResponseCardsSuggestionsActionsComponent> actionsList;
        private static final long serialVersionUID = 89077716L;

        public CDSHooksResponseCardsSuggestionsComponent() {
        }

        public CDSHooksResponseCardsSuggestionsComponent(String label) {
            this.setLabel(label);
        }

        public StringType getLabelElement() {
            if (this.label == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsSuggestionsComponent.label");
                }
                if (Configuration.doAutoCreate()) {
                    this.label = new StringType();
                }
            }
            return this.label;
        }

        public boolean hasLabelElement() {
            return this.label != null && !this.label.isEmpty();
        }

        public boolean hasLabel() {
            return this.label != null && !this.label.isEmpty();
        }

        public CDSHooksResponseCardsSuggestionsComponent setLabelElement(StringType value) {
            this.label = value;
            return this;
        }

        public String getLabel() {
            return this.label == null ? null : (String)this.label.getValue();
        }

        public CDSHooksResponseCardsSuggestionsComponent setLabel(String value) {
            if (this.label == null) {
                this.label = new StringType();
            }
            this.label.setValue(value);
            return this;
        }

        public UuidType getUuidElement() {
            if (this.uuid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsSuggestionsComponent.uuid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uuid = new UuidType();
                }
            }
            return this.uuid;
        }

        public boolean hasUuidElement() {
            return this.uuid != null && !this.uuid.isEmpty();
        }

        public boolean hasUuid() {
            return this.uuid != null && !this.uuid.isEmpty();
        }

        public CDSHooksResponseCardsSuggestionsComponent setUuidElement(UuidType value) {
            this.uuid = value;
            return this;
        }

        public String getUuid() {
            return this.uuid == null ? null : (String)this.uuid.getValue();
        }

        public CDSHooksResponseCardsSuggestionsComponent setUuid(String value) {
            if (Utilities.noString((String)value)) {
                this.uuid = null;
            } else {
                if (this.uuid == null) {
                    this.uuid = new UuidType();
                }
                this.uuid.setValue(value);
            }
            return this;
        }

        public BooleanType getIsRecommendedElement() {
            if (this.isRecommended == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsSuggestionsComponent.isRecommended");
                }
                if (Configuration.doAutoCreate()) {
                    this.isRecommended = new BooleanType();
                }
            }
            return this.isRecommended;
        }

        public boolean hasIsRecommendedElement() {
            return this.isRecommended != null && !this.isRecommended.isEmpty();
        }

        public boolean hasIsRecommended() {
            return this.isRecommended != null && !this.isRecommended.isEmpty();
        }

        public CDSHooksResponseCardsSuggestionsComponent setIsRecommendedElement(BooleanType value) {
            this.isRecommended = value;
            return this;
        }

        public boolean getIsRecommended() {
            return this.isRecommended == null || this.isRecommended.isEmpty() ? false : (Boolean)this.isRecommended.getValue();
        }

        public CDSHooksResponseCardsSuggestionsComponent setIsRecommended(boolean value) {
            if (this.isRecommended == null) {
                this.isRecommended = new BooleanType();
            }
            this.isRecommended.setValue((Object)value);
            return this;
        }

        public List<CDSHooksResponseCardsSuggestionsActionsComponent> getActionsList() {
            if (this.actionsList == null) {
                this.actionsList = new ArrayList<CDSHooksResponseCardsSuggestionsActionsComponent>();
            }
            return this.actionsList;
        }

        public CDSHooksResponseCardsSuggestionsComponent setActionsList(List<CDSHooksResponseCardsSuggestionsActionsComponent> theActions) {
            this.actionsList = theActions;
            return this;
        }

        public boolean hasActions() {
            if (this.actionsList == null) {
                return false;
            }
            for (CDSHooksResponseCardsSuggestionsActionsComponent item : this.actionsList) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CDSHooksResponseCardsSuggestionsActionsComponent addActions() {
            CDSHooksResponseCardsSuggestionsActionsComponent t = new CDSHooksResponseCardsSuggestionsActionsComponent();
            if (this.actionsList == null) {
                this.actionsList = new ArrayList<CDSHooksResponseCardsSuggestionsActionsComponent>();
            }
            this.actionsList.add(t);
            return t;
        }

        public CDSHooksResponseCardsSuggestionsComponent addActions(CDSHooksResponseCardsSuggestionsActionsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.actionsList == null) {
                this.actionsList = new ArrayList<CDSHooksResponseCardsSuggestionsActionsComponent>();
            }
            this.actionsList.add(t);
            return this;
        }

        public CDSHooksResponseCardsSuggestionsActionsComponent getActionsFirstRep() {
            if (this.getActionsList().isEmpty()) {
                this.addActions();
            }
            return this.getActionsList().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("label", "string", "Human-readable label to display for this suggestion", 0, 1, this.label));
            children.add(new Property("uuid", "uuid", "Unique identifier, used for auditing and logging suggestions", 0, 1, this.uuid));
            children.add(new Property("isRecommended", "boolean", "When there are multiple suggestions, allows a service to indicate that a specific suggestion is recommended from all the available suggestions on the card", 0, 1, this.isRecommended));
            children.add(new Property("actions", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "Defines a suggested action. Within a suggestion, all actions are logically AND'd together, such that a user selecting a suggestion selects all of the actions within it", 0, Integer.MAX_VALUE, this.actionsList));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 102727412: {
                    return new Property("label", "string", "Human-readable label to display for this suggestion", 0, 1, this.label);
                }
                case 3601339: {
                    return new Property("uuid", "uuid", "Unique identifier, used for auditing and logging suggestions", 0, 1, this.uuid);
                }
                case 27884241: {
                    return new Property("isRecommended", "boolean", "When there are multiple suggestions, allows a service to indicate that a specific suggestion is recommended from all the available suggestions on the card", 0, 1, this.isRecommended);
                }
                case -1161803523: {
                    return new Property("actions", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "Defines a suggested action. Within a suggestion, all actions are logically AND'd together, such that a user selecting a suggestion selects all of the actions within it", 0, Integer.MAX_VALUE, this.actionsList);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    Base[] baseArray;
                    if (this.label == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.label;
                    }
                    return baseArray;
                }
                case 3601339: {
                    Base[] baseArray;
                    if (this.uuid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uuid;
                    }
                    return baseArray;
                }
                case 27884241: {
                    Base[] baseArray;
                    if (this.isRecommended == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.isRecommended;
                    }
                    return baseArray;
                }
                case -1161803523: {
                    return this.actionsList == null ? new Base[]{} : this.actionsList.toArray(new Base[this.actionsList.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    this.label = TypeConvertor.castToString(value);
                    return value;
                }
                case 3601339: {
                    this.uuid = TypeConvertor.castToUuid(value);
                    return value;
                }
                case 27884241: {
                    this.isRecommended = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1161803523: {
                    this.getActionsList().add((CDSHooksResponseCardsSuggestionsActionsComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("label")) {
                this.label = TypeConvertor.castToString(value);
            } else if (name.equals("uuid")) {
                this.uuid = TypeConvertor.castToUuid(value);
            } else if (name.equals("isRecommended")) {
                this.isRecommended = TypeConvertor.castToBoolean(value);
            } else if (name.equals("actions")) {
                this.getActionsList().add((CDSHooksResponseCardsSuggestionsActionsComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return this.getLabelElement();
                }
                case 3601339: {
                    return this.getUuidElement();
                }
                case 27884241: {
                    return this.getIsRecommendedElement();
                }
                case -1161803523: {
                    return this.addActions();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return new String[]{"string"};
                }
                case 3601339: {
                    return new String[]{"uuid"};
                }
                case 27884241: {
                    return new String[]{"boolean"};
                }
                case -1161803523: {
                    return new String[]{"http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("label")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.suggestions.label");
            }
            if (name.equals("uuid")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.suggestions.uuid");
            }
            if (name.equals("isRecommended")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.suggestions.isRecommended");
            }
            if (name.equals("actions")) {
                throw new FHIRException("Cannot call addChild on an abstract type CDSHooksResponse.cards.suggestions.actions");
            }
            return super.addChild(name);
        }

        @Override
        public CDSHooksResponseCardsSuggestionsComponent copy() {
            CDSHooksResponseCardsSuggestionsComponent dst = new CDSHooksResponseCardsSuggestionsComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CDSHooksResponseCardsSuggestionsComponent dst) {
            super.copyValues(dst);
            dst.label = this.label == null ? null : this.label.copy();
            dst.uuid = this.uuid == null ? null : this.uuid.copy();
            BooleanType booleanType = dst.isRecommended = this.isRecommended == null ? null : this.isRecommended.copy();
            if (this.actionsList != null) {
                dst.actionsList = new ArrayList<CDSHooksResponseCardsSuggestionsActionsComponent>();
                for (CDSHooksResponseCardsSuggestionsActionsComponent i : this.actionsList) {
                    dst.actionsList.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksResponseCardsSuggestionsComponent)) {
                return false;
            }
            CDSHooksResponseCardsSuggestionsComponent o = (CDSHooksResponseCardsSuggestionsComponent)other_;
            return CDSHooksResponseCardsSuggestionsComponent.compareDeep(this.label, o.label, true) && CDSHooksResponseCardsSuggestionsComponent.compareDeep(this.uuid, o.uuid, true) && CDSHooksResponseCardsSuggestionsComponent.compareDeep(this.isRecommended, o.isRecommended, true) && CDSHooksResponseCardsSuggestionsComponent.compareDeep(this.actionsList, o.actionsList, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksResponseCardsSuggestionsComponent)) {
                return false;
            }
            CDSHooksResponseCardsSuggestionsComponent o = (CDSHooksResponseCardsSuggestionsComponent)other_;
            return CDSHooksResponseCardsSuggestionsComponent.compareValues(this.label, o.label, true) && CDSHooksResponseCardsSuggestionsComponent.compareValues(this.uuid, o.uuid, true) && CDSHooksResponseCardsSuggestionsComponent.compareValues(this.isRecommended, o.isRecommended, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.label, this.uuid, this.isRecommended, this.actionsList});
        }

        @Override
        public String fhirType() {
            return "CDSHooksResponse.cards.suggestions";
        }
    }

    @Block
    public static class CDSHooksResponseCardsSourceComponent
    extends CDSHooksElement {
        @Child(name="label", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short, human-readable label to display for the source.", formalDefinition="A short, human-readable label to display for the source of the information displayed on this card. If a url is also specified, this MAY be the text for the hyperlink.")
        protected StringType label;
        @Child(name="url", type={UrlType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Link for when user clicks for more information about the source", formalDefinition="An optional absolute URL to load (via GET, in a browser context) when a user clicks on this link to learn more about the organization or data set that provided the information on this card.")
        protected UrlType url;
        @Child(name="icon", type={UrlType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="absolute URL to an icon for the source (<100x100 PNG))", formalDefinition="An absolute URL to an icon for the source of this card. The icon returned by this URL SHOULD be a 100x100 pixel PNG image without any transparent regions. The CDS Client may ignore or scale the image during display as appropriate for user experience.")
        protected UrlType icon;
        @Child(name="topic", type={Coding.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Describes the content of the card - can be useful for filtering, searching or ordered display", formalDefinition="A topic describes the content of the card by providing a high-level categorization that can be useful for filtering, searching or ordered display of related cards in the CDS client's UI. This specification does not prescribe a standard set of topics")
        protected Coding topic;
        private static final long serialVersionUID = -271286704L;

        public CDSHooksResponseCardsSourceComponent() {
        }

        public CDSHooksResponseCardsSourceComponent(String label) {
            this.setLabel(label);
        }

        public StringType getLabelElement() {
            if (this.label == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsSourceComponent.label");
                }
                if (Configuration.doAutoCreate()) {
                    this.label = new StringType();
                }
            }
            return this.label;
        }

        public boolean hasLabelElement() {
            return this.label != null && !this.label.isEmpty();
        }

        public boolean hasLabel() {
            return this.label != null && !this.label.isEmpty();
        }

        public CDSHooksResponseCardsSourceComponent setLabelElement(StringType value) {
            this.label = value;
            return this;
        }

        public String getLabel() {
            return this.label == null ? null : (String)this.label.getValue();
        }

        public CDSHooksResponseCardsSourceComponent setLabel(String value) {
            if (this.label == null) {
                this.label = new StringType();
            }
            this.label.setValue(value);
            return this;
        }

        public UrlType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsSourceComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UrlType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public CDSHooksResponseCardsSourceComponent setUrlElement(UrlType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public CDSHooksResponseCardsSourceComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UrlType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        public UrlType getIconElement() {
            if (this.icon == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsSourceComponent.icon");
                }
                if (Configuration.doAutoCreate()) {
                    this.icon = new UrlType();
                }
            }
            return this.icon;
        }

        public boolean hasIconElement() {
            return this.icon != null && !this.icon.isEmpty();
        }

        public boolean hasIcon() {
            return this.icon != null && !this.icon.isEmpty();
        }

        public CDSHooksResponseCardsSourceComponent setIconElement(UrlType value) {
            this.icon = value;
            return this;
        }

        public String getIcon() {
            return this.icon == null ? null : (String)this.icon.getValue();
        }

        public CDSHooksResponseCardsSourceComponent setIcon(String value) {
            if (Utilities.noString((String)value)) {
                this.icon = null;
            } else {
                if (this.icon == null) {
                    this.icon = new UrlType();
                }
                this.icon.setValue(value);
            }
            return this;
        }

        public Coding getTopic() {
            if (this.topic == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksResponseCardsSourceComponent.topic");
                }
                if (Configuration.doAutoCreate()) {
                    this.topic = new Coding();
                }
            }
            return this.topic;
        }

        public boolean hasTopic() {
            return this.topic != null && !this.topic.isEmpty();
        }

        public CDSHooksResponseCardsSourceComponent setTopic(Coding value) {
            this.topic = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("label", "string", "A short, human-readable label to display for the source of the information displayed on this card. If a url is also specified, this MAY be the text for the hyperlink.", 0, 1, this.label));
            children.add(new Property("url", "url", "An optional absolute URL to load (via GET, in a browser context) when a user clicks on this link to learn more about the organization or data set that provided the information on this card.", 0, 1, this.url));
            children.add(new Property("icon", "url", "An absolute URL to an icon for the source of this card. The icon returned by this URL SHOULD be a 100x100 pixel PNG image without any transparent regions. The CDS Client may ignore or scale the image during display as appropriate for user experience.", 0, 1, this.icon));
            children.add(new Property("topic", "Coding", "A topic describes the content of the card by providing a high-level categorization that can be useful for filtering, searching or ordered display of related cards in the CDS client's UI. This specification does not prescribe a standard set of topics", 0, 1, this.topic));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 102727412: {
                    return new Property("label", "string", "A short, human-readable label to display for the source of the information displayed on this card. If a url is also specified, this MAY be the text for the hyperlink.", 0, 1, this.label);
                }
                case 116079: {
                    return new Property("url", "url", "An optional absolute URL to load (via GET, in a browser context) when a user clicks on this link to learn more about the organization or data set that provided the information on this card.", 0, 1, this.url);
                }
                case 3226745: {
                    return new Property("icon", "url", "An absolute URL to an icon for the source of this card. The icon returned by this URL SHOULD be a 100x100 pixel PNG image without any transparent regions. The CDS Client may ignore or scale the image during display as appropriate for user experience.", 0, 1, this.icon);
                }
                case 110546223: {
                    return new Property("topic", "Coding", "A topic describes the content of the card by providing a high-level categorization that can be useful for filtering, searching or ordered display of related cards in the CDS client's UI. This specification does not prescribe a standard set of topics", 0, 1, this.topic);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    Base[] baseArray;
                    if (this.label == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.label;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
                case 3226745: {
                    Base[] baseArray;
                    if (this.icon == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.icon;
                    }
                    return baseArray;
                }
                case 110546223: {
                    Base[] baseArray;
                    if (this.topic == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.topic;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    this.label = TypeConvertor.castToString(value);
                    return value;
                }
                case 116079: {
                    this.url = TypeConvertor.castToUrl(value);
                    return value;
                }
                case 3226745: {
                    this.icon = TypeConvertor.castToUrl(value);
                    return value;
                }
                case 110546223: {
                    this.topic = TypeConvertor.castToCoding(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("label")) {
                this.label = TypeConvertor.castToString(value);
            } else if (name.equals("url")) {
                this.url = TypeConvertor.castToUrl(value);
            } else if (name.equals("icon")) {
                this.icon = TypeConvertor.castToUrl(value);
            } else if (name.equals("topic")) {
                this.topic = TypeConvertor.castToCoding(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return this.getLabelElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
                case 3226745: {
                    return this.getIconElement();
                }
                case 110546223: {
                    return this.getTopic();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return new String[]{"string"};
                }
                case 116079: {
                    return new String[]{"url"};
                }
                case 3226745: {
                    return new String[]{"url"};
                }
                case 110546223: {
                    return new String[]{"Coding"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("label")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.source.label");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.source.url");
            }
            if (name.equals("icon")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksResponse.cards.source.icon");
            }
            if (name.equals("topic")) {
                this.topic = new Coding();
                return this.topic;
            }
            return super.addChild(name);
        }

        @Override
        public CDSHooksResponseCardsSourceComponent copy() {
            CDSHooksResponseCardsSourceComponent dst = new CDSHooksResponseCardsSourceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CDSHooksResponseCardsSourceComponent dst) {
            super.copyValues(dst);
            dst.label = this.label == null ? null : this.label.copy();
            dst.url = this.url == null ? null : this.url.copy();
            dst.icon = this.icon == null ? null : this.icon.copy();
            dst.topic = this.topic == null ? null : this.topic.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksResponseCardsSourceComponent)) {
                return false;
            }
            CDSHooksResponseCardsSourceComponent o = (CDSHooksResponseCardsSourceComponent)other_;
            return CDSHooksResponseCardsSourceComponent.compareDeep(this.label, o.label, true) && CDSHooksResponseCardsSourceComponent.compareDeep(this.url, o.url, true) && CDSHooksResponseCardsSourceComponent.compareDeep(this.icon, o.icon, true) && CDSHooksResponseCardsSourceComponent.compareDeep(this.topic, o.topic, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksResponseCardsSourceComponent)) {
                return false;
            }
            CDSHooksResponseCardsSourceComponent o = (CDSHooksResponseCardsSourceComponent)other_;
            return CDSHooksResponseCardsSourceComponent.compareValues(this.label, o.label, true) && CDSHooksResponseCardsSourceComponent.compareValues(this.url, o.url, true) && CDSHooksResponseCardsSourceComponent.compareValues(this.icon, o.icon, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.label, this.url, this.icon, this.topic});
        }

        @Override
        public String fhirType() {
            return "CDSHooksResponse.cards.source";
        }
    }

    public static class CDSSelectionBehaviorCodesVSEnumFactory
    implements EnumFactory<CDSSelectionBehaviorCodesVS> {
        @Override
        public CDSSelectionBehaviorCodesVS fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("at-most-one".equals(codeString)) {
                return CDSSelectionBehaviorCodesVS.ATMOSTONE;
            }
            if ("any".equals(codeString)) {
                return CDSSelectionBehaviorCodesVS.ANY;
            }
            throw new IllegalArgumentException("Unknown CDSSelectionBehaviorCodesVS code '" + codeString + "'");
        }

        public Enumeration<CDSSelectionBehaviorCodesVS> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CDSSelectionBehaviorCodesVS>(this, CDSSelectionBehaviorCodesVS.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<CDSSelectionBehaviorCodesVS>(this, CDSSelectionBehaviorCodesVS.NULL, code);
            }
            if ("at-most-one".equals(codeString)) {
                return new Enumeration<CDSSelectionBehaviorCodesVS>(this, CDSSelectionBehaviorCodesVS.ATMOSTONE, code);
            }
            if ("any".equals(codeString)) {
                return new Enumeration<CDSSelectionBehaviorCodesVS>(this, CDSSelectionBehaviorCodesVS.ANY, code);
            }
            throw new FHIRException("Unknown CDSSelectionBehaviorCodesVS code '" + codeString + "'");
        }

        @Override
        public String toCode(CDSSelectionBehaviorCodesVS code) {
            if (code == CDSSelectionBehaviorCodesVS.ATMOSTONE) {
                return "at-most-one";
            }
            if (code == CDSSelectionBehaviorCodesVS.ANY) {
                return "any";
            }
            return "?";
        }

        @Override
        public String toSystem(CDSSelectionBehaviorCodesVS code) {
            return code.getSystem();
        }
    }

    public static enum CDSSelectionBehaviorCodesVS {
        ATMOSTONE,
        ANY,
        NULL;


        public static CDSSelectionBehaviorCodesVS fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("at-most-one".equals(codeString)) {
                return ATMOSTONE;
            }
            if ("any".equals(codeString)) {
                return ANY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CDSSelectionBehaviorCodesVS code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ATMOSTONE: {
                    return "at-most-one";
                }
                case ANY: {
                    return "any";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ATMOSTONE: {
                    return "http://hl7.org/fhir/tools/CodeSystem/CDSSelectionBehavior";
                }
                case ANY: {
                    return "http://hl7.org/fhir/tools/CodeSystem/CDSSelectionBehavior";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ATMOSTONE: {
                    return "indicates that the user may choose none or at most one of the suggestions";
                }
                case ANY: {
                    return "indicates that the end user may choose any number of suggestions including none of them and all of them";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ATMOSTONE: {
                    return "at-most-one";
                }
                case ANY: {
                    return "any";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class CDSLinkTypeCodesVSEnumFactory
    implements EnumFactory<CDSLinkTypeCodesVS> {
        @Override
        public CDSLinkTypeCodesVS fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("absolute".equals(codeString)) {
                return CDSLinkTypeCodesVS.ABSOLUTE;
            }
            if ("smart".equals(codeString)) {
                return CDSLinkTypeCodesVS.SMART;
            }
            throw new IllegalArgumentException("Unknown CDSLinkTypeCodesVS code '" + codeString + "'");
        }

        public Enumeration<CDSLinkTypeCodesVS> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CDSLinkTypeCodesVS>(this, CDSLinkTypeCodesVS.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<CDSLinkTypeCodesVS>(this, CDSLinkTypeCodesVS.NULL, code);
            }
            if ("absolute".equals(codeString)) {
                return new Enumeration<CDSLinkTypeCodesVS>(this, CDSLinkTypeCodesVS.ABSOLUTE, code);
            }
            if ("smart".equals(codeString)) {
                return new Enumeration<CDSLinkTypeCodesVS>(this, CDSLinkTypeCodesVS.SMART, code);
            }
            throw new FHIRException("Unknown CDSLinkTypeCodesVS code '" + codeString + "'");
        }

        @Override
        public String toCode(CDSLinkTypeCodesVS code) {
            if (code == CDSLinkTypeCodesVS.ABSOLUTE) {
                return "absolute";
            }
            if (code == CDSLinkTypeCodesVS.SMART) {
                return "smart";
            }
            return "?";
        }

        @Override
        public String toSystem(CDSLinkTypeCodesVS code) {
            return code.getSystem();
        }
    }

    public static enum CDSLinkTypeCodesVS {
        ABSOLUTE,
        SMART,
        NULL;


        public static CDSLinkTypeCodesVS fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("absolute".equals(codeString)) {
                return ABSOLUTE;
            }
            if ("smart".equals(codeString)) {
                return SMART;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CDSLinkTypeCodesVS code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ABSOLUTE: {
                    return "absolute";
                }
                case SMART: {
                    return "smart";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ABSOLUTE: {
                    return "http://hl7.org/fhir/tools/CodeSystem/CDSLinkType";
                }
                case SMART: {
                    return "http://hl7.org/fhir/tools/CodeSystem/CDSLinkType";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ABSOLUTE: {
                    return "Indicates that the URL is absolute and should be treated as-is.";
                }
                case SMART: {
                    return "indicates that the URL is a SMART app launch URL and the CDS Client should ensure the SMART app launch URL is populated with the appropriate SMART launch parameters";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ABSOLUTE: {
                    return "absolute";
                }
                case SMART: {
                    return "smart";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class CDSIndicatorCodesVSEnumFactory
    implements EnumFactory<CDSIndicatorCodesVS> {
        @Override
        public CDSIndicatorCodesVS fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("info".equals(codeString)) {
                return CDSIndicatorCodesVS.INFO;
            }
            if ("warning".equals(codeString)) {
                return CDSIndicatorCodesVS.WARNING;
            }
            if ("error".equals(codeString)) {
                return CDSIndicatorCodesVS.ERROR;
            }
            throw new IllegalArgumentException("Unknown CDSIndicatorCodesVS code '" + codeString + "'");
        }

        public Enumeration<CDSIndicatorCodesVS> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CDSIndicatorCodesVS>(this, CDSIndicatorCodesVS.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<CDSIndicatorCodesVS>(this, CDSIndicatorCodesVS.NULL, code);
            }
            if ("info".equals(codeString)) {
                return new Enumeration<CDSIndicatorCodesVS>(this, CDSIndicatorCodesVS.INFO, code);
            }
            if ("warning".equals(codeString)) {
                return new Enumeration<CDSIndicatorCodesVS>(this, CDSIndicatorCodesVS.WARNING, code);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<CDSIndicatorCodesVS>(this, CDSIndicatorCodesVS.ERROR, code);
            }
            throw new FHIRException("Unknown CDSIndicatorCodesVS code '" + codeString + "'");
        }

        @Override
        public String toCode(CDSIndicatorCodesVS code) {
            if (code == CDSIndicatorCodesVS.INFO) {
                return "info";
            }
            if (code == CDSIndicatorCodesVS.WARNING) {
                return "warning";
            }
            if (code == CDSIndicatorCodesVS.ERROR) {
                return "error";
            }
            return "?";
        }

        @Override
        public String toSystem(CDSIndicatorCodesVS code) {
            return code.getSystem();
        }
    }

    public static enum CDSIndicatorCodesVS {
        INFO,
        WARNING,
        ERROR,
        NULL;


        public static CDSIndicatorCodesVS fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("info".equals(codeString)) {
                return INFO;
            }
            if ("warning".equals(codeString)) {
                return WARNING;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CDSIndicatorCodesVS code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INFO: {
                    return "info";
                }
                case WARNING: {
                    return "warning";
                }
                case ERROR: {
                    return "error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INFO: {
                    return "http://hl7.org/fhir/tools/CodeSystem/CDSIndicator";
                }
                case WARNING: {
                    return "http://hl7.org/fhir/tools/CodeSystem/CDSIndicator";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/tools/CodeSystem/CDSIndicator";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INFO: {
                    return "An information message";
                }
                case WARNING: {
                    return "A warning message";
                }
                case ERROR: {
                    return "An error message";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INFO: {
                    return "info";
                }
                case WARNING: {
                    return "warning";
                }
                case ERROR: {
                    return "error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class CDSActionTypeCodesVSEnumFactory
    implements EnumFactory<CDSActionTypeCodesVS> {
        @Override
        public CDSActionTypeCodesVS fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("create".equals(codeString)) {
                return CDSActionTypeCodesVS.CREATE;
            }
            if ("update".equals(codeString)) {
                return CDSActionTypeCodesVS.UPDATE;
            }
            if ("delete".equals(codeString)) {
                return CDSActionTypeCodesVS.DELETE;
            }
            throw new IllegalArgumentException("Unknown CDSActionTypeCodesVS code '" + codeString + "'");
        }

        public Enumeration<CDSActionTypeCodesVS> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CDSActionTypeCodesVS>(this, CDSActionTypeCodesVS.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<CDSActionTypeCodesVS>(this, CDSActionTypeCodesVS.NULL, code);
            }
            if ("create".equals(codeString)) {
                return new Enumeration<CDSActionTypeCodesVS>(this, CDSActionTypeCodesVS.CREATE, code);
            }
            if ("update".equals(codeString)) {
                return new Enumeration<CDSActionTypeCodesVS>(this, CDSActionTypeCodesVS.UPDATE, code);
            }
            if ("delete".equals(codeString)) {
                return new Enumeration<CDSActionTypeCodesVS>(this, CDSActionTypeCodesVS.DELETE, code);
            }
            throw new FHIRException("Unknown CDSActionTypeCodesVS code '" + codeString + "'");
        }

        @Override
        public String toCode(CDSActionTypeCodesVS code) {
            if (code == CDSActionTypeCodesVS.CREATE) {
                return "create";
            }
            if (code == CDSActionTypeCodesVS.UPDATE) {
                return "update";
            }
            if (code == CDSActionTypeCodesVS.DELETE) {
                return "delete";
            }
            return "?";
        }

        @Override
        public String toSystem(CDSActionTypeCodesVS code) {
            return code.getSystem();
        }
    }

    public static enum CDSActionTypeCodesVS {
        CREATE,
        UPDATE,
        DELETE,
        NULL;


        public static CDSActionTypeCodesVS fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("create".equals(codeString)) {
                return CREATE;
            }
            if ("update".equals(codeString)) {
                return UPDATE;
            }
            if ("delete".equals(codeString)) {
                return DELETE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CDSActionTypeCodesVS code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case UPDATE: {
                    return "update";
                }
                case DELETE: {
                    return "delete";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CREATE: {
                    return "http://hl7.org/fhir/tools/CodeSystem/CDSActionType";
                }
                case UPDATE: {
                    return "http://hl7.org/fhir/tools/CodeSystem/CDSActionType";
                }
                case DELETE: {
                    return "http://hl7.org/fhir/tools/CodeSystem/CDSActionType";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CREATE: {
                    return "Create this resource";
                }
                case UPDATE: {
                    return "Update this resource";
                }
                case DELETE: {
                    return "Delete this resource";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case UPDATE: {
                    return "update";
                }
                case DELETE: {
                    return "delete";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

