/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.tools;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.tools.CDSHooksElement;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="CDSHooksServices")
public class CDSHooksServices
extends CDSHooksElement
implements ICompositeType {
    @Child(name="services", type={CDSHooksElement.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of CDS services", formalDefinition="A list of CDS services")
    protected List<CDSHooksServicesServicesComponent> servicesList;
    private static final long serialVersionUID = 721056483L;

    public List<CDSHooksServicesServicesComponent> getServicesList() {
        if (this.servicesList == null) {
            this.servicesList = new ArrayList<CDSHooksServicesServicesComponent>();
        }
        return this.servicesList;
    }

    public CDSHooksServices setServicesList(List<CDSHooksServicesServicesComponent> theServices) {
        this.servicesList = theServices;
        return this;
    }

    public boolean hasServices() {
        if (this.servicesList == null) {
            return false;
        }
        for (CDSHooksServicesServicesComponent item : this.servicesList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CDSHooksServicesServicesComponent addServices() {
        CDSHooksServicesServicesComponent t = new CDSHooksServicesServicesComponent();
        if (this.servicesList == null) {
            this.servicesList = new ArrayList<CDSHooksServicesServicesComponent>();
        }
        this.servicesList.add(t);
        return t;
    }

    public CDSHooksServices addServices(CDSHooksServicesServicesComponent t) {
        if (t == null) {
            return this;
        }
        if (this.servicesList == null) {
            this.servicesList = new ArrayList<CDSHooksServicesServicesComponent>();
        }
        this.servicesList.add(t);
        return this;
    }

    public CDSHooksServicesServicesComponent getServicesFirstRep() {
        if (this.getServicesList().isEmpty()) {
            this.addServices();
        }
        return this.getServicesList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("services", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "A list of CDS services", 0, Integer.MAX_VALUE, this.servicesList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1379209310: {
                return new Property("services", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "A list of CDS services", 0, Integer.MAX_VALUE, this.servicesList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1379209310: {
                return this.servicesList == null ? new Base[]{} : this.servicesList.toArray(new Base[this.servicesList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1379209310: {
                this.getServicesList().add((CDSHooksServicesServicesComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("services")) {
            return super.setProperty(name, value);
        }
        this.getServicesList().add((CDSHooksServicesServicesComponent)value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1379209310: {
                return this.addServices();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1379209310: {
                return new String[]{"http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("services")) {
            throw new FHIRException("Cannot call addChild on an abstract type CDSHooksServices.services");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CDSHooksServices";
    }

    @Override
    public CDSHooksServices copy() {
        CDSHooksServices dst = new CDSHooksServices();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CDSHooksServices dst) {
        super.copyValues(dst);
        if (this.servicesList != null) {
            dst.servicesList = new ArrayList<CDSHooksServicesServicesComponent>();
            for (CDSHooksServicesServicesComponent i : this.servicesList) {
                dst.servicesList.add(i.copy());
            }
        }
    }

    protected CDSHooksServices typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CDSHooksServices)) {
            return false;
        }
        CDSHooksServices o = (CDSHooksServices)other_;
        return CDSHooksServices.compareDeep(this.servicesList, o.servicesList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CDSHooksServices)) {
            return false;
        }
        CDSHooksServices o = (CDSHooksServices)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.servicesList);
    }

    @Block
    public static class CDSHooksServicesServicesComponent
    extends CDSHooksElement {
        @Child(name="hook", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The hook this Services should be invoked on", formalDefinition="The hook this Services should be invoked on")
        protected StringType hook;
        @Child(name="title", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The human-friendly name of this Services (Recommended)", formalDefinition="The human-friendly name of this Services (Recommended)")
        protected StringType title;
        @Child(name="id", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The URL to this service which is available at: {baseUrl}/cds-services/{id}", formalDefinition="The {id} portion of the URL to this service which is available at ```{baseUrl}/cds-services/{id}```")
        protected CodeType id;
        @Child(name="description", type={StringType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The description of this Services", formalDefinition="The description of this Services")
        protected StringType description;
        @Child(name="usageRequirements", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human-friendly description of any preconditions for the use of this CDS Services", formalDefinition="Human-friendly description of any preconditions for the use of this CDS Services")
        protected StringType usageRequirements;
        @Child(name="prefetch", type={Base.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Key/value pairs of FHIR queries the CDS Client provides on each call", formalDefinition="An object containing key/value pairs of FHIR queries that this Services is requesting the CDS Client to perform and provide on each Services call. The key is a string that describes the type of data being requested and the value is a string representing the FHIR query")
        protected List<CDSHooksServicesServicesPrefetchComponent> prefetchList;
        private static final long serialVersionUID = 1303422447L;

        public CDSHooksServicesServicesComponent() {
        }

        public CDSHooksServicesServicesComponent(String hook, String id, String description) {
            this.setHook(hook);
            this.setId(id);
            this.setDescription(description);
        }

        public StringType getHookElement() {
            if (this.hook == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksServicesServicesComponent.hook");
                }
                if (Configuration.doAutoCreate()) {
                    this.hook = new StringType();
                }
            }
            return this.hook;
        }

        public boolean hasHookElement() {
            return this.hook != null && !this.hook.isEmpty();
        }

        public boolean hasHook() {
            return this.hook != null && !this.hook.isEmpty();
        }

        public CDSHooksServicesServicesComponent setHookElement(StringType value) {
            this.hook = value;
            return this;
        }

        public String getHook() {
            return this.hook == null ? null : (String)this.hook.getValue();
        }

        public CDSHooksServicesServicesComponent setHook(String value) {
            if (this.hook == null) {
                this.hook = new StringType();
            }
            this.hook.setValue(value);
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksServicesServicesComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public CDSHooksServicesServicesComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public CDSHooksServicesServicesComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public CodeType getIdElement() {
            if (this.id == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksServicesServicesComponent.id");
                }
                if (Configuration.doAutoCreate()) {
                    this.id = new CodeType();
                }
            }
            return this.id;
        }

        public boolean hasIdElement() {
            return this.id != null && !this.id.isEmpty();
        }

        public boolean hasId() {
            return this.id != null && !this.id.isEmpty();
        }

        public CDSHooksServicesServicesComponent setIdElement(CodeType value) {
            this.id = value;
            return this;
        }

        public String getId() {
            return this.id == null ? null : (String)this.id.getValue();
        }

        public CDSHooksServicesServicesComponent setId(String value) {
            if (this.id == null) {
                this.id = new CodeType();
            }
            this.id.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksServicesServicesComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public CDSHooksServicesServicesComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public CDSHooksServicesServicesComponent setDescription(String value) {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
            return this;
        }

        public StringType getUsageRequirementsElement() {
            if (this.usageRequirements == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksServicesServicesComponent.usageRequirements");
                }
                if (Configuration.doAutoCreate()) {
                    this.usageRequirements = new StringType();
                }
            }
            return this.usageRequirements;
        }

        public boolean hasUsageRequirementsElement() {
            return this.usageRequirements != null && !this.usageRequirements.isEmpty();
        }

        public boolean hasUsageRequirements() {
            return this.usageRequirements != null && !this.usageRequirements.isEmpty();
        }

        public CDSHooksServicesServicesComponent setUsageRequirementsElement(StringType value) {
            this.usageRequirements = value;
            return this;
        }

        public String getUsageRequirements() {
            return this.usageRequirements == null ? null : (String)this.usageRequirements.getValue();
        }

        public CDSHooksServicesServicesComponent setUsageRequirements(String value) {
            if (Utilities.noString((String)value)) {
                this.usageRequirements = null;
            } else {
                if (this.usageRequirements == null) {
                    this.usageRequirements = new StringType();
                }
                this.usageRequirements.setValue(value);
            }
            return this;
        }

        public List<CDSHooksServicesServicesPrefetchComponent> getPrefetchList() {
            if (this.prefetchList == null) {
                this.prefetchList = new ArrayList<CDSHooksServicesServicesPrefetchComponent>();
            }
            return this.prefetchList;
        }

        public CDSHooksServicesServicesComponent setPrefetchList(List<CDSHooksServicesServicesPrefetchComponent> thePrefetch) {
            this.prefetchList = thePrefetch;
            return this;
        }

        public boolean hasPrefetch() {
            if (this.prefetchList == null) {
                return false;
            }
            for (CDSHooksServicesServicesPrefetchComponent item : this.prefetchList) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CDSHooksServicesServicesComponent addPrefetch(CDSHooksServicesServicesPrefetchComponent t) {
            if (t == null) {
                return this;
            }
            if (this.prefetchList == null) {
                this.prefetchList = new ArrayList<CDSHooksServicesServicesPrefetchComponent>();
            }
            this.prefetchList.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("hook", "string", "The hook this Services should be invoked on", 0, 1, this.hook));
            children.add(new Property("title", "string", "The human-friendly name of this Services (Recommended)", 0, 1, this.title));
            children.add(new Property("id", "code", "The {id} portion of the URL to this service which is available at ```{baseUrl}/cds-services/{id}```", 0, 1, this.id));
            children.add(new Property("description", "string", "The description of this Services", 0, 1, this.description));
            children.add(new Property("usageRequirements", "string", "Human-friendly description of any preconditions for the use of this CDS Services", 0, 1, this.usageRequirements));
            children.add(new Property("prefetch", "Base", "An object containing key/value pairs of FHIR queries that this Services is requesting the CDS Client to perform and provide on each Services call. The key is a string that describes the type of data being requested and the value is a string representing the FHIR query", 0, Integer.MAX_VALUE, this.prefetchList));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3208483: {
                    return new Property("hook", "string", "The hook this Services should be invoked on", 0, 1, this.hook);
                }
                case 110371416: {
                    return new Property("title", "string", "The human-friendly name of this Services (Recommended)", 0, 1, this.title);
                }
                case 3355: {
                    return new Property("id", "code", "The {id} portion of the URL to this service which is available at ```{baseUrl}/cds-services/{id}```", 0, 1, this.id);
                }
                case -1724546052: {
                    return new Property("description", "string", "The description of this Services", 0, 1, this.description);
                }
                case -512224047: {
                    return new Property("usageRequirements", "string", "Human-friendly description of any preconditions for the use of this CDS Services", 0, 1, this.usageRequirements);
                }
                case -1288666633: {
                    return new Property("prefetch", "Base", "An object containing key/value pairs of FHIR queries that this Services is requesting the CDS Client to perform and provide on each Services call. The key is a string that describes the type of data being requested and the value is a string representing the FHIR query", 0, Integer.MAX_VALUE, this.prefetchList);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3208483: {
                    Base[] baseArray;
                    if (this.hook == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.hook;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.title;
                    }
                    return baseArray;
                }
                case 3355: {
                    Base[] baseArray;
                    if (this.id == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.id;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case -512224047: {
                    Base[] baseArray;
                    if (this.usageRequirements == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.usageRequirements;
                    }
                    return baseArray;
                }
                case -1288666633: {
                    return this.prefetchList == null ? new Base[]{} : this.prefetchList.toArray(new Base[this.prefetchList.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3208483: {
                    this.hook = TypeConvertor.castToString(value);
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case 3355: {
                    this.id = TypeConvertor.castToCode(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -512224047: {
                    this.usageRequirements = TypeConvertor.castToString(value);
                    return value;
                }
                case -1288666633: {
                    this.getPrefetchList().add((CDSHooksServicesServicesPrefetchComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("hook")) {
                this.hook = TypeConvertor.castToString(value);
            } else if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("id")) {
                this.id = TypeConvertor.castToCode(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("usageRequirements")) {
                this.usageRequirements = TypeConvertor.castToString(value);
            } else if (name.equals("prefetch")) {
                this.getPrefetchList().add((CDSHooksServicesServicesPrefetchComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3208483: {
                    return this.getHookElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case 3355: {
                    return this.getIdElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -512224047: {
                    return this.getUsageRequirementsElement();
                }
                case -1288666633: {
                    throw new Error("Unable to make an instance of the abstract property 'prefetch'");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3208483: {
                    return new String[]{"string"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case 3355: {
                    return new String[]{"code"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -512224047: {
                    return new String[]{"string"};
                }
                case -1288666633: {
                    return new String[]{"Base"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("hook")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksServices.services.hook");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksServices.services.title");
            }
            if (name.equals("id")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksServices.services.id");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksServices.services.description");
            }
            if (name.equals("usageRequirements")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksServices.services.usageRequirements");
            }
            if (name.equals("prefetch")) {
                throw new FHIRException("Cannot call addChild on an abstract type CDSHooksServices.services.prefetch");
            }
            return super.addChild(name);
        }

        @Override
        public CDSHooksServicesServicesComponent copy() {
            CDSHooksServicesServicesComponent dst = new CDSHooksServicesServicesComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CDSHooksServicesServicesComponent dst) {
            super.copyValues(dst);
            dst.hook = this.hook == null ? null : this.hook.copy();
            dst.title = this.title == null ? null : this.title.copy();
            dst.id = this.id == null ? null : this.id.copy();
            dst.description = this.description == null ? null : this.description.copy();
            StringType stringType = dst.usageRequirements = this.usageRequirements == null ? null : this.usageRequirements.copy();
            if (this.prefetchList != null) {
                dst.prefetchList = new ArrayList<CDSHooksServicesServicesPrefetchComponent>();
                for (CDSHooksServicesServicesPrefetchComponent i : this.prefetchList) {
                    dst.prefetchList.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksServicesServicesComponent)) {
                return false;
            }
            CDSHooksServicesServicesComponent o = (CDSHooksServicesServicesComponent)other_;
            return CDSHooksServicesServicesComponent.compareDeep(this.hook, o.hook, true) && CDSHooksServicesServicesComponent.compareDeep(this.title, o.title, true) && CDSHooksServicesServicesComponent.compareDeep(this.id, o.id, true) && CDSHooksServicesServicesComponent.compareDeep(this.description, o.description, true) && CDSHooksServicesServicesComponent.compareDeep(this.usageRequirements, o.usageRequirements, true) && CDSHooksServicesServicesComponent.compareDeep(this.prefetchList, o.prefetchList, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksServicesServicesComponent)) {
                return false;
            }
            CDSHooksServicesServicesComponent o = (CDSHooksServicesServicesComponent)other_;
            return CDSHooksServicesServicesComponent.compareValues(this.hook, o.hook, true) && CDSHooksServicesServicesComponent.compareValues(this.title, o.title, true) && CDSHooksServicesServicesComponent.compareValues(this.id, o.id, true) && CDSHooksServicesServicesComponent.compareValues(this.description, o.description, true) && CDSHooksServicesServicesComponent.compareValues(this.usageRequirements, o.usageRequirements, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.hook, this.title, this.id, this.description, this.usageRequirements, this.prefetchList});
        }

        @Override
        public String fhirType() {
            return "CDSHooksServices.services";
        }
    }

    @Block
    public static class CDSHooksServicesServicesPrefetchComponent
    extends LogicalBase {
        @Child(name="key", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Key of FHIR query - name for client to use when sending to Services", formalDefinition="Key of FHIR query - name for client to use when sending to Services")
        protected CodeType key;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of FHIR query - FHIR Query for client to perform", formalDefinition="Value of FHIR query - FHIR Query for client to perform")
        protected StringType value;
        private static final long serialVersionUID = -1496585526L;

        public CDSHooksServicesServicesPrefetchComponent() {
        }

        public CDSHooksServicesServicesPrefetchComponent(String key, String value) {
            this.setKey(key);
            this.setValue(value);
        }

        public CodeType getKeyElement() {
            if (this.key == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksServicesServicesPrefetchComponent.key");
                }
                if (Configuration.doAutoCreate()) {
                    this.key = new CodeType();
                }
            }
            return this.key;
        }

        public boolean hasKeyElement() {
            return this.key != null && !this.key.isEmpty();
        }

        public boolean hasKey() {
            return this.key != null && !this.key.isEmpty();
        }

        public CDSHooksServicesServicesPrefetchComponent setKeyElement(CodeType value) {
            this.key = value;
            return this;
        }

        public String getKey() {
            return this.key == null ? null : (String)this.key.getValue();
        }

        public CDSHooksServicesServicesPrefetchComponent setKey(String value) {
            if (this.key == null) {
                this.key = new CodeType();
            }
            this.key.setValue(value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksServicesServicesPrefetchComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CDSHooksServicesServicesPrefetchComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public CDSHooksServicesServicesPrefetchComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("key", "code", "Key of FHIR query - name for client to use when sending to Services", 0, 1, this.key));
            children.add(new Property("value", "string", "Value of FHIR query - FHIR Query for client to perform", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 106079: {
                    return new Property("key", "code", "Key of FHIR query - name for client to use when sending to Services", 0, 1, this.key);
                }
                case 111972721: {
                    return new Property("value", "string", "Value of FHIR query - FHIR Query for client to perform", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 106079: {
                    Base[] baseArray;
                    if (this.key == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.key;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 106079: {
                    this.key = TypeConvertor.castToCode(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("key")) {
                this.key = TypeConvertor.castToCode(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106079: {
                    return this.getKeyElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106079: {
                    return new String[]{"code"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("key")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksServices.services.prefetch.key");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksServices.services.prefetch.value");
            }
            return super.addChild(name);
        }

        @Override
        public CDSHooksServicesServicesPrefetchComponent copy() {
            CDSHooksServicesServicesPrefetchComponent dst = new CDSHooksServicesServicesPrefetchComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CDSHooksServicesServicesPrefetchComponent dst) {
            super.copyValues(dst);
            dst.key = this.key == null ? null : this.key.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksServicesServicesPrefetchComponent)) {
                return false;
            }
            CDSHooksServicesServicesPrefetchComponent o = (CDSHooksServicesServicesPrefetchComponent)other_;
            return CDSHooksServicesServicesPrefetchComponent.compareDeep(this.key, o.key, true) && CDSHooksServicesServicesPrefetchComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksServicesServicesPrefetchComponent)) {
                return false;
            }
            CDSHooksServicesServicesPrefetchComponent o = (CDSHooksServicesServicesPrefetchComponent)other_;
            return CDSHooksServicesServicesPrefetchComponent.compareValues(this.key, o.key, true) && CDSHooksServicesServicesPrefetchComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.key, this.value});
        }

        @Override
        public String fhirType() {
            return "CDSHooksServices.services.prefetch";
        }
    }
}

