/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;

@MarkedToMoveToAdjunctPackage
public class SnomedExpressions {
    private static final int MAX_TERM_LIMIT = 1024;
    private String source;
    private int cursor;

    private Concept concept() throws FHIRException {
        Concept res = new Concept();
        res.setStart(this.cursor);
        this.ws();
        if (this.peek() == '#') {
            res.decimal = this.decimal();
        } else if (this.peek() == '\"') {
            res.literal = this.stringConstant();
        } else {
            res.code = this.conceptId();
        }
        this.ws();
        if (this.gchar('|')) {
            this.ws();
            res.description = this.term().trim();
            this.ws();
            this.fixed('|');
            this.ws();
        }
        res.setStop(this.cursor);
        return res;
    }

    private void refinements(Expression expr) throws FHIRException {
        boolean n = true;
        while (n) {
            if (this.peek() != '{') {
                expr.refinements.add(this.attribute());
            } else {
                expr.refinementGroups.add(this.attributeGroup());
            }
            this.ws();
            n = this.gchar(',');
            this.ws();
        }
    }

    private RefinementGroup attributeGroup() throws FHIRException {
        RefinementGroup res = new RefinementGroup();
        this.fixed('{');
        this.ws();
        res.setStart(this.cursor);
        res.refinements.add(this.attribute());
        while (this.gchar(',')) {
            res.refinements.add(this.attribute());
        }
        res.setStop(this.cursor);
        this.ws();
        this.fixed('}');
        this.ws();
        return res;
    }

    private Refinement attribute() throws FHIRException {
        Refinement res = new Refinement();
        res.setStart(this.cursor);
        res.name = this.attributeName();
        this.fixed('=');
        res.value = this.attributeValue();
        this.ws();
        res.setStop(this.cursor);
        return res;
    }

    private Concept attributeName() throws FHIRException {
        Concept res = new Concept();
        res.setStart(this.cursor);
        this.ws();
        res.code = this.conceptId();
        this.ws();
        if (this.gchar('|')) {
            this.ws();
            res.description = this.term();
            this.ws();
            this.fixed('|');
            this.ws();
        }
        res.setStop(this.cursor);
        return res;
    }

    private Expression attributeValue() throws FHIRException {
        Expression res;
        this.ws();
        if (this.gchar('(')) {
            res = this.expression();
            this.fixed(')');
        } else {
            res = this.expression();
        }
        return res;
    }

    private Expression expression() throws FHIRException {
        Expression res = new Expression();
        res.setStart(this.cursor);
        this.ws();
        res.concepts.add(this.concept());
        while (this.gchar('+')) {
            res.concepts.add(this.concept());
        }
        if (this.gchar(':')) {
            this.ws();
            this.refinements(res);
        }
        res.setStop(this.cursor);
        return res;
    }

    private String conceptId() throws FHIRException {
        StringBuffer res = new StringBuffer(Utilities.padLeft((String)"", (char)' ', (int)18));
        int i = 0;
        while (this.peek() >= '0' && this.peek() <= '9') {
            res.setCharAt(i, this.next());
            ++i;
        }
        this.rule(i > 0, "Concept not found (next char = \"" + this.peekDisp() + "\", in '" + this.source + "')");
        return res.substring(0, i);
    }

    private String decimal() throws FHIRException {
        StringBuffer res = new StringBuffer(Utilities.padLeft((String)"", (char)' ', (int)1024));
        int i = 0;
        this.fixed('#');
        while (this.peek() >= '0' && this.peek() <= '9' || this.peek() == '.') {
            res.setCharAt(i, this.next());
            ++i;
        }
        return res.substring(0, i);
    }

    private String term() {
        StringBuffer res = new StringBuffer(Utilities.padLeft((String)"", (char)' ', (int)1024));
        int i = 0;
        while (this.peek() != '|') {
            res.setCharAt(i, this.next());
            ++i;
        }
        return res.substring(0, i);
    }

    private void ws() {
        while (Utilities.existsInList((int)this.peek(), (int[])new int[]{32, 9, 13, 110})) {
            this.next();
        }
    }

    private boolean gchar(char ch) {
        boolean result;
        boolean bl = result = this.peek() == ch;
        if (result) {
            this.next();
        }
        return result;
    }

    private void fixed(char ch) throws FHIRException {
        boolean b = this.gchar(ch);
        this.rule(b, "Expected character \"" + ch + "\" but found " + this.peek());
        this.ws();
    }

    private Expression parse() throws FHIRException {
        Expression res = new Expression();
        res.setStart(this.cursor);
        this.ws();
        if (this.peek() == '=') {
            res.status = ExpressionStatus.Equivalent;
            this.prefix('=');
        } else if (this.peek() == '<') {
            res.status = ExpressionStatus.SubsumedBy;
            this.prefix('<');
        }
        res.concepts.add(this.concept());
        while (this.gchar('+')) {
            res.concepts.add(this.concept());
        }
        if (this.gchar(':')) {
            this.ws();
            this.refinements(res);
        }
        res.setStop(this.cursor);
        this.rule(this.cursor >= this.source.length(), "Found content (\"" + this.peekDisp() + "\") after end of expression");
        return res;
    }

    public static Expression parse(String source) throws FHIRException {
        SnomedExpressions self = new SnomedExpressions();
        self.source = source;
        self.cursor = 0;
        return self.parse();
    }

    private char peek() {
        if (this.cursor >= this.source.length()) {
            return '\u0000';
        }
        return this.source.charAt(this.cursor);
    }

    private String peekDisp() {
        if (this.cursor >= this.source.length()) {
            return "[n/a: overrun]";
        }
        return String.valueOf(this.source.charAt(this.cursor));
    }

    private void prefix(char c) throws FHIRException {
        this.fixed(c);
        this.fixed(c);
        this.fixed(c);
        this.ws();
    }

    private char next() {
        char res = this.peek();
        ++this.cursor;
        return res;
    }

    private void rule(boolean test, String message) throws FHIRException {
        if (!test) {
            throw new FHIRException(message + " at character " + Integer.toString(this.cursor));
        }
    }

    private String stringConstant() throws FHIRException {
        StringBuffer res = new StringBuffer(Utilities.padLeft((String)"", (char)' ', (int)1024));
        this.fixed('\"');
        int i = 0;
        while (this.peek() != '\"') {
            res.setCharAt(++i, this.next());
        }
        this.fixed('\"');
        return res.substring(0, i);
    }

    public class Concept
    extends Base {
        private long reference;
        private String code;
        private String description;
        private String literal;
        private String decimal;

        public long getReference() {
            return this.reference;
        }

        public void setReference(long reference) {
            this.reference = reference;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getLiteral() {
            return this.literal;
        }

        public void setLiteral(String literal) {
            this.literal = literal;
        }

        public String getDecimal() {
            return this.decimal;
        }

        public void setDecimal(String decimal) {
            this.decimal = decimal;
        }

        public String toString() {
            if (this.code != null) {
                return this.code;
            }
            if (this.decimal != null) {
                return "#" + this.decimal;
            }
            if (this.literal != null) {
                return "\"" + this.literal + "\"";
            }
            return "";
        }
    }

    public class Expression
    extends Base {
        private List<RefinementGroup> refinementGroups;
        private List<Refinement> refinements;
        private List<Concept> concepts;
        private ExpressionStatus status;

        public Expression() {
            this.refinementGroups = new ArrayList<RefinementGroup>();
            this.refinements = new ArrayList<Refinement>();
            this.concepts = new ArrayList<Concept>();
        }

        public ExpressionStatus getStatus() {
            return this.status;
        }

        public void setStatus(ExpressionStatus status) {
            this.status = status;
        }

        public List<RefinementGroup> getRefinementGroups() {
            return this.refinementGroups;
        }

        public List<Refinement> getRefinements() {
            return this.refinements;
        }

        public List<Concept> getConcepts() {
            return this.concepts;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            if (this.status == ExpressionStatus.Equivalent) {
                b.append("===");
            } else if (this.status == ExpressionStatus.SubsumedBy) {
                b.append("<<<");
            }
            boolean first = true;
            for (Concept concept : this.concepts) {
                if (first) {
                    first = false;
                } else {
                    b.append(',');
                }
                b.append(concept.toString());
            }
            for (Refinement refinement : this.refinements) {
                if (first) {
                    first = false;
                } else {
                    b.append(',');
                }
                b.append(refinement.toString());
            }
            for (RefinementGroup refinementGroup : this.refinementGroups) {
                if (first) {
                    first = false;
                } else {
                    b.append(',');
                }
                b.append(refinementGroup.toString());
            }
            return b.toString();
        }
    }

    public class Refinement
    extends Base {
        private Concept name;
        private Expression value;

        public Concept getName() {
            return this.name;
        }

        public void setName(Concept name) {
            this.name = name;
        }

        public Expression getValue() {
            return this.value;
        }

        public void setValue(Expression value) {
            this.value = value;
        }

        public String toString() {
            return this.name.toString() + "=" + this.value.toString();
        }
    }

    public class RefinementGroup
    extends Base {
        private List<Refinement> refinements;

        public RefinementGroup() {
            this.refinements = new ArrayList<Refinement>();
        }

        public List<Refinement> getRefinements() {
            return this.refinements;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            for (Refinement refinement : this.refinements) {
                if (first) {
                    first = false;
                } else {
                    b.append(',');
                }
                b.append(refinement.toString());
            }
            return b.toString();
        }
    }

    public static enum ExpressionStatus {
        Unknown,
        Equivalent,
        SubsumedBy;

    }

    public class Base {
        private int stop;
        private int start;

        public int getStop() {
            return this.stop;
        }

        public void setStop(int stop) {
            this.stop = stop;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }
    }
}

