/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.client;

import org.hl7.fhir.r5.model.OperationOutcome;

public class EFhirClientException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private OperationOutcome error = null;
    private int code;

    public EFhirClientException(int code, String message) {
        super(message);
        this.code = code;
    }

    public EFhirClientException(Exception cause) {
        super(cause);
    }

    public EFhirClientException(int code, String message, Exception cause) {
        super(message, cause);
        this.code = code;
    }

    public EFhirClientException(int code, String message, OperationOutcome serverError) {
        super(message);
        this.code = code;
        this.error = serverError;
    }

    public EFhirClientException(int code, String message, OperationOutcome serverError, Exception cause) {
        super(message, cause);
        this.code = code;
        this.error = serverError;
    }

    public EFhirClientException(int code, OperationOutcome serverError) {
        super("Error on the server: " + serverError.getText().getDiv().allText() + ". Refer to e.getServerErrors() for additional details.");
        this.code = code;
        this.error = serverError;
    }

    public OperationOutcome getServerError() {
        return this.error;
    }

    public boolean hasServerError() {
        return this.error != null;
    }

    public int getCode() {
        return this.code;
    }
}

