/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.client.network;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.http.HTTPHeader;

public class ClientHeaders {
    private final List<HTTPHeader> headers;

    public ClientHeaders() {
        this.headers = new ArrayList<HTTPHeader>();
    }

    public ClientHeaders(List<HTTPHeader> headers) {
        this.headers = new ArrayList<HTTPHeader>(headers);
    }

    public List<HTTPHeader> headers() {
        return this.headers;
    }

    public ClientHeaders addHeader(HTTPHeader header) throws FHIRException {
        if (this.headers.contains(header)) {
            throw new FHIRException("Attempting to add duplicate header, <" + header.getName() + ", " + header.getValue() + ">.");
        }
        this.headers.add(header);
        return this;
    }

    public ClientHeaders addHeaders(List<HTTPHeader> headerList) throws FHIRException {
        headerList.forEach(this::addHeader);
        return this;
    }

    public ClientHeaders removeHeader(HTTPHeader header) throws FHIRException {
        if (!this.headers.remove(header)) {
            throw new FHIRException("Attempting to remove header, <" + header.getName() + ", " + header.getValue() + ">, from GenericClientHeaders that is not currently stored.");
        }
        return this;
    }

    public ClientHeaders removeHeaders(List<HTTPHeader> headerList) throws FHIRException {
        headerList.forEach(this::removeHeader);
        return this;
    }

    public ClientHeaders clearHeaders() {
        this.headers.clear();
        return this;
    }

    public String toString() {
        return this.headers.stream().map(header -> "\t" + header.getName() + ":" + header.getValue()).collect(Collectors.joining(",\n", "{\n", "\n}"));
    }
}

