/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance.profile;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.utils.DefinitionNavigator;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.UUIDUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class CompliesWithChecker {
    private IWorkerContext context;
    private String id;

    public CompliesWithChecker(IWorkerContext context) {
        this.context = context;
        this.id = UUIDUtilities.makeUuidLC();
    }

    public List<ValidationMessage> checkCompliesWith(StructureDefinition claimee, StructureDefinition authority) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        DefinitionNavigator cn = new DefinitionNavigator(this.context, claimee, false, true);
        DefinitionNavigator an = new DefinitionNavigator(this.context, authority, false, true);
        String path = claimee.getType();
        if (!path.equals(authority.getType())) {
            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_WRONG_TYPE", path, authority.getType()), ValidationMessage.IssueSeverity.ERROR));
        } else {
            this.checkCompliesWith(messages, path, cn, an, false);
        }
        return messages;
    }

    private void checkCompliesWith(List<ValidationMessage> messages, String path, DefinitionNavigator claimee, DefinitionNavigator authority, boolean isSlice) {
        ElementDefinition a;
        ElementDefinition c = claimee.current();
        if (this.checkElementComplies(messages, path, c, a = authority.current(), isSlice) && (!this.typesIdentical(c, a) || claimee.hasInlineChildren() || authority.hasInlineChildren())) {
            for (int i = 0; i < authority.children().size(); ++i) {
                DefinitionNavigator anChild = authority.children().get(i);
                this.checkCompilesWith(messages, path, claimee, anChild);
            }
        }
    }

    private void checkCompilesWith(List<ValidationMessage> messages, String path, DefinitionNavigator claimee, DefinitionNavigator anChild) {
        DefinitionNavigator cnChild = claimee.childByName(anChild.current().getName());
        String cpath = path + "." + anChild.current().getName();
        if (cnChild == null) {
            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, cpath, this.context.formatMessage("PROFILE_COMPLIES_WITH_MISSING", anChild.globalPath()), ValidationMessage.IssueSeverity.ERROR));
        } else if (anChild.sliced() || cnChild.sliced()) {
            if (!cnChild.hasSlices()) {
                if (anChild.hasSlices()) {
                    boolean wecare = anChild.current().getSlicing().getRules() == ElementDefinition.SlicingRules.CLOSED;
                    for (DefinitionNavigator anSlice : anChild.slices()) {
                        wecare = wecare || anSlice.current().getMin() > 0;
                    }
                    if (wecare) {
                        messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, cpath, this.context.formatMessage("PROFILE_COMPLIES_WITH_SLICING_UNSLICED", cpath), ValidationMessage.IssueSeverity.ERROR));
                    }
                }
                this.checkCompliesWith(messages, cpath, cnChild, anChild, false);
            } else if (!anChild.hasSlices()) {
                for (DefinitionNavigator cc : cnChild.slices()) {
                    this.checkCompliesWith(messages, cpath + ":" + cnChild.current().getSliceName(), cc, anChild, true);
                }
            } else {
                ArrayList<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent> discriminators = new ArrayList<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent>();
                if (this.slicingCompliesWith(messages, cpath, anChild.current(), cnChild.current(), discriminators)) {
                    String spath;
                    ArrayList<DefinitionNavigator> processed = new ArrayList<DefinitionNavigator>();
                    for (DefinitionNavigator anSlice : anChild.slices()) {
                        spath = cpath + ":" + anSlice.current().getSliceName();
                        ArrayList<DataType> discriminatorValues = new ArrayList<DataType>();
                        List<DefinitionNavigator> cnSlices = this.findMatchingSlices(cnChild.slices(), discriminators, anSlice, discriminatorValues);
                        if (cnSlices.isEmpty() && anSlice.current().getSlicing().getRules() != ElementDefinition.SlicingRules.CLOSED) {
                            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, cpath, this.context.formatMessage("PROFILE_COMPLIES_WITH_SLICING_NO_SLICE", spath, this.discriminatorsToString(discriminators), this.valuesToString(discriminatorValues)), ValidationMessage.IssueSeverity.ERROR));
                        }
                        for (DefinitionNavigator cnSlice : cnSlices) {
                            spath = cpath + ":" + cnSlice.current().getSliceName();
                            if (!processed.contains(cnSlice)) {
                                processed.add(cnSlice);
                            }
                            this.checkCompliesWith(messages, spath, cnSlice, anSlice, false);
                        }
                    }
                    for (DefinitionNavigator cnSlice : cnChild.slices()) {
                        if (processed.contains(cnSlice)) continue;
                        if (anChild.current().getSlicing().getRules() != ElementDefinition.SlicingRules.OPEN) {
                            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, cpath, this.context.formatMessage("PROFILE_COMPLIES_WITH_SLICING_EXTRA_SLICE", cpath, cnSlice.current().getSliceName()), ValidationMessage.IssueSeverity.ERROR));
                        }
                        spath = cpath + ":" + cnSlice.current().getSliceName();
                        this.checkCompliesWith(messages, spath, cnSlice, anChild, true);
                    }
                }
            }
        } else {
            this.checkCompliesWith(messages, cpath, cnChild, anChild, false);
        }
    }

    private Object discriminatorsToString(List<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent> discriminators) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder("|");
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent dt : discriminators) {
            b.append(dt.getType().toCode() + ":" + dt.getPath());
        }
        return b.toString();
    }

    private String valuesToString(List<DataType> diffValues) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder("|");
        for (DataType dt : diffValues) {
            b.append(dt.toString());
        }
        return b.toString();
    }

    private List<DefinitionNavigator> findMatchingSlices(List<DefinitionNavigator> slices, List<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent> discriminators, DefinitionNavigator anSlice, List<DataType> discriminatorValues) {
        ArrayList<DefinitionNavigator> list = new ArrayList<DefinitionNavigator>();
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent ad : discriminators) {
            discriminatorValues.add(this.getDisciminatorValue(anSlice, ad));
        }
        for (DefinitionNavigator slice : slices) {
            ArrayList<DataType> values = new ArrayList<DataType>();
            for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent ad : discriminators) {
                values.add(this.getDisciminatorValue(slice, ad));
            }
            boolean ok = true;
            for (int i = 0; i < discriminators.size(); ++i) {
                if (this.isMatch(discriminators.get(i), discriminatorValues.get(i), (DataType)values.get(i))) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            list.add(slice);
        }
        return list;
    }

    private boolean isMatch(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent discriminator, DataType dt1, DataType dt2) {
        if (dt1 == null) {
            return dt2 == null;
        }
        if (dt2 == null) {
            return false;
        }
        switch (discriminator.getType()) {
            case EXISTS: {
                return false;
            }
            case NULL: {
                return false;
            }
            case PATTERN: {
                return dt1.equalsDeep(dt2);
            }
            case POSITION: {
                return false;
            }
            case PROFILE: {
                StructureDefinition sde;
                String url;
                StructureDefinition sd1 = this.context.fetchResource(StructureDefinition.class, dt1.primitiveValue());
                StructureDefinition sd2 = this.context.fetchResource(StructureDefinition.class, dt2.primitiveValue());
                if (sd1 == null || sd2 == null) {
                    return false;
                }
                for (Extension ex : sd2.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile")) {
                    url = ex.getValue().primitiveValue();
                    if (url == null) continue;
                    sde = sd1;
                    while (sde != null) {
                        if (url.equals(sde.getUrl()) || url.equals(sde.getVersionedUrl())) {
                            return true;
                        }
                        sde = this.context.fetchResource(StructureDefinition.class, sde.getBaseDefinition());
                    }
                }
                for (Extension ex : sd2.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile")) {
                    url = ex.getValue().primitiveValue();
                    if (url == null) continue;
                    sde = sd1;
                    while (sde != null) {
                        if (url.equals(sde.getUrl()) || url.equals(sde.getVersionedUrl())) {
                            return true;
                        }
                        sde = this.context.fetchResource(StructureDefinition.class, sde.getBaseDefinition());
                    }
                }
                StructureDefinition sde2 = sd1;
                while (sde2 != null) {
                    if (sd2.getVersionedUrl().equals(sde2.getVersionedUrl())) {
                        return true;
                    }
                    sde2 = this.context.fetchResource(StructureDefinition.class, sde2.getBaseDefinition());
                }
                return false;
            }
            case TYPE: {
                return dt1.primitiveValue().equals(dt2.primitiveValue());
            }
            case VALUE: {
                return dt1.equalsDeep(dt2);
            }
        }
        return false;
    }

    private DataType getDisciminatorValue(DefinitionNavigator anSlice, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent ad) {
        switch (ad.getType()) {
            case EXISTS: {
                return this.getExistsDiscriminatorValue(anSlice, ad.getPath());
            }
            case NULL: {
                throw new FHIRException("Discriminator type 'Null' Not supported yet");
            }
            case POSITION: {
                throw new FHIRException("Discriminator type 'Position' Not supported yet");
            }
            case PROFILE: {
                return this.getProfileDiscriminatorValue(anSlice, ad.getPath());
            }
            case TYPE: {
                return this.getTypeDiscriminatorValue(anSlice, ad.getPath());
            }
            case PATTERN: 
            case VALUE: {
                return this.getValueDiscriminatorValue(anSlice, ad.getPath());
            }
        }
        throw new FHIRException("Not supported yet");
    }

    private DataType getProfileDiscriminatorValue(DefinitionNavigator anSlice, String path) {
        DefinitionNavigator pathDN = this.getByPath(anSlice, path);
        if (pathDN == null) {
            return null;
        }
        ElementDefinition ed = pathDN.current();
        if (!ed.hasType() || !ed.getTypeFirstRep().hasProfile()) {
            return null;
        }
        return new CanonicalType(ed.getTypeFirstRep().getProfile().get(0).asStringValue());
    }

    private DataType getExistsDiscriminatorValue(DefinitionNavigator anSlice, String path) {
        DefinitionNavigator pathDN = this.getByPath(anSlice, path);
        if (pathDN == null) {
            return null;
        }
        ElementDefinition ed = pathDN.current();
        BooleanType dt = new BooleanType("1".equals(ed.getMax()));
        return dt;
    }

    private DataType getTypeDiscriminatorValue(DefinitionNavigator anSlice, String path) {
        DefinitionNavigator pathDN = this.getByPath(anSlice, path);
        if (pathDN == null) {
            return null;
        }
        ElementDefinition ed = pathDN.current();
        StringType dt = new StringType(ed.typeSummary());
        return dt;
    }

    private DataType getValueDiscriminatorValue(DefinitionNavigator anSlice, String path) {
        DefinitionNavigator pathDN = this.getByPath(anSlice, path);
        if (pathDN == null) {
            return null;
        }
        ElementDefinition ed = pathDN.current();
        DataType dt = ed.hasFixed() ? ed.getFixed() : ed.getPattern();
        return dt;
    }

    private DefinitionNavigator getByPath(DefinitionNavigator focus, String path) {
        String segment;
        String string = segment = path.contains(".") ? path.substring(0, path.indexOf(".")) : path;
        if ("$this".equals(segment)) {
            return focus;
        }
        DefinitionNavigator p = focus.childByName(segment);
        if (p != null && path.contains(".")) {
            return this.getByPath(p, path.substring(path.indexOf(".") + 1));
        }
        return p;
    }

    private boolean slicingCompliesWith(List<ValidationMessage> messages, String path, ElementDefinition a, ElementDefinition c, List<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent> discriminators) {
        if (a.getSlicing().getRules() != ElementDefinition.SlicingRules.OPEN && c.getSlicing().getRules() != a.getSlicing().getRules()) {
            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_SLICING_RULES", path, a.getSlicing().getRules().toCode(), c.getSlicing().getRules().toCode()), ValidationMessage.IssueSeverity.ERROR));
            return false;
        }
        if (a.getSlicing().getOrdered() && !c.getSlicing().getOrdered()) {
            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_SLICING_ORDER", path), ValidationMessage.IssueSeverity.ERROR));
            return false;
        }
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent ad : a.getSlicing().getDiscriminator()) {
            discriminators.add(ad);
            ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent cd = null;
            for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : c.getSlicing().getDiscriminator()) {
                if (t.getType() != ad.getType() || !t.getPath().equals(ad.getPath())) continue;
                cd = t;
            }
            if (cd != null) continue;
            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_SLICING_DISCRIMINATOR", new Object[]{path, ad.getType(), ad.getPath()}), ValidationMessage.IssueSeverity.ERROR));
            return false;
        }
        return true;
    }

    private boolean checkElementComplies(List<ValidationMessage> messages, String path, ElementDefinition c, ElementDefinition a, boolean inSlice) {
        boolean doInner = true;
        if (!inSlice && a.getMin() > c.getMin()) {
            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", "min", a.getMin(), c.getMin(), c.getId()), ValidationMessage.IssueSeverity.ERROR));
        }
        if (a.getMaxAsInt() < c.getMaxAsInt()) {
            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", "max", a.getMax(), c.getMax(), c.getId()), ValidationMessage.IssueSeverity.ERROR));
        }
        if (a.hasFixed()) {
            if (!c.hasFixed()) {
                messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", "fixed", a.getFixed(), null, c.getId()), ValidationMessage.IssueSeverity.ERROR));
            } else if (!this.compliesWith(a.getFixed(), c.getFixed())) {
                messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", "fixed", a.getFixed(), c.getFixed(), c.getId()), ValidationMessage.IssueSeverity.ERROR));
            }
        } else if (a.hasPattern()) {
            if (!c.hasFixed() && !c.hasPattern()) {
                messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", "pattern", a.getFixed(), null, c.getId()), ValidationMessage.IssueSeverity.ERROR));
            } else if (c.hasFixed()) {
                if (!this.compliesWith(a.getFixed(), c.getFixed())) {
                    messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", "pattern", a.getFixed(), c.getFixed(), c.getId()), ValidationMessage.IssueSeverity.ERROR));
                }
            } else if (!this.compliesWith(a.getPattern(), c.getPattern())) {
                messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", "pattern", a.getFixed(), c.getPattern(), c.getId()), ValidationMessage.IssueSeverity.ERROR));
            }
        }
        if (!"Resource.id".equals(c.getBase().getPath())) {
            for (ElementDefinition.TypeRefComponent tr : c.getType()) {
                if (!this.hasType(tr, a.getType())) {
                    messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_BAD_TYPE", tr.getWorkingCode()), ValidationMessage.IssueSeverity.ERROR));
                }
                doInner = false;
            }
        }
        if (a.hasMinValue() && this.notGreaterThan(a.getMinValue(), c.getMinValue())) {
            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", "minValue", a.getMinValue(), c.getMinValue(), c.getId()), ValidationMessage.IssueSeverity.ERROR));
        }
        if (a.hasMaxValue() && this.notLessThan(a.getMaxValue(), c.getMaxValue())) {
            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", "maxValue", a.getMaxValue(), c.getMaxValue(), c.getId()), ValidationMessage.IssueSeverity.ERROR));
        }
        if (a.hasMaxLength() && a.getMaxLength() < c.getMaxLength()) {
            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", "maxLength", a.getMaxValue(), c.getMaxValue(), c.getId()), ValidationMessage.IssueSeverity.ERROR));
        }
        if (a.hasMustHaveValue() && a.getMustHaveValue() && !c.getMustHaveValue()) {
            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", "mustHaveValue", a.getMustHaveValue(), c.getMustHaveValue(), c.getId()), ValidationMessage.IssueSeverity.ERROR));
        }
        if (a.hasValueAlternatives()) {
            for (CanonicalType ct : c.getValueAlternatives()) {
                if (this.hasCanonical(ct, a.getValueAlternatives())) continue;
                messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_BAD_ELEMENT", "valueAlternatives", ct.toString()), ValidationMessage.IssueSeverity.ERROR));
            }
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent cc : a.getConstraint()) {
            if (cc.getSeverity() != ElementDefinition.ConstraintSeverity.ERROR || this.hasConstraint(cc, c.getConstraint())) continue;
            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_MISSING_ELEMENT", "constraint", cc.getExpression()), ValidationMessage.IssueSeverity.ERROR));
        }
        if (a.hasBinding() && a.getBinding().hasValueSet() && (a.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED || a.getBinding().getStrength() == Enumerations.BindingStrength.EXTENSIBLE)) {
            if (!c.hasBinding()) {
                if (this.isBindableType(c)) {
                    messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", "binding", a.getBinding().getValueSet(), "null", c.getId()), ValidationMessage.IssueSeverity.ERROR));
                }
            } else if (c.getBinding().getStrength() != Enumerations.BindingStrength.REQUIRED && c.getBinding().getStrength() != Enumerations.BindingStrength.EXTENSIBLE) {
                messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", new Object[]{"binding.strength", a.getBinding().getStrength(), c.getBinding().getStrength(), c.getId()}), ValidationMessage.IssueSeverity.ERROR));
            } else if (c.getBinding().getStrength() == Enumerations.BindingStrength.EXTENSIBLE && a.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED) {
                messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NOT_VALID", new Object[]{"binding.strength", a.getBinding().getStrength(), c.getBinding().getStrength(), c.getId()}), ValidationMessage.IssueSeverity.ERROR));
            } else if (!c.getBinding().getValueSet().equals(a.getBinding().getValueSet())) {
                ValueSet cVS = this.context.fetchResource(ValueSet.class, c.getBinding().getValueSet());
                ValueSet aVS = this.context.fetchResource(ValueSet.class, a.getBinding().getValueSet());
                if (aVS == null || cVS == null) {
                    if (aVS == null) {
                        messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NO_VS", a.getBinding().getValueSet()), ValidationMessage.IssueSeverity.WARNING));
                    } else {
                        messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NO_VS", c.getBinding().getValueSet()), ValidationMessage.IssueSeverity.WARNING));
                    }
                } else {
                    ValueSetExpansionOutcome cExp = this.context.expandVS(cVS, true, false);
                    ValueSetExpansionOutcome aExp = this.context.expandVS(aVS, true, false);
                    if (!cExp.isOk() || !aExp.isOk()) {
                        if (!aExp.isOk()) {
                            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NO_VS_EXP", aVS.getVersionedUrl(), aExp.getError()), ValidationMessage.IssueSeverity.WARNING));
                        } else {
                            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NO_VS_EXP", cVS.getVersionedUrl(), cExp.getError()), ValidationMessage.IssueSeverity.WARNING));
                        }
                    } else {
                        Set<String> wrong = ValueSetUtilities.checkExpansionSubset(aExp.getValueset(), cExp.getValueset());
                        if (!wrong.isEmpty()) {
                            messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, path, this.context.formatMessage("PROFILE_COMPLIES_WITH_NO_VS_NO", cVS.getVersionedUrl(), aVS.getVersionedUrl(), CommaSeparatedStringBuilder.joinToLimit((String)", ", (int)5, (String)"etc", wrong)), c.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED ? ValidationMessage.IssueSeverity.ERROR : ValidationMessage.IssueSeverity.WARNING));
                        }
                    }
                }
            }
        }
        return doInner;
    }

    private boolean isBindableType(ElementDefinition c) {
        for (ElementDefinition.TypeRefComponent t : c.getType()) {
            if (!this.isBindableType(t.getWorkingCode())) continue;
            return true;
        }
        return false;
    }

    private boolean isBindableType(String type) {
        if (Utilities.existsInList((String)type, (String[])new String[]{"CodeableConcept", "Coding", "code", "CodeableReference", "string", "uri", "Quantity"})) {
            return true;
        }
        StructureDefinition sd = this.context.fetchTypeDefinition(type);
        if (sd == null) {
            return false;
        }
        for (Extension ex : sd.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics")) {
            if (!"can-bind".equals(ex.getValue().primitiveValue())) continue;
            return true;
        }
        return false;
    }

    private boolean typesIdentical(ElementDefinition c, ElementDefinition a) {
        if (c.getType().size() != a.getType().size()) {
            return false;
        }
        for (ElementDefinition.TypeRefComponent ct : c.getType()) {
            ElementDefinition.TypeRefComponent at = this.getType(a.getType(), ct.getCode());
            if (at != null && at.equalsDeep(ct)) continue;
            return false;
        }
        return true;
    }

    private ElementDefinition.TypeRefComponent getType(List<ElementDefinition.TypeRefComponent> types, String code) {
        for (ElementDefinition.TypeRefComponent t : types) {
            if (!code.equals(t.getCode())) continue;
            return t;
        }
        return null;
    }

    private boolean hasConstraint(ElementDefinition.ElementDefinitionConstraintComponent cc, List<ElementDefinition.ElementDefinitionConstraintComponent> list) {
        for (ElementDefinition.ElementDefinitionConstraintComponent t : list) {
            if (t.getSeverity() != ElementDefinition.ConstraintSeverity.ERROR || !t.getExpression().equals(cc.getExpression())) continue;
            return true;
        }
        return false;
    }

    private boolean hasCanonical(CanonicalType ct, List<CanonicalType> list) {
        for (CanonicalType t : list) {
            if (!t.hasValue() || !((String)t.getValue()).equals(ct.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean notLessThan(DataType v1, DataType v2) {
        if (v2 == null) {
            return true;
        }
        if (!v1.fhirType().equals(v2.fhirType())) {
            return true;
        }
        switch (v1.fhirType()) {
            case "date": 
            case "dateTime": 
            case "instant": {
                return !((DateTimeType)v1).before((DateTimeType)v2);
            }
            case "time": {
                return v1.primitiveValue().compareTo(v2.primitiveValue()) >= 0;
            }
            case "decimal": {
                return ((DecimalType)v1).compareTo((DecimalType)v2) >= 0;
            }
            case "integer": 
            case "integer64": 
            case "positiveInt": 
            case "unsignedInt": {
                int i1 = Integer.parseInt(v1.toString());
                int i2 = Integer.parseInt(v2.toString());
                return i1 >= i2;
            }
            case "Quantity": {
                Quantity q1 = (Quantity)v1;
                Quantity quantity = (Quantity)v2;
            }
        }
        return true;
    }

    private boolean notGreaterThan(DataType minValue, DataType minValue2) {
        return false;
    }

    private boolean hasType(ElementDefinition.TypeRefComponent tr, List<ElementDefinition.TypeRefComponent> types) {
        for (ElementDefinition.TypeRefComponent t : types) {
            boolean ok;
            if (!t.getWorkingCode().equals(tr.getWorkingCode()) || !(ok = t.getVersioning() == tr.getVersioning())) continue;
            return true;
        }
        return false;
    }

    private boolean compliesWith(DataType authority, DataType test) {
        if (!authority.fhirType().equals(test.fhirType())) {
            return false;
        }
        if (authority.isPrimitive() && !authority.primitiveValue().equals(test.primitiveValue())) {
            return false;
        }
        for (Property p : authority.children()) {
            if (!p.hasValues()) continue;
            Property pt = test.getNamedProperty(p.getName());
            if (p.getValues().size() > pt.getValues().size()) {
                return false;
            }
            for (int i = 0; i < pt.getValues().size(); ++i) {
                DataType vt;
                DataType v = (DataType)p.getValues().get(i);
                if (this.compliesWith(v, vt = (DataType)pt.getValues().get(i))) continue;
                return false;
            }
        }
        return true;
    }
}

