/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.NaturalOrderComparator;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;

@MarkedToMoveToAdjunctPackage
public class CanonicalResourceManager<T extends CanonicalResource> {
    private final String[] INVALID_TERMINOLOGY_URLS = new String[]{"http://snomed.info/sct", "http://dicom.nema.org/resources/ontology/DCM", "http://nucc.org/provider-taxonomy"};
    private int loadCount = 0;
    private boolean minimalMemory;
    private boolean enforceUniqueId;
    private List<CachedCanonicalResource<T>> list = new ArrayList<CachedCanonicalResource<T>>();
    private Map<String, List<CachedCanonicalResource<T>>> listForId;
    private Map<String, List<CachedCanonicalResource<T>>> listForUrl;
    private Map<String, CachedCanonicalResource<T>> map;
    private Map<String, List<CachedCanonicalResource<T>>> supplements;
    private String version;

    public CanonicalResourceManager(boolean enforceUniqueId, boolean minimalMemory) {
        this.enforceUniqueId = enforceUniqueId;
        this.minimalMemory = minimalMemory;
        this.list = new ArrayList<CachedCanonicalResource<T>>();
        this.listForId = new HashMap<String, List<CachedCanonicalResource<T>>>();
        this.listForUrl = new HashMap<String, List<CachedCanonicalResource<T>>>();
        this.map = new HashMap<String, CachedCanonicalResource<T>>();
        this.supplements = new HashMap<String, List<CachedCanonicalResource<T>>>();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void copy(CanonicalResourceManager<T> source) {
        this.list.clear();
        this.map.clear();
        this.list.addAll(source.list);
        this.map.putAll(source.map);
    }

    public void register(CanonicalResourceProxy r, PackageInformation packgeInfo) {
        if (!r.hasId()) {
            throw new FHIRException("An id is required for a deferred load resource");
        }
        CachedCanonicalResource cr = new CachedCanonicalResource(this, r, packgeInfo);
        this.see(cr);
    }

    public void see(T r, PackageInformation packgeInfo) {
        if (r != null) {
            if (!((Resource)r).hasId()) {
                ((Resource)r).setId(UUID.randomUUID().toString());
            }
            CachedCanonicalResource cr = new CachedCanonicalResource(this, r, packgeInfo);
            this.see(cr);
        }
    }

    public void see(CachedCanonicalResource<T> cr) {
        String mm;
        String mmp;
        int n;
        List<CachedCanonicalResource<T>> set;
        if (cr.getPackageInfo() != null && cr.getPackageInfo().getId() != null && cr.getPackageInfo().getId().startsWith("hl7.terminology") && Arrays.stream(this.INVALID_TERMINOLOGY_URLS).anyMatch(it -> it.equals(cr.getUrl()))) {
            return;
        }
        if (this.map.get(cr.getUrl()) != null && cr.getPackageInfo() != null && cr.getPackageInfo().isExamplesPackage()) {
            return;
        }
        if (cr.resource != null && cr.getPackageInfo() != null) {
            ((Resource)cr.resource).setSourcePackage(cr.getPackageInfo());
        }
        if (this.enforceUniqueId && this.map.containsKey(cr.getId())) {
            this.drop(cr.getId());
        }
        if (cr.getPackageInfo() != null && cr.getPackageInfo().getId().startsWith("hl7.terminology")) {
            ArrayList<CachedCanonicalResource<T>> toDrop = new ArrayList<CachedCanonicalResource<T>>();
            for (CachedCanonicalResource<T> cachedCanonicalResource : this.list) {
                if (cachedCanonicalResource.getUrl() == null || !cachedCanonicalResource.getUrl().equals(cr.getUrl()) || !this.isBasePackage(cachedCanonicalResource.getPackageInfo())) continue;
                toDrop.add(cachedCanonicalResource);
            }
            for (CachedCanonicalResource<Object> cachedCanonicalResource : toDrop) {
                this.drop(cachedCanonicalResource);
            }
        }
        if (!this.enforceUniqueId) {
            if (!this.listForId.containsKey(cr.getId())) {
                this.listForId.put(cr.getId(), new ArrayList());
            }
            set = this.listForId.get(cr.getId());
            set.add(cr);
        }
        this.list.add(cr);
        if (!this.listForUrl.containsKey(cr.getUrl())) {
            this.listForUrl.put(cr.getUrl(), new ArrayList());
        }
        this.addToSupplements(cr);
        set = this.listForUrl.get(cr.getUrl());
        set.add(cr);
        if (set.size() > 1) {
            Collections.sort(set, new MetadataResourceVersionComparator());
        }
        String pv = cr.getPackageInfo() != null ? cr.getPackageInfo().getVID() : null;
        this.addToMap(cr.getId(), cr);
        this.addToMap(cr.hasVersion() ? cr.getUrl() + "|" + cr.getVersion() : cr.getUrl() + "|#0", cr);
        if (pv != null) {
            this.addToMap(pv + ":" + (cr.hasVersion() ? cr.getUrl() + "|" + cr.getVersion() : cr.getUrl() + "|#0"), cr);
        }
        if ((n = set.indexOf(cr)) == set.size() - 1) {
            this.addToMap(cr.getUrl(), cr);
            if (pv != null) {
                this.addToMap(pv + ":" + cr.getUrl(), cr);
            }
        }
        if ((mmp = VersionUtilities.getMajMinPatch((String)cr.getVersion())) != null && !mmp.equals(cr.getVersion())) {
            if (pv != null) {
                this.addToMap(pv + ":" + cr.getUrl() + "|" + mmp, cr);
            }
            if (set.size() - 1 == n) {
                this.addToMap(cr.getUrl() + "|" + mmp, cr);
            } else {
                for (int i = set.size() - 1; i > n; --i) {
                    if (mmp.equals(VersionUtilities.getMajMinPatch((String)set.get(i).getVersion()))) {
                        return;
                    }
                    this.addToMap(cr.getUrl() + "|" + mmp, cr);
                }
            }
        }
        if ((mm = VersionUtilities.getMajMin((String)cr.getVersion())) != null) {
            if (pv != null) {
                this.addToMap(pv + ":" + cr.getUrl() + "|" + mm, cr);
            }
            if (set.size() - 1 == n) {
                this.addToMap(cr.getUrl() + "|" + mm, cr);
            } else {
                for (int i = set.size() - 1; i > n; --i) {
                    if (mm.equals(VersionUtilities.getMajMin((String)set.get(i).getVersion()))) {
                        return;
                    }
                    this.addToMap(cr.getUrl() + "|" + mm, cr);
                }
            }
        }
        cr.setLoadingOrder(++this.loadCount);
    }

    private int compareResources(CachedCanonicalResource<T> c1, CachedCanonicalResource<T> c2) {
        int res = this.compareByResourceVersion(c1.getVersion(), c2.getVersion());
        if (res == 0) {
            res = this.compareByResourceContent(c1.getContent(), c2.getContent());
        }
        if (res == 0) {
            res = this.compareByPackageVersion(c1.getPackageInfo(), c2.getPackageInfo());
        }
        if (res == 0) {
            res = this.compareByLoadCount(c1.getLoadingOrder(), c2.getLoadingOrder());
        }
        return res;
    }

    private int compareByLoadCount(int o1, int o2) {
        if (o1 == 0) {
            return 1;
        }
        if (o2 == 0) {
            return -1;
        }
        return Integer.compare(o1, o2);
    }

    private int compareByResourceVersion(String v1, String v2) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (VersionUtilities.isSemVer((String)v1) && VersionUtilities.isSemVer((String)v2)) {
            return VersionUtilities.compareVersions((String)v1, (String)v2);
        }
        if (Utilities.isInteger((String)v1) && Utilities.isInteger((String)v2)) {
            return Integer.compare(Integer.parseInt(v1), Integer.parseInt(v2));
        }
        return new NaturalOrderComparator().compare(v1, v2);
    }

    private int compareByLoadCount(String v1, String v2) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        if (VersionUtilities.isSemVer((String)v1) && VersionUtilities.isSemVer((String)v2)) {
            return VersionUtilities.compareVersions((String)v1, (String)v2);
        }
        if (Utilities.isInteger((String)v1) && Utilities.isInteger((String)v2)) {
            return Integer.compare(Integer.parseInt(v1), Integer.parseInt(v2));
        }
        return new NaturalOrderComparator().compare(v1, v2);
    }

    private int compareByPackageVersion(PackageInformation p1, PackageInformation p2) {
        if (p1 == null && p2 == null) {
            return 0;
        }
        if (p1 == null) {
            return 1;
        }
        if (p2 == null) {
            return -1;
        }
        if (p1.getId().equals(p2.getId())) {
            int res = this.compareByResourceVersion(p1.getVersion(), p2.getVersion());
            if (res == 0) {
                res = this.compareByDate(p1.getDate(), p2.getDate());
            }
            return res;
        }
        return this.compareByDate(p1.getDate(), p2.getDate());
    }

    private int compareByDate(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return 0;
        }
        if (d1 == null) {
            return 1;
        }
        if (d2 == null) {
            return -1;
        }
        return d1.compareTo(d2);
    }

    private int compareByResourceContent(String c1, String c2) {
        if (c1 == null && c2 == null) {
            return 0;
        }
        if (c1 == null) {
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        if (c1.equals(c2)) {
            return 0;
        }
        int i1 = this.orderOfContent(c1);
        int i2 = this.orderOfContent(c2);
        return Integer.compare(i1, i2);
    }

    private int orderOfContent(String c) {
        switch (c) {
            case "not-present": {
                return 1;
            }
            case "example": {
                return 2;
            }
            case "fragment": {
                return 3;
            }
            case "complete": {
                return 5;
            }
            case "supplement": {
                return 4;
            }
        }
        return 0;
    }

    private void addToMap(String key, CachedCanonicalResource<T> cr) {
        boolean newIsOlder = false;
        CachedCanonicalResource<T> existing = this.map.get(key);
        if (existing != null) {
            int comp = this.compareResources(existing, cr);
            boolean bl = newIsOlder = comp == 1;
        }
        if (!newIsOlder) {
            this.map.put(key, cr);
        }
    }

    private void addToSupplements(CachedCanonicalResource<T> cr) {
        String surl = cr.supplements();
        if (surl != null) {
            List<CachedCanonicalResource<T>> list = this.supplements.get(surl);
            if (list == null) {
                list = new ArrayList<CachedCanonicalResource<T>>();
                this.supplements.put(surl, list);
            }
            list.add(cr);
        }
    }

    public void drop(CachedCanonicalResource<T> cr) {
        while (this.map.values().remove(cr)) {
        }
        while (this.listForId.values().remove(cr)) {
        }
        while (this.listForUrl.values().remove(cr)) {
        }
        String surl = cr.supplements();
        if (surl != null) {
            this.supplements.get(surl).remove(cr);
        }
        this.list.remove(cr);
        List<CachedCanonicalResource<T>> set = this.listForUrl.get(cr.getUrl());
        if (set != null) {
            boolean last = set.indexOf(cr) == set.size() - 1;
            set.remove(cr);
            if (!set.isEmpty()) {
                String mm;
                CachedCanonicalResource<T> crl = set.get(set.size() - 1);
                if (last) {
                    this.map.put(crl.getUrl(), crl);
                }
                if ((mm = VersionUtilities.getMajMin((String)cr.getVersion())) != null) {
                    for (int i = set.size() - 1; i >= 0; --i) {
                        if (!mm.equals(VersionUtilities.getMajMin((String)set.get(i).getVersion()))) continue;
                        this.map.put(cr.getUrl() + "|" + mm, set.get(i));
                        break;
                    }
                }
            }
        }
    }

    public void drop(String id) {
        if (this.enforceUniqueId) {
            CachedCanonicalResource<T> cr = this.map.get(id);
            if (cr != null) {
                this.drop(cr);
            }
        } else {
            List<CachedCanonicalResource<T>> set = this.listForId.get(id);
            if (set != null) {
                for (CachedCanonicalResource<T> i : set) {
                    this.drop(i);
                }
            }
        }
    }

    private boolean isBasePackage(PackageInformation packageInfo) {
        return packageInfo == null ? false : VersionUtilities.isCorePackage((String)packageInfo.getId());
    }

    private void updateList(String url, String version) {
        ArrayList<CachedCanonicalResource<T>> rl = new ArrayList<CachedCanonicalResource<T>>();
        for (CachedCanonicalResource<T> t : this.list) {
            if (!url.equals(t.getUrl()) || rl.contains(t)) continue;
            rl.add(t);
        }
        if (rl.size() > 0) {
            this.map.put(url, (CachedCanonicalResource)rl.get(rl.size() - 1));
            if (version != null) {
                String lv;
                CachedCanonicalResource latest = null;
                for (CachedCanonicalResource cachedCanonicalResource : rl) {
                    if (!VersionUtilities.versionMatches((String)cachedCanonicalResource.getVersion(), (String)version)) continue;
                    latest = cachedCanonicalResource;
                }
                if (latest != null && (lv = VersionUtilities.getMajMin((String)latest.getVersion())) != null && !lv.equals(version)) {
                    this.map.put(url + "|" + lv, (CachedCanonicalResource)rl.get(rl.size() - 1));
                }
            }
        }
    }

    public boolean has(String url) {
        return this.map.containsKey(url);
    }

    public boolean has(String system, String version) {
        if (this.map.containsKey(system + "|" + version)) {
            return true;
        }
        String mm = VersionUtilities.getMajMin((String)version);
        if (mm != null) {
            return this.map.containsKey(system + "|" + mm);
        }
        return false;
    }

    public T get(String url) {
        return this.map.containsKey(url) ? (T)this.map.get(url).getResource() : null;
    }

    public T get(String system, String version) {
        String mm;
        if (version == null) {
            return this.get(system);
        }
        if (this.map.containsKey(system + "|" + version)) {
            return this.map.get(system + "|" + version).getResource();
        }
        if (VersionUtilities.isSemVer((String)version) && !Utilities.containsInList((String)version, (String[])new String[]{"+", "-"}) && (mm = VersionUtilities.getMajMin((String)version)) != null && this.map.containsKey(system + "|" + mm)) {
            return this.map.get(system + "|" + mm).getResource();
        }
        return null;
    }

    public List<T> getForUrl(String url) {
        ArrayList<T> res = new ArrayList<T>();
        List<CachedCanonicalResource<T>> list = this.listForUrl.get(url);
        if (list != null) {
            for (CachedCanonicalResource<T> t : list) {
                res.add(t.getResource());
            }
        }
        return res;
    }

    public T getByPackage(String url, List<String> pvlist) {
        for (String pv : pvlist) {
            if (!this.map.containsKey(pv + ":" + url)) continue;
            return this.map.get(pv + ":" + url).getResource();
        }
        return this.map.containsKey(url) ? (T)this.map.get(url).getResource() : null;
    }

    public T getByPackage(String system, String version, List<String> pvlist) {
        if (version == null) {
            return this.getByPackage(system, pvlist);
        }
        for (String pv : pvlist) {
            if (!this.map.containsKey(pv + ":" + system + "|" + version)) continue;
            return this.map.get(pv + ":" + system + "|" + version).getResource();
        }
        String mm = VersionUtilities.getMajMin((String)version);
        if (mm != null && this.map.containsKey(system + "|" + mm)) {
            for (String pv : pvlist) {
                if (!this.map.containsKey(pv + ":" + system + "|" + mm)) continue;
                return this.map.get(pv + ":" + system + "|" + mm).getResource();
            }
        }
        if (this.map.containsKey(system + "|" + version)) {
            return this.map.get(system + "|" + version).getResource();
        }
        if (mm != null && this.map.containsKey(system + "|" + mm)) {
            return this.map.get(system + "|" + mm).getResource();
        }
        return null;
    }

    public PackageInformation getPackageInfo(String system, String version) {
        if (version == null) {
            return this.map.containsKey(system) ? this.map.get(system).getPackageInfo() : null;
        }
        if (this.map.containsKey(system + "|" + version)) {
            return this.map.get(system + "|" + version).getPackageInfo();
        }
        String mm = VersionUtilities.getMajMin((String)version);
        if (mm != null && this.map.containsKey(system + "|" + mm)) {
            return this.map.get(system + "|" + mm).getPackageInfo();
        }
        return null;
    }

    public int size() {
        return this.list.size();
    }

    public void listAll(List<T> result) {
        for (CachedCanonicalResource<T> t : this.list) {
            result.add(t.getResource());
        }
    }

    public void listAllM(List<CanonicalResource> result) {
        for (CachedCanonicalResource<T> t : this.list) {
            result.add((CanonicalResource)t.getResource());
        }
    }

    public List<T> getSupplements(T cr) {
        if (cr == null) {
            return new ArrayList();
        }
        if (((Resource)cr).hasSourcePackage()) {
            ArrayList<String> pvl = new ArrayList<String>();
            pvl.add(((Resource)cr).getSourcePackage().getVID());
            return this.getSupplements(((CanonicalResource)cr).getUrl(), ((CanonicalResource)cr).getVersion(), pvl);
        }
        return this.getSupplements(((CanonicalResource)cr).getUrl(), ((CanonicalResource)cr).getVersion(), null);
    }

    public List<T> getSupplements(String url) {
        return this.getSupplements(url, null, null);
    }

    public List<T> getSupplements(String url, String version) {
        return this.getSupplements(url, version, null);
    }

    public List<T> getSupplements(String url, String version, List<String> pvlist) {
        List<CachedCanonicalResource<T>> list;
        boolean possibleMatches = false;
        ArrayList<T> res = new ArrayList<T>();
        if (version != null && (list = this.supplements.get(url + "|" + version)) != null) {
            for (CachedCanonicalResource<T> t : list) {
                possibleMatches = true;
                if (pvlist != null && !pvlist.contains(t.getPackageInfo().getVID())) continue;
                res.add(t.getResource());
            }
        }
        if ((list = this.supplements.get(url)) != null) {
            for (CachedCanonicalResource<T> t : list) {
                possibleMatches = true;
                if (pvlist != null && t.getPackageInfo() != null && !pvlist.contains(t.getPackageInfo().getVID())) continue;
                res.add(t.getResource());
            }
        }
        if (res.isEmpty() && pvlist != null && possibleMatches) {
            return this.getSupplements(url, version, null);
        }
        return res;
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public List<CachedCanonicalResource<T>> getCachedList() {
        return this.list;
    }

    public List<T> getList() {
        ArrayList<T> res = new ArrayList<T>();
        for (CachedCanonicalResource<T> t : this.list) {
            if (res.contains(t.getResource())) continue;
            res.add(t.getResource());
        }
        return res;
    }

    public List<T> getVersionList(String url) {
        ArrayList<T> res = new ArrayList<T>();
        for (CachedCanonicalResource<T> t : this.list) {
            if (!url.equals(t.getUrl()) || res.contains(t.getResource())) continue;
            res.add(t.getResource());
        }
        return res;
    }

    public List<T> getSortedList() {
        List<T> res = this.getList();
        Collections.sort(res, new CanonicalListSorter());
        return res;
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public boolean isEnforceUniqueId() {
        return this.enforceUniqueId;
    }

    public void unload() {
        for (CachedCanonicalResource<T> t : this.list) {
            t.unload();
        }
    }

    public static abstract class CanonicalResourceProxy {
        private String type;
        private String id;
        private String url;
        private String version;
        private String supplements;
        private String derivation;
        private CanonicalResource resource;
        private boolean hacked;
        private String content;

        public CanonicalResourceProxy(String type, String id, String url, String version, String supplements, String derivation, String content) {
            this.type = type;
            this.id = id;
            this.url = url;
            this.version = version;
            this.supplements = supplements;
            this.content = content;
            this.derivation = derivation;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean hasId() {
            return this.id != null;
        }

        public boolean hasUrl() {
            return this.url != null;
        }

        public boolean hasVersion() {
            return this.version != null;
        }

        public String getSupplements() {
            return this.supplements;
        }

        public String getContent() {
            return this.content;
        }

        public String getDerivation() {
            return this.derivation;
        }

        public void setDerivation(String derivation) {
            this.derivation = derivation;
        }

        public CanonicalResource getResource() throws FHIRException {
            if (this.resource == null) {
                this.resource = this.loadResource();
                if (this.hacked) {
                    this.resource.setUrl(this.url).setVersion(this.version);
                }
                if (this.resource instanceof CodeSystem) {
                    CodeSystemUtilities.crossLinkCodeSystem((CodeSystem)this.resource);
                }
            }
            return this.resource;
        }

        public void setResource(CanonicalResource resource) {
            this.resource = resource;
        }

        public abstract CanonicalResource loadResource() throws FHIRException;

        public String toString() {
            return this.type + "/" + this.id + ": " + this.url + "|" + this.version;
        }

        public void hack(String url, String version) {
            this.url = url;
            this.version = version;
            this.hacked = true;
        }

        public void updateInfo() {
            this.type = this.resource.fhirType();
            this.id = this.resource.getId();
            this.url = this.resource.getUrl();
            this.version = this.resource.getVersion();
            if (this.resource instanceof CodeSystem) {
                this.supplements = ((CodeSystem)this.resource).getSupplements();
                this.content = ((CodeSystem)this.resource).getContentElement().asStringValue();
            }
            if (this.resource instanceof StructureDefinition) {
                this.derivation = ((StructureDefinition)this.resource).getDerivationElement().asStringValue();
            }
        }
    }

    public static class CachedCanonicalResource<T1 extends CanonicalResource> {
        int loadingOrder = 0;
        private T1 resource;
        private CanonicalResourceProxy proxy;
        private PackageInformation packageInfo;
        final /* synthetic */ CanonicalResourceManager this$0;

        public CachedCanonicalResource(T1 resource, PackageInformation packageInfo) {
            this.this$0 = this$0;
            if (resource == null) {
                throw new NullPointerException("Canonical resource cannot be null");
            }
            this.resource = resource;
            this.packageInfo = packageInfo;
        }

        public CachedCanonicalResource(CanonicalResourceManager this$0, CanonicalResourceProxy proxy, PackageInformation packageInfo) {
            this.this$0 = this$0;
            if (proxy == null) {
                throw new NullPointerException("Canonical resource proxy cannot be null");
            }
            this.proxy = proxy;
            this.packageInfo = packageInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T1 getResource() {
            if (this.resource == null) {
                CanonicalResource res = this.proxy.getResource();
                if (res == null) {
                    throw new Error("Proxy loading a resource from " + String.valueOf(this.packageInfo) + " failed and returned null");
                }
                CachedCanonicalResource cachedCanonicalResource = this;
                synchronized (cachedCanonicalResource) {
                    this.resource = res;
                }
                ((Resource)this.resource).setSourcePackage(this.packageInfo);
                this.proxy = null;
            }
            return this.resource;
        }

        public PackageInformation getPackageInfo() {
            return this.packageInfo;
        }

        public String getUrl() {
            return this.resource != null ? ((CanonicalResource)this.resource).getUrl() : this.proxy.getUrl();
        }

        public String getId() {
            return this.resource != null ? ((Resource)this.resource).getId() : this.proxy.getId();
        }

        public String getVersion() {
            return this.resource != null ? ((CanonicalResource)this.resource).getVersion() : this.proxy.getVersion();
        }

        public boolean hasVersion() {
            return this.resource != null ? ((CanonicalResource)this.resource).hasVersion() : this.proxy.getVersion() != null;
        }

        public String getContent() {
            if (this.resource instanceof CodeSystem) {
                Enumerations.CodeSystemContentMode cnt = ((CodeSystem)this.resource).getContent();
                return cnt == null ? null : cnt.toCode();
            }
            if (this.proxy != null) {
                return this.proxy.getContent();
            }
            return null;
        }

        public String toString() {
            return this.resource != null ? ((CanonicalResource)this.resource).fhirType() + "/" + ((Resource)this.resource).getId() + "[" + ((CanonicalResource)this.resource).getUrl() + "|" + ((CanonicalResource)this.resource).getVersion() + "]" : this.proxy.toString();
        }

        public String supplements() {
            if (this.resource == null) {
                return this.proxy.getSupplements();
            }
            return this.resource instanceof CodeSystem ? ((CodeSystem)this.resource).getSupplements() : null;
        }

        public Object getDerivation() {
            if (this.resource == null) {
                return this.proxy.getDerivation();
            }
            return this.resource instanceof StructureDefinition ? ((StructureDefinition)this.resource).getDerivationElement().primitiveValue() : null;
        }

        public void unload() {
            if (this.proxy != null) {
                this.resource = null;
            }
        }

        public int getLoadingOrder() {
            return this.loadingOrder;
        }

        public void setLoadingOrder(int loadingOrder) {
            this.loadingOrder = loadingOrder;
        }
    }

    public class MetadataResourceVersionComparator<T1 extends CachedCanonicalResource<T>>
    implements Comparator<T1> {
        @Override
        public int compare(T1 arg1, T1 arg2) {
            return CanonicalResourceManager.this.compareResources(arg1, arg2);
        }
    }

    public static class CanonicalListSorter
    implements Comparator<CanonicalResource> {
        @Override
        public int compare(CanonicalResource arg0, CanonicalResource arg1) {
            String u0 = arg0.getUrl();
            String u1 = arg1.getUrl();
            return u0.compareTo(u1);
        }
    }
}

